<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/generative_settings.proto

namespace Google\Cloud\Dialogflow\Cx\V3\GenerativeSettings;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Settings for knowledge connector. These parameters are used for LLM prompt
 * like "You are <agent>. You are a helpful and verbose <agent_identity> at
 * <business>, <business_description>. Your task is to help humans on
 * <agent_scope>".
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.GenerativeSettings.KnowledgeConnectorSettings</code>
 */
class KnowledgeConnectorSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * Name of the company, organization or other entity that the agent
     * represents. Used for knowledge connector LLM prompt and for knowledge
     * search.
     *
     * Generated from protobuf field <code>string business = 1;</code>
     */
    protected $business = '';
    /**
     * Name of the virtual agent. Used for LLM prompt. Can be left empty.
     *
     * Generated from protobuf field <code>string agent = 2;</code>
     */
    protected $agent = '';
    /**
     * Identity of the agent, e.g. "virtual agent", "AI assistant".
     *
     * Generated from protobuf field <code>string agent_identity = 3;</code>
     */
    protected $agent_identity = '';
    /**
     * Company description, used for LLM prompt, e.g. "a family company selling
     * freshly roasted coffee beans".
     *
     * Generated from protobuf field <code>string business_description = 4;</code>
     */
    protected $business_description = '';
    /**
     * Agent scope, e.g. "Example company website", "internal Example
     * company website for employees", "manual of car owner".
     *
     * Generated from protobuf field <code>string agent_scope = 5;</code>
     */
    protected $agent_scope = '';
    /**
     * Whether to disable fallback to Data Store search results (in case the LLM
     * couldn't pick a proper answer). Per default the feature is enabled.
     *
     * Generated from protobuf field <code>bool disable_data_store_fallback = 8;</code>
     */
    protected $disable_data_store_fallback = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $business
     *           Name of the company, organization or other entity that the agent
     *           represents. Used for knowledge connector LLM prompt and for knowledge
     *           search.
     *     @type string $agent
     *           Name of the virtual agent. Used for LLM prompt. Can be left empty.
     *     @type string $agent_identity
     *           Identity of the agent, e.g. "virtual agent", "AI assistant".
     *     @type string $business_description
     *           Company description, used for LLM prompt, e.g. "a family company selling
     *           freshly roasted coffee beans".
     *     @type string $agent_scope
     *           Agent scope, e.g. "Example company website", "internal Example
     *           company website for employees", "manual of car owner".
     *     @type bool $disable_data_store_fallback
     *           Whether to disable fallback to Data Store search results (in case the LLM
     *           couldn't pick a proper answer). Per default the feature is enabled.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\GenerativeSettings::initOnce();
        parent::__construct($data);
    }

    /**
     * Name of the company, organization or other entity that the agent
     * represents. Used for knowledge connector LLM prompt and for knowledge
     * search.
     *
     * Generated from protobuf field <code>string business = 1;</code>
     * @return string
     */
    public function getBusiness()
    {
        return $this->business;
    }

    /**
     * Name of the company, organization or other entity that the agent
     * represents. Used for knowledge connector LLM prompt and for knowledge
     * search.
     *
     * Generated from protobuf field <code>string business = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setBusiness($var)
    {
        GPBUtil::checkString($var, True);
        $this->business = $var;

        return $this;
    }

    /**
     * Name of the virtual agent. Used for LLM prompt. Can be left empty.
     *
     * Generated from protobuf field <code>string agent = 2;</code>
     * @return string
     */
    public function getAgent()
    {
        return $this->agent;
    }

    /**
     * Name of the virtual agent. Used for LLM prompt. Can be left empty.
     *
     * Generated from protobuf field <code>string agent = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setAgent($var)
    {
        GPBUtil::checkString($var, True);
        $this->agent = $var;

        return $this;
    }

    /**
     * Identity of the agent, e.g. "virtual agent", "AI assistant".
     *
     * Generated from protobuf field <code>string agent_identity = 3;</code>
     * @return string
     */
    public function getAgentIdentity()
    {
        return $this->agent_identity;
    }

    /**
     * Identity of the agent, e.g. "virtual agent", "AI assistant".
     *
     * Generated from protobuf field <code>string agent_identity = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setAgentIdentity($var)
    {
        GPBUtil::checkString($var, True);
        $this->agent_identity = $var;

        return $this;
    }

    /**
     * Company description, used for LLM prompt, e.g. "a family company selling
     * freshly roasted coffee beans".
     *
     * Generated from protobuf field <code>string business_description = 4;</code>
     * @return string
     */
    public function getBusinessDescription()
    {
        return $this->business_description;
    }

    /**
     * Company description, used for LLM prompt, e.g. "a family company selling
     * freshly roasted coffee beans".
     *
     * Generated from protobuf field <code>string business_description = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setBusinessDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->business_description = $var;

        return $this;
    }

    /**
     * Agent scope, e.g. "Example company website", "internal Example
     * company website for employees", "manual of car owner".
     *
     * Generated from protobuf field <code>string agent_scope = 5;</code>
     * @return string
     */
    public function getAgentScope()
    {
        return $this->agent_scope;
    }

    /**
     * Agent scope, e.g. "Example company website", "internal Example
     * company website for employees", "manual of car owner".
     *
     * Generated from protobuf field <code>string agent_scope = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setAgentScope($var)
    {
        GPBUtil::checkString($var, True);
        $this->agent_scope = $var;

        return $this;
    }

    /**
     * Whether to disable fallback to Data Store search results (in case the LLM
     * couldn't pick a proper answer). Per default the feature is enabled.
     *
     * Generated from protobuf field <code>bool disable_data_store_fallback = 8;</code>
     * @return bool
     */
    public function getDisableDataStoreFallback()
    {
        return $this->disable_data_store_fallback;
    }

    /**
     * Whether to disable fallback to Data Store search results (in case the LLM
     * couldn't pick a proper answer). Per default the feature is enabled.
     *
     * Generated from protobuf field <code>bool disable_data_store_fallback = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisableDataStoreFallback($var)
    {
        GPBUtil::checkBool($var);
        $this->disable_data_store_fallback = $var;

        return $this;
    }

}


