<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/developerconnect/v1/insights_config.proto

namespace Google\Cloud\DeveloperConnect\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The InsightsConfig resource is the core configuration object to capture
 * events from your Software Development Lifecycle. It acts as the central hub
 * for managing how Developer connect understands your application, its runtime
 * environments, and the artifacts deployed within them.
 *
 * Generated from protobuf message <code>google.cloud.developerconnect.v1.InsightsConfig</code>
 */
class InsightsConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the InsightsConfig.
     * Format:
     * projects/{project}/locations/{location}/insightsConfigs/{insightsConfig}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. [Output only] Create timestamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. [Output only] Update timestamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. The runtime configurations where the application is deployed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.developerconnect.v1.RuntimeConfig runtime_configs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $runtime_configs;
    /**
     * Optional. The artifact configurations of the artifacts that are deployed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.developerconnect.v1.ArtifactConfig artifact_configs = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $artifact_configs;
    /**
     * Optional. Output only. The state of the InsightsConfig.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.InsightsConfig.State state = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $state = 0;
    /**
     * Optional. User specified annotations. See
     * https://google.aip.dev/148#annotations for more details such as format and
     * size limitations.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $annotations;
    /**
     * Optional. Set of labels associated with an InsightsConfig.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Output only. Reconciling (https://google.aip.dev/128#reconciliation).
     * Set to true if the current state of InsightsConfig does not match the
     * user's intended state, and the service is actively updating the resource to
     * reconcile them. This can happen due to user-triggered updates or
     * system actions like failover or maintenance.
     *
     * Generated from protobuf field <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $reconciling = false;
    /**
     * Output only. Any errors that occurred while setting up the InsightsConfig.
     * Each error will be in the format: `field_name: error_message`, e.g.
     * GetAppHubApplication: Permission denied while getting App Hub
     * application. Please grant permissions to the P4SA.
     *
     * Generated from protobuf field <code>repeated .google.rpc.Status errors = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $errors;
    protected $insights_config_context;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $app_hub_application
     *           Optional. The name of the App Hub Application.
     *           Format:
     *           projects/{project}/locations/{location}/applications/{application}
     *     @type string $name
     *           Identifier. The name of the InsightsConfig.
     *           Format:
     *           projects/{project}/locations/{location}/insightsConfigs/{insightsConfig}
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. [Output only] Create timestamp
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. [Output only] Update timestamp
     *     @type array<\Google\Cloud\DeveloperConnect\V1\RuntimeConfig>|\Google\Protobuf\Internal\RepeatedField $runtime_configs
     *           Output only. The runtime configurations where the application is deployed.
     *     @type array<\Google\Cloud\DeveloperConnect\V1\ArtifactConfig>|\Google\Protobuf\Internal\RepeatedField $artifact_configs
     *           Optional. The artifact configurations of the artifacts that are deployed.
     *     @type int $state
     *           Optional. Output only. The state of the InsightsConfig.
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *           Optional. User specified annotations. See
     *           https://google.aip.dev/148#annotations for more details such as format and
     *           size limitations.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Set of labels associated with an InsightsConfig.
     *     @type bool $reconciling
     *           Output only. Reconciling (https://google.aip.dev/128#reconciliation).
     *           Set to true if the current state of InsightsConfig does not match the
     *           user's intended state, and the service is actively updating the resource to
     *           reconcile them. This can happen due to user-triggered updates or
     *           system actions like failover or maintenance.
     *     @type array<\Google\Rpc\Status>|\Google\Protobuf\Internal\RepeatedField $errors
     *           Output only. Any errors that occurred while setting up the InsightsConfig.
     *           Each error will be in the format: `field_name: error_message`, e.g.
     *           GetAppHubApplication: Permission denied while getting App Hub
     *           application. Please grant permissions to the P4SA.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Developerconnect\V1\InsightsConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The name of the App Hub Application.
     * Format:
     * projects/{project}/locations/{location}/applications/{application}
     *
     * Generated from protobuf field <code>string app_hub_application = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAppHubApplication()
    {
        return $this->readOneof(4);
    }

    public function hasAppHubApplication()
    {
        return $this->hasOneof(4);
    }

    /**
     * Optional. The name of the App Hub Application.
     * Format:
     * projects/{project}/locations/{location}/applications/{application}
     *
     * Generated from protobuf field <code>string app_hub_application = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAppHubApplication($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Identifier. The name of the InsightsConfig.
     * Format:
     * projects/{project}/locations/{location}/insightsConfigs/{insightsConfig}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the InsightsConfig.
     * Format:
     * projects/{project}/locations/{location}/insightsConfigs/{insightsConfig}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. [Output only] Create timestamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. [Output only] Create timestamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. [Output only] Update timestamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. [Output only] Update timestamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The runtime configurations where the application is deployed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.developerconnect.v1.RuntimeConfig runtime_configs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRuntimeConfigs()
    {
        return $this->runtime_configs;
    }

    /**
     * Output only. The runtime configurations where the application is deployed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.developerconnect.v1.RuntimeConfig runtime_configs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\DeveloperConnect\V1\RuntimeConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRuntimeConfigs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DeveloperConnect\V1\RuntimeConfig::class);
        $this->runtime_configs = $arr;

        return $this;
    }

    /**
     * Optional. The artifact configurations of the artifacts that are deployed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.developerconnect.v1.ArtifactConfig artifact_configs = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getArtifactConfigs()
    {
        return $this->artifact_configs;
    }

    /**
     * Optional. The artifact configurations of the artifacts that are deployed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.developerconnect.v1.ArtifactConfig artifact_configs = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\DeveloperConnect\V1\ArtifactConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setArtifactConfigs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DeveloperConnect\V1\ArtifactConfig::class);
        $this->artifact_configs = $arr;

        return $this;
    }

    /**
     * Optional. Output only. The state of the InsightsConfig.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.InsightsConfig.State state = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Optional. Output only. The state of the InsightsConfig.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.InsightsConfig.State state = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DeveloperConnect\V1\InsightsConfig\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Optional. User specified annotations. See
     * https://google.aip.dev/148#annotations for more details such as format and
     * size limitations.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * Optional. User specified annotations. See
     * https://google.aip.dev/148#annotations for more details such as format and
     * size limitations.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * Optional. Set of labels associated with an InsightsConfig.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Set of labels associated with an InsightsConfig.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. Reconciling (https://google.aip.dev/128#reconciliation).
     * Set to true if the current state of InsightsConfig does not match the
     * user's intended state, and the service is actively updating the resource to
     * reconcile them. This can happen due to user-triggered updates or
     * system actions like failover or maintenance.
     *
     * Generated from protobuf field <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getReconciling()
    {
        return $this->reconciling;
    }

    /**
     * Output only. Reconciling (https://google.aip.dev/128#reconciliation).
     * Set to true if the current state of InsightsConfig does not match the
     * user's intended state, and the service is actively updating the resource to
     * reconcile them. This can happen due to user-triggered updates or
     * system actions like failover or maintenance.
     *
     * Generated from protobuf field <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setReconciling($var)
    {
        GPBUtil::checkBool($var);
        $this->reconciling = $var;

        return $this;
    }

    /**
     * Output only. Any errors that occurred while setting up the InsightsConfig.
     * Each error will be in the format: `field_name: error_message`, e.g.
     * GetAppHubApplication: Permission denied while getting App Hub
     * application. Please grant permissions to the P4SA.
     *
     * Generated from protobuf field <code>repeated .google.rpc.Status errors = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * Output only. Any errors that occurred while setting up the InsightsConfig.
     * Each error will be in the format: `field_name: error_message`, e.g.
     * GetAppHubApplication: Permission denied while getting App Hub
     * application. Please grant permissions to the P4SA.
     *
     * Generated from protobuf field <code>repeated .google.rpc.Status errors = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Rpc\Status>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setErrors($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Rpc\Status::class);
        $this->errors = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getInsightsConfigContext()
    {
        return $this->whichOneof("insights_config_context");
    }

}

