<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1\ControlPlaneEndpointsConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes the configuration of a DNS endpoint.
 *
 * Generated from protobuf message <code>google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig</code>
 */
class DNSEndpointConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The cluster's DNS endpoint configuration.
     * A DNS format address. This is accessible from the public internet.
     * Ex: uid.us-central1.gke.goog.
     * Always present, but the behavior may change according to the value of
     * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
     *
     * Generated from protobuf field <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $endpoint = '';
    /**
     * Controls whether user traffic is allowed over this endpoint. Note that
     * Google-managed services may still use the endpoint even if this is false.
     *
     * Generated from protobuf field <code>optional bool allow_external_traffic = 3;</code>
     */
    protected $allow_external_traffic = null;
    /**
     * Controls whether the k8s token auth is allowed via DNS.
     *
     * Generated from protobuf field <code>optional bool enable_k8s_tokens_via_dns = 5;</code>
     */
    protected $enable_k8s_tokens_via_dns = null;
    /**
     * Controls whether the k8s certs auth is allowed via DNS.
     *
     * Generated from protobuf field <code>optional bool enable_k8s_certs_via_dns = 6;</code>
     */
    protected $enable_k8s_certs_via_dns = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $endpoint
     *           Output only. The cluster's DNS endpoint configuration.
     *           A DNS format address. This is accessible from the public internet.
     *           Ex: uid.us-central1.gke.goog.
     *           Always present, but the behavior may change according to the value of
     *           [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
     *     @type bool $allow_external_traffic
     *           Controls whether user traffic is allowed over this endpoint. Note that
     *           Google-managed services may still use the endpoint even if this is false.
     *     @type bool $enable_k8s_tokens_via_dns
     *           Controls whether the k8s token auth is allowed via DNS.
     *     @type bool $enable_k8s_certs_via_dns
     *           Controls whether the k8s certs auth is allowed via DNS.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The cluster's DNS endpoint configuration.
     * A DNS format address. This is accessible from the public internet.
     * Ex: uid.us-central1.gke.goog.
     * Always present, but the behavior may change according to the value of
     * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
     *
     * Generated from protobuf field <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }

    /**
     * Output only. The cluster's DNS endpoint configuration.
     * A DNS format address. This is accessible from the public internet.
     * Ex: uid.us-central1.gke.goog.
     * Always present, but the behavior may change according to the value of
     * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
     *
     * Generated from protobuf field <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEndpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->endpoint = $var;

        return $this;
    }

    /**
     * Controls whether user traffic is allowed over this endpoint. Note that
     * Google-managed services may still use the endpoint even if this is false.
     *
     * Generated from protobuf field <code>optional bool allow_external_traffic = 3;</code>
     * @return bool
     */
    public function getAllowExternalTraffic()
    {
        return isset($this->allow_external_traffic) ? $this->allow_external_traffic : false;
    }

    public function hasAllowExternalTraffic()
    {
        return isset($this->allow_external_traffic);
    }

    public function clearAllowExternalTraffic()
    {
        unset($this->allow_external_traffic);
    }

    /**
     * Controls whether user traffic is allowed over this endpoint. Note that
     * Google-managed services may still use the endpoint even if this is false.
     *
     * Generated from protobuf field <code>optional bool allow_external_traffic = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowExternalTraffic($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_external_traffic = $var;

        return $this;
    }

    /**
     * Controls whether the k8s token auth is allowed via DNS.
     *
     * Generated from protobuf field <code>optional bool enable_k8s_tokens_via_dns = 5;</code>
     * @return bool
     */
    public function getEnableK8STokensViaDns()
    {
        return isset($this->enable_k8s_tokens_via_dns) ? $this->enable_k8s_tokens_via_dns : false;
    }

    public function hasEnableK8STokensViaDns()
    {
        return isset($this->enable_k8s_tokens_via_dns);
    }

    public function clearEnableK8STokensViaDns()
    {
        unset($this->enable_k8s_tokens_via_dns);
    }

    /**
     * Controls whether the k8s token auth is allowed via DNS.
     *
     * Generated from protobuf field <code>optional bool enable_k8s_tokens_via_dns = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableK8STokensViaDns($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_k8s_tokens_via_dns = $var;

        return $this;
    }

    /**
     * Controls whether the k8s certs auth is allowed via DNS.
     *
     * Generated from protobuf field <code>optional bool enable_k8s_certs_via_dns = 6;</code>
     * @return bool
     */
    public function getEnableK8SCertsViaDns()
    {
        return isset($this->enable_k8s_certs_via_dns) ? $this->enable_k8s_certs_via_dns : false;
    }

    public function hasEnableK8SCertsViaDns()
    {
        return isset($this->enable_k8s_certs_via_dns);
    }

    public function clearEnableK8SCertsViaDns()
    {
        unset($this->enable_k8s_certs_via_dns);
    }

    /**
     * Controls whether the k8s certs auth is allowed via DNS.
     *
     * Generated from protobuf field <code>optional bool enable_k8s_certs_via_dns = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableK8SCertsViaDns($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_k8s_certs_via_dns = $var;

        return $this;
    }

}


