<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/chronicle/v1/data_access_control.proto

namespace Google\Cloud\Chronicle\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A DataAccessScope is a boolean expression of data access labels used
 * to restrict access to data for users.
 *
 * Generated from protobuf message <code>google.cloud.chronicle.v1.DataAccessScope</code>
 */
class DataAccessScope extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The unique full name of the data access scope.
     * The name should comply with https://google.aip.dev/122 standards.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $name = '';
    /**
     * Optional. The allowed labels for the scope.
     * Either allow_all or allowed_data_access_labels needs to be provided.
     * When provided, there has to be at least one label allowed for the scope to
     * be valid.
     * The logical operator for evaluation of the allowed labels is OR.
     * E.g.: A customer with scope with allowed labels A and B will be able
     * to see data with labeled with A or B or (A and B).
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.DataAccessLabelReference allowed_data_access_labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $allowed_data_access_labels;
    /**
     * Optional. The denied labels for the scope.
     * The logical operator for evaluation of the denied labels is AND.
     * E.g.: A customer with scope with denied labels A and B won't be able
     * to see data labeled with A and data labeled with B
     * and data with labels A and B.
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.DataAccessLabelReference denied_data_access_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $denied_data_access_labels;
    /**
     * Output only. The name to be used for display to customers of the data
     * access scope.
     *
     * Generated from protobuf field <code>string display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $display_name = '';
    /**
     * Output only. The time at which the data access scope was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time at which the data access scope was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. The user who created the data access scope.
     *
     * Generated from protobuf field <code>string author = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $author = '';
    /**
     * Output only. The user who last updated the data access scope.
     *
     * Generated from protobuf field <code>string last_editor = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_editor = '';
    /**
     * Optional. A description of the data access scope for a human reader.
     *
     * Generated from protobuf field <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. Whether or not the scope allows all labels, allow_all and
     * allowed_data_access_labels are mutually exclusive and one of them must be
     * present. denied_data_access_labels can still be used along with allow_all.
     * When combined with denied_data_access_labels, access will be granted to all
     * data that doesn't have labels mentioned in denied_data_access_labels. E.g.:
     * A customer with scope with denied labels A and B and allow_all will be able
     * to see all data except data labeled with A and data labeled with B and data
     * with labels A and B.
     *
     * Generated from protobuf field <code>bool allow_all = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $allow_all = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The unique full name of the data access scope.
     *           The name should comply with https://google.aip.dev/122 standards.
     *     @type array<\Google\Cloud\Chronicle\V1\DataAccessLabelReference>|\Google\Protobuf\Internal\RepeatedField $allowed_data_access_labels
     *           Optional. The allowed labels for the scope.
     *           Either allow_all or allowed_data_access_labels needs to be provided.
     *           When provided, there has to be at least one label allowed for the scope to
     *           be valid.
     *           The logical operator for evaluation of the allowed labels is OR.
     *           E.g.: A customer with scope with allowed labels A and B will be able
     *           to see data with labeled with A or B or (A and B).
     *     @type array<\Google\Cloud\Chronicle\V1\DataAccessLabelReference>|\Google\Protobuf\Internal\RepeatedField $denied_data_access_labels
     *           Optional. The denied labels for the scope.
     *           The logical operator for evaluation of the denied labels is AND.
     *           E.g.: A customer with scope with denied labels A and B won't be able
     *           to see data labeled with A and data labeled with B
     *           and data with labels A and B.
     *     @type string $display_name
     *           Output only. The name to be used for display to customers of the data
     *           access scope.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time at which the data access scope was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time at which the data access scope was last updated.
     *     @type string $author
     *           Output only. The user who created the data access scope.
     *     @type string $last_editor
     *           Output only. The user who last updated the data access scope.
     *     @type string $description
     *           Optional. A description of the data access scope for a human reader.
     *     @type bool $allow_all
     *           Optional. Whether or not the scope allows all labels, allow_all and
     *           allowed_data_access_labels are mutually exclusive and one of them must be
     *           present. denied_data_access_labels can still be used along with allow_all.
     *           When combined with denied_data_access_labels, access will be granted to all
     *           data that doesn't have labels mentioned in denied_data_access_labels. E.g.:
     *           A customer with scope with denied labels A and B and allow_all will be able
     *           to see all data except data labeled with A and data labeled with B and data
     *           with labels A and B.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Chronicle\V1\DataAccessControl::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The unique full name of the data access scope.
     * The name should comply with https://google.aip.dev/122 standards.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The unique full name of the data access scope.
     * The name should comply with https://google.aip.dev/122 standards.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The allowed labels for the scope.
     * Either allow_all or allowed_data_access_labels needs to be provided.
     * When provided, there has to be at least one label allowed for the scope to
     * be valid.
     * The logical operator for evaluation of the allowed labels is OR.
     * E.g.: A customer with scope with allowed labels A and B will be able
     * to see data with labeled with A or B or (A and B).
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.DataAccessLabelReference allowed_data_access_labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowedDataAccessLabels()
    {
        return $this->allowed_data_access_labels;
    }

    /**
     * Optional. The allowed labels for the scope.
     * Either allow_all or allowed_data_access_labels needs to be provided.
     * When provided, there has to be at least one label allowed for the scope to
     * be valid.
     * The logical operator for evaluation of the allowed labels is OR.
     * E.g.: A customer with scope with allowed labels A and B will be able
     * to see data with labeled with A or B or (A and B).
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.DataAccessLabelReference allowed_data_access_labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Chronicle\V1\DataAccessLabelReference>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowedDataAccessLabels($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Chronicle\V1\DataAccessLabelReference::class);
        $this->allowed_data_access_labels = $arr;

        return $this;
    }

    /**
     * Optional. The denied labels for the scope.
     * The logical operator for evaluation of the denied labels is AND.
     * E.g.: A customer with scope with denied labels A and B won't be able
     * to see data labeled with A and data labeled with B
     * and data with labels A and B.
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.DataAccessLabelReference denied_data_access_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDeniedDataAccessLabels()
    {
        return $this->denied_data_access_labels;
    }

    /**
     * Optional. The denied labels for the scope.
     * The logical operator for evaluation of the denied labels is AND.
     * E.g.: A customer with scope with denied labels A and B won't be able
     * to see data labeled with A and data labeled with B
     * and data with labels A and B.
     *
     * Generated from protobuf field <code>repeated .google.cloud.chronicle.v1.DataAccessLabelReference denied_data_access_labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Chronicle\V1\DataAccessLabelReference>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDeniedDataAccessLabels($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Chronicle\V1\DataAccessLabelReference::class);
        $this->denied_data_access_labels = $arr;

        return $this;
    }

    /**
     * Output only. The name to be used for display to customers of the data
     * access scope.
     *
     * Generated from protobuf field <code>string display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Output only. The name to be used for display to customers of the data
     * access scope.
     *
     * Generated from protobuf field <code>string display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. The time at which the data access scope was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time at which the data access scope was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time at which the data access scope was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time at which the data access scope was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The user who created the data access scope.
     *
     * Generated from protobuf field <code>string author = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getAuthor()
    {
        return $this->author;
    }

    /**
     * Output only. The user who created the data access scope.
     *
     * Generated from protobuf field <code>string author = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setAuthor($var)
    {
        GPBUtil::checkString($var, True);
        $this->author = $var;

        return $this;
    }

    /**
     * Output only. The user who last updated the data access scope.
     *
     * Generated from protobuf field <code>string last_editor = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLastEditor()
    {
        return $this->last_editor;
    }

    /**
     * Output only. The user who last updated the data access scope.
     *
     * Generated from protobuf field <code>string last_editor = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLastEditor($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_editor = $var;

        return $this;
    }

    /**
     * Optional. A description of the data access scope for a human reader.
     *
     * Generated from protobuf field <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A description of the data access scope for a human reader.
     *
     * Generated from protobuf field <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. Whether or not the scope allows all labels, allow_all and
     * allowed_data_access_labels are mutually exclusive and one of them must be
     * present. denied_data_access_labels can still be used along with allow_all.
     * When combined with denied_data_access_labels, access will be granted to all
     * data that doesn't have labels mentioned in denied_data_access_labels. E.g.:
     * A customer with scope with denied labels A and B and allow_all will be able
     * to see all data except data labeled with A and data labeled with B and data
     * with labels A and B.
     *
     * Generated from protobuf field <code>bool allow_all = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getAllowAll()
    {
        return $this->allow_all;
    }

    /**
     * Optional. Whether or not the scope allows all labels, allow_all and
     * allowed_data_access_labels are mutually exclusive and one of them must be
     * present. denied_data_access_labels can still be used along with allow_all.
     * When combined with denied_data_access_labels, access will be granted to all
     * data that doesn't have labels mentioned in denied_data_access_labels. E.g.:
     * A customer with scope with denied labels A and B and allow_all will be able
     * to see all data except data labeled with A and data labeled with B and data
     * with labels A and B.
     *
     * Generated from protobuf field <code>bool allow_all = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowAll($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_all = $var;

        return $this;
    }

}

