<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/channel/v1/repricing.proto

namespace Google\Cloud\Channel\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for repricing a Google bill over a period of time.
 *
 * Generated from protobuf message <code>google.cloud.channel.v1.RepricingConfig</code>
 */
class RepricingConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The YearMonth when these adjustments activate. The Day field
     * needs to be "0" since we only accept YearMonth repricing boundaries.
     *
     * Generated from protobuf field <code>.google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $effective_invoice_month = null;
    /**
     * Required. Information about the adjustment.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $adjustment = null;
    /**
     * Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to
     * use for this bill. Specifies the relative cost based on repricing costs you
     * will apply.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.RebillingBasis rebilling_basis = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $rebilling_basis = 0;
    /**
     * The conditional overrides to apply for this configuration. If you list
     * multiple overrides, only the first valid override is used.  If you don't
     * list any overrides, the API uses the normal adjustment and rebilling basis.
     *
     * Generated from protobuf field <code>repeated .google.cloud.channel.v1.ConditionalOverride conditional_overrides = 6;</code>
     */
    private $conditional_overrides;
    protected $granularity;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Channel\V1\RepricingConfig\EntitlementGranularity $entitlement_granularity
     *           Applies the repricing configuration at the entitlement level.
     *           Note: If a
     *           [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     *           using
     *           [RepricingConfig.EntitlementGranularity][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity]
     *           becomes effective, then no existing or future
     *           [RepricingConfig.ChannelPartnerGranularity][google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity]
     *           will apply to the
     *           [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
     *           This is the recommended value for both
     *           [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     *           and
     *           [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig].
     *     @type \Google\Cloud\Channel\V1\RepricingConfig\ChannelPartnerGranularity $channel_partner_granularity
     *           Applies the repricing configuration at the channel partner level.
     *           Only
     *           [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     *           supports this value. Deprecated: This is no longer supported. Use
     *           [RepricingConfig.entitlement_granularity][google.cloud.channel.v1.RepricingConfig.entitlement_granularity]
     *           instead.
     *     @type \Google\Type\Date $effective_invoice_month
     *           Required. The YearMonth when these adjustments activate. The Day field
     *           needs to be "0" since we only accept YearMonth repricing boundaries.
     *     @type \Google\Cloud\Channel\V1\RepricingAdjustment $adjustment
     *           Required. Information about the adjustment.
     *     @type int $rebilling_basis
     *           Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to
     *           use for this bill. Specifies the relative cost based on repricing costs you
     *           will apply.
     *     @type array<\Google\Cloud\Channel\V1\ConditionalOverride>|\Google\Protobuf\Internal\RepeatedField $conditional_overrides
     *           The conditional overrides to apply for this configuration. If you list
     *           multiple overrides, only the first valid override is used.  If you don't
     *           list any overrides, the API uses the normal adjustment and rebilling basis.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Channel\V1\Repricing::initOnce();
        parent::__construct($data);
    }

    /**
     * Applies the repricing configuration at the entitlement level.
     * Note: If a
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * using
     * [RepricingConfig.EntitlementGranularity][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity]
     * becomes effective, then no existing or future
     * [RepricingConfig.ChannelPartnerGranularity][google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity]
     * will apply to the
     * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
     * This is the recommended value for both
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * and
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig].
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;</code>
     * @return \Google\Cloud\Channel\V1\RepricingConfig\EntitlementGranularity|null
     */
    public function getEntitlementGranularity()
    {
        return $this->readOneof(4);
    }

    public function hasEntitlementGranularity()
    {
        return $this->hasOneof(4);
    }

    /**
     * Applies the repricing configuration at the entitlement level.
     * Note: If a
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * using
     * [RepricingConfig.EntitlementGranularity][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity]
     * becomes effective, then no existing or future
     * [RepricingConfig.ChannelPartnerGranularity][google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity]
     * will apply to the
     * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
     * This is the recommended value for both
     * [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
     * and
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig].
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;</code>
     * @param \Google\Cloud\Channel\V1\RepricingConfig\EntitlementGranularity $var
     * @return $this
     */
    public function setEntitlementGranularity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Channel\V1\RepricingConfig\EntitlementGranularity::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Applies the repricing configuration at the channel partner level.
     * Only
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * supports this value. Deprecated: This is no longer supported. Use
     * [RepricingConfig.entitlement_granularity][google.cloud.channel.v1.RepricingConfig.entitlement_granularity]
     * instead.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5 [deprecated = true];</code>
     * @return \Google\Cloud\Channel\V1\RepricingConfig\ChannelPartnerGranularity|null
     * @deprecated
     */
    public function getChannelPartnerGranularity()
    {
        if ($this->hasOneof(5)) {
            @trigger_error('channel_partner_granularity is deprecated.', E_USER_DEPRECATED);
        }
        return $this->readOneof(5);
    }

    public function hasChannelPartnerGranularity()
    {
        if ($this->hasOneof(5)) {
            @trigger_error('channel_partner_granularity is deprecated.', E_USER_DEPRECATED);
        }
        return $this->hasOneof(5);
    }

    /**
     * Applies the repricing configuration at the channel partner level.
     * Only
     * [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
     * supports this value. Deprecated: This is no longer supported. Use
     * [RepricingConfig.entitlement_granularity][google.cloud.channel.v1.RepricingConfig.entitlement_granularity]
     * instead.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5 [deprecated = true];</code>
     * @param \Google\Cloud\Channel\V1\RepricingConfig\ChannelPartnerGranularity $var
     * @return $this
     * @deprecated
     */
    public function setChannelPartnerGranularity($var)
    {
        @trigger_error('channel_partner_granularity is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\Channel\V1\RepricingConfig\ChannelPartnerGranularity::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Required. The YearMonth when these adjustments activate. The Day field
     * needs to be "0" since we only accept YearMonth repricing boundaries.
     *
     * Generated from protobuf field <code>.google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Type\Date|null
     */
    public function getEffectiveInvoiceMonth()
    {
        return $this->effective_invoice_month;
    }

    public function hasEffectiveInvoiceMonth()
    {
        return isset($this->effective_invoice_month);
    }

    public function clearEffectiveInvoiceMonth()
    {
        unset($this->effective_invoice_month);
    }

    /**
     * Required. The YearMonth when these adjustments activate. The Day field
     * needs to be "0" since we only accept YearMonth repricing boundaries.
     *
     * Generated from protobuf field <code>.google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Type\Date $var
     * @return $this
     */
    public function setEffectiveInvoiceMonth($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Date::class);
        $this->effective_invoice_month = $var;

        return $this;
    }

    /**
     * Required. Information about the adjustment.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Channel\V1\RepricingAdjustment|null
     */
    public function getAdjustment()
    {
        return $this->adjustment;
    }

    public function hasAdjustment()
    {
        return isset($this->adjustment);
    }

    public function clearAdjustment()
    {
        unset($this->adjustment);
    }

    /**
     * Required. Information about the adjustment.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Channel\V1\RepricingAdjustment $var
     * @return $this
     */
    public function setAdjustment($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Channel\V1\RepricingAdjustment::class);
        $this->adjustment = $var;

        return $this;
    }

    /**
     * Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to
     * use for this bill. Specifies the relative cost based on repricing costs you
     * will apply.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.RebillingBasis rebilling_basis = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getRebillingBasis()
    {
        return $this->rebilling_basis;
    }

    /**
     * Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to
     * use for this bill. Specifies the relative cost based on repricing costs you
     * will apply.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.RebillingBasis rebilling_basis = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setRebillingBasis($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Channel\V1\RebillingBasis::class);
        $this->rebilling_basis = $var;

        return $this;
    }

    /**
     * The conditional overrides to apply for this configuration. If you list
     * multiple overrides, only the first valid override is used.  If you don't
     * list any overrides, the API uses the normal adjustment and rebilling basis.
     *
     * Generated from protobuf field <code>repeated .google.cloud.channel.v1.ConditionalOverride conditional_overrides = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getConditionalOverrides()
    {
        return $this->conditional_overrides;
    }

    /**
     * The conditional overrides to apply for this configuration. If you list
     * multiple overrides, only the first valid override is used.  If you don't
     * list any overrides, the API uses the normal adjustment and rebilling basis.
     *
     * Generated from protobuf field <code>repeated .google.cloud.channel.v1.ConditionalOverride conditional_overrides = 6;</code>
     * @param array<\Google\Cloud\Channel\V1\ConditionalOverride>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setConditionalOverrides($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Channel\V1\ConditionalOverride::class);
        $this->conditional_overrides = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getGranularity()
    {
        return $this->whichOneof("granularity");
    }

}

