<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/backupdr/v1/backupdr.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\BackupDR\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\BackupDR\V1\Backup;
use Google\Cloud\BackupDR\V1\BackupPlan;
use Google\Cloud\BackupDR\V1\BackupPlanAssociation;
use Google\Cloud\BackupDR\V1\BackupPlanRevision;
use Google\Cloud\BackupDR\V1\BackupVault;
use Google\Cloud\BackupDR\V1\CreateBackupPlanAssociationRequest;
use Google\Cloud\BackupDR\V1\CreateBackupPlanRequest;
use Google\Cloud\BackupDR\V1\CreateBackupVaultRequest;
use Google\Cloud\BackupDR\V1\CreateManagementServerRequest;
use Google\Cloud\BackupDR\V1\DataSource;
use Google\Cloud\BackupDR\V1\DataSourceReference;
use Google\Cloud\BackupDR\V1\DeleteBackupPlanAssociationRequest;
use Google\Cloud\BackupDR\V1\DeleteBackupPlanRequest;
use Google\Cloud\BackupDR\V1\DeleteBackupRequest;
use Google\Cloud\BackupDR\V1\DeleteBackupVaultRequest;
use Google\Cloud\BackupDR\V1\DeleteManagementServerRequest;
use Google\Cloud\BackupDR\V1\FetchBackupPlanAssociationsForResourceTypeRequest;
use Google\Cloud\BackupDR\V1\FetchBackupsForResourceTypeRequest;
use Google\Cloud\BackupDR\V1\FetchDataSourceReferencesForResourceTypeRequest;
use Google\Cloud\BackupDR\V1\FetchUsableBackupVaultsRequest;
use Google\Cloud\BackupDR\V1\GetBackupPlanAssociationRequest;
use Google\Cloud\BackupDR\V1\GetBackupPlanRequest;
use Google\Cloud\BackupDR\V1\GetBackupPlanRevisionRequest;
use Google\Cloud\BackupDR\V1\GetBackupRequest;
use Google\Cloud\BackupDR\V1\GetBackupVaultRequest;
use Google\Cloud\BackupDR\V1\GetDataSourceReferenceRequest;
use Google\Cloud\BackupDR\V1\GetDataSourceRequest;
use Google\Cloud\BackupDR\V1\GetManagementServerRequest;
use Google\Cloud\BackupDR\V1\InitializeServiceRequest;
use Google\Cloud\BackupDR\V1\InitializeServiceResponse;
use Google\Cloud\BackupDR\V1\ListBackupPlanAssociationsRequest;
use Google\Cloud\BackupDR\V1\ListBackupPlanRevisionsRequest;
use Google\Cloud\BackupDR\V1\ListBackupPlansRequest;
use Google\Cloud\BackupDR\V1\ListBackupVaultsRequest;
use Google\Cloud\BackupDR\V1\ListBackupsRequest;
use Google\Cloud\BackupDR\V1\ListDataSourceReferencesRequest;
use Google\Cloud\BackupDR\V1\ListDataSourcesRequest;
use Google\Cloud\BackupDR\V1\ListManagementServersRequest;
use Google\Cloud\BackupDR\V1\ManagementServer;
use Google\Cloud\BackupDR\V1\RestoreBackupRequest;
use Google\Cloud\BackupDR\V1\RestoreBackupResponse;
use Google\Cloud\BackupDR\V1\TriggerBackupRequest;
use Google\Cloud\BackupDR\V1\UpdateBackupPlanAssociationRequest;
use Google\Cloud\BackupDR\V1\UpdateBackupPlanRequest;
use Google\Cloud\BackupDR\V1\UpdateBackupRequest;
use Google\Cloud\BackupDR\V1\UpdateBackupVaultRequest;
use Google\Cloud\BackupDR\V1\UpdateDataSourceRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The BackupDR Service
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createBackupPlanAsync(CreateBackupPlanRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createBackupPlanAssociationAsync(CreateBackupPlanAssociationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createBackupVaultAsync(CreateBackupVaultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createManagementServerAsync(CreateManagementServerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteBackupAsync(DeleteBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteBackupPlanAsync(DeleteBackupPlanRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteBackupPlanAssociationAsync(DeleteBackupPlanAssociationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteBackupVaultAsync(DeleteBackupVaultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteManagementServerAsync(DeleteManagementServerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> fetchBackupPlanAssociationsForResourceTypeAsync(FetchBackupPlanAssociationsForResourceTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> fetchBackupsForResourceTypeAsync(FetchBackupsForResourceTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> fetchDataSourceReferencesForResourceTypeAsync(FetchDataSourceReferencesForResourceTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> fetchUsableBackupVaultsAsync(FetchUsableBackupVaultsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Backup> getBackupAsync(GetBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BackupPlan> getBackupPlanAsync(GetBackupPlanRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BackupPlanAssociation> getBackupPlanAssociationAsync(GetBackupPlanAssociationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BackupPlanRevision> getBackupPlanRevisionAsync(GetBackupPlanRevisionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BackupVault> getBackupVaultAsync(GetBackupVaultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataSource> getDataSourceAsync(GetDataSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataSourceReference> getDataSourceReferenceAsync(GetDataSourceReferenceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ManagementServer> getManagementServerAsync(GetManagementServerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> initializeServiceAsync(InitializeServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBackupPlanAssociationsAsync(ListBackupPlanAssociationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBackupPlanRevisionsAsync(ListBackupPlanRevisionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBackupPlansAsync(ListBackupPlansRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBackupVaultsAsync(ListBackupVaultsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBackupsAsync(ListBackupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDataSourceReferencesAsync(ListDataSourceReferencesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDataSourcesAsync(ListDataSourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listManagementServersAsync(ListManagementServersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> restoreBackupAsync(RestoreBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> triggerBackupAsync(TriggerBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateBackupAsync(UpdateBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateBackupPlanAsync(UpdateBackupPlanRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateBackupPlanAssociationAsync(UpdateBackupPlanAssociationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateBackupVaultAsync(UpdateBackupVaultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateDataSourceAsync(UpdateDataSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class BackupDRClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.backupdr.v1.BackupDR';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'backupdr.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'backupdr.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/backup_dr_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/backup_dr_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/backup_dr_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/backup_dr_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupvault
     * @param string $datasource
     * @param string $backup
     *
     * @return string The formatted backup resource.
     */
    public static function backupName(
        string $project,
        string $location,
        string $backupvault,
        string $datasource,
        string $backup
    ): string {
        return self::getPathTemplate('backup')->render([
            'project' => $project,
            'location' => $location,
            'backupvault' => $backupvault,
            'datasource' => $datasource,
            'backup' => $backup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup_plan
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupPlan
     *
     * @return string The formatted backup_plan resource.
     */
    public static function backupPlanName(string $project, string $location, string $backupPlan): string
    {
        return self::getPathTemplate('backupPlan')->render([
            'project' => $project,
            'location' => $location,
            'backup_plan' => $backupPlan,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * backup_plan_association resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupPlanAssociation
     *
     * @return string The formatted backup_plan_association resource.
     */
    public static function backupPlanAssociationName(
        string $project,
        string $location,
        string $backupPlanAssociation
    ): string {
        return self::getPathTemplate('backupPlanAssociation')->render([
            'project' => $project,
            'location' => $location,
            'backup_plan_association' => $backupPlanAssociation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * backup_plan_revision resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupPlan
     * @param string $revision
     *
     * @return string The formatted backup_plan_revision resource.
     */
    public static function backupPlanRevisionName(
        string $project,
        string $location,
        string $backupPlan,
        string $revision
    ): string {
        return self::getPathTemplate('backupPlanRevision')->render([
            'project' => $project,
            'location' => $location,
            'backup_plan' => $backupPlan,
            'revision' => $revision,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup_vault
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupvault
     *
     * @return string The formatted backup_vault resource.
     */
    public static function backupVaultName(string $project, string $location, string $backupvault): string
    {
        return self::getPathTemplate('backupVault')->render([
            'project' => $project,
            'location' => $location,
            'backupvault' => $backupvault,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a data_source
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupvault
     * @param string $datasource
     *
     * @return string The formatted data_source resource.
     */
    public static function dataSourceName(
        string $project,
        string $location,
        string $backupvault,
        string $datasource
    ): string {
        return self::getPathTemplate('dataSource')->render([
            'project' => $project,
            'location' => $location,
            'backupvault' => $backupvault,
            'datasource' => $datasource,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_source_reference resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataSourceReference
     *
     * @return string The formatted data_source_reference resource.
     */
    public static function dataSourceReferenceName(
        string $project,
        string $location,
        string $dataSourceReference
    ): string {
        return self::getPathTemplate('dataSourceReference')->render([
            'project' => $project,
            'location' => $location,
            'data_source_reference' => $dataSourceReference,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * management_server resource.
     *
     * @param string $project
     * @param string $location
     * @param string $managementserver
     *
     * @return string The formatted management_server resource.
     */
    public static function managementServerName(string $project, string $location, string $managementserver): string
    {
        return self::getPathTemplate('managementServer')->render([
            'project' => $project,
            'location' => $location,
            'managementserver' => $managementserver,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a storage_pool
     * resource.
     *
     * @param string $project
     * @param string $zone
     * @param string $storagePool
     *
     * @return string The formatted storage_pool resource.
     */
    public static function storagePoolName(string $project, string $zone, string $storagePool): string
    {
        return self::getPathTemplate('storagePool')->render([
            'project' => $project,
            'zone' => $zone,
            'storage_pool' => $storagePool,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - backup: projects/{project}/locations/{location}/backupVaults/{backupvault}/dataSources/{datasource}/backups/{backup}
     * - backupPlan: projects/{project}/locations/{location}/backupPlans/{backup_plan}
     * - backupPlanAssociation: projects/{project}/locations/{location}/backupPlanAssociations/{backup_plan_association}
     * - backupPlanRevision: projects/{project}/locations/{location}/backupPlans/{backup_plan}/revisions/{revision}
     * - backupVault: projects/{project}/locations/{location}/backupVaults/{backupvault}
     * - dataSource: projects/{project}/locations/{location}/backupVaults/{backupvault}/dataSources/{datasource}
     * - dataSourceReference: projects/{project}/locations/{location}/dataSourceReferences/{data_source_reference}
     * - instance: projects/{project}/instances/{instance}
     * - location: projects/{project}/locations/{location}
     * - managementServer: projects/{project}/locations/{location}/managementServers/{managementserver}
     * - storagePool: projects/{project}/zones/{zone}/storagePools/{storage_pool}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'backupdr.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\BackupDR\V1\BackupDRClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new BackupDRClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Create a BackupPlan
     *
     * The async variant is {@see BackupDRClient::createBackupPlanAsync()} .
     *
     * @example samples/V1/BackupDRClient/create_backup_plan.php
     *
     * @param CreateBackupPlanRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<BackupPlan>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBackupPlan(CreateBackupPlanRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBackupPlan', $request, $callOptions)->wait();
    }

    /**
     * Create a BackupPlanAssociation
     *
     * The async variant is {@see BackupDRClient::createBackupPlanAssociationAsync()} .
     *
     * @example samples/V1/BackupDRClient/create_backup_plan_association.php
     *
     * @param CreateBackupPlanAssociationRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<BackupPlanAssociation>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBackupPlanAssociation(
        CreateBackupPlanAssociationRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateBackupPlanAssociation', $request, $callOptions)->wait();
    }

    /**
     * Creates a new BackupVault in a given project and location.
     *
     * The async variant is {@see BackupDRClient::createBackupVaultAsync()} .
     *
     * @example samples/V1/BackupDRClient/create_backup_vault.php
     *
     * @param CreateBackupVaultRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<BackupVault>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBackupVault(CreateBackupVaultRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBackupVault', $request, $callOptions)->wait();
    }

    /**
     * Creates a new ManagementServer in a given project and location.
     *
     * The async variant is {@see BackupDRClient::createManagementServerAsync()} .
     *
     * @example samples/V1/BackupDRClient/create_management_server.php
     *
     * @param CreateManagementServerRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ManagementServer>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createManagementServer(
        CreateManagementServerRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateManagementServer', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Backup.
     *
     * The async variant is {@see BackupDRClient::deleteBackupAsync()} .
     *
     * @example samples/V1/BackupDRClient/delete_backup.php
     *
     * @param DeleteBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Backup>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackup(DeleteBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBackup', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single BackupPlan.
     *
     * The async variant is {@see BackupDRClient::deleteBackupPlanAsync()} .
     *
     * @example samples/V1/BackupDRClient/delete_backup_plan.php
     *
     * @param DeleteBackupPlanRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackupPlan(DeleteBackupPlanRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBackupPlan', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single BackupPlanAssociation.
     *
     * The async variant is {@see BackupDRClient::deleteBackupPlanAssociationAsync()} .
     *
     * @example samples/V1/BackupDRClient/delete_backup_plan_association.php
     *
     * @param DeleteBackupPlanAssociationRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackupPlanAssociation(
        DeleteBackupPlanAssociationRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteBackupPlanAssociation', $request, $callOptions)->wait();
    }

    /**
     * Deletes a BackupVault.
     *
     * The async variant is {@see BackupDRClient::deleteBackupVaultAsync()} .
     *
     * @example samples/V1/BackupDRClient/delete_backup_vault.php
     *
     * @param DeleteBackupVaultRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackupVault(DeleteBackupVaultRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBackupVault', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single ManagementServer.
     *
     * The async variant is {@see BackupDRClient::deleteManagementServerAsync()} .
     *
     * @example samples/V1/BackupDRClient/delete_management_server.php
     *
     * @param DeleteManagementServerRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteManagementServer(
        DeleteManagementServerRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteManagementServer', $request, $callOptions)->wait();
    }

    /**
     * List BackupPlanAssociations for a given resource type.
     *
     * The async variant is
     * {@see BackupDRClient::fetchBackupPlanAssociationsForResourceTypeAsync()} .
     *
     * @example samples/V1/BackupDRClient/fetch_backup_plan_associations_for_resource_type.php
     *
     * @param FetchBackupPlanAssociationsForResourceTypeRequest $request     A request to house fields associated with the call.
     * @param array                                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchBackupPlanAssociationsForResourceType(
        FetchBackupPlanAssociationsForResourceTypeRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('FetchBackupPlanAssociationsForResourceType', $request, $callOptions);
    }

    /**
     * Fetch Backups for a given resource type.
     *
     * The async variant is {@see BackupDRClient::fetchBackupsForResourceTypeAsync()} .
     *
     * @example samples/V1/BackupDRClient/fetch_backups_for_resource_type.php
     *
     * @param FetchBackupsForResourceTypeRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchBackupsForResourceType(
        FetchBackupsForResourceTypeRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('FetchBackupsForResourceType', $request, $callOptions);
    }

    /**
     * Fetch DataSourceReferences for a given project, location and resource type.
     *
     * The async variant is
     * {@see BackupDRClient::fetchDataSourceReferencesForResourceTypeAsync()} .
     *
     * @example samples/V1/BackupDRClient/fetch_data_source_references_for_resource_type.php
     *
     * @param FetchDataSourceReferencesForResourceTypeRequest $request     A request to house fields associated with the call.
     * @param array                                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchDataSourceReferencesForResourceType(
        FetchDataSourceReferencesForResourceTypeRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('FetchDataSourceReferencesForResourceType', $request, $callOptions);
    }

    /**
     * FetchUsableBackupVaults lists usable BackupVaults in a given project and
     * location. Usable BackupVault are the ones that user has
     * backupdr.backupVaults.get permission.
     *
     * The async variant is {@see BackupDRClient::fetchUsableBackupVaultsAsync()} .
     *
     * @example samples/V1/BackupDRClient/fetch_usable_backup_vaults.php
     *
     * @param FetchUsableBackupVaultsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchUsableBackupVaults(
        FetchUsableBackupVaultsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('FetchUsableBackupVaults', $request, $callOptions);
    }

    /**
     * Gets details of a Backup.
     *
     * The async variant is {@see BackupDRClient::getBackupAsync()} .
     *
     * @example samples/V1/BackupDRClient/get_backup.php
     *
     * @param GetBackupRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Backup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackup(GetBackupRequest $request, array $callOptions = []): Backup
    {
        return $this->startApiCall('GetBackup', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single BackupPlan.
     *
     * The async variant is {@see BackupDRClient::getBackupPlanAsync()} .
     *
     * @example samples/V1/BackupDRClient/get_backup_plan.php
     *
     * @param GetBackupPlanRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BackupPlan
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackupPlan(GetBackupPlanRequest $request, array $callOptions = []): BackupPlan
    {
        return $this->startApiCall('GetBackupPlan', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single BackupPlanAssociation.
     *
     * The async variant is {@see BackupDRClient::getBackupPlanAssociationAsync()} .
     *
     * @example samples/V1/BackupDRClient/get_backup_plan_association.php
     *
     * @param GetBackupPlanAssociationRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BackupPlanAssociation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackupPlanAssociation(
        GetBackupPlanAssociationRequest $request,
        array $callOptions = []
    ): BackupPlanAssociation {
        return $this->startApiCall('GetBackupPlanAssociation', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single BackupPlanRevision.
     *
     * The async variant is {@see BackupDRClient::getBackupPlanRevisionAsync()} .
     *
     * @example samples/V1/BackupDRClient/get_backup_plan_revision.php
     *
     * @param GetBackupPlanRevisionRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BackupPlanRevision
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackupPlanRevision(
        GetBackupPlanRevisionRequest $request,
        array $callOptions = []
    ): BackupPlanRevision {
        return $this->startApiCall('GetBackupPlanRevision', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a BackupVault.
     *
     * The async variant is {@see BackupDRClient::getBackupVaultAsync()} .
     *
     * @example samples/V1/BackupDRClient/get_backup_vault.php
     *
     * @param GetBackupVaultRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BackupVault
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackupVault(GetBackupVaultRequest $request, array $callOptions = []): BackupVault
    {
        return $this->startApiCall('GetBackupVault', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a DataSource.
     *
     * The async variant is {@see BackupDRClient::getDataSourceAsync()} .
     *
     * @example samples/V1/BackupDRClient/get_data_source.php
     *
     * @param GetDataSourceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataSource
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDataSource(GetDataSourceRequest $request, array $callOptions = []): DataSource
    {
        return $this->startApiCall('GetDataSource', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single DataSourceReference.
     *
     * The async variant is {@see BackupDRClient::getDataSourceReferenceAsync()} .
     *
     * @example samples/V1/BackupDRClient/get_data_source_reference.php
     *
     * @param GetDataSourceReferenceRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataSourceReference
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDataSourceReference(
        GetDataSourceReferenceRequest $request,
        array $callOptions = []
    ): DataSourceReference {
        return $this->startApiCall('GetDataSourceReference', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single ManagementServer.
     *
     * The async variant is {@see BackupDRClient::getManagementServerAsync()} .
     *
     * @example samples/V1/BackupDRClient/get_management_server.php
     *
     * @param GetManagementServerRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ManagementServer
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getManagementServer(GetManagementServerRequest $request, array $callOptions = []): ManagementServer
    {
        return $this->startApiCall('GetManagementServer', $request, $callOptions)->wait();
    }

    /**
     * Initializes the service related config for a project.
     *
     * The async variant is {@see BackupDRClient::initializeServiceAsync()} .
     *
     * @example samples/V1/BackupDRClient/initialize_service.php
     *
     * @param InitializeServiceRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<InitializeServiceResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function initializeService(InitializeServiceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('InitializeService', $request, $callOptions)->wait();
    }

    /**
     * Lists BackupPlanAssociations in a given project and location.
     *
     * The async variant is {@see BackupDRClient::listBackupPlanAssociationsAsync()} .
     *
     * @example samples/V1/BackupDRClient/list_backup_plan_associations.php
     *
     * @param ListBackupPlanAssociationsRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackupPlanAssociations(
        ListBackupPlanAssociationsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListBackupPlanAssociations', $request, $callOptions);
    }

    /**
     * Lists BackupPlanRevisions in a given project and location.
     *
     * The async variant is {@see BackupDRClient::listBackupPlanRevisionsAsync()} .
     *
     * @example samples/V1/BackupDRClient/list_backup_plan_revisions.php
     *
     * @param ListBackupPlanRevisionsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackupPlanRevisions(
        ListBackupPlanRevisionsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListBackupPlanRevisions', $request, $callOptions);
    }

    /**
     * Lists BackupPlans in a given project and location.
     *
     * The async variant is {@see BackupDRClient::listBackupPlansAsync()} .
     *
     * @example samples/V1/BackupDRClient/list_backup_plans.php
     *
     * @param ListBackupPlansRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackupPlans(ListBackupPlansRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackupPlans', $request, $callOptions);
    }

    /**
     * Lists BackupVaults in a given project and location.
     *
     * The async variant is {@see BackupDRClient::listBackupVaultsAsync()} .
     *
     * @example samples/V1/BackupDRClient/list_backup_vaults.php
     *
     * @param ListBackupVaultsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackupVaults(ListBackupVaultsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackupVaults', $request, $callOptions);
    }

    /**
     * Lists Backups in a given project and location.
     *
     * The async variant is {@see BackupDRClient::listBackupsAsync()} .
     *
     * @example samples/V1/BackupDRClient/list_backups.php
     *
     * @param ListBackupsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackups(ListBackupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackups', $request, $callOptions);
    }

    /**
     * Lists DataSourceReferences for a given project and location.
     *
     * The async variant is {@see BackupDRClient::listDataSourceReferencesAsync()} .
     *
     * @example samples/V1/BackupDRClient/list_data_source_references.php
     *
     * @param ListDataSourceReferencesRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDataSourceReferences(
        ListDataSourceReferencesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListDataSourceReferences', $request, $callOptions);
    }

    /**
     * Lists DataSources in a given project and location.
     *
     * The async variant is {@see BackupDRClient::listDataSourcesAsync()} .
     *
     * @example samples/V1/BackupDRClient/list_data_sources.php
     *
     * @param ListDataSourcesRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDataSources(ListDataSourcesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDataSources', $request, $callOptions);
    }

    /**
     * Lists ManagementServers in a given project and location.
     *
     * The async variant is {@see BackupDRClient::listManagementServersAsync()} .
     *
     * @example samples/V1/BackupDRClient/list_management_servers.php
     *
     * @param ListManagementServersRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listManagementServers(
        ListManagementServersRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListManagementServers', $request, $callOptions);
    }

    /**
     * Restore from a Backup
     *
     * The async variant is {@see BackupDRClient::restoreBackupAsync()} .
     *
     * @example samples/V1/BackupDRClient/restore_backup.php
     *
     * @param RestoreBackupRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<RestoreBackupResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restoreBackup(RestoreBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RestoreBackup', $request, $callOptions)->wait();
    }

    /**
     * Triggers a new Backup.
     *
     * The async variant is {@see BackupDRClient::triggerBackupAsync()} .
     *
     * @example samples/V1/BackupDRClient/trigger_backup.php
     *
     * @param TriggerBackupRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<BackupPlanAssociation>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function triggerBackup(TriggerBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('TriggerBackup', $request, $callOptions)->wait();
    }

    /**
     * Updates the settings of a Backup.
     *
     * The async variant is {@see BackupDRClient::updateBackupAsync()} .
     *
     * @example samples/V1/BackupDRClient/update_backup.php
     *
     * @param UpdateBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Backup>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackup(UpdateBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateBackup', $request, $callOptions)->wait();
    }

    /**
     * Update a BackupPlan.
     *
     * The async variant is {@see BackupDRClient::updateBackupPlanAsync()} .
     *
     * @example samples/V1/BackupDRClient/update_backup_plan.php
     *
     * @param UpdateBackupPlanRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<BackupPlan>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackupPlan(UpdateBackupPlanRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateBackupPlan', $request, $callOptions)->wait();
    }

    /**
     * Update a BackupPlanAssociation.
     *
     * The async variant is {@see BackupDRClient::updateBackupPlanAssociationAsync()} .
     *
     * @example samples/V1/BackupDRClient/update_backup_plan_association.php
     *
     * @param UpdateBackupPlanAssociationRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<BackupPlanAssociation>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackupPlanAssociation(
        UpdateBackupPlanAssociationRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateBackupPlanAssociation', $request, $callOptions)->wait();
    }

    /**
     * Updates the settings of a BackupVault.
     *
     * The async variant is {@see BackupDRClient::updateBackupVaultAsync()} .
     *
     * @example samples/V1/BackupDRClient/update_backup_vault.php
     *
     * @param UpdateBackupVaultRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<BackupVault>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackupVault(UpdateBackupVaultRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateBackupVault', $request, $callOptions)->wait();
    }

    /**
     * Updates the settings of a DataSource.
     *
     * The async variant is {@see BackupDRClient::updateDataSourceAsync()} .
     *
     * @example samples/V1/BackupDRClient/update_data_source.php
     *
     * @param UpdateDataSourceRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<DataSource>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDataSource(UpdateDataSourceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateDataSource', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see BackupDRClient::getLocationAsync()} .
     *
     * @example samples/V1/BackupDRClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see BackupDRClient::listLocationsAsync()} .
     *
     * @example samples/V1/BackupDRClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see BackupDRClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/BackupDRClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see BackupDRClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/BackupDRClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see BackupDRClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/BackupDRClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
