<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/devtools/artifactregistry/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ArtifactRegistry\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\ArtifactRegistry\V1\Attachment;
use Google\Cloud\ArtifactRegistry\V1\BatchDeleteVersionsRequest;
use Google\Cloud\ArtifactRegistry\V1\CreateAttachmentRequest;
use Google\Cloud\ArtifactRegistry\V1\CreateRepositoryRequest;
use Google\Cloud\ArtifactRegistry\V1\CreateRuleRequest;
use Google\Cloud\ArtifactRegistry\V1\CreateTagRequest;
use Google\Cloud\ArtifactRegistry\V1\DeleteAttachmentRequest;
use Google\Cloud\ArtifactRegistry\V1\DeleteFileRequest;
use Google\Cloud\ArtifactRegistry\V1\DeletePackageRequest;
use Google\Cloud\ArtifactRegistry\V1\DeleteRepositoryRequest;
use Google\Cloud\ArtifactRegistry\V1\DeleteRuleRequest;
use Google\Cloud\ArtifactRegistry\V1\DeleteTagRequest;
use Google\Cloud\ArtifactRegistry\V1\DeleteVersionRequest;
use Google\Cloud\ArtifactRegistry\V1\DockerImage;
use Google\Cloud\ArtifactRegistry\V1\File;
use Google\Cloud\ArtifactRegistry\V1\GetAttachmentRequest;
use Google\Cloud\ArtifactRegistry\V1\GetDockerImageRequest;
use Google\Cloud\ArtifactRegistry\V1\GetFileRequest;
use Google\Cloud\ArtifactRegistry\V1\GetMavenArtifactRequest;
use Google\Cloud\ArtifactRegistry\V1\GetNpmPackageRequest;
use Google\Cloud\ArtifactRegistry\V1\GetPackageRequest;
use Google\Cloud\ArtifactRegistry\V1\GetProjectSettingsRequest;
use Google\Cloud\ArtifactRegistry\V1\GetPythonPackageRequest;
use Google\Cloud\ArtifactRegistry\V1\GetRepositoryRequest;
use Google\Cloud\ArtifactRegistry\V1\GetRuleRequest;
use Google\Cloud\ArtifactRegistry\V1\GetTagRequest;
use Google\Cloud\ArtifactRegistry\V1\GetVPCSCConfigRequest;
use Google\Cloud\ArtifactRegistry\V1\GetVersionRequest;
use Google\Cloud\ArtifactRegistry\V1\ImportAptArtifactsRequest;
use Google\Cloud\ArtifactRegistry\V1\ImportAptArtifactsResponse;
use Google\Cloud\ArtifactRegistry\V1\ImportYumArtifactsRequest;
use Google\Cloud\ArtifactRegistry\V1\ImportYumArtifactsResponse;
use Google\Cloud\ArtifactRegistry\V1\ListAttachmentsRequest;
use Google\Cloud\ArtifactRegistry\V1\ListDockerImagesRequest;
use Google\Cloud\ArtifactRegistry\V1\ListFilesRequest;
use Google\Cloud\ArtifactRegistry\V1\ListMavenArtifactsRequest;
use Google\Cloud\ArtifactRegistry\V1\ListNpmPackagesRequest;
use Google\Cloud\ArtifactRegistry\V1\ListPackagesRequest;
use Google\Cloud\ArtifactRegistry\V1\ListPythonPackagesRequest;
use Google\Cloud\ArtifactRegistry\V1\ListRepositoriesRequest;
use Google\Cloud\ArtifactRegistry\V1\ListRulesRequest;
use Google\Cloud\ArtifactRegistry\V1\ListTagsRequest;
use Google\Cloud\ArtifactRegistry\V1\ListVersionsRequest;
use Google\Cloud\ArtifactRegistry\V1\MavenArtifact;
use Google\Cloud\ArtifactRegistry\V1\NpmPackage;
use Google\Cloud\ArtifactRegistry\V1\Package;
use Google\Cloud\ArtifactRegistry\V1\ProjectSettings;
use Google\Cloud\ArtifactRegistry\V1\PythonPackage;
use Google\Cloud\ArtifactRegistry\V1\Repository;
use Google\Cloud\ArtifactRegistry\V1\Rule;
use Google\Cloud\ArtifactRegistry\V1\Tag;
use Google\Cloud\ArtifactRegistry\V1\UpdateFileRequest;
use Google\Cloud\ArtifactRegistry\V1\UpdatePackageRequest;
use Google\Cloud\ArtifactRegistry\V1\UpdateProjectSettingsRequest;
use Google\Cloud\ArtifactRegistry\V1\UpdateRepositoryRequest;
use Google\Cloud\ArtifactRegistry\V1\UpdateRuleRequest;
use Google\Cloud\ArtifactRegistry\V1\UpdateTagRequest;
use Google\Cloud\ArtifactRegistry\V1\UpdateVPCSCConfigRequest;
use Google\Cloud\ArtifactRegistry\V1\UpdateVersionRequest;
use Google\Cloud\ArtifactRegistry\V1\VPCSCConfig;
use Google\Cloud\ArtifactRegistry\V1\Version;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The Artifact Registry API service.
 *
 * Artifact Registry is an artifact management system for storing artifacts
 * from different package management systems.
 *
 * The resources managed by this API are:
 *
 * * Repositories, which group packages and their data.
 * * Packages, which group versions and their tags.
 * * Versions, which are specific forms of a package.
 * * Tags, which represent alternative names for versions.
 * * Files, which contain content and are optionally associated with a Package
 * or Version.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> batchDeleteVersionsAsync(BatchDeleteVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createAttachmentAsync(CreateAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createRepositoryAsync(CreateRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Rule> createRuleAsync(CreateRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Tag> createTagAsync(CreateTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteAttachmentAsync(DeleteAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteFileAsync(DeleteFileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deletePackageAsync(DeletePackageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteRepositoryAsync(DeleteRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteRuleAsync(DeleteRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteTagAsync(DeleteTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteVersionAsync(DeleteVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Attachment> getAttachmentAsync(GetAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DockerImage> getDockerImageAsync(GetDockerImageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<File> getFileAsync(GetFileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MavenArtifact> getMavenArtifactAsync(GetMavenArtifactRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<NpmPackage> getNpmPackageAsync(GetNpmPackageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Package> getPackageAsync(GetPackageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ProjectSettings> getProjectSettingsAsync(GetProjectSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PythonPackage> getPythonPackageAsync(GetPythonPackageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Repository> getRepositoryAsync(GetRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Rule> getRuleAsync(GetRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Tag> getTagAsync(GetTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<VPCSCConfig> getVPCSCConfigAsync(GetVPCSCConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Version> getVersionAsync(GetVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> importAptArtifactsAsync(ImportAptArtifactsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> importYumArtifactsAsync(ImportYumArtifactsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAttachmentsAsync(ListAttachmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDockerImagesAsync(ListDockerImagesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listFilesAsync(ListFilesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listMavenArtifactsAsync(ListMavenArtifactsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listNpmPackagesAsync(ListNpmPackagesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listPackagesAsync(ListPackagesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listPythonPackagesAsync(ListPythonPackagesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRepositoriesAsync(ListRepositoriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRulesAsync(ListRulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTagsAsync(ListTagsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listVersionsAsync(ListVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<File> updateFileAsync(UpdateFileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Package> updatePackageAsync(UpdatePackageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ProjectSettings> updateProjectSettingsAsync(UpdateProjectSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Repository> updateRepositoryAsync(UpdateRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Rule> updateRuleAsync(UpdateRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Tag> updateTagAsync(UpdateTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<VPCSCConfig> updateVPCSCConfigAsync(UpdateVPCSCConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Version> updateVersionAsync(UpdateVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class ArtifactRegistryClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.devtools.artifactregistry.v1.ArtifactRegistry';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'artifactregistry.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'artifactregistry.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloud-platform.read-only',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/artifact_registry_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/artifact_registry_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/artifact_registry_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/artifact_registry_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a attachment
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $attachment
     *
     * @return string The formatted attachment resource.
     */
    public static function attachmentName(
        string $project,
        string $location,
        string $repository,
        string $attachment
    ): string {
        return self::getPathTemplate('attachment')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'attachment' => $attachment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a docker_image
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $dockerImage
     *
     * @return string The formatted docker_image resource.
     */
    public static function dockerImageName(
        string $project,
        string $location,
        string $repository,
        string $dockerImage
    ): string {
        return self::getPathTemplate('dockerImage')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'docker_image' => $dockerImage,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a file
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $file
     *
     * @return string The formatted file resource.
     */
    public static function fileName(string $project, string $location, string $repository, string $file): string
    {
        return self::getPathTemplate('file')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'file' => $file,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * maven_artifact resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $mavenArtifact
     *
     * @return string The formatted maven_artifact resource.
     */
    public static function mavenArtifactName(
        string $project,
        string $location,
        string $repository,
        string $mavenArtifact
    ): string {
        return self::getPathTemplate('mavenArtifact')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'maven_artifact' => $mavenArtifact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a npm_package
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $npmPackage
     *
     * @return string The formatted npm_package resource.
     */
    public static function npmPackageName(
        string $project,
        string $location,
        string $repository,
        string $npmPackage
    ): string {
        return self::getPathTemplate('npmPackage')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'npm_package' => $npmPackage,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a package
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $package
     *
     * @return string The formatted package resource.
     */
    public static function packageName(string $project, string $location, string $repository, string $package): string
    {
        return self::getPathTemplate('package')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'package' => $package,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_settings resource.
     *
     * @param string $project
     *
     * @return string The formatted project_settings resource.
     */
    public static function projectSettingsName(string $project): string
    {
        return self::getPathTemplate('projectSettings')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * python_package resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $pythonPackage
     *
     * @return string The formatted python_package resource.
     */
    public static function pythonPackageName(
        string $project,
        string $location,
        string $repository,
        string $pythonPackage
    ): string {
        return self::getPathTemplate('pythonPackage')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'python_package' => $pythonPackage,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a repository
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     *
     * @return string The formatted repository resource.
     */
    public static function repositoryName(string $project, string $location, string $repository): string
    {
        return self::getPathTemplate('repository')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a rule
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $rule
     *
     * @return string The formatted rule resource.
     */
    public static function ruleName(string $project, string $location, string $repository, string $rule): string
    {
        return self::getPathTemplate('rule')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'rule' => $rule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * secret_version resource.
     *
     * @param string $project
     * @param string $secret
     * @param string $secretVersion
     *
     * @return string The formatted secret_version resource.
     */
    public static function secretVersionName(string $project, string $secret, string $secretVersion): string
    {
        return self::getPathTemplate('secretVersion')->render([
            'project' => $project,
            'secret' => $secret,
            'secret_version' => $secretVersion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tag
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $package
     * @param string $tag
     *
     * @return string The formatted tag resource.
     */
    public static function tagName(
        string $project,
        string $location,
        string $repository,
        string $package,
        string $tag
    ): string {
        return self::getPathTemplate('tag')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'package' => $package,
            'tag' => $tag,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a version
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $package
     * @param string $version
     *
     * @return string The formatted version resource.
     */
    public static function versionName(
        string $project,
        string $location,
        string $repository,
        string $package,
        string $version
    ): string {
        return self::getPathTemplate('version')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'package' => $package,
            'version' => $version,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a vpcsc_config
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted vpcsc_config resource.
     */
    public static function vpcscConfigName(string $project, string $location): string
    {
        return self::getPathTemplate('vpcscConfig')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - attachment: projects/{project}/locations/{location}/repositories/{repository}/attachments/{attachment}
     * - dockerImage: projects/{project}/locations/{location}/repositories/{repository}/dockerImages/{docker_image}
     * - file: projects/{project}/locations/{location}/repositories/{repository}/files/{file}
     * - location: projects/{project}/locations/{location}
     * - mavenArtifact: projects/{project}/locations/{location}/repositories/{repository}/mavenArtifacts/{maven_artifact}
     * - npmPackage: projects/{project}/locations/{location}/repositories/{repository}/npmPackages/{npm_package}
     * - package: projects/{project}/locations/{location}/repositories/{repository}/packages/{package}
     * - projectSettings: projects/{project}/projectSettings
     * - pythonPackage: projects/{project}/locations/{location}/repositories/{repository}/pythonPackages/{python_package}
     * - repository: projects/{project}/locations/{location}/repositories/{repository}
     * - rule: projects/{project}/locations/{location}/repositories/{repository}/rules/{rule}
     * - secretVersion: projects/{project}/secrets/{secret}/versions/{secret_version}
     * - tag: projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/tags/{tag}
     * - version: projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/versions/{version}
     * - vpcscConfig: projects/{project}/locations/{location}/vpcscConfig
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'artifactregistry.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\ArtifactRegistry\V1\ArtifactRegistryClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new ArtifactRegistryClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Deletes multiple versions across a repository. The returned operation will
     * complete once the versions have been deleted.
     *
     * The async variant is {@see ArtifactRegistryClient::batchDeleteVersionsAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/batch_delete_versions.php
     *
     * @param BatchDeleteVersionsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchDeleteVersions(BatchDeleteVersionsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BatchDeleteVersions', $request, $callOptions)->wait();
    }

    /**
     * Creates an attachment. The returned Operation will finish once the
     * attachment has been created. Its response will be the created attachment.
     *
     * The async variant is {@see ArtifactRegistryClient::createAttachmentAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/create_attachment.php
     *
     * @param CreateAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Attachment>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAttachment(CreateAttachmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAttachment', $request, $callOptions)->wait();
    }

    /**
     * Creates a repository. The returned Operation will finish once the
     * repository has been created. Its response will be the created Repository.
     *
     * The async variant is {@see ArtifactRegistryClient::createRepositoryAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/create_repository.php
     *
     * @param CreateRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Repository>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRepository(CreateRepositoryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRepository', $request, $callOptions)->wait();
    }

    /**
     * Creates a rule.
     *
     * The async variant is {@see ArtifactRegistryClient::createRuleAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/create_rule.php
     *
     * @param CreateRuleRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Rule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRule(CreateRuleRequest $request, array $callOptions = []): Rule
    {
        return $this->startApiCall('CreateRule', $request, $callOptions)->wait();
    }

    /**
     * Creates a tag.
     *
     * The async variant is {@see ArtifactRegistryClient::createTagAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/create_tag.php
     *
     * @param CreateTagRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Tag
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTag(CreateTagRequest $request, array $callOptions = []): Tag
    {
        return $this->startApiCall('CreateTag', $request, $callOptions)->wait();
    }

    /**
     * Deletes an attachment. The returned Operation will
     * finish once the attachments has been deleted. It will not have any
     * Operation metadata and will return a `google.protobuf.Empty` response.
     *
     * The async variant is {@see ArtifactRegistryClient::deleteAttachmentAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/delete_attachment.php
     *
     * @param DeleteAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAttachment(DeleteAttachmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteAttachment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a file and all of its content. It is only allowed on generic
     * repositories. The returned operation will complete once the file has been
     * deleted.
     *
     * The async variant is {@see ArtifactRegistryClient::deleteFileAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/delete_file.php
     *
     * @param DeleteFileRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteFile(DeleteFileRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteFile', $request, $callOptions)->wait();
    }

    /**
     * Deletes a package and all of its versions and tags. The returned operation
     * will complete once the package has been deleted.
     *
     * The async variant is {@see ArtifactRegistryClient::deletePackageAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/delete_package.php
     *
     * @param DeletePackageRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePackage(DeletePackageRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePackage', $request, $callOptions)->wait();
    }

    /**
     * Deletes a repository and all of its contents. The returned Operation will
     * finish once the repository has been deleted. It will not have any Operation
     * metadata and will return a google.protobuf.Empty response.
     *
     * The async variant is {@see ArtifactRegistryClient::deleteRepositoryAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/delete_repository.php
     *
     * @param DeleteRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRepository(DeleteRepositoryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteRepository', $request, $callOptions)->wait();
    }

    /**
     * Deletes a rule.
     *
     * The async variant is {@see ArtifactRegistryClient::deleteRuleAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/delete_rule.php
     *
     * @param DeleteRuleRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRule(DeleteRuleRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteRule', $request, $callOptions)->wait();
    }

    /**
     * Deletes a tag.
     *
     * The async variant is {@see ArtifactRegistryClient::deleteTagAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/delete_tag.php
     *
     * @param DeleteTagRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTag(DeleteTagRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteTag', $request, $callOptions)->wait();
    }

    /**
     * Deletes a version and all of its content. The returned operation will
     * complete once the version has been deleted.
     *
     * The async variant is {@see ArtifactRegistryClient::deleteVersionAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/delete_version.php
     *
     * @param DeleteVersionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteVersion(DeleteVersionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteVersion', $request, $callOptions)->wait();
    }

    /**
     * Gets an attachment.
     *
     * The async variant is {@see ArtifactRegistryClient::getAttachmentAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_attachment.php
     *
     * @param GetAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Attachment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAttachment(GetAttachmentRequest $request, array $callOptions = []): Attachment
    {
        return $this->startApiCall('GetAttachment', $request, $callOptions)->wait();
    }

    /**
     * Gets a docker image.
     *
     * The async variant is {@see ArtifactRegistryClient::getDockerImageAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_docker_image.php
     *
     * @param GetDockerImageRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DockerImage
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDockerImage(GetDockerImageRequest $request, array $callOptions = []): DockerImage
    {
        return $this->startApiCall('GetDockerImage', $request, $callOptions)->wait();
    }

    /**
     * Gets a file.
     *
     * The async variant is {@see ArtifactRegistryClient::getFileAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_file.php
     *
     * @param GetFileRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return File
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getFile(GetFileRequest $request, array $callOptions = []): File
    {
        return $this->startApiCall('GetFile', $request, $callOptions)->wait();
    }

    /**
     * Gets the IAM policy for a given resource.
     *
     * The async variant is {@see ArtifactRegistryClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets a maven artifact.
     *
     * The async variant is {@see ArtifactRegistryClient::getMavenArtifactAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_maven_artifact.php
     *
     * @param GetMavenArtifactRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MavenArtifact
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMavenArtifact(GetMavenArtifactRequest $request, array $callOptions = []): MavenArtifact
    {
        return $this->startApiCall('GetMavenArtifact', $request, $callOptions)->wait();
    }

    /**
     * Gets a npm package.
     *
     * The async variant is {@see ArtifactRegistryClient::getNpmPackageAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_npm_package.php
     *
     * @param GetNpmPackageRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NpmPackage
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNpmPackage(GetNpmPackageRequest $request, array $callOptions = []): NpmPackage
    {
        return $this->startApiCall('GetNpmPackage', $request, $callOptions)->wait();
    }

    /**
     * Gets a package.
     *
     * The async variant is {@see ArtifactRegistryClient::getPackageAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_package.php
     *
     * @param GetPackageRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Package
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPackage(GetPackageRequest $request, array $callOptions = []): Package
    {
        return $this->startApiCall('GetPackage', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the Settings for the Project.
     *
     * The async variant is {@see ArtifactRegistryClient::getProjectSettingsAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_project_settings.php
     *
     * @param GetProjectSettingsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProjectSettings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getProjectSettings(GetProjectSettingsRequest $request, array $callOptions = []): ProjectSettings
    {
        return $this->startApiCall('GetProjectSettings', $request, $callOptions)->wait();
    }

    /**
     * Gets a python package.
     *
     * The async variant is {@see ArtifactRegistryClient::getPythonPackageAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_python_package.php
     *
     * @param GetPythonPackageRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PythonPackage
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPythonPackage(GetPythonPackageRequest $request, array $callOptions = []): PythonPackage
    {
        return $this->startApiCall('GetPythonPackage', $request, $callOptions)->wait();
    }

    /**
     * Gets a repository.
     *
     * The async variant is {@see ArtifactRegistryClient::getRepositoryAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_repository.php
     *
     * @param GetRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Repository
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRepository(GetRepositoryRequest $request, array $callOptions = []): Repository
    {
        return $this->startApiCall('GetRepository', $request, $callOptions)->wait();
    }

    /**
     * Gets a rule.
     *
     * The async variant is {@see ArtifactRegistryClient::getRuleAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_rule.php
     *
     * @param GetRuleRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Rule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRule(GetRuleRequest $request, array $callOptions = []): Rule
    {
        return $this->startApiCall('GetRule', $request, $callOptions)->wait();
    }

    /**
     * Gets a tag.
     *
     * The async variant is {@see ArtifactRegistryClient::getTagAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_tag.php
     *
     * @param GetTagRequest $request     A request to house fields associated with the call.
     * @param array         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Tag
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTag(GetTagRequest $request, array $callOptions = []): Tag
    {
        return $this->startApiCall('GetTag', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the VPCSC Config for the Project.
     *
     * The async variant is {@see ArtifactRegistryClient::getVPCSCConfigAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_vpcsc_config.php
     *
     * @param GetVPCSCConfigRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VPCSCConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVPCSCConfig(GetVPCSCConfigRequest $request, array $callOptions = []): VPCSCConfig
    {
        return $this->startApiCall('GetVPCSCConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets a version
     *
     * The async variant is {@see ArtifactRegistryClient::getVersionAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_version.php
     *
     * @param GetVersionRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Version
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVersion(GetVersionRequest $request, array $callOptions = []): Version
    {
        return $this->startApiCall('GetVersion', $request, $callOptions)->wait();
    }

    /**
     * Imports Apt artifacts. The returned Operation will complete once the
     * resources are imported. Package, Version, and File resources are created
     * based on the imported artifacts. Imported artifacts that conflict with
     * existing resources are ignored.
     *
     * The async variant is {@see ArtifactRegistryClient::importAptArtifactsAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/import_apt_artifacts.php
     *
     * @param ImportAptArtifactsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ImportAptArtifactsResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importAptArtifacts(ImportAptArtifactsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ImportAptArtifacts', $request, $callOptions)->wait();
    }

    /**
     * Imports Yum (RPM) artifacts. The returned Operation will complete once the
     * resources are imported. Package, Version, and File resources are created
     * based on the imported artifacts. Imported artifacts that conflict with
     * existing resources are ignored.
     *
     * The async variant is {@see ArtifactRegistryClient::importYumArtifactsAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/import_yum_artifacts.php
     *
     * @param ImportYumArtifactsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ImportYumArtifactsResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importYumArtifacts(ImportYumArtifactsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ImportYumArtifacts', $request, $callOptions)->wait();
    }

    /**
     * Lists attachments.
     *
     * The async variant is {@see ArtifactRegistryClient::listAttachmentsAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/list_attachments.php
     *
     * @param ListAttachmentsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAttachments(ListAttachmentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAttachments', $request, $callOptions);
    }

    /**
     * Lists docker images.
     *
     * The async variant is {@see ArtifactRegistryClient::listDockerImagesAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/list_docker_images.php
     *
     * @param ListDockerImagesRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDockerImages(ListDockerImagesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDockerImages', $request, $callOptions);
    }

    /**
     * Lists files.
     *
     * The async variant is {@see ArtifactRegistryClient::listFilesAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/list_files.php
     *
     * @param ListFilesRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFiles(ListFilesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFiles', $request, $callOptions);
    }

    /**
     * Lists maven artifacts.
     *
     * The async variant is {@see ArtifactRegistryClient::listMavenArtifactsAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/list_maven_artifacts.php
     *
     * @param ListMavenArtifactsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMavenArtifacts(ListMavenArtifactsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMavenArtifacts', $request, $callOptions);
    }

    /**
     * Lists npm packages.
     *
     * The async variant is {@see ArtifactRegistryClient::listNpmPackagesAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/list_npm_packages.php
     *
     * @param ListNpmPackagesRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNpmPackages(ListNpmPackagesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListNpmPackages', $request, $callOptions);
    }

    /**
     * Lists packages.
     *
     * The async variant is {@see ArtifactRegistryClient::listPackagesAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/list_packages.php
     *
     * @param ListPackagesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPackages(ListPackagesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPackages', $request, $callOptions);
    }

    /**
     * Lists python packages.
     *
     * The async variant is {@see ArtifactRegistryClient::listPythonPackagesAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/list_python_packages.php
     *
     * @param ListPythonPackagesRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPythonPackages(ListPythonPackagesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPythonPackages', $request, $callOptions);
    }

    /**
     * Lists repositories.
     *
     * The async variant is {@see ArtifactRegistryClient::listRepositoriesAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/list_repositories.php
     *
     * @param ListRepositoriesRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRepositories(ListRepositoriesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRepositories', $request, $callOptions);
    }

    /**
     * Lists rules.
     *
     * The async variant is {@see ArtifactRegistryClient::listRulesAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/list_rules.php
     *
     * @param ListRulesRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRules(ListRulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRules', $request, $callOptions);
    }

    /**
     * Lists tags.
     *
     * The async variant is {@see ArtifactRegistryClient::listTagsAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/list_tags.php
     *
     * @param ListTagsRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTags(ListTagsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTags', $request, $callOptions);
    }

    /**
     * Lists versions.
     *
     * The async variant is {@see ArtifactRegistryClient::listVersionsAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/list_versions.php
     *
     * @param ListVersionsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listVersions(ListVersionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListVersions', $request, $callOptions);
    }

    /**
     * Updates the IAM policy for a given resource.
     *
     * The async variant is {@see ArtifactRegistryClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Tests if the caller has a list of permissions on a resource.
     *
     * The async variant is {@see ArtifactRegistryClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Updates a file.
     *
     * The async variant is {@see ArtifactRegistryClient::updateFileAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/update_file.php
     *
     * @param UpdateFileRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return File
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateFile(UpdateFileRequest $request, array $callOptions = []): File
    {
        return $this->startApiCall('UpdateFile', $request, $callOptions)->wait();
    }

    /**
     * Updates a package.
     *
     * The async variant is {@see ArtifactRegistryClient::updatePackageAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/update_package.php
     *
     * @param UpdatePackageRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Package
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePackage(UpdatePackageRequest $request, array $callOptions = []): Package
    {
        return $this->startApiCall('UpdatePackage', $request, $callOptions)->wait();
    }

    /**
     * Updates the Settings for the Project.
     *
     * The async variant is {@see ArtifactRegistryClient::updateProjectSettingsAsync()}
     * .
     *
     * @example samples/V1/ArtifactRegistryClient/update_project_settings.php
     *
     * @param UpdateProjectSettingsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProjectSettings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateProjectSettings(
        UpdateProjectSettingsRequest $request,
        array $callOptions = []
    ): ProjectSettings {
        return $this->startApiCall('UpdateProjectSettings', $request, $callOptions)->wait();
    }

    /**
     * Updates a repository.
     *
     * The async variant is {@see ArtifactRegistryClient::updateRepositoryAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/update_repository.php
     *
     * @param UpdateRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Repository
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateRepository(UpdateRepositoryRequest $request, array $callOptions = []): Repository
    {
        return $this->startApiCall('UpdateRepository', $request, $callOptions)->wait();
    }

    /**
     * Updates a rule.
     *
     * The async variant is {@see ArtifactRegistryClient::updateRuleAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/update_rule.php
     *
     * @param UpdateRuleRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Rule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateRule(UpdateRuleRequest $request, array $callOptions = []): Rule
    {
        return $this->startApiCall('UpdateRule', $request, $callOptions)->wait();
    }

    /**
     * Updates a tag.
     *
     * The async variant is {@see ArtifactRegistryClient::updateTagAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/update_tag.php
     *
     * @param UpdateTagRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Tag
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTag(UpdateTagRequest $request, array $callOptions = []): Tag
    {
        return $this->startApiCall('UpdateTag', $request, $callOptions)->wait();
    }

    /**
     * Updates the VPCSC Config for the Project.
     *
     * The async variant is {@see ArtifactRegistryClient::updateVPCSCConfigAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/update_vpcsc_config.php
     *
     * @param UpdateVPCSCConfigRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VPCSCConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateVPCSCConfig(UpdateVPCSCConfigRequest $request, array $callOptions = []): VPCSCConfig
    {
        return $this->startApiCall('UpdateVPCSCConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates a version.
     *
     * The async variant is {@see ArtifactRegistryClient::updateVersionAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/update_version.php
     *
     * @param UpdateVersionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Version
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateVersion(UpdateVersionRequest $request, array $callOptions = []): Version
    {
        return $this->startApiCall('UpdateVersion', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see ArtifactRegistryClient::getLocationAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see ArtifactRegistryClient::listLocationsAsync()} .
     *
     * @example samples/V1/ArtifactRegistryClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
