<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/apps/card/v1/card.proto

namespace Google\Apps\Card\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A field in which users can enter text. Supports suggestions and on-change
 * actions.
 * Supports form submission validation. When `Action.all_widgets_are_required`
 * is set to `true` or this widget is specified in `Action.required_widgets`,
 * the submission action is blocked unless a value is entered. For an example in
 * Google Chat apps, see [Add a field in which a user can enter
 * text](https://developers.google.com/workspace/chat/design-interactive-card-dialog#add_a_field_in_which_a_user_can_enter_text).
 * Chat apps receive and can process the value of entered text during form input
 * events. For details about working with form inputs, see [Receive form
 * data](https://developers.google.com/workspace/chat/read-form-data).
 * When you need to collect undefined or abstract data from users,
 * use a text input. To collect defined or enumerated data from users, use the
 * [SelectionInput][google.apps.card.v1.SelectionInput] widget.
 * [Google Workspace add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 *
 * Generated from protobuf message <code>google.apps.card.v1.TextInput</code>
 */
class TextInput extends \Google\Protobuf\Internal\Message
{
    /**
     * The name by which the text input is identified in a form input event.
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * The text that appears above the text input field in the user interface.
     * Specify text that helps the user enter the information your app needs.
     * For example, if you are asking someone's name, but specifically need their
     * surname, write `surname` instead of `name`.
     * Required if `hintText` is unspecified. Otherwise, optional.
     *
     * Generated from protobuf field <code>string label = 2;</code>
     */
    protected $label = '';
    /**
     * Text that appears below the text input field meant to assist users by
     * prompting them to enter a certain value. This text is always visible.
     * Required if `label` is unspecified. Otherwise, optional.
     *
     * Generated from protobuf field <code>string hint_text = 3;</code>
     */
    protected $hint_text = '';
    /**
     * The value entered by a user, returned as part of a form input event.
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     *
     * Generated from protobuf field <code>string value = 4;</code>
     */
    protected $value = '';
    /**
     * How a text input field appears in the user interface.
     * For example, whether the field is single or multi-line.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.TextInput.Type type = 5;</code>
     */
    protected $type = 0;
    /**
     * What to do when a change occurs in the text input field. For example, a
     * user adding to the field or deleting text.
     * Examples of actions to take include running a custom function or opening
     * a [dialog](https://developers.google.com/workspace/chat/dialogs)
     * in Google Chat.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    protected $on_change_action = null;
    /**
     * Suggested values that users can enter. These values appear when users click
     * inside the text input field. As users type, the suggested values
     * dynamically filter to match what the users have typed.
     * For example, a text input field for programming language might suggest
     * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     * of suggestions filters to show just `Java` and `JavaScript`.
     * Suggested values help guide users to enter values that your app can make
     * sense of. When referring to JavaScript, some users might enter `javascript`
     * and others `java script`. Suggesting `JavaScript` can standardize how users
     * interact with your app.
     * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     * to `MULTIPLE_LINE`.
     * [Google Workspace
     * add-ons and Chat apps](https://developers.google.com/workspace/extend):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
     */
    protected $initial_suggestions = null;
    /**
     * Optional. Specify what action to take when the text input field provides
     * suggestions to users who interact with it.
     * If unspecified, the suggestions are set by `initialSuggestions` and
     * are processed by the client.
     * If specified, the app takes the action specified here, such as running
     * a custom function.
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
     */
    protected $auto_complete_action = null;
    /**
     * Specify the input format validation necessary for this text field.
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Validation validation = 11;</code>
     */
    protected $validation = null;
    /**
     * Text that appears in the text input field when the field is empty.
     * Use this text to prompt users to enter a value. For example, `Enter a
     * number from 0 to 100`.
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     *
     * Generated from protobuf field <code>string placeholder_text = 12;</code>
     */
    protected $placeholder_text = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The name by which the text input is identified in a form input event.
     *           For details about working with form inputs, see [Receive form
     *           data](https://developers.google.com/workspace/chat/read-form-data).
     *     @type string $label
     *           The text that appears above the text input field in the user interface.
     *           Specify text that helps the user enter the information your app needs.
     *           For example, if you are asking someone's name, but specifically need their
     *           surname, write `surname` instead of `name`.
     *           Required if `hintText` is unspecified. Otherwise, optional.
     *     @type string $hint_text
     *           Text that appears below the text input field meant to assist users by
     *           prompting them to enter a certain value. This text is always visible.
     *           Required if `label` is unspecified. Otherwise, optional.
     *     @type string $value
     *           The value entered by a user, returned as part of a form input event.
     *           For details about working with form inputs, see [Receive form
     *           data](https://developers.google.com/workspace/chat/read-form-data).
     *     @type int $type
     *           How a text input field appears in the user interface.
     *           For example, whether the field is single or multi-line.
     *     @type \Google\Apps\Card\V1\Action $on_change_action
     *           What to do when a change occurs in the text input field. For example, a
     *           user adding to the field or deleting text.
     *           Examples of actions to take include running a custom function or opening
     *           a [dialog](https://developers.google.com/workspace/chat/dialogs)
     *           in Google Chat.
     *     @type \Google\Apps\Card\V1\Suggestions $initial_suggestions
     *           Suggested values that users can enter. These values appear when users click
     *           inside the text input field. As users type, the suggested values
     *           dynamically filter to match what the users have typed.
     *           For example, a text input field for programming language might suggest
     *           Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     *           of suggestions filters to show just `Java` and `JavaScript`.
     *           Suggested values help guide users to enter values that your app can make
     *           sense of. When referring to JavaScript, some users might enter `javascript`
     *           and others `java script`. Suggesting `JavaScript` can standardize how users
     *           interact with your app.
     *           When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     *           to `MULTIPLE_LINE`.
     *           [Google Workspace
     *           add-ons and Chat apps](https://developers.google.com/workspace/extend):
     *     @type \Google\Apps\Card\V1\Action $auto_complete_action
     *           Optional. Specify what action to take when the text input field provides
     *           suggestions to users who interact with it.
     *           If unspecified, the suggestions are set by `initialSuggestions` and
     *           are processed by the client.
     *           If specified, the app takes the action specified here, such as running
     *           a custom function.
     *           [Google Workspace
     *           add-ons](https://developers.google.com/workspace/add-ons):
     *     @type \Google\Apps\Card\V1\Validation $validation
     *           Specify the input format validation necessary for this text field.
     *           [Google Workspace add-ons and Chat
     *           apps](https://developers.google.com/workspace/extend):
     *     @type string $placeholder_text
     *           Text that appears in the text input field when the field is empty.
     *           Use this text to prompt users to enter a value. For example, `Enter a
     *           number from 0 to 100`.
     *           [Google Chat apps](https://developers.google.com/workspace/chat):
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Apps\Card\V1\Card::initOnce();
        parent::__construct($data);
    }

    /**
     * The name by which the text input is identified in a form input event.
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name by which the text input is identified in a form input event.
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The text that appears above the text input field in the user interface.
     * Specify text that helps the user enter the information your app needs.
     * For example, if you are asking someone's name, but specifically need their
     * surname, write `surname` instead of `name`.
     * Required if `hintText` is unspecified. Otherwise, optional.
     *
     * Generated from protobuf field <code>string label = 2;</code>
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * The text that appears above the text input field in the user interface.
     * Specify text that helps the user enter the information your app needs.
     * For example, if you are asking someone's name, but specifically need their
     * surname, write `surname` instead of `name`.
     * Required if `hintText` is unspecified. Otherwise, optional.
     *
     * Generated from protobuf field <code>string label = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->label = $var;

        return $this;
    }

    /**
     * Text that appears below the text input field meant to assist users by
     * prompting them to enter a certain value. This text is always visible.
     * Required if `label` is unspecified. Otherwise, optional.
     *
     * Generated from protobuf field <code>string hint_text = 3;</code>
     * @return string
     */
    public function getHintText()
    {
        return $this->hint_text;
    }

    /**
     * Text that appears below the text input field meant to assist users by
     * prompting them to enter a certain value. This text is always visible.
     * Required if `label` is unspecified. Otherwise, optional.
     *
     * Generated from protobuf field <code>string hint_text = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setHintText($var)
    {
        GPBUtil::checkString($var, True);
        $this->hint_text = $var;

        return $this;
    }

    /**
     * The value entered by a user, returned as part of a form input event.
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     *
     * Generated from protobuf field <code>string value = 4;</code>
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * The value entered by a user, returned as part of a form input event.
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     *
     * Generated from protobuf field <code>string value = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setValue($var)
    {
        GPBUtil::checkString($var, True);
        $this->value = $var;

        return $this;
    }

    /**
     * How a text input field appears in the user interface.
     * For example, whether the field is single or multi-line.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.TextInput.Type type = 5;</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * How a text input field appears in the user interface.
     * For example, whether the field is single or multi-line.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.TextInput.Type type = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Card\V1\TextInput\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * What to do when a change occurs in the text input field. For example, a
     * user adding to the field or deleting text.
     * Examples of actions to take include running a custom function or opening
     * a [dialog](https://developers.google.com/workspace/chat/dialogs)
     * in Google Chat.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     * @return \Google\Apps\Card\V1\Action|null
     */
    public function getOnChangeAction()
    {
        return $this->on_change_action;
    }

    public function hasOnChangeAction()
    {
        return isset($this->on_change_action);
    }

    public function clearOnChangeAction()
    {
        unset($this->on_change_action);
    }

    /**
     * What to do when a change occurs in the text input field. For example, a
     * user adding to the field or deleting text.
     * Examples of actions to take include running a custom function or opening
     * a [dialog](https://developers.google.com/workspace/chat/dialogs)
     * in Google Chat.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     * @param \Google\Apps\Card\V1\Action $var
     * @return $this
     */
    public function setOnChangeAction($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Action::class);
        $this->on_change_action = $var;

        return $this;
    }

    /**
     * Suggested values that users can enter. These values appear when users click
     * inside the text input field. As users type, the suggested values
     * dynamically filter to match what the users have typed.
     * For example, a text input field for programming language might suggest
     * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     * of suggestions filters to show just `Java` and `JavaScript`.
     * Suggested values help guide users to enter values that your app can make
     * sense of. When referring to JavaScript, some users might enter `javascript`
     * and others `java script`. Suggesting `JavaScript` can standardize how users
     * interact with your app.
     * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     * to `MULTIPLE_LINE`.
     * [Google Workspace
     * add-ons and Chat apps](https://developers.google.com/workspace/extend):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
     * @return \Google\Apps\Card\V1\Suggestions|null
     */
    public function getInitialSuggestions()
    {
        return $this->initial_suggestions;
    }

    public function hasInitialSuggestions()
    {
        return isset($this->initial_suggestions);
    }

    public function clearInitialSuggestions()
    {
        unset($this->initial_suggestions);
    }

    /**
     * Suggested values that users can enter. These values appear when users click
     * inside the text input field. As users type, the suggested values
     * dynamically filter to match what the users have typed.
     * For example, a text input field for programming language might suggest
     * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     * of suggestions filters to show just `Java` and `JavaScript`.
     * Suggested values help guide users to enter values that your app can make
     * sense of. When referring to JavaScript, some users might enter `javascript`
     * and others `java script`. Suggesting `JavaScript` can standardize how users
     * interact with your app.
     * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     * to `MULTIPLE_LINE`.
     * [Google Workspace
     * add-ons and Chat apps](https://developers.google.com/workspace/extend):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
     * @param \Google\Apps\Card\V1\Suggestions $var
     * @return $this
     */
    public function setInitialSuggestions($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Suggestions::class);
        $this->initial_suggestions = $var;

        return $this;
    }

    /**
     * Optional. Specify what action to take when the text input field provides
     * suggestions to users who interact with it.
     * If unspecified, the suggestions are set by `initialSuggestions` and
     * are processed by the client.
     * If specified, the app takes the action specified here, such as running
     * a custom function.
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
     * @return \Google\Apps\Card\V1\Action|null
     */
    public function getAutoCompleteAction()
    {
        return $this->auto_complete_action;
    }

    public function hasAutoCompleteAction()
    {
        return isset($this->auto_complete_action);
    }

    public function clearAutoCompleteAction()
    {
        unset($this->auto_complete_action);
    }

    /**
     * Optional. Specify what action to take when the text input field provides
     * suggestions to users who interact with it.
     * If unspecified, the suggestions are set by `initialSuggestions` and
     * are processed by the client.
     * If specified, the app takes the action specified here, such as running
     * a custom function.
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
     * @param \Google\Apps\Card\V1\Action $var
     * @return $this
     */
    public function setAutoCompleteAction($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Action::class);
        $this->auto_complete_action = $var;

        return $this;
    }

    /**
     * Specify the input format validation necessary for this text field.
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Validation validation = 11;</code>
     * @return \Google\Apps\Card\V1\Validation|null
     */
    public function getValidation()
    {
        return $this->validation;
    }

    public function hasValidation()
    {
        return isset($this->validation);
    }

    public function clearValidation()
    {
        unset($this->validation);
    }

    /**
     * Specify the input format validation necessary for this text field.
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Validation validation = 11;</code>
     * @param \Google\Apps\Card\V1\Validation $var
     * @return $this
     */
    public function setValidation($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Validation::class);
        $this->validation = $var;

        return $this;
    }

    /**
     * Text that appears in the text input field when the field is empty.
     * Use this text to prompt users to enter a value. For example, `Enter a
     * number from 0 to 100`.
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     *
     * Generated from protobuf field <code>string placeholder_text = 12;</code>
     * @return string
     */
    public function getPlaceholderText()
    {
        return $this->placeholder_text;
    }

    /**
     * Text that appears in the text input field when the field is empty.
     * Use this text to prompt users to enter a value. For example, `Enter a
     * number from 0 to 100`.
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     *
     * Generated from protobuf field <code>string placeholder_text = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setPlaceholderText($var)
    {
        GPBUtil::checkString($var, True);
        $this->placeholder_text = $var;

        return $this;
    }

}

