<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/admanager/v1/ad_review_center_ad_service.proto

namespace Google\Ads\AdManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request object for `SearchAdReviewCenterAds` method.
 *
 * Generated from protobuf message <code>google.ads.admanager.v1.SearchAdReviewCenterAdsRequest</code>
 */
class SearchAdReviewCenterAdsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent, which owns this collection of AdReviewCenterAds.
     * Format: networks/{network_code}/webProperties/{web_property_code}
     * Since a network can only have a single web property of each
     * `ExchangeSyndicationProduct`, you can use the
     * `ExchangeSyndicationProduct` as an alias for the web property code:
     * `networks/{network_code}/webProperties/display`
     * `networks/{network_code}/webProperties/videoAndAudio`
     * `networks/{network_code}/webProperties/mobileApp`
     * `networks/{network_code}/webProperties/games`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Optional. The maximum number of AdReviewCenterAds to return. The service
     * may return fewer than this value. If unspecified, at most 50
     * AdReviewCenterAds will be returned. The maximum value is 1000; values
     * greater than 1000 will be coerced to 1000.
     *
     * Generated from protobuf field <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_size = 0;
    /**
     * Optional. The page token to fetch the next page of AdReviewCenterAds. This
     * is the value returned from a previous Search request, or empty.
     *
     * Generated from protobuf field <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_token = '';
    /**
     * Required. Only return ads with the given status.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.AdReviewCenterAdStatusEnum.AdReviewCenterAdStatus status = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $status = 0;
    /**
     * Optional. If provided, only return ads with the given AdReviewCenterAd IDs.
     *
     * Generated from protobuf field <code>repeated string ad_review_center_ad_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $ad_review_center_ad_id;
    /**
     * Optional. If provided, only return ads that served within the given date
     * range (inclusive). The  date range must be within the last 30 days. If not
     * provided, the date range will be the last 30 days.
     *
     * Generated from protobuf field <code>.google.type.Interval date_time_range = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $date_time_range = null;
    /**
     * Optional. If provided, restrict the search to AdReviewCenterAds associated
     * with the text (including any text on the ad or in the destination URL). If
     * more than one value is provided, the search will combine them in a logical
     * AND. For example, ['car', 'blue'] will match ads that contain both "car"
     * and "blue", but not an ad that only contains "car".
     *
     * Generated from protobuf field <code>repeated string search_text = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $search_text;
    /**
     * Optional. If provided, restrict the search to creatives belonging to one of
     * the given Adx buyer account IDs. Only applicable to RTB creatives. Adx
     * buyer account IDs can be found via the ProgrammaticBuyerService.
     *
     * Generated from protobuf field <code>repeated int64 buyer_account_id = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $buyer_account_id;

    /**
     * @param string $parent Required. The parent, which owns this collection of AdReviewCenterAds.
     *                       Format: networks/{network_code}/webProperties/{web_property_code}
     *
     *                       Since a network can only have a single web property of each
     *                       `ExchangeSyndicationProduct`, you can use the
     *                       `ExchangeSyndicationProduct` as an alias for the web property code:
     *
     *                       `networks/{network_code}/webProperties/display`
     *
     *                       `networks/{network_code}/webProperties/videoAndAudio`
     *
     *                       `networks/{network_code}/webProperties/mobileApp`
     *
     *                       `networks/{network_code}/webProperties/games`
     *                       Please see {@see AdReviewCenterAdServiceClient::webPropertyName()} for help formatting this field.
     *
     * @return \Google\Ads\AdManager\V1\SearchAdReviewCenterAdsRequest
     *
     * @experimental
     */
    public static function build(string $parent): self
    {
        return (new self())
            ->setParent($parent);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent, which owns this collection of AdReviewCenterAds.
     *           Format: networks/{network_code}/webProperties/{web_property_code}
     *           Since a network can only have a single web property of each
     *           `ExchangeSyndicationProduct`, you can use the
     *           `ExchangeSyndicationProduct` as an alias for the web property code:
     *           `networks/{network_code}/webProperties/display`
     *           `networks/{network_code}/webProperties/videoAndAudio`
     *           `networks/{network_code}/webProperties/mobileApp`
     *           `networks/{network_code}/webProperties/games`
     *     @type int $page_size
     *           Optional. The maximum number of AdReviewCenterAds to return. The service
     *           may return fewer than this value. If unspecified, at most 50
     *           AdReviewCenterAds will be returned. The maximum value is 1000; values
     *           greater than 1000 will be coerced to 1000.
     *     @type string $page_token
     *           Optional. The page token to fetch the next page of AdReviewCenterAds. This
     *           is the value returned from a previous Search request, or empty.
     *     @type int $status
     *           Required. Only return ads with the given status.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $ad_review_center_ad_id
     *           Optional. If provided, only return ads with the given AdReviewCenterAd IDs.
     *     @type \Google\Type\Interval $date_time_range
     *           Optional. If provided, only return ads that served within the given date
     *           range (inclusive). The  date range must be within the last 30 days. If not
     *           provided, the date range will be the last 30 days.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $search_text
     *           Optional. If provided, restrict the search to AdReviewCenterAds associated
     *           with the text (including any text on the ad or in the destination URL). If
     *           more than one value is provided, the search will combine them in a logical
     *           AND. For example, ['car', 'blue'] will match ads that contain both "car"
     *           and "blue", but not an ad that only contains "car".
     *     @type array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $buyer_account_id
     *           Optional. If provided, restrict the search to creatives belonging to one of
     *           the given Adx buyer account IDs. Only applicable to RTB creatives. Adx
     *           buyer account IDs can be found via the ProgrammaticBuyerService.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\Admanager\V1\AdReviewCenterAdService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent, which owns this collection of AdReviewCenterAds.
     * Format: networks/{network_code}/webProperties/{web_property_code}
     * Since a network can only have a single web property of each
     * `ExchangeSyndicationProduct`, you can use the
     * `ExchangeSyndicationProduct` as an alias for the web property code:
     * `networks/{network_code}/webProperties/display`
     * `networks/{network_code}/webProperties/videoAndAudio`
     * `networks/{network_code}/webProperties/mobileApp`
     * `networks/{network_code}/webProperties/games`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent, which owns this collection of AdReviewCenterAds.
     * Format: networks/{network_code}/webProperties/{web_property_code}
     * Since a network can only have a single web property of each
     * `ExchangeSyndicationProduct`, you can use the
     * `ExchangeSyndicationProduct` as an alias for the web property code:
     * `networks/{network_code}/webProperties/display`
     * `networks/{network_code}/webProperties/videoAndAudio`
     * `networks/{network_code}/webProperties/mobileApp`
     * `networks/{network_code}/webProperties/games`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Optional. The maximum number of AdReviewCenterAds to return. The service
     * may return fewer than this value. If unspecified, at most 50
     * AdReviewCenterAds will be returned. The maximum value is 1000; values
     * greater than 1000 will be coerced to 1000.
     *
     * Generated from protobuf field <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Optional. The maximum number of AdReviewCenterAds to return. The service
     * may return fewer than this value. If unspecified, at most 50
     * AdReviewCenterAds will be returned. The maximum value is 1000; values
     * greater than 1000 will be coerced to 1000.
     *
     * Generated from protobuf field <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * Optional. The page token to fetch the next page of AdReviewCenterAds. This
     * is the value returned from a previous Search request, or empty.
     *
     * Generated from protobuf field <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * Optional. The page token to fetch the next page of AdReviewCenterAds. This
     * is the value returned from a previous Search request, or empty.
     *
     * Generated from protobuf field <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * Required. Only return ads with the given status.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.AdReviewCenterAdStatusEnum.AdReviewCenterAdStatus status = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Required. Only return ads with the given status.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.AdReviewCenterAdStatusEnum.AdReviewCenterAdStatus status = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\AdManager\V1\AdReviewCenterAdStatusEnum\AdReviewCenterAdStatus::class);
        $this->status = $var;

        return $this;
    }

    /**
     * Optional. If provided, only return ads with the given AdReviewCenterAd IDs.
     *
     * Generated from protobuf field <code>repeated string ad_review_center_ad_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdReviewCenterAdId()
    {
        return $this->ad_review_center_ad_id;
    }

    /**
     * Optional. If provided, only return ads with the given AdReviewCenterAd IDs.
     *
     * Generated from protobuf field <code>repeated string ad_review_center_ad_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdReviewCenterAdId($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->ad_review_center_ad_id = $arr;

        return $this;
    }

    /**
     * Optional. If provided, only return ads that served within the given date
     * range (inclusive). The  date range must be within the last 30 days. If not
     * provided, the date range will be the last 30 days.
     *
     * Generated from protobuf field <code>.google.type.Interval date_time_range = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Type\Interval|null
     */
    public function getDateTimeRange()
    {
        return $this->date_time_range;
    }

    public function hasDateTimeRange()
    {
        return isset($this->date_time_range);
    }

    public function clearDateTimeRange()
    {
        unset($this->date_time_range);
    }

    /**
     * Optional. If provided, only return ads that served within the given date
     * range (inclusive). The  date range must be within the last 30 days. If not
     * provided, the date range will be the last 30 days.
     *
     * Generated from protobuf field <code>.google.type.Interval date_time_range = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Type\Interval $var
     * @return $this
     */
    public function setDateTimeRange($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Interval::class);
        $this->date_time_range = $var;

        return $this;
    }

    /**
     * Optional. If provided, restrict the search to AdReviewCenterAds associated
     * with the text (including any text on the ad or in the destination URL). If
     * more than one value is provided, the search will combine them in a logical
     * AND. For example, ['car', 'blue'] will match ads that contain both "car"
     * and "blue", but not an ad that only contains "car".
     *
     * Generated from protobuf field <code>repeated string search_text = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSearchText()
    {
        return $this->search_text;
    }

    /**
     * Optional. If provided, restrict the search to AdReviewCenterAds associated
     * with the text (including any text on the ad or in the destination URL). If
     * more than one value is provided, the search will combine them in a logical
     * AND. For example, ['car', 'blue'] will match ads that contain both "car"
     * and "blue", but not an ad that only contains "car".
     *
     * Generated from protobuf field <code>repeated string search_text = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSearchText($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->search_text = $arr;

        return $this;
    }

    /**
     * Optional. If provided, restrict the search to creatives belonging to one of
     * the given Adx buyer account IDs. Only applicable to RTB creatives. Adx
     * buyer account IDs can be found via the ProgrammaticBuyerService.
     *
     * Generated from protobuf field <code>repeated int64 buyer_account_id = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBuyerAccountId()
    {
        return $this->buyer_account_id;
    }

    /**
     * Optional. If provided, restrict the search to creatives belonging to one of
     * the given Adx buyer account IDs. Only applicable to RTB creatives. Adx
     * buyer account IDs can be found via the ProgrammaticBuyerService.
     *
     * Generated from protobuf field <code>repeated int64 buyer_account_id = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBuyerAccountId($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::INT64);
        $this->buyer_account_id = $arr;

        return $this;
    }

}

