<?php
/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/securitycenter/v1/securitycenter_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\SecurityCenter\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\SecurityCenter\V1\BatchCreateResourceValueConfigsRequest;
use Google\Cloud\SecurityCenter\V1\BatchCreateResourceValueConfigsResponse;
use Google\Cloud\SecurityCenter\V1\BigQueryExport;
use Google\Cloud\SecurityCenter\V1\BulkMuteFindingsRequest;
use Google\Cloud\SecurityCenter\V1\CreateBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V1\CreateEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\CreateFindingRequest;
use Google\Cloud\SecurityCenter\V1\CreateMuteConfigRequest;
use Google\Cloud\SecurityCenter\V1\CreateNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V1\CreateResourceValueConfigRequest;
use Google\Cloud\SecurityCenter\V1\CreateSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\CreateSourceRequest;
use Google\Cloud\SecurityCenter\V1\CustomConfig;
use Google\Cloud\SecurityCenter\V1\DeleteBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V1\DeleteEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\DeleteMuteConfigRequest;
use Google\Cloud\SecurityCenter\V1\DeleteNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V1\DeleteResourceValueConfigRequest;
use Google\Cloud\SecurityCenter\V1\DeleteSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\EffectiveEventThreatDetectionCustomModule;
use Google\Cloud\SecurityCenter\V1\EffectiveSecurityHealthAnalyticsCustomModule;
use Google\Cloud\SecurityCenter\V1\EventThreatDetectionCustomModule;
use Google\Cloud\SecurityCenter\V1\ExternalSystem;
use Google\Cloud\SecurityCenter\V1\Finding;
use Google\Cloud\SecurityCenter\V1\Finding\Mute;
use Google\Cloud\SecurityCenter\V1\Finding\State;
use Google\Cloud\SecurityCenter\V1\GetBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V1\GetEffectiveEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\GetEffectiveSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\GetEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\GetMuteConfigRequest;
use Google\Cloud\SecurityCenter\V1\GetNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V1\GetOrganizationSettingsRequest;
use Google\Cloud\SecurityCenter\V1\GetResourceValueConfigRequest;
use Google\Cloud\SecurityCenter\V1\GetSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\GetSimulationRequest;
use Google\Cloud\SecurityCenter\V1\GetSourceRequest;
use Google\Cloud\SecurityCenter\V1\GetValuedResourceRequest;
use Google\Cloud\SecurityCenter\V1\GroupAssetsRequest;
use Google\Cloud\SecurityCenter\V1\GroupAssetsResponse;
use Google\Cloud\SecurityCenter\V1\GroupFindingsRequest;
use Google\Cloud\SecurityCenter\V1\GroupFindingsResponse;
use Google\Cloud\SecurityCenter\V1\ListAssetsRequest;
use Google\Cloud\SecurityCenter\V1\ListAssetsResponse;
use Google\Cloud\SecurityCenter\V1\ListAttackPathsRequest;
use Google\Cloud\SecurityCenter\V1\ListAttackPathsResponse;
use Google\Cloud\SecurityCenter\V1\ListBigQueryExportsRequest;
use Google\Cloud\SecurityCenter\V1\ListBigQueryExportsResponse;
use Google\Cloud\SecurityCenter\V1\ListDescendantEventThreatDetectionCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListDescendantEventThreatDetectionCustomModulesResponse;
use Google\Cloud\SecurityCenter\V1\ListDescendantSecurityHealthAnalyticsCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListDescendantSecurityHealthAnalyticsCustomModulesResponse;
use Google\Cloud\SecurityCenter\V1\ListEffectiveEventThreatDetectionCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListEffectiveEventThreatDetectionCustomModulesResponse;
use Google\Cloud\SecurityCenter\V1\ListEffectiveSecurityHealthAnalyticsCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListEffectiveSecurityHealthAnalyticsCustomModulesResponse;
use Google\Cloud\SecurityCenter\V1\ListEventThreatDetectionCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListEventThreatDetectionCustomModulesResponse;
use Google\Cloud\SecurityCenter\V1\ListFindingsRequest;
use Google\Cloud\SecurityCenter\V1\ListFindingsResponse;
use Google\Cloud\SecurityCenter\V1\ListMuteConfigsRequest;
use Google\Cloud\SecurityCenter\V1\ListMuteConfigsResponse;
use Google\Cloud\SecurityCenter\V1\ListNotificationConfigsRequest;
use Google\Cloud\SecurityCenter\V1\ListNotificationConfigsResponse;
use Google\Cloud\SecurityCenter\V1\ListResourceValueConfigsRequest;
use Google\Cloud\SecurityCenter\V1\ListResourceValueConfigsResponse;
use Google\Cloud\SecurityCenter\V1\ListSecurityHealthAnalyticsCustomModulesRequest;
use Google\Cloud\SecurityCenter\V1\ListSecurityHealthAnalyticsCustomModulesResponse;
use Google\Cloud\SecurityCenter\V1\ListSourcesRequest;
use Google\Cloud\SecurityCenter\V1\ListSourcesResponse;
use Google\Cloud\SecurityCenter\V1\ListValuedResourcesRequest;
use Google\Cloud\SecurityCenter\V1\ListValuedResourcesResponse;
use Google\Cloud\SecurityCenter\V1\MuteConfig;
use Google\Cloud\SecurityCenter\V1\NotificationConfig;
use Google\Cloud\SecurityCenter\V1\OrganizationSettings;
use Google\Cloud\SecurityCenter\V1\ResourceValueConfig;
use Google\Cloud\SecurityCenter\V1\RunAssetDiscoveryRequest;
use Google\Cloud\SecurityCenter\V1\SecurityHealthAnalyticsCustomModule;
use Google\Cloud\SecurityCenter\V1\SecurityMarks;
use Google\Cloud\SecurityCenter\V1\SetFindingStateRequest;
use Google\Cloud\SecurityCenter\V1\SetMuteRequest;
use Google\Cloud\SecurityCenter\V1\SimulateSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\SimulateSecurityHealthAnalyticsCustomModuleRequest\SimulatedResource;
use Google\Cloud\SecurityCenter\V1\SimulateSecurityHealthAnalyticsCustomModuleResponse;
use Google\Cloud\SecurityCenter\V1\Simulation;
use Google\Cloud\SecurityCenter\V1\Source;
use Google\Cloud\SecurityCenter\V1\UpdateBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V1\UpdateEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\UpdateExternalSystemRequest;
use Google\Cloud\SecurityCenter\V1\UpdateFindingRequest;
use Google\Cloud\SecurityCenter\V1\UpdateMuteConfigRequest;
use Google\Cloud\SecurityCenter\V1\UpdateNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V1\UpdateOrganizationSettingsRequest;
use Google\Cloud\SecurityCenter\V1\UpdateResourceValueConfigRequest;
use Google\Cloud\SecurityCenter\V1\UpdateSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\UpdateSecurityMarksRequest;
use Google\Cloud\SecurityCenter\V1\UpdateSourceRequest;
use Google\Cloud\SecurityCenter\V1\ValidateEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenter\V1\ValidateEventThreatDetectionCustomModuleResponse;
use Google\Cloud\SecurityCenter\V1\ValuedResource;
use Google\LongRunning\Operation;
use Google\Protobuf\Duration;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;
use Google\Protobuf\Timestamp;

/**
 * Service Description: V1 APIs for Security Center service.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $securityCenterClient = new SecurityCenterClient();
 * try {
 *     $formattedParent = $securityCenterClient->organizationName('[ORGANIZATION]');
 *     $requests = [];
 *     $response = $securityCenterClient->batchCreateResourceValueConfigs($formattedParent, $requests);
 * } finally {
 *     $securityCenterClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\SecurityCenter\V1\Client\SecurityCenterClient}.
 */
class SecurityCenterGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.securitycenter.v1.SecurityCenter';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'securitycenter.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'securitycenter.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $bigQueryExportNameTemplate;

    private static $dlpJobNameTemplate;

    private static $effectiveEventThreatDetectionCustomModuleNameTemplate;

    private static $effectiveSecurityHealthAnalyticsCustomModuleNameTemplate;

    private static $eventThreatDetectionCustomModuleNameTemplate;

    private static $eventThreatDetectionSettingsNameTemplate;

    private static $externalSystemNameTemplate;

    private static $findingNameTemplate;

    private static $folderNameTemplate;

    private static $folderAssetSecurityMarksNameTemplate;

    private static $folderConstraintNameNameTemplate;

    private static $folderCustomModuleNameTemplate;

    private static $folderEffectiveCustomModuleNameTemplate;

    private static $folderEventThreatDetectionSettingsNameTemplate;

    private static $folderExportNameTemplate;

    private static $folderLocationNameTemplate;

    private static $folderLocationMuteConfigNameTemplate;

    private static $folderModuleNameTemplate;

    private static $folderMuteConfigNameTemplate;

    private static $folderNotificationConfigNameTemplate;

    private static $folderSecurityHealthAnalyticsSettingsNameTemplate;

    private static $folderSourceNameTemplate;

    private static $folderSourceFindingNameTemplate;

    private static $folderSourceFindingExternalsystemNameTemplate;

    private static $folderSourceFindingSecurityMarksNameTemplate;

    private static $locationNameTemplate;

    private static $muteConfigNameTemplate;

    private static $notificationConfigNameTemplate;

    private static $organizationNameTemplate;

    private static $organizationAssetSecurityMarksNameTemplate;

    private static $organizationConstraintNameNameTemplate;

    private static $organizationCustomModuleNameTemplate;

    private static $organizationEffectiveCustomModuleNameTemplate;

    private static $organizationEventThreatDetectionSettingsNameTemplate;

    private static $organizationExportNameTemplate;

    private static $organizationLocationNameTemplate;

    private static $organizationLocationMuteConfigNameTemplate;

    private static $organizationModuleNameTemplate;

    private static $organizationMuteConfigNameTemplate;

    private static $organizationNotificationConfigNameTemplate;

    private static $organizationSecurityHealthAnalyticsSettingsNameTemplate;

    private static $organizationSettingsNameTemplate;

    private static $organizationSourceNameTemplate;

    private static $organizationSourceFindingNameTemplate;

    private static $organizationSourceFindingExternalsystemNameTemplate;

    private static $organizationSourceFindingSecurityMarksNameTemplate;

    private static $policyNameTemplate;

    private static $projectNameTemplate;

    private static $projectAssetSecurityMarksNameTemplate;

    private static $projectConstraintNameNameTemplate;

    private static $projectCustomModuleNameTemplate;

    private static $projectDlpJobNameTemplate;

    private static $projectEffectiveCustomModuleNameTemplate;

    private static $projectEventThreatDetectionSettingsNameTemplate;

    private static $projectExportNameTemplate;

    private static $projectLocationDlpJobNameTemplate;

    private static $projectLocationMuteConfigNameTemplate;

    private static $projectLocationTableProfileNameTemplate;

    private static $projectModuleNameTemplate;

    private static $projectMuteConfigNameTemplate;

    private static $projectNotificationConfigNameTemplate;

    private static $projectSecurityHealthAnalyticsSettingsNameTemplate;

    private static $projectSourceNameTemplate;

    private static $projectSourceFindingNameTemplate;

    private static $projectSourceFindingExternalsystemNameTemplate;

    private static $projectSourceFindingSecurityMarksNameTemplate;

    private static $projectTableProfileNameTemplate;

    private static $resourceValueConfigNameTemplate;

    private static $securityHealthAnalyticsCustomModuleNameTemplate;

    private static $securityHealthAnalyticsSettingsNameTemplate;

    private static $securityMarksNameTemplate;

    private static $simulationNameTemplate;

    private static $sourceNameTemplate;

    private static $tableDataProfileNameTemplate;

    private static $topicNameTemplate;

    private static $valuedResourceNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/security_center_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/security_center_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/security_center_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/security_center_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getBigQueryExportNameTemplate()
    {
        if (self::$bigQueryExportNameTemplate == null) {
            self::$bigQueryExportNameTemplate = new PathTemplate('organizations/{organization}/bigQueryExports/{export}');
        }

        return self::$bigQueryExportNameTemplate;
    }

    private static function getDlpJobNameTemplate()
    {
        if (self::$dlpJobNameTemplate == null) {
            self::$dlpJobNameTemplate = new PathTemplate('projects/{project}/dlpJobs/{dlp_job}');
        }

        return self::$dlpJobNameTemplate;
    }

    private static function getEffectiveEventThreatDetectionCustomModuleNameTemplate()
    {
        if (self::$effectiveEventThreatDetectionCustomModuleNameTemplate == null) {
            self::$effectiveEventThreatDetectionCustomModuleNameTemplate = new PathTemplate('organizations/{organization}/eventThreatDetectionSettings/effectiveCustomModules/{module}');
        }

        return self::$effectiveEventThreatDetectionCustomModuleNameTemplate;
    }

    private static function getEffectiveSecurityHealthAnalyticsCustomModuleNameTemplate()
    {
        if (self::$effectiveSecurityHealthAnalyticsCustomModuleNameTemplate == null) {
            self::$effectiveSecurityHealthAnalyticsCustomModuleNameTemplate = new PathTemplate('organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}');
        }

        return self::$effectiveSecurityHealthAnalyticsCustomModuleNameTemplate;
    }

    private static function getEventThreatDetectionCustomModuleNameTemplate()
    {
        if (self::$eventThreatDetectionCustomModuleNameTemplate == null) {
            self::$eventThreatDetectionCustomModuleNameTemplate = new PathTemplate('organizations/{organization}/eventThreatDetectionSettings/customModules/{module}');
        }

        return self::$eventThreatDetectionCustomModuleNameTemplate;
    }

    private static function getEventThreatDetectionSettingsNameTemplate()
    {
        if (self::$eventThreatDetectionSettingsNameTemplate == null) {
            self::$eventThreatDetectionSettingsNameTemplate = new PathTemplate('organizations/{organization}/eventThreatDetectionSettings');
        }

        return self::$eventThreatDetectionSettingsNameTemplate;
    }

    private static function getExternalSystemNameTemplate()
    {
        if (self::$externalSystemNameTemplate == null) {
            self::$externalSystemNameTemplate = new PathTemplate('organizations/{organization}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}');
        }

        return self::$externalSystemNameTemplate;
    }

    private static function getFindingNameTemplate()
    {
        if (self::$findingNameTemplate == null) {
            self::$findingNameTemplate = new PathTemplate('organizations/{organization}/sources/{source}/findings/{finding}');
        }

        return self::$findingNameTemplate;
    }

    private static function getFolderNameTemplate()
    {
        if (self::$folderNameTemplate == null) {
            self::$folderNameTemplate = new PathTemplate('folders/{folder}');
        }

        return self::$folderNameTemplate;
    }

    private static function getFolderAssetSecurityMarksNameTemplate()
    {
        if (self::$folderAssetSecurityMarksNameTemplate == null) {
            self::$folderAssetSecurityMarksNameTemplate = new PathTemplate('folders/{folder}/assets/{asset}/securityMarks');
        }

        return self::$folderAssetSecurityMarksNameTemplate;
    }

    private static function getFolderConstraintNameNameTemplate()
    {
        if (self::$folderConstraintNameNameTemplate == null) {
            self::$folderConstraintNameNameTemplate = new PathTemplate('folders/{folder}/policies/{constraint_name}');
        }

        return self::$folderConstraintNameNameTemplate;
    }

    private static function getFolderCustomModuleNameTemplate()
    {
        if (self::$folderCustomModuleNameTemplate == null) {
            self::$folderCustomModuleNameTemplate = new PathTemplate('folders/{folder}/securityHealthAnalyticsSettings/customModules/{custom_module}');
        }

        return self::$folderCustomModuleNameTemplate;
    }

    private static function getFolderEffectiveCustomModuleNameTemplate()
    {
        if (self::$folderEffectiveCustomModuleNameTemplate == null) {
            self::$folderEffectiveCustomModuleNameTemplate = new PathTemplate('folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}');
        }

        return self::$folderEffectiveCustomModuleNameTemplate;
    }

    private static function getFolderEventThreatDetectionSettingsNameTemplate()
    {
        if (self::$folderEventThreatDetectionSettingsNameTemplate == null) {
            self::$folderEventThreatDetectionSettingsNameTemplate = new PathTemplate('folders/{folder}/eventThreatDetectionSettings');
        }

        return self::$folderEventThreatDetectionSettingsNameTemplate;
    }

    private static function getFolderExportNameTemplate()
    {
        if (self::$folderExportNameTemplate == null) {
            self::$folderExportNameTemplate = new PathTemplate('folders/{folder}/bigQueryExports/{export}');
        }

        return self::$folderExportNameTemplate;
    }

    private static function getFolderLocationNameTemplate()
    {
        if (self::$folderLocationNameTemplate == null) {
            self::$folderLocationNameTemplate = new PathTemplate('folders/{folder}/locations/{location}');
        }

        return self::$folderLocationNameTemplate;
    }

    private static function getFolderLocationMuteConfigNameTemplate()
    {
        if (self::$folderLocationMuteConfigNameTemplate == null) {
            self::$folderLocationMuteConfigNameTemplate = new PathTemplate('folders/{folder}/locations/{location}/muteConfigs/{mute_config}');
        }

        return self::$folderLocationMuteConfigNameTemplate;
    }

    private static function getFolderModuleNameTemplate()
    {
        if (self::$folderModuleNameTemplate == null) {
            self::$folderModuleNameTemplate = new PathTemplate('folders/{folder}/eventThreatDetectionSettings/customModules/{module}');
        }

        return self::$folderModuleNameTemplate;
    }

    private static function getFolderMuteConfigNameTemplate()
    {
        if (self::$folderMuteConfigNameTemplate == null) {
            self::$folderMuteConfigNameTemplate = new PathTemplate('folders/{folder}/muteConfigs/{mute_config}');
        }

        return self::$folderMuteConfigNameTemplate;
    }

    private static function getFolderNotificationConfigNameTemplate()
    {
        if (self::$folderNotificationConfigNameTemplate == null) {
            self::$folderNotificationConfigNameTemplate = new PathTemplate('folders/{folder}/notificationConfigs/{notification_config}');
        }

        return self::$folderNotificationConfigNameTemplate;
    }

    private static function getFolderSecurityHealthAnalyticsSettingsNameTemplate()
    {
        if (self::$folderSecurityHealthAnalyticsSettingsNameTemplate == null) {
            self::$folderSecurityHealthAnalyticsSettingsNameTemplate = new PathTemplate('folders/{folder}/securityHealthAnalyticsSettings');
        }

        return self::$folderSecurityHealthAnalyticsSettingsNameTemplate;
    }

    private static function getFolderSourceNameTemplate()
    {
        if (self::$folderSourceNameTemplate == null) {
            self::$folderSourceNameTemplate = new PathTemplate('folders/{folder}/sources/{source}');
        }

        return self::$folderSourceNameTemplate;
    }

    private static function getFolderSourceFindingNameTemplate()
    {
        if (self::$folderSourceFindingNameTemplate == null) {
            self::$folderSourceFindingNameTemplate = new PathTemplate('folders/{folder}/sources/{source}/findings/{finding}');
        }

        return self::$folderSourceFindingNameTemplate;
    }

    private static function getFolderSourceFindingExternalsystemNameTemplate()
    {
        if (self::$folderSourceFindingExternalsystemNameTemplate == null) {
            self::$folderSourceFindingExternalsystemNameTemplate = new PathTemplate('folders/{folder}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}');
        }

        return self::$folderSourceFindingExternalsystemNameTemplate;
    }

    private static function getFolderSourceFindingSecurityMarksNameTemplate()
    {
        if (self::$folderSourceFindingSecurityMarksNameTemplate == null) {
            self::$folderSourceFindingSecurityMarksNameTemplate = new PathTemplate('folders/{folder}/sources/{source}/findings/{finding}/securityMarks');
        }

        return self::$folderSourceFindingSecurityMarksNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getMuteConfigNameTemplate()
    {
        if (self::$muteConfigNameTemplate == null) {
            self::$muteConfigNameTemplate = new PathTemplate('organizations/{organization}/muteConfigs/{mute_config}');
        }

        return self::$muteConfigNameTemplate;
    }

    private static function getNotificationConfigNameTemplate()
    {
        if (self::$notificationConfigNameTemplate == null) {
            self::$notificationConfigNameTemplate = new PathTemplate('organizations/{organization}/notificationConfigs/{notification_config}');
        }

        return self::$notificationConfigNameTemplate;
    }

    private static function getOrganizationNameTemplate()
    {
        if (self::$organizationNameTemplate == null) {
            self::$organizationNameTemplate = new PathTemplate('organizations/{organization}');
        }

        return self::$organizationNameTemplate;
    }

    private static function getOrganizationAssetSecurityMarksNameTemplate()
    {
        if (self::$organizationAssetSecurityMarksNameTemplate == null) {
            self::$organizationAssetSecurityMarksNameTemplate = new PathTemplate('organizations/{organization}/assets/{asset}/securityMarks');
        }

        return self::$organizationAssetSecurityMarksNameTemplate;
    }

    private static function getOrganizationConstraintNameNameTemplate()
    {
        if (self::$organizationConstraintNameNameTemplate == null) {
            self::$organizationConstraintNameNameTemplate = new PathTemplate('organizations/{organization}/policies/{constraint_name}');
        }

        return self::$organizationConstraintNameNameTemplate;
    }

    private static function getOrganizationCustomModuleNameTemplate()
    {
        if (self::$organizationCustomModuleNameTemplate == null) {
            self::$organizationCustomModuleNameTemplate = new PathTemplate('organizations/{organization}/securityHealthAnalyticsSettings/customModules/{custom_module}');
        }

        return self::$organizationCustomModuleNameTemplate;
    }

    private static function getOrganizationEffectiveCustomModuleNameTemplate()
    {
        if (self::$organizationEffectiveCustomModuleNameTemplate == null) {
            self::$organizationEffectiveCustomModuleNameTemplate = new PathTemplate('organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}');
        }

        return self::$organizationEffectiveCustomModuleNameTemplate;
    }

    private static function getOrganizationEventThreatDetectionSettingsNameTemplate()
    {
        if (self::$organizationEventThreatDetectionSettingsNameTemplate == null) {
            self::$organizationEventThreatDetectionSettingsNameTemplate = new PathTemplate('organizations/{organization}/eventThreatDetectionSettings');
        }

        return self::$organizationEventThreatDetectionSettingsNameTemplate;
    }

    private static function getOrganizationExportNameTemplate()
    {
        if (self::$organizationExportNameTemplate == null) {
            self::$organizationExportNameTemplate = new PathTemplate('organizations/{organization}/bigQueryExports/{export}');
        }

        return self::$organizationExportNameTemplate;
    }

    private static function getOrganizationLocationNameTemplate()
    {
        if (self::$organizationLocationNameTemplate == null) {
            self::$organizationLocationNameTemplate = new PathTemplate('organizations/{organization}/locations/{location}');
        }

        return self::$organizationLocationNameTemplate;
    }

    private static function getOrganizationLocationMuteConfigNameTemplate()
    {
        if (self::$organizationLocationMuteConfigNameTemplate == null) {
            self::$organizationLocationMuteConfigNameTemplate = new PathTemplate('organizations/{organization}/locations/{location}/muteConfigs/{mute_config}');
        }

        return self::$organizationLocationMuteConfigNameTemplate;
    }

    private static function getOrganizationModuleNameTemplate()
    {
        if (self::$organizationModuleNameTemplate == null) {
            self::$organizationModuleNameTemplate = new PathTemplate('organizations/{organization}/eventThreatDetectionSettings/customModules/{module}');
        }

        return self::$organizationModuleNameTemplate;
    }

    private static function getOrganizationMuteConfigNameTemplate()
    {
        if (self::$organizationMuteConfigNameTemplate == null) {
            self::$organizationMuteConfigNameTemplate = new PathTemplate('organizations/{organization}/muteConfigs/{mute_config}');
        }

        return self::$organizationMuteConfigNameTemplate;
    }

    private static function getOrganizationNotificationConfigNameTemplate()
    {
        if (self::$organizationNotificationConfigNameTemplate == null) {
            self::$organizationNotificationConfigNameTemplate = new PathTemplate('organizations/{organization}/notificationConfigs/{notification_config}');
        }

        return self::$organizationNotificationConfigNameTemplate;
    }

    private static function getOrganizationSecurityHealthAnalyticsSettingsNameTemplate()
    {
        if (self::$organizationSecurityHealthAnalyticsSettingsNameTemplate == null) {
            self::$organizationSecurityHealthAnalyticsSettingsNameTemplate = new PathTemplate('organizations/{organization}/securityHealthAnalyticsSettings');
        }

        return self::$organizationSecurityHealthAnalyticsSettingsNameTemplate;
    }

    private static function getOrganizationSettingsNameTemplate()
    {
        if (self::$organizationSettingsNameTemplate == null) {
            self::$organizationSettingsNameTemplate = new PathTemplate('organizations/{organization}/organizationSettings');
        }

        return self::$organizationSettingsNameTemplate;
    }

    private static function getOrganizationSourceNameTemplate()
    {
        if (self::$organizationSourceNameTemplate == null) {
            self::$organizationSourceNameTemplate = new PathTemplate('organizations/{organization}/sources/{source}');
        }

        return self::$organizationSourceNameTemplate;
    }

    private static function getOrganizationSourceFindingNameTemplate()
    {
        if (self::$organizationSourceFindingNameTemplate == null) {
            self::$organizationSourceFindingNameTemplate = new PathTemplate('organizations/{organization}/sources/{source}/findings/{finding}');
        }

        return self::$organizationSourceFindingNameTemplate;
    }

    private static function getOrganizationSourceFindingExternalsystemNameTemplate()
    {
        if (self::$organizationSourceFindingExternalsystemNameTemplate == null) {
            self::$organizationSourceFindingExternalsystemNameTemplate = new PathTemplate('organizations/{organization}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}');
        }

        return self::$organizationSourceFindingExternalsystemNameTemplate;
    }

    private static function getOrganizationSourceFindingSecurityMarksNameTemplate()
    {
        if (self::$organizationSourceFindingSecurityMarksNameTemplate == null) {
            self::$organizationSourceFindingSecurityMarksNameTemplate = new PathTemplate('organizations/{organization}/sources/{source}/findings/{finding}/securityMarks');
        }

        return self::$organizationSourceFindingSecurityMarksNameTemplate;
    }

    private static function getPolicyNameTemplate()
    {
        if (self::$policyNameTemplate == null) {
            self::$policyNameTemplate = new PathTemplate('organizations/{organization}/policies/{constraint_name}');
        }

        return self::$policyNameTemplate;
    }

    private static function getProjectNameTemplate()
    {
        if (self::$projectNameTemplate == null) {
            self::$projectNameTemplate = new PathTemplate('projects/{project}');
        }

        return self::$projectNameTemplate;
    }

    private static function getProjectAssetSecurityMarksNameTemplate()
    {
        if (self::$projectAssetSecurityMarksNameTemplate == null) {
            self::$projectAssetSecurityMarksNameTemplate = new PathTemplate('projects/{project}/assets/{asset}/securityMarks');
        }

        return self::$projectAssetSecurityMarksNameTemplate;
    }

    private static function getProjectConstraintNameNameTemplate()
    {
        if (self::$projectConstraintNameNameTemplate == null) {
            self::$projectConstraintNameNameTemplate = new PathTemplate('projects/{project}/policies/{constraint_name}');
        }

        return self::$projectConstraintNameNameTemplate;
    }

    private static function getProjectCustomModuleNameTemplate()
    {
        if (self::$projectCustomModuleNameTemplate == null) {
            self::$projectCustomModuleNameTemplate = new PathTemplate('projects/{project}/securityHealthAnalyticsSettings/customModules/{custom_module}');
        }

        return self::$projectCustomModuleNameTemplate;
    }

    private static function getProjectDlpJobNameTemplate()
    {
        if (self::$projectDlpJobNameTemplate == null) {
            self::$projectDlpJobNameTemplate = new PathTemplate('projects/{project}/dlpJobs/{dlp_job}');
        }

        return self::$projectDlpJobNameTemplate;
    }

    private static function getProjectEffectiveCustomModuleNameTemplate()
    {
        if (self::$projectEffectiveCustomModuleNameTemplate == null) {
            self::$projectEffectiveCustomModuleNameTemplate = new PathTemplate('projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}');
        }

        return self::$projectEffectiveCustomModuleNameTemplate;
    }

    private static function getProjectEventThreatDetectionSettingsNameTemplate()
    {
        if (self::$projectEventThreatDetectionSettingsNameTemplate == null) {
            self::$projectEventThreatDetectionSettingsNameTemplate = new PathTemplate('projects/{project}/eventThreatDetectionSettings');
        }

        return self::$projectEventThreatDetectionSettingsNameTemplate;
    }

    private static function getProjectExportNameTemplate()
    {
        if (self::$projectExportNameTemplate == null) {
            self::$projectExportNameTemplate = new PathTemplate('projects/{project}/bigQueryExports/{export}');
        }

        return self::$projectExportNameTemplate;
    }

    private static function getProjectLocationDlpJobNameTemplate()
    {
        if (self::$projectLocationDlpJobNameTemplate == null) {
            self::$projectLocationDlpJobNameTemplate = new PathTemplate('projects/{project}/locations/{location}/dlpJobs/{dlp_job}');
        }

        return self::$projectLocationDlpJobNameTemplate;
    }

    private static function getProjectLocationMuteConfigNameTemplate()
    {
        if (self::$projectLocationMuteConfigNameTemplate == null) {
            self::$projectLocationMuteConfigNameTemplate = new PathTemplate('projects/{project}/locations/{location}/muteConfigs/{mute_config}');
        }

        return self::$projectLocationMuteConfigNameTemplate;
    }

    private static function getProjectLocationTableProfileNameTemplate()
    {
        if (self::$projectLocationTableProfileNameTemplate == null) {
            self::$projectLocationTableProfileNameTemplate = new PathTemplate('projects/{project}/locations/{location}/tableProfiles/{table_profile}');
        }

        return self::$projectLocationTableProfileNameTemplate;
    }

    private static function getProjectModuleNameTemplate()
    {
        if (self::$projectModuleNameTemplate == null) {
            self::$projectModuleNameTemplate = new PathTemplate('projects/{project}/eventThreatDetectionSettings/customModules/{module}');
        }

        return self::$projectModuleNameTemplate;
    }

    private static function getProjectMuteConfigNameTemplate()
    {
        if (self::$projectMuteConfigNameTemplate == null) {
            self::$projectMuteConfigNameTemplate = new PathTemplate('projects/{project}/muteConfigs/{mute_config}');
        }

        return self::$projectMuteConfigNameTemplate;
    }

    private static function getProjectNotificationConfigNameTemplate()
    {
        if (self::$projectNotificationConfigNameTemplate == null) {
            self::$projectNotificationConfigNameTemplate = new PathTemplate('projects/{project}/notificationConfigs/{notification_config}');
        }

        return self::$projectNotificationConfigNameTemplate;
    }

    private static function getProjectSecurityHealthAnalyticsSettingsNameTemplate()
    {
        if (self::$projectSecurityHealthAnalyticsSettingsNameTemplate == null) {
            self::$projectSecurityHealthAnalyticsSettingsNameTemplate = new PathTemplate('projects/{project}/securityHealthAnalyticsSettings');
        }

        return self::$projectSecurityHealthAnalyticsSettingsNameTemplate;
    }

    private static function getProjectSourceNameTemplate()
    {
        if (self::$projectSourceNameTemplate == null) {
            self::$projectSourceNameTemplate = new PathTemplate('projects/{project}/sources/{source}');
        }

        return self::$projectSourceNameTemplate;
    }

    private static function getProjectSourceFindingNameTemplate()
    {
        if (self::$projectSourceFindingNameTemplate == null) {
            self::$projectSourceFindingNameTemplate = new PathTemplate('projects/{project}/sources/{source}/findings/{finding}');
        }

        return self::$projectSourceFindingNameTemplate;
    }

    private static function getProjectSourceFindingExternalsystemNameTemplate()
    {
        if (self::$projectSourceFindingExternalsystemNameTemplate == null) {
            self::$projectSourceFindingExternalsystemNameTemplate = new PathTemplate('projects/{project}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}');
        }

        return self::$projectSourceFindingExternalsystemNameTemplate;
    }

    private static function getProjectSourceFindingSecurityMarksNameTemplate()
    {
        if (self::$projectSourceFindingSecurityMarksNameTemplate == null) {
            self::$projectSourceFindingSecurityMarksNameTemplate = new PathTemplate('projects/{project}/sources/{source}/findings/{finding}/securityMarks');
        }

        return self::$projectSourceFindingSecurityMarksNameTemplate;
    }

    private static function getProjectTableProfileNameTemplate()
    {
        if (self::$projectTableProfileNameTemplate == null) {
            self::$projectTableProfileNameTemplate = new PathTemplate('projects/{project}/tableProfiles/{table_profile}');
        }

        return self::$projectTableProfileNameTemplate;
    }

    private static function getResourceValueConfigNameTemplate()
    {
        if (self::$resourceValueConfigNameTemplate == null) {
            self::$resourceValueConfigNameTemplate = new PathTemplate('organizations/{organization}/resourceValueConfigs/{resource_value_config}');
        }

        return self::$resourceValueConfigNameTemplate;
    }

    private static function getSecurityHealthAnalyticsCustomModuleNameTemplate()
    {
        if (self::$securityHealthAnalyticsCustomModuleNameTemplate == null) {
            self::$securityHealthAnalyticsCustomModuleNameTemplate = new PathTemplate('organizations/{organization}/securityHealthAnalyticsSettings/customModules/{custom_module}');
        }

        return self::$securityHealthAnalyticsCustomModuleNameTemplate;
    }

    private static function getSecurityHealthAnalyticsSettingsNameTemplate()
    {
        if (self::$securityHealthAnalyticsSettingsNameTemplate == null) {
            self::$securityHealthAnalyticsSettingsNameTemplate = new PathTemplate('organizations/{organization}/securityHealthAnalyticsSettings');
        }

        return self::$securityHealthAnalyticsSettingsNameTemplate;
    }

    private static function getSecurityMarksNameTemplate()
    {
        if (self::$securityMarksNameTemplate == null) {
            self::$securityMarksNameTemplate = new PathTemplate('organizations/{organization}/assets/{asset}/securityMarks');
        }

        return self::$securityMarksNameTemplate;
    }

    private static function getSimulationNameTemplate()
    {
        if (self::$simulationNameTemplate == null) {
            self::$simulationNameTemplate = new PathTemplate('organizations/{organization}/simulations/{simulation}');
        }

        return self::$simulationNameTemplate;
    }

    private static function getSourceNameTemplate()
    {
        if (self::$sourceNameTemplate == null) {
            self::$sourceNameTemplate = new PathTemplate('organizations/{organization}/sources/{source}');
        }

        return self::$sourceNameTemplate;
    }

    private static function getTableDataProfileNameTemplate()
    {
        if (self::$tableDataProfileNameTemplate == null) {
            self::$tableDataProfileNameTemplate = new PathTemplate('projects/{project}/tableProfiles/{table_profile}');
        }

        return self::$tableDataProfileNameTemplate;
    }

    private static function getTopicNameTemplate()
    {
        if (self::$topicNameTemplate == null) {
            self::$topicNameTemplate = new PathTemplate('projects/{project}/topics/{topic}');
        }

        return self::$topicNameTemplate;
    }

    private static function getValuedResourceNameTemplate()
    {
        if (self::$valuedResourceNameTemplate == null) {
            self::$valuedResourceNameTemplate = new PathTemplate('organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}');
        }

        return self::$valuedResourceNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'bigQueryExport' => self::getBigQueryExportNameTemplate(),
                'dlpJob' => self::getDlpJobNameTemplate(),
                'effectiveEventThreatDetectionCustomModule' => self::getEffectiveEventThreatDetectionCustomModuleNameTemplate(),
                'effectiveSecurityHealthAnalyticsCustomModule' => self::getEffectiveSecurityHealthAnalyticsCustomModuleNameTemplate(),
                'eventThreatDetectionCustomModule' => self::getEventThreatDetectionCustomModuleNameTemplate(),
                'eventThreatDetectionSettings' => self::getEventThreatDetectionSettingsNameTemplate(),
                'externalSystem' => self::getExternalSystemNameTemplate(),
                'finding' => self::getFindingNameTemplate(),
                'folder' => self::getFolderNameTemplate(),
                'folderAssetSecurityMarks' => self::getFolderAssetSecurityMarksNameTemplate(),
                'folderConstraintName' => self::getFolderConstraintNameNameTemplate(),
                'folderCustomModule' => self::getFolderCustomModuleNameTemplate(),
                'folderEffectiveCustomModule' => self::getFolderEffectiveCustomModuleNameTemplate(),
                'folderEventThreatDetectionSettings' => self::getFolderEventThreatDetectionSettingsNameTemplate(),
                'folderExport' => self::getFolderExportNameTemplate(),
                'folderLocation' => self::getFolderLocationNameTemplate(),
                'folderLocationMuteConfig' => self::getFolderLocationMuteConfigNameTemplate(),
                'folderModule' => self::getFolderModuleNameTemplate(),
                'folderMuteConfig' => self::getFolderMuteConfigNameTemplate(),
                'folderNotificationConfig' => self::getFolderNotificationConfigNameTemplate(),
                'folderSecurityHealthAnalyticsSettings' => self::getFolderSecurityHealthAnalyticsSettingsNameTemplate(),
                'folderSource' => self::getFolderSourceNameTemplate(),
                'folderSourceFinding' => self::getFolderSourceFindingNameTemplate(),
                'folderSourceFindingExternalsystem' => self::getFolderSourceFindingExternalsystemNameTemplate(),
                'folderSourceFindingSecurityMarks' => self::getFolderSourceFindingSecurityMarksNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'muteConfig' => self::getMuteConfigNameTemplate(),
                'notificationConfig' => self::getNotificationConfigNameTemplate(),
                'organization' => self::getOrganizationNameTemplate(),
                'organizationAssetSecurityMarks' => self::getOrganizationAssetSecurityMarksNameTemplate(),
                'organizationConstraintName' => self::getOrganizationConstraintNameNameTemplate(),
                'organizationCustomModule' => self::getOrganizationCustomModuleNameTemplate(),
                'organizationEffectiveCustomModule' => self::getOrganizationEffectiveCustomModuleNameTemplate(),
                'organizationEventThreatDetectionSettings' => self::getOrganizationEventThreatDetectionSettingsNameTemplate(),
                'organizationExport' => self::getOrganizationExportNameTemplate(),
                'organizationLocation' => self::getOrganizationLocationNameTemplate(),
                'organizationLocationMuteConfig' => self::getOrganizationLocationMuteConfigNameTemplate(),
                'organizationModule' => self::getOrganizationModuleNameTemplate(),
                'organizationMuteConfig' => self::getOrganizationMuteConfigNameTemplate(),
                'organizationNotificationConfig' => self::getOrganizationNotificationConfigNameTemplate(),
                'organizationSecurityHealthAnalyticsSettings' => self::getOrganizationSecurityHealthAnalyticsSettingsNameTemplate(),
                'organizationSettings' => self::getOrganizationSettingsNameTemplate(),
                'organizationSource' => self::getOrganizationSourceNameTemplate(),
                'organizationSourceFinding' => self::getOrganizationSourceFindingNameTemplate(),
                'organizationSourceFindingExternalsystem' => self::getOrganizationSourceFindingExternalsystemNameTemplate(),
                'organizationSourceFindingSecurityMarks' => self::getOrganizationSourceFindingSecurityMarksNameTemplate(),
                'policy' => self::getPolicyNameTemplate(),
                'project' => self::getProjectNameTemplate(),
                'projectAssetSecurityMarks' => self::getProjectAssetSecurityMarksNameTemplate(),
                'projectConstraintName' => self::getProjectConstraintNameNameTemplate(),
                'projectCustomModule' => self::getProjectCustomModuleNameTemplate(),
                'projectDlpJob' => self::getProjectDlpJobNameTemplate(),
                'projectEffectiveCustomModule' => self::getProjectEffectiveCustomModuleNameTemplate(),
                'projectEventThreatDetectionSettings' => self::getProjectEventThreatDetectionSettingsNameTemplate(),
                'projectExport' => self::getProjectExportNameTemplate(),
                'projectLocationDlpJob' => self::getProjectLocationDlpJobNameTemplate(),
                'projectLocationMuteConfig' => self::getProjectLocationMuteConfigNameTemplate(),
                'projectLocationTableProfile' => self::getProjectLocationTableProfileNameTemplate(),
                'projectModule' => self::getProjectModuleNameTemplate(),
                'projectMuteConfig' => self::getProjectMuteConfigNameTemplate(),
                'projectNotificationConfig' => self::getProjectNotificationConfigNameTemplate(),
                'projectSecurityHealthAnalyticsSettings' => self::getProjectSecurityHealthAnalyticsSettingsNameTemplate(),
                'projectSource' => self::getProjectSourceNameTemplate(),
                'projectSourceFinding' => self::getProjectSourceFindingNameTemplate(),
                'projectSourceFindingExternalsystem' => self::getProjectSourceFindingExternalsystemNameTemplate(),
                'projectSourceFindingSecurityMarks' => self::getProjectSourceFindingSecurityMarksNameTemplate(),
                'projectTableProfile' => self::getProjectTableProfileNameTemplate(),
                'resourceValueConfig' => self::getResourceValueConfigNameTemplate(),
                'securityHealthAnalyticsCustomModule' => self::getSecurityHealthAnalyticsCustomModuleNameTemplate(),
                'securityHealthAnalyticsSettings' => self::getSecurityHealthAnalyticsSettingsNameTemplate(),
                'securityMarks' => self::getSecurityMarksNameTemplate(),
                'simulation' => self::getSimulationNameTemplate(),
                'source' => self::getSourceNameTemplate(),
                'tableDataProfile' => self::getTableDataProfileNameTemplate(),
                'topic' => self::getTopicNameTemplate(),
                'valuedResource' => self::getValuedResourceNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * big_query_export resource.
     *
     * @param string $organization
     * @param string $export
     *
     * @return string The formatted big_query_export resource.
     */
    public static function bigQueryExportName($organization, $export)
    {
        return self::getBigQueryExportNameTemplate()->render([
            'organization' => $organization,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a dlp_job
     * resource.
     *
     * @param string $project
     * @param string $dlpJob
     *
     * @return string The formatted dlp_job resource.
     */
    public static function dlpJobName($project, $dlpJob)
    {
        return self::getDlpJobNameTemplate()->render([
            'project' => $project,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * effective_event_threat_detection_custom_module resource.
     *
     * @param string $organization
     * @param string $module
     *
     * @return string The formatted effective_event_threat_detection_custom_module resource.
     */
    public static function effectiveEventThreatDetectionCustomModuleName($organization, $module)
    {
        return self::getEffectiveEventThreatDetectionCustomModuleNameTemplate()->render([
            'organization' => $organization,
            'module' => $module,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * effective_security_health_analytics_custom_module resource.
     *
     * @param string $organization
     * @param string $effectiveCustomModule
     *
     * @return string The formatted effective_security_health_analytics_custom_module resource.
     */
    public static function effectiveSecurityHealthAnalyticsCustomModuleName($organization, $effectiveCustomModule)
    {
        return self::getEffectiveSecurityHealthAnalyticsCustomModuleNameTemplate()->render([
            'organization' => $organization,
            'effective_custom_module' => $effectiveCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * event_threat_detection_custom_module resource.
     *
     * @param string $organization
     * @param string $module
     *
     * @return string The formatted event_threat_detection_custom_module resource.
     */
    public static function eventThreatDetectionCustomModuleName($organization, $module)
    {
        return self::getEventThreatDetectionCustomModuleNameTemplate()->render([
            'organization' => $organization,
            'module' => $module,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * event_threat_detection_settings resource.
     *
     * @param string $organization
     *
     * @return string The formatted event_threat_detection_settings resource.
     */
    public static function eventThreatDetectionSettingsName($organization)
    {
        return self::getEventThreatDetectionSettingsNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * external_system resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted external_system resource.
     */
    public static function externalSystemName($organization, $source, $finding, $externalsystem)
    {
        return self::getExternalSystemNameTemplate()->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a finding
     * resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted finding resource.
     */
    public static function findingName($organization, $source, $finding)
    {
        return self::getFindingNameTemplate()->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName($folder)
    {
        return self::getFolderNameTemplate()->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_asset_securityMarks resource.
     *
     * @param string $folder
     * @param string $asset
     *
     * @return string The formatted folder_asset_securityMarks resource.
     */
    public static function folderAssetSecurityMarksName($folder, $asset)
    {
        return self::getFolderAssetSecurityMarksNameTemplate()->render([
            'folder' => $folder,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_constraint_name resource.
     *
     * @param string $folder
     * @param string $constraintName
     *
     * @return string The formatted folder_constraint_name resource.
     */
    public static function folderConstraintNameName($folder, $constraintName)
    {
        return self::getFolderConstraintNameNameTemplate()->render([
            'folder' => $folder,
            'constraint_name' => $constraintName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_custom_module resource.
     *
     * @param string $folder
     * @param string $customModule
     *
     * @return string The formatted folder_custom_module resource.
     */
    public static function folderCustomModuleName($folder, $customModule)
    {
        return self::getFolderCustomModuleNameTemplate()->render([
            'folder' => $folder,
            'custom_module' => $customModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_effective_custom_module resource.
     *
     * @param string $folder
     * @param string $effectiveCustomModule
     *
     * @return string The formatted folder_effective_custom_module resource.
     */
    public static function folderEffectiveCustomModuleName($folder, $effectiveCustomModule)
    {
        return self::getFolderEffectiveCustomModuleNameTemplate()->render([
            'folder' => $folder,
            'effective_custom_module' => $effectiveCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_eventThreatDetectionSettings resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder_eventThreatDetectionSettings resource.
     */
    public static function folderEventThreatDetectionSettingsName($folder)
    {
        return self::getFolderEventThreatDetectionSettingsNameTemplate()->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_export resource.
     *
     * @param string $folder
     * @param string $export
     *
     * @return string The formatted folder_export resource.
     */
    public static function folderExportName($folder, $export)
    {
        return self::getFolderExportNameTemplate()->render([
            'folder' => $folder,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location resource.
     *
     * @param string $folder
     * @param string $location
     *
     * @return string The formatted folder_location resource.
     */
    public static function folderLocationName($folder, $location)
    {
        return self::getFolderLocationNameTemplate()->render([
            'folder' => $folder,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_mute_config resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $muteConfig
     *
     * @return string The formatted folder_location_mute_config resource.
     */
    public static function folderLocationMuteConfigName($folder, $location, $muteConfig)
    {
        return self::getFolderLocationMuteConfigNameTemplate()->render([
            'folder' => $folder,
            'location' => $location,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_module resource.
     *
     * @param string $folder
     * @param string $module
     *
     * @return string The formatted folder_module resource.
     */
    public static function folderModuleName($folder, $module)
    {
        return self::getFolderModuleNameTemplate()->render([
            'folder' => $folder,
            'module' => $module,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_mute_config resource.
     *
     * @param string $folder
     * @param string $muteConfig
     *
     * @return string The formatted folder_mute_config resource.
     */
    public static function folderMuteConfigName($folder, $muteConfig)
    {
        return self::getFolderMuteConfigNameTemplate()->render([
            'folder' => $folder,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_notification_config resource.
     *
     * @param string $folder
     * @param string $notificationConfig
     *
     * @return string The formatted folder_notification_config resource.
     */
    public static function folderNotificationConfigName($folder, $notificationConfig)
    {
        return self::getFolderNotificationConfigNameTemplate()->render([
            'folder' => $folder,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_securityHealthAnalyticsSettings resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder_securityHealthAnalyticsSettings resource.
     */
    public static function folderSecurityHealthAnalyticsSettingsName($folder)
    {
        return self::getFolderSecurityHealthAnalyticsSettingsNameTemplate()->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source resource.
     *
     * @param string $folder
     * @param string $source
     *
     * @return string The formatted folder_source resource.
     */
    public static function folderSourceName($folder, $source)
    {
        return self::getFolderSourceNameTemplate()->render([
            'folder' => $folder,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_finding resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted folder_source_finding resource.
     */
    public static function folderSourceFindingName($folder, $source, $finding)
    {
        return self::getFolderSourceFindingNameTemplate()->render([
            'folder' => $folder,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_finding_externalsystem resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted folder_source_finding_externalsystem resource.
     */
    public static function folderSourceFindingExternalsystemName($folder, $source, $finding, $externalsystem)
    {
        return self::getFolderSourceFindingExternalsystemNameTemplate()->render([
            'folder' => $folder,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_finding_securityMarks resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted folder_source_finding_securityMarks resource.
     */
    public static function folderSourceFindingSecurityMarksName($folder, $source, $finding)
    {
        return self::getFolderSourceFindingSecurityMarksNameTemplate()->render([
            'folder' => $folder,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a mute_config
     * resource.
     *
     * @param string $organization
     * @param string $muteConfig
     *
     * @return string The formatted mute_config resource.
     */
    public static function muteConfigName($organization, $muteConfig)
    {
        return self::getMuteConfigNameTemplate()->render([
            'organization' => $organization,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * notification_config resource.
     *
     * @param string $organization
     * @param string $notificationConfig
     *
     * @return string The formatted notification_config resource.
     */
    public static function notificationConfigName($organization, $notificationConfig)
    {
        return self::getNotificationConfigNameTemplate()->render([
            'organization' => $organization,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName($organization)
    {
        return self::getOrganizationNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_asset_securityMarks resource.
     *
     * @param string $organization
     * @param string $asset
     *
     * @return string The formatted organization_asset_securityMarks resource.
     */
    public static function organizationAssetSecurityMarksName($organization, $asset)
    {
        return self::getOrganizationAssetSecurityMarksNameTemplate()->render([
            'organization' => $organization,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_constraint_name resource.
     *
     * @param string $organization
     * @param string $constraintName
     *
     * @return string The formatted organization_constraint_name resource.
     */
    public static function organizationConstraintNameName($organization, $constraintName)
    {
        return self::getOrganizationConstraintNameNameTemplate()->render([
            'organization' => $organization,
            'constraint_name' => $constraintName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_custom_module resource.
     *
     * @param string $organization
     * @param string $customModule
     *
     * @return string The formatted organization_custom_module resource.
     */
    public static function organizationCustomModuleName($organization, $customModule)
    {
        return self::getOrganizationCustomModuleNameTemplate()->render([
            'organization' => $organization,
            'custom_module' => $customModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_effective_custom_module resource.
     *
     * @param string $organization
     * @param string $effectiveCustomModule
     *
     * @return string The formatted organization_effective_custom_module resource.
     */
    public static function organizationEffectiveCustomModuleName($organization, $effectiveCustomModule)
    {
        return self::getOrganizationEffectiveCustomModuleNameTemplate()->render([
            'organization' => $organization,
            'effective_custom_module' => $effectiveCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_eventThreatDetectionSettings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_eventThreatDetectionSettings resource.
     */
    public static function organizationEventThreatDetectionSettingsName($organization)
    {
        return self::getOrganizationEventThreatDetectionSettingsNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_export resource.
     *
     * @param string $organization
     * @param string $export
     *
     * @return string The formatted organization_export resource.
     */
    public static function organizationExportName($organization, $export)
    {
        return self::getOrganizationExportNameTemplate()->render([
            'organization' => $organization,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName($organization, $location)
    {
        return self::getOrganizationLocationNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_mute_config resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $muteConfig
     *
     * @return string The formatted organization_location_mute_config resource.
     */
    public static function organizationLocationMuteConfigName($organization, $location, $muteConfig)
    {
        return self::getOrganizationLocationMuteConfigNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_module resource.
     *
     * @param string $organization
     * @param string $module
     *
     * @return string The formatted organization_module resource.
     */
    public static function organizationModuleName($organization, $module)
    {
        return self::getOrganizationModuleNameTemplate()->render([
            'organization' => $organization,
            'module' => $module,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_mute_config resource.
     *
     * @param string $organization
     * @param string $muteConfig
     *
     * @return string The formatted organization_mute_config resource.
     */
    public static function organizationMuteConfigName($organization, $muteConfig)
    {
        return self::getOrganizationMuteConfigNameTemplate()->render([
            'organization' => $organization,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_notification_config resource.
     *
     * @param string $organization
     * @param string $notificationConfig
     *
     * @return string The formatted organization_notification_config resource.
     */
    public static function organizationNotificationConfigName($organization, $notificationConfig)
    {
        return self::getOrganizationNotificationConfigNameTemplate()->render([
            'organization' => $organization,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_securityHealthAnalyticsSettings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_securityHealthAnalyticsSettings resource.
     */
    public static function organizationSecurityHealthAnalyticsSettingsName($organization)
    {
        return self::getOrganizationSecurityHealthAnalyticsSettingsNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_settings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_settings resource.
     */
    public static function organizationSettingsName($organization)
    {
        return self::getOrganizationSettingsNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source resource.
     *
     * @param string $organization
     * @param string $source
     *
     * @return string The formatted organization_source resource.
     */
    public static function organizationSourceName($organization, $source)
    {
        return self::getOrganizationSourceNameTemplate()->render([
            'organization' => $organization,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_finding resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted organization_source_finding resource.
     */
    public static function organizationSourceFindingName($organization, $source, $finding)
    {
        return self::getOrganizationSourceFindingNameTemplate()->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_finding_externalsystem resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted organization_source_finding_externalsystem resource.
     */
    public static function organizationSourceFindingExternalsystemName($organization, $source, $finding, $externalsystem)
    {
        return self::getOrganizationSourceFindingExternalsystemNameTemplate()->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_finding_securityMarks resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted organization_source_finding_securityMarks resource.
     */
    public static function organizationSourceFindingSecurityMarksName($organization, $source, $finding)
    {
        return self::getOrganizationSourceFindingSecurityMarksNameTemplate()->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a policy
     * resource.
     *
     * @param string $organization
     * @param string $constraintName
     *
     * @return string The formatted policy resource.
     */
    public static function policyName($organization, $constraintName)
    {
        return self::getPolicyNameTemplate()->render([
            'organization' => $organization,
            'constraint_name' => $constraintName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName($project)
    {
        return self::getProjectNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_asset_securityMarks resource.
     *
     * @param string $project
     * @param string $asset
     *
     * @return string The formatted project_asset_securityMarks resource.
     */
    public static function projectAssetSecurityMarksName($project, $asset)
    {
        return self::getProjectAssetSecurityMarksNameTemplate()->render([
            'project' => $project,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_constraint_name resource.
     *
     * @param string $project
     * @param string $constraintName
     *
     * @return string The formatted project_constraint_name resource.
     */
    public static function projectConstraintNameName($project, $constraintName)
    {
        return self::getProjectConstraintNameNameTemplate()->render([
            'project' => $project,
            'constraint_name' => $constraintName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_custom_module resource.
     *
     * @param string $project
     * @param string $customModule
     *
     * @return string The formatted project_custom_module resource.
     */
    public static function projectCustomModuleName($project, $customModule)
    {
        return self::getProjectCustomModuleNameTemplate()->render([
            'project' => $project,
            'custom_module' => $customModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_dlp_job resource.
     *
     * @param string $project
     * @param string $dlpJob
     *
     * @return string The formatted project_dlp_job resource.
     */
    public static function projectDlpJobName($project, $dlpJob)
    {
        return self::getProjectDlpJobNameTemplate()->render([
            'project' => $project,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_effective_custom_module resource.
     *
     * @param string $project
     * @param string $effectiveCustomModule
     *
     * @return string The formatted project_effective_custom_module resource.
     */
    public static function projectEffectiveCustomModuleName($project, $effectiveCustomModule)
    {
        return self::getProjectEffectiveCustomModuleNameTemplate()->render([
            'project' => $project,
            'effective_custom_module' => $effectiveCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_eventThreatDetectionSettings resource.
     *
     * @param string $project
     *
     * @return string The formatted project_eventThreatDetectionSettings resource.
     */
    public static function projectEventThreatDetectionSettingsName($project)
    {
        return self::getProjectEventThreatDetectionSettingsNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_export resource.
     *
     * @param string $project
     * @param string $export
     *
     * @return string The formatted project_export resource.
     */
    public static function projectExportName($project, $export)
    {
        return self::getProjectExportNameTemplate()->render([
            'project' => $project,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_dlp_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dlpJob
     *
     * @return string The formatted project_location_dlp_job resource.
     */
    public static function projectLocationDlpJobName($project, $location, $dlpJob)
    {
        return self::getProjectLocationDlpJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_mute_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $muteConfig
     *
     * @return string The formatted project_location_mute_config resource.
     */
    public static function projectLocationMuteConfigName($project, $location, $muteConfig)
    {
        return self::getProjectLocationMuteConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_table_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tableProfile
     *
     * @return string The formatted project_location_table_profile resource.
     */
    public static function projectLocationTableProfileName($project, $location, $tableProfile)
    {
        return self::getProjectLocationTableProfileNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'table_profile' => $tableProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_module resource.
     *
     * @param string $project
     * @param string $module
     *
     * @return string The formatted project_module resource.
     */
    public static function projectModuleName($project, $module)
    {
        return self::getProjectModuleNameTemplate()->render([
            'project' => $project,
            'module' => $module,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_mute_config resource.
     *
     * @param string $project
     * @param string $muteConfig
     *
     * @return string The formatted project_mute_config resource.
     */
    public static function projectMuteConfigName($project, $muteConfig)
    {
        return self::getProjectMuteConfigNameTemplate()->render([
            'project' => $project,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_notification_config resource.
     *
     * @param string $project
     * @param string $notificationConfig
     *
     * @return string The formatted project_notification_config resource.
     */
    public static function projectNotificationConfigName($project, $notificationConfig)
    {
        return self::getProjectNotificationConfigNameTemplate()->render([
            'project' => $project,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_securityHealthAnalyticsSettings resource.
     *
     * @param string $project
     *
     * @return string The formatted project_securityHealthAnalyticsSettings resource.
     */
    public static function projectSecurityHealthAnalyticsSettingsName($project)
    {
        return self::getProjectSecurityHealthAnalyticsSettingsNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source resource.
     *
     * @param string $project
     * @param string $source
     *
     * @return string The formatted project_source resource.
     */
    public static function projectSourceName($project, $source)
    {
        return self::getProjectSourceNameTemplate()->render([
            'project' => $project,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_finding resource.
     *
     * @param string $project
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted project_source_finding resource.
     */
    public static function projectSourceFindingName($project, $source, $finding)
    {
        return self::getProjectSourceFindingNameTemplate()->render([
            'project' => $project,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_finding_externalsystem resource.
     *
     * @param string $project
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted project_source_finding_externalsystem resource.
     */
    public static function projectSourceFindingExternalsystemName($project, $source, $finding, $externalsystem)
    {
        return self::getProjectSourceFindingExternalsystemNameTemplate()->render([
            'project' => $project,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_finding_securityMarks resource.
     *
     * @param string $project
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted project_source_finding_securityMarks resource.
     */
    public static function projectSourceFindingSecurityMarksName($project, $source, $finding)
    {
        return self::getProjectSourceFindingSecurityMarksNameTemplate()->render([
            'project' => $project,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_table_profile resource.
     *
     * @param string $project
     * @param string $tableProfile
     *
     * @return string The formatted project_table_profile resource.
     */
    public static function projectTableProfileName($project, $tableProfile)
    {
        return self::getProjectTableProfileNameTemplate()->render([
            'project' => $project,
            'table_profile' => $tableProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * resource_value_config resource.
     *
     * @param string $organization
     * @param string $resourceValueConfig
     *
     * @return string The formatted resource_value_config resource.
     */
    public static function resourceValueConfigName($organization, $resourceValueConfig)
    {
        return self::getResourceValueConfigNameTemplate()->render([
            'organization' => $organization,
            'resource_value_config' => $resourceValueConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * security_health_analytics_custom_module resource.
     *
     * @param string $organization
     * @param string $customModule
     *
     * @return string The formatted security_health_analytics_custom_module resource.
     */
    public static function securityHealthAnalyticsCustomModuleName($organization, $customModule)
    {
        return self::getSecurityHealthAnalyticsCustomModuleNameTemplate()->render([
            'organization' => $organization,
            'custom_module' => $customModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * security_health_analytics_settings resource.
     *
     * @param string $organization
     *
     * @return string The formatted security_health_analytics_settings resource.
     */
    public static function securityHealthAnalyticsSettingsName($organization)
    {
        return self::getSecurityHealthAnalyticsSettingsNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * security_marks resource.
     *
     * @param string $organization
     * @param string $asset
     *
     * @return string The formatted security_marks resource.
     */
    public static function securityMarksName($organization, $asset)
    {
        return self::getSecurityMarksNameTemplate()->render([
            'organization' => $organization,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a simulation
     * resource.
     *
     * @param string $organization
     * @param string $simulation
     *
     * @return string The formatted simulation resource.
     */
    public static function simulationName($organization, $simulation)
    {
        return self::getSimulationNameTemplate()->render([
            'organization' => $organization,
            'simulation' => $simulation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a source
     * resource.
     *
     * @param string $organization
     * @param string $source
     *
     * @return string The formatted source resource.
     */
    public static function sourceName($organization, $source)
    {
        return self::getSourceNameTemplate()->render([
            'organization' => $organization,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * table_data_profile resource.
     *
     * @param string $project
     * @param string $tableProfile
     *
     * @return string The formatted table_data_profile resource.
     */
    public static function tableDataProfileName($project, $tableProfile)
    {
        return self::getTableDataProfileNameTemplate()->render([
            'project' => $project,
            'table_profile' => $tableProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a topic
     * resource.
     *
     * @param string $project
     * @param string $topic
     *
     * @return string The formatted topic resource.
     */
    public static function topicName($project, $topic)
    {
        return self::getTopicNameTemplate()->render([
            'project' => $project,
            'topic' => $topic,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * valued_resource resource.
     *
     * @param string $organization
     * @param string $simulation
     * @param string $valuedResource
     *
     * @return string The formatted valued_resource resource.
     */
    public static function valuedResourceName($organization, $simulation, $valuedResource)
    {
        return self::getValuedResourceNameTemplate()->render([
            'organization' => $organization,
            'simulation' => $simulation,
            'valued_resource' => $valuedResource,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - bigQueryExport: organizations/{organization}/bigQueryExports/{export}
     * - dlpJob: projects/{project}/dlpJobs/{dlp_job}
     * - effectiveEventThreatDetectionCustomModule: organizations/{organization}/eventThreatDetectionSettings/effectiveCustomModules/{module}
     * - effectiveSecurityHealthAnalyticsCustomModule: organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}
     * - eventThreatDetectionCustomModule: organizations/{organization}/eventThreatDetectionSettings/customModules/{module}
     * - eventThreatDetectionSettings: organizations/{organization}/eventThreatDetectionSettings
     * - externalSystem: organizations/{organization}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - finding: organizations/{organization}/sources/{source}/findings/{finding}
     * - folder: folders/{folder}
     * - folderAssetSecurityMarks: folders/{folder}/assets/{asset}/securityMarks
     * - folderConstraintName: folders/{folder}/policies/{constraint_name}
     * - folderCustomModule: folders/{folder}/securityHealthAnalyticsSettings/customModules/{custom_module}
     * - folderEffectiveCustomModule: folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}
     * - folderEventThreatDetectionSettings: folders/{folder}/eventThreatDetectionSettings
     * - folderExport: folders/{folder}/bigQueryExports/{export}
     * - folderLocation: folders/{folder}/locations/{location}
     * - folderLocationMuteConfig: folders/{folder}/locations/{location}/muteConfigs/{mute_config}
     * - folderModule: folders/{folder}/eventThreatDetectionSettings/customModules/{module}
     * - folderMuteConfig: folders/{folder}/muteConfigs/{mute_config}
     * - folderNotificationConfig: folders/{folder}/notificationConfigs/{notification_config}
     * - folderSecurityHealthAnalyticsSettings: folders/{folder}/securityHealthAnalyticsSettings
     * - folderSource: folders/{folder}/sources/{source}
     * - folderSourceFinding: folders/{folder}/sources/{source}/findings/{finding}
     * - folderSourceFindingExternalsystem: folders/{folder}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - folderSourceFindingSecurityMarks: folders/{folder}/sources/{source}/findings/{finding}/securityMarks
     * - location: projects/{project}/locations/{location}
     * - muteConfig: organizations/{organization}/muteConfigs/{mute_config}
     * - notificationConfig: organizations/{organization}/notificationConfigs/{notification_config}
     * - organization: organizations/{organization}
     * - organizationAssetSecurityMarks: organizations/{organization}/assets/{asset}/securityMarks
     * - organizationConstraintName: organizations/{organization}/policies/{constraint_name}
     * - organizationCustomModule: organizations/{organization}/securityHealthAnalyticsSettings/customModules/{custom_module}
     * - organizationEffectiveCustomModule: organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}
     * - organizationEventThreatDetectionSettings: organizations/{organization}/eventThreatDetectionSettings
     * - organizationExport: organizations/{organization}/bigQueryExports/{export}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationLocationMuteConfig: organizations/{organization}/locations/{location}/muteConfigs/{mute_config}
     * - organizationModule: organizations/{organization}/eventThreatDetectionSettings/customModules/{module}
     * - organizationMuteConfig: organizations/{organization}/muteConfigs/{mute_config}
     * - organizationNotificationConfig: organizations/{organization}/notificationConfigs/{notification_config}
     * - organizationSecurityHealthAnalyticsSettings: organizations/{organization}/securityHealthAnalyticsSettings
     * - organizationSettings: organizations/{organization}/organizationSettings
     * - organizationSource: organizations/{organization}/sources/{source}
     * - organizationSourceFinding: organizations/{organization}/sources/{source}/findings/{finding}
     * - organizationSourceFindingExternalsystem: organizations/{organization}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - organizationSourceFindingSecurityMarks: organizations/{organization}/sources/{source}/findings/{finding}/securityMarks
     * - policy: organizations/{organization}/policies/{constraint_name}
     * - project: projects/{project}
     * - projectAssetSecurityMarks: projects/{project}/assets/{asset}/securityMarks
     * - projectConstraintName: projects/{project}/policies/{constraint_name}
     * - projectCustomModule: projects/{project}/securityHealthAnalyticsSettings/customModules/{custom_module}
     * - projectDlpJob: projects/{project}/dlpJobs/{dlp_job}
     * - projectEffectiveCustomModule: projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}
     * - projectEventThreatDetectionSettings: projects/{project}/eventThreatDetectionSettings
     * - projectExport: projects/{project}/bigQueryExports/{export}
     * - projectLocationDlpJob: projects/{project}/locations/{location}/dlpJobs/{dlp_job}
     * - projectLocationMuteConfig: projects/{project}/locations/{location}/muteConfigs/{mute_config}
     * - projectLocationTableProfile: projects/{project}/locations/{location}/tableProfiles/{table_profile}
     * - projectModule: projects/{project}/eventThreatDetectionSettings/customModules/{module}
     * - projectMuteConfig: projects/{project}/muteConfigs/{mute_config}
     * - projectNotificationConfig: projects/{project}/notificationConfigs/{notification_config}
     * - projectSecurityHealthAnalyticsSettings: projects/{project}/securityHealthAnalyticsSettings
     * - projectSource: projects/{project}/sources/{source}
     * - projectSourceFinding: projects/{project}/sources/{source}/findings/{finding}
     * - projectSourceFindingExternalsystem: projects/{project}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - projectSourceFindingSecurityMarks: projects/{project}/sources/{source}/findings/{finding}/securityMarks
     * - projectTableProfile: projects/{project}/tableProfiles/{table_profile}
     * - resourceValueConfig: organizations/{organization}/resourceValueConfigs/{resource_value_config}
     * - securityHealthAnalyticsCustomModule: organizations/{organization}/securityHealthAnalyticsSettings/customModules/{custom_module}
     * - securityHealthAnalyticsSettings: organizations/{organization}/securityHealthAnalyticsSettings
     * - securityMarks: organizations/{organization}/assets/{asset}/securityMarks
     * - simulation: organizations/{organization}/simulations/{simulation}
     * - source: organizations/{organization}/sources/{source}
     * - tableDataProfile: projects/{project}/tableProfiles/{table_profile}
     * - topic: projects/{project}/topics/{topic}
     * - valuedResource: organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'securitycenter.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a ResourceValueConfig for an organization. Maps user's tags to
     * difference resource values for use by the attack path simulation.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->organizationName('[ORGANIZATION]');
     *     $requests = [];
     *     $response = $securityCenterClient->batchCreateResourceValueConfigs($formattedParent, $requests);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string                             $parent       Required. Resource name of the new ResourceValueConfig's parent.
     *                                                         The parent field in the CreateResourceValueConfigRequest
     *                                                         messages must either be empty or match this field.
     * @param CreateResourceValueConfigRequest[] $requests     Required. The resource value configs to be created.
     * @param array                              $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\BatchCreateResourceValueConfigsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchCreateResourceValueConfigs($parent, $requests, array $optionalArgs = [])
    {
        $request = new BatchCreateResourceValueConfigsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRequests($requests);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('BatchCreateResourceValueConfigs', BatchCreateResourceValueConfigsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Kicks off an LRO to bulk mute findings for a parent based on a filter. The
     * parent can be either an organization, folder or project. The findings
     * matched by the filter will be muted after the LRO is done.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $parent = 'parent';
     *     $operationResponse = $securityCenterClient->bulkMuteFindings($parent);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $securityCenterClient->bulkMuteFindings($parent);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $securityCenterClient->resumeOperation($operationName, 'bulkMuteFindings');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, at which bulk action needs to be applied. Its format
     *                             is `organizations/[organization_id]`, `folders/[folder_id]`,
     *                             `projects/[project_id]`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Expression that identifies findings that should be updated.
     *           The expression is a list of zero or more restrictions combined
     *           via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
     *           has higher precedence than `AND`.
     *
     *           Restrictions have the form `<field> <operator> <value>` and may have a
     *           `-` character in front of them to indicate negation. The fields map to
     *           those defined in the corresponding resource.
     *
     *           The supported operators are:
     *
     *           * `=` for all value types.
     *           * `>`, `<`, `>=`, `<=` for integer values.
     *           * `:`, meaning substring matching, for strings.
     *
     *           The supported value types are:
     *
     *           * string literals in quotes.
     *           * integer literals without quotes.
     *           * boolean literals `true` and `false` without quotes.
     *     @type string $muteAnnotation
     *           This can be a mute configuration name or any identifier for mute/unmute
     *           of findings based on the filter.
     *     @type int $muteState
     *           Optional. All findings matching the given filter will have their mute state
     *           set to this value. The default value is `MUTED`. Setting this to
     *           `UNDEFINED` will clear the mute state on all matching findings.
     *           For allowed values, use constants defined on {@see \Google\Cloud\SecurityCenter\V1\BulkMuteFindingsRequest\MuteState}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function bulkMuteFindings($parent, array $optionalArgs = [])
    {
        $request = new BulkMuteFindingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['muteAnnotation'])) {
            $request->setMuteAnnotation($optionalArgs['muteAnnotation']);
        }

        if (isset($optionalArgs['muteState'])) {
            $request->setMuteState($optionalArgs['muteState']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('BulkMuteFindings', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a BigQuery export.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->projectName('[PROJECT]');
     *     $bigQueryExport = new BigQueryExport();
     *     $bigQueryExportId = 'big_query_export_id';
     *     $response = $securityCenterClient->createBigQueryExport($formattedParent, $bigQueryExport, $bigQueryExportId);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string         $parent           Required. The name of the parent resource of the new BigQuery export. Its
     *                                         format is `organizations/[organization_id]`, `folders/[folder_id]`, or
     *                                         `projects/[project_id]`.
     * @param BigQueryExport $bigQueryExport   Required. The BigQuery export being created.
     * @param string         $bigQueryExportId Required. Unique identifier provided by the client within the parent scope.
     *                                         It must consist of only lowercase letters, numbers, and hyphens, must start
     *                                         with a letter, must end with either a letter or a number, and must be 63
     *                                         characters or less.
     * @param array          $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\BigQueryExport
     *
     * @throws ApiException if the remote call fails
     */
    public function createBigQueryExport($parent, $bigQueryExport, $bigQueryExportId, array $optionalArgs = [])
    {
        $request = new CreateBigQueryExportRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setBigQueryExport($bigQueryExport);
        $request->setBigQueryExportId($bigQueryExportId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateBigQueryExport', BigQueryExport::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a resident Event Threat Detection custom module at the scope of the
     * given Resource Manager parent, and also creates inherited custom modules
     * for all descendants of the given parent. These modules are enabled by
     * default.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->eventThreatDetectionSettingsName('[ORGANIZATION]');
     *     $eventThreatDetectionCustomModule = new EventThreatDetectionCustomModule();
     *     $response = $securityCenterClient->createEventThreatDetectionCustomModule($formattedParent, $eventThreatDetectionCustomModule);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string                           $parent                           Required. The new custom module's parent.
     *
     *                                                                           Its format is:
     *
     *                                                                           * `organizations/{organization}/eventThreatDetectionSettings`.
     *                                                                           * `folders/{folder}/eventThreatDetectionSettings`.
     *                                                                           * `projects/{project}/eventThreatDetectionSettings`.
     * @param EventThreatDetectionCustomModule $eventThreatDetectionCustomModule Required. The module to create. The
     *                                                                           event_threat_detection_custom_module.name will be ignored and server
     *                                                                           generated.
     * @param array                            $optionalArgs                     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\EventThreatDetectionCustomModule
     *
     * @throws ApiException if the remote call fails
     */
    public function createEventThreatDetectionCustomModule($parent, $eventThreatDetectionCustomModule, array $optionalArgs = [])
    {
        $request = new CreateEventThreatDetectionCustomModuleRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEventThreatDetectionCustomModule($eventThreatDetectionCustomModule);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateEventThreatDetectionCustomModule', EventThreatDetectionCustomModule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a finding. The corresponding source must exist for finding creation
     * to succeed.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->sourceName('[ORGANIZATION]', '[SOURCE]');
     *     $findingId = 'finding_id';
     *     $finding = new Finding();
     *     $response = $securityCenterClient->createFinding($formattedParent, $findingId, $finding);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. Resource name of the new finding's parent. Its format should be
     *                              `organizations/[organization_id]/sources/[source_id]`.
     * @param string  $findingId    Required. Unique identifier provided by the client within the parent scope.
     *                              It must be alphanumeric and less than or equal to 32 characters and
     *                              greater than 0 characters in length.
     * @param Finding $finding      Required. The Finding being created. The name and security_marks will be
     *                              ignored as they are both output only fields on this resource.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\Finding
     *
     * @throws ApiException if the remote call fails
     */
    public function createFinding($parent, $findingId, $finding, array $optionalArgs = [])
    {
        $request = new CreateFindingRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFindingId($findingId);
        $request->setFinding($finding);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateFinding', Finding::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a mute config.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     $muteConfig = new MuteConfig();
     *     $muteConfigId = 'mute_config_id';
     *     $response = $securityCenterClient->createMuteConfig($formattedParent, $muteConfig, $muteConfigId);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. Resource name of the new mute configs's parent. Its format is
     *                                 `organizations/[organization_id]`, `folders/[folder_id]`, or
     *                                 `projects/[project_id]`.
     * @param MuteConfig $muteConfig   Required. The mute config being created.
     * @param string     $muteConfigId Required. Unique identifier provided by the client within the parent scope.
     *                                 It must consist of only lowercase letters, numbers, and hyphens, must start
     *                                 with a letter, must end with either a letter or a number, and must be 63
     *                                 characters or less.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\MuteConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function createMuteConfig($parent, $muteConfig, $muteConfigId, array $optionalArgs = [])
    {
        $request = new CreateMuteConfigRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setMuteConfig($muteConfig);
        $request->setMuteConfigId($muteConfigId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateMuteConfig', MuteConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a notification config.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->projectName('[PROJECT]');
     *     $configId = 'config_id';
     *     $notificationConfig = new NotificationConfig();
     *     $response = $securityCenterClient->createNotificationConfig($formattedParent, $configId, $notificationConfig);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string             $parent             Required. Resource name of the new notification config's parent. Its format
     *                                               is `organizations/[organization_id]`, `folders/[folder_id]`, or
     *                                               `projects/[project_id]`.
     * @param string             $configId           Required.
     *                                               Unique identifier provided by the client within the parent scope.
     *                                               It must be between 1 and 128 characters and contain alphanumeric
     *                                               characters, underscores, or hyphens only.
     * @param NotificationConfig $notificationConfig Required. The notification config being created. The name and the service
     *                                               account will be ignored as they are both output only fields on this
     *                                               resource.
     * @param array              $optionalArgs       {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\NotificationConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function createNotificationConfig($parent, $configId, $notificationConfig, array $optionalArgs = [])
    {
        $request = new CreateNotificationConfigRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setConfigId($configId);
        $request->setNotificationConfig($notificationConfig);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateNotificationConfig', NotificationConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
     * given CRM parent, and also creates inherited
     * SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
     * parent. These modules are enabled by default.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->securityHealthAnalyticsSettingsName('[ORGANIZATION]');
     *     $securityHealthAnalyticsCustomModule = new SecurityHealthAnalyticsCustomModule();
     *     $response = $securityCenterClient->createSecurityHealthAnalyticsCustomModule($formattedParent, $securityHealthAnalyticsCustomModule);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string                              $parent                              Required. Resource name of the new custom module's parent. Its format is
     *                                                                                 `organizations/{organization}/securityHealthAnalyticsSettings`,
     *                                                                                 `folders/{folder}/securityHealthAnalyticsSettings`, or
     *                                                                                 `projects/{project}/securityHealthAnalyticsSettings`
     * @param SecurityHealthAnalyticsCustomModule $securityHealthAnalyticsCustomModule Required. SecurityHealthAnalytics custom module to create. The provided
     *                                                                                 name is ignored and reset with provided parent information and
     *                                                                                 server-generated ID.
     * @param array                               $optionalArgs                        {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\SecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException if the remote call fails
     */
    public function createSecurityHealthAnalyticsCustomModule($parent, $securityHealthAnalyticsCustomModule, array $optionalArgs = [])
    {
        $request = new CreateSecurityHealthAnalyticsCustomModuleRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSecurityHealthAnalyticsCustomModule($securityHealthAnalyticsCustomModule);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateSecurityHealthAnalyticsCustomModule', SecurityHealthAnalyticsCustomModule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a source.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->organizationName('[ORGANIZATION]');
     *     $source = new Source();
     *     $response = $securityCenterClient->createSource($formattedParent, $source);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name of the new source's parent. Its format should be
     *                             `organizations/[organization_id]`.
     * @param Source $source       Required. The Source being created, only the display_name and description
     *                             will be used. All other fields will be ignored.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\Source
     *
     * @throws ApiException if the remote call fails
     */
    public function createSource($parent, $source, array $optionalArgs = [])
    {
        $request = new CreateSourceRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSource($source);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateSource', Source::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes an existing BigQuery export.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->bigQueryExportName('[ORGANIZATION]', '[EXPORT]');
     *     $securityCenterClient->deleteBigQueryExport($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the BigQuery export to delete. Its format is
     *                             `organizations/{organization}/bigQueryExports/{export_id}`,
     *                             `folders/{folder}/bigQueryExports/{export_id}`, or
     *                             `projects/{project}/bigQueryExports/{export_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteBigQueryExport($name, array $optionalArgs = [])
    {
        $request = new DeleteBigQueryExportRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteBigQueryExport', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes the specified Event Threat Detection custom module and all of its
     * descendants in the Resource Manager hierarchy. This method is only
     * supported for resident custom modules.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->eventThreatDetectionCustomModuleName('[ORGANIZATION]', '[MODULE]');
     *     $securityCenterClient->deleteEventThreatDetectionCustomModule($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the custom module to delete.
     *
     *                             Its format is:
     *
     *                             * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
     *                             * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
     *                             * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEventThreatDetectionCustomModule($name, array $optionalArgs = [])
    {
        $request = new DeleteEventThreatDetectionCustomModuleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteEventThreatDetectionCustomModule', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes an existing mute config.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->muteConfigName('[ORGANIZATION]', '[MUTE_CONFIG]');
     *     $securityCenterClient->deleteMuteConfig($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the mute config to delete. Its format is
     *                             `organizations/{organization}/muteConfigs/{config_id}`,
     *                             `folders/{folder}/muteConfigs/{config_id}`,
     *                             `projects/{project}/muteConfigs/{config_id}`,
     *                             `organizations/{organization}/locations/global/muteConfigs/{config_id}`,
     *                             `folders/{folder}/locations/global/muteConfigs/{config_id}`, or
     *                             `projects/{project}/locations/global/muteConfigs/{config_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteMuteConfig($name, array $optionalArgs = [])
    {
        $request = new DeleteMuteConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteMuteConfig', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a notification config.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->notificationConfigName('[ORGANIZATION]', '[NOTIFICATION_CONFIG]');
     *     $securityCenterClient->deleteNotificationConfig($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the notification config to delete. Its format is
     *                             `organizations/[organization_id]/notificationConfigs/[config_id]`,
     *                             `folders/[folder_id]/notificationConfigs/[config_id]`,
     *                             or `projects/[project_id]/notificationConfigs/[config_id]`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteNotificationConfig($name, array $optionalArgs = [])
    {
        $request = new DeleteNotificationConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteNotificationConfig', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a ResourceValueConfig.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->resourceValueConfigName('[ORGANIZATION]', '[RESOURCE_VALUE_CONFIG]');
     *     $securityCenterClient->deleteResourceValueConfig($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the ResourceValueConfig to delete
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteResourceValueConfig($name, array $optionalArgs = [])
    {
        $request = new DeleteResourceValueConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteResourceValueConfig', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
     * descendants in the CRM hierarchy. This method is only supported for
     * resident custom modules.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->securityHealthAnalyticsCustomModuleName('[ORGANIZATION]', '[CUSTOM_MODULE]');
     *     $securityCenterClient->deleteSecurityHealthAnalyticsCustomModule($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the custom module to delete. Its format is
     *                             `organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}`,
     *                             `folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}`,
     *                             or
     *                             `projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSecurityHealthAnalyticsCustomModule($name, array $optionalArgs = [])
    {
        $request = new DeleteSecurityHealthAnalyticsCustomModuleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteSecurityHealthAnalyticsCustomModule', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a BigQuery export.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->bigQueryExportName('[ORGANIZATION]', '[EXPORT]');
     *     $response = $securityCenterClient->getBigQueryExport($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the BigQuery export to retrieve. Its format is
     *                             `organizations/{organization}/bigQueryExports/{export_id}`,
     *                             `folders/{folder}/bigQueryExports/{export_id}`, or
     *                             `projects/{project}/bigQueryExports/{export_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\BigQueryExport
     *
     * @throws ApiException if the remote call fails
     */
    public function getBigQueryExport($name, array $optionalArgs = [])
    {
        $request = new GetBigQueryExportRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetBigQueryExport', BigQueryExport::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets an effective Event Threat Detection custom module at the given level.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->effectiveEventThreatDetectionCustomModuleName('[ORGANIZATION]', '[MODULE]');
     *     $response = $securityCenterClient->getEffectiveEventThreatDetectionCustomModule($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the effective Event Threat Detection custom
     *                             module.
     *
     *                             Its format is:
     *
     *                             * `organizations/{organization}/eventThreatDetectionSettings/effectiveCustomModules/{module}`.
     *                             * `folders/{folder}/eventThreatDetectionSettings/effectiveCustomModules/{module}`.
     *                             * `projects/{project}/eventThreatDetectionSettings/effectiveCustomModules/{module}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\EffectiveEventThreatDetectionCustomModule
     *
     * @throws ApiException if the remote call fails
     */
    public function getEffectiveEventThreatDetectionCustomModule($name, array $optionalArgs = [])
    {
        $request = new GetEffectiveEventThreatDetectionCustomModuleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEffectiveEventThreatDetectionCustomModule', EffectiveEventThreatDetectionCustomModule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Retrieves an EffectiveSecurityHealthAnalyticsCustomModule.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->effectiveSecurityHealthAnalyticsCustomModuleName('[ORGANIZATION]', '[EFFECTIVE_CUSTOM_MODULE]');
     *     $response = $securityCenterClient->getEffectiveSecurityHealthAnalyticsCustomModule($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the effective custom module to get. Its format is
     *                             `organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}`,
     *                             `folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}`,
     *                             or
     *                             `projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\EffectiveSecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException if the remote call fails
     */
    public function getEffectiveSecurityHealthAnalyticsCustomModule($name, array $optionalArgs = [])
    {
        $request = new GetEffectiveSecurityHealthAnalyticsCustomModuleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEffectiveSecurityHealthAnalyticsCustomModule', EffectiveSecurityHealthAnalyticsCustomModule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets an Event Threat Detection custom module.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->eventThreatDetectionCustomModuleName('[ORGANIZATION]', '[MODULE]');
     *     $response = $securityCenterClient->getEventThreatDetectionCustomModule($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the custom module to get.
     *
     *                             Its format is:
     *
     *                             * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
     *                             * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
     *                             * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\EventThreatDetectionCustomModule
     *
     * @throws ApiException if the remote call fails
     */
    public function getEventThreatDetectionCustomModule($name, array $optionalArgs = [])
    {
        $request = new GetEventThreatDetectionCustomModuleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEventThreatDetectionCustomModule', EventThreatDetectionCustomModule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the access control policy on the specified Source.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $resource = 'resource';
     *     $response = $securityCenterClient->getIamPolicy($resource);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetIamPolicy', Policy::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a mute config.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->muteConfigName('[ORGANIZATION]', '[MUTE_CONFIG]');
     *     $response = $securityCenterClient->getMuteConfig($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the mute config to retrieve. Its format is
     *                             `organizations/{organization}/muteConfigs/{config_id}`,
     *                             `folders/{folder}/muteConfigs/{config_id}`,
     *                             `projects/{project}/muteConfigs/{config_id}`,
     *                             `organizations/{organization}/locations/global/muteConfigs/{config_id}`,
     *                             `folders/{folder}/locations/global/muteConfigs/{config_id}`, or
     *                             `projects/{project}/locations/global/muteConfigs/{config_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\MuteConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getMuteConfig($name, array $optionalArgs = [])
    {
        $request = new GetMuteConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetMuteConfig', MuteConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a notification config.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->notificationConfigName('[ORGANIZATION]', '[NOTIFICATION_CONFIG]');
     *     $response = $securityCenterClient->getNotificationConfig($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the notification config to get. Its format is
     *                             `organizations/[organization_id]/notificationConfigs/[config_id]`,
     *                             `folders/[folder_id]/notificationConfigs/[config_id]`,
     *                             or `projects/[project_id]/notificationConfigs/[config_id]`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\NotificationConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getNotificationConfig($name, array $optionalArgs = [])
    {
        $request = new GetNotificationConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetNotificationConfig', NotificationConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the settings for an organization.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->organizationSettingsName('[ORGANIZATION]');
     *     $response = $securityCenterClient->getOrganizationSettings($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the organization to get organization settings for. Its
     *                             format is `organizations/[organization_id]/organizationSettings`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\OrganizationSettings
     *
     * @throws ApiException if the remote call fails
     */
    public function getOrganizationSettings($name, array $optionalArgs = [])
    {
        $request = new GetOrganizationSettingsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetOrganizationSettings', OrganizationSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a ResourceValueConfig.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->resourceValueConfigName('[ORGANIZATION]', '[RESOURCE_VALUE_CONFIG]');
     *     $response = $securityCenterClient->getResourceValueConfig($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource value config to retrieve. Its format is
     *                             `organizations/{organization}/resourceValueConfigs/{config_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\ResourceValueConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getResourceValueConfig($name, array $optionalArgs = [])
    {
        $request = new GetResourceValueConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetResourceValueConfig', ResourceValueConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Retrieves a SecurityHealthAnalyticsCustomModule.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->securityHealthAnalyticsCustomModuleName('[ORGANIZATION]', '[CUSTOM_MODULE]');
     *     $response = $securityCenterClient->getSecurityHealthAnalyticsCustomModule($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the custom module to get. Its format is
     *                             `organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}`,
     *                             `folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}`,
     *                             or
     *                             `projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\SecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException if the remote call fails
     */
    public function getSecurityHealthAnalyticsCustomModule($name, array $optionalArgs = [])
    {
        $request = new GetSecurityHealthAnalyticsCustomModuleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetSecurityHealthAnalyticsCustomModule', SecurityHealthAnalyticsCustomModule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Get the simulation by name or the latest simulation for the given
     * organization.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->simulationName('[ORGANIZATION]', '[SIMULATION]');
     *     $response = $securityCenterClient->getSimulation($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The organization name or simulation name of this simulation
     *
     *                             Valid format:
     *                             `organizations/{organization}/simulations/latest`
     *                             `organizations/{organization}/simulations/{simulation}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\Simulation
     *
     * @throws ApiException if the remote call fails
     */
    public function getSimulation($name, array $optionalArgs = [])
    {
        $request = new GetSimulationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetSimulation', Simulation::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a source.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->sourceName('[ORGANIZATION]', '[SOURCE]');
     *     $response = $securityCenterClient->getSource($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Relative resource name of the source. Its format is
     *                             `organizations/[organization_id]/source/[source_id]`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\Source
     *
     * @throws ApiException if the remote call fails
     */
    public function getSource($name, array $optionalArgs = [])
    {
        $request = new GetSourceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetSource', Source::class, $optionalArgs, $request)->wait();
    }

    /**
     * Get the valued resource by name
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->valuedResourceName('[ORGANIZATION]', '[SIMULATION]', '[VALUED_RESOURCE]');
     *     $response = $securityCenterClient->getValuedResource($formattedName);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of this valued resource
     *
     *                             Valid format:
     *                             `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\ValuedResource
     *
     * @throws ApiException if the remote call fails
     */
    public function getValuedResource($name, array $optionalArgs = [])
    {
        $request = new GetValuedResourceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetValuedResource', ValuedResource::class, $optionalArgs, $request)->wait();
    }

    /**
     * Filters an organization's assets and  groups them by their specified
     * properties.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->projectName('[PROJECT]');
     *     $groupBy = 'group_by';
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->groupAssets($formattedParent, $groupBy);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->groupAssets($formattedParent, $groupBy);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the parent to group the assets by. Its format is
     *                             `organizations/[organization_id]`, `folders/[folder_id]`, or
     *                             `projects/[project_id]`.
     * @param string $groupBy      Required. Expression that defines what assets fields to use for grouping.
     *                             The string value should follow SQL syntax: comma separated list of fields.
     *                             For example:
     *                             "security_center_properties.resource_project,security_center_properties.project".
     *
     *                             The following fields are supported when compare_duration is not set:
     *
     *                             * security_center_properties.resource_project
     *                             * security_center_properties.resource_project_display_name
     *                             * security_center_properties.resource_type
     *                             * security_center_properties.resource_parent
     *                             * security_center_properties.resource_parent_display_name
     *
     *                             The following fields are supported when compare_duration is set:
     *
     *                             * security_center_properties.resource_type
     *                             * security_center_properties.resource_project_display_name
     *                             * security_center_properties.resource_parent_display_name
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Expression that defines the filter to apply across assets.
     *           The expression is a list of zero or more restrictions combined via logical
     *           operators `AND` and `OR`.
     *           Parentheses are supported, and `OR` has higher precedence than `AND`.
     *
     *           Restrictions have the form `<field> <operator> <value>` and may have a `-`
     *           character in front of them to indicate negation. The fields map to those
     *           defined in the Asset resource. Examples include:
     *
     *           * name
     *           * security_center_properties.resource_name
     *           * resource_properties.a_property
     *           * security_marks.marks.marka
     *
     *           The supported operators are:
     *
     *           * `=` for all value types.
     *           * `>`, `<`, `>=`, `<=` for integer values.
     *           * `:`, meaning substring matching, for strings.
     *
     *           The supported value types are:
     *
     *           * string literals in quotes.
     *           * integer literals without quotes.
     *           * boolean literals `true` and `false` without quotes.
     *
     *           The following field and operator combinations are supported:
     *
     *           * name: `=`
     *           * update_time: `=`, `>`, `<`, `>=`, `<=`
     *
     *           Usage: This should be milliseconds since epoch or an RFC3339 string.
     *           Examples:
     *           `update_time = "2019-06-10T16:07:18-07:00"`
     *           `update_time = 1560208038000`
     *
     *           * create_time: `=`, `>`, `<`, `>=`, `<=`
     *
     *           Usage: This should be milliseconds since epoch or an RFC3339 string.
     *           Examples:
     *           `create_time = "2019-06-10T16:07:18-07:00"`
     *           `create_time = 1560208038000`
     *
     *           * iam_policy.policy_blob: `=`, `:`
     *           * resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
     *           * security_marks.marks: `=`, `:`
     *           * security_center_properties.resource_name: `=`, `:`
     *           * security_center_properties.resource_display_name: `=`, `:`
     *           * security_center_properties.resource_type: `=`, `:`
     *           * security_center_properties.resource_parent: `=`, `:`
     *           * security_center_properties.resource_parent_display_name: `=`, `:`
     *           * security_center_properties.resource_project: `=`, `:`
     *           * security_center_properties.resource_project_display_name: `=`, `:`
     *           * security_center_properties.resource_owners: `=`, `:`
     *
     *           For example, `resource_properties.size = 100` is a valid filter string.
     *
     *           Use a partial match on the empty string to filter based on a property
     *           existing: `resource_properties.my_property : ""`
     *
     *           Use a negated partial match on the empty string to filter based on a
     *           property not existing: `-resource_properties.my_property : ""`
     *     @type Duration $compareDuration
     *           When compare_duration is set, the GroupResult's "state_change" property is
     *           updated to indicate whether the asset was added, removed, or remained
     *           present during the compare_duration period of time that precedes the
     *           read_time. This is the time between (read_time - compare_duration) and
     *           read_time.
     *
     *           The state change value is derived based on the presence of the asset at the
     *           two points in time. Intermediate state changes between the two times don't
     *           affect the result. For example, the results aren't affected if the asset is
     *           removed and re-created again.
     *
     *           Possible "state_change" values when compare_duration is specified:
     *
     *           * "ADDED":   indicates that the asset was not present at the start of
     *           compare_duration, but present at reference_time.
     *           * "REMOVED": indicates that the asset was present at the start of
     *           compare_duration, but not present at reference_time.
     *           * "ACTIVE":  indicates that the asset was present at both the
     *           start and the end of the time period defined by
     *           compare_duration and reference_time.
     *
     *           If compare_duration is not specified, then the only possible state_change
     *           is "UNUSED", which will be the state_change set for all assets present at
     *           read_time.
     *
     *           If this field is set then `state_change` must be a specified field in
     *           `group_by`.
     *     @type Timestamp $readTime
     *           Time used as a reference point when filtering assets. The filter is limited
     *           to assets existing at the supplied time and their values are those at that
     *           specific time. Absence of this field will default to the API's version of
     *           NOW.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function groupAssets($parent, $groupBy, array $optionalArgs = [])
    {
        $request = new GroupAssetsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setGroupBy($groupBy);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['compareDuration'])) {
            $request->setCompareDuration($optionalArgs['compareDuration']);
        }

        if (isset($optionalArgs['readTime'])) {
            $request->setReadTime($optionalArgs['readTime']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('GroupAssets', $optionalArgs, GroupAssetsResponse::class, $request);
    }

    /**
     * Filters an organization or source's findings and  groups them by their
     * specified properties.
     *
     * To group across all sources provide a `-` as the source id.
     * Example: /v1/organizations/{organization_id}/sources/-/findings,
     * /v1/folders/{folder_id}/sources/-/findings,
     * /v1/projects/{project_id}/sources/-/findings
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->sourceName('[ORGANIZATION]', '[SOURCE]');
     *     $groupBy = 'group_by';
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->groupFindings($formattedParent, $groupBy);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->groupFindings($formattedParent, $groupBy);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of the source to groupBy. Its format is
     *                             `organizations/[organization_id]/sources/[source_id]`,
     *                             `folders/[folder_id]/sources/[source_id]`, or
     *                             `projects/[project_id]/sources/[source_id]`. To groupBy across all sources
     *                             provide a source_id of `-`. For example:
     *                             `organizations/{organization_id}/sources/-, folders/{folder_id}/sources/-`,
     *                             or `projects/{project_id}/sources/-`
     * @param string $groupBy      Required. Expression that defines what assets fields to use for grouping
     *                             (including `state_change`). The string value should follow SQL syntax:
     *                             comma separated list of fields. For example: "parent,resource_name".
     *
     *                             The following fields are supported when compare_duration is set:
     *
     *                             * state_change
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Expression that defines the filter to apply across findings.
     *           The expression is a list of one or more restrictions combined via logical
     *           operators `AND` and `OR`.
     *           Parentheses are supported, and `OR` has higher precedence than `AND`.
     *
     *           Restrictions have the form `<field> <operator> <value>` and may have a `-`
     *           character in front of them to indicate negation. Examples include:
     *
     *           * name
     *           * source_properties.a_property
     *           * security_marks.marks.marka
     *
     *           The supported operators are:
     *
     *           * `=` for all value types.
     *           * `>`, `<`, `>=`, `<=` for integer values.
     *           * `:`, meaning substring matching, for strings.
     *
     *           The supported value types are:
     *
     *           * string literals in quotes.
     *           * integer literals without quotes.
     *           * boolean literals `true` and `false` without quotes.
     *
     *           The following field and operator combinations are supported:
     *
     *           * name: `=`
     *           * parent: `=`, `:`
     *           * resource_name: `=`, `:`
     *           * state: `=`, `:`
     *           * category: `=`, `:`
     *           * external_uri: `=`, `:`
     *           * event_time: `=`, `>`, `<`, `>=`, `<=`
     *
     *           Usage: This should be milliseconds since epoch or an RFC3339 string.
     *           Examples:
     *           `event_time = "2019-06-10T16:07:18-07:00"`
     *           `event_time = 1560208038000`
     *
     *           * severity: `=`, `:`
     *           * workflow_state: `=`, `:`
     *           * security_marks.marks: `=`, `:`
     *           * source_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
     *
     *           For example, `source_properties.size = 100` is a valid filter string.
     *
     *           Use a partial match on the empty string to filter based on a property
     *           existing: `source_properties.my_property : ""`
     *
     *           Use a negated partial match on the empty string to filter based on a
     *           property not existing: `-source_properties.my_property : ""`
     *
     *           * resource:
     *           * resource.name: `=`, `:`
     *           * resource.parent_name: `=`, `:`
     *           * resource.parent_display_name: `=`, `:`
     *           * resource.project_name: `=`, `:`
     *           * resource.project_display_name: `=`, `:`
     *           * resource.type: `=`, `:`
     *     @type Timestamp $readTime
     *           Time used as a reference point when filtering findings. The filter is
     *           limited to findings existing at the supplied time and their values are
     *           those at that specific time. Absence of this field will default to the
     *           API's version of NOW.
     *     @type Duration $compareDuration
     *           When compare_duration is set, the GroupResult's "state_change" attribute is
     *           updated to indicate whether the finding had its state changed, the
     *           finding's state remained unchanged, or if the finding was added during the
     *           compare_duration period of time that precedes the read_time. This is the
     *           time between (read_time - compare_duration) and read_time.
     *
     *           The state_change value is derived based on the presence and state of the
     *           finding at the two points in time. Intermediate state changes between the
     *           two times don't affect the result. For example, the results aren't affected
     *           if the finding is made inactive and then active again.
     *
     *           Possible "state_change" values when compare_duration is specified:
     *
     *           * "CHANGED":   indicates that the finding was present and matched the given
     *           filter at the start of compare_duration, but changed its
     *           state at read_time.
     *           * "UNCHANGED": indicates that the finding was present and matched the given
     *           filter at the start of compare_duration and did not change
     *           state at read_time.
     *           * "ADDED":     indicates that the finding did not match the given filter or
     *           was not present at the start of compare_duration, but was
     *           present at read_time.
     *           * "REMOVED":   indicates that the finding was present and matched the
     *           filter at the start of compare_duration, but did not match
     *           the filter at read_time.
     *
     *           If compare_duration is not specified, then the only possible state_change
     *           is "UNUSED",  which will be the state_change set for all findings present
     *           at read_time.
     *
     *           If this field is set then `state_change` must be a specified field in
     *           `group_by`.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function groupFindings($parent, $groupBy, array $optionalArgs = [])
    {
        $request = new GroupFindingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setGroupBy($groupBy);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['readTime'])) {
            $request->setReadTime($optionalArgs['readTime']);
        }

        if (isset($optionalArgs['compareDuration'])) {
            $request->setCompareDuration($optionalArgs['compareDuration']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('GroupFindings', $optionalArgs, GroupFindingsResponse::class, $request);
    }

    /**
     * Lists an organization's assets.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->projectName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listAssets($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listAssets($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the parent resource that contains the assets. The
     *                             value that you can specify on parent depends on the method in which you
     *                             specify parent. You can specify one of the following values:
     *                             `organizations/[organization_id]`, `folders/[folder_id]`, or
     *                             `projects/[project_id]`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Expression that defines the filter to apply across assets.
     *           The expression is a list of zero or more restrictions combined via logical
     *           operators `AND` and `OR`.
     *           Parentheses are supported, and `OR` has higher precedence than `AND`.
     *
     *           Restrictions have the form `<field> <operator> <value>` and may have a `-`
     *           character in front of them to indicate negation. The fields map to those
     *           defined in the Asset resource. Examples include:
     *
     *           * name
     *           * security_center_properties.resource_name
     *           * resource_properties.a_property
     *           * security_marks.marks.marka
     *
     *           The supported operators are:
     *
     *           * `=` for all value types.
     *           * `>`, `<`, `>=`, `<=` for integer values.
     *           * `:`, meaning substring matching, for strings.
     *
     *           The supported value types are:
     *
     *           * string literals in quotes.
     *           * integer literals without quotes.
     *           * boolean literals `true` and `false` without quotes.
     *
     *           The following are the allowed field and operator combinations:
     *
     *           * name: `=`
     *           * update_time: `=`, `>`, `<`, `>=`, `<=`
     *
     *           Usage: This should be milliseconds since epoch or an RFC3339 string.
     *           Examples:
     *           `update_time = "2019-06-10T16:07:18-07:00"`
     *           `update_time = 1560208038000`
     *
     *           * create_time: `=`, `>`, `<`, `>=`, `<=`
     *
     *           Usage: This should be milliseconds since epoch or an RFC3339 string.
     *           Examples:
     *           `create_time = "2019-06-10T16:07:18-07:00"`
     *           `create_time = 1560208038000`
     *
     *           * iam_policy.policy_blob: `=`, `:`
     *           * resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
     *           * security_marks.marks: `=`, `:`
     *           * security_center_properties.resource_name: `=`, `:`
     *           * security_center_properties.resource_display_name: `=`, `:`
     *           * security_center_properties.resource_type: `=`, `:`
     *           * security_center_properties.resource_parent: `=`, `:`
     *           * security_center_properties.resource_parent_display_name: `=`, `:`
     *           * security_center_properties.resource_project: `=`, `:`
     *           * security_center_properties.resource_project_display_name: `=`, `:`
     *           * security_center_properties.resource_owners: `=`, `:`
     *
     *           For example, `resource_properties.size = 100` is a valid filter string.
     *
     *           Use a partial match on the empty string to filter based on a property
     *           existing: `resource_properties.my_property : ""`
     *
     *           Use a negated partial match on the empty string to filter based on a
     *           property not existing: `-resource_properties.my_property : ""`
     *     @type string $orderBy
     *           Expression that defines what fields and order to use for sorting. The
     *           string value should follow SQL syntax: comma separated list of fields. For
     *           example: "name,resource_properties.a_property". The default sorting order
     *           is ascending. To specify descending order for a field, a suffix " desc"
     *           should be appended to the field name. For example: "name
     *           desc,resource_properties.a_property". Redundant space characters in the
     *           syntax are insignificant. "name desc,resource_properties.a_property" and "
     *           name     desc  ,   resource_properties.a_property  " are equivalent.
     *
     *           The following fields are supported:
     *           name
     *           update_time
     *           resource_properties
     *           security_marks.marks
     *           security_center_properties.resource_name
     *           security_center_properties.resource_display_name
     *           security_center_properties.resource_parent
     *           security_center_properties.resource_parent_display_name
     *           security_center_properties.resource_project
     *           security_center_properties.resource_project_display_name
     *           security_center_properties.resource_type
     *     @type Timestamp $readTime
     *           Time used as a reference point when filtering assets. The filter is limited
     *           to assets existing at the supplied time and their values are those at that
     *           specific time. Absence of this field will default to the API's version of
     *           NOW.
     *     @type Duration $compareDuration
     *           When compare_duration is set, the ListAssetsResult's "state_change"
     *           attribute is updated to indicate whether the asset was added, removed, or
     *           remained present during the compare_duration period of time that precedes
     *           the read_time. This is the time between (read_time - compare_duration) and
     *           read_time.
     *
     *           The state_change value is derived based on the presence of the asset at the
     *           two points in time. Intermediate state changes between the two times don't
     *           affect the result. For example, the results aren't affected if the asset is
     *           removed and re-created again.
     *
     *           Possible "state_change" values when compare_duration is specified:
     *
     *           * "ADDED":   indicates that the asset was not present at the start of
     *           compare_duration, but present at read_time.
     *           * "REMOVED": indicates that the asset was present at the start of
     *           compare_duration, but not present at read_time.
     *           * "ACTIVE":  indicates that the asset was present at both the
     *           start and the end of the time period defined by
     *           compare_duration and read_time.
     *
     *           If compare_duration is not specified, then the only possible state_change
     *           is "UNUSED",  which will be the state_change set for all assets present at
     *           read_time.
     *     @type FieldMask $fieldMask
     *           A field mask to specify the ListAssetsResult fields to be listed in the
     *           response.
     *           An empty field mask will list all fields.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function listAssets($parent, array $optionalArgs = [])
    {
        $request = new ListAssetsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['readTime'])) {
            $request->setReadTime($optionalArgs['readTime']);
        }

        if (isset($optionalArgs['compareDuration'])) {
            $request->setCompareDuration($optionalArgs['compareDuration']);
        }

        if (isset($optionalArgs['fieldMask'])) {
            $request->setFieldMask($optionalArgs['fieldMask']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListAssets', $optionalArgs, ListAssetsResponse::class, $request);
    }

    /**
     * Lists the attack paths for a set of simulation results or valued resources
     * and filter.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->valuedResourceName('[ORGANIZATION]', '[SIMULATION]', '[VALUED_RESOURCE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listAttackPaths($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listAttackPaths($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of parent to list attack paths.
     *
     *                             Valid formats:
     *                             `organizations/{organization}`,
     *                             `organizations/{organization}/simulations/{simulation}`
     *                             `organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}`
     *                             `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           The filter expression that filters the attack path in the response.
     *           Supported fields:
     *
     *           * `valued_resources` supports =
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAttackPaths($parent, array $optionalArgs = [])
    {
        $request = new ListAttackPathsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListAttackPaths', $optionalArgs, ListAttackPathsResponse::class, $request);
    }

    /**
     * Lists BigQuery exports. Note that when requesting BigQuery exports at a
     * given level all exports under that level are also returned e.g. if
     * requesting BigQuery exports under a folder, then all BigQuery exports
     * immediately under the folder plus the ones created under the projects
     * within the folder are returned.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->projectName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listBigQueryExports($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listBigQueryExports($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns the collection of BigQuery exports. Its
     *                             format is `organizations/[organization_id]`, `folders/[folder_id]`,
     *                             `projects/[project_id]`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listBigQueryExports($parent, array $optionalArgs = [])
    {
        $request = new ListBigQueryExportsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListBigQueryExports', $optionalArgs, ListBigQueryExportsResponse::class, $request);
    }

    /**
     * Lists all resident Event Threat Detection custom modules under the
     * given Resource Manager parent and its descendants.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->eventThreatDetectionSettingsName('[ORGANIZATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listDescendantEventThreatDetectionCustomModules($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listDescendantEventThreatDetectionCustomModules($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of the parent to list custom modules under.
     *
     *                             Its format is:
     *
     *                             * `organizations/{organization}/eventThreatDetectionSettings`.
     *                             * `folders/{folder}/eventThreatDetectionSettings`.
     *                             * `projects/{project}/eventThreatDetectionSettings`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDescendantEventThreatDetectionCustomModules($parent, array $optionalArgs = [])
    {
        $request = new ListDescendantEventThreatDetectionCustomModulesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListDescendantEventThreatDetectionCustomModules', $optionalArgs, ListDescendantEventThreatDetectionCustomModulesResponse::class, $request);
    }

    /**
     * Returns a list of all resident SecurityHealthAnalyticsCustomModules under
     * the given CRM parent and all of the parent’s CRM descendants.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->securityHealthAnalyticsSettingsName('[ORGANIZATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listDescendantSecurityHealthAnalyticsCustomModules($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listDescendantSecurityHealthAnalyticsCustomModules($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of parent to list descendant custom modules. Its format is
     *                             `organizations/{organization}/securityHealthAnalyticsSettings`,
     *                             `folders/{folder}/securityHealthAnalyticsSettings`, or
     *                             `projects/{project}/securityHealthAnalyticsSettings`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDescendantSecurityHealthAnalyticsCustomModules($parent, array $optionalArgs = [])
    {
        $request = new ListDescendantSecurityHealthAnalyticsCustomModulesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListDescendantSecurityHealthAnalyticsCustomModules', $optionalArgs, ListDescendantSecurityHealthAnalyticsCustomModulesResponse::class, $request);
    }

    /**
     * Lists all effective Event Threat Detection custom modules for the
     * given parent. This includes resident modules defined at the scope of the
     * parent along with modules inherited from its ancestors.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->eventThreatDetectionSettingsName('[ORGANIZATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listEffectiveEventThreatDetectionCustomModules($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listEffectiveEventThreatDetectionCustomModules($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of the parent to list custom modules for.
     *
     *                             Its format is:
     *
     *                             * `organizations/{organization}/eventThreatDetectionSettings`.
     *                             * `folders/{folder}/eventThreatDetectionSettings`.
     *                             * `projects/{project}/eventThreatDetectionSettings`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEffectiveEventThreatDetectionCustomModules($parent, array $optionalArgs = [])
    {
        $request = new ListEffectiveEventThreatDetectionCustomModulesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListEffectiveEventThreatDetectionCustomModules', $optionalArgs, ListEffectiveEventThreatDetectionCustomModulesResponse::class, $request);
    }

    /**
     * Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
     * given parent. This includes resident modules defined at the scope of the
     * parent, and inherited modules, inherited from CRM ancestors.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->securityHealthAnalyticsSettingsName('[ORGANIZATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listEffectiveSecurityHealthAnalyticsCustomModules($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listEffectiveSecurityHealthAnalyticsCustomModules($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of parent to list effective custom modules. Its format is
     *                             `organizations/{organization}/securityHealthAnalyticsSettings`,
     *                             `folders/{folder}/securityHealthAnalyticsSettings`, or
     *                             `projects/{project}/securityHealthAnalyticsSettings`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEffectiveSecurityHealthAnalyticsCustomModules($parent, array $optionalArgs = [])
    {
        $request = new ListEffectiveSecurityHealthAnalyticsCustomModulesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListEffectiveSecurityHealthAnalyticsCustomModules', $optionalArgs, ListEffectiveSecurityHealthAnalyticsCustomModulesResponse::class, $request);
    }

    /**
     * Lists all Event Threat Detection custom modules for the given
     * Resource Manager parent. This includes resident modules defined at the
     * scope of the parent along with modules inherited from ancestors.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->eventThreatDetectionSettingsName('[ORGANIZATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listEventThreatDetectionCustomModules($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listEventThreatDetectionCustomModules($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of the parent to list custom modules under.
     *
     *                             Its format is:
     *
     *                             * `organizations/{organization}/eventThreatDetectionSettings`.
     *                             * `folders/{folder}/eventThreatDetectionSettings`.
     *                             * `projects/{project}/eventThreatDetectionSettings`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEventThreatDetectionCustomModules($parent, array $optionalArgs = [])
    {
        $request = new ListEventThreatDetectionCustomModulesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListEventThreatDetectionCustomModules', $optionalArgs, ListEventThreatDetectionCustomModulesResponse::class, $request);
    }

    /**
     * Lists an organization or source's findings.
     *
     * To list across all sources provide a `-` as the source id.
     * Example: /v1/organizations/{organization_id}/sources/-/findings
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->sourceName('[ORGANIZATION]', '[SOURCE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listFindings($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listFindings($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of the source the findings belong to. Its format is
     *                             `organizations/[organization_id]/sources/[source_id]`,
     *                             `folders/[folder_id]/sources/[source_id]`, or
     *                             `projects/[project_id]/sources/[source_id]`. To list across all sources
     *                             provide a source_id of `-`. For example:
     *                             `organizations/{organization_id}/sources/-`,
     *                             `folders/{folder_id}/sources/-` or `projects/{projects_id}/sources/-`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Expression that defines the filter to apply across findings.
     *           The expression is a list of one or more restrictions combined via logical
     *           operators `AND` and `OR`.
     *           Parentheses are supported, and `OR` has higher precedence than `AND`.
     *
     *           Restrictions have the form `<field> <operator> <value>` and may have a `-`
     *           character in front of them to indicate negation. Examples include:
     *
     *           * name
     *           * source_properties.a_property
     *           * security_marks.marks.marka
     *
     *           The supported operators are:
     *
     *           * `=` for all value types.
     *           * `>`, `<`, `>=`, `<=` for integer values.
     *           * `:`, meaning substring matching, for strings.
     *
     *           The supported value types are:
     *
     *           * string literals in quotes.
     *           * integer literals without quotes.
     *           * boolean literals `true` and `false` without quotes.
     *
     *           The following field and operator combinations are supported:
     *
     *           * name: `=`
     *           * parent: `=`, `:`
     *           * resource_name: `=`, `:`
     *           * state: `=`, `:`
     *           * category: `=`, `:`
     *           * external_uri: `=`, `:`
     *           * event_time: `=`, `>`, `<`, `>=`, `<=`
     *
     *           Usage: This should be milliseconds since epoch or an RFC3339 string.
     *           Examples:
     *           `event_time = "2019-06-10T16:07:18-07:00"`
     *           `event_time = 1560208038000`
     *
     *           * severity: `=`, `:`
     *           * workflow_state: `=`, `:`
     *           * security_marks.marks: `=`, `:`
     *           * source_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
     *
     *           For example, `source_properties.size = 100` is a valid filter string.
     *
     *           Use a partial match on the empty string to filter based on a property
     *           existing: `source_properties.my_property : ""`
     *
     *           Use a negated partial match on the empty string to filter based on a
     *           property not existing: `-source_properties.my_property : ""`
     *
     *           * resource:
     *           * resource.name: `=`, `:`
     *           * resource.parent_name: `=`, `:`
     *           * resource.parent_display_name: `=`, `:`
     *           * resource.project_name: `=`, `:`
     *           * resource.project_display_name: `=`, `:`
     *           * resource.type: `=`, `:`
     *           * resource.folders.resource_folder: `=`, `:`
     *           * resource.display_name: `=`, `:`
     *     @type string $orderBy
     *           Expression that defines what fields and order to use for sorting. The
     *           string value should follow SQL syntax: comma separated list of fields. For
     *           example: "name,resource_properties.a_property". The default sorting order
     *           is ascending. To specify descending order for a field, a suffix " desc"
     *           should be appended to the field name. For example: "name
     *           desc,source_properties.a_property". Redundant space characters in the
     *           syntax are insignificant. "name desc,source_properties.a_property" and "
     *           name     desc  ,   source_properties.a_property  " are equivalent.
     *
     *           The following fields are supported:
     *           name
     *           parent
     *           state
     *           category
     *           resource_name
     *           event_time
     *           source_properties
     *           security_marks.marks
     *     @type Timestamp $readTime
     *           Time used as a reference point when filtering findings. The filter is
     *           limited to findings existing at the supplied time and their values are
     *           those at that specific time. Absence of this field will default to the
     *           API's version of NOW.
     *     @type Duration $compareDuration
     *           When compare_duration is set, the ListFindingsResult's "state_change"
     *           attribute is updated to indicate whether the finding had its state changed,
     *           the finding's state remained unchanged, or if the finding was added in any
     *           state during the compare_duration period of time that precedes the
     *           read_time. This is the time between (read_time - compare_duration) and
     *           read_time.
     *
     *           The state_change value is derived based on the presence and state of the
     *           finding at the two points in time. Intermediate state changes between the
     *           two times don't affect the result. For example, the results aren't affected
     *           if the finding is made inactive and then active again.
     *
     *           Possible "state_change" values when compare_duration is specified:
     *
     *           * "CHANGED":   indicates that the finding was present and matched the given
     *           filter at the start of compare_duration, but changed its
     *           state at read_time.
     *           * "UNCHANGED": indicates that the finding was present and matched the given
     *           filter at the start of compare_duration and did not change
     *           state at read_time.
     *           * "ADDED":     indicates that the finding did not match the given filter or
     *           was not present at the start of compare_duration, but was
     *           present at read_time.
     *           * "REMOVED":   indicates that the finding was present and matched the
     *           filter at the start of compare_duration, but did not match
     *           the filter at read_time.
     *
     *           If compare_duration is not specified, then the only possible state_change
     *           is "UNUSED", which will be the state_change set for all findings present at
     *           read_time.
     *     @type FieldMask $fieldMask
     *           A field mask to specify the Finding fields to be listed in the response.
     *           An empty field mask will list all fields.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listFindings($parent, array $optionalArgs = [])
    {
        $request = new ListFindingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['readTime'])) {
            $request->setReadTime($optionalArgs['readTime']);
        }

        if (isset($optionalArgs['compareDuration'])) {
            $request->setCompareDuration($optionalArgs['compareDuration']);
        }

        if (isset($optionalArgs['fieldMask'])) {
            $request->setFieldMask($optionalArgs['fieldMask']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListFindings', $optionalArgs, ListFindingsResponse::class, $request);
    }

    /**
     * Lists mute configs.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listMuteConfigs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listMuteConfigs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns the collection of mute configs. Its format
     *                             is `organizations/[organization_id]`, `folders/[folder_id]`,
     *                             `projects/[project_id]`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listMuteConfigs($parent, array $optionalArgs = [])
    {
        $request = new ListMuteConfigsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListMuteConfigs', $optionalArgs, ListMuteConfigsResponse::class, $request);
    }

    /**
     * Lists notification configs.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->projectName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listNotificationConfigs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listNotificationConfigs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the parent in which to list the notification
     *                             configurations. Its format is "organizations/[organization_id]",
     *                             "folders/[folder_id]", or "projects/[project_id]".
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listNotificationConfigs($parent, array $optionalArgs = [])
    {
        $request = new ListNotificationConfigsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListNotificationConfigs', $optionalArgs, ListNotificationConfigsResponse::class, $request);
    }

    /**
     * Lists all ResourceValueConfigs.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->organizationName('[ORGANIZATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listResourceValueConfigs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listResourceValueConfigs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns the collection of resource value configs.
     *                             Its format is
     *                             `organizations/[organization_id]`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listResourceValueConfigs($parent, array $optionalArgs = [])
    {
        $request = new ListResourceValueConfigsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListResourceValueConfigs', $optionalArgs, ListResourceValueConfigsResponse::class, $request);
    }

    /**
     * Returns a list of all SecurityHealthAnalyticsCustomModules for the given
     * parent. This includes resident modules defined at the scope of the parent,
     * and inherited modules, inherited from CRM ancestors.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->securityHealthAnalyticsSettingsName('[ORGANIZATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listSecurityHealthAnalyticsCustomModules($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listSecurityHealthAnalyticsCustomModules($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of parent to list custom modules. Its format is
     *                             `organizations/{organization}/securityHealthAnalyticsSettings`,
     *                             `folders/{folder}/securityHealthAnalyticsSettings`, or
     *                             `projects/{project}/securityHealthAnalyticsSettings`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSecurityHealthAnalyticsCustomModules($parent, array $optionalArgs = [])
    {
        $request = new ListSecurityHealthAnalyticsCustomModulesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListSecurityHealthAnalyticsCustomModules', $optionalArgs, ListSecurityHealthAnalyticsCustomModulesResponse::class, $request);
    }

    /**
     * Lists all sources belonging to an organization.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->projectName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listSources($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listSources($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name of the parent of sources to list. Its format should
     *                             be `organizations/[organization_id]`, `folders/[folder_id]`, or
     *                             `projects/[project_id]`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSources($parent, array $optionalArgs = [])
    {
        $request = new ListSourcesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListSources', $optionalArgs, ListSourcesResponse::class, $request);
    }

    /**
     * Lists the valued resources for a set of simulation results and filter.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->simulationName('[ORGANIZATION]', '[SIMULATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $securityCenterClient->listValuedResources($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $securityCenterClient->listValuedResources($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of parent to list valued resources.
     *
     *                             Valid formats:
     *                             `organizations/{organization}`,
     *                             `organizations/{organization}/simulations/{simulation}`
     *                             `organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           The filter expression that filters the valued resources in the response.
     *           Supported fields:
     *
     *           * `resource_value` supports =
     *           * `resource_type` supports =
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $orderBy
     *           Optional. The fields by which to order the valued resources response.
     *
     *           Supported fields:
     *
     *           * `exposed_score`
     *
     *           * `resource_value`
     *
     *           * `resource_type`
     *
     *           * `resource`
     *
     *           * `display_name`
     *
     *           Values should be a comma separated list of fields. For example:
     *           `exposed_score,resource_value`.
     *
     *           The default sorting order is descending. To specify ascending or descending
     *           order for a field, append a ` ASC` or a ` DESC` suffix, respectively; for
     *           example: `exposed_score DESC`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listValuedResources($parent, array $optionalArgs = [])
    {
        $request = new ListValuedResourcesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListValuedResources', $optionalArgs, ListValuedResourcesResponse::class, $request);
    }

    /**
     * Runs asset discovery. The discovery is tracked with a long-running
     * operation.
     *
     * This API can only be called with limited frequency for an organization. If
     * it is called too frequently the caller will receive a TOO_MANY_REQUESTS
     * error.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->organizationName('[ORGANIZATION]');
     *     $operationResponse = $securityCenterClient->runAssetDiscovery($formattedParent);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $securityCenterClient->runAssetDiscovery($formattedParent);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $securityCenterClient->resumeOperation($operationName, 'runAssetDiscovery');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of the organization to run asset discovery for. Its format
     *                             is `organizations/[organization_id]`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function runAssetDiscovery($parent, array $optionalArgs = [])
    {
        $request = new RunAssetDiscoveryRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('RunAssetDiscovery', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the state of a finding.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->findingName('[ORGANIZATION]', '[SOURCE]', '[FINDING]');
     *     $state = State::STATE_UNSPECIFIED;
     *     $startTime = new Timestamp();
     *     $response = $securityCenterClient->setFindingState($formattedName, $state, $startTime);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string    $name         Required. The [relative resource
     *                                name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     *                                of the finding. Example:
     *                                `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`,
     *                                `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`,
     *                                `projects/{project_id}/sources/{source_id}/findings/{finding_id}`.
     * @param int       $state        Required. The desired State of the finding.
     *                                For allowed values, use constants defined on {@see \Google\Cloud\SecurityCenter\V1\Finding\State}
     * @param Timestamp $startTime    Required. The time at which the updated state takes effect.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\Finding
     *
     * @throws ApiException if the remote call fails
     */
    public function setFindingState($name, $state, $startTime, array $optionalArgs = [])
    {
        $request = new SetFindingStateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setState($state);
        $request->setStartTime($startTime);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('SetFindingState', Finding::class, $optionalArgs, $request)->wait();
    }

    /**
     * Sets the access control policy on the specified Source.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $securityCenterClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('SetIamPolicy', Policy::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates the mute state of a finding.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedName = $securityCenterClient->findingName('[ORGANIZATION]', '[SOURCE]', '[FINDING]');
     *     $mute = Mute::MUTE_UNSPECIFIED;
     *     $response = $securityCenterClient->setMute($formattedName, $mute);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The [relative resource
     *                             name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     *                             of the finding. Example:
     *                             `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`,
     *                             `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`,
     *                             `projects/{project_id}/sources/{source_id}/findings/{finding_id}`.
     * @param int    $mute         Required. The desired state of the Mute.
     *                             For allowed values, use constants defined on {@see \Google\Cloud\SecurityCenter\V1\Finding\Mute}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\Finding
     *
     * @throws ApiException if the remote call fails
     */
    public function setMute($name, $mute, array $optionalArgs = [])
    {
        $request = new SetMuteRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setMute($mute);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('SetMute', Finding::class, $optionalArgs, $request)->wait();
    }

    /**
     * Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $parent = 'parent';
     *     $customConfig = new CustomConfig();
     *     $resource = new SimulatedResource();
     *     $response = $securityCenterClient->simulateSecurityHealthAnalyticsCustomModule($parent, $customConfig, $resource);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string            $parent       Required. The relative resource name of the organization, project, or
     *                                        folder. For more information about relative resource names, see [Relative
     *                                        Resource
     *                                        Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     *                                        Example: `organizations/{organization_id}`
     * @param CustomConfig      $customConfig Required. The custom configuration that you need to test.
     * @param SimulatedResource $resource     Required. Resource data to simulate custom module against.
     * @param array             $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\SimulateSecurityHealthAnalyticsCustomModuleResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function simulateSecurityHealthAnalyticsCustomModule($parent, $customConfig, $resource, array $optionalArgs = [])
    {
        $request = new SimulateSecurityHealthAnalyticsCustomModuleRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCustomConfig($customConfig);
        $request->setResource($resource);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('SimulateSecurityHealthAnalyticsCustomModule', SimulateSecurityHealthAnalyticsCustomModuleResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the permissions that a caller has on the specified source.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $securityCenterClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions($resource, $permissions, array $optionalArgs = [])
    {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('TestIamPermissions', TestIamPermissionsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a BigQuery export.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $bigQueryExport = new BigQueryExport();
     *     $response = $securityCenterClient->updateBigQueryExport($bigQueryExport);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param BigQueryExport $bigQueryExport Required. The BigQuery export being updated.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *           If empty all mutable fields will be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\BigQueryExport
     *
     * @throws ApiException if the remote call fails
     */
    public function updateBigQueryExport($bigQueryExport, array $optionalArgs = [])
    {
        $request = new UpdateBigQueryExportRequest();
        $requestParamHeaders = [];
        $request->setBigQueryExport($bigQueryExport);
        $requestParamHeaders['big_query_export.name'] = $bigQueryExport->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateBigQueryExport', BigQueryExport::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates the Event Threat Detection custom module with the given name based
     * on the given update mask. Updating the enablement state is supported for
     * both resident and inherited modules (though resident modules cannot have an
     * enablement state of "inherited"). Updating the display name or
     * configuration of a module is supported for resident modules only. The type
     * of a module cannot be changed.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $eventThreatDetectionCustomModule = new EventThreatDetectionCustomModule();
     *     $response = $securityCenterClient->updateEventThreatDetectionCustomModule($eventThreatDetectionCustomModule);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param EventThreatDetectionCustomModule $eventThreatDetectionCustomModule Required. The module being updated.
     * @param array                            $optionalArgs                     {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *           If empty all mutable fields will be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\EventThreatDetectionCustomModule
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEventThreatDetectionCustomModule($eventThreatDetectionCustomModule, array $optionalArgs = [])
    {
        $request = new UpdateEventThreatDetectionCustomModuleRequest();
        $requestParamHeaders = [];
        $request->setEventThreatDetectionCustomModule($eventThreatDetectionCustomModule);
        $requestParamHeaders['event_threat_detection_custom_module.name'] = $eventThreatDetectionCustomModule->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateEventThreatDetectionCustomModule', EventThreatDetectionCustomModule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates external system. This is for a given finding.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $externalSystem = new ExternalSystem();
     *     $response = $securityCenterClient->updateExternalSystem($externalSystem);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param ExternalSystem $externalSystem Required. The external system resource to update.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The FieldMask to use when updating the external system resource.
     *
     *           If empty all mutable fields will be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\ExternalSystem
     *
     * @throws ApiException if the remote call fails
     */
    public function updateExternalSystem($externalSystem, array $optionalArgs = [])
    {
        $request = new UpdateExternalSystemRequest();
        $requestParamHeaders = [];
        $request->setExternalSystem($externalSystem);
        $requestParamHeaders['external_system.name'] = $externalSystem->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateExternalSystem', ExternalSystem::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates or updates a finding. The corresponding source must exist for a
     * finding creation to succeed.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $finding = new Finding();
     *     $response = $securityCenterClient->updateFinding($finding);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param Finding $finding      Required. The finding resource to update or create if it does not already
     *                              exist. parent, security_marks, and update_time will be ignored.
     *
     *                              In the case of creation, the finding id portion of the name must be
     *                              alphanumeric and less than or equal to 32 characters and greater than 0
     *                              characters in length.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The FieldMask to use when updating the finding resource. This field should
     *           not be specified when creating a finding.
     *
     *           When updating a finding, an empty mask is treated as updating all mutable
     *           fields and replacing source_properties.  Individual source_properties can
     *           be added/updated by using "source_properties.<property key>" in the field
     *           mask.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\Finding
     *
     * @throws ApiException if the remote call fails
     */
    public function updateFinding($finding, array $optionalArgs = [])
    {
        $request = new UpdateFindingRequest();
        $requestParamHeaders = [];
        $request->setFinding($finding);
        $requestParamHeaders['finding.name'] = $finding->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateFinding', Finding::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a mute config.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $muteConfig = new MuteConfig();
     *     $response = $securityCenterClient->updateMuteConfig($muteConfig);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param MuteConfig $muteConfig   Required. The mute config being updated.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *           If empty all mutable fields will be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\MuteConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function updateMuteConfig($muteConfig, array $optionalArgs = [])
    {
        $request = new UpdateMuteConfigRequest();
        $requestParamHeaders = [];
        $request->setMuteConfig($muteConfig);
        $requestParamHeaders['mute_config.name'] = $muteConfig->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateMuteConfig', MuteConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     *
     * Updates a notification config. The following update
     * fields are allowed: description, pubsub_topic, streaming_config.filter
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $notificationConfig = new NotificationConfig();
     *     $response = $securityCenterClient->updateNotificationConfig($notificationConfig);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param NotificationConfig $notificationConfig Required. The notification config to update.
     * @param array              $optionalArgs       {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The FieldMask to use when updating the notification config.
     *
     *           If empty all mutable fields will be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\NotificationConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function updateNotificationConfig($notificationConfig, array $optionalArgs = [])
    {
        $request = new UpdateNotificationConfigRequest();
        $requestParamHeaders = [];
        $request->setNotificationConfig($notificationConfig);
        $requestParamHeaders['notification_config.name'] = $notificationConfig->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateNotificationConfig', NotificationConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an organization's settings.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $organizationSettings = new OrganizationSettings();
     *     $response = $securityCenterClient->updateOrganizationSettings($organizationSettings);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param OrganizationSettings $organizationSettings Required. The organization settings resource to update.
     * @param array                $optionalArgs         {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The FieldMask to use when updating the settings resource.
     *
     *           If empty all mutable fields will be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\OrganizationSettings
     *
     * @throws ApiException if the remote call fails
     */
    public function updateOrganizationSettings($organizationSettings, array $optionalArgs = [])
    {
        $request = new UpdateOrganizationSettingsRequest();
        $requestParamHeaders = [];
        $request->setOrganizationSettings($organizationSettings);
        $requestParamHeaders['organization_settings.name'] = $organizationSettings->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateOrganizationSettings', OrganizationSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an existing ResourceValueConfigs with new rules.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $resourceValueConfig = new ResourceValueConfig();
     *     $response = $securityCenterClient->updateResourceValueConfig($resourceValueConfig);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param ResourceValueConfig $resourceValueConfig Required. The resource value config being updated.
     * @param array               $optionalArgs        {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *           If empty all mutable fields will be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\ResourceValueConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function updateResourceValueConfig($resourceValueConfig, array $optionalArgs = [])
    {
        $request = new UpdateResourceValueConfigRequest();
        $requestParamHeaders = [];
        $request->setResourceValueConfig($resourceValueConfig);
        $requestParamHeaders['resource_value_config.name'] = $resourceValueConfig->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateResourceValueConfig', ResourceValueConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates the SecurityHealthAnalyticsCustomModule under the given name based
     * on the given update mask. Updating the enablement state is supported on
     * both resident and inherited modules (though resident modules cannot have an
     * enablement state of "inherited"). Updating the display name and custom
     * config of a module is supported on resident modules only.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $securityHealthAnalyticsCustomModule = new SecurityHealthAnalyticsCustomModule();
     *     $response = $securityCenterClient->updateSecurityHealthAnalyticsCustomModule($securityHealthAnalyticsCustomModule);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param SecurityHealthAnalyticsCustomModule $securityHealthAnalyticsCustomModule Required. The SecurityHealthAnalytics custom module to update.
     * @param array                               $optionalArgs                        {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated. The only fields that can be updated are
     *           `enablement_state` and `custom_config`. If empty or set to the wildcard
     *           value `*`, both `enablement_state` and `custom_config` are updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\SecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSecurityHealthAnalyticsCustomModule($securityHealthAnalyticsCustomModule, array $optionalArgs = [])
    {
        $request = new UpdateSecurityHealthAnalyticsCustomModuleRequest();
        $requestParamHeaders = [];
        $request->setSecurityHealthAnalyticsCustomModule($securityHealthAnalyticsCustomModule);
        $requestParamHeaders['security_health_analytics_custom_module.name'] = $securityHealthAnalyticsCustomModule->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateSecurityHealthAnalyticsCustomModule', SecurityHealthAnalyticsCustomModule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates security marks.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $securityMarks = new SecurityMarks();
     *     $response = $securityCenterClient->updateSecurityMarks($securityMarks);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param SecurityMarks $securityMarks Required. The security marks resource to update.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The FieldMask to use when updating the security marks resource.
     *
     *           The field mask must not contain duplicate fields.
     *           If empty or set to "marks", all marks will be replaced.  Individual
     *           marks can be updated using "marks.<mark_key>".
     *     @type Timestamp $startTime
     *           The time at which the updated SecurityMarks take effect.
     *           If not set uses current server time.  Updates will be applied to the
     *           SecurityMarks that are active immediately preceding this time. Must be
     *           earlier or equal to the server time.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\SecurityMarks
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSecurityMarks($securityMarks, array $optionalArgs = [])
    {
        $request = new UpdateSecurityMarksRequest();
        $requestParamHeaders = [];
        $request->setSecurityMarks($securityMarks);
        $requestParamHeaders['security_marks.name'] = $securityMarks->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['startTime'])) {
            $request->setStartTime($optionalArgs['startTime']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateSecurityMarks', SecurityMarks::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a source.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $source = new Source();
     *     $response = $securityCenterClient->updateSource($source);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param Source $source       Required. The source resource to update.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The FieldMask to use when updating the source resource.
     *
     *           If empty all mutable fields will be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\Source
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSource($source, array $optionalArgs = [])
    {
        $request = new UpdateSourceRequest();
        $requestParamHeaders = [];
        $request->setSource($source);
        $requestParamHeaders['source.name'] = $source->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateSource', Source::class, $optionalArgs, $request)->wait();
    }

    /**
     * Validates the given Event Threat Detection custom module.
     *
     * Sample code:
     * ```
     * $securityCenterClient = new SecurityCenterClient();
     * try {
     *     $formattedParent = $securityCenterClient->eventThreatDetectionSettingsName('[ORGANIZATION]');
     *     $rawText = 'raw_text';
     *     $type = 'type';
     *     $response = $securityCenterClient->validateEventThreatDetectionCustomModule($formattedParent, $rawText, $type);
     * } finally {
     *     $securityCenterClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name of the parent to validate the Custom Module under.
     *
     *                             Its format is:
     *
     *                             * `organizations/{organization}/eventThreatDetectionSettings`.
     *                             * `folders/{folder}/eventThreatDetectionSettings`.
     *                             * `projects/{project}/eventThreatDetectionSettings`.
     * @param string $rawText      Required. The raw text of the module's contents. Used to generate error
     *                             messages.
     * @param string $type         Required. The type of the module (e.g. CONFIGURABLE_BAD_IP).
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\SecurityCenter\V1\ValidateEventThreatDetectionCustomModuleResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function validateEventThreatDetectionCustomModule($parent, $rawText, $type, array $optionalArgs = [])
    {
        $request = new ValidateEventThreatDetectionCustomModuleRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRawText($rawText);
        $request->setType($type);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ValidateEventThreatDetectionCustomModule', ValidateEventThreatDetectionCustomModuleResponse::class, $optionalArgs, $request)->wait();
    }
}
