<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/user_event.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * UserEvent captures all metadata information Retail API needs to know about
 * how end users interact with customers' website.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.UserEvent</code>
 */
class UserEvent extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. User event type. Allowed values are:
     * * `add-to-cart`: Products being added to cart.
     * * `remove-from-cart`: Products being removed from cart.
     * * `category-page-view`: Special pages such as sale or promotion pages
     *   viewed.
     * * `detail-page-view`: Products detail page viewed.
     * * `home-page-view`: Homepage viewed.
     * * `promotion-offered`: Promotion is offered to a user.
     * * `promotion-not-offered`: Promotion is not offered to a user.
     * * `purchase-complete`: User finishing a purchase.
     * * `search`: Product search.
     * * `shopping-cart-page-view`: User viewing a shopping cart.
     *
     * Generated from protobuf field <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $event_type = '';
    /**
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * Don't set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     *
     * Generated from protobuf field <code>string visitor_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $visitor_id = '';
    /**
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     * A general guideline to populate the sesion_id:
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * visitor_id as prefix.
     *
     * Generated from protobuf field <code>string session_id = 21;</code>
     */
    private $session_id = '';
    /**
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.retail.v2.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    private $event_time = null;
    /**
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups (e.g. using Retail API, using different
     * recommendation models).
     *
     * Generated from protobuf field <code>repeated string experiment_ids = 4;</code>
     */
    private $experiment_ids;
    /**
     * Highly recommended for user events that are the result of
     * [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     * This field enables accurate attribution of recommendation model
     * performance.
     * The value must be a valid
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * for user events that are the result of
     * [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     * The value must be a valid
     * [SearchResponse.attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     * for user events that are the result of
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     * This token enables us to accurately attribute page view or purchase back to
     * the event and the particular predict response containing this
     * clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * to this field.
     *
     * Generated from protobuf field <code>string attribution_token = 5;</code>
     */
    private $attribution_token = '';
    /**
     * The main product details related to the event.
     * This field is optional except for the following event types:
     * * `add-to-cart`
     * * `detail-page-view`
     * * `purchase-complete`
     * In a `search` event, this field represents the products returned to the end
     * user on the current page (the end user may have not finished browsing the
     * whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [product_details][google.cloud.retail.v2.UserEvent.product_details] is
     * desired. The end user may have not finished browsing the whole page yet.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.ProductDetail product_details = 6;</code>
     */
    private $product_details;
    /**
     * The main auto-completion details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CompletionDetail completion_detail = 22;</code>
     */
    private $completion_detail = null;
    /**
     * Extra user event features to include in the recommendation model.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Retail API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * traffic_channel, which is how a user arrives at the site. Users can arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.retail.v2.CustomAttribute> attributes = 7;</code>
     */
    private $attributes;
    /**
     * The ID or name of the associated shopping cart. This ID is used
     * to associate multiple items added or present in the cart before purchase.
     * This can only be set for `add-to-cart`, `purchase-complete`, or
     * `shopping-cart-page-view` events.
     *
     * Generated from protobuf field <code>string cart_id = 8;</code>
     */
    private $cart_id = '';
    /**
     * A transaction represents the entire purchase transaction.
     * Required for `purchase-complete` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.PurchaseTransaction purchase_transaction = 9;</code>
     */
    private $purchase_transaction = null;
    /**
     * The user's search query.
     * See [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] for
     * definition.
     * The value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * At least one of
     * [search_query][google.cloud.retail.v2.UserEvent.search_query] or
     * [page_categories][google.cloud.retail.v2.UserEvent.page_categories] is
     * required for `search` events. Other event types should not set this field.
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string search_query = 10;</code>
     */
    private $search_query = '';
    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered.
     * See [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
     * definition and syntax.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string filter = 16;</code>
     */
    private $filter = '';
    /**
     * The order in which products are returned.
     * See [SearchRequest.order_by][google.cloud.retail.v2.SearchRequest.order_by]
     * for definition and syntax.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * This can only be set for `search` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string order_by = 17;</code>
     */
    private $order_by = '';
    /**
     * An integer that specifies the current offset for pagination (the 0-indexed
     * starting location, amongst the products deemed by the API as relevant).
     * See [SearchRequest.offset][google.cloud.retail.v2.SearchRequest.offset] for
     * definition.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     * This can only be set for `search` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>int32 offset = 18;</code>
     */
    private $offset = 0;
    /**
     * The categories associated with a category page.
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     * Required for `category-page-view` events. At least one of
     * [search_query][google.cloud.retail.v2.UserEvent.search_query] or
     * [page_categories][google.cloud.retail.v2.UserEvent.page_categories] is
     * required for `search` events. Other event types should not set this field.
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>repeated string page_categories = 11;</code>
     */
    private $page_categories;
    /**
     * User information.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserInfo user_info = 12;</code>
     */
    private $user_info = null;
    /**
     * Complete URL (window.location.href) of the user's current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. Maximum length 5,000
     * characters.
     *
     * Generated from protobuf field <code>string uri = 13;</code>
     */
    private $uri = '';
    /**
     * The referrer URL of the current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     *
     * Generated from protobuf field <code>string referrer_uri = 14;</code>
     */
    private $referrer_uri = '';
    /**
     * A unique ID of a web page view.
     * This should be kept the same for all user events triggered from the same
     * pageview. For example, an item detail page view could trigger multiple
     * events as the user is browsing the page. The `pageViewId` property should
     * be kept the same for all these events so that they can be grouped together
     * properly.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     *
     * Generated from protobuf field <code>string page_view_id = 15;</code>
     */
    private $page_view_id = '';
    /**
     * The entity for customers that may run multiple different entities, domains,
     * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * We recommend that you set this field to get better per-entity search,
     * completion, and prediction results.
     *
     * Generated from protobuf field <code>string entity = 23;</code>
     */
    private $entity = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $event_type
     *           Required. User event type. Allowed values are:
     *           * `add-to-cart`: Products being added to cart.
     *           * `remove-from-cart`: Products being removed from cart.
     *           * `category-page-view`: Special pages such as sale or promotion pages
     *             viewed.
     *           * `detail-page-view`: Products detail page viewed.
     *           * `home-page-view`: Homepage viewed.
     *           * `promotion-offered`: Promotion is offered to a user.
     *           * `promotion-not-offered`: Promotion is not offered to a user.
     *           * `purchase-complete`: User finishing a purchase.
     *           * `search`: Product search.
     *           * `shopping-cart-page-view`: User viewing a shopping cart.
     *     @type string $visitor_id
     *           Required. A unique identifier for tracking visitors.
     *           For example, this could be implemented with an HTTP cookie, which should be
     *           able to uniquely identify a visitor on a single device. This unique
     *           identifier should not change if the visitor log in/out of the website.
     *           Don't set the field to the same fixed ID for different users. This mixes
     *           the event history of those users together, which results in degraded model
     *           quality.
     *           The field must be a UTF-8 encoded string with a length limit of 128
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *           The field should not contain PII or user-data. We recommend to use Google
     *           Analytics [Client
     *           ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     *           for this field.
     *     @type string $session_id
     *           A unique identifier for tracking a visitor session with a length limit of
     *           128 bytes. A session is an aggregation of an end user behavior in a time
     *           span.
     *           A general guideline to populate the sesion_id:
     *           1. If user has no activity for 30 min, a new session_id should be assigned.
     *           2. The session_id should be unique across users, suggest use uuid or add
     *           visitor_id as prefix.
     *     @type \Google\Protobuf\Timestamp $event_time
     *           Only required for
     *           [UserEventService.ImportUserEvents][google.cloud.retail.v2.UserEventService.ImportUserEvents]
     *           method. Timestamp of when the user event happened.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $experiment_ids
     *           A list of identifiers for the independent experiment groups this user event
     *           belongs to. This is used to distinguish between user events associated with
     *           different experiment setups (e.g. using Retail API, using different
     *           recommendation models).
     *     @type string $attribution_token
     *           Highly recommended for user events that are the result of
     *           [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     *           This field enables accurate attribution of recommendation model
     *           performance.
     *           The value must be a valid
     *           [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     *           for user events that are the result of
     *           [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     *           The value must be a valid
     *           [SearchResponse.attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     *           for user events that are the result of
     *           [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *           This token enables us to accurately attribute page view or purchase back to
     *           the event and the particular predict response containing this
     *           clicked/purchased product. If user clicks on product K in the
     *           recommendation results, pass
     *           [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     *           as a URL parameter to product K's page. When recording events on product
     *           K's page, log the
     *           [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     *           to this field.
     *     @type array<\Google\Cloud\Retail\V2\ProductDetail>|\Google\Protobuf\Internal\RepeatedField $product_details
     *           The main product details related to the event.
     *           This field is optional except for the following event types:
     *           * `add-to-cart`
     *           * `detail-page-view`
     *           * `purchase-complete`
     *           In a `search` event, this field represents the products returned to the end
     *           user on the current page (the end user may have not finished browsing the
     *           whole page yet). When a new page is returned to the end user, after
     *           pagination/filtering/ordering even for the same query, a new `search` event
     *           with different
     *           [product_details][google.cloud.retail.v2.UserEvent.product_details] is
     *           desired. The end user may have not finished browsing the whole page yet.
     *     @type \Google\Cloud\Retail\V2\CompletionDetail $completion_detail
     *           The main auto-completion details related to the event.
     *           This field should be set for `search` event when autocomplete function is
     *           enabled and the user clicks a suggestion for search.
     *     @type array|\Google\Protobuf\Internal\MapField $attributes
     *           Extra user event features to include in the recommendation model.
     *           If you provide custom attributes for ingested user events, also include
     *           them in the user events that you associate with prediction requests. Custom
     *           attribute formatting must be consistent between imported events and events
     *           provided with prediction requests. This lets the Retail API use
     *           those custom attributes when training models and serving predictions, which
     *           helps improve recommendation quality.
     *           This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     *           error is returned:
     *           * The key must be a UTF-8 encoded string with a length limit of 5,000
     *             characters.
     *           * For text attributes, at most 400 values are allowed. Empty values are not
     *             allowed. Each value must be a UTF-8 encoded string with a length limit of
     *             256 characters.
     *           * For number attributes, at most 400 values are allowed.
     *           For product recommendations, an example of extra user information is
     *           traffic_channel, which is how a user arrives at the site. Users can arrive
     *           at the site by coming to the site directly, coming through Google
     *           search, or in other ways.
     *     @type string $cart_id
     *           The ID or name of the associated shopping cart. This ID is used
     *           to associate multiple items added or present in the cart before purchase.
     *           This can only be set for `add-to-cart`, `purchase-complete`, or
     *           `shopping-cart-page-view` events.
     *     @type \Google\Cloud\Retail\V2\PurchaseTransaction $purchase_transaction
     *           A transaction represents the entire purchase transaction.
     *           Required for `purchase-complete` events. Other event types should not set
     *           this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type string $search_query
     *           The user's search query.
     *           See [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] for
     *           definition.
     *           The value must be a UTF-8 encoded string with a length limit of 5,000
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *           At least one of
     *           [search_query][google.cloud.retail.v2.UserEvent.search_query] or
     *           [page_categories][google.cloud.retail.v2.UserEvent.page_categories] is
     *           required for `search` events. Other event types should not set this field.
     *           Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type string $filter
     *           The filter syntax consists of an expression language for constructing a
     *           predicate from one or more fields of the products being filtered.
     *           See [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
     *           definition and syntax.
     *           The value must be a UTF-8 encoded string with a length limit of 1,000
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type string $order_by
     *           The order in which products are returned.
     *           See [SearchRequest.order_by][google.cloud.retail.v2.SearchRequest.order_by]
     *           for definition and syntax.
     *           The value must be a UTF-8 encoded string with a length limit of 1,000
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *           This can only be set for `search` events. Other event types should not set
     *           this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type int $offset
     *           An integer that specifies the current offset for pagination (the 0-indexed
     *           starting location, amongst the products deemed by the API as relevant).
     *           See [SearchRequest.offset][google.cloud.retail.v2.SearchRequest.offset] for
     *           definition.
     *           If this field is negative, an INVALID_ARGUMENT is returned.
     *           This can only be set for `search` events. Other event types should not set
     *           this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $page_categories
     *           The categories associated with a category page.
     *           To represent full path of category, use '>' sign to separate different
     *           hierarchies. If '>' is part of the category name, replace it with
     *           other character(s).
     *           Category pages include special pages such as sales or promotions. For
     *           instance, a special sale page may have the category hierarchy:
     *           "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     *           Required for `category-page-view` events. At least one of
     *           [search_query][google.cloud.retail.v2.UserEvent.search_query] or
     *           [page_categories][google.cloud.retail.v2.UserEvent.page_categories] is
     *           required for `search` events. Other event types should not set this field.
     *           Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type \Google\Cloud\Retail\V2\UserInfo $user_info
     *           User information.
     *     @type string $uri
     *           Complete URL (window.location.href) of the user's current page.
     *           When using the client side event reporting with JavaScript pixel and Google
     *           Tag Manager, this value is filled in automatically. Maximum length 5,000
     *           characters.
     *     @type string $referrer_uri
     *           The referrer URL of the current page.
     *           When using the client side event reporting with JavaScript pixel and Google
     *           Tag Manager, this value is filled in automatically.
     *     @type string $page_view_id
     *           A unique ID of a web page view.
     *           This should be kept the same for all user events triggered from the same
     *           pageview. For example, an item detail page view could trigger multiple
     *           events as the user is browsing the page. The `pageViewId` property should
     *           be kept the same for all these events so that they can be grouped together
     *           properly.
     *           When using the client side event reporting with JavaScript pixel and Google
     *           Tag Manager, this value is filled in automatically.
     *     @type string $entity
     *           The entity for customers that may run multiple different entities, domains,
     *           sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     *           `google.com`, `youtube.com`, etc.
     *           We recommend that you set this field to get better per-entity search,
     *           completion, and prediction results.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\UserEvent::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. User event type. Allowed values are:
     * * `add-to-cart`: Products being added to cart.
     * * `remove-from-cart`: Products being removed from cart.
     * * `category-page-view`: Special pages such as sale or promotion pages
     *   viewed.
     * * `detail-page-view`: Products detail page viewed.
     * * `home-page-view`: Homepage viewed.
     * * `promotion-offered`: Promotion is offered to a user.
     * * `promotion-not-offered`: Promotion is not offered to a user.
     * * `purchase-complete`: User finishing a purchase.
     * * `search`: Product search.
     * * `shopping-cart-page-view`: User viewing a shopping cart.
     *
     * Generated from protobuf field <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getEventType()
    {
        return $this->event_type;
    }

    /**
     * Required. User event type. Allowed values are:
     * * `add-to-cart`: Products being added to cart.
     * * `remove-from-cart`: Products being removed from cart.
     * * `category-page-view`: Special pages such as sale or promotion pages
     *   viewed.
     * * `detail-page-view`: Products detail page viewed.
     * * `home-page-view`: Homepage viewed.
     * * `promotion-offered`: Promotion is offered to a user.
     * * `promotion-not-offered`: Promotion is not offered to a user.
     * * `purchase-complete`: User finishing a purchase.
     * * `search`: Product search.
     * * `shopping-cart-page-view`: User viewing a shopping cart.
     *
     * Generated from protobuf field <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setEventType($var)
    {
        GPBUtil::checkString($var, True);
        $this->event_type = $var;

        return $this;
    }

    /**
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * Don't set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     *
     * Generated from protobuf field <code>string visitor_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getVisitorId()
    {
        return $this->visitor_id;
    }

    /**
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * Don't set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     *
     * Generated from protobuf field <code>string visitor_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setVisitorId($var)
    {
        GPBUtil::checkString($var, True);
        $this->visitor_id = $var;

        return $this;
    }

    /**
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     * A general guideline to populate the sesion_id:
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * visitor_id as prefix.
     *
     * Generated from protobuf field <code>string session_id = 21;</code>
     * @return string
     */
    public function getSessionId()
    {
        return $this->session_id;
    }

    /**
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     * A general guideline to populate the sesion_id:
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * visitor_id as prefix.
     *
     * Generated from protobuf field <code>string session_id = 21;</code>
     * @param string $var
     * @return $this
     */
    public function setSessionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->session_id = $var;

        return $this;
    }

    /**
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.retail.v2.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 3;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEventTime()
    {
        return $this->event_time;
    }

    public function hasEventTime()
    {
        return isset($this->event_time);
    }

    public function clearEventTime()
    {
        unset($this->event_time);
    }

    /**
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.retail.v2.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 3;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEventTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->event_time = $var;

        return $this;
    }

    /**
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups (e.g. using Retail API, using different
     * recommendation models).
     *
     * Generated from protobuf field <code>repeated string experiment_ids = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExperimentIds()
    {
        return $this->experiment_ids;
    }

    /**
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups (e.g. using Retail API, using different
     * recommendation models).
     *
     * Generated from protobuf field <code>repeated string experiment_ids = 4;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExperimentIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->experiment_ids = $arr;

        return $this;
    }

    /**
     * Highly recommended for user events that are the result of
     * [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     * This field enables accurate attribution of recommendation model
     * performance.
     * The value must be a valid
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * for user events that are the result of
     * [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     * The value must be a valid
     * [SearchResponse.attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     * for user events that are the result of
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     * This token enables us to accurately attribute page view or purchase back to
     * the event and the particular predict response containing this
     * clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * to this field.
     *
     * Generated from protobuf field <code>string attribution_token = 5;</code>
     * @return string
     */
    public function getAttributionToken()
    {
        return $this->attribution_token;
    }

    /**
     * Highly recommended for user events that are the result of
     * [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     * This field enables accurate attribution of recommendation model
     * performance.
     * The value must be a valid
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * for user events that are the result of
     * [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     * The value must be a valid
     * [SearchResponse.attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     * for user events that are the result of
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     * This token enables us to accurately attribute page view or purchase back to
     * the event and the particular predict response containing this
     * clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * to this field.
     *
     * Generated from protobuf field <code>string attribution_token = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setAttributionToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->attribution_token = $var;

        return $this;
    }

    /**
     * The main product details related to the event.
     * This field is optional except for the following event types:
     * * `add-to-cart`
     * * `detail-page-view`
     * * `purchase-complete`
     * In a `search` event, this field represents the products returned to the end
     * user on the current page (the end user may have not finished browsing the
     * whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [product_details][google.cloud.retail.v2.UserEvent.product_details] is
     * desired. The end user may have not finished browsing the whole page yet.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.ProductDetail product_details = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProductDetails()
    {
        return $this->product_details;
    }

    /**
     * The main product details related to the event.
     * This field is optional except for the following event types:
     * * `add-to-cart`
     * * `detail-page-view`
     * * `purchase-complete`
     * In a `search` event, this field represents the products returned to the end
     * user on the current page (the end user may have not finished browsing the
     * whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [product_details][google.cloud.retail.v2.UserEvent.product_details] is
     * desired. The end user may have not finished browsing the whole page yet.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.ProductDetail product_details = 6;</code>
     * @param array<\Google\Cloud\Retail\V2\ProductDetail>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProductDetails($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\ProductDetail::class);
        $this->product_details = $arr;

        return $this;
    }

    /**
     * The main auto-completion details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CompletionDetail completion_detail = 22;</code>
     * @return \Google\Cloud\Retail\V2\CompletionDetail|null
     */
    public function getCompletionDetail()
    {
        return $this->completion_detail;
    }

    public function hasCompletionDetail()
    {
        return isset($this->completion_detail);
    }

    public function clearCompletionDetail()
    {
        unset($this->completion_detail);
    }

    /**
     * The main auto-completion details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CompletionDetail completion_detail = 22;</code>
     * @param \Google\Cloud\Retail\V2\CompletionDetail $var
     * @return $this
     */
    public function setCompletionDetail($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\CompletionDetail::class);
        $this->completion_detail = $var;

        return $this;
    }

    /**
     * Extra user event features to include in the recommendation model.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Retail API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * traffic_channel, which is how a user arrives at the site. Users can arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.retail.v2.CustomAttribute> attributes = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Extra user event features to include in the recommendation model.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Retail API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * traffic_channel, which is how a user arrives at the site. Users can arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.retail.v2.CustomAttribute> attributes = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\CustomAttribute::class);
        $this->attributes = $arr;

        return $this;
    }

    /**
     * The ID or name of the associated shopping cart. This ID is used
     * to associate multiple items added or present in the cart before purchase.
     * This can only be set for `add-to-cart`, `purchase-complete`, or
     * `shopping-cart-page-view` events.
     *
     * Generated from protobuf field <code>string cart_id = 8;</code>
     * @return string
     */
    public function getCartId()
    {
        return $this->cart_id;
    }

    /**
     * The ID or name of the associated shopping cart. This ID is used
     * to associate multiple items added or present in the cart before purchase.
     * This can only be set for `add-to-cart`, `purchase-complete`, or
     * `shopping-cart-page-view` events.
     *
     * Generated from protobuf field <code>string cart_id = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setCartId($var)
    {
        GPBUtil::checkString($var, True);
        $this->cart_id = $var;

        return $this;
    }

    /**
     * A transaction represents the entire purchase transaction.
     * Required for `purchase-complete` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.PurchaseTransaction purchase_transaction = 9;</code>
     * @return \Google\Cloud\Retail\V2\PurchaseTransaction|null
     */
    public function getPurchaseTransaction()
    {
        return $this->purchase_transaction;
    }

    public function hasPurchaseTransaction()
    {
        return isset($this->purchase_transaction);
    }

    public function clearPurchaseTransaction()
    {
        unset($this->purchase_transaction);
    }

    /**
     * A transaction represents the entire purchase transaction.
     * Required for `purchase-complete` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.PurchaseTransaction purchase_transaction = 9;</code>
     * @param \Google\Cloud\Retail\V2\PurchaseTransaction $var
     * @return $this
     */
    public function setPurchaseTransaction($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\PurchaseTransaction::class);
        $this->purchase_transaction = $var;

        return $this;
    }

    /**
     * The user's search query.
     * See [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] for
     * definition.
     * The value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * At least one of
     * [search_query][google.cloud.retail.v2.UserEvent.search_query] or
     * [page_categories][google.cloud.retail.v2.UserEvent.page_categories] is
     * required for `search` events. Other event types should not set this field.
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string search_query = 10;</code>
     * @return string
     */
    public function getSearchQuery()
    {
        return $this->search_query;
    }

    /**
     * The user's search query.
     * See [SearchRequest.query][google.cloud.retail.v2.SearchRequest.query] for
     * definition.
     * The value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * At least one of
     * [search_query][google.cloud.retail.v2.UserEvent.search_query] or
     * [page_categories][google.cloud.retail.v2.UserEvent.page_categories] is
     * required for `search` events. Other event types should not set this field.
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string search_query = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setSearchQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->search_query = $var;

        return $this;
    }

    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered.
     * See [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
     * definition and syntax.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string filter = 16;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered.
     * See [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
     * definition and syntax.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string filter = 16;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * The order in which products are returned.
     * See [SearchRequest.order_by][google.cloud.retail.v2.SearchRequest.order_by]
     * for definition and syntax.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * This can only be set for `search` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string order_by = 17;</code>
     * @return string
     */
    public function getOrderBy()
    {
        return $this->order_by;
    }

    /**
     * The order in which products are returned.
     * See [SearchRequest.order_by][google.cloud.retail.v2.SearchRequest.order_by]
     * for definition and syntax.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * This can only be set for `search` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string order_by = 17;</code>
     * @param string $var
     * @return $this
     */
    public function setOrderBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->order_by = $var;

        return $this;
    }

    /**
     * An integer that specifies the current offset for pagination (the 0-indexed
     * starting location, amongst the products deemed by the API as relevant).
     * See [SearchRequest.offset][google.cloud.retail.v2.SearchRequest.offset] for
     * definition.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     * This can only be set for `search` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>int32 offset = 18;</code>
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * An integer that specifies the current offset for pagination (the 0-indexed
     * starting location, amongst the products deemed by the API as relevant).
     * See [SearchRequest.offset][google.cloud.retail.v2.SearchRequest.offset] for
     * definition.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     * This can only be set for `search` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>int32 offset = 18;</code>
     * @param int $var
     * @return $this
     */
    public function setOffset($var)
    {
        GPBUtil::checkInt32($var);
        $this->offset = $var;

        return $this;
    }

    /**
     * The categories associated with a category page.
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     * Required for `category-page-view` events. At least one of
     * [search_query][google.cloud.retail.v2.UserEvent.search_query] or
     * [page_categories][google.cloud.retail.v2.UserEvent.page_categories] is
     * required for `search` events. Other event types should not set this field.
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>repeated string page_categories = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPageCategories()
    {
        return $this->page_categories;
    }

    /**
     * The categories associated with a category page.
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     * Required for `category-page-view` events. At least one of
     * [search_query][google.cloud.retail.v2.UserEvent.search_query] or
     * [page_categories][google.cloud.retail.v2.UserEvent.page_categories] is
     * required for `search` events. Other event types should not set this field.
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>repeated string page_categories = 11;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPageCategories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->page_categories = $arr;

        return $this;
    }

    /**
     * User information.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserInfo user_info = 12;</code>
     * @return \Google\Cloud\Retail\V2\UserInfo|null
     */
    public function getUserInfo()
    {
        return $this->user_info;
    }

    public function hasUserInfo()
    {
        return isset($this->user_info);
    }

    public function clearUserInfo()
    {
        unset($this->user_info);
    }

    /**
     * User information.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserInfo user_info = 12;</code>
     * @param \Google\Cloud\Retail\V2\UserInfo $var
     * @return $this
     */
    public function setUserInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\UserInfo::class);
        $this->user_info = $var;

        return $this;
    }

    /**
     * Complete URL (window.location.href) of the user's current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. Maximum length 5,000
     * characters.
     *
     * Generated from protobuf field <code>string uri = 13;</code>
     * @return string
     */
    public function getUri()
    {
        return $this->uri;
    }

    /**
     * Complete URL (window.location.href) of the user's current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. Maximum length 5,000
     * characters.
     *
     * Generated from protobuf field <code>string uri = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->uri = $var;

        return $this;
    }

    /**
     * The referrer URL of the current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     *
     * Generated from protobuf field <code>string referrer_uri = 14;</code>
     * @return string
     */
    public function getReferrerUri()
    {
        return $this->referrer_uri;
    }

    /**
     * The referrer URL of the current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     *
     * Generated from protobuf field <code>string referrer_uri = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setReferrerUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->referrer_uri = $var;

        return $this;
    }

    /**
     * A unique ID of a web page view.
     * This should be kept the same for all user events triggered from the same
     * pageview. For example, an item detail page view could trigger multiple
     * events as the user is browsing the page. The `pageViewId` property should
     * be kept the same for all these events so that they can be grouped together
     * properly.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     *
     * Generated from protobuf field <code>string page_view_id = 15;</code>
     * @return string
     */
    public function getPageViewId()
    {
        return $this->page_view_id;
    }

    /**
     * A unique ID of a web page view.
     * This should be kept the same for all user events triggered from the same
     * pageview. For example, an item detail page view could trigger multiple
     * events as the user is browsing the page. The `pageViewId` property should
     * be kept the same for all these events so that they can be grouped together
     * properly.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     *
     * Generated from protobuf field <code>string page_view_id = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setPageViewId($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_view_id = $var;

        return $this;
    }

    /**
     * The entity for customers that may run multiple different entities, domains,
     * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * We recommend that you set this field to get better per-entity search,
     * completion, and prediction results.
     *
     * Generated from protobuf field <code>string entity = 23;</code>
     * @return string
     */
    public function getEntity()
    {
        return $this->entity;
    }

    /**
     * The entity for customers that may run multiple different entities, domains,
     * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * We recommend that you set this field to get better per-entity search,
     * completion, and prediction results.
     *
     * Generated from protobuf field <code>string entity = 23;</code>
     * @param string $var
     * @return $this
     */
    public function setEntity($var)
    {
        GPBUtil::checkString($var, True);
        $this->entity = $var;

        return $this;
    }

}

