<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/catalog.proto

namespace Google\Cloud\Retail\V2\CatalogAttribute\FacetConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Options to rerank based on facet values engaged by the user for the
 * current key. That key needs to be a custom textual key and facetable.
 * To use this control, you also need to pass all the facet keys engaged by
 * the user in the request using the field [SearchRequest.FacetSpec]. In
 * particular, if you don't pass the facet keys engaged that you want to
 * rerank on, this control won't be effective. Moreover, to obtain better
 * results, the facet values that you want to rerank on should be close to
 * English (ideally made of words, underscores, and spaces).
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.CatalogAttribute.FacetConfig.RerankConfig</code>
 */
class RerankConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * If set to true, then we also rerank the dynamic facets based on the
     * facet values engaged by the user for the current attribute key during
     * serving.
     *
     * Generated from protobuf field <code>bool rerank_facet = 1;</code>
     */
    private $rerank_facet = false;
    /**
     * If empty, rerank on all facet values for the current key. Otherwise,
     * will rerank on the facet values from this list only.
     *
     * Generated from protobuf field <code>repeated string facet_values = 2;</code>
     */
    private $facet_values;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $rerank_facet
     *           If set to true, then we also rerank the dynamic facets based on the
     *           facet values engaged by the user for the current attribute key during
     *           serving.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $facet_values
     *           If empty, rerank on all facet values for the current key. Otherwise,
     *           will rerank on the facet values from this list only.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\Catalog::initOnce();
        parent::__construct($data);
    }

    /**
     * If set to true, then we also rerank the dynamic facets based on the
     * facet values engaged by the user for the current attribute key during
     * serving.
     *
     * Generated from protobuf field <code>bool rerank_facet = 1;</code>
     * @return bool
     */
    public function getRerankFacet()
    {
        return $this->rerank_facet;
    }

    /**
     * If set to true, then we also rerank the dynamic facets based on the
     * facet values engaged by the user for the current attribute key during
     * serving.
     *
     * Generated from protobuf field <code>bool rerank_facet = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setRerankFacet($var)
    {
        GPBUtil::checkBool($var);
        $this->rerank_facet = $var;

        return $this;
    }

    /**
     * If empty, rerank on all facet values for the current key. Otherwise,
     * will rerank on the facet values from this list only.
     *
     * Generated from protobuf field <code>repeated string facet_values = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFacetValues()
    {
        return $this->facet_values;
    }

    /**
     * If empty, rerank on all facet values for the current key. Otherwise,
     * will rerank on the facet values from this list only.
     *
     * Generated from protobuf field <code>repeated string facet_values = 2;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFacetValues($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->facet_values = $arr;

        return $this;
    }

}


