<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/security/privateca/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Security\PrivateCA\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\Security\PrivateCA\V1\ActivateCertificateAuthorityRequest;
use Google\Cloud\Security\PrivateCA\V1\CaPool;
use Google\Cloud\Security\PrivateCA\V1\Certificate;
use Google\Cloud\Security\PrivateCA\V1\CertificateAuthority;
use Google\Cloud\Security\PrivateCA\V1\CertificateRevocationList;
use Google\Cloud\Security\PrivateCA\V1\CertificateTemplate;
use Google\Cloud\Security\PrivateCA\V1\CreateCaPoolRequest;
use Google\Cloud\Security\PrivateCA\V1\CreateCertificateAuthorityRequest;
use Google\Cloud\Security\PrivateCA\V1\CreateCertificateRequest;
use Google\Cloud\Security\PrivateCA\V1\CreateCertificateTemplateRequest;
use Google\Cloud\Security\PrivateCA\V1\DeleteCaPoolRequest;
use Google\Cloud\Security\PrivateCA\V1\DeleteCertificateAuthorityRequest;
use Google\Cloud\Security\PrivateCA\V1\DeleteCertificateTemplateRequest;
use Google\Cloud\Security\PrivateCA\V1\DisableCertificateAuthorityRequest;
use Google\Cloud\Security\PrivateCA\V1\EnableCertificateAuthorityRequest;
use Google\Cloud\Security\PrivateCA\V1\FetchCaCertsRequest;
use Google\Cloud\Security\PrivateCA\V1\FetchCaCertsResponse;
use Google\Cloud\Security\PrivateCA\V1\FetchCertificateAuthorityCsrRequest;
use Google\Cloud\Security\PrivateCA\V1\FetchCertificateAuthorityCsrResponse;
use Google\Cloud\Security\PrivateCA\V1\GetCaPoolRequest;
use Google\Cloud\Security\PrivateCA\V1\GetCertificateAuthorityRequest;
use Google\Cloud\Security\PrivateCA\V1\GetCertificateRequest;
use Google\Cloud\Security\PrivateCA\V1\GetCertificateRevocationListRequest;
use Google\Cloud\Security\PrivateCA\V1\GetCertificateTemplateRequest;
use Google\Cloud\Security\PrivateCA\V1\ListCaPoolsRequest;
use Google\Cloud\Security\PrivateCA\V1\ListCertificateAuthoritiesRequest;
use Google\Cloud\Security\PrivateCA\V1\ListCertificateRevocationListsRequest;
use Google\Cloud\Security\PrivateCA\V1\ListCertificateTemplatesRequest;
use Google\Cloud\Security\PrivateCA\V1\ListCertificatesRequest;
use Google\Cloud\Security\PrivateCA\V1\RevokeCertificateRequest;
use Google\Cloud\Security\PrivateCA\V1\UndeleteCertificateAuthorityRequest;
use Google\Cloud\Security\PrivateCA\V1\UpdateCaPoolRequest;
use Google\Cloud\Security\PrivateCA\V1\UpdateCertificateAuthorityRequest;
use Google\Cloud\Security\PrivateCA\V1\UpdateCertificateRequest;
use Google\Cloud\Security\PrivateCA\V1\UpdateCertificateRevocationListRequest;
use Google\Cloud\Security\PrivateCA\V1\UpdateCertificateTemplateRequest;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: [Certificate Authority
 * Service][google.cloud.security.privateca.v1.CertificateAuthorityService]
 * manages private certificate authorities and issued certificates.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface activateCertificateAuthorityAsync(ActivateCertificateAuthorityRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCaPoolAsync(CreateCaPoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCertificateAsync(CreateCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCertificateAuthorityAsync(CreateCertificateAuthorityRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCertificateTemplateAsync(CreateCertificateTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteCaPoolAsync(DeleteCaPoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteCertificateAuthorityAsync(DeleteCertificateAuthorityRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteCertificateTemplateAsync(DeleteCertificateTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface disableCertificateAuthorityAsync(DisableCertificateAuthorityRequest $request, array $optionalArgs = [])
 * @method PromiseInterface enableCertificateAuthorityAsync(EnableCertificateAuthorityRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchCaCertsAsync(FetchCaCertsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchCertificateAuthorityCsrAsync(FetchCertificateAuthorityCsrRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCaPoolAsync(GetCaPoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCertificateAsync(GetCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCertificateAuthorityAsync(GetCertificateAuthorityRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCertificateRevocationListAsync(GetCertificateRevocationListRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCertificateTemplateAsync(GetCertificateTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCaPoolsAsync(ListCaPoolsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCertificateAuthoritiesAsync(ListCertificateAuthoritiesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCertificateRevocationListsAsync(ListCertificateRevocationListsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCertificateTemplatesAsync(ListCertificateTemplatesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCertificatesAsync(ListCertificatesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface revokeCertificateAsync(RevokeCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface undeleteCertificateAuthorityAsync(UndeleteCertificateAuthorityRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCaPoolAsync(UpdateCaPoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCertificateAsync(UpdateCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCertificateAuthorityAsync(UpdateCertificateAuthorityRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCertificateRevocationListAsync(UpdateCertificateRevocationListRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCertificateTemplateAsync(UpdateCertificateTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class CertificateAuthorityServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.security.privateca.v1.CertificateAuthorityService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'privateca.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'privateca.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/certificate_authority_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/certificate_authority_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/certificate_authority_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/certificate_authority_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a ca_pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $caPool
     *
     * @return string The formatted ca_pool resource.
     */
    public static function caPoolName(string $project, string $location, string $caPool): string
    {
        return self::getPathTemplate('caPool')->render([
            'project' => $project,
            'location' => $location,
            'ca_pool' => $caPool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a certificate
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $caPool
     * @param string $certificate
     *
     * @return string The formatted certificate resource.
     */
    public static function certificateName(string $project, string $location, string $caPool, string $certificate): string
    {
        return self::getPathTemplate('certificate')->render([
            'project' => $project,
            'location' => $location,
            'ca_pool' => $caPool,
            'certificate' => $certificate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * certificate_authority resource.
     *
     * @param string $project
     * @param string $location
     * @param string $caPool
     * @param string $certificateAuthority
     *
     * @return string The formatted certificate_authority resource.
     */
    public static function certificateAuthorityName(string $project, string $location, string $caPool, string $certificateAuthority): string
    {
        return self::getPathTemplate('certificateAuthority')->render([
            'project' => $project,
            'location' => $location,
            'ca_pool' => $caPool,
            'certificate_authority' => $certificateAuthority,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * certificate_revocation_list resource.
     *
     * @param string $project
     * @param string $location
     * @param string $caPool
     * @param string $certificateAuthority
     * @param string $certificateRevocationList
     *
     * @return string The formatted certificate_revocation_list resource.
     */
    public static function certificateRevocationListName(string $project, string $location, string $caPool, string $certificateAuthority, string $certificateRevocationList): string
    {
        return self::getPathTemplate('certificateRevocationList')->render([
            'project' => $project,
            'location' => $location,
            'ca_pool' => $caPool,
            'certificate_authority' => $certificateAuthority,
            'certificate_revocation_list' => $certificateRevocationList,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * certificate_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $certificateTemplate
     *
     * @return string The formatted certificate_template resource.
     */
    public static function certificateTemplateName(string $project, string $location, string $certificateTemplate): string
    {
        return self::getPathTemplate('certificateTemplate')->render([
            'project' => $project,
            'location' => $location,
            'certificate_template' => $certificateTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - caPool: projects/{project}/locations/{location}/caPools/{ca_pool}
     * - certificate: projects/{project}/locations/{location}/caPools/{ca_pool}/certificates/{certificate}
     * - certificateAuthority: projects/{project}/locations/{location}/caPools/{ca_pool}/certificateAuthorities/{certificate_authority}
     * - certificateRevocationList: projects/{project}/locations/{location}/caPools/{ca_pool}/certificateAuthorities/{certificate_authority}/certificateRevocationLists/{certificate_revocation_list}
     * - certificateTemplate: projects/{project}/locations/{location}/certificateTemplates/{certificate_template}
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'privateca.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Activate a
     * [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
     * that is in state
     * [AWAITING_USER_ACTIVATION][google.cloud.security.privateca.v1.CertificateAuthority.State.AWAITING_USER_ACTIVATION]
     * and is of type
     * [SUBORDINATE][google.cloud.security.privateca.v1.CertificateAuthority.Type.SUBORDINATE].
     * After the parent Certificate Authority signs a certificate signing request
     * from
     * [FetchCertificateAuthorityCsr][google.cloud.security.privateca.v1.CertificateAuthorityService.FetchCertificateAuthorityCsr],
     * this method can complete the activation process.
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::activateCertificateAuthorityAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/activate_certificate_authority.php
     *
     * @param ActivateCertificateAuthorityRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function activateCertificateAuthority(ActivateCertificateAuthorityRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ActivateCertificateAuthority', $request, $callOptions)->wait();
    }

    /**
     * Create a [CaPool][google.cloud.security.privateca.v1.CaPool].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::createCaPoolAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/create_ca_pool.php
     *
     * @param CreateCaPoolRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCaPool(CreateCaPoolRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCaPool', $request, $callOptions)->wait();
    }

    /**
     * Create a new [Certificate][google.cloud.security.privateca.v1.Certificate]
     * in a given Project, Location from a particular
     * [CaPool][google.cloud.security.privateca.v1.CaPool].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::createCertificateAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/create_certificate.php
     *
     * @param CreateCertificateRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Certificate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCertificate(CreateCertificateRequest $request, array $callOptions = []): Certificate
    {
        return $this->startApiCall('CreateCertificate', $request, $callOptions)->wait();
    }

    /**
     * Create a new
     * [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
     * in a given Project and Location.
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::createCertificateAuthorityAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/create_certificate_authority.php
     *
     * @param CreateCertificateAuthorityRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCertificateAuthority(CreateCertificateAuthorityRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCertificateAuthority', $request, $callOptions)->wait();
    }

    /**
     * Create a new
     * [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
     * in a given Project and Location.
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::createCertificateTemplateAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/create_certificate_template.php
     *
     * @param CreateCertificateTemplateRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCertificateTemplate(CreateCertificateTemplateRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCertificateTemplate', $request, $callOptions)->wait();
    }

    /**
     * Delete a [CaPool][google.cloud.security.privateca.v1.CaPool].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::deleteCaPoolAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/delete_ca_pool.php
     *
     * @param DeleteCaPoolRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCaPool(DeleteCaPoolRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCaPool', $request, $callOptions)->wait();
    }

    /**
     * Delete a
     * [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::deleteCertificateAuthorityAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/delete_certificate_authority.php
     *
     * @param DeleteCertificateAuthorityRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCertificateAuthority(DeleteCertificateAuthorityRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCertificateAuthority', $request, $callOptions)->wait();
    }

    /**
     * DeleteCertificateTemplate deletes a
     * [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::deleteCertificateTemplateAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/delete_certificate_template.php
     *
     * @param DeleteCertificateTemplateRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCertificateTemplate(DeleteCertificateTemplateRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCertificateTemplate', $request, $callOptions)->wait();
    }

    /**
     * Disable a
     * [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::disableCertificateAuthorityAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/disable_certificate_authority.php
     *
     * @param DisableCertificateAuthorityRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function disableCertificateAuthority(DisableCertificateAuthorityRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DisableCertificateAuthority', $request, $callOptions)->wait();
    }

    /**
     * Enable a
     * [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::enableCertificateAuthorityAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/enable_certificate_authority.php
     *
     * @param EnableCertificateAuthorityRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function enableCertificateAuthority(EnableCertificateAuthorityRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('EnableCertificateAuthority', $request, $callOptions)->wait();
    }

    /**
     * FetchCaCerts returns the current trust anchor for the
     * [CaPool][google.cloud.security.privateca.v1.CaPool]. This will include CA
     * certificate chains for all certificate authorities in the ENABLED,
     * DISABLED, or STAGED states.
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::fetchCaCertsAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/fetch_ca_certs.php
     *
     * @param FetchCaCertsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchCaCertsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchCaCerts(FetchCaCertsRequest $request, array $callOptions = []): FetchCaCertsResponse
    {
        return $this->startApiCall('FetchCaCerts', $request, $callOptions)->wait();
    }

    /**
     * Fetch a certificate signing request (CSR) from a
     * [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
     * that is in state
     * [AWAITING_USER_ACTIVATION][google.cloud.security.privateca.v1.CertificateAuthority.State.AWAITING_USER_ACTIVATION]
     * and is of type
     * [SUBORDINATE][google.cloud.security.privateca.v1.CertificateAuthority.Type.SUBORDINATE].
     * The CSR must then be signed by the desired parent Certificate Authority,
     * which could be another
     * [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
     * resource, or could be an on-prem certificate authority. See also
     * [ActivateCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.ActivateCertificateAuthority].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::fetchCertificateAuthorityCsrAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/fetch_certificate_authority_csr.php
     *
     * @param FetchCertificateAuthorityCsrRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchCertificateAuthorityCsrResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchCertificateAuthorityCsr(FetchCertificateAuthorityCsrRequest $request, array $callOptions = []): FetchCertificateAuthorityCsrResponse
    {
        return $this->startApiCall('FetchCertificateAuthorityCsr', $request, $callOptions)->wait();
    }

    /**
     * Returns a [CaPool][google.cloud.security.privateca.v1.CaPool].
     *
     * The async variant is {@see CertificateAuthorityServiceClient::getCaPoolAsync()}
     * .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/get_ca_pool.php
     *
     * @param GetCaPoolRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CaPool
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCaPool(GetCaPoolRequest $request, array $callOptions = []): CaPool
    {
        return $this->startApiCall('GetCaPool', $request, $callOptions)->wait();
    }

    /**
     * Returns a [Certificate][google.cloud.security.privateca.v1.Certificate].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::getCertificateAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/get_certificate.php
     *
     * @param GetCertificateRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Certificate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCertificate(GetCertificateRequest $request, array $callOptions = []): Certificate
    {
        return $this->startApiCall('GetCertificate', $request, $callOptions)->wait();
    }

    /**
     * Returns a
     * [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::getCertificateAuthorityAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/get_certificate_authority.php
     *
     * @param GetCertificateAuthorityRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CertificateAuthority
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCertificateAuthority(GetCertificateAuthorityRequest $request, array $callOptions = []): CertificateAuthority
    {
        return $this->startApiCall('GetCertificateAuthority', $request, $callOptions)->wait();
    }

    /**
     * Returns a
     * [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::getCertificateRevocationListAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/get_certificate_revocation_list.php
     *
     * @param GetCertificateRevocationListRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CertificateRevocationList
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCertificateRevocationList(GetCertificateRevocationListRequest $request, array $callOptions = []): CertificateRevocationList
    {
        return $this->startApiCall('GetCertificateRevocationList', $request, $callOptions)->wait();
    }

    /**
     * Returns a
     * [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::getCertificateTemplateAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/get_certificate_template.php
     *
     * @param GetCertificateTemplateRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CertificateTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCertificateTemplate(GetCertificateTemplateRequest $request, array $callOptions = []): CertificateTemplate
    {
        return $this->startApiCall('GetCertificateTemplate', $request, $callOptions)->wait();
    }

    /**
     * Lists [CaPools][google.cloud.security.privateca.v1.CaPool].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::listCaPoolsAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/list_ca_pools.php
     *
     * @param ListCaPoolsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCaPools(ListCaPoolsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCaPools', $request, $callOptions);
    }

    /**
     * Lists
     * [CertificateAuthorities][google.cloud.security.privateca.v1.CertificateAuthority].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::listCertificateAuthoritiesAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/list_certificate_authorities.php
     *
     * @param ListCertificateAuthoritiesRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCertificateAuthorities(ListCertificateAuthoritiesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCertificateAuthorities', $request, $callOptions);
    }

    /**
     * Lists
     * [CertificateRevocationLists][google.cloud.security.privateca.v1.CertificateRevocationList].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::listCertificateRevocationListsAsync()}
     * .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/list_certificate_revocation_lists.php
     *
     * @param ListCertificateRevocationListsRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCertificateRevocationLists(ListCertificateRevocationListsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCertificateRevocationLists', $request, $callOptions);
    }

    /**
     * Lists
     * [CertificateTemplates][google.cloud.security.privateca.v1.CertificateTemplate].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::listCertificateTemplatesAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/list_certificate_templates.php
     *
     * @param ListCertificateTemplatesRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCertificateTemplates(ListCertificateTemplatesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCertificateTemplates', $request, $callOptions);
    }

    /**
     * Lists [Certificates][google.cloud.security.privateca.v1.Certificate].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::listCertificatesAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/list_certificates.php
     *
     * @param ListCertificatesRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCertificates(ListCertificatesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCertificates', $request, $callOptions);
    }

    /**
     * Revoke a [Certificate][google.cloud.security.privateca.v1.Certificate].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::revokeCertificateAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/revoke_certificate.php
     *
     * @param RevokeCertificateRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Certificate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function revokeCertificate(RevokeCertificateRequest $request, array $callOptions = []): Certificate
    {
        return $this->startApiCall('RevokeCertificate', $request, $callOptions)->wait();
    }

    /**
     * Undelete a
     * [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
     * that has been deleted.
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::undeleteCertificateAuthorityAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/undelete_certificate_authority.php
     *
     * @param UndeleteCertificateAuthorityRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function undeleteCertificateAuthority(UndeleteCertificateAuthorityRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UndeleteCertificateAuthority', $request, $callOptions)->wait();
    }

    /**
     * Update a [CaPool][google.cloud.security.privateca.v1.CaPool].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::updateCaPoolAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/update_ca_pool.php
     *
     * @param UpdateCaPoolRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCaPool(UpdateCaPoolRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCaPool', $request, $callOptions)->wait();
    }

    /**
     * Update a [Certificate][google.cloud.security.privateca.v1.Certificate].
     * Currently, the only field you can update is the
     * [labels][google.cloud.security.privateca.v1.Certificate.labels] field.
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::updateCertificateAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/update_certificate.php
     *
     * @param UpdateCertificateRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Certificate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCertificate(UpdateCertificateRequest $request, array $callOptions = []): Certificate
    {
        return $this->startApiCall('UpdateCertificate', $request, $callOptions)->wait();
    }

    /**
     * Update a
     * [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::updateCertificateAuthorityAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/update_certificate_authority.php
     *
     * @param UpdateCertificateAuthorityRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCertificateAuthority(UpdateCertificateAuthorityRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCertificateAuthority', $request, $callOptions)->wait();
    }

    /**
     * Update a
     * [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::updateCertificateRevocationListAsync()}
     * .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/update_certificate_revocation_list.php
     *
     * @param UpdateCertificateRevocationListRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCertificateRevocationList(UpdateCertificateRevocationListRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCertificateRevocationList', $request, $callOptions)->wait();
    }

    /**
     * Update a
     * [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::updateCertificateTemplateAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/update_certificate_template.php
     *
     * @param UpdateCertificateTemplateRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCertificateTemplate(UpdateCertificateTemplateRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCertificateTemplate', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is
     * {@see CertificateAuthorityServiceClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/CertificateAuthorityServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
