<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/admin/v2/bigtable_table_admin.proto

namespace Google\Cloud\Bigtable\Admin\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request for
 * [CopyBackup][google.bigtable.admin.v2.BigtableTableAdmin.CopyBackup].
 *
 * Generated from protobuf message <code>google.bigtable.admin.v2.CopyBackupRequest</code>
 */
class CopyBackupRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the destination cluster that will contain the backup
     * copy. The cluster must already exists. Values are of the form:
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The id of the new backup. The `backup_id` along with `parent`
     * are combined as {parent}/backups/{backup_id} to create the full backup
     * name, of the form:
     * `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
     * This string must be between 1 and 50 characters in length and match the
     * regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
     *
     * Generated from protobuf field <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $backup_id = '';
    /**
     * Required. The source backup to be copied from.
     * The source backup needs to be in READY state for it to be copied.
     * Copying a copied backup is not allowed.
     * Once CopyBackup is in progress, the source backup cannot be deleted or
     * cleaned up on expiration until CopyBackup is finished.
     * Values are of the form:
     * `projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>`.
     *
     * Generated from protobuf field <code>string source_backup = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $source_backup = '';
    /**
     * Required. Required. The expiration time of the copied backup with
     * microsecond granularity that must be at least 6 hours and at most 30 days
     * from the time the request is received. Once the `expire_time` has
     * passed, Cloud Bigtable will delete the backup and free the resources used
     * by the backup.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $expire_time = null;

    /**
     * @param string                     $parent       Required. The name of the destination cluster that will contain the backup
     *                                                 copy. The cluster must already exists. Values are of the form:
     *                                                 `projects/{project}/instances/{instance}/clusters/{cluster}`. Please see
     *                                                 {@see BigtableTableAdminClient::clusterName()} for help formatting this field.
     * @param string                     $backupId     Required. The id of the new backup. The `backup_id` along with `parent`
     *                                                 are combined as {parent}/backups/{backup_id} to create the full backup
     *                                                 name, of the form:
     *                                                 `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
     *                                                 This string must be between 1 and 50 characters in length and match the
     *                                                 regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
     * @param string                     $sourceBackup Required. The source backup to be copied from.
     *                                                 The source backup needs to be in READY state for it to be copied.
     *                                                 Copying a copied backup is not allowed.
     *                                                 Once CopyBackup is in progress, the source backup cannot be deleted or
     *                                                 cleaned up on expiration until CopyBackup is finished.
     *                                                 Values are of the form:
     *                                                 `projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>`. Please see
     *                                                 {@see BigtableTableAdminClient::backupName()} for help formatting this field.
     * @param \Google\Protobuf\Timestamp $expireTime   Required. Required. The expiration time of the copied backup with
     *                                                 microsecond granularity that must be at least 6 hours and at most 30 days
     *                                                 from the time the request is received. Once the `expire_time` has
     *                                                 passed, Cloud Bigtable will delete the backup and free the resources used
     *                                                 by the backup.
     *
     * @return \Google\Cloud\Bigtable\Admin\V2\CopyBackupRequest
     *
     * @experimental
     */
    public static function build(string $parent, string $backupId, string $sourceBackup, \Google\Protobuf\Timestamp $expireTime): self
    {
        return (new self())
            ->setParent($parent)
            ->setBackupId($backupId)
            ->setSourceBackup($sourceBackup)
            ->setExpireTime($expireTime);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The name of the destination cluster that will contain the backup
     *           copy. The cluster must already exists. Values are of the form:
     *           `projects/{project}/instances/{instance}/clusters/{cluster}`.
     *     @type string $backup_id
     *           Required. The id of the new backup. The `backup_id` along with `parent`
     *           are combined as {parent}/backups/{backup_id} to create the full backup
     *           name, of the form:
     *           `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
     *           This string must be between 1 and 50 characters in length and match the
     *           regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
     *     @type string $source_backup
     *           Required. The source backup to be copied from.
     *           The source backup needs to be in READY state for it to be copied.
     *           Copying a copied backup is not allowed.
     *           Once CopyBackup is in progress, the source backup cannot be deleted or
     *           cleaned up on expiration until CopyBackup is finished.
     *           Values are of the form:
     *           `projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>`.
     *     @type \Google\Protobuf\Timestamp $expire_time
     *           Required. Required. The expiration time of the copied backup with
     *           microsecond granularity that must be at least 6 hours and at most 30 days
     *           from the time the request is received. Once the `expire_time` has
     *           passed, Cloud Bigtable will delete the backup and free the resources used
     *           by the backup.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\Admin\V2\BigtableTableAdmin::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the destination cluster that will contain the backup
     * copy. The cluster must already exists. Values are of the form:
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The name of the destination cluster that will contain the backup
     * copy. The cluster must already exists. Values are of the form:
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The id of the new backup. The `backup_id` along with `parent`
     * are combined as {parent}/backups/{backup_id} to create the full backup
     * name, of the form:
     * `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
     * This string must be between 1 and 50 characters in length and match the
     * regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
     *
     * Generated from protobuf field <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getBackupId()
    {
        return $this->backup_id;
    }

    /**
     * Required. The id of the new backup. The `backup_id` along with `parent`
     * are combined as {parent}/backups/{backup_id} to create the full backup
     * name, of the form:
     * `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
     * This string must be between 1 and 50 characters in length and match the
     * regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
     *
     * Generated from protobuf field <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setBackupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_id = $var;

        return $this;
    }

    /**
     * Required. The source backup to be copied from.
     * The source backup needs to be in READY state for it to be copied.
     * Copying a copied backup is not allowed.
     * Once CopyBackup is in progress, the source backup cannot be deleted or
     * cleaned up on expiration until CopyBackup is finished.
     * Values are of the form:
     * `projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>`.
     *
     * Generated from protobuf field <code>string source_backup = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSourceBackup()
    {
        return $this->source_backup;
    }

    /**
     * Required. The source backup to be copied from.
     * The source backup needs to be in READY state for it to be copied.
     * Copying a copied backup is not allowed.
     * Once CopyBackup is in progress, the source backup cannot be deleted or
     * cleaned up on expiration until CopyBackup is finished.
     * Values are of the form:
     * `projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>`.
     *
     * Generated from protobuf field <code>string source_backup = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSourceBackup($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_backup = $var;

        return $this;
    }

    /**
     * Required. Required. The expiration time of the copied backup with
     * microsecond granularity that must be at least 6 hours and at most 30 days
     * from the time the request is received. Once the `expire_time` has
     * passed, Cloud Bigtable will delete the backup and free the resources used
     * by the backup.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpireTime()
    {
        return $this->expire_time;
    }

    public function hasExpireTime()
    {
        return isset($this->expire_time);
    }

    public function clearExpireTime()
    {
        unset($this->expire_time);
    }

    /**
     * Required. Required. The expiration time of the copied backup with
     * microsecond granularity that must be at least 6 hours and at most 30 days
     * from the time the request is received. Once the `expire_time` has
     * passed, Cloud Bigtable will delete the backup and free the resources used
     * by the backup.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expire_time = $var;

        return $this;
    }

}

