<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/websecurityscanner/v1/scan_config.proto

namespace Google\Cloud\WebSecurityScanner\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A ScanConfig resource contains the configurations to launch a scan.
 *
 * Generated from protobuf message <code>google.cloud.websecurityscanner.v1.ScanConfig</code>
 */
class ScanConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the ScanConfig. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
     * generated by the system.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Required. The user provided display name of the ScanConfig.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     */
    protected $display_name = '';
    /**
     * The maximum QPS during scanning. A valid value ranges from 5 to 20
     * inclusively. If the field is unspecified or its value is set 0, server will
     * default to 15. Other values outside of [5, 20] range will be rejected with
     * INVALID_ARGUMENT error.
     *
     * Generated from protobuf field <code>int32 max_qps = 3;</code>
     */
    protected $max_qps = 0;
    /**
     * Required. The starting URLs from which the scanner finds site pages.
     *
     * Generated from protobuf field <code>repeated string starting_urls = 4;</code>
     */
    private $starting_urls;
    /**
     * The authentication configuration. If specified, service will use the
     * authentication configuration during scanning.
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.Authentication authentication = 5;</code>
     */
    protected $authentication = null;
    /**
     * The user agent used during scanning.
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.UserAgent user_agent = 6;</code>
     */
    protected $user_agent = 0;
    /**
     * The excluded URL patterns as described in
     * https://cloud.google.com/security-command-center/docs/how-to-use-web-security-scanner#excluding_urls
     *
     * Generated from protobuf field <code>repeated string blacklist_patterns = 7;</code>
     */
    private $blacklist_patterns;
    /**
     * The schedule of the ScanConfig.
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.Schedule schedule = 8;</code>
     */
    protected $schedule = null;
    /**
     * Controls export of scan configurations and results to Security
     * Command Center.
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.ExportToSecurityCommandCenter export_to_security_command_center = 10;</code>
     */
    protected $export_to_security_command_center = 0;
    /**
     * The risk level selected for the scan
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.RiskLevel risk_level = 12;</code>
     */
    protected $risk_level = 0;
    /**
     * Whether the scan config is managed by Web Security Scanner, output
     * only.
     *
     * Generated from protobuf field <code>bool managed_scan = 13;</code>
     */
    protected $managed_scan = false;
    /**
     * Whether the scan configuration has enabled static IP address scan feature.
     * If enabled, the scanner will access applications from static IP addresses.
     *
     * Generated from protobuf field <code>bool static_ip_scan = 14;</code>
     */
    protected $static_ip_scan = false;
    /**
     * Whether to keep scanning even if most requests return HTTP error codes.
     *
     * Generated from protobuf field <code>bool ignore_http_status_errors = 15;</code>
     */
    protected $ignore_http_status_errors = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the ScanConfig. The name follows the format of
     *           'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
     *           generated by the system.
     *     @type string $display_name
     *           Required. The user provided display name of the ScanConfig.
     *     @type int $max_qps
     *           The maximum QPS during scanning. A valid value ranges from 5 to 20
     *           inclusively. If the field is unspecified or its value is set 0, server will
     *           default to 15. Other values outside of [5, 20] range will be rejected with
     *           INVALID_ARGUMENT error.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $starting_urls
     *           Required. The starting URLs from which the scanner finds site pages.
     *     @type \Google\Cloud\WebSecurityScanner\V1\ScanConfig\Authentication $authentication
     *           The authentication configuration. If specified, service will use the
     *           authentication configuration during scanning.
     *     @type int $user_agent
     *           The user agent used during scanning.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $blacklist_patterns
     *           The excluded URL patterns as described in
     *           https://cloud.google.com/security-command-center/docs/how-to-use-web-security-scanner#excluding_urls
     *     @type \Google\Cloud\WebSecurityScanner\V1\ScanConfig\Schedule $schedule
     *           The schedule of the ScanConfig.
     *     @type int $export_to_security_command_center
     *           Controls export of scan configurations and results to Security
     *           Command Center.
     *     @type int $risk_level
     *           The risk level selected for the scan
     *     @type bool $managed_scan
     *           Whether the scan config is managed by Web Security Scanner, output
     *           only.
     *     @type bool $static_ip_scan
     *           Whether the scan configuration has enabled static IP address scan feature.
     *           If enabled, the scanner will access applications from static IP addresses.
     *     @type bool $ignore_http_status_errors
     *           Whether to keep scanning even if most requests return HTTP error codes.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Websecurityscanner\V1\ScanConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the ScanConfig. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
     * generated by the system.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the ScanConfig. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
     * generated by the system.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The user provided display name of the ScanConfig.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The user provided display name of the ScanConfig.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The maximum QPS during scanning. A valid value ranges from 5 to 20
     * inclusively. If the field is unspecified or its value is set 0, server will
     * default to 15. Other values outside of [5, 20] range will be rejected with
     * INVALID_ARGUMENT error.
     *
     * Generated from protobuf field <code>int32 max_qps = 3;</code>
     * @return int
     */
    public function getMaxQps()
    {
        return $this->max_qps;
    }

    /**
     * The maximum QPS during scanning. A valid value ranges from 5 to 20
     * inclusively. If the field is unspecified or its value is set 0, server will
     * default to 15. Other values outside of [5, 20] range will be rejected with
     * INVALID_ARGUMENT error.
     *
     * Generated from protobuf field <code>int32 max_qps = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxQps($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_qps = $var;

        return $this;
    }

    /**
     * Required. The starting URLs from which the scanner finds site pages.
     *
     * Generated from protobuf field <code>repeated string starting_urls = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStartingUrls()
    {
        return $this->starting_urls;
    }

    /**
     * Required. The starting URLs from which the scanner finds site pages.
     *
     * Generated from protobuf field <code>repeated string starting_urls = 4;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStartingUrls($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->starting_urls = $arr;

        return $this;
    }

    /**
     * The authentication configuration. If specified, service will use the
     * authentication configuration during scanning.
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.Authentication authentication = 5;</code>
     * @return \Google\Cloud\WebSecurityScanner\V1\ScanConfig\Authentication|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }

    public function hasAuthentication()
    {
        return isset($this->authentication);
    }

    public function clearAuthentication()
    {
        unset($this->authentication);
    }

    /**
     * The authentication configuration. If specified, service will use the
     * authentication configuration during scanning.
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.Authentication authentication = 5;</code>
     * @param \Google\Cloud\WebSecurityScanner\V1\ScanConfig\Authentication $var
     * @return $this
     */
    public function setAuthentication($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\WebSecurityScanner\V1\ScanConfig\Authentication::class);
        $this->authentication = $var;

        return $this;
    }

    /**
     * The user agent used during scanning.
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.UserAgent user_agent = 6;</code>
     * @return int
     */
    public function getUserAgent()
    {
        return $this->user_agent;
    }

    /**
     * The user agent used during scanning.
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.UserAgent user_agent = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setUserAgent($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\WebSecurityScanner\V1\ScanConfig\UserAgent::class);
        $this->user_agent = $var;

        return $this;
    }

    /**
     * The excluded URL patterns as described in
     * https://cloud.google.com/security-command-center/docs/how-to-use-web-security-scanner#excluding_urls
     *
     * Generated from protobuf field <code>repeated string blacklist_patterns = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBlacklistPatterns()
    {
        return $this->blacklist_patterns;
    }

    /**
     * The excluded URL patterns as described in
     * https://cloud.google.com/security-command-center/docs/how-to-use-web-security-scanner#excluding_urls
     *
     * Generated from protobuf field <code>repeated string blacklist_patterns = 7;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBlacklistPatterns($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->blacklist_patterns = $arr;

        return $this;
    }

    /**
     * The schedule of the ScanConfig.
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.Schedule schedule = 8;</code>
     * @return \Google\Cloud\WebSecurityScanner\V1\ScanConfig\Schedule|null
     */
    public function getSchedule()
    {
        return $this->schedule;
    }

    public function hasSchedule()
    {
        return isset($this->schedule);
    }

    public function clearSchedule()
    {
        unset($this->schedule);
    }

    /**
     * The schedule of the ScanConfig.
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.Schedule schedule = 8;</code>
     * @param \Google\Cloud\WebSecurityScanner\V1\ScanConfig\Schedule $var
     * @return $this
     */
    public function setSchedule($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\WebSecurityScanner\V1\ScanConfig\Schedule::class);
        $this->schedule = $var;

        return $this;
    }

    /**
     * Controls export of scan configurations and results to Security
     * Command Center.
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.ExportToSecurityCommandCenter export_to_security_command_center = 10;</code>
     * @return int
     */
    public function getExportToSecurityCommandCenter()
    {
        return $this->export_to_security_command_center;
    }

    /**
     * Controls export of scan configurations and results to Security
     * Command Center.
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.ExportToSecurityCommandCenter export_to_security_command_center = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setExportToSecurityCommandCenter($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\WebSecurityScanner\V1\ScanConfig\ExportToSecurityCommandCenter::class);
        $this->export_to_security_command_center = $var;

        return $this;
    }

    /**
     * The risk level selected for the scan
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.RiskLevel risk_level = 12;</code>
     * @return int
     */
    public function getRiskLevel()
    {
        return $this->risk_level;
    }

    /**
     * The risk level selected for the scan
     *
     * Generated from protobuf field <code>.google.cloud.websecurityscanner.v1.ScanConfig.RiskLevel risk_level = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setRiskLevel($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\WebSecurityScanner\V1\ScanConfig\RiskLevel::class);
        $this->risk_level = $var;

        return $this;
    }

    /**
     * Whether the scan config is managed by Web Security Scanner, output
     * only.
     *
     * Generated from protobuf field <code>bool managed_scan = 13;</code>
     * @return bool
     */
    public function getManagedScan()
    {
        return $this->managed_scan;
    }

    /**
     * Whether the scan config is managed by Web Security Scanner, output
     * only.
     *
     * Generated from protobuf field <code>bool managed_scan = 13;</code>
     * @param bool $var
     * @return $this
     */
    public function setManagedScan($var)
    {
        GPBUtil::checkBool($var);
        $this->managed_scan = $var;

        return $this;
    }

    /**
     * Whether the scan configuration has enabled static IP address scan feature.
     * If enabled, the scanner will access applications from static IP addresses.
     *
     * Generated from protobuf field <code>bool static_ip_scan = 14;</code>
     * @return bool
     */
    public function getStaticIpScan()
    {
        return $this->static_ip_scan;
    }

    /**
     * Whether the scan configuration has enabled static IP address scan feature.
     * If enabled, the scanner will access applications from static IP addresses.
     *
     * Generated from protobuf field <code>bool static_ip_scan = 14;</code>
     * @param bool $var
     * @return $this
     */
    public function setStaticIpScan($var)
    {
        GPBUtil::checkBool($var);
        $this->static_ip_scan = $var;

        return $this;
    }

    /**
     * Whether to keep scanning even if most requests return HTTP error codes.
     *
     * Generated from protobuf field <code>bool ignore_http_status_errors = 15;</code>
     * @return bool
     */
    public function getIgnoreHttpStatusErrors()
    {
        return $this->ignore_http_status_errors;
    }

    /**
     * Whether to keep scanning even if most requests return HTTP error codes.
     *
     * Generated from protobuf field <code>bool ignore_http_status_errors = 15;</code>
     * @param bool $var
     * @return $this
     */
    public function setIgnoreHttpStatusErrors($var)
    {
        GPBUtil::checkBool($var);
        $this->ignore_http_status_errors = $var;

        return $this;
    }

}

