<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/managedkafka/v1/managed_kafka.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ManagedKafka\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\ManagedKafka\V1\Acl;
use Google\Cloud\ManagedKafka\V1\AddAclEntryRequest;
use Google\Cloud\ManagedKafka\V1\AddAclEntryResponse;
use Google\Cloud\ManagedKafka\V1\Cluster;
use Google\Cloud\ManagedKafka\V1\ConsumerGroup;
use Google\Cloud\ManagedKafka\V1\CreateAclRequest;
use Google\Cloud\ManagedKafka\V1\CreateClusterRequest;
use Google\Cloud\ManagedKafka\V1\CreateTopicRequest;
use Google\Cloud\ManagedKafka\V1\DeleteAclRequest;
use Google\Cloud\ManagedKafka\V1\DeleteClusterRequest;
use Google\Cloud\ManagedKafka\V1\DeleteConsumerGroupRequest;
use Google\Cloud\ManagedKafka\V1\DeleteTopicRequest;
use Google\Cloud\ManagedKafka\V1\GetAclRequest;
use Google\Cloud\ManagedKafka\V1\GetClusterRequest;
use Google\Cloud\ManagedKafka\V1\GetConsumerGroupRequest;
use Google\Cloud\ManagedKafka\V1\GetTopicRequest;
use Google\Cloud\ManagedKafka\V1\ListAclsRequest;
use Google\Cloud\ManagedKafka\V1\ListClustersRequest;
use Google\Cloud\ManagedKafka\V1\ListConsumerGroupsRequest;
use Google\Cloud\ManagedKafka\V1\ListTopicsRequest;
use Google\Cloud\ManagedKafka\V1\RemoveAclEntryRequest;
use Google\Cloud\ManagedKafka\V1\RemoveAclEntryResponse;
use Google\Cloud\ManagedKafka\V1\Topic;
use Google\Cloud\ManagedKafka\V1\UpdateAclRequest;
use Google\Cloud\ManagedKafka\V1\UpdateClusterRequest;
use Google\Cloud\ManagedKafka\V1\UpdateConsumerGroupRequest;
use Google\Cloud\ManagedKafka\V1\UpdateTopicRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The service that a client application uses to manage Apache Kafka clusters,
 * topics and consumer groups.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<AddAclEntryResponse> addAclEntryAsync(AddAclEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Acl> createAclAsync(CreateAclRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createClusterAsync(CreateClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Topic> createTopicAsync(CreateTopicRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteAclAsync(DeleteAclRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteClusterAsync(DeleteClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteConsumerGroupAsync(DeleteConsumerGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteTopicAsync(DeleteTopicRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Acl> getAclAsync(GetAclRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Cluster> getClusterAsync(GetClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ConsumerGroup> getConsumerGroupAsync(GetConsumerGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Topic> getTopicAsync(GetTopicRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAclsAsync(ListAclsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listClustersAsync(ListClustersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listConsumerGroupsAsync(ListConsumerGroupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTopicsAsync(ListTopicsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RemoveAclEntryResponse> removeAclEntryAsync(RemoveAclEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Acl> updateAclAsync(UpdateAclRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateClusterAsync(UpdateClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ConsumerGroup> updateConsumerGroupAsync(UpdateConsumerGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Topic> updateTopicAsync(UpdateTopicRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class ManagedKafkaClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.managedkafka.v1.ManagedKafka';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'managedkafka.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'managedkafka.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/managed_kafka_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/managed_kafka_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/managed_kafka_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/managed_kafka_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a acl
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     * @param string $acl
     *
     * @return string The formatted acl resource.
     */
    public static function aclName(string $project, string $location, string $cluster, string $acl): string
    {
        return self::getPathTemplate('acl')->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
            'acl' => $acl,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a ca_pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $caPool
     *
     * @return string The formatted ca_pool resource.
     */
    public static function caPoolName(string $project, string $location, string $caPool): string
    {
        return self::getPathTemplate('caPool')->render([
            'project' => $project,
            'location' => $location,
            'ca_pool' => $caPool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cluster
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     *
     * @return string The formatted cluster resource.
     */
    public static function clusterName(string $project, string $location, string $cluster): string
    {
        return self::getPathTemplate('cluster')->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * consumer_group resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     * @param string $consumerGroup
     *
     * @return string The formatted consumer_group resource.
     */
    public static function consumerGroupName(
        string $project,
        string $location,
        string $cluster,
        string $consumerGroup
    ): string {
        return self::getPathTemplate('consumerGroup')->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
            'consumer_group' => $consumerGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(string $project, string $location, string $keyRing, string $cryptoKey): string
    {
        return self::getPathTemplate('cryptoKey')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a topic
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     * @param string $topic
     *
     * @return string The formatted topic resource.
     */
    public static function topicName(string $project, string $location, string $cluster, string $topic): string
    {
        return self::getPathTemplate('topic')->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
            'topic' => $topic,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - acl: projects/{project}/locations/{location}/clusters/{cluster}/acls/{acl}
     * - caPool: projects/{project}/locations/{location}/caPools/{ca_pool}
     * - cluster: projects/{project}/locations/{location}/clusters/{cluster}
     * - consumerGroup: projects/{project}/locations/{location}/clusters/{cluster}/consumerGroups/{consumer_group}
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - location: projects/{project}/locations/{location}
     * - topic: projects/{project}/locations/{location}/clusters/{cluster}/topics/{topic}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'managedkafka.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Incremental update: Adds an acl entry to an acl. Creates the acl if it does
     * not exist yet.
     *
     * The async variant is {@see ManagedKafkaClient::addAclEntryAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/add_acl_entry.php
     *
     * @param AddAclEntryRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AddAclEntryResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addAclEntry(AddAclEntryRequest $request, array $callOptions = []): AddAclEntryResponse
    {
        return $this->startApiCall('AddAclEntry', $request, $callOptions)->wait();
    }

    /**
     * Creates a new acl in the given project, location, and cluster.
     *
     * The async variant is {@see ManagedKafkaClient::createAclAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/create_acl.php
     *
     * @param CreateAclRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Acl
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAcl(CreateAclRequest $request, array $callOptions = []): Acl
    {
        return $this->startApiCall('CreateAcl', $request, $callOptions)->wait();
    }

    /**
     * Creates a new cluster in a given project and location.
     *
     * The async variant is {@see ManagedKafkaClient::createClusterAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/create_cluster.php
     *
     * @param CreateClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCluster(CreateClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCluster', $request, $callOptions)->wait();
    }

    /**
     * Creates a new topic in a given project and location.
     *
     * The async variant is {@see ManagedKafkaClient::createTopicAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/create_topic.php
     *
     * @param CreateTopicRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Topic
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTopic(CreateTopicRequest $request, array $callOptions = []): Topic
    {
        return $this->startApiCall('CreateTopic', $request, $callOptions)->wait();
    }

    /**
     * Deletes an acl.
     *
     * The async variant is {@see ManagedKafkaClient::deleteAclAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/delete_acl.php
     *
     * @param DeleteAclRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAcl(DeleteAclRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAcl', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single cluster.
     *
     * The async variant is {@see ManagedKafkaClient::deleteClusterAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/delete_cluster.php
     *
     * @param DeleteClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCluster(DeleteClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCluster', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single consumer group.
     *
     * The async variant is {@see ManagedKafkaClient::deleteConsumerGroupAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/delete_consumer_group.php
     *
     * @param DeleteConsumerGroupRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteConsumerGroup(DeleteConsumerGroupRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteConsumerGroup', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single topic.
     *
     * The async variant is {@see ManagedKafkaClient::deleteTopicAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/delete_topic.php
     *
     * @param DeleteTopicRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTopic(DeleteTopicRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteTopic', $request, $callOptions)->wait();
    }

    /**
     * Returns the properties of a single acl.
     *
     * The async variant is {@see ManagedKafkaClient::getAclAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/get_acl.php
     *
     * @param GetAclRequest $request     A request to house fields associated with the call.
     * @param array         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Acl
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAcl(GetAclRequest $request, array $callOptions = []): Acl
    {
        return $this->startApiCall('GetAcl', $request, $callOptions)->wait();
    }

    /**
     * Returns the properties of a single cluster.
     *
     * The async variant is {@see ManagedKafkaClient::getClusterAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/get_cluster.php
     *
     * @param GetClusterRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Cluster
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCluster(GetClusterRequest $request, array $callOptions = []): Cluster
    {
        return $this->startApiCall('GetCluster', $request, $callOptions)->wait();
    }

    /**
     * Returns the properties of a single consumer group.
     *
     * The async variant is {@see ManagedKafkaClient::getConsumerGroupAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/get_consumer_group.php
     *
     * @param GetConsumerGroupRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConsumerGroup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConsumerGroup(GetConsumerGroupRequest $request, array $callOptions = []): ConsumerGroup
    {
        return $this->startApiCall('GetConsumerGroup', $request, $callOptions)->wait();
    }

    /**
     * Returns the properties of a single topic.
     *
     * The async variant is {@see ManagedKafkaClient::getTopicAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/get_topic.php
     *
     * @param GetTopicRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Topic
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTopic(GetTopicRequest $request, array $callOptions = []): Topic
    {
        return $this->startApiCall('GetTopic', $request, $callOptions)->wait();
    }

    /**
     * Lists the acls in a given cluster.
     *
     * The async variant is {@see ManagedKafkaClient::listAclsAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/list_acls.php
     *
     * @param ListAclsRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAcls(ListAclsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAcls', $request, $callOptions);
    }

    /**
     * Lists the clusters in a given project and location.
     *
     * The async variant is {@see ManagedKafkaClient::listClustersAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/list_clusters.php
     *
     * @param ListClustersRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listClusters(ListClustersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListClusters', $request, $callOptions);
    }

    /**
     * Lists the consumer groups in a given cluster.
     *
     * The async variant is {@see ManagedKafkaClient::listConsumerGroupsAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/list_consumer_groups.php
     *
     * @param ListConsumerGroupsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listConsumerGroups(ListConsumerGroupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConsumerGroups', $request, $callOptions);
    }

    /**
     * Lists the topics in a given cluster.
     *
     * The async variant is {@see ManagedKafkaClient::listTopicsAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/list_topics.php
     *
     * @param ListTopicsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTopics(ListTopicsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTopics', $request, $callOptions);
    }

    /**
     * Incremental update: Removes an acl entry from an acl. Deletes the acl if
     * its acl entries become empty (i.e. if the removed entry was the last one in
     * the acl).
     *
     * The async variant is {@see ManagedKafkaClient::removeAclEntryAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/remove_acl_entry.php
     *
     * @param RemoveAclEntryRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RemoveAclEntryResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function removeAclEntry(RemoveAclEntryRequest $request, array $callOptions = []): RemoveAclEntryResponse
    {
        return $this->startApiCall('RemoveAclEntry', $request, $callOptions)->wait();
    }

    /**
     * Updates the properties of a single acl.
     *
     * The async variant is {@see ManagedKafkaClient::updateAclAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/update_acl.php
     *
     * @param UpdateAclRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Acl
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAcl(UpdateAclRequest $request, array $callOptions = []): Acl
    {
        return $this->startApiCall('UpdateAcl', $request, $callOptions)->wait();
    }

    /**
     * Updates the properties of a single cluster.
     *
     * The async variant is {@see ManagedKafkaClient::updateClusterAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/update_cluster.php
     *
     * @param UpdateClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCluster(UpdateClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCluster', $request, $callOptions)->wait();
    }

    /**
     * Updates the properties of a single consumer group.
     *
     * The async variant is {@see ManagedKafkaClient::updateConsumerGroupAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/update_consumer_group.php
     *
     * @param UpdateConsumerGroupRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConsumerGroup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateConsumerGroup(UpdateConsumerGroupRequest $request, array $callOptions = []): ConsumerGroup
    {
        return $this->startApiCall('UpdateConsumerGroup', $request, $callOptions)->wait();
    }

    /**
     * Updates the properties of a single topic.
     *
     * The async variant is {@see ManagedKafkaClient::updateTopicAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/update_topic.php
     *
     * @param UpdateTopicRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Topic
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTopic(UpdateTopicRequest $request, array $callOptions = []): Topic
    {
        return $this->startApiCall('UpdateTopic', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see ManagedKafkaClient::getLocationAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see ManagedKafkaClient::listLocationsAsync()} .
     *
     * @example samples/V1/ManagedKafkaClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
