<?php
/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/google/googleapis/blob/master/google/firestore/admin/v1/firestore_admin.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Firestore\Admin\V1;

use Google\Cloud\Firestore\Admin\V1\Gapic\FirestoreAdminGapicClient;
use Google\ApiCore\PathTemplate;

/** {@inheritdoc} */
class FirestoreAdminClient extends FirestoreAdminGapicClient
{
    /**
     * Formats a string containing the fully-qualified path to represent
     * a parent resource.
     *
     * @param string $project
     * @param string $database
     * @param string $collectionId
     *
     * @return string The formatted parent resource.
     * @deprecated
     */
    public static function parentName($project, $database, $collectionId)
    {
        return (new PathTemplate('projects/{project}/databases/{database}/collectionGroups/{collection_id}'))->render([
            'project' => $project,
            'database' => $database,
            'collection_id' => $collectionId,
        ]);
    }
}
