<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/deploy/v1/cloud_deploy.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Deploy\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Deploy\V1\AbandonReleaseRequest;
use Google\Cloud\Deploy\V1\AbandonReleaseResponse;
use Google\Cloud\Deploy\V1\AdvanceRolloutRequest;
use Google\Cloud\Deploy\V1\AdvanceRolloutResponse;
use Google\Cloud\Deploy\V1\ApproveRolloutRequest;
use Google\Cloud\Deploy\V1\ApproveRolloutResponse;
use Google\Cloud\Deploy\V1\Automation;
use Google\Cloud\Deploy\V1\AutomationRun;
use Google\Cloud\Deploy\V1\CancelAutomationRunRequest;
use Google\Cloud\Deploy\V1\CancelAutomationRunResponse;
use Google\Cloud\Deploy\V1\CancelRolloutRequest;
use Google\Cloud\Deploy\V1\CancelRolloutResponse;
use Google\Cloud\Deploy\V1\Config;
use Google\Cloud\Deploy\V1\CreateAutomationRequest;
use Google\Cloud\Deploy\V1\CreateCustomTargetTypeRequest;
use Google\Cloud\Deploy\V1\CreateDeliveryPipelineRequest;
use Google\Cloud\Deploy\V1\CreateDeployPolicyRequest;
use Google\Cloud\Deploy\V1\CreateReleaseRequest;
use Google\Cloud\Deploy\V1\CreateRolloutRequest;
use Google\Cloud\Deploy\V1\CreateTargetRequest;
use Google\Cloud\Deploy\V1\CustomTargetType;
use Google\Cloud\Deploy\V1\DeleteAutomationRequest;
use Google\Cloud\Deploy\V1\DeleteCustomTargetTypeRequest;
use Google\Cloud\Deploy\V1\DeleteDeliveryPipelineRequest;
use Google\Cloud\Deploy\V1\DeleteDeployPolicyRequest;
use Google\Cloud\Deploy\V1\DeleteTargetRequest;
use Google\Cloud\Deploy\V1\DeliveryPipeline;
use Google\Cloud\Deploy\V1\DeployPolicy;
use Google\Cloud\Deploy\V1\GetAutomationRequest;
use Google\Cloud\Deploy\V1\GetAutomationRunRequest;
use Google\Cloud\Deploy\V1\GetConfigRequest;
use Google\Cloud\Deploy\V1\GetCustomTargetTypeRequest;
use Google\Cloud\Deploy\V1\GetDeliveryPipelineRequest;
use Google\Cloud\Deploy\V1\GetDeployPolicyRequest;
use Google\Cloud\Deploy\V1\GetJobRunRequest;
use Google\Cloud\Deploy\V1\GetReleaseRequest;
use Google\Cloud\Deploy\V1\GetRolloutRequest;
use Google\Cloud\Deploy\V1\GetTargetRequest;
use Google\Cloud\Deploy\V1\IgnoreJobRequest;
use Google\Cloud\Deploy\V1\IgnoreJobResponse;
use Google\Cloud\Deploy\V1\JobRun;
use Google\Cloud\Deploy\V1\ListAutomationRunsRequest;
use Google\Cloud\Deploy\V1\ListAutomationsRequest;
use Google\Cloud\Deploy\V1\ListCustomTargetTypesRequest;
use Google\Cloud\Deploy\V1\ListDeliveryPipelinesRequest;
use Google\Cloud\Deploy\V1\ListDeployPoliciesRequest;
use Google\Cloud\Deploy\V1\ListJobRunsRequest;
use Google\Cloud\Deploy\V1\ListReleasesRequest;
use Google\Cloud\Deploy\V1\ListRolloutsRequest;
use Google\Cloud\Deploy\V1\ListTargetsRequest;
use Google\Cloud\Deploy\V1\Release;
use Google\Cloud\Deploy\V1\RetryJobRequest;
use Google\Cloud\Deploy\V1\RetryJobResponse;
use Google\Cloud\Deploy\V1\RollbackTargetRequest;
use Google\Cloud\Deploy\V1\RollbackTargetResponse;
use Google\Cloud\Deploy\V1\Rollout;
use Google\Cloud\Deploy\V1\Target;
use Google\Cloud\Deploy\V1\TerminateJobRunRequest;
use Google\Cloud\Deploy\V1\TerminateJobRunResponse;
use Google\Cloud\Deploy\V1\UpdateAutomationRequest;
use Google\Cloud\Deploy\V1\UpdateCustomTargetTypeRequest;
use Google\Cloud\Deploy\V1\UpdateDeliveryPipelineRequest;
use Google\Cloud\Deploy\V1\UpdateDeployPolicyRequest;
use Google\Cloud\Deploy\V1\UpdateTargetRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: CloudDeploy service creates and manages Continuous Delivery operations
 * on Google Cloud Platform via Skaffold (https://skaffold.dev).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<AbandonReleaseResponse> abandonReleaseAsync(AbandonReleaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AdvanceRolloutResponse> advanceRolloutAsync(AdvanceRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApproveRolloutResponse> approveRolloutAsync(ApproveRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CancelAutomationRunResponse> cancelAutomationRunAsync(CancelAutomationRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CancelRolloutResponse> cancelRolloutAsync(CancelRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createAutomationAsync(CreateAutomationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createCustomTargetTypeAsync(CreateCustomTargetTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createDeliveryPipelineAsync(CreateDeliveryPipelineRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createDeployPolicyAsync(CreateDeployPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createReleaseAsync(CreateReleaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createRolloutAsync(CreateRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createTargetAsync(CreateTargetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteAutomationAsync(DeleteAutomationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteCustomTargetTypeAsync(DeleteCustomTargetTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteDeliveryPipelineAsync(DeleteDeliveryPipelineRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteDeployPolicyAsync(DeleteDeployPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteTargetAsync(DeleteTargetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Automation> getAutomationAsync(GetAutomationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AutomationRun> getAutomationRunAsync(GetAutomationRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Config> getConfigAsync(GetConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CustomTargetType> getCustomTargetTypeAsync(GetCustomTargetTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DeliveryPipeline> getDeliveryPipelineAsync(GetDeliveryPipelineRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DeployPolicy> getDeployPolicyAsync(GetDeployPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<JobRun> getJobRunAsync(GetJobRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Release> getReleaseAsync(GetReleaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Rollout> getRolloutAsync(GetRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Target> getTargetAsync(GetTargetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<IgnoreJobResponse> ignoreJobAsync(IgnoreJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAutomationRunsAsync(ListAutomationRunsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAutomationsAsync(ListAutomationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listCustomTargetTypesAsync(ListCustomTargetTypesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDeliveryPipelinesAsync(ListDeliveryPipelinesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDeployPoliciesAsync(ListDeployPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listJobRunsAsync(ListJobRunsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listReleasesAsync(ListReleasesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRolloutsAsync(ListRolloutsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTargetsAsync(ListTargetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RetryJobResponse> retryJobAsync(RetryJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RollbackTargetResponse> rollbackTargetAsync(RollbackTargetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TerminateJobRunResponse> terminateJobRunAsync(TerminateJobRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateAutomationAsync(UpdateAutomationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateCustomTargetTypeAsync(UpdateCustomTargetTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateDeliveryPipelineAsync(UpdateDeliveryPipelineRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateDeployPolicyAsync(UpdateDeployPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateTargetAsync(UpdateTargetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class CloudDeployClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.deploy.v1.CloudDeploy';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'clouddeploy.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'clouddeploy.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/cloud_deploy_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/cloud_deploy_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/cloud_deploy_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/cloud_deploy_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a automation
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     * @param string $automation
     *
     * @return string The formatted automation resource.
     */
    public static function automationName(
        string $project,
        string $location,
        string $deliveryPipeline,
        string $automation
    ): string {
        return self::getPathTemplate('automation')->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
            'automation' => $automation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * automation_run resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     * @param string $automationRun
     *
     * @return string The formatted automation_run resource.
     */
    public static function automationRunName(
        string $project,
        string $location,
        string $deliveryPipeline,
        string $automationRun
    ): string {
        return self::getPathTemplate('automationRun')->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
            'automation_run' => $automationRun,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a build
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $build
     *
     * @return string The formatted build resource.
     */
    public static function buildName(string $project, string $location, string $build): string
    {
        return self::getPathTemplate('build')->render([
            'project' => $project,
            'location' => $location,
            'build' => $build,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cluster
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     *
     * @return string The formatted cluster resource.
     */
    public static function clusterName(string $project, string $location, string $cluster): string
    {
        return self::getPathTemplate('cluster')->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a config
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted config resource.
     */
    public static function configName(string $project, string $location): string
    {
        return self::getPathTemplate('config')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * custom_target_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $customTargetType
     *
     * @return string The formatted custom_target_type resource.
     */
    public static function customTargetTypeName(string $project, string $location, string $customTargetType): string
    {
        return self::getPathTemplate('customTargetType')->render([
            'project' => $project,
            'location' => $location,
            'custom_target_type' => $customTargetType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * delivery_pipeline resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     *
     * @return string The formatted delivery_pipeline resource.
     */
    public static function deliveryPipelineName(string $project, string $location, string $deliveryPipeline): string
    {
        return self::getPathTemplate('deliveryPipeline')->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * deploy_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deployPolicy
     *
     * @return string The formatted deploy_policy resource.
     */
    public static function deployPolicyName(string $project, string $location, string $deployPolicy): string
    {
        return self::getPathTemplate('deployPolicy')->render([
            'project' => $project,
            'location' => $location,
            'deploy_policy' => $deployPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $job
     *
     * @return string The formatted job resource.
     */
    public static function jobName(string $project, string $location, string $job): string
    {
        return self::getPathTemplate('job')->render([
            'project' => $project,
            'location' => $location,
            'job' => $job,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a job_run
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     * @param string $release
     * @param string $rollout
     * @param string $jobRun
     *
     * @return string The formatted job_run resource.
     */
    public static function jobRunName(
        string $project,
        string $location,
        string $deliveryPipeline,
        string $release,
        string $rollout,
        string $jobRun
    ): string {
        return self::getPathTemplate('jobRun')->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
            'release' => $release,
            'rollout' => $rollout,
            'job_run' => $jobRun,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a membership
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $membership
     *
     * @return string The formatted membership resource.
     */
    public static function membershipName(string $project, string $location, string $membership): string
    {
        return self::getPathTemplate('membership')->render([
            'project' => $project,
            'location' => $location,
            'membership' => $membership,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a release
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     * @param string $release
     *
     * @return string The formatted release resource.
     */
    public static function releaseName(
        string $project,
        string $location,
        string $deliveryPipeline,
        string $release
    ): string {
        return self::getPathTemplate('release')->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
            'release' => $release,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a repository
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connection
     * @param string $repository
     *
     * @return string The formatted repository resource.
     */
    public static function repositoryName(
        string $project,
        string $location,
        string $connection,
        string $repository
    ): string {
        return self::getPathTemplate('repository')->render([
            'project' => $project,
            'location' => $location,
            'connection' => $connection,
            'repository' => $repository,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a rollout
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     * @param string $release
     * @param string $rollout
     *
     * @return string The formatted rollout resource.
     */
    public static function rolloutName(
        string $project,
        string $location,
        string $deliveryPipeline,
        string $release,
        string $rollout
    ): string {
        return self::getPathTemplate('rollout')->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
            'release' => $release,
            'rollout' => $rollout,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a service
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $service
     *
     * @return string The formatted service resource.
     */
    public static function serviceName(string $project, string $location, string $service): string
    {
        return self::getPathTemplate('service')->render([
            'project' => $project,
            'location' => $location,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a target
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $target
     *
     * @return string The formatted target resource.
     */
    public static function targetName(string $project, string $location, string $target): string
    {
        return self::getPathTemplate('target')->render([
            'project' => $project,
            'location' => $location,
            'target' => $target,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a worker_pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $workerPool
     *
     * @return string The formatted worker_pool resource.
     */
    public static function workerPoolName(string $project, string $location, string $workerPool): string
    {
        return self::getPathTemplate('workerPool')->render([
            'project' => $project,
            'location' => $location,
            'worker_pool' => $workerPool,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - automation: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}
     * - automationRun: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}
     * - build: projects/{project}/locations/{location}/builds/{build}
     * - cluster: projects/{project}/locations/{location}/clusters/{cluster}
     * - config: projects/{project}/locations/{location}/config
     * - customTargetType: projects/{project}/locations/{location}/customTargetTypes/{custom_target_type}
     * - deliveryPipeline: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}
     * - deployPolicy: projects/{project}/locations/{location}/deployPolicies/{deploy_policy}
     * - job: projects/{project}/locations/{location}/jobs/{job}
     * - jobRun: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}/rollouts/{rollout}/jobRuns/{job_run}
     * - location: projects/{project}/locations/{location}
     * - membership: projects/{project}/locations/{location}/memberships/{membership}
     * - release: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}
     * - repository: projects/{project}/locations/{location}/connections/{connection}/repositories/{repository}
     * - rollout: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}/rollouts/{rollout}
     * - service: projects/{project}/locations/{location}/services/{service}
     * - target: projects/{project}/locations/{location}/targets/{target}
     * - workerPool: projects/{project}/locations/{location}/workerPools/{worker_pool}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'clouddeploy.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Abandons a Release in the Delivery Pipeline.
     *
     * The async variant is {@see CloudDeployClient::abandonReleaseAsync()} .
     *
     * @example samples/V1/CloudDeployClient/abandon_release.php
     *
     * @param AbandonReleaseRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AbandonReleaseResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function abandonRelease(AbandonReleaseRequest $request, array $callOptions = []): AbandonReleaseResponse
    {
        return $this->startApiCall('AbandonRelease', $request, $callOptions)->wait();
    }

    /**
     * Advances a Rollout in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::advanceRolloutAsync()} .
     *
     * @example samples/V1/CloudDeployClient/advance_rollout.php
     *
     * @param AdvanceRolloutRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AdvanceRolloutResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function advanceRollout(AdvanceRolloutRequest $request, array $callOptions = []): AdvanceRolloutResponse
    {
        return $this->startApiCall('AdvanceRollout', $request, $callOptions)->wait();
    }

    /**
     * Approves a Rollout.
     *
     * The async variant is {@see CloudDeployClient::approveRolloutAsync()} .
     *
     * @example samples/V1/CloudDeployClient/approve_rollout.php
     *
     * @param ApproveRolloutRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApproveRolloutResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function approveRollout(ApproveRolloutRequest $request, array $callOptions = []): ApproveRolloutResponse
    {
        return $this->startApiCall('ApproveRollout', $request, $callOptions)->wait();
    }

    /**
     * Cancels an AutomationRun. The `state` of the `AutomationRun` after
     * cancelling is `CANCELLED`. `CancelAutomationRun` can be called on
     * AutomationRun in the state `IN_PROGRESS` and `PENDING`; AutomationRun
     * in a different state returns an `FAILED_PRECONDITION` error.
     *
     * The async variant is {@see CloudDeployClient::cancelAutomationRunAsync()} .
     *
     * @example samples/V1/CloudDeployClient/cancel_automation_run.php
     *
     * @param CancelAutomationRunRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CancelAutomationRunResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelAutomationRun(
        CancelAutomationRunRequest $request,
        array $callOptions = []
    ): CancelAutomationRunResponse {
        return $this->startApiCall('CancelAutomationRun', $request, $callOptions)->wait();
    }

    /**
     * Cancels a Rollout in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::cancelRolloutAsync()} .
     *
     * @example samples/V1/CloudDeployClient/cancel_rollout.php
     *
     * @param CancelRolloutRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CancelRolloutResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelRollout(CancelRolloutRequest $request, array $callOptions = []): CancelRolloutResponse
    {
        return $this->startApiCall('CancelRollout', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Automation in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::createAutomationAsync()} .
     *
     * @example samples/V1/CloudDeployClient/create_automation.php
     *
     * @param CreateAutomationRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAutomation(CreateAutomationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAutomation', $request, $callOptions)->wait();
    }

    /**
     * Creates a new CustomTargetType in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::createCustomTargetTypeAsync()} .
     *
     * @example samples/V1/CloudDeployClient/create_custom_target_type.php
     *
     * @param CreateCustomTargetTypeRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCustomTargetType(
        CreateCustomTargetTypeRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateCustomTargetType', $request, $callOptions)->wait();
    }

    /**
     * Creates a new DeliveryPipeline in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::createDeliveryPipelineAsync()} .
     *
     * @example samples/V1/CloudDeployClient/create_delivery_pipeline.php
     *
     * @param CreateDeliveryPipelineRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDeliveryPipeline(
        CreateDeliveryPipelineRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateDeliveryPipeline', $request, $callOptions)->wait();
    }

    /**
     * Creates a new DeployPolicy in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::createDeployPolicyAsync()} .
     *
     * @example samples/V1/CloudDeployClient/create_deploy_policy.php
     *
     * @param CreateDeployPolicyRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDeployPolicy(CreateDeployPolicyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateDeployPolicy', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Release in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::createReleaseAsync()} .
     *
     * @example samples/V1/CloudDeployClient/create_release.php
     *
     * @param CreateReleaseRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRelease(CreateReleaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRelease', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Rollout in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::createRolloutAsync()} .
     *
     * @example samples/V1/CloudDeployClient/create_rollout.php
     *
     * @param CreateRolloutRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRollout(CreateRolloutRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRollout', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Target in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::createTargetAsync()} .
     *
     * @example samples/V1/CloudDeployClient/create_target.php
     *
     * @param CreateTargetRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTarget(CreateTargetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateTarget', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Automation resource.
     *
     * The async variant is {@see CloudDeployClient::deleteAutomationAsync()} .
     *
     * @example samples/V1/CloudDeployClient/delete_automation.php
     *
     * @param DeleteAutomationRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAutomation(DeleteAutomationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteAutomation', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single CustomTargetType.
     *
     * The async variant is {@see CloudDeployClient::deleteCustomTargetTypeAsync()} .
     *
     * @example samples/V1/CloudDeployClient/delete_custom_target_type.php
     *
     * @param DeleteCustomTargetTypeRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCustomTargetType(
        DeleteCustomTargetTypeRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteCustomTargetType', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single DeliveryPipeline.
     *
     * The async variant is {@see CloudDeployClient::deleteDeliveryPipelineAsync()} .
     *
     * @example samples/V1/CloudDeployClient/delete_delivery_pipeline.php
     *
     * @param DeleteDeliveryPipelineRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDeliveryPipeline(
        DeleteDeliveryPipelineRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteDeliveryPipeline', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single DeployPolicy.
     *
     * The async variant is {@see CloudDeployClient::deleteDeployPolicyAsync()} .
     *
     * @example samples/V1/CloudDeployClient/delete_deploy_policy.php
     *
     * @param DeleteDeployPolicyRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDeployPolicy(DeleteDeployPolicyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteDeployPolicy', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Target.
     *
     * The async variant is {@see CloudDeployClient::deleteTargetAsync()} .
     *
     * @example samples/V1/CloudDeployClient/delete_target.php
     *
     * @param DeleteTargetRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTarget(DeleteTargetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteTarget', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Automation.
     *
     * The async variant is {@see CloudDeployClient::getAutomationAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_automation.php
     *
     * @param GetAutomationRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Automation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAutomation(GetAutomationRequest $request, array $callOptions = []): Automation
    {
        return $this->startApiCall('GetAutomation', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single AutomationRun.
     *
     * The async variant is {@see CloudDeployClient::getAutomationRunAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_automation_run.php
     *
     * @param GetAutomationRunRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AutomationRun
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAutomationRun(GetAutomationRunRequest $request, array $callOptions = []): AutomationRun
    {
        return $this->startApiCall('GetAutomationRun', $request, $callOptions)->wait();
    }

    /**
     * Gets the configuration for a location.
     *
     * The async variant is {@see CloudDeployClient::getConfigAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_config.php
     *
     * @param GetConfigRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Config
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConfig(GetConfigRequest $request, array $callOptions = []): Config
    {
        return $this->startApiCall('GetConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single CustomTargetType.
     *
     * The async variant is {@see CloudDeployClient::getCustomTargetTypeAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_custom_target_type.php
     *
     * @param GetCustomTargetTypeRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomTargetType
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCustomTargetType(GetCustomTargetTypeRequest $request, array $callOptions = []): CustomTargetType
    {
        return $this->startApiCall('GetCustomTargetType', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single DeliveryPipeline.
     *
     * The async variant is {@see CloudDeployClient::getDeliveryPipelineAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_delivery_pipeline.php
     *
     * @param GetDeliveryPipelineRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DeliveryPipeline
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDeliveryPipeline(GetDeliveryPipelineRequest $request, array $callOptions = []): DeliveryPipeline
    {
        return $this->startApiCall('GetDeliveryPipeline', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single DeployPolicy.
     *
     * The async variant is {@see CloudDeployClient::getDeployPolicyAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_deploy_policy.php
     *
     * @param GetDeployPolicyRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DeployPolicy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDeployPolicy(GetDeployPolicyRequest $request, array $callOptions = []): DeployPolicy
    {
        return $this->startApiCall('GetDeployPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single JobRun.
     *
     * The async variant is {@see CloudDeployClient::getJobRunAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_job_run.php
     *
     * @param GetJobRunRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return JobRun
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getJobRun(GetJobRunRequest $request, array $callOptions = []): JobRun
    {
        return $this->startApiCall('GetJobRun', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Release.
     *
     * The async variant is {@see CloudDeployClient::getReleaseAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_release.php
     *
     * @param GetReleaseRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Release
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRelease(GetReleaseRequest $request, array $callOptions = []): Release
    {
        return $this->startApiCall('GetRelease', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Rollout.
     *
     * The async variant is {@see CloudDeployClient::getRolloutAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_rollout.php
     *
     * @param GetRolloutRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Rollout
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRollout(GetRolloutRequest $request, array $callOptions = []): Rollout
    {
        return $this->startApiCall('GetRollout', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Target.
     *
     * The async variant is {@see CloudDeployClient::getTargetAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_target.php
     *
     * @param GetTargetRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Target
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTarget(GetTargetRequest $request, array $callOptions = []): Target
    {
        return $this->startApiCall('GetTarget', $request, $callOptions)->wait();
    }

    /**
     * Ignores the specified Job in a Rollout.
     *
     * The async variant is {@see CloudDeployClient::ignoreJobAsync()} .
     *
     * @example samples/V1/CloudDeployClient/ignore_job.php
     *
     * @param IgnoreJobRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return IgnoreJobResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function ignoreJob(IgnoreJobRequest $request, array $callOptions = []): IgnoreJobResponse
    {
        return $this->startApiCall('IgnoreJob', $request, $callOptions)->wait();
    }

    /**
     * Lists AutomationRuns in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::listAutomationRunsAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_automation_runs.php
     *
     * @param ListAutomationRunsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAutomationRuns(ListAutomationRunsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAutomationRuns', $request, $callOptions);
    }

    /**
     * Lists Automations in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::listAutomationsAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_automations.php
     *
     * @param ListAutomationsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAutomations(ListAutomationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAutomations', $request, $callOptions);
    }

    /**
     * Lists CustomTargetTypes in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::listCustomTargetTypesAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_custom_target_types.php
     *
     * @param ListCustomTargetTypesRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCustomTargetTypes(
        ListCustomTargetTypesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListCustomTargetTypes', $request, $callOptions);
    }

    /**
     * Lists DeliveryPipelines in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::listDeliveryPipelinesAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_delivery_pipelines.php
     *
     * @param ListDeliveryPipelinesRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDeliveryPipelines(
        ListDeliveryPipelinesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListDeliveryPipelines', $request, $callOptions);
    }

    /**
     * Lists DeployPolicies in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::listDeployPoliciesAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_deploy_policies.php
     *
     * @param ListDeployPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDeployPolicies(ListDeployPoliciesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDeployPolicies', $request, $callOptions);
    }

    /**
     * Lists JobRuns in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::listJobRunsAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_job_runs.php
     *
     * @param ListJobRunsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listJobRuns(ListJobRunsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListJobRuns', $request, $callOptions);
    }

    /**
     * Lists Releases in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::listReleasesAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_releases.php
     *
     * @param ListReleasesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listReleases(ListReleasesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListReleases', $request, $callOptions);
    }

    /**
     * Lists Rollouts in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::listRolloutsAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_rollouts.php
     *
     * @param ListRolloutsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRollouts(ListRolloutsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRollouts', $request, $callOptions);
    }

    /**
     * Lists Targets in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::listTargetsAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_targets.php
     *
     * @param ListTargetsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTargets(ListTargetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTargets', $request, $callOptions);
    }

    /**
     * Retries the specified Job in a Rollout.
     *
     * The async variant is {@see CloudDeployClient::retryJobAsync()} .
     *
     * @example samples/V1/CloudDeployClient/retry_job.php
     *
     * @param RetryJobRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RetryJobResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function retryJob(RetryJobRequest $request, array $callOptions = []): RetryJobResponse
    {
        return $this->startApiCall('RetryJob', $request, $callOptions)->wait();
    }

    /**
     * Creates a `Rollout` to roll back the specified target.
     *
     * The async variant is {@see CloudDeployClient::rollbackTargetAsync()} .
     *
     * @example samples/V1/CloudDeployClient/rollback_target.php
     *
     * @param RollbackTargetRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RollbackTargetResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rollbackTarget(RollbackTargetRequest $request, array $callOptions = []): RollbackTargetResponse
    {
        return $this->startApiCall('RollbackTarget', $request, $callOptions)->wait();
    }

    /**
     * Terminates a Job Run in a given project and location.
     *
     * The async variant is {@see CloudDeployClient::terminateJobRunAsync()} .
     *
     * @example samples/V1/CloudDeployClient/terminate_job_run.php
     *
     * @param TerminateJobRunRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TerminateJobRunResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function terminateJobRun(TerminateJobRunRequest $request, array $callOptions = []): TerminateJobRunResponse
    {
        return $this->startApiCall('TerminateJobRun', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Automation resource.
     *
     * The async variant is {@see CloudDeployClient::updateAutomationAsync()} .
     *
     * @example samples/V1/CloudDeployClient/update_automation.php
     *
     * @param UpdateAutomationRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAutomation(UpdateAutomationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateAutomation', $request, $callOptions)->wait();
    }

    /**
     * Updates a single CustomTargetType.
     *
     * The async variant is {@see CloudDeployClient::updateCustomTargetTypeAsync()} .
     *
     * @example samples/V1/CloudDeployClient/update_custom_target_type.php
     *
     * @param UpdateCustomTargetTypeRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCustomTargetType(
        UpdateCustomTargetTypeRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateCustomTargetType', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single DeliveryPipeline.
     *
     * The async variant is {@see CloudDeployClient::updateDeliveryPipelineAsync()} .
     *
     * @example samples/V1/CloudDeployClient/update_delivery_pipeline.php
     *
     * @param UpdateDeliveryPipelineRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDeliveryPipeline(
        UpdateDeliveryPipelineRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateDeliveryPipeline', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single DeployPolicy.
     *
     * The async variant is {@see CloudDeployClient::updateDeployPolicyAsync()} .
     *
     * @example samples/V1/CloudDeployClient/update_deploy_policy.php
     *
     * @param UpdateDeployPolicyRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDeployPolicy(UpdateDeployPolicyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateDeployPolicy', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Target.
     *
     * The async variant is {@see CloudDeployClient::updateTargetAsync()} .
     *
     * @example samples/V1/CloudDeployClient/update_target.php
     *
     * @param UpdateTargetRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTarget(UpdateTargetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateTarget', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see CloudDeployClient::getLocationAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see CloudDeployClient::listLocationsAsync()} .
     *
     * @example samples/V1/CloudDeployClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see CloudDeployClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/CloudDeployClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see CloudDeployClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/CloudDeployClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see CloudDeployClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/CloudDeployClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
