<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/backupdr/v1/backupvault.proto

namespace Google\Cloud\BackupDR\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message describing a DataSource object.
 * Datasource object used to represent Datasource details for both admin and
 * basic view.
 *
 * Generated from protobuf message <code>google.cloud.backupdr.v1.DataSource</code>
 */
class DataSource extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Identifier. Name of the datasource to create.
     * It must have the
     * format`"projects/{project}/locations/{location}/backupVaults/{backupvault}/dataSources/{datasource}"`.
     * `{datasource}` cannot be changed after creation. It must be between 3-63
     * characters long and must be unique within the backup vault.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The DataSource resource instance state.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.DataSource.State state = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Optional. Resource labels to represent user provided metadata.
     * No labels currently defined:
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Output only. The time when the instance was created.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time when the instance was updated.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Number of backups in the data source.
     *
     * Generated from protobuf field <code>optional int64 backup_count = 7;</code>
     */
    protected $backup_count = null;
    /**
     * Server specified ETag for the ManagementServer resource to prevent
     * simultaneous updates from overwiting each other.
     *
     * Generated from protobuf field <code>optional string etag = 14;</code>
     */
    protected $etag = null;
    /**
     * The number of bytes (metadata and data) stored in this datasource.
     *
     * Generated from protobuf field <code>optional int64 total_stored_bytes = 23;</code>
     */
    protected $total_stored_bytes = null;
    /**
     * Output only. The backup configuration state.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.BackupConfigState config_state = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $config_state = 0;
    /**
     * Output only. Details of how the resource is configured for backup.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.BackupConfigInfo backup_config_info = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $backup_config_info = null;
    /**
     * Output only. This field is set to true if the backup is blocked by vault
     * access restriction.
     *
     * Generated from protobuf field <code>bool backup_blocked_by_vault_access_restriction = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $backup_blocked_by_vault_access_restriction = false;
    protected $source_resource;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Identifier. Name of the datasource to create.
     *           It must have the
     *           format`"projects/{project}/locations/{location}/backupVaults/{backupvault}/dataSources/{datasource}"`.
     *           `{datasource}` cannot be changed after creation. It must be between 3-63
     *           characters long and must be unique within the backup vault.
     *     @type int $state
     *           Output only. The DataSource resource instance state.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Resource labels to represent user provided metadata.
     *           No labels currently defined:
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time when the instance was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time when the instance was updated.
     *     @type int|string $backup_count
     *           Number of backups in the data source.
     *     @type string $etag
     *           Server specified ETag for the ManagementServer resource to prevent
     *           simultaneous updates from overwiting each other.
     *     @type int|string $total_stored_bytes
     *           The number of bytes (metadata and data) stored in this datasource.
     *     @type int $config_state
     *           Output only. The backup configuration state.
     *     @type \Google\Cloud\BackupDR\V1\BackupConfigInfo $backup_config_info
     *           Output only. Details of how the resource is configured for backup.
     *     @type \Google\Cloud\BackupDR\V1\DataSourceGcpResource $data_source_gcp_resource
     *           The backed up resource is a Google Cloud resource.
     *           The word 'DataSource' was included in the names to indicate that this is
     *           the representation of the Google Cloud resource used within the
     *           DataSource object.
     *     @type \Google\Cloud\BackupDR\V1\DataSourceBackupApplianceApplication $data_source_backup_appliance_application
     *           The backed up resource is a backup appliance application.
     *     @type bool $backup_blocked_by_vault_access_restriction
     *           Output only. This field is set to true if the backup is blocked by vault
     *           access restriction.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Backupdr\V1\Backupvault::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Identifier. Name of the datasource to create.
     * It must have the
     * format`"projects/{project}/locations/{location}/backupVaults/{backupvault}/dataSources/{datasource}"`.
     * `{datasource}` cannot be changed after creation. It must be between 3-63
     * characters long and must be unique within the backup vault.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Identifier. Name of the datasource to create.
     * It must have the
     * format`"projects/{project}/locations/{location}/backupVaults/{backupvault}/dataSources/{datasource}"`.
     * `{datasource}` cannot be changed after creation. It must be between 3-63
     * characters long and must be unique within the backup vault.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The DataSource resource instance state.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.DataSource.State state = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The DataSource resource instance state.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.DataSource.State state = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BackupDR\V1\DataSource\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Optional. Resource labels to represent user provided metadata.
     * No labels currently defined:
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Resource labels to represent user provided metadata.
     * No labels currently defined:
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. The time when the instance was created.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time when the instance was created.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time when the instance was updated.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time when the instance was updated.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Number of backups in the data source.
     *
     * Generated from protobuf field <code>optional int64 backup_count = 7;</code>
     * @return int|string
     */
    public function getBackupCount()
    {
        return isset($this->backup_count) ? $this->backup_count : 0;
    }

    public function hasBackupCount()
    {
        return isset($this->backup_count);
    }

    public function clearBackupCount()
    {
        unset($this->backup_count);
    }

    /**
     * Number of backups in the data source.
     *
     * Generated from protobuf field <code>optional int64 backup_count = 7;</code>
     * @param int|string $var
     * @return $this
     */
    public function setBackupCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->backup_count = $var;

        return $this;
    }

    /**
     * Server specified ETag for the ManagementServer resource to prevent
     * simultaneous updates from overwiting each other.
     *
     * Generated from protobuf field <code>optional string etag = 14;</code>
     * @return string
     */
    public function getEtag()
    {
        return isset($this->etag) ? $this->etag : '';
    }

    public function hasEtag()
    {
        return isset($this->etag);
    }

    public function clearEtag()
    {
        unset($this->etag);
    }

    /**
     * Server specified ETag for the ManagementServer resource to prevent
     * simultaneous updates from overwiting each other.
     *
     * Generated from protobuf field <code>optional string etag = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * The number of bytes (metadata and data) stored in this datasource.
     *
     * Generated from protobuf field <code>optional int64 total_stored_bytes = 23;</code>
     * @return int|string
     */
    public function getTotalStoredBytes()
    {
        return isset($this->total_stored_bytes) ? $this->total_stored_bytes : 0;
    }

    public function hasTotalStoredBytes()
    {
        return isset($this->total_stored_bytes);
    }

    public function clearTotalStoredBytes()
    {
        unset($this->total_stored_bytes);
    }

    /**
     * The number of bytes (metadata and data) stored in this datasource.
     *
     * Generated from protobuf field <code>optional int64 total_stored_bytes = 23;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTotalStoredBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->total_stored_bytes = $var;

        return $this;
    }

    /**
     * Output only. The backup configuration state.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.BackupConfigState config_state = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getConfigState()
    {
        return $this->config_state;
    }

    /**
     * Output only. The backup configuration state.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.BackupConfigState config_state = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setConfigState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BackupDR\V1\BackupConfigState::class);
        $this->config_state = $var;

        return $this;
    }

    /**
     * Output only. Details of how the resource is configured for backup.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.BackupConfigInfo backup_config_info = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\BackupDR\V1\BackupConfigInfo|null
     */
    public function getBackupConfigInfo()
    {
        return $this->backup_config_info;
    }

    public function hasBackupConfigInfo()
    {
        return isset($this->backup_config_info);
    }

    public function clearBackupConfigInfo()
    {
        unset($this->backup_config_info);
    }

    /**
     * Output only. Details of how the resource is configured for backup.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.BackupConfigInfo backup_config_info = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\BackupDR\V1\BackupConfigInfo $var
     * @return $this
     */
    public function setBackupConfigInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BackupDR\V1\BackupConfigInfo::class);
        $this->backup_config_info = $var;

        return $this;
    }

    /**
     * The backed up resource is a Google Cloud resource.
     * The word 'DataSource' was included in the names to indicate that this is
     * the representation of the Google Cloud resource used within the
     * DataSource object.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.DataSourceGcpResource data_source_gcp_resource = 26;</code>
     * @return \Google\Cloud\BackupDR\V1\DataSourceGcpResource|null
     */
    public function getDataSourceGcpResource()
    {
        return $this->readOneof(26);
    }

    public function hasDataSourceGcpResource()
    {
        return $this->hasOneof(26);
    }

    /**
     * The backed up resource is a Google Cloud resource.
     * The word 'DataSource' was included in the names to indicate that this is
     * the representation of the Google Cloud resource used within the
     * DataSource object.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.DataSourceGcpResource data_source_gcp_resource = 26;</code>
     * @param \Google\Cloud\BackupDR\V1\DataSourceGcpResource $var
     * @return $this
     */
    public function setDataSourceGcpResource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BackupDR\V1\DataSourceGcpResource::class);
        $this->writeOneof(26, $var);

        return $this;
    }

    /**
     * The backed up resource is a backup appliance application.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.DataSourceBackupApplianceApplication data_source_backup_appliance_application = 27;</code>
     * @return \Google\Cloud\BackupDR\V1\DataSourceBackupApplianceApplication|null
     */
    public function getDataSourceBackupApplianceApplication()
    {
        return $this->readOneof(27);
    }

    public function hasDataSourceBackupApplianceApplication()
    {
        return $this->hasOneof(27);
    }

    /**
     * The backed up resource is a backup appliance application.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.DataSourceBackupApplianceApplication data_source_backup_appliance_application = 27;</code>
     * @param \Google\Cloud\BackupDR\V1\DataSourceBackupApplianceApplication $var
     * @return $this
     */
    public function setDataSourceBackupApplianceApplication($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BackupDR\V1\DataSourceBackupApplianceApplication::class);
        $this->writeOneof(27, $var);

        return $this;
    }

    /**
     * Output only. This field is set to true if the backup is blocked by vault
     * access restriction.
     *
     * Generated from protobuf field <code>bool backup_blocked_by_vault_access_restriction = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getBackupBlockedByVaultAccessRestriction()
    {
        return $this->backup_blocked_by_vault_access_restriction;
    }

    /**
     * Output only. This field is set to true if the backup is blocked by vault
     * access restriction.
     *
     * Generated from protobuf field <code>bool backup_blocked_by_vault_access_restriction = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setBackupBlockedByVaultAccessRestriction($var)
    {
        GPBUtil::checkBool($var);
        $this->backup_blocked_by_vault_access_restriction = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSourceResource()
    {
        return $this->whichOneof("source_resource");
    }

}

