<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/asset/v1/asset_service.proto

namespace Google\Cloud\Asset\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Search all resources request.
 *
 * Generated from protobuf message <code>google.cloud.asset.v1.SearchAllResourcesRequest</code>
 */
class SearchAllResourcesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. A scope can be a project, a folder or an organization. The search
     * is limited to the resources within the `scope`.
     * The allowed values are:
     * * projects/{PROJECT_ID}
     * * projects/{PROJECT_NUMBER}
     * * folders/{FOLDER_NUMBER}
     * * organizations/{ORGANIZATION_NUMBER}
     *
     * Generated from protobuf field <code>string scope = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $scope = '';
    /**
     * Optional. The query statement. An empty query can be specified to search
     * all the resources of certain `asset_types` within the given `scope`.
     * Examples:
     * * `name : "Important"` to find Cloud resources whose name contains
     *   "Important" as a word.
     * * `displayName : "Impor*"` to find Cloud resources whose display name
     *   contains "Impor" as a word prefix.
     * * `description : "*por*"` to find Cloud resources whose description
     *   contains "por" as a substring.
     * * `location : "us-west*"` to find Cloud resources whose location is
     *   prefixed with "us-west".
     * * `labels : "prod"` to find Cloud resources whose labels contain "prod" as
     *   a key or value.
     * * `labels.env : "prod"` to find Cloud resources which have a label "env"
     *   and its value is "prod".
     * * `labels.env : *` to find Cloud resources which have a label "env".
     * * `"Important"` to find Cloud resources which contain "Important" as a word
     *   in any of the searchable fields.
     * * `"Impor*"` to find Cloud resources which contain "Impor" as a word prefix
     *   in any of the searchable fields.
     * * `"*por*"` to find Cloud resources which contain "por" as a substring in
     *   any of the searchable fields.
     * * `("Important" AND location : ("us-west1" OR "global"))` to find Cloud
     *   resources which contain "Important" as a word in any of the searchable
     *   fields and are also located in the "us-west1" region or the "global"
     *   location.
     * See [how to construct a
     * query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
     * for more details.
     *
     * Generated from protobuf field <code>string query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $query = '';
    /**
     * Optional. A list of asset types that this request searches for. If empty,
     * it will search all the [searchable asset
     * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
     *
     * Generated from protobuf field <code>repeated string asset_types = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $asset_types;
    /**
     * Optional. The page size for search result pagination. Page size is capped
     * at 500 even if a larger value is given. If set to zero, server will pick an
     * appropriate default. Returned results may be fewer than requested. When
     * this happens, there could be more results as long as `next_page_token` is
     * returned.
     *
     * Generated from protobuf field <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $page_size = 0;
    /**
     * Optional. If present, then retrieve the next batch of results from the
     * preceding call to this method. `page_token` must be the value of
     * `next_page_token` from the previous response. The values of all other
     * method parameters, must be identical to those in the previous call.
     *
     * Generated from protobuf field <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $page_token = '';
    /**
     * Optional. A comma separated list of fields specifying the sorting order of
     * the results. The default order is ascending. Add " DESC" after the field
     * name to indicate descending order. Redundant space characters are ignored.
     * Example: "location DESC, name". See [supported resource metadata
     * fields](https://cloud.google.com/asset-inventory/docs/searching-resources#query_on_resource_metadata_fields)
     * for more details.
     *
     * Generated from protobuf field <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $order_by = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $scope
     *           Required. A scope can be a project, a folder or an organization. The search
     *           is limited to the resources within the `scope`.
     *           The allowed values are:
     *           * projects/{PROJECT_ID}
     *           * projects/{PROJECT_NUMBER}
     *           * folders/{FOLDER_NUMBER}
     *           * organizations/{ORGANIZATION_NUMBER}
     *     @type string $query
     *           Optional. The query statement. An empty query can be specified to search
     *           all the resources of certain `asset_types` within the given `scope`.
     *           Examples:
     *           * `name : "Important"` to find Cloud resources whose name contains
     *             "Important" as a word.
     *           * `displayName : "Impor*"` to find Cloud resources whose display name
     *             contains "Impor" as a word prefix.
     *           * `description : "*por*"` to find Cloud resources whose description
     *             contains "por" as a substring.
     *           * `location : "us-west*"` to find Cloud resources whose location is
     *             prefixed with "us-west".
     *           * `labels : "prod"` to find Cloud resources whose labels contain "prod" as
     *             a key or value.
     *           * `labels.env : "prod"` to find Cloud resources which have a label "env"
     *             and its value is "prod".
     *           * `labels.env : *` to find Cloud resources which have a label "env".
     *           * `"Important"` to find Cloud resources which contain "Important" as a word
     *             in any of the searchable fields.
     *           * `"Impor*"` to find Cloud resources which contain "Impor" as a word prefix
     *             in any of the searchable fields.
     *           * `"*por*"` to find Cloud resources which contain "por" as a substring in
     *             any of the searchable fields.
     *           * `("Important" AND location : ("us-west1" OR "global"))` to find Cloud
     *             resources which contain "Important" as a word in any of the searchable
     *             fields and are also located in the "us-west1" region or the "global"
     *             location.
     *           See [how to construct a
     *           query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
     *           for more details.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $asset_types
     *           Optional. A list of asset types that this request searches for. If empty,
     *           it will search all the [searchable asset
     *           types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
     *     @type int $page_size
     *           Optional. The page size for search result pagination. Page size is capped
     *           at 500 even if a larger value is given. If set to zero, server will pick an
     *           appropriate default. Returned results may be fewer than requested. When
     *           this happens, there could be more results as long as `next_page_token` is
     *           returned.
     *     @type string $page_token
     *           Optional. If present, then retrieve the next batch of results from the
     *           preceding call to this method. `page_token` must be the value of
     *           `next_page_token` from the previous response. The values of all other
     *           method parameters, must be identical to those in the previous call.
     *     @type string $order_by
     *           Optional. A comma separated list of fields specifying the sorting order of
     *           the results. The default order is ascending. Add " DESC" after the field
     *           name to indicate descending order. Redundant space characters are ignored.
     *           Example: "location DESC, name". See [supported resource metadata
     *           fields](https://cloud.google.com/asset-inventory/docs/searching-resources#query_on_resource_metadata_fields)
     *           for more details.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Asset\V1\AssetService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. A scope can be a project, a folder or an organization. The search
     * is limited to the resources within the `scope`.
     * The allowed values are:
     * * projects/{PROJECT_ID}
     * * projects/{PROJECT_NUMBER}
     * * folders/{FOLDER_NUMBER}
     * * organizations/{ORGANIZATION_NUMBER}
     *
     * Generated from protobuf field <code>string scope = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * Required. A scope can be a project, a folder or an organization. The search
     * is limited to the resources within the `scope`.
     * The allowed values are:
     * * projects/{PROJECT_ID}
     * * projects/{PROJECT_NUMBER}
     * * folders/{FOLDER_NUMBER}
     * * organizations/{ORGANIZATION_NUMBER}
     *
     * Generated from protobuf field <code>string scope = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkString($var, True);
        $this->scope = $var;

        return $this;
    }

    /**
     * Optional. The query statement. An empty query can be specified to search
     * all the resources of certain `asset_types` within the given `scope`.
     * Examples:
     * * `name : "Important"` to find Cloud resources whose name contains
     *   "Important" as a word.
     * * `displayName : "Impor*"` to find Cloud resources whose display name
     *   contains "Impor" as a word prefix.
     * * `description : "*por*"` to find Cloud resources whose description
     *   contains "por" as a substring.
     * * `location : "us-west*"` to find Cloud resources whose location is
     *   prefixed with "us-west".
     * * `labels : "prod"` to find Cloud resources whose labels contain "prod" as
     *   a key or value.
     * * `labels.env : "prod"` to find Cloud resources which have a label "env"
     *   and its value is "prod".
     * * `labels.env : *` to find Cloud resources which have a label "env".
     * * `"Important"` to find Cloud resources which contain "Important" as a word
     *   in any of the searchable fields.
     * * `"Impor*"` to find Cloud resources which contain "Impor" as a word prefix
     *   in any of the searchable fields.
     * * `"*por*"` to find Cloud resources which contain "por" as a substring in
     *   any of the searchable fields.
     * * `("Important" AND location : ("us-west1" OR "global"))` to find Cloud
     *   resources which contain "Important" as a word in any of the searchable
     *   fields and are also located in the "us-west1" region or the "global"
     *   location.
     * See [how to construct a
     * query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
     * for more details.
     *
     * Generated from protobuf field <code>string query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Optional. The query statement. An empty query can be specified to search
     * all the resources of certain `asset_types` within the given `scope`.
     * Examples:
     * * `name : "Important"` to find Cloud resources whose name contains
     *   "Important" as a word.
     * * `displayName : "Impor*"` to find Cloud resources whose display name
     *   contains "Impor" as a word prefix.
     * * `description : "*por*"` to find Cloud resources whose description
     *   contains "por" as a substring.
     * * `location : "us-west*"` to find Cloud resources whose location is
     *   prefixed with "us-west".
     * * `labels : "prod"` to find Cloud resources whose labels contain "prod" as
     *   a key or value.
     * * `labels.env : "prod"` to find Cloud resources which have a label "env"
     *   and its value is "prod".
     * * `labels.env : *` to find Cloud resources which have a label "env".
     * * `"Important"` to find Cloud resources which contain "Important" as a word
     *   in any of the searchable fields.
     * * `"Impor*"` to find Cloud resources which contain "Impor" as a word prefix
     *   in any of the searchable fields.
     * * `"*por*"` to find Cloud resources which contain "por" as a substring in
     *   any of the searchable fields.
     * * `("Important" AND location : ("us-west1" OR "global"))` to find Cloud
     *   resources which contain "Important" as a word in any of the searchable
     *   fields and are also located in the "us-west1" region or the "global"
     *   location.
     * See [how to construct a
     * query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
     * for more details.
     *
     * Generated from protobuf field <code>string query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

    /**
     * Optional. A list of asset types that this request searches for. If empty,
     * it will search all the [searchable asset
     * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
     *
     * Generated from protobuf field <code>repeated string asset_types = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAssetTypes()
    {
        return $this->asset_types;
    }

    /**
     * Optional. A list of asset types that this request searches for. If empty,
     * it will search all the [searchable asset
     * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
     *
     * Generated from protobuf field <code>repeated string asset_types = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAssetTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->asset_types = $arr;

        return $this;
    }

    /**
     * Optional. The page size for search result pagination. Page size is capped
     * at 500 even if a larger value is given. If set to zero, server will pick an
     * appropriate default. Returned results may be fewer than requested. When
     * this happens, there could be more results as long as `next_page_token` is
     * returned.
     *
     * Generated from protobuf field <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Optional. The page size for search result pagination. Page size is capped
     * at 500 even if a larger value is given. If set to zero, server will pick an
     * appropriate default. Returned results may be fewer than requested. When
     * this happens, there could be more results as long as `next_page_token` is
     * returned.
     *
     * Generated from protobuf field <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * Optional. If present, then retrieve the next batch of results from the
     * preceding call to this method. `page_token` must be the value of
     * `next_page_token` from the previous response. The values of all other
     * method parameters, must be identical to those in the previous call.
     *
     * Generated from protobuf field <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * Optional. If present, then retrieve the next batch of results from the
     * preceding call to this method. `page_token` must be the value of
     * `next_page_token` from the previous response. The values of all other
     * method parameters, must be identical to those in the previous call.
     *
     * Generated from protobuf field <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * Optional. A comma separated list of fields specifying the sorting order of
     * the results. The default order is ascending. Add " DESC" after the field
     * name to indicate descending order. Redundant space characters are ignored.
     * Example: "location DESC, name". See [supported resource metadata
     * fields](https://cloud.google.com/asset-inventory/docs/searching-resources#query_on_resource_metadata_fields)
     * for more details.
     *
     * Generated from protobuf field <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getOrderBy()
    {
        return $this->order_by;
    }

    /**
     * Optional. A comma separated list of fields specifying the sorting order of
     * the results. The default order is ascending. Add " DESC" after the field
     * name to indicate descending order. Redundant space characters are ignored.
     * Example: "location DESC, name". See [supported resource metadata
     * fields](https://cloud.google.com/asset-inventory/docs/searching-resources#query_on_resource_metadata_fields)
     * for more details.
     *
     * Generated from protobuf field <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setOrderBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->order_by = $var;

        return $this;
    }

}

