<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/scheduler/v1beta1/target.proto

namespace Google\Cloud\Scheduler\V1beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * App Engine target. The job will be pushed to a job handler by means
 * of an HTTP request via an [http_method][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.http_method] such
 * as HTTP POST, HTTP GET, etc. The job is acknowledged by means of an
 * HTTP response code in the range [200 - 299]. Error 503 is
 * considered an App Engine system error instead of an application
 * error. Requests returning error 503 will be retried regardless of
 * retry configuration and not counted against retry counts. Any other
 * response code, or a failure to receive a response before the
 * deadline, constitutes a failed attempt.
 *
 * Generated from protobuf message <code>google.cloud.scheduler.v1beta1.AppEngineHttpTarget</code>
 */
class AppEngineHttpTarget extends \Google\Protobuf\Internal\Message
{
    /**
     * The HTTP method to use for the request. PATCH and OPTIONS are not
     * permitted.
     *
     * Generated from protobuf field <code>.google.cloud.scheduler.v1beta1.HttpMethod http_method = 1;</code>
     */
    private $http_method = 0;
    /**
     * App Engine Routing setting for the job.
     *
     * Generated from protobuf field <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
     */
    private $app_engine_routing = null;
    /**
     * The relative URI.
     * The relative URL must begin with "/" and must be a valid HTTP relative URL.
     * It can contain a path, query string arguments, and `#` fragments.
     * If the relative URL is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     *
     * Generated from protobuf field <code>string relative_uri = 3;</code>
     */
    private $relative_uri = '';
    /**
     * HTTP request headers.
     * This map contains the header field names and values. Headers can be set
     * when the job is created.
     * Cloud Scheduler sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Scheduler will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * * `X-CloudScheduler`: This header will be set to true.
     * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
     * the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explictly
     *   setting `Content-Type` to a particular media type when the job is
     *   created.
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Scheduler. This value is
     *   output only. It cannot be changed.
     * The headers below are output only. They cannot be set or overridden:
     * * `X-Google-*`: For Google internal use only.
     * * `X-AppEngine-*`: For Google internal use only.
     * In addition, some App Engine headers, which contain
     * job-specific information, are also be sent to the job handler.
     *
     * Generated from protobuf field <code>map<string, string> headers = 4;</code>
     */
    private $headers;
    /**
     * Body.
     * HTTP request body. A request body is allowed only if the HTTP method is
     * POST or PUT. It will result in invalid argument error to set a body on a
     * job with an incompatible [HttpMethod][google.cloud.scheduler.v1beta1.HttpMethod].
     *
     * Generated from protobuf field <code>bytes body = 5;</code>
     */
    private $body = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $http_method
     *           The HTTP method to use for the request. PATCH and OPTIONS are not
     *           permitted.
     *     @type \Google\Cloud\Scheduler\V1beta1\AppEngineRouting $app_engine_routing
     *           App Engine Routing setting for the job.
     *     @type string $relative_uri
     *           The relative URI.
     *           The relative URL must begin with "/" and must be a valid HTTP relative URL.
     *           It can contain a path, query string arguments, and `#` fragments.
     *           If the relative URL is empty, then the root path "/" will be used.
     *           No spaces are allowed, and the maximum length allowed is 2083 characters.
     *     @type array|\Google\Protobuf\Internal\MapField $headers
     *           HTTP request headers.
     *           This map contains the header field names and values. Headers can be set
     *           when the job is created.
     *           Cloud Scheduler sets some headers to default values:
     *           * `User-Agent`: By default, this header is
     *             `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *             This header can be modified, but Cloud Scheduler will append
     *             `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *             modified `User-Agent`.
     *           * `X-CloudScheduler`: This header will be set to true.
     *           If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
     *           the following headers:
     *           * `Content-Type`: By default, the `Content-Type` header is set to
     *             `"application/octet-stream"`. The default can be overridden by explictly
     *             setting `Content-Type` to a particular media type when the job is
     *             created.
     *             For example, `Content-Type` can be set to `"application/json"`.
     *           * `Content-Length`: This is computed by Cloud Scheduler. This value is
     *             output only. It cannot be changed.
     *           The headers below are output only. They cannot be set or overridden:
     *           * `X-Google-*`: For Google internal use only.
     *           * `X-AppEngine-*`: For Google internal use only.
     *           In addition, some App Engine headers, which contain
     *           job-specific information, are also be sent to the job handler.
     *     @type string $body
     *           Body.
     *           HTTP request body. A request body is allowed only if the HTTP method is
     *           POST or PUT. It will result in invalid argument error to set a body on a
     *           job with an incompatible [HttpMethod][google.cloud.scheduler.v1beta1.HttpMethod].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Scheduler\V1Beta1\Target::initOnce();
        parent::__construct($data);
    }

    /**
     * The HTTP method to use for the request. PATCH and OPTIONS are not
     * permitted.
     *
     * Generated from protobuf field <code>.google.cloud.scheduler.v1beta1.HttpMethod http_method = 1;</code>
     * @return int
     */
    public function getHttpMethod()
    {
        return $this->http_method;
    }

    /**
     * The HTTP method to use for the request. PATCH and OPTIONS are not
     * permitted.
     *
     * Generated from protobuf field <code>.google.cloud.scheduler.v1beta1.HttpMethod http_method = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setHttpMethod($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Scheduler\V1beta1\HttpMethod::class);
        $this->http_method = $var;

        return $this;
    }

    /**
     * App Engine Routing setting for the job.
     *
     * Generated from protobuf field <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
     * @return \Google\Cloud\Scheduler\V1beta1\AppEngineRouting|null
     */
    public function getAppEngineRouting()
    {
        return $this->app_engine_routing;
    }

    public function hasAppEngineRouting()
    {
        return isset($this->app_engine_routing);
    }

    public function clearAppEngineRouting()
    {
        unset($this->app_engine_routing);
    }

    /**
     * App Engine Routing setting for the job.
     *
     * Generated from protobuf field <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
     * @param \Google\Cloud\Scheduler\V1beta1\AppEngineRouting $var
     * @return $this
     */
    public function setAppEngineRouting($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Scheduler\V1beta1\AppEngineRouting::class);
        $this->app_engine_routing = $var;

        return $this;
    }

    /**
     * The relative URI.
     * The relative URL must begin with "/" and must be a valid HTTP relative URL.
     * It can contain a path, query string arguments, and `#` fragments.
     * If the relative URL is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     *
     * Generated from protobuf field <code>string relative_uri = 3;</code>
     * @return string
     */
    public function getRelativeUri()
    {
        return $this->relative_uri;
    }

    /**
     * The relative URI.
     * The relative URL must begin with "/" and must be a valid HTTP relative URL.
     * It can contain a path, query string arguments, and `#` fragments.
     * If the relative URL is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     *
     * Generated from protobuf field <code>string relative_uri = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setRelativeUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->relative_uri = $var;

        return $this;
    }

    /**
     * HTTP request headers.
     * This map contains the header field names and values. Headers can be set
     * when the job is created.
     * Cloud Scheduler sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Scheduler will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * * `X-CloudScheduler`: This header will be set to true.
     * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
     * the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explictly
     *   setting `Content-Type` to a particular media type when the job is
     *   created.
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Scheduler. This value is
     *   output only. It cannot be changed.
     * The headers below are output only. They cannot be set or overridden:
     * * `X-Google-*`: For Google internal use only.
     * * `X-AppEngine-*`: For Google internal use only.
     * In addition, some App Engine headers, which contain
     * job-specific information, are also be sent to the job handler.
     *
     * Generated from protobuf field <code>map<string, string> headers = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getHeaders()
    {
        return $this->headers;
    }

    /**
     * HTTP request headers.
     * This map contains the header field names and values. Headers can be set
     * when the job is created.
     * Cloud Scheduler sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Scheduler will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * * `X-CloudScheduler`: This header will be set to true.
     * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
     * the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explictly
     *   setting `Content-Type` to a particular media type when the job is
     *   created.
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Scheduler. This value is
     *   output only. It cannot be changed.
     * The headers below are output only. They cannot be set or overridden:
     * * `X-Google-*`: For Google internal use only.
     * * `X-AppEngine-*`: For Google internal use only.
     * In addition, some App Engine headers, which contain
     * job-specific information, are also be sent to the job handler.
     *
     * Generated from protobuf field <code>map<string, string> headers = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setHeaders($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->headers = $arr;

        return $this;
    }

    /**
     * Body.
     * HTTP request body. A request body is allowed only if the HTTP method is
     * POST or PUT. It will result in invalid argument error to set a body on a
     * job with an incompatible [HttpMethod][google.cloud.scheduler.v1beta1.HttpMethod].
     *
     * Generated from protobuf field <code>bytes body = 5;</code>
     * @return string
     */
    public function getBody()
    {
        return $this->body;
    }

    /**
     * Body.
     * HTTP request body. A request body is allowed only if the HTTP method is
     * POST or PUT. It will result in invalid argument error to set a body on a
     * job with an incompatible [HttpMethod][google.cloud.scheduler.v1beta1.HttpMethod].
     *
     * Generated from protobuf field <code>bytes body = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setBody($var)
    {
        GPBUtil::checkString($var, False);
        $this->body = $var;

        return $this;
    }

}

