<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/gkemulticloud/v1/aws_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\GkeMultiCloud\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\GkeMultiCloud\V1\AwsCluster;
use Google\Cloud\GkeMultiCloud\V1\AwsNodePool;
use Google\Cloud\GkeMultiCloud\V1\AwsServerConfig;
use Google\Cloud\GkeMultiCloud\V1\CreateAwsClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\CreateAwsNodePoolRequest;
use Google\Cloud\GkeMultiCloud\V1\DeleteAwsClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\DeleteAwsNodePoolRequest;
use Google\Cloud\GkeMultiCloud\V1\GenerateAwsAccessTokenRequest;
use Google\Cloud\GkeMultiCloud\V1\GenerateAwsAccessTokenResponse;
use Google\Cloud\GkeMultiCloud\V1\GetAwsClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\GetAwsNodePoolRequest;
use Google\Cloud\GkeMultiCloud\V1\GetAwsServerConfigRequest;
use Google\Cloud\GkeMultiCloud\V1\ListAwsClustersRequest;
use Google\Cloud\GkeMultiCloud\V1\ListAwsClustersResponse;
use Google\Cloud\GkeMultiCloud\V1\ListAwsNodePoolsRequest;
use Google\Cloud\GkeMultiCloud\V1\ListAwsNodePoolsResponse;
use Google\Cloud\GkeMultiCloud\V1\UpdateAwsClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\UpdateAwsNodePoolRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: The AwsClusters API provides a single centrally managed service
 * to create and manage Anthos clusters that run on AWS infrastructure.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $awsClustersClient = new AwsClustersClient();
 * try {
 *     $formattedParent = $awsClustersClient->locationName('[PROJECT]', '[LOCATION]');
 *     $awsCluster = new AwsCluster();
 *     $awsClusterId = 'aws_cluster_id';
 *     $operationResponse = $awsClustersClient->createAwsCluster($formattedParent, $awsCluster, $awsClusterId);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $awsClustersClient->createAwsCluster($formattedParent, $awsCluster, $awsClusterId);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $awsClustersClient->resumeOperation($operationName, 'createAwsCluster');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $awsClustersClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class AwsClustersGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.gkemulticloud.v1.AwsClusters';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'gkemulticloud.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $awsClusterNameTemplate;

    private static $awsNodePoolNameTemplate;

    private static $awsServerConfigNameTemplate;

    private static $locationNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/aws_clusters_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/aws_clusters_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/aws_clusters_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/aws_clusters_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAwsClusterNameTemplate()
    {
        if (self::$awsClusterNameTemplate == null) {
            self::$awsClusterNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/awsClusters/{aws_cluster}'
            );
        }

        return self::$awsClusterNameTemplate;
    }

    private static function getAwsNodePoolNameTemplate()
    {
        if (self::$awsNodePoolNameTemplate == null) {
            self::$awsNodePoolNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/awsClusters/{aws_cluster}/awsNodePools/{aws_node_pool}'
            );
        }

        return self::$awsNodePoolNameTemplate;
    }

    private static function getAwsServerConfigNameTemplate()
    {
        if (self::$awsServerConfigNameTemplate == null) {
            self::$awsServerConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/awsServerConfig'
            );
        }

        return self::$awsServerConfigNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'awsCluster' => self::getAwsClusterNameTemplate(),
                'awsNodePool' => self::getAwsNodePoolNameTemplate(),
                'awsServerConfig' => self::getAwsServerConfigNameTemplate(),
                'location' => self::getLocationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a aws_cluster
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $awsCluster
     *
     * @return string The formatted aws_cluster resource.
     */
    public static function awsClusterName($project, $location, $awsCluster)
    {
        return self::getAwsClusterNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'aws_cluster' => $awsCluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * aws_node_pool resource.
     *
     * @param string $project
     * @param string $location
     * @param string $awsCluster
     * @param string $awsNodePool
     *
     * @return string The formatted aws_node_pool resource.
     */
    public static function awsNodePoolName(
        $project,
        $location,
        $awsCluster,
        $awsNodePool
    ) {
        return self::getAwsNodePoolNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'aws_cluster' => $awsCluster,
            'aws_node_pool' => $awsNodePool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * aws_server_config resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted aws_server_config resource.
     */
    public static function awsServerConfigName($project, $location)
    {
        return self::getAwsServerConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - awsCluster: projects/{project}/locations/{location}/awsClusters/{aws_cluster}
     * - awsNodePool: projects/{project}/locations/{location}/awsClusters/{aws_cluster}/awsNodePools/{aws_node_pool}
     * - awsServerConfig: projects/{project}/locations/{location}/awsServerConfig
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'gkemulticloud.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource on a given GCP project and region.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $awsClustersClient = new AwsClustersClient();
     * try {
     *     $formattedParent = $awsClustersClient->locationName('[PROJECT]', '[LOCATION]');
     *     $awsCluster = new AwsCluster();
     *     $awsClusterId = 'aws_cluster_id';
     *     $operationResponse = $awsClustersClient->createAwsCluster($formattedParent, $awsCluster, $awsClusterId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $awsClustersClient->createAwsCluster($formattedParent, $awsCluster, $awsClusterId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $awsClustersClient->resumeOperation($operationName, 'createAwsCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $awsClustersClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The parent location where this [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource
     *                                 will be created.
     *
     *                                 Location names are formatted as `projects/<project-id>/locations/<region>`.
     *
     *                                 See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                                 for more details on Google Cloud resource names.
     * @param AwsCluster $awsCluster   Required. The specification of the [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] to create.
     * @param string     $awsClusterId Required. A client provided ID the resource. Must be unique within the parent
     *                                 resource.
     *
     *                                 The provided ID will be part of the [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
     *                                 resource name formatted as
     *                                 `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
     *
     *                                 Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 40 characters.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually create the cluster.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAwsCluster(
        $parent,
        $awsCluster,
        $awsClusterId,
        array $optionalArgs = []
    ) {
        $request = new CreateAwsClusterRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAwsCluster($awsCluster);
        $request->setAwsClusterId($awsClusterId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateAwsCluster',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool], attached to a given [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $awsClustersClient = new AwsClustersClient();
     * try {
     *     $formattedParent = $awsClustersClient->awsClusterName('[PROJECT]', '[LOCATION]', '[AWS_CLUSTER]');
     *     $awsNodePool = new AwsNodePool();
     *     $awsNodePoolId = 'aws_node_pool_id';
     *     $operationResponse = $awsClustersClient->createAwsNodePool($formattedParent, $awsNodePool, $awsNodePoolId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $awsClustersClient->createAwsNodePool($formattedParent, $awsNodePool, $awsNodePoolId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $awsClustersClient->resumeOperation($operationName, 'createAwsNodePool');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $awsClustersClient->close();
     * }
     * ```
     *
     * @param string      $parent        Required. The [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource where this node pool will be created.
     *
     *                                   `AwsCluster` names are formatted as
     *                                   `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
     *
     *                                   See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                                   for more details on Google Cloud resource names.
     * @param AwsNodePool $awsNodePool   Required. The specification of the [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] to create.
     * @param string      $awsNodePoolId Required. A client provided ID the resource. Must be unique within the parent
     *                                   resource.
     *
     *                                   The provided ID will be part of the [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
     *                                   resource name formatted as
     *                                   `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
     *
     *                                   Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 40 characters.
     * @param array       $optionalArgs  {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually create the node
     *           pool.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAwsNodePool(
        $parent,
        $awsNodePool,
        $awsNodePoolId,
        array $optionalArgs = []
    ) {
        $request = new CreateAwsNodePoolRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAwsNodePool($awsNodePool);
        $request->setAwsNodePoolId($awsNodePoolId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateAwsNodePool',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource.
     *
     * Fails if the cluster has one or more associated [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
     * resources.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $awsClustersClient = new AwsClustersClient();
     * try {
     *     $formattedName = $awsClustersClient->awsClusterName('[PROJECT]', '[LOCATION]', '[AWS_CLUSTER]');
     *     $operationResponse = $awsClustersClient->deleteAwsCluster($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $awsClustersClient->deleteAwsCluster($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $awsClustersClient->resumeOperation($operationName, 'deleteAwsCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $awsClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name the [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] to delete.
     *
     *                             `AwsCluster` names are formatted as
     *                             `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on GCP resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually delete the resource.
     *     @type bool $allowMissing
     *           If set to true, and the [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource is not found,
     *           the request will succeed but no action will be taken on the server and a
     *           completed [Operation][google.longrunning.Operation] will be returned.
     *
     *           Useful for idempotent deletion.
     *     @type string $etag
     *           The current etag of the [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
     *
     *           Allows clients to perform deletions through optimistic concurrency control.
     *
     *           If the provided etag does not match the current etag of the cluster,
     *           the request will fail and an ABORTED error will be returned.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAwsCluster($name, array $optionalArgs = [])
    {
        $request = new DeleteAwsClusterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteAwsCluster',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a specific [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $awsClustersClient = new AwsClustersClient();
     * try {
     *     $formattedName = $awsClustersClient->awsNodePoolName('[PROJECT]', '[LOCATION]', '[AWS_CLUSTER]', '[AWS_NODE_POOL]');
     *     $operationResponse = $awsClustersClient->deleteAwsNodePool($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $awsClustersClient->deleteAwsNodePool($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $awsClustersClient->resumeOperation($operationName, 'deleteAwsNodePool');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $awsClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name the [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] to delete.
     *
     *                             `AwsNodePool` names are formatted as
     *                             `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually delete the node
     *           pool.
     *     @type bool $allowMissing
     *           If set to true, and the [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource is not found,
     *           the request will succeed but no action will be taken on the server and a
     *           completed [Operation][google.longrunning.Operation] will be returned.
     *
     *           Useful for idempotent deletion.
     *     @type string $etag
     *           The current ETag of the [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool].
     *
     *           Allows clients to perform deletions through optimistic concurrency control.
     *
     *           If the provided ETag does not match the current etag of the node pool,
     *           the request will fail and an ABORTED error will be returned.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAwsNodePool($name, array $optionalArgs = [])
    {
        $request = new DeleteAwsNodePoolRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteAwsNodePool',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Generates a short-lived access token to authenticate to a given
     * [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource.
     *
     * Sample code:
     * ```
     * $awsClustersClient = new AwsClustersClient();
     * try {
     *     $formattedAwsCluster = $awsClustersClient->awsClusterName('[PROJECT]', '[LOCATION]', '[AWS_CLUSTER]');
     *     $response = $awsClustersClient->generateAwsAccessToken($formattedAwsCluster);
     * } finally {
     *     $awsClustersClient->close();
     * }
     * ```
     *
     * @param string $awsCluster   Required. The name of the [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource to authenticate to.
     *
     *                             `AwsCluster` names are formatted as
     *                             `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeMultiCloud\V1\GenerateAwsAccessTokenResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function generateAwsAccessToken(
        $awsCluster,
        array $optionalArgs = []
    ) {
        $request = new GenerateAwsAccessTokenRequest();
        $requestParamHeaders = [];
        $request->setAwsCluster($awsCluster);
        $requestParamHeaders['aws_cluster'] = $awsCluster;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GenerateAwsAccessToken',
            GenerateAwsAccessTokenResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Describes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource.
     *
     * Sample code:
     * ```
     * $awsClustersClient = new AwsClustersClient();
     * try {
     *     $formattedName = $awsClustersClient->awsClusterName('[PROJECT]', '[LOCATION]', '[AWS_CLUSTER]');
     *     $response = $awsClustersClient->getAwsCluster($formattedName);
     * } finally {
     *     $awsClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource to describe.
     *
     *                             `AwsCluster` names are formatted as
     *                             `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on GCP resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeMultiCloud\V1\AwsCluster
     *
     * @throws ApiException if the remote call fails
     */
    public function getAwsCluster($name, array $optionalArgs = [])
    {
        $request = new GetAwsClusterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAwsCluster',
            AwsCluster::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Describes a specific [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource.
     *
     * Sample code:
     * ```
     * $awsClustersClient = new AwsClustersClient();
     * try {
     *     $formattedName = $awsClustersClient->awsNodePoolName('[PROJECT]', '[LOCATION]', '[AWS_CLUSTER]', '[AWS_NODE_POOL]');
     *     $response = $awsClustersClient->getAwsNodePool($formattedName);
     * } finally {
     *     $awsClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource to describe.
     *
     *                             `AwsNodePool` names are formatted as
     *                             `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeMultiCloud\V1\AwsNodePool
     *
     * @throws ApiException if the remote call fails
     */
    public function getAwsNodePool($name, array $optionalArgs = [])
    {
        $request = new GetAwsNodePoolRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAwsNodePool',
            AwsNodePool::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns information, such as supported AWS regions and Kubernetes
     * versions, on a given Google Cloud location.
     *
     * Sample code:
     * ```
     * $awsClustersClient = new AwsClustersClient();
     * try {
     *     $formattedName = $awsClustersClient->awsServerConfigName('[PROJECT]', '[LOCATION]');
     *     $response = $awsClustersClient->getAwsServerConfig($formattedName);
     * } finally {
     *     $awsClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the [AwsServerConfig][google.cloud.gkemulticloud.v1.AwsServerConfig] resource to describe.
     *
     *                             `AwsServerConfig` names are formatted as
     *                             `projects/<project-id>/locations/<region>/awsServerConfig`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeMultiCloud\V1\AwsServerConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getAwsServerConfig($name, array $optionalArgs = [])
    {
        $request = new GetAwsServerConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAwsServerConfig',
            AwsServerConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists all [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resources on a given Google Cloud project and
     * region.
     *
     * Sample code:
     * ```
     * $awsClustersClient = new AwsClustersClient();
     * try {
     *     $formattedParent = $awsClustersClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $awsClustersClient->listAwsClusters($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $awsClustersClient->listAwsClusters($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $awsClustersClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent location which owns this collection of
     *                             [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resources.
     *
     *                             Location names are formatted as `projects/<project-id>/locations/<region>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on GCP resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAwsClusters($parent, array $optionalArgs = [])
    {
        $request = new ListAwsClustersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListAwsClusters',
            $optionalArgs,
            ListAwsClustersResponse::class,
            $request
        );
    }

    /**
     * Lists all [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resources on a given [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
     *
     * Sample code:
     * ```
     * $awsClustersClient = new AwsClustersClient();
     * try {
     *     $formattedParent = $awsClustersClient->awsClusterName('[PROJECT]', '[LOCATION]', '[AWS_CLUSTER]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $awsClustersClient->listAwsNodePools($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $awsClustersClient->listAwsNodePools($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $awsClustersClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent `AwsCluster` which owns this collection of
     *                             [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resources.
     *
     *                             `AwsCluster` names are formatted as
     *                             `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAwsNodePools($parent, array $optionalArgs = [])
    {
        $request = new ListAwsNodePoolsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListAwsNodePools',
            $optionalArgs,
            ListAwsNodePoolsResponse::class,
            $request
        );
    }

    /**
     * Updates an [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
     *
     * Sample code:
     * ```
     * $awsClustersClient = new AwsClustersClient();
     * try {
     *     $awsCluster = new AwsCluster();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $awsClustersClient->updateAwsCluster($awsCluster, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $awsClustersClient->updateAwsCluster($awsCluster, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $awsClustersClient->resumeOperation($operationName, 'updateAwsCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $awsClustersClient->close();
     * }
     * ```
     *
     * @param AwsCluster $awsCluster   Required. The [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource to update.
     * @param FieldMask  $updateMask   Required. Mask of fields to update. At least one path must be supplied in
     *                                 this field. The elements of the repeated paths field can only include these
     *                                 fields from [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]:
     *
     *                                 *   `description`.
     *                                 *   `annotations`.
     *                                 *   `control_plane.version`.
     *                                 *   `authorization.admin_users`.
     *                                 *   `control_plane.aws_services_authentication.role_arn`.
     *                                 *   `control_plane.aws_services_authentication.role_session_name`.
     *                                 *   `control_plane.config_encryption.kms_key_arn`.
     *                                 *   `control_plane.instance_type`.
     *                                 *   `control_plane.security_group_ids`.
     *                                 *   `control_plane.proxy_config`.
     *                                 *   `control_plane.proxy_config.secret_arn`.
     *                                 *   `control_plane.proxy_config.secret_version`.
     *                                 *   `control_plane.root_volume.iops`.
     *                                 *   `control_plane.root_volume.kms_key_arn`.
     *                                 *   `control_plane.root_volume.volume_type`.
     *                                 *   `control_plane.root_volume.size_gib`.
     *                                 *   `control_plane.ssh_config`.
     *                                 *   `control_plane.ssh_config.ec2_key_pair`.
     *                                 *   `control_plane.instance_placement.tenancy`.
     *                                 *   `logging_config`.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually update the cluster.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAwsCluster(
        $awsCluster,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateAwsClusterRequest();
        $requestParamHeaders = [];
        $request->setAwsCluster($awsCluster);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['aws_cluster.name'] = $awsCluster->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateAwsCluster',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates an [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool].
     *
     * Sample code:
     * ```
     * $awsClustersClient = new AwsClustersClient();
     * try {
     *     $awsNodePool = new AwsNodePool();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $awsClustersClient->updateAwsNodePool($awsNodePool, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $awsClustersClient->updateAwsNodePool($awsNodePool, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $awsClustersClient->resumeOperation($operationName, 'updateAwsNodePool');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $awsClustersClient->close();
     * }
     * ```
     *
     * @param AwsNodePool $awsNodePool  Required. The [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource to update.
     * @param FieldMask   $updateMask   Required. Mask of fields to update. At least one path must be supplied in
     *                                  this field. The elements of the repeated paths field can only include these
     *                                  fields from [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]:
     *
     *                                  *   `annotations`.
     *                                  *   `version`.
     *                                  *   `autoscaling.min_node_count`.
     *                                  *   `autoscaling.max_node_count`.
     *                                  *   `config.config_encryption.kms_key_arn`.
     *                                  *   `config.security_group_ids`.
     *                                  *   `config.root_volume.iops`.
     *                                  *   `config.root_volume.kms_key_arn`.
     *                                  *   `config.root_volume.volume_type`.
     *                                  *   `config.root_volume.size_gib`.
     *                                  *   `config.proxy_config`.
     *                                  *   `config.proxy_config.secret_arn`.
     *                                  *   `config.proxy_config.secret_version`.
     *                                  *   `config.ssh_config`.
     *                                  *   `config.ssh_config.ec2_key_pair`.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but don't actually update the node pool.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAwsNodePool(
        $awsNodePool,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateAwsNodePoolRequest();
        $requestParamHeaders = [];
        $request->setAwsNodePool($awsNodePool);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['aws_node_pool.name'] = $awsNodePool->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateAwsNodePool',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }
}
