<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/video/stitcher/v1/video_stitcher_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Video\Stitcher\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Video\Stitcher\V1\CdnKey;
use Google\Cloud\Video\Stitcher\V1\CreateCdnKeyRequest;
use Google\Cloud\Video\Stitcher\V1\CreateLiveConfigRequest;
use Google\Cloud\Video\Stitcher\V1\CreateLiveSessionRequest;
use Google\Cloud\Video\Stitcher\V1\CreateSlateRequest;
use Google\Cloud\Video\Stitcher\V1\CreateVodSessionRequest;
use Google\Cloud\Video\Stitcher\V1\DeleteCdnKeyRequest;
use Google\Cloud\Video\Stitcher\V1\DeleteLiveConfigRequest;
use Google\Cloud\Video\Stitcher\V1\DeleteSlateRequest;
use Google\Cloud\Video\Stitcher\V1\GetCdnKeyRequest;
use Google\Cloud\Video\Stitcher\V1\GetLiveAdTagDetailRequest;
use Google\Cloud\Video\Stitcher\V1\GetLiveConfigRequest;
use Google\Cloud\Video\Stitcher\V1\GetLiveSessionRequest;
use Google\Cloud\Video\Stitcher\V1\GetSlateRequest;
use Google\Cloud\Video\Stitcher\V1\GetVodAdTagDetailRequest;
use Google\Cloud\Video\Stitcher\V1\GetVodSessionRequest;
use Google\Cloud\Video\Stitcher\V1\GetVodStitchDetailRequest;
use Google\Cloud\Video\Stitcher\V1\ListCdnKeysRequest;
use Google\Cloud\Video\Stitcher\V1\ListCdnKeysResponse;
use Google\Cloud\Video\Stitcher\V1\ListLiveAdTagDetailsRequest;
use Google\Cloud\Video\Stitcher\V1\ListLiveAdTagDetailsResponse;
use Google\Cloud\Video\Stitcher\V1\ListLiveConfigsRequest;
use Google\Cloud\Video\Stitcher\V1\ListLiveConfigsResponse;
use Google\Cloud\Video\Stitcher\V1\ListSlatesRequest;
use Google\Cloud\Video\Stitcher\V1\ListSlatesResponse;
use Google\Cloud\Video\Stitcher\V1\ListVodAdTagDetailsRequest;
use Google\Cloud\Video\Stitcher\V1\ListVodAdTagDetailsResponse;
use Google\Cloud\Video\Stitcher\V1\ListVodStitchDetailsRequest;
use Google\Cloud\Video\Stitcher\V1\ListVodStitchDetailsResponse;
use Google\Cloud\Video\Stitcher\V1\LiveAdTagDetail;
use Google\Cloud\Video\Stitcher\V1\LiveConfig;
use Google\Cloud\Video\Stitcher\V1\LiveSession;
use Google\Cloud\Video\Stitcher\V1\Slate;
use Google\Cloud\Video\Stitcher\V1\UpdateCdnKeyRequest;
use Google\Cloud\Video\Stitcher\V1\UpdateSlateRequest;
use Google\Cloud\Video\Stitcher\V1\VodAdTagDetail;
use Google\Cloud\Video\Stitcher\V1\VodSession;
use Google\Cloud\Video\Stitcher\V1\VodStitchDetail;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Video-On-Demand content stitching API allows you to insert ads
 * into (VoD) video on demand files. You will be able to render custom
 * scrubber bars with highlighted ads, enforce ad policies, allow
 * seamless playback and tracking on native players and monetize
 * content with any standard VMAP compliant ad server.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $videoStitcherServiceClient = new VideoStitcherServiceClient();
 * try {
 *     $formattedParent = $videoStitcherServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $cdnKey = new CdnKey();
 *     $cdnKeyId = 'cdn_key_id';
 *     $operationResponse = $videoStitcherServiceClient->createCdnKey($formattedParent, $cdnKey, $cdnKeyId);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $videoStitcherServiceClient->createCdnKey($formattedParent, $cdnKey, $cdnKeyId);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $videoStitcherServiceClient->resumeOperation($operationName, 'createCdnKey');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $videoStitcherServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\Video\Stitcher\V1\Client\VideoStitcherServiceClient} to use the
 * new surface.
 */
class VideoStitcherServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.video.stitcher.v1.VideoStitcherService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'videostitcher.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $cdnKeyNameTemplate;

    private static $liveAdTagDetailNameTemplate;

    private static $liveConfigNameTemplate;

    private static $liveSessionNameTemplate;

    private static $locationNameTemplate;

    private static $slateNameTemplate;

    private static $vodAdTagDetailNameTemplate;

    private static $vodSessionNameTemplate;

    private static $vodStitchDetailNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/video_stitcher_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/video_stitcher_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/video_stitcher_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/video_stitcher_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getCdnKeyNameTemplate()
    {
        if (self::$cdnKeyNameTemplate == null) {
            self::$cdnKeyNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/cdnKeys/{cdn_key}'
            );
        }

        return self::$cdnKeyNameTemplate;
    }

    private static function getLiveAdTagDetailNameTemplate()
    {
        if (self::$liveAdTagDetailNameTemplate == null) {
            self::$liveAdTagDetailNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/liveSessions/{live_session}/liveAdTagDetails/{live_ad_tag_detail}'
            );
        }

        return self::$liveAdTagDetailNameTemplate;
    }

    private static function getLiveConfigNameTemplate()
    {
        if (self::$liveConfigNameTemplate == null) {
            self::$liveConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/liveConfigs/{live_config}'
            );
        }

        return self::$liveConfigNameTemplate;
    }

    private static function getLiveSessionNameTemplate()
    {
        if (self::$liveSessionNameTemplate == null) {
            self::$liveSessionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/liveSessions/{live_session}'
            );
        }

        return self::$liveSessionNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getSlateNameTemplate()
    {
        if (self::$slateNameTemplate == null) {
            self::$slateNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/slates/{slate}'
            );
        }

        return self::$slateNameTemplate;
    }

    private static function getVodAdTagDetailNameTemplate()
    {
        if (self::$vodAdTagDetailNameTemplate == null) {
            self::$vodAdTagDetailNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/vodSessions/{vod_session}/vodAdTagDetails/{vod_ad_tag_detail}'
            );
        }

        return self::$vodAdTagDetailNameTemplate;
    }

    private static function getVodSessionNameTemplate()
    {
        if (self::$vodSessionNameTemplate == null) {
            self::$vodSessionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/vodSessions/{vod_session}'
            );
        }

        return self::$vodSessionNameTemplate;
    }

    private static function getVodStitchDetailNameTemplate()
    {
        if (self::$vodStitchDetailNameTemplate == null) {
            self::$vodStitchDetailNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/vodSessions/{vod_session}/vodStitchDetails/{vod_stitch_detail}'
            );
        }

        return self::$vodStitchDetailNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'cdnKey' => self::getCdnKeyNameTemplate(),
                'liveAdTagDetail' => self::getLiveAdTagDetailNameTemplate(),
                'liveConfig' => self::getLiveConfigNameTemplate(),
                'liveSession' => self::getLiveSessionNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'slate' => self::getSlateNameTemplate(),
                'vodAdTagDetail' => self::getVodAdTagDetailNameTemplate(),
                'vodSession' => self::getVodSessionNameTemplate(),
                'vodStitchDetail' => self::getVodStitchDetailNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cdn_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cdnKey
     *
     * @return string The formatted cdn_key resource.
     */
    public static function cdnKeyName($project, $location, $cdnKey)
    {
        return self::getCdnKeyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'cdn_key' => $cdnKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * live_ad_tag_detail resource.
     *
     * @param string $project
     * @param string $location
     * @param string $liveSession
     * @param string $liveAdTagDetail
     *
     * @return string The formatted live_ad_tag_detail resource.
     */
    public static function liveAdTagDetailName(
        $project,
        $location,
        $liveSession,
        $liveAdTagDetail
    ) {
        return self::getLiveAdTagDetailNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'live_session' => $liveSession,
            'live_ad_tag_detail' => $liveAdTagDetail,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a live_config
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $liveConfig
     *
     * @return string The formatted live_config resource.
     */
    public static function liveConfigName($project, $location, $liveConfig)
    {
        return self::getLiveConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'live_config' => $liveConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a live_session
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $liveSession
     *
     * @return string The formatted live_session resource.
     */
    public static function liveSessionName($project, $location, $liveSession)
    {
        return self::getLiveSessionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'live_session' => $liveSession,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a slate
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $slate
     *
     * @return string The formatted slate resource.
     */
    public static function slateName($project, $location, $slate)
    {
        return self::getSlateNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'slate' => $slate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * vod_ad_tag_detail resource.
     *
     * @param string $project
     * @param string $location
     * @param string $vodSession
     * @param string $vodAdTagDetail
     *
     * @return string The formatted vod_ad_tag_detail resource.
     */
    public static function vodAdTagDetailName(
        $project,
        $location,
        $vodSession,
        $vodAdTagDetail
    ) {
        return self::getVodAdTagDetailNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'vod_session' => $vodSession,
            'vod_ad_tag_detail' => $vodAdTagDetail,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a vod_session
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $vodSession
     *
     * @return string The formatted vod_session resource.
     */
    public static function vodSessionName($project, $location, $vodSession)
    {
        return self::getVodSessionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'vod_session' => $vodSession,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * vod_stitch_detail resource.
     *
     * @param string $project
     * @param string $location
     * @param string $vodSession
     * @param string $vodStitchDetail
     *
     * @return string The formatted vod_stitch_detail resource.
     */
    public static function vodStitchDetailName(
        $project,
        $location,
        $vodSession,
        $vodStitchDetail
    ) {
        return self::getVodStitchDetailNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'vod_session' => $vodSession,
            'vod_stitch_detail' => $vodStitchDetail,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - cdnKey: projects/{project}/locations/{location}/cdnKeys/{cdn_key}
     * - liveAdTagDetail: projects/{project}/locations/{location}/liveSessions/{live_session}/liveAdTagDetails/{live_ad_tag_detail}
     * - liveConfig: projects/{project}/locations/{location}/liveConfigs/{live_config}
     * - liveSession: projects/{project}/locations/{location}/liveSessions/{live_session}
     * - location: projects/{project}/locations/{location}
     * - slate: projects/{project}/locations/{location}/slates/{slate}
     * - vodAdTagDetail: projects/{project}/locations/{location}/vodSessions/{vod_session}/vodAdTagDetails/{vod_ad_tag_detail}
     * - vodSession: projects/{project}/locations/{location}/vodSessions/{vod_session}
     * - vodStitchDetail: projects/{project}/locations/{location}/vodSessions/{vod_session}/vodStitchDetails/{vod_stitch_detail}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'videostitcher.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new CDN key.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedParent = $videoStitcherServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $cdnKey = new CdnKey();
     *     $cdnKeyId = 'cdn_key_id';
     *     $operationResponse = $videoStitcherServiceClient->createCdnKey($formattedParent, $cdnKey, $cdnKeyId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $videoStitcherServiceClient->createCdnKey($formattedParent, $cdnKey, $cdnKeyId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $videoStitcherServiceClient->resumeOperation($operationName, 'createCdnKey');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project in which the CDN key should be created, in the form
     *                             of `projects/{project_number}/locations/{location}`.
     * @param CdnKey $cdnKey       Required. The CDN key resource to create.
     * @param string $cdnKeyId     Required. The ID to use for the CDN key, which will become the final
     *                             component of the CDN key's resource name.
     *
     *                             This value should conform to RFC-1034, which restricts to
     *                             lower-case letters, numbers, and hyphen, with the first character a
     *                             letter, the last a letter or a number, and a 63 character maximum.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createCdnKey(
        $parent,
        $cdnKey,
        $cdnKeyId,
        array $optionalArgs = []
    ) {
        $request = new CreateCdnKeyRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCdnKey($cdnKey);
        $request->setCdnKeyId($cdnKeyId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateCdnKey',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Registers the live config with the provided unique ID in
     * the specified region.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedParent = $videoStitcherServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $liveConfigId = 'live_config_id';
     *     $liveConfig = new LiveConfig();
     *     $operationResponse = $videoStitcherServiceClient->createLiveConfig($formattedParent, $liveConfigId, $liveConfig);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $videoStitcherServiceClient->createLiveConfig($formattedParent, $liveConfigId, $liveConfig);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $videoStitcherServiceClient->resumeOperation($operationName, 'createLiveConfig');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The project in which the live config should be created, in
     *                                 the form of `projects/{project_number}/locations/{location}`.
     * @param string     $liveConfigId Required. The unique identifier ID to use for the live config.
     * @param LiveConfig $liveConfig   Required. The live config resource to create.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createLiveConfig(
        $parent,
        $liveConfigId,
        $liveConfig,
        array $optionalArgs = []
    ) {
        $request = new CreateLiveConfigRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setLiveConfigId($liveConfigId);
        $request->setLiveConfig($liveConfig);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateLiveConfig',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new live session.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedParent = $videoStitcherServiceClient->liveSessionName('[PROJECT]', '[LOCATION]', '[LIVE_SESSION]');
     *     $liveSession = new LiveSession();
     *     $response = $videoStitcherServiceClient->createLiveSession($formattedParent, $liveSession);
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string      $parent       Required. The project and location in which the live session should be
     *                                  created, in the form of `projects/{project_number}/locations/{location}`.
     * @param LiveSession $liveSession  Required. Parameters for creating a live session.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Stitcher\V1\LiveSession
     *
     * @throws ApiException if the remote call fails
     */
    public function createLiveSession(
        $parent,
        $liveSession,
        array $optionalArgs = []
    ) {
        $request = new CreateLiveSessionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setLiveSession($liveSession);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateLiveSession',
            LiveSession::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a slate.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedParent = $videoStitcherServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $slateId = 'slate_id';
     *     $slate = new Slate();
     *     $operationResponse = $videoStitcherServiceClient->createSlate($formattedParent, $slateId, $slate);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $videoStitcherServiceClient->createSlate($formattedParent, $slateId, $slate);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $videoStitcherServiceClient->resumeOperation($operationName, 'createSlate');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project in which the slate should be created, in the form of
     *                             `projects/{project_number}/locations/{location}`.
     * @param string $slateId      Required. The unique identifier for the slate.
     *                             This value should conform to RFC-1034, which restricts to
     *                             lower-case letters, numbers, and hyphen, with the first character a
     *                             letter, the last a letter or a number, and a 63 character maximum.
     * @param Slate  $slate        Required. The slate to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createSlate(
        $parent,
        $slateId,
        $slate,
        array $optionalArgs = []
    ) {
        $request = new CreateSlateRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSlateId($slateId);
        $request->setSlate($slate);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateSlate',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a client side playback VOD session and returns the full
     * tracking and playback metadata of the session.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedParent = $videoStitcherServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $vodSession = new VodSession();
     *     $response = $videoStitcherServiceClient->createVodSession($formattedParent, $vodSession);
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The project and location in which the VOD session should be
     *                                 created, in the form of `projects/{project_number}/locations/{location}`.
     * @param VodSession $vodSession   Required. Parameters for creating a session.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Stitcher\V1\VodSession
     *
     * @throws ApiException if the remote call fails
     */
    public function createVodSession(
        $parent,
        $vodSession,
        array $optionalArgs = []
    ) {
        $request = new CreateVodSessionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setVodSession($vodSession);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateVodSession',
            VodSession::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes the specified CDN key.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedName = $videoStitcherServiceClient->cdnKeyName('[PROJECT]', '[LOCATION]', '[CDN_KEY]');
     *     $operationResponse = $videoStitcherServiceClient->deleteCdnKey($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $videoStitcherServiceClient->deleteCdnKey($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $videoStitcherServiceClient->resumeOperation($operationName, 'deleteCdnKey');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the CDN key to be deleted, in the form of
     *                             `projects/{project_number}/locations/{location}/cdnKeys/{id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteCdnKey($name, array $optionalArgs = [])
    {
        $request = new DeleteCdnKeyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteCdnKey',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes the specified live config.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedName = $videoStitcherServiceClient->liveConfigName('[PROJECT]', '[LOCATION]', '[LIVE_CONFIG]');
     *     $operationResponse = $videoStitcherServiceClient->deleteLiveConfig($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $videoStitcherServiceClient->deleteLiveConfig($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $videoStitcherServiceClient->resumeOperation($operationName, 'deleteLiveConfig');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the live config to be deleted, in the form of
     *                             `projects/{project_number}/locations/{location}/liveConfigs/{id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteLiveConfig($name, array $optionalArgs = [])
    {
        $request = new DeleteLiveConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteLiveConfig',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes the specified slate.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedName = $videoStitcherServiceClient->slateName('[PROJECT]', '[LOCATION]', '[SLATE]');
     *     $operationResponse = $videoStitcherServiceClient->deleteSlate($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $videoStitcherServiceClient->deleteSlate($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $videoStitcherServiceClient->resumeOperation($operationName, 'deleteSlate');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the slate to be deleted, in the form of
     *                             `projects/{project_number}/locations/{location}/slates/{id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSlate($name, array $optionalArgs = [])
    {
        $request = new DeleteSlateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteSlate',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Returns the specified CDN key.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedName = $videoStitcherServiceClient->cdnKeyName('[PROJECT]', '[LOCATION]', '[CDN_KEY]');
     *     $response = $videoStitcherServiceClient->getCdnKey($formattedName);
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the CDN key to be retrieved, in the form of
     *                             `projects/{project}/locations/{location}/cdnKeys/{id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Stitcher\V1\CdnKey
     *
     * @throws ApiException if the remote call fails
     */
    public function getCdnKey($name, array $optionalArgs = [])
    {
        $request = new GetCdnKeyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetCdnKey',
            CdnKey::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the specified ad tag detail for the specified live session.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedName = $videoStitcherServiceClient->liveAdTagDetailName('[PROJECT]', '[LOCATION]', '[LIVE_SESSION]', '[LIVE_AD_TAG_DETAIL]');
     *     $response = $videoStitcherServiceClient->getLiveAdTagDetail($formattedName);
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name in the form of
     *                             `projects/{project}/locations/{location}/liveSessions/{live_session}/liveAdTagDetails/{live_ad_tag_detail}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Stitcher\V1\LiveAdTagDetail
     *
     * @throws ApiException if the remote call fails
     */
    public function getLiveAdTagDetail($name, array $optionalArgs = [])
    {
        $request = new GetLiveAdTagDetailRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLiveAdTagDetail',
            LiveAdTagDetail::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the specified live config managed by the Video
     * Stitcher service.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedName = $videoStitcherServiceClient->liveConfigName('[PROJECT]', '[LOCATION]', '[LIVE_CONFIG]');
     *     $response = $videoStitcherServiceClient->getLiveConfig($formattedName);
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the live config to be retrieved, in the form
     *                             of
     *                             `projects/{project_number}/locations/{location}/liveConfigs/{id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Stitcher\V1\LiveConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getLiveConfig($name, array $optionalArgs = [])
    {
        $request = new GetLiveConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLiveConfig',
            LiveConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the details for the specified live session.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedName = $videoStitcherServiceClient->liveSessionName('[PROJECT]', '[LOCATION]', '[LIVE_SESSION]');
     *     $response = $videoStitcherServiceClient->getLiveSession($formattedName);
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the live session, in the form of
     *                             `projects/{project_number}/locations/{location}/liveSessions/{id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Stitcher\V1\LiveSession
     *
     * @throws ApiException if the remote call fails
     */
    public function getLiveSession($name, array $optionalArgs = [])
    {
        $request = new GetLiveSessionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLiveSession',
            LiveSession::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the specified slate.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedName = $videoStitcherServiceClient->slateName('[PROJECT]', '[LOCATION]', '[SLATE]');
     *     $response = $videoStitcherServiceClient->getSlate($formattedName);
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the slate to be retrieved, of the slate, in the form
     *                             of `projects/{project_number}/locations/{location}/slates/{id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Stitcher\V1\Slate
     *
     * @throws ApiException if the remote call fails
     */
    public function getSlate($name, array $optionalArgs = [])
    {
        $request = new GetSlateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetSlate',
            Slate::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the specified ad tag detail for the specified VOD session.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedName = $videoStitcherServiceClient->vodAdTagDetailName('[PROJECT]', '[LOCATION]', '[VOD_SESSION]', '[VOD_AD_TAG_DETAIL]');
     *     $response = $videoStitcherServiceClient->getVodAdTagDetail($formattedName);
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the ad tag detail for the specified VOD session, in
     *                             the form of
     *                             `projects/{project}/locations/{location}/vodSessions/{vod_session_id}/vodAdTagDetails/{vod_ad_tag_detail}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Stitcher\V1\VodAdTagDetail
     *
     * @throws ApiException if the remote call fails
     */
    public function getVodAdTagDetail($name, array $optionalArgs = [])
    {
        $request = new GetVodAdTagDetailRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetVodAdTagDetail',
            VodAdTagDetail::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the full tracking, playback metadata, and relevant ad-ops
     * logs for the specified VOD session.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedName = $videoStitcherServiceClient->vodSessionName('[PROJECT]', '[LOCATION]', '[VOD_SESSION]');
     *     $response = $videoStitcherServiceClient->getVodSession($formattedName);
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the VOD session to be retrieved, in the form of
     *                             `projects/{project_number}/locations/{location}/vodSessions/{id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Stitcher\V1\VodSession
     *
     * @throws ApiException if the remote call fails
     */
    public function getVodSession($name, array $optionalArgs = [])
    {
        $request = new GetVodSessionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetVodSession',
            VodSession::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the specified stitching information for the specified VOD session.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedName = $videoStitcherServiceClient->vodStitchDetailName('[PROJECT]', '[LOCATION]', '[VOD_SESSION]', '[VOD_STITCH_DETAIL]');
     *     $response = $videoStitcherServiceClient->getVodStitchDetail($formattedName);
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the stitch detail in the specified VOD session, in
     *                             the form of
     *                             `projects/{project}/locations/{location}/vodSessions/{vod_session_id}/vodStitchDetails/{id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\Stitcher\V1\VodStitchDetail
     *
     * @throws ApiException if the remote call fails
     */
    public function getVodStitchDetail($name, array $optionalArgs = [])
    {
        $request = new GetVodStitchDetailRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetVodStitchDetail',
            VodStitchDetail::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists all CDN keys in the specified project and location.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedParent = $videoStitcherServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $videoStitcherServiceClient->listCdnKeys($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $videoStitcherServiceClient->listCdnKeys($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project that contains the list of CDN keys, in the form of
     *                             `projects/{project_number}/locations/{location}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results
     *     @type string $orderBy
     *           Hint for how to order the results
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listCdnKeys($parent, array $optionalArgs = [])
    {
        $request = new ListCdnKeysRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListCdnKeys',
            $optionalArgs,
            ListCdnKeysResponse::class,
            $request
        );
    }

    /**
     * Return the list of ad tag details for the specified live session.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedParent = $videoStitcherServiceClient->liveSessionName('[PROJECT]', '[LOCATION]', '[LIVE_SESSION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $videoStitcherServiceClient->listLiveAdTagDetails($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $videoStitcherServiceClient->listLiveAdTagDetails($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource parent in the form of
     *                             `projects/{project}/locations/{location}/liveSessions/{live_session}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLiveAdTagDetails($parent, array $optionalArgs = [])
    {
        $request = new ListLiveAdTagDetailsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLiveAdTagDetails',
            $optionalArgs,
            ListLiveAdTagDetailsResponse::class,
            $request
        );
    }

    /**
     * Lists all live configs managed by the Video Stitcher that
     * belong to the specified project and region.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedParent = $videoStitcherServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $videoStitcherServiceClient->listLiveConfigs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $videoStitcherServiceClient->listLiveConfigs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project that contains the list of live configs, in the
     *                             form of `projects/{project_number}/locations/{location}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. The filter to apply to list results (see
     *           [Filtering](https://google.aip.dev/160)).
     *     @type string $orderBy
     *           Optional. Specifies the ordering of results following
     *           [Cloud API
     *           syntax](https://cloud.google.com/apis/design/design_patterns#sorting_order).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLiveConfigs($parent, array $optionalArgs = [])
    {
        $request = new ListLiveConfigsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLiveConfigs',
            $optionalArgs,
            ListLiveConfigsResponse::class,
            $request
        );
    }

    /**
     * Lists all slates in the specified project and location.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedParent = $videoStitcherServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $videoStitcherServiceClient->listSlates($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $videoStitcherServiceClient->listSlates($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project to list slates, in the form of
     *                             `projects/{project_number}/locations/{location}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results
     *     @type string $orderBy
     *           Hint for how to order the results
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSlates($parent, array $optionalArgs = [])
    {
        $request = new ListSlatesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListSlates',
            $optionalArgs,
            ListSlatesResponse::class,
            $request
        );
    }

    /**
     * Return the list of ad tag details for the specified VOD session.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedParent = $videoStitcherServiceClient->vodSessionName('[PROJECT]', '[LOCATION]', '[VOD_SESSION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $videoStitcherServiceClient->listVodAdTagDetails($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $videoStitcherServiceClient->listVodAdTagDetails($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The VOD session which the ad tag details belong to, in the form
     *                             of `projects/{project}/locations/{location}/vodSessions/{vod_session_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listVodAdTagDetails($parent, array $optionalArgs = [])
    {
        $request = new ListVodAdTagDetailsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListVodAdTagDetails',
            $optionalArgs,
            ListVodAdTagDetailsResponse::class,
            $request
        );
    }

    /**
     * Returns a list of detailed stitching information of the specified VOD
     * session.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $formattedParent = $videoStitcherServiceClient->vodSessionName('[PROJECT]', '[LOCATION]', '[VOD_SESSION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $videoStitcherServiceClient->listVodStitchDetails($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $videoStitcherServiceClient->listVodStitchDetails($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The VOD session where the stitch details belong to, in the form
     *                             of `projects/{project}/locations/{location}/vodSessions/{id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listVodStitchDetails($parent, array $optionalArgs = [])
    {
        $request = new ListVodStitchDetailsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListVodStitchDetails',
            $optionalArgs,
            ListVodStitchDetailsResponse::class,
            $request
        );
    }

    /**
     * Updates the specified CDN key. Only update fields specified
     * in the call method body.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $cdnKey = new CdnKey();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $videoStitcherServiceClient->updateCdnKey($cdnKey, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $videoStitcherServiceClient->updateCdnKey($cdnKey, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $videoStitcherServiceClient->resumeOperation($operationName, 'updateCdnKey');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param CdnKey    $cdnKey       Required. The CDN key resource which replaces the resource on the server.
     * @param FieldMask $updateMask   Required. The update mask applies to the resource.
     *                                For the `FieldMask` definition, see
     *                                https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCdnKey($cdnKey, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateCdnKeyRequest();
        $requestParamHeaders = [];
        $request->setCdnKey($cdnKey);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['cdn_key.name'] = $cdnKey->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateCdnKey',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the specified slate.
     *
     * Sample code:
     * ```
     * $videoStitcherServiceClient = new VideoStitcherServiceClient();
     * try {
     *     $slate = new Slate();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $videoStitcherServiceClient->updateSlate($slate, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $videoStitcherServiceClient->updateSlate($slate, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $videoStitcherServiceClient->resumeOperation($operationName, 'updateSlate');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $videoStitcherServiceClient->close();
     * }
     * ```
     *
     * @param Slate     $slate        Required. The resource with updated fields.
     * @param FieldMask $updateMask   Required. The update mask which specifies fields which should be updated.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSlate($slate, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateSlateRequest();
        $requestParamHeaders = [];
        $request->setSlate($slate);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['slate.name'] = $slate->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateSlate',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }
}
