<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/tasks/v2beta3/target.proto

namespace Google\Cloud\Tasks\V2beta3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * HTTP target.
 * When specified as a [Queue][target_type], all the tasks with [HttpRequest]
 * will be overridden according to the target.
 *
 * Generated from protobuf message <code>google.cloud.tasks.v2beta3.HttpTarget</code>
 */
class HttpTarget extends \Google\Protobuf\Internal\Message
{
    /**
     * URI override.
     * When specified, overrides the execution URI for all the tasks in the queue.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.UriOverride uri_override = 1;</code>
     */
    private $uri_override = null;
    /**
     * The HTTP method to use for the request.
     * When specified, it overrides
     * [HttpRequest][google.cloud.tasks.v2beta3.HttpTarget.http_method] for the
     * task. Note that if the value is set to [HttpMethod][GET] the
     * [HttpRequest][body] of the task will be ignored at execution time.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 2;</code>
     */
    private $http_method = 0;
    /**
     * HTTP target headers.
     * This map contains the header field names and values.
     * Headers will be set when running the
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask] and/or
     * [BufferTask][google.cloud.tasks.v2beta3.CloudTasks.BufferTask].
     * These headers represent a subset of the headers that will be configured for
     * the task's HTTP request. Some HTTP request headers will be ignored or
     * replaced.
     * A partial list of headers that will be ignored or replaced is:
     * * Several predefined headers, prefixed with "X-CloudTasks-", can
     * be used to define properties of the task.
     * * Host: This will be computed by Cloud Tasks and derived from
     * [HttpRequest.url][google.cloud.tasks.v2beta3.Target.HttpRequest.url].
     * * Content-Length: This will be computed by Cloud Tasks.
     * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
     * `Content-Type` to a media type when the
     *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *  For example,`Content-Type` can be set to `"application/octet-stream"` or
     *  `"application/json"`. The default value is set to "application/json"`.
     * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
     * Headers which can have multiple values (according to RFC2616) can be
     * specified using comma-separated values.
     * The size of the headers must be less than 80KB.
     * Queue-level headers to override headers of all the tasks in the queue.
     *
     * Generated from protobuf field <code>repeated .google.cloud.tasks.v2beta3.HttpTarget.HeaderOverride header_overrides = 3;</code>
     */
    private $header_overrides;
    protected $authorization_header;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Tasks\V2beta3\UriOverride $uri_override
     *           URI override.
     *           When specified, overrides the execution URI for all the tasks in the queue.
     *     @type int $http_method
     *           The HTTP method to use for the request.
     *           When specified, it overrides
     *           [HttpRequest][google.cloud.tasks.v2beta3.HttpTarget.http_method] for the
     *           task. Note that if the value is set to [HttpMethod][GET] the
     *           [HttpRequest][body] of the task will be ignored at execution time.
     *     @type array<\Google\Cloud\Tasks\V2beta3\HttpTarget\HeaderOverride>|\Google\Protobuf\Internal\RepeatedField $header_overrides
     *           HTTP target headers.
     *           This map contains the header field names and values.
     *           Headers will be set when running the
     *           [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask] and/or
     *           [BufferTask][google.cloud.tasks.v2beta3.CloudTasks.BufferTask].
     *           These headers represent a subset of the headers that will be configured for
     *           the task's HTTP request. Some HTTP request headers will be ignored or
     *           replaced.
     *           A partial list of headers that will be ignored or replaced is:
     *           * Several predefined headers, prefixed with "X-CloudTasks-", can
     *           be used to define properties of the task.
     *           * Host: This will be computed by Cloud Tasks and derived from
     *           [HttpRequest.url][google.cloud.tasks.v2beta3.Target.HttpRequest.url].
     *           * Content-Length: This will be computed by Cloud Tasks.
     *           `Content-Type` won't be set by Cloud Tasks. You can explicitly set
     *           `Content-Type` to a media type when the
     *            [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *            For example,`Content-Type` can be set to `"application/octet-stream"` or
     *            `"application/json"`. The default value is set to "application/json"`.
     *           * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
     *           Headers which can have multiple values (according to RFC2616) can be
     *           specified using comma-separated values.
     *           The size of the headers must be less than 80KB.
     *           Queue-level headers to override headers of all the tasks in the queue.
     *     @type \Google\Cloud\Tasks\V2beta3\OAuthToken $oauth_token
     *           If specified, an
     *           [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     *           will be generated and attached as the `Authorization` header in the HTTP
     *           request.
     *           This type of authorization should generally only be used when calling
     *           Google APIs hosted on *.googleapis.com.
     *     @type \Google\Cloud\Tasks\V2beta3\OidcToken $oidc_token
     *           If specified, an
     *           [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     *           token will be generated and attached as an `Authorization` header in the
     *           HTTP request.
     *           This type of authorization can be used for many scenarios, including
     *           calling Cloud Run, or endpoints where you intend to validate the token
     *           yourself.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Tasks\V2Beta3\Target::initOnce();
        parent::__construct($data);
    }

    /**
     * URI override.
     * When specified, overrides the execution URI for all the tasks in the queue.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.UriOverride uri_override = 1;</code>
     * @return \Google\Cloud\Tasks\V2beta3\UriOverride|null
     */
    public function getUriOverride()
    {
        return $this->uri_override;
    }

    public function hasUriOverride()
    {
        return isset($this->uri_override);
    }

    public function clearUriOverride()
    {
        unset($this->uri_override);
    }

    /**
     * URI override.
     * When specified, overrides the execution URI for all the tasks in the queue.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.UriOverride uri_override = 1;</code>
     * @param \Google\Cloud\Tasks\V2beta3\UriOverride $var
     * @return $this
     */
    public function setUriOverride($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta3\UriOverride::class);
        $this->uri_override = $var;

        return $this;
    }

    /**
     * The HTTP method to use for the request.
     * When specified, it overrides
     * [HttpRequest][google.cloud.tasks.v2beta3.HttpTarget.http_method] for the
     * task. Note that if the value is set to [HttpMethod][GET] the
     * [HttpRequest][body] of the task will be ignored at execution time.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 2;</code>
     * @return int
     */
    public function getHttpMethod()
    {
        return $this->http_method;
    }

    /**
     * The HTTP method to use for the request.
     * When specified, it overrides
     * [HttpRequest][google.cloud.tasks.v2beta3.HttpTarget.http_method] for the
     * task. Note that if the value is set to [HttpMethod][GET] the
     * [HttpRequest][body] of the task will be ignored at execution time.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setHttpMethod($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Tasks\V2beta3\HttpMethod::class);
        $this->http_method = $var;

        return $this;
    }

    /**
     * HTTP target headers.
     * This map contains the header field names and values.
     * Headers will be set when running the
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask] and/or
     * [BufferTask][google.cloud.tasks.v2beta3.CloudTasks.BufferTask].
     * These headers represent a subset of the headers that will be configured for
     * the task's HTTP request. Some HTTP request headers will be ignored or
     * replaced.
     * A partial list of headers that will be ignored or replaced is:
     * * Several predefined headers, prefixed with "X-CloudTasks-", can
     * be used to define properties of the task.
     * * Host: This will be computed by Cloud Tasks and derived from
     * [HttpRequest.url][google.cloud.tasks.v2beta3.Target.HttpRequest.url].
     * * Content-Length: This will be computed by Cloud Tasks.
     * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
     * `Content-Type` to a media type when the
     *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *  For example,`Content-Type` can be set to `"application/octet-stream"` or
     *  `"application/json"`. The default value is set to "application/json"`.
     * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
     * Headers which can have multiple values (according to RFC2616) can be
     * specified using comma-separated values.
     * The size of the headers must be less than 80KB.
     * Queue-level headers to override headers of all the tasks in the queue.
     *
     * Generated from protobuf field <code>repeated .google.cloud.tasks.v2beta3.HttpTarget.HeaderOverride header_overrides = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHeaderOverrides()
    {
        return $this->header_overrides;
    }

    /**
     * HTTP target headers.
     * This map contains the header field names and values.
     * Headers will be set when running the
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask] and/or
     * [BufferTask][google.cloud.tasks.v2beta3.CloudTasks.BufferTask].
     * These headers represent a subset of the headers that will be configured for
     * the task's HTTP request. Some HTTP request headers will be ignored or
     * replaced.
     * A partial list of headers that will be ignored or replaced is:
     * * Several predefined headers, prefixed with "X-CloudTasks-", can
     * be used to define properties of the task.
     * * Host: This will be computed by Cloud Tasks and derived from
     * [HttpRequest.url][google.cloud.tasks.v2beta3.Target.HttpRequest.url].
     * * Content-Length: This will be computed by Cloud Tasks.
     * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
     * `Content-Type` to a media type when the
     *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *  For example,`Content-Type` can be set to `"application/octet-stream"` or
     *  `"application/json"`. The default value is set to "application/json"`.
     * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
     * Headers which can have multiple values (according to RFC2616) can be
     * specified using comma-separated values.
     * The size of the headers must be less than 80KB.
     * Queue-level headers to override headers of all the tasks in the queue.
     *
     * Generated from protobuf field <code>repeated .google.cloud.tasks.v2beta3.HttpTarget.HeaderOverride header_overrides = 3;</code>
     * @param array<\Google\Cloud\Tasks\V2beta3\HttpTarget\HeaderOverride>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHeaderOverrides($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Tasks\V2beta3\HttpTarget\HeaderOverride::class);
        $this->header_overrides = $arr;

        return $this;
    }

    /**
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as the `Authorization` header in the HTTP
     * request.
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
     * @return \Google\Cloud\Tasks\V2beta3\OAuthToken|null
     */
    public function getOauthToken()
    {
        return $this->readOneof(5);
    }

    public function hasOauthToken()
    {
        return $this->hasOneof(5);
    }

    /**
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as the `Authorization` header in the HTTP
     * request.
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
     * @param \Google\Cloud\Tasks\V2beta3\OAuthToken $var
     * @return $this
     */
    public function setOauthToken($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta3\OAuthToken::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
     * @return \Google\Cloud\Tasks\V2beta3\OidcToken|null
     */
    public function getOidcToken()
    {
        return $this->readOneof(6);
    }

    public function hasOidcToken()
    {
        return $this->hasOneof(6);
    }

    /**
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
     * @param \Google\Cloud\Tasks\V2beta3\OidcToken $var
     * @return $this
     */
    public function setOidcToken($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta3\OidcToken::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getAuthorizationHeader()
    {
        return $this->whichOneof("authorization_header");
    }

}

