<?php
/*
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/kms/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Kms\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Kms\V1\AsymmetricDecryptRequest;
use Google\Cloud\Kms\V1\AsymmetricDecryptResponse;
use Google\Cloud\Kms\V1\AsymmetricSignRequest;
use Google\Cloud\Kms\V1\AsymmetricSignResponse;
use Google\Cloud\Kms\V1\CreateCryptoKeyRequest;
use Google\Cloud\Kms\V1\CreateCryptoKeyVersionRequest;
use Google\Cloud\Kms\V1\CreateImportJobRequest;
use Google\Cloud\Kms\V1\CreateKeyRingRequest;
use Google\Cloud\Kms\V1\CryptoKey;
use Google\Cloud\Kms\V1\CryptoKeyVersion;
use Google\Cloud\Kms\V1\DecryptRequest;
use Google\Cloud\Kms\V1\DecryptResponse;
use Google\Cloud\Kms\V1\DestroyCryptoKeyVersionRequest;
use Google\Cloud\Kms\V1\EncryptRequest;
use Google\Cloud\Kms\V1\EncryptResponse;
use Google\Cloud\Kms\V1\GenerateRandomBytesRequest;
use Google\Cloud\Kms\V1\GenerateRandomBytesResponse;
use Google\Cloud\Kms\V1\GetCryptoKeyRequest;
use Google\Cloud\Kms\V1\GetCryptoKeyVersionRequest;
use Google\Cloud\Kms\V1\GetImportJobRequest;
use Google\Cloud\Kms\V1\GetKeyRingRequest;
use Google\Cloud\Kms\V1\GetPublicKeyRequest;
use Google\Cloud\Kms\V1\ImportCryptoKeyVersionRequest;
use Google\Cloud\Kms\V1\ImportJob;
use Google\Cloud\Kms\V1\KeyRing;
use Google\Cloud\Kms\V1\ListCryptoKeyVersionsRequest;
use Google\Cloud\Kms\V1\ListCryptoKeysRequest;
use Google\Cloud\Kms\V1\ListImportJobsRequest;
use Google\Cloud\Kms\V1\ListKeyRingsRequest;
use Google\Cloud\Kms\V1\MacSignRequest;
use Google\Cloud\Kms\V1\MacSignResponse;
use Google\Cloud\Kms\V1\MacVerifyRequest;
use Google\Cloud\Kms\V1\MacVerifyResponse;
use Google\Cloud\Kms\V1\PublicKey;
use Google\Cloud\Kms\V1\RawDecryptRequest;
use Google\Cloud\Kms\V1\RawDecryptResponse;
use Google\Cloud\Kms\V1\RawEncryptRequest;
use Google\Cloud\Kms\V1\RawEncryptResponse;
use Google\Cloud\Kms\V1\RestoreCryptoKeyVersionRequest;
use Google\Cloud\Kms\V1\UpdateCryptoKeyPrimaryVersionRequest;
use Google\Cloud\Kms\V1\UpdateCryptoKeyRequest;
use Google\Cloud\Kms\V1\UpdateCryptoKeyVersionRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Google Cloud Key Management Service
 *
 * Manages cryptographic keys and operations using those keys. Implements a REST
 * model with the following objects:
 *
 * * [KeyRing][google.cloud.kms.v1.KeyRing]
 * * [CryptoKey][google.cloud.kms.v1.CryptoKey]
 * * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
 * * [ImportJob][google.cloud.kms.v1.ImportJob]
 *
 * If you are using manual gRPC libraries, see
 * [Using gRPC with Cloud KMS](https://cloud.google.com/kms/docs/grpc).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\Kms\V1\KeyManagementServiceClient} for the stable implementation
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface asymmetricDecryptAsync(AsymmetricDecryptRequest $request, array $optionalArgs = [])
 * @method PromiseInterface asymmetricSignAsync(AsymmetricSignRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCryptoKeyAsync(CreateCryptoKeyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCryptoKeyVersionAsync(CreateCryptoKeyVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createImportJobAsync(CreateImportJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createKeyRingAsync(CreateKeyRingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface decryptAsync(DecryptRequest $request, array $optionalArgs = [])
 * @method PromiseInterface destroyCryptoKeyVersionAsync(DestroyCryptoKeyVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface encryptAsync(EncryptRequest $request, array $optionalArgs = [])
 * @method PromiseInterface generateRandomBytesAsync(GenerateRandomBytesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCryptoKeyAsync(GetCryptoKeyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCryptoKeyVersionAsync(GetCryptoKeyVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getImportJobAsync(GetImportJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getKeyRingAsync(GetKeyRingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPublicKeyAsync(GetPublicKeyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface importCryptoKeyVersionAsync(ImportCryptoKeyVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCryptoKeyVersionsAsync(ListCryptoKeyVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCryptoKeysAsync(ListCryptoKeysRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listImportJobsAsync(ListImportJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listKeyRingsAsync(ListKeyRingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface macSignAsync(MacSignRequest $request, array $optionalArgs = [])
 * @method PromiseInterface macVerifyAsync(MacVerifyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface rawDecryptAsync(RawDecryptRequest $request, array $optionalArgs = [])
 * @method PromiseInterface rawEncryptAsync(RawEncryptRequest $request, array $optionalArgs = [])
 * @method PromiseInterface restoreCryptoKeyVersionAsync(RestoreCryptoKeyVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCryptoKeyAsync(UpdateCryptoKeyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCryptoKeyPrimaryVersionAsync(UpdateCryptoKeyPrimaryVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCryptoKeyVersionAsync(UpdateCryptoKeyVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
abstract class KeyManagementServiceBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.kms.v1.KeyManagementService';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'cloudkms.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloudkms',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/key_management_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/key_management_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/key_management_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/key_management_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(string $project, string $location, string $keyRing, string $cryptoKey): string
    {
        return self::getPathTemplate('cryptoKey')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * crypto_key_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     * @param string $cryptoKeyVersion
     *
     * @return string The formatted crypto_key_version resource.
     */
    public static function cryptoKeyVersionName(string $project, string $location, string $keyRing, string $cryptoKey, string $cryptoKeyVersion): string
    {
        return self::getPathTemplate('cryptoKeyVersion')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
            'crypto_key_version' => $cryptoKeyVersion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a import_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $importJob
     *
     * @return string The formatted import_job resource.
     */
    public static function importJobName(string $project, string $location, string $keyRing, string $importJob): string
    {
        return self::getPathTemplate('importJob')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'import_job' => $importJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a key_ring
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     *
     * @return string The formatted key_ring resource.
     */
    public static function keyRingName(string $project, string $location, string $keyRing): string
    {
        return self::getPathTemplate('keyRing')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - cryptoKeyVersion: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}
     * - importJob: projects/{project}/locations/{location}/keyRings/{key_ring}/importJobs/{import_job}
     * - keyRing: projects/{project}/locations/{location}/keyRings/{key_ring}
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'cloudkms.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Decrypts data that was encrypted with a public key retrieved from
     * [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey]
     * corresponding to a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * ASYMMETRIC_DECRYPT.
     *
     * The async variant is {@see self::asymmetricDecryptAsync()} .
     *
     * @param AsymmetricDecryptRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AsymmetricDecryptResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function asymmetricDecrypt(AsymmetricDecryptRequest $request, array $callOptions = []): AsymmetricDecryptResponse
    {
        return $this->startApiCall('AsymmetricDecrypt', $request, $callOptions)->wait();
    }

    /**
     * Signs data using a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * ASYMMETRIC_SIGN, producing a signature that can be verified with the public
     * key retrieved from
     * [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
     *
     * The async variant is {@see self::asymmetricSignAsync()} .
     *
     * @param AsymmetricSignRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AsymmetricSignResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function asymmetricSign(AsymmetricSignRequest $request, array $callOptions = []): AsymmetricSignResponse
    {
        return $this->startApiCall('AsymmetricSign', $request, $callOptions)->wait();
    }

    /**
     * Create a new [CryptoKey][google.cloud.kms.v1.CryptoKey] within a
     * [KeyRing][google.cloud.kms.v1.KeyRing].
     *
     * [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] and
     * [CryptoKey.version_template.algorithm][google.cloud.kms.v1.CryptoKeyVersionTemplate.algorithm]
     * are required.
     *
     * The async variant is {@see self::createCryptoKeyAsync()} .
     *
     * @param CreateCryptoKeyRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CryptoKey
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCryptoKey(CreateCryptoKeyRequest $request, array $callOptions = []): CryptoKey
    {
        return $this->startApiCall('CreateCryptoKey', $request, $callOptions)->wait();
    }

    /**
     * Create a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey].
     *
     * The server will assign the next sequential id. If unset,
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
     * [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED].
     *
     * The async variant is {@see self::createCryptoKeyVersionAsync()} .
     *
     * @param CreateCryptoKeyVersionRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CryptoKeyVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCryptoKeyVersion(CreateCryptoKeyVersionRequest $request, array $callOptions = []): CryptoKeyVersion
    {
        return $this->startApiCall('CreateCryptoKeyVersion', $request, $callOptions)->wait();
    }

    /**
     * Create a new [ImportJob][google.cloud.kms.v1.ImportJob] within a
     * [KeyRing][google.cloud.kms.v1.KeyRing].
     *
     * [ImportJob.import_method][google.cloud.kms.v1.ImportJob.import_method] is
     * required.
     *
     * The async variant is {@see self::createImportJobAsync()} .
     *
     * @param CreateImportJobRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ImportJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createImportJob(CreateImportJobRequest $request, array $callOptions = []): ImportJob
    {
        return $this->startApiCall('CreateImportJob', $request, $callOptions)->wait();
    }

    /**
     * Create a new [KeyRing][google.cloud.kms.v1.KeyRing] in a given Project and
     * Location.
     *
     * The async variant is {@see self::createKeyRingAsync()} .
     *
     * @param CreateKeyRingRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return KeyRing
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createKeyRing(CreateKeyRingRequest $request, array $callOptions = []): KeyRing
    {
        return $this->startApiCall('CreateKeyRing', $request, $callOptions)->wait();
    }

    /**
     * Decrypts data that was protected by
     * [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt]. The
     * [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
     *
     * The async variant is {@see self::decryptAsync()} .
     *
     * @param DecryptRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DecryptResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function decrypt(DecryptRequest $request, array $callOptions = []): DecryptResponse
    {
        return $this->startApiCall('Decrypt', $request, $callOptions)->wait();
    }

    /**
     * Schedule a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] for
     * destruction.
     *
     * Upon calling this method,
     * [CryptoKeyVersion.state][google.cloud.kms.v1.CryptoKeyVersion.state] will
     * be set to
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED],
     * and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will
     * be set to the time
     * [destroy_scheduled_duration][google.cloud.kms.v1.CryptoKey.destroy_scheduled_duration]
     * in the future. At that time, the
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] will automatically
     * change to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED],
     * and the key material will be irrevocably destroyed.
     *
     * Before the
     * [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] is
     * reached,
     * [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
     * may be called to reverse the process.
     *
     * The async variant is {@see self::destroyCryptoKeyVersionAsync()} .
     *
     * @param DestroyCryptoKeyVersionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CryptoKeyVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function destroyCryptoKeyVersion(DestroyCryptoKeyVersionRequest $request, array $callOptions = []): CryptoKeyVersion
    {
        return $this->startApiCall('DestroyCryptoKeyVersion', $request, $callOptions)->wait();
    }

    /**
     * Encrypts data, so that it can only be recovered by a call to
     * [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt]. The
     * [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
     *
     * The async variant is {@see self::encryptAsync()} .
     *
     * @param EncryptRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EncryptResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function encrypt(EncryptRequest $request, array $callOptions = []): EncryptResponse
    {
        return $this->startApiCall('Encrypt', $request, $callOptions)->wait();
    }

    /**
     * Generate random bytes using the Cloud KMS randomness source in the provided
     * location.
     *
     * The async variant is {@see self::generateRandomBytesAsync()} .
     *
     * @param GenerateRandomBytesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GenerateRandomBytesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function generateRandomBytes(GenerateRandomBytesRequest $request, array $callOptions = []): GenerateRandomBytesResponse
    {
        return $this->startApiCall('GenerateRandomBytes', $request, $callOptions)->wait();
    }

    /**
     * Returns metadata for a given [CryptoKey][google.cloud.kms.v1.CryptoKey], as
     * well as its [primary][google.cloud.kms.v1.CryptoKey.primary]
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     *
     * The async variant is {@see self::getCryptoKeyAsync()} .
     *
     * @param GetCryptoKeyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CryptoKey
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCryptoKey(GetCryptoKeyRequest $request, array $callOptions = []): CryptoKey
    {
        return $this->startApiCall('GetCryptoKey', $request, $callOptions)->wait();
    }

    /**
     * Returns metadata for a given
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     *
     * The async variant is {@see self::getCryptoKeyVersionAsync()} .
     *
     * @param GetCryptoKeyVersionRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CryptoKeyVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCryptoKeyVersion(GetCryptoKeyVersionRequest $request, array $callOptions = []): CryptoKeyVersion
    {
        return $this->startApiCall('GetCryptoKeyVersion', $request, $callOptions)->wait();
    }

    /**
     * Returns metadata for a given [ImportJob][google.cloud.kms.v1.ImportJob].
     *
     * The async variant is {@see self::getImportJobAsync()} .
     *
     * @param GetImportJobRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ImportJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getImportJob(GetImportJobRequest $request, array $callOptions = []): ImportJob
    {
        return $this->startApiCall('GetImportJob', $request, $callOptions)->wait();
    }

    /**
     * Returns metadata for a given [KeyRing][google.cloud.kms.v1.KeyRing].
     *
     * The async variant is {@see self::getKeyRingAsync()} .
     *
     * @param GetKeyRingRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return KeyRing
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getKeyRing(GetKeyRingRequest $request, array $callOptions = []): KeyRing
    {
        return $this->startApiCall('GetKeyRing', $request, $callOptions)->wait();
    }

    /**
     * Returns the public key for the given
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. The
     * [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
     * [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN]
     * or
     * [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
     *
     * The async variant is {@see self::getPublicKeyAsync()} .
     *
     * @param GetPublicKeyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PublicKey
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPublicKey(GetPublicKeyRequest $request, array $callOptions = []): PublicKey
    {
        return $this->startApiCall('GetPublicKey', $request, $callOptions)->wait();
    }

    /**
     * Import wrapped key material into a
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     *
     * All requests must specify a [CryptoKey][google.cloud.kms.v1.CryptoKey]. If
     * a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] is additionally
     * specified in the request, key material will be reimported into that
     * version. Otherwise, a new version will be created, and will be assigned the
     * next sequential id within the [CryptoKey][google.cloud.kms.v1.CryptoKey].
     *
     * The async variant is {@see self::importCryptoKeyVersionAsync()} .
     *
     * @param ImportCryptoKeyVersionRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CryptoKeyVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importCryptoKeyVersion(ImportCryptoKeyVersionRequest $request, array $callOptions = []): CryptoKeyVersion
    {
        return $this->startApiCall('ImportCryptoKeyVersion', $request, $callOptions)->wait();
    }

    /**
     * Lists [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
     *
     * The async variant is {@see self::listCryptoKeyVersionsAsync()} .
     *
     * @param ListCryptoKeyVersionsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCryptoKeyVersions(ListCryptoKeyVersionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCryptoKeyVersions', $request, $callOptions);
    }

    /**
     * Lists [CryptoKeys][google.cloud.kms.v1.CryptoKey].
     *
     * The async variant is {@see self::listCryptoKeysAsync()} .
     *
     * @param ListCryptoKeysRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCryptoKeys(ListCryptoKeysRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCryptoKeys', $request, $callOptions);
    }

    /**
     * Lists [ImportJobs][google.cloud.kms.v1.ImportJob].
     *
     * The async variant is {@see self::listImportJobsAsync()} .
     *
     * @param ListImportJobsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listImportJobs(ListImportJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListImportJobs', $request, $callOptions);
    }

    /**
     * Lists [KeyRings][google.cloud.kms.v1.KeyRing].
     *
     * The async variant is {@see self::listKeyRingsAsync()} .
     *
     * @param ListKeyRingsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listKeyRings(ListKeyRingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListKeyRings', $request, $callOptions);
    }

    /**
     * Signs data using a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] MAC,
     * producing a tag that can be verified by another source with the same key.
     *
     * The async variant is {@see self::macSignAsync()} .
     *
     * @param MacSignRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MacSignResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function macSign(MacSignRequest $request, array $callOptions = []): MacSignResponse
    {
        return $this->startApiCall('MacSign', $request, $callOptions)->wait();
    }

    /**
     * Verifies MAC tag using a
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
     * [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] MAC, and returns
     * a response that indicates whether or not the verification was successful.
     *
     * The async variant is {@see self::macVerifyAsync()} .
     *
     * @param MacVerifyRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MacVerifyResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function macVerify(MacVerifyRequest $request, array $callOptions = []): MacVerifyResponse
    {
        return $this->startApiCall('MacVerify', $request, $callOptions)->wait();
    }

    /**
     * Decrypts data that was originally encrypted using a raw cryptographic
     * mechanism. The [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * must be
     * [RAW_ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.RAW_ENCRYPT_DECRYPT].
     *
     * The async variant is {@see self::rawDecryptAsync()} .
     *
     * @param RawDecryptRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RawDecryptResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rawDecrypt(RawDecryptRequest $request, array $callOptions = []): RawDecryptResponse
    {
        return $this->startApiCall('RawDecrypt', $request, $callOptions)->wait();
    }

    /**
     * Encrypts data using portable cryptographic primitives. Most users should
     * choose [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] and
     * [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt] rather than
     * their raw counterparts. The
     * [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
     * [RAW_ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.RAW_ENCRYPT_DECRYPT].
     *
     * The async variant is {@see self::rawEncryptAsync()} .
     *
     * @param RawEncryptRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RawEncryptResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rawEncrypt(RawEncryptRequest $request, array $callOptions = []): RawEncryptResponse
    {
        return $this->startApiCall('RawEncrypt', $request, $callOptions)->wait();
    }

    /**
     * Restore a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state.
     *
     * Upon restoration of the CryptoKeyVersion,
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
     * [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED],
     * and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will
     * be cleared.
     *
     * The async variant is {@see self::restoreCryptoKeyVersionAsync()} .
     *
     * @param RestoreCryptoKeyVersionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CryptoKeyVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restoreCryptoKeyVersion(RestoreCryptoKeyVersionRequest $request, array $callOptions = []): CryptoKeyVersion
    {
        return $this->startApiCall('RestoreCryptoKeyVersion', $request, $callOptions)->wait();
    }

    /**
     * Update a [CryptoKey][google.cloud.kms.v1.CryptoKey].
     *
     * The async variant is {@see self::updateCryptoKeyAsync()} .
     *
     * @param UpdateCryptoKeyRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CryptoKey
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCryptoKey(UpdateCryptoKeyRequest $request, array $callOptions = []): CryptoKey
    {
        return $this->startApiCall('UpdateCryptoKey', $request, $callOptions)->wait();
    }

    /**
     * Update the version of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that
     * will be used in
     * [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
     *
     * Returns an error if called on a key whose purpose is not
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
     *
     * The async variant is {@see self::updateCryptoKeyPrimaryVersionAsync()} .
     *
     * @param UpdateCryptoKeyPrimaryVersionRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CryptoKey
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCryptoKeyPrimaryVersion(UpdateCryptoKeyPrimaryVersionRequest $request, array $callOptions = []): CryptoKey
    {
        return $this->startApiCall('UpdateCryptoKeyPrimaryVersion', $request, $callOptions)->wait();
    }

    /**
     * Update a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s
     * metadata.
     *
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] may be changed between
     * [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
     * and
     * [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED]
     * using this method. See
     * [DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion]
     * and
     * [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
     * to move between other states.
     *
     * The async variant is {@see self::updateCryptoKeyVersionAsync()} .
     *
     * @param UpdateCryptoKeyVersionRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CryptoKeyVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCryptoKeyVersion(UpdateCryptoKeyVersionRequest $request, array $callOptions = []): CryptoKeyVersion
    {
        return $this->startApiCall('UpdateCryptoKeyVersion', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see self::getLocationAsync()} .
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see self::listLocationsAsync()} .
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see self::getIamPolicyAsync()} .
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see self::setIamPolicyAsync()} .
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see self::testIamPermissionsAsync()} .
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
