<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dataplex/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dataplex\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dataplex\V1\Asset;
use Google\Cloud\Dataplex\V1\CancelJobRequest;
use Google\Cloud\Dataplex\V1\CreateAssetRequest;
use Google\Cloud\Dataplex\V1\CreateEnvironmentRequest;
use Google\Cloud\Dataplex\V1\CreateLakeRequest;
use Google\Cloud\Dataplex\V1\CreateTaskRequest;
use Google\Cloud\Dataplex\V1\CreateZoneRequest;
use Google\Cloud\Dataplex\V1\DeleteAssetRequest;
use Google\Cloud\Dataplex\V1\DeleteEnvironmentRequest;
use Google\Cloud\Dataplex\V1\DeleteLakeRequest;
use Google\Cloud\Dataplex\V1\DeleteTaskRequest;
use Google\Cloud\Dataplex\V1\DeleteZoneRequest;
use Google\Cloud\Dataplex\V1\Environment;
use Google\Cloud\Dataplex\V1\GetAssetRequest;
use Google\Cloud\Dataplex\V1\GetEnvironmentRequest;
use Google\Cloud\Dataplex\V1\GetJobRequest;
use Google\Cloud\Dataplex\V1\GetLakeRequest;
use Google\Cloud\Dataplex\V1\GetTaskRequest;
use Google\Cloud\Dataplex\V1\GetZoneRequest;
use Google\Cloud\Dataplex\V1\Job;
use Google\Cloud\Dataplex\V1\Lake;
use Google\Cloud\Dataplex\V1\ListActionsResponse;
use Google\Cloud\Dataplex\V1\ListAssetActionsRequest;
use Google\Cloud\Dataplex\V1\ListAssetsRequest;
use Google\Cloud\Dataplex\V1\ListAssetsResponse;
use Google\Cloud\Dataplex\V1\ListEnvironmentsRequest;
use Google\Cloud\Dataplex\V1\ListEnvironmentsResponse;
use Google\Cloud\Dataplex\V1\ListJobsRequest;
use Google\Cloud\Dataplex\V1\ListJobsResponse;
use Google\Cloud\Dataplex\V1\ListLakeActionsRequest;
use Google\Cloud\Dataplex\V1\ListLakesRequest;
use Google\Cloud\Dataplex\V1\ListLakesResponse;
use Google\Cloud\Dataplex\V1\ListSessionsRequest;
use Google\Cloud\Dataplex\V1\ListSessionsResponse;
use Google\Cloud\Dataplex\V1\ListTasksRequest;
use Google\Cloud\Dataplex\V1\ListTasksResponse;
use Google\Cloud\Dataplex\V1\ListZoneActionsRequest;
use Google\Cloud\Dataplex\V1\ListZonesRequest;
use Google\Cloud\Dataplex\V1\ListZonesResponse;
use Google\Cloud\Dataplex\V1\RunTaskRequest;
use Google\Cloud\Dataplex\V1\RunTaskResponse;
use Google\Cloud\Dataplex\V1\Task;
use Google\Cloud\Dataplex\V1\UpdateAssetRequest;
use Google\Cloud\Dataplex\V1\UpdateEnvironmentRequest;
use Google\Cloud\Dataplex\V1\UpdateLakeRequest;
use Google\Cloud\Dataplex\V1\UpdateTaskRequest;
use Google\Cloud\Dataplex\V1\UpdateZoneRequest;
use Google\Cloud\Dataplex\V1\Zone;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Dataplex service provides data lakes as a service. The primary resources
 * offered by this service are Lakes, Zones and Assets which collectively allow
 * a data administrator to organize, manage, secure and catalog data across
 * their organization located across cloud projects in a variety of storage
 * systems including Cloud Storage and BigQuery.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $dataplexServiceClient = new DataplexServiceClient();
 * try {
 *     $formattedName = $dataplexServiceClient->jobName('[PROJECT]', '[LOCATION]', '[LAKE]', '[TASK]', '[JOB]');
 *     $dataplexServiceClient->cancelJob($formattedName);
 * } finally {
 *     $dataplexServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\Dataplex\V1\Client\DataplexServiceClient} to use the new surface.
 */
class DataplexServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.dataplex.v1.DataplexService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'dataplex.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $assetNameTemplate;

    private static $environmentNameTemplate;

    private static $jobNameTemplate;

    private static $lakeNameTemplate;

    private static $locationNameTemplate;

    private static $taskNameTemplate;

    private static $zoneNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/dataplex_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/dataplex_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/dataplex_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/dataplex_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAssetNameTemplate()
    {
        if (self::$assetNameTemplate == null) {
            self::$assetNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/assets/{asset}'
            );
        }

        return self::$assetNameTemplate;
    }

    private static function getEnvironmentNameTemplate()
    {
        if (self::$environmentNameTemplate == null) {
            self::$environmentNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/lakes/{lake}/environments/{environment}'
            );
        }

        return self::$environmentNameTemplate;
    }

    private static function getJobNameTemplate()
    {
        if (self::$jobNameTemplate == null) {
            self::$jobNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/lakes/{lake}/tasks/{task}/jobs/{job}'
            );
        }

        return self::$jobNameTemplate;
    }

    private static function getLakeNameTemplate()
    {
        if (self::$lakeNameTemplate == null) {
            self::$lakeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/lakes/{lake}'
            );
        }

        return self::$lakeNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getTaskNameTemplate()
    {
        if (self::$taskNameTemplate == null) {
            self::$taskNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/lakes/{lake}/tasks/{task}'
            );
        }

        return self::$taskNameTemplate;
    }

    private static function getZoneNameTemplate()
    {
        if (self::$zoneNameTemplate == null) {
            self::$zoneNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}'
            );
        }

        return self::$zoneNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'asset' => self::getAssetNameTemplate(),
                'environment' => self::getEnvironmentNameTemplate(),
                'job' => self::getJobNameTemplate(),
                'lake' => self::getLakeNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'task' => self::getTaskNameTemplate(),
                'zone' => self::getZoneNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a asset
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     * @param string $zone
     * @param string $asset
     *
     * @return string The formatted asset resource.
     */
    public static function assetName($project, $location, $lake, $zone, $asset)
    {
        return self::getAssetNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
            'zone' => $zone,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a environment
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     * @param string $environment
     *
     * @return string The formatted environment resource.
     */
    public static function environmentName(
        $project,
        $location,
        $lake,
        $environment
    ) {
        return self::getEnvironmentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
            'environment' => $environment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     * @param string $task
     * @param string $job
     *
     * @return string The formatted job resource.
     */
    public static function jobName($project, $location, $lake, $task, $job)
    {
        return self::getJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
            'task' => $task,
            'job' => $job,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a lake
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     *
     * @return string The formatted lake resource.
     */
    public static function lakeName($project, $location, $lake)
    {
        return self::getLakeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a task
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     * @param string $task
     *
     * @return string The formatted task resource.
     */
    public static function taskName($project, $location, $lake, $task)
    {
        return self::getTaskNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
            'task' => $task,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a zone
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     * @param string $zone
     *
     * @return string The formatted zone resource.
     */
    public static function zoneName($project, $location, $lake, $zone)
    {
        return self::getZoneNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
            'zone' => $zone,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - asset: projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/assets/{asset}
     * - environment: projects/{project}/locations/{location}/lakes/{lake}/environments/{environment}
     * - job: projects/{project}/locations/{location}/lakes/{lake}/tasks/{task}/jobs/{job}
     * - lake: projects/{project}/locations/{location}/lakes/{lake}
     * - location: projects/{project}/locations/{location}
     * - task: projects/{project}/locations/{location}/lakes/{lake}/tasks/{task}
     * - zone: projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dataplex.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Cancel jobs running for the task resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->jobName('[PROJECT]', '[LOCATION]', '[LAKE]', '[TASK]', '[JOB]');
     *     $dataplexServiceClient->cancelJob($formattedName);
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the job:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/task/{task_id}/job/{job_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function cancelJob($name, array $optionalArgs = [])
    {
        $request = new CancelJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CancelJob',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates an asset resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->zoneName('[PROJECT]', '[LOCATION]', '[LAKE]', '[ZONE]');
     *     $assetId = 'asset_id';
     *     $asset = new Asset();
     *     $operationResponse = $dataplexServiceClient->createAsset($formattedParent, $assetId, $asset);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->createAsset($formattedParent, $assetId, $asset);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'createAsset');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent zone:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
     * @param string $assetId      Required. Asset identifier.
     *                             This ID will be used to generate names such as table names when publishing
     *                             metadata to Hive Metastore and BigQuery.
     *                             * Must contain only lowercase letters, numbers and hyphens.
     *                             * Must start with a letter.
     *                             * Must end with a number or a letter.
     *                             * Must be between 1-63 characters.
     *                             * Must be unique within the zone.
     * @param Asset  $asset        Required. Asset resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAsset(
        $parent,
        $assetId,
        $asset,
        array $optionalArgs = []
    ) {
        $request = new CreateAssetRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAssetId($assetId);
        $request->setAsset($asset);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateAsset',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Create an environment resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->lakeName('[PROJECT]', '[LOCATION]', '[LAKE]');
     *     $environmentId = 'environment_id';
     *     $environment = new Environment();
     *     $operationResponse = $dataplexServiceClient->createEnvironment($formattedParent, $environmentId, $environment);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->createEnvironment($formattedParent, $environmentId, $environment);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'createEnvironment');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string      $parent        Required. The resource name of the parent lake:
     *                                   `projects/{project_id}/locations/{location_id}/lakes/{lake_id}`.
     * @param string      $environmentId Required. Environment identifier.
     *                                   * Must contain only lowercase letters, numbers and hyphens.
     *                                   * Must start with a letter.
     *                                   * Must be between 1-63 characters.
     *                                   * Must end with a number or a letter.
     *                                   * Must be unique within the lake.
     * @param Environment $environment   Required. Environment resource.
     * @param array       $optionalArgs  {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createEnvironment(
        $parent,
        $environmentId,
        $environment,
        array $optionalArgs = []
    ) {
        $request = new CreateEnvironmentRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEnvironmentId($environmentId);
        $request->setEnvironment($environment);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateEnvironment',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a lake resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $lakeId = 'lake_id';
     *     $lake = new Lake();
     *     $operationResponse = $dataplexServiceClient->createLake($formattedParent, $lakeId, $lake);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->createLake($formattedParent, $lakeId, $lake);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'createLake');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the lake location, of the form:
     *                             projects/{project_number}/locations/{location_id}
     *                             where `location_id` refers to a GCP region.
     * @param string $lakeId       Required. Lake identifier.
     *                             This ID will be used to generate names such as database and dataset names
     *                             when publishing metadata to Hive Metastore and BigQuery.
     *                             * Must contain only lowercase letters, numbers and hyphens.
     *                             * Must start with a letter.
     *                             * Must end with a number or a letter.
     *                             * Must be between 1-63 characters.
     *                             * Must be unique within the customer project / location.
     * @param Lake   $lake         Required. Lake resource
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createLake(
        $parent,
        $lakeId,
        $lake,
        array $optionalArgs = []
    ) {
        $request = new CreateLakeRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setLakeId($lakeId);
        $request->setLake($lake);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateLake',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a task resource within a lake.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->lakeName('[PROJECT]', '[LOCATION]', '[LAKE]');
     *     $taskId = 'task_id';
     *     $task = new Task();
     *     $operationResponse = $dataplexServiceClient->createTask($formattedParent, $taskId, $task);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->createTask($formattedParent, $taskId, $task);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'createTask');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent lake:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     * @param string $taskId       Required. Task identifier.
     * @param Task   $task         Required. Task resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createTask(
        $parent,
        $taskId,
        $task,
        array $optionalArgs = []
    ) {
        $request = new CreateTaskRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTaskId($taskId);
        $request->setTask($task);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateTask',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a zone resource within a lake.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->lakeName('[PROJECT]', '[LOCATION]', '[LAKE]');
     *     $zoneId = 'zone_id';
     *     $zone = new Zone();
     *     $operationResponse = $dataplexServiceClient->createZone($formattedParent, $zoneId, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->createZone($formattedParent, $zoneId, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'createZone');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent lake:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     * @param string $zoneId       Required. Zone identifier.
     *                             This ID will be used to generate names such as database and dataset names
     *                             when publishing metadata to Hive Metastore and BigQuery.
     *                             * Must contain only lowercase letters, numbers and hyphens.
     *                             * Must start with a letter.
     *                             * Must end with a number or a letter.
     *                             * Must be between 1-63 characters.
     *                             * Must be unique across all lakes from all locations in a project.
     *                             * Must not be one of the reserved IDs (i.e. "default", "global-temp")
     * @param Zone   $zone         Required. Zone resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createZone(
        $parent,
        $zoneId,
        $zone,
        array $optionalArgs = []
    ) {
        $request = new CreateZoneRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setZoneId($zoneId);
        $request->setZone($zone);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateZone',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes an asset resource. The referenced storage resource is detached
     * (default) or deleted based on the associated Lifecycle policy.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->assetName('[PROJECT]', '[LOCATION]', '[LAKE]', '[ZONE]', '[ASSET]');
     *     $operationResponse = $dataplexServiceClient->deleteAsset($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->deleteAsset($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'deleteAsset');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the asset:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAsset($name, array $optionalArgs = [])
    {
        $request = new DeleteAssetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteAsset',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Delete the environment resource. All the child resources must have been
     * deleted before environment deletion can be initiated.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->environmentName('[PROJECT]', '[LOCATION]', '[LAKE]', '[ENVIRONMENT]');
     *     $operationResponse = $dataplexServiceClient->deleteEnvironment($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->deleteEnvironment($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'deleteEnvironment');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the environment:
     *                             `projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environments/{environment_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEnvironment($name, array $optionalArgs = [])
    {
        $request = new DeleteEnvironmentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteEnvironment',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a lake resource. All zones within the lake must be deleted before
     * the lake can be deleted.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->lakeName('[PROJECT]', '[LOCATION]', '[LAKE]');
     *     $operationResponse = $dataplexServiceClient->deleteLake($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->deleteLake($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'deleteLake');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the lake:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteLake($name, array $optionalArgs = [])
    {
        $request = new DeleteLakeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteLake',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Delete the task resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->taskName('[PROJECT]', '[LOCATION]', '[LAKE]', '[TASK]');
     *     $operationResponse = $dataplexServiceClient->deleteTask($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->deleteTask($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'deleteTask');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the task:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/task/{task_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTask($name, array $optionalArgs = [])
    {
        $request = new DeleteTaskRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteTask',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a zone resource. All assets within a zone must be deleted before
     * the zone can be deleted.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->zoneName('[PROJECT]', '[LOCATION]', '[LAKE]', '[ZONE]');
     *     $operationResponse = $dataplexServiceClient->deleteZone($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->deleteZone($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'deleteZone');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the zone:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteZone($name, array $optionalArgs = [])
    {
        $request = new DeleteZoneRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteZone',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Retrieves an asset resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->assetName('[PROJECT]', '[LOCATION]', '[LAKE]', '[ZONE]', '[ASSET]');
     *     $response = $dataplexServiceClient->getAsset($formattedName);
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the asset:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\Asset
     *
     * @throws ApiException if the remote call fails
     */
    public function getAsset($name, array $optionalArgs = [])
    {
        $request = new GetAssetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAsset',
            Asset::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get environment resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->environmentName('[PROJECT]', '[LOCATION]', '[LAKE]', '[ENVIRONMENT]');
     *     $response = $dataplexServiceClient->getEnvironment($formattedName);
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the environment:
     *                             `projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environments/{environment_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\Environment
     *
     * @throws ApiException if the remote call fails
     */
    public function getEnvironment($name, array $optionalArgs = [])
    {
        $request = new GetEnvironmentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetEnvironment',
            Environment::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get job resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->jobName('[PROJECT]', '[LOCATION]', '[LAKE]', '[TASK]', '[JOB]');
     *     $response = $dataplexServiceClient->getJob($formattedName);
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the job:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}/jobs/{job_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\Job
     *
     * @throws ApiException if the remote call fails
     */
    public function getJob($name, array $optionalArgs = [])
    {
        $request = new GetJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetJob',
            Job::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a lake resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->lakeName('[PROJECT]', '[LOCATION]', '[LAKE]');
     *     $response = $dataplexServiceClient->getLake($formattedName);
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the lake:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\Lake
     *
     * @throws ApiException if the remote call fails
     */
    public function getLake($name, array $optionalArgs = [])
    {
        $request = new GetLakeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLake',
            Lake::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get task resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->taskName('[PROJECT]', '[LOCATION]', '[LAKE]', '[TASK]');
     *     $response = $dataplexServiceClient->getTask($formattedName);
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the task:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{tasks_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\Task
     *
     * @throws ApiException if the remote call fails
     */
    public function getTask($name, array $optionalArgs = [])
    {
        $request = new GetTaskRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTask',
            Task::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a zone resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->zoneName('[PROJECT]', '[LOCATION]', '[LAKE]', '[ZONE]');
     *     $response = $dataplexServiceClient->getZone($formattedName);
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the zone:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\Zone
     *
     * @throws ApiException if the remote call fails
     */
    public function getZone($name, array $optionalArgs = [])
    {
        $request = new GetZoneRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetZone',
            Zone::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists action resources in an asset.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->assetName('[PROJECT]', '[LOCATION]', '[LAKE]', '[ZONE]', '[ASSET]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataplexServiceClient->listAssetActions($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataplexServiceClient->listAssetActions($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent asset:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAssetActions($parent, array $optionalArgs = [])
    {
        $request = new ListAssetActionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListAssetActions',
            $optionalArgs,
            ListActionsResponse::class,
            $request
        );
    }

    /**
     * Lists asset resources in a zone.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->zoneName('[PROJECT]', '[LOCATION]', '[LAKE]', '[ZONE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataplexServiceClient->listAssets($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataplexServiceClient->listAssets($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent zone:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter request.
     *     @type string $orderBy
     *           Optional. Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAssets($parent, array $optionalArgs = [])
    {
        $request = new ListAssetsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListAssets',
            $optionalArgs,
            ListAssetsResponse::class,
            $request
        );
    }

    /**
     * Lists environments under the given lake.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->lakeName('[PROJECT]', '[LOCATION]', '[LAKE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataplexServiceClient->listEnvironments($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataplexServiceClient->listEnvironments($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent lake:
     *                             `projects/{project_id}/locations/{location_id}/lakes/{lake_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter request.
     *     @type string $orderBy
     *           Optional. Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEnvironments($parent, array $optionalArgs = [])
    {
        $request = new ListEnvironmentsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListEnvironments',
            $optionalArgs,
            ListEnvironmentsResponse::class,
            $request
        );
    }

    /**
     * Lists Jobs under the given task.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->taskName('[PROJECT]', '[LOCATION]', '[LAKE]', '[TASK]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataplexServiceClient->listJobs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataplexServiceClient->listJobs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent environment:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listJobs($parent, array $optionalArgs = [])
    {
        $request = new ListJobsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListJobs',
            $optionalArgs,
            ListJobsResponse::class,
            $request
        );
    }

    /**
     * Lists action resources in a lake.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->lakeName('[PROJECT]', '[LOCATION]', '[LAKE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataplexServiceClient->listLakeActions($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataplexServiceClient->listLakeActions($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent lake:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLakeActions($parent, array $optionalArgs = [])
    {
        $request = new ListLakeActionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLakeActions',
            $optionalArgs,
            ListActionsResponse::class,
            $request
        );
    }

    /**
     * Lists lake resources in a project and location.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataplexServiceClient->listLakes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataplexServiceClient->listLakes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the lake location, of the form:
     *                             `projects/{project_number}/locations/{location_id}`
     *                             where `location_id` refers to a GCP region.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter request.
     *     @type string $orderBy
     *           Optional. Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLakes($parent, array $optionalArgs = [])
    {
        $request = new ListLakesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLakes',
            $optionalArgs,
            ListLakesResponse::class,
            $request
        );
    }

    /**
     * Lists session resources in an environment.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->environmentName('[PROJECT]', '[LOCATION]', '[LAKE]', '[ENVIRONMENT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataplexServiceClient->listSessions($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataplexServiceClient->listSessions($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent environment:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/environment/{environment_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter request. The following `mode` filter is supported to
     *           return only the sessions belonging to the requester when the mode is USER
     *           and return sessions of all the users when the mode is ADMIN. When no filter
     *           is sent default to USER mode. NOTE: When the mode is ADMIN, the requester
     *           should have `dataplex.environments.listAllSessions` permission to list all
     *           sessions, in absence of the permission, the request fails.
     *
     *           mode = ADMIN | USER
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSessions($parent, array $optionalArgs = [])
    {
        $request = new ListSessionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListSessions',
            $optionalArgs,
            ListSessionsResponse::class,
            $request
        );
    }

    /**
     * Lists tasks under the given lake.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->lakeName('[PROJECT]', '[LOCATION]', '[LAKE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataplexServiceClient->listTasks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataplexServiceClient->listTasks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent lake:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter request.
     *     @type string $orderBy
     *           Optional. Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTasks($parent, array $optionalArgs = [])
    {
        $request = new ListTasksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListTasks',
            $optionalArgs,
            ListTasksResponse::class,
            $request
        );
    }

    /**
     * Lists action resources in a zone.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->zoneName('[PROJECT]', '[LOCATION]', '[LAKE]', '[ZONE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataplexServiceClient->listZoneActions($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataplexServiceClient->listZoneActions($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent zone:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listZoneActions($parent, array $optionalArgs = [])
    {
        $request = new ListZoneActionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListZoneActions',
            $optionalArgs,
            ListActionsResponse::class,
            $request
        );
    }

    /**
     * Lists zone resources in a lake.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedParent = $dataplexServiceClient->lakeName('[PROJECT]', '[LOCATION]', '[LAKE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataplexServiceClient->listZones($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataplexServiceClient->listZones($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent lake:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter request.
     *     @type string $orderBy
     *           Optional. Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listZones($parent, array $optionalArgs = [])
    {
        $request = new ListZonesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListZones',
            $optionalArgs,
            ListZonesResponse::class,
            $request
        );
    }

    /**
     * Run an on demand execution of a Task.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $formattedName = $dataplexServiceClient->taskName('[PROJECT]', '[LOCATION]', '[LAKE]', '[TASK]');
     *     $response = $dataplexServiceClient->runTask($formattedName);
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the task:
     *                             `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\RunTaskResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function runTask($name, array $optionalArgs = [])
    {
        $request = new RunTaskRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RunTask',
            RunTaskResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates an asset resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $asset = new Asset();
     *     $operationResponse = $dataplexServiceClient->updateAsset($updateMask, $asset);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->updateAsset($updateMask, $asset);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'updateAsset');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Mask of fields to update.
     * @param Asset     $asset        Required. Update description.
     *                                Only fields specified in `update_mask` are updated.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAsset($updateMask, $asset, array $optionalArgs = [])
    {
        $request = new UpdateAssetRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setAsset($asset);
        $requestParamHeaders['asset.name'] = $asset->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateAsset',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Update the environment resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $environment = new Environment();
     *     $operationResponse = $dataplexServiceClient->updateEnvironment($updateMask, $environment);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->updateEnvironment($updateMask, $environment);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'updateEnvironment');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask   $updateMask   Required. Mask of fields to update.
     * @param Environment $environment  Required. Update description.
     *                                  Only fields specified in `update_mask` are updated.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEnvironment(
        $updateMask,
        $environment,
        array $optionalArgs = []
    ) {
        $request = new UpdateEnvironmentRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setEnvironment($environment);
        $requestParamHeaders['environment.name'] = $environment->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateEnvironment',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a lake resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $lake = new Lake();
     *     $operationResponse = $dataplexServiceClient->updateLake($updateMask, $lake);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->updateLake($updateMask, $lake);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'updateLake');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Mask of fields to update.
     * @param Lake      $lake         Required. Update description.
     *                                Only fields specified in `update_mask` are updated.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateLake($updateMask, $lake, array $optionalArgs = [])
    {
        $request = new UpdateLakeRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setLake($lake);
        $requestParamHeaders['lake.name'] = $lake->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateLake',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Update the task resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $task = new Task();
     *     $operationResponse = $dataplexServiceClient->updateTask($updateMask, $task);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->updateTask($updateMask, $task);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'updateTask');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Mask of fields to update.
     * @param Task      $task         Required. Update description.
     *                                Only fields specified in `update_mask` are updated.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTask($updateMask, $task, array $optionalArgs = [])
    {
        $request = new UpdateTaskRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setTask($task);
        $requestParamHeaders['task.name'] = $task->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateTask',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a zone resource.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $zone = new Zone();
     *     $operationResponse = $dataplexServiceClient->updateZone($updateMask, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataplexServiceClient->updateZone($updateMask, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataplexServiceClient->resumeOperation($operationName, 'updateZone');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Mask of fields to update.
     * @param Zone      $zone         Required. Update description.
     *                                Only fields specified in `update_mask` are updated.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateZone($updateMask, $zone, array $optionalArgs = [])
    {
        $request = new UpdateZoneRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setZone($zone);
        $requestParamHeaders['zone.name'] = $zone->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateZone',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $dataplexServiceClient->getIamPolicy($resource);
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $dataplexServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $dataplexServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     $response = $dataplexServiceClient->getLocation();
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $dataplexServiceClient = new DataplexServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataplexServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataplexServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataplexServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }
}
