<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/v2/feature_flags.proto

namespace Google\Cloud\Bigtable\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Feature flags supported by a client.
 * This is intended to be sent as part of request metadata to assure the server
 * that certain behaviors are safe to enable. This proto is meant to be
 * serialized and websafe-base64 encoded under the `bigtable-features` metadata
 * key. The value will remain constant for the lifetime of a client and due to
 * HTTP2's HPACK compression, the request overhead will be tiny.
 * This is an internal implementation detail and should not be used by endusers
 * directly.
 *
 * Generated from protobuf message <code>google.bigtable.v2.FeatureFlags</code>
 */
class FeatureFlags extends \Google\Protobuf\Internal\Message
{
    /**
     * Notify the server that the client supports reverse scans. The server will
     * reject ReadRowsRequests with the reverse bit set when this is absent.
     *
     * Generated from protobuf field <code>bool reverse_scans = 1;</code>
     */
    private $reverse_scans = false;
    /**
     * Notify the server that the client enables batch write flow control by
     * requesting RateLimitInfo from MutateRowsResponse.
     *
     * Generated from protobuf field <code>bool mutate_rows_rate_limit = 3;</code>
     */
    private $mutate_rows_rate_limit = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $reverse_scans
     *           Notify the server that the client supports reverse scans. The server will
     *           reject ReadRowsRequests with the reverse bit set when this is absent.
     *     @type bool $mutate_rows_rate_limit
     *           Notify the server that the client enables batch write flow control by
     *           requesting RateLimitInfo from MutateRowsResponse.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\V2\FeatureFlags::initOnce();
        parent::__construct($data);
    }

    /**
     * Notify the server that the client supports reverse scans. The server will
     * reject ReadRowsRequests with the reverse bit set when this is absent.
     *
     * Generated from protobuf field <code>bool reverse_scans = 1;</code>
     * @return bool
     */
    public function getReverseScans()
    {
        return $this->reverse_scans;
    }

    /**
     * Notify the server that the client supports reverse scans. The server will
     * reject ReadRowsRequests with the reverse bit set when this is absent.
     *
     * Generated from protobuf field <code>bool reverse_scans = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setReverseScans($var)
    {
        GPBUtil::checkBool($var);
        $this->reverse_scans = $var;

        return $this;
    }

    /**
     * Notify the server that the client enables batch write flow control by
     * requesting RateLimitInfo from MutateRowsResponse.
     *
     * Generated from protobuf field <code>bool mutate_rows_rate_limit = 3;</code>
     * @return bool
     */
    public function getMutateRowsRateLimit()
    {
        return $this->mutate_rows_rate_limit;
    }

    /**
     * Notify the server that the client enables batch write flow control by
     * requesting RateLimitInfo from MutateRowsResponse.
     *
     * Generated from protobuf field <code>bool mutate_rows_rate_limit = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setMutateRowsRateLimit($var)
    {
        GPBUtil::checkBool($var);
        $this->mutate_rows_rate_limit = $var;

        return $this;
    }

}

