<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/talent/v4beta1/filters.proto

namespace Google\Cloud\Talent\V4beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Filters to apply when performing the search query.
 *
 * Generated from protobuf message <code>google.cloud.talent.v4beta1.ProfileQuery</code>
 */
class ProfileQuery extends \Google\Protobuf\Internal\Message
{
    /**
     * Keywords to match any text fields of profiles.
     * For example, "software engineer in Palo Alto".
     *
     * Generated from protobuf field <code>string query = 1;</code>
     */
    private $query = '';
    /**
     * The location filter specifies geo-regions containing the profiles to
     * search against.
     * One of [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] or [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] must be
     * provided or an error is thrown. If both [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] and
     * [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] are provided, an error is thrown.
     * The following logic is used to determine which locations in
     * the profile to filter against:
     * 1. All of the profile's geocoded [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where
     * [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     * 2. If the above set of locations is empty, all of the profile's geocoded
     * [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is
     * CONTACT_INFO_USAGE_UNSPECIFIED and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     * 3. If the above set of locations is empty, all of the profile's geocoded
     * [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL or
     * CONTACT_INFO_USAGE_UNSPECIFIED and [Address.current][google.cloud.talent.v4beta1.Address.current] is not set.
     * This means that any profiles without any [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] that match
     * any of the above criteria will not be included in a search with location
     * filter. Furthermore, any [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is
     * WORK or SCHOOL or where [Address.current][google.cloud.talent.v4beta1.Address.current] is false are not considered for
     * location filter.
     * If a location filter isn't specified, profiles fitting the other search
     * criteria are retrieved regardless of where they're located.
     * If [LocationFilter.negated][google.cloud.talent.v4beta1.LocationFilter.negated] is specified, the result doesn't contain
     * profiles from that location.
     * If [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] is provided, the
     * [LocationType][google.cloud.talent.v4beta1.Location.LocationType], center
     * point (latitude and longitude), and radius are automatically detected by
     * the Google Maps Geocoding API and included as well. If
     * [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] cannot be geocoded, the filter
     * falls back to keyword search.
     * If the detected
     * [LocationType][google.cloud.talent.v4beta1.Location.LocationType] is
     * [LocationType.SUB_ADMINISTRATIVE_AREA][google.cloud.talent.v4beta1.Location.LocationType.SUB_ADMINISTRATIVE_AREA],
     * [LocationType.ADMINISTRATIVE_AREA][google.cloud.talent.v4beta1.Location.LocationType.ADMINISTRATIVE_AREA],
     * or
     * [LocationType.COUNTRY][google.cloud.talent.v4beta1.Location.LocationType.COUNTRY],
     * the filter is performed against the detected location name (using exact
     * text matching). Otherwise, the filter is performed against the detected
     * center point and a radius of detected location radius +
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles].
     * If [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] is provided,
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is the additional radius on top of the
     * radius of the location geocoded from [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address]. If
     * [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] is provided,
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is the only radius that is used.
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is 10 by default. Note that the value
     * of [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is 0 if it is unset, so the server
     * does not differentiate [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] that is
     * explicitly set to 0 and [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] that is not
     * set. Which means that if [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is explicitly
     * set to 0, the server will use the default value of
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] which is 10. To work around this and
     * effectively set [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] to 0, we recommend
     * setting [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] to a very small decimal number
     * (such as 0.00001).
     * If [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is negative, an error is thrown.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.LocationFilter location_filters = 2;</code>
     */
    private $location_filters;
    /**
     * Job title filter specifies job titles of profiles to match on.
     * If a job title isn't specified, profiles with any titles are retrieved.
     * If multiple values are specified, profiles are retrieved with any of the
     * specified job titles.
     * If [JobTitleFilter.negated][google.cloud.talent.v4beta1.JobTitleFilter.negated] is specified, the result won't contain
     * profiles with the job titles.
     * For example, search for profiles with a job title "Product Manager".
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.JobTitleFilter job_title_filters = 3;</code>
     */
    private $job_title_filters;
    /**
     * Employer filter specifies employers of profiles to match on.
     * If an employer filter isn't specified, profiles with any employers are
     * retrieved.
     * If multiple employer filters are specified, profiles with any matching
     * employers are retrieved.
     * If [EmployerFilter.negated][google.cloud.talent.v4beta1.EmployerFilter.negated] is specified, the result won't contain
     * profiles that match the employers.
     * For example, search for profiles that have working experience at "Google
     * LLC".
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EmployerFilter employer_filters = 4;</code>
     */
    private $employer_filters;
    /**
     * Education filter specifies education of profiles to match on.
     * If an education filter isn't specified, profiles with any education are
     * retrieved.
     * If multiple education filters are specified, profiles that match any
     * education filters are retrieved.
     * If [EducationFilter.negated][google.cloud.talent.v4beta1.EducationFilter.negated] is specified, the result won't contain
     * profiles that match the educations.
     * For example, search for profiles with a master degree.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EducationFilter education_filters = 5;</code>
     */
    private $education_filters;
    /**
     * Skill filter specifies skill of profiles to match on.
     * If a skill filter isn't specified, profiles with any skills are retrieved.
     * If multiple skill filters are specified, profiles that match any skill
     * filters are retrieved.
     * If [SkillFilter.negated][google.cloud.talent.v4beta1.SkillFilter.negated] is specified, the result won't contain profiles
     * that match the skills.
     * For example, search for profiles that have "Java" and "Python" in skill
     * list.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.SkillFilter skill_filters = 6;</code>
     */
    private $skill_filters;
    /**
     * Work experience filter specifies the total working experience of profiles
     * to match on.
     * If a work experience filter isn't specified, profiles with any
     * professional experience are retrieved.
     * If multiple work experience filters are specified, profiles that match any
     * work experience filters are retrieved.
     * For example, search for profiles with 10 years of work experience.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.WorkExperienceFilter work_experience_filter = 7;</code>
     */
    private $work_experience_filter;
    /**
     * Time filter specifies the create/update timestamp of the profiles to match
     * on.
     * For example, search for profiles created since "2018-1-1".
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.TimeFilter time_filters = 8;</code>
     */
    private $time_filters;
    /**
     * The hirable filter specifies the profile's hirable status to match on.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue hirable_filter = 9;</code>
     */
    private $hirable_filter = null;
    /**
     * The application date filters specify application date ranges to match on.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.ApplicationDateFilter application_date_filters = 10;</code>
     */
    private $application_date_filters;
    /**
     * The application outcome notes filters specify the notes for the outcome of
     * the job application.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.ApplicationOutcomeNotesFilter application_outcome_notes_filters = 11;</code>
     */
    private $application_outcome_notes_filters;
    /**
     * The application job filters specify the job applied for in the application.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.ApplicationJobFilter application_job_filters = 13;</code>
     */
    private $application_job_filters;
    /**
     * This filter specifies a structured syntax to match against the
     * [Profile.custom_attributes][google.cloud.talent.v4beta1.Profile.custom_attributes] that are marked as `filterable`.
     * The syntax for this expression is a subset of Google SQL syntax.
     * String custom attributes: supported operators are =, != where the left of
     * the operator is a custom field key and the right of the operator is a
     * string (surrounded by quotes) value.
     * Numeric custom attributes: Supported operators are '>', '<' or '='
     * operators where the left of the operator is a custom field key and the
     * right of the operator is a numeric value.
     * Supported functions are LOWER(<field_name>) to
     * perform case insensitive match and EMPTY(<field_name>) to filter on the
     * existence of a key.
     * Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
     * nesting (for example "((A AND B AND C) OR NOT D) AND E"), and there can be
     * a maximum of 50 comparisons/functions in the expression. The expression
     * must be < 2000 characters in length.
     * Sample Query:
     * (key1 = "TEST" OR LOWER(key1)="test" OR NOT EMPTY(key1))
     *
     * Generated from protobuf field <code>string custom_attribute_filter = 15;</code>
     */
    private $custom_attribute_filter = '';
    /**
     * Deprecated. Use availability_filters instead.
     * The candidate availability filter which filters based on availability
     * signals.
     * Signal 1: Number of days since most recent job application.  See
     * [Availability.JobApplicationAvailabilitySignal][google.cloud.talent.v4beta1.Availability.JobApplicationAvailabilitySignal] for the details of this
     * signal.
     * Signal 2: Number of days since last profile update. See
     * [Availability.ProfileUpdateAvailabilitySignal][google.cloud.talent.v4beta1.Availability.ProfileUpdateAvailabilitySignal]
     * for the details of this signal.
     * The candidate availability filter helps a recruiter understand if a
     * specific candidate is likely to be actively seeking new job opportunities
     * based on an aggregated set of signals.  Specifically, the intent is NOT to
     * indicate the candidate's potential qualification / interest / close ability
     * for a specific job.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.CandidateAvailabilityFilter candidate_availability_filter = 16 [deprecated = true];</code>
     * @deprecated
     */
    protected $candidate_availability_filter = null;
    /**
     * The availability filter which filters based on
     * [Profile.availability_signals][google.cloud.talent.v4beta1.Profile.availability_signals].
     * The availability filter helps a recruiter understand if a
     * specific candidate is likely to be actively seeking new job opportunities
     * based on an aggregated set of signals.  Specifically, the intent is NOT to
     * indicate the candidate's potential qualification / interest / close ability
     * for a specific job.
     * There can be at most one [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter] per
     * [signal_type][google.cloud.talent.v4beta1.AvailabilityFilter.signal_type]. If there are multiple
     * [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter] for a [signal_type][google.cloud.talent.v4beta1.AvailabilityFilter.signal_type],
     * an error is thrown.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.AvailabilityFilter availability_filters = 18;</code>
     */
    private $availability_filters;
    /**
     * Person name filter specifies person name of profiles to match on.
     * If multiple person name filters are specified, profiles that match any
     * person name filters are retrieved.
     * For example, search for profiles of candidates with name "John Smith".
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonNameFilter person_name_filters = 17;</code>
     */
    private $person_name_filters;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $query
     *           Keywords to match any text fields of profiles.
     *           For example, "software engineer in Palo Alto".
     *     @type \Google\Cloud\Talent\V4beta1\LocationFilter[]|\Google\Protobuf\Internal\RepeatedField $location_filters
     *           The location filter specifies geo-regions containing the profiles to
     *           search against.
     *           One of [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] or [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] must be
     *           provided or an error is thrown. If both [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] and
     *           [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] are provided, an error is thrown.
     *           The following logic is used to determine which locations in
     *           the profile to filter against:
     *           1. All of the profile's geocoded [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where
     *           [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     *           2. If the above set of locations is empty, all of the profile's geocoded
     *           [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is
     *           CONTACT_INFO_USAGE_UNSPECIFIED and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     *           3. If the above set of locations is empty, all of the profile's geocoded
     *           [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL or
     *           CONTACT_INFO_USAGE_UNSPECIFIED and [Address.current][google.cloud.talent.v4beta1.Address.current] is not set.
     *           This means that any profiles without any [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] that match
     *           any of the above criteria will not be included in a search with location
     *           filter. Furthermore, any [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is
     *           WORK or SCHOOL or where [Address.current][google.cloud.talent.v4beta1.Address.current] is false are not considered for
     *           location filter.
     *           If a location filter isn't specified, profiles fitting the other search
     *           criteria are retrieved regardless of where they're located.
     *           If [LocationFilter.negated][google.cloud.talent.v4beta1.LocationFilter.negated] is specified, the result doesn't contain
     *           profiles from that location.
     *           If [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] is provided, the
     *           [LocationType][google.cloud.talent.v4beta1.Location.LocationType], center
     *           point (latitude and longitude), and radius are automatically detected by
     *           the Google Maps Geocoding API and included as well. If
     *           [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] cannot be geocoded, the filter
     *           falls back to keyword search.
     *           If the detected
     *           [LocationType][google.cloud.talent.v4beta1.Location.LocationType] is
     *           [LocationType.SUB_ADMINISTRATIVE_AREA][google.cloud.talent.v4beta1.Location.LocationType.SUB_ADMINISTRATIVE_AREA],
     *           [LocationType.ADMINISTRATIVE_AREA][google.cloud.talent.v4beta1.Location.LocationType.ADMINISTRATIVE_AREA],
     *           or
     *           [LocationType.COUNTRY][google.cloud.talent.v4beta1.Location.LocationType.COUNTRY],
     *           the filter is performed against the detected location name (using exact
     *           text matching). Otherwise, the filter is performed against the detected
     *           center point and a radius of detected location radius +
     *           [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles].
     *           If [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] is provided,
     *           [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is the additional radius on top of the
     *           radius of the location geocoded from [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address]. If
     *           [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] is provided,
     *           [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is the only radius that is used.
     *           [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is 10 by default. Note that the value
     *           of [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is 0 if it is unset, so the server
     *           does not differentiate [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] that is
     *           explicitly set to 0 and [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] that is not
     *           set. Which means that if [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is explicitly
     *           set to 0, the server will use the default value of
     *           [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] which is 10. To work around this and
     *           effectively set [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] to 0, we recommend
     *           setting [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] to a very small decimal number
     *           (such as 0.00001).
     *           If [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is negative, an error is thrown.
     *     @type \Google\Cloud\Talent\V4beta1\JobTitleFilter[]|\Google\Protobuf\Internal\RepeatedField $job_title_filters
     *           Job title filter specifies job titles of profiles to match on.
     *           If a job title isn't specified, profiles with any titles are retrieved.
     *           If multiple values are specified, profiles are retrieved with any of the
     *           specified job titles.
     *           If [JobTitleFilter.negated][google.cloud.talent.v4beta1.JobTitleFilter.negated] is specified, the result won't contain
     *           profiles with the job titles.
     *           For example, search for profiles with a job title "Product Manager".
     *     @type \Google\Cloud\Talent\V4beta1\EmployerFilter[]|\Google\Protobuf\Internal\RepeatedField $employer_filters
     *           Employer filter specifies employers of profiles to match on.
     *           If an employer filter isn't specified, profiles with any employers are
     *           retrieved.
     *           If multiple employer filters are specified, profiles with any matching
     *           employers are retrieved.
     *           If [EmployerFilter.negated][google.cloud.talent.v4beta1.EmployerFilter.negated] is specified, the result won't contain
     *           profiles that match the employers.
     *           For example, search for profiles that have working experience at "Google
     *           LLC".
     *     @type \Google\Cloud\Talent\V4beta1\EducationFilter[]|\Google\Protobuf\Internal\RepeatedField $education_filters
     *           Education filter specifies education of profiles to match on.
     *           If an education filter isn't specified, profiles with any education are
     *           retrieved.
     *           If multiple education filters are specified, profiles that match any
     *           education filters are retrieved.
     *           If [EducationFilter.negated][google.cloud.talent.v4beta1.EducationFilter.negated] is specified, the result won't contain
     *           profiles that match the educations.
     *           For example, search for profiles with a master degree.
     *     @type \Google\Cloud\Talent\V4beta1\SkillFilter[]|\Google\Protobuf\Internal\RepeatedField $skill_filters
     *           Skill filter specifies skill of profiles to match on.
     *           If a skill filter isn't specified, profiles with any skills are retrieved.
     *           If multiple skill filters are specified, profiles that match any skill
     *           filters are retrieved.
     *           If [SkillFilter.negated][google.cloud.talent.v4beta1.SkillFilter.negated] is specified, the result won't contain profiles
     *           that match the skills.
     *           For example, search for profiles that have "Java" and "Python" in skill
     *           list.
     *     @type \Google\Cloud\Talent\V4beta1\WorkExperienceFilter[]|\Google\Protobuf\Internal\RepeatedField $work_experience_filter
     *           Work experience filter specifies the total working experience of profiles
     *           to match on.
     *           If a work experience filter isn't specified, profiles with any
     *           professional experience are retrieved.
     *           If multiple work experience filters are specified, profiles that match any
     *           work experience filters are retrieved.
     *           For example, search for profiles with 10 years of work experience.
     *     @type \Google\Cloud\Talent\V4beta1\TimeFilter[]|\Google\Protobuf\Internal\RepeatedField $time_filters
     *           Time filter specifies the create/update timestamp of the profiles to match
     *           on.
     *           For example, search for profiles created since "2018-1-1".
     *     @type \Google\Protobuf\BoolValue $hirable_filter
     *           The hirable filter specifies the profile's hirable status to match on.
     *     @type \Google\Cloud\Talent\V4beta1\ApplicationDateFilter[]|\Google\Protobuf\Internal\RepeatedField $application_date_filters
     *           The application date filters specify application date ranges to match on.
     *     @type \Google\Cloud\Talent\V4beta1\ApplicationOutcomeNotesFilter[]|\Google\Protobuf\Internal\RepeatedField $application_outcome_notes_filters
     *           The application outcome notes filters specify the notes for the outcome of
     *           the job application.
     *     @type \Google\Cloud\Talent\V4beta1\ApplicationJobFilter[]|\Google\Protobuf\Internal\RepeatedField $application_job_filters
     *           The application job filters specify the job applied for in the application.
     *     @type string $custom_attribute_filter
     *           This filter specifies a structured syntax to match against the
     *           [Profile.custom_attributes][google.cloud.talent.v4beta1.Profile.custom_attributes] that are marked as `filterable`.
     *           The syntax for this expression is a subset of Google SQL syntax.
     *           String custom attributes: supported operators are =, != where the left of
     *           the operator is a custom field key and the right of the operator is a
     *           string (surrounded by quotes) value.
     *           Numeric custom attributes: Supported operators are '>', '<' or '='
     *           operators where the left of the operator is a custom field key and the
     *           right of the operator is a numeric value.
     *           Supported functions are LOWER(<field_name>) to
     *           perform case insensitive match and EMPTY(<field_name>) to filter on the
     *           existence of a key.
     *           Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
     *           nesting (for example "((A AND B AND C) OR NOT D) AND E"), and there can be
     *           a maximum of 50 comparisons/functions in the expression. The expression
     *           must be < 2000 characters in length.
     *           Sample Query:
     *           (key1 = "TEST" OR LOWER(key1)="test" OR NOT EMPTY(key1))
     *     @type \Google\Cloud\Talent\V4beta1\CandidateAvailabilityFilter $candidate_availability_filter
     *           Deprecated. Use availability_filters instead.
     *           The candidate availability filter which filters based on availability
     *           signals.
     *           Signal 1: Number of days since most recent job application.  See
     *           [Availability.JobApplicationAvailabilitySignal][google.cloud.talent.v4beta1.Availability.JobApplicationAvailabilitySignal] for the details of this
     *           signal.
     *           Signal 2: Number of days since last profile update. See
     *           [Availability.ProfileUpdateAvailabilitySignal][google.cloud.talent.v4beta1.Availability.ProfileUpdateAvailabilitySignal]
     *           for the details of this signal.
     *           The candidate availability filter helps a recruiter understand if a
     *           specific candidate is likely to be actively seeking new job opportunities
     *           based on an aggregated set of signals.  Specifically, the intent is NOT to
     *           indicate the candidate's potential qualification / interest / close ability
     *           for a specific job.
     *     @type \Google\Cloud\Talent\V4beta1\AvailabilityFilter[]|\Google\Protobuf\Internal\RepeatedField $availability_filters
     *           The availability filter which filters based on
     *           [Profile.availability_signals][google.cloud.talent.v4beta1.Profile.availability_signals].
     *           The availability filter helps a recruiter understand if a
     *           specific candidate is likely to be actively seeking new job opportunities
     *           based on an aggregated set of signals.  Specifically, the intent is NOT to
     *           indicate the candidate's potential qualification / interest / close ability
     *           for a specific job.
     *           There can be at most one [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter] per
     *           [signal_type][google.cloud.talent.v4beta1.AvailabilityFilter.signal_type]. If there are multiple
     *           [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter] for a [signal_type][google.cloud.talent.v4beta1.AvailabilityFilter.signal_type],
     *           an error is thrown.
     *     @type \Google\Cloud\Talent\V4beta1\PersonNameFilter[]|\Google\Protobuf\Internal\RepeatedField $person_name_filters
     *           Person name filter specifies person name of profiles to match on.
     *           If multiple person name filters are specified, profiles that match any
     *           person name filters are retrieved.
     *           For example, search for profiles of candidates with name "John Smith".
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Talent\V4Beta1\Filters::initOnce();
        parent::__construct($data);
    }

    /**
     * Keywords to match any text fields of profiles.
     * For example, "software engineer in Palo Alto".
     *
     * Generated from protobuf field <code>string query = 1;</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Keywords to match any text fields of profiles.
     * For example, "software engineer in Palo Alto".
     *
     * Generated from protobuf field <code>string query = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

    /**
     * The location filter specifies geo-regions containing the profiles to
     * search against.
     * One of [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] or [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] must be
     * provided or an error is thrown. If both [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] and
     * [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] are provided, an error is thrown.
     * The following logic is used to determine which locations in
     * the profile to filter against:
     * 1. All of the profile's geocoded [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where
     * [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     * 2. If the above set of locations is empty, all of the profile's geocoded
     * [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is
     * CONTACT_INFO_USAGE_UNSPECIFIED and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     * 3. If the above set of locations is empty, all of the profile's geocoded
     * [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL or
     * CONTACT_INFO_USAGE_UNSPECIFIED and [Address.current][google.cloud.talent.v4beta1.Address.current] is not set.
     * This means that any profiles without any [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] that match
     * any of the above criteria will not be included in a search with location
     * filter. Furthermore, any [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is
     * WORK or SCHOOL or where [Address.current][google.cloud.talent.v4beta1.Address.current] is false are not considered for
     * location filter.
     * If a location filter isn't specified, profiles fitting the other search
     * criteria are retrieved regardless of where they're located.
     * If [LocationFilter.negated][google.cloud.talent.v4beta1.LocationFilter.negated] is specified, the result doesn't contain
     * profiles from that location.
     * If [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] is provided, the
     * [LocationType][google.cloud.talent.v4beta1.Location.LocationType], center
     * point (latitude and longitude), and radius are automatically detected by
     * the Google Maps Geocoding API and included as well. If
     * [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] cannot be geocoded, the filter
     * falls back to keyword search.
     * If the detected
     * [LocationType][google.cloud.talent.v4beta1.Location.LocationType] is
     * [LocationType.SUB_ADMINISTRATIVE_AREA][google.cloud.talent.v4beta1.Location.LocationType.SUB_ADMINISTRATIVE_AREA],
     * [LocationType.ADMINISTRATIVE_AREA][google.cloud.talent.v4beta1.Location.LocationType.ADMINISTRATIVE_AREA],
     * or
     * [LocationType.COUNTRY][google.cloud.talent.v4beta1.Location.LocationType.COUNTRY],
     * the filter is performed against the detected location name (using exact
     * text matching). Otherwise, the filter is performed against the detected
     * center point and a radius of detected location radius +
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles].
     * If [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] is provided,
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is the additional radius on top of the
     * radius of the location geocoded from [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address]. If
     * [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] is provided,
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is the only radius that is used.
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is 10 by default. Note that the value
     * of [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is 0 if it is unset, so the server
     * does not differentiate [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] that is
     * explicitly set to 0 and [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] that is not
     * set. Which means that if [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is explicitly
     * set to 0, the server will use the default value of
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] which is 10. To work around this and
     * effectively set [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] to 0, we recommend
     * setting [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] to a very small decimal number
     * (such as 0.00001).
     * If [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is negative, an error is thrown.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.LocationFilter location_filters = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLocationFilters()
    {
        return $this->location_filters;
    }

    /**
     * The location filter specifies geo-regions containing the profiles to
     * search against.
     * One of [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] or [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] must be
     * provided or an error is thrown. If both [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] and
     * [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] are provided, an error is thrown.
     * The following logic is used to determine which locations in
     * the profile to filter against:
     * 1. All of the profile's geocoded [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where
     * [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     * 2. If the above set of locations is empty, all of the profile's geocoded
     * [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is
     * CONTACT_INFO_USAGE_UNSPECIFIED and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     * 3. If the above set of locations is empty, all of the profile's geocoded
     * [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL or
     * CONTACT_INFO_USAGE_UNSPECIFIED and [Address.current][google.cloud.talent.v4beta1.Address.current] is not set.
     * This means that any profiles without any [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] that match
     * any of the above criteria will not be included in a search with location
     * filter. Furthermore, any [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is
     * WORK or SCHOOL or where [Address.current][google.cloud.talent.v4beta1.Address.current] is false are not considered for
     * location filter.
     * If a location filter isn't specified, profiles fitting the other search
     * criteria are retrieved regardless of where they're located.
     * If [LocationFilter.negated][google.cloud.talent.v4beta1.LocationFilter.negated] is specified, the result doesn't contain
     * profiles from that location.
     * If [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] is provided, the
     * [LocationType][google.cloud.talent.v4beta1.Location.LocationType], center
     * point (latitude and longitude), and radius are automatically detected by
     * the Google Maps Geocoding API and included as well. If
     * [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] cannot be geocoded, the filter
     * falls back to keyword search.
     * If the detected
     * [LocationType][google.cloud.talent.v4beta1.Location.LocationType] is
     * [LocationType.SUB_ADMINISTRATIVE_AREA][google.cloud.talent.v4beta1.Location.LocationType.SUB_ADMINISTRATIVE_AREA],
     * [LocationType.ADMINISTRATIVE_AREA][google.cloud.talent.v4beta1.Location.LocationType.ADMINISTRATIVE_AREA],
     * or
     * [LocationType.COUNTRY][google.cloud.talent.v4beta1.Location.LocationType.COUNTRY],
     * the filter is performed against the detected location name (using exact
     * text matching). Otherwise, the filter is performed against the detected
     * center point and a radius of detected location radius +
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles].
     * If [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] is provided,
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is the additional radius on top of the
     * radius of the location geocoded from [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address]. If
     * [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] is provided,
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is the only radius that is used.
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is 10 by default. Note that the value
     * of [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is 0 if it is unset, so the server
     * does not differentiate [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] that is
     * explicitly set to 0 and [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] that is not
     * set. Which means that if [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is explicitly
     * set to 0, the server will use the default value of
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] which is 10. To work around this and
     * effectively set [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] to 0, we recommend
     * setting [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] to a very small decimal number
     * (such as 0.00001).
     * If [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is negative, an error is thrown.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.LocationFilter location_filters = 2;</code>
     * @param \Google\Cloud\Talent\V4beta1\LocationFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLocationFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\LocationFilter::class);
        $this->location_filters = $arr;

        return $this;
    }

    /**
     * Job title filter specifies job titles of profiles to match on.
     * If a job title isn't specified, profiles with any titles are retrieved.
     * If multiple values are specified, profiles are retrieved with any of the
     * specified job titles.
     * If [JobTitleFilter.negated][google.cloud.talent.v4beta1.JobTitleFilter.negated] is specified, the result won't contain
     * profiles with the job titles.
     * For example, search for profiles with a job title "Product Manager".
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.JobTitleFilter job_title_filters = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getJobTitleFilters()
    {
        return $this->job_title_filters;
    }

    /**
     * Job title filter specifies job titles of profiles to match on.
     * If a job title isn't specified, profiles with any titles are retrieved.
     * If multiple values are specified, profiles are retrieved with any of the
     * specified job titles.
     * If [JobTitleFilter.negated][google.cloud.talent.v4beta1.JobTitleFilter.negated] is specified, the result won't contain
     * profiles with the job titles.
     * For example, search for profiles with a job title "Product Manager".
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.JobTitleFilter job_title_filters = 3;</code>
     * @param \Google\Cloud\Talent\V4beta1\JobTitleFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setJobTitleFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\JobTitleFilter::class);
        $this->job_title_filters = $arr;

        return $this;
    }

    /**
     * Employer filter specifies employers of profiles to match on.
     * If an employer filter isn't specified, profiles with any employers are
     * retrieved.
     * If multiple employer filters are specified, profiles with any matching
     * employers are retrieved.
     * If [EmployerFilter.negated][google.cloud.talent.v4beta1.EmployerFilter.negated] is specified, the result won't contain
     * profiles that match the employers.
     * For example, search for profiles that have working experience at "Google
     * LLC".
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EmployerFilter employer_filters = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEmployerFilters()
    {
        return $this->employer_filters;
    }

    /**
     * Employer filter specifies employers of profiles to match on.
     * If an employer filter isn't specified, profiles with any employers are
     * retrieved.
     * If multiple employer filters are specified, profiles with any matching
     * employers are retrieved.
     * If [EmployerFilter.negated][google.cloud.talent.v4beta1.EmployerFilter.negated] is specified, the result won't contain
     * profiles that match the employers.
     * For example, search for profiles that have working experience at "Google
     * LLC".
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EmployerFilter employer_filters = 4;</code>
     * @param \Google\Cloud\Talent\V4beta1\EmployerFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEmployerFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\EmployerFilter::class);
        $this->employer_filters = $arr;

        return $this;
    }

    /**
     * Education filter specifies education of profiles to match on.
     * If an education filter isn't specified, profiles with any education are
     * retrieved.
     * If multiple education filters are specified, profiles that match any
     * education filters are retrieved.
     * If [EducationFilter.negated][google.cloud.talent.v4beta1.EducationFilter.negated] is specified, the result won't contain
     * profiles that match the educations.
     * For example, search for profiles with a master degree.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EducationFilter education_filters = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEducationFilters()
    {
        return $this->education_filters;
    }

    /**
     * Education filter specifies education of profiles to match on.
     * If an education filter isn't specified, profiles with any education are
     * retrieved.
     * If multiple education filters are specified, profiles that match any
     * education filters are retrieved.
     * If [EducationFilter.negated][google.cloud.talent.v4beta1.EducationFilter.negated] is specified, the result won't contain
     * profiles that match the educations.
     * For example, search for profiles with a master degree.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EducationFilter education_filters = 5;</code>
     * @param \Google\Cloud\Talent\V4beta1\EducationFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEducationFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\EducationFilter::class);
        $this->education_filters = $arr;

        return $this;
    }

    /**
     * Skill filter specifies skill of profiles to match on.
     * If a skill filter isn't specified, profiles with any skills are retrieved.
     * If multiple skill filters are specified, profiles that match any skill
     * filters are retrieved.
     * If [SkillFilter.negated][google.cloud.talent.v4beta1.SkillFilter.negated] is specified, the result won't contain profiles
     * that match the skills.
     * For example, search for profiles that have "Java" and "Python" in skill
     * list.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.SkillFilter skill_filters = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSkillFilters()
    {
        return $this->skill_filters;
    }

    /**
     * Skill filter specifies skill of profiles to match on.
     * If a skill filter isn't specified, profiles with any skills are retrieved.
     * If multiple skill filters are specified, profiles that match any skill
     * filters are retrieved.
     * If [SkillFilter.negated][google.cloud.talent.v4beta1.SkillFilter.negated] is specified, the result won't contain profiles
     * that match the skills.
     * For example, search for profiles that have "Java" and "Python" in skill
     * list.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.SkillFilter skill_filters = 6;</code>
     * @param \Google\Cloud\Talent\V4beta1\SkillFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSkillFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\SkillFilter::class);
        $this->skill_filters = $arr;

        return $this;
    }

    /**
     * Work experience filter specifies the total working experience of profiles
     * to match on.
     * If a work experience filter isn't specified, profiles with any
     * professional experience are retrieved.
     * If multiple work experience filters are specified, profiles that match any
     * work experience filters are retrieved.
     * For example, search for profiles with 10 years of work experience.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.WorkExperienceFilter work_experience_filter = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getWorkExperienceFilter()
    {
        return $this->work_experience_filter;
    }

    /**
     * Work experience filter specifies the total working experience of profiles
     * to match on.
     * If a work experience filter isn't specified, profiles with any
     * professional experience are retrieved.
     * If multiple work experience filters are specified, profiles that match any
     * work experience filters are retrieved.
     * For example, search for profiles with 10 years of work experience.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.WorkExperienceFilter work_experience_filter = 7;</code>
     * @param \Google\Cloud\Talent\V4beta1\WorkExperienceFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setWorkExperienceFilter($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\WorkExperienceFilter::class);
        $this->work_experience_filter = $arr;

        return $this;
    }

    /**
     * Time filter specifies the create/update timestamp of the profiles to match
     * on.
     * For example, search for profiles created since "2018-1-1".
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.TimeFilter time_filters = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTimeFilters()
    {
        return $this->time_filters;
    }

    /**
     * Time filter specifies the create/update timestamp of the profiles to match
     * on.
     * For example, search for profiles created since "2018-1-1".
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.TimeFilter time_filters = 8;</code>
     * @param \Google\Cloud\Talent\V4beta1\TimeFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTimeFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\TimeFilter::class);
        $this->time_filters = $arr;

        return $this;
    }

    /**
     * The hirable filter specifies the profile's hirable status to match on.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue hirable_filter = 9;</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getHirableFilter()
    {
        return $this->hirable_filter;
    }

    public function hasHirableFilter()
    {
        return isset($this->hirable_filter);
    }

    public function clearHirableFilter()
    {
        unset($this->hirable_filter);
    }

    /**
     * Returns the unboxed value from <code>getHirableFilter()</code>

     * The hirable filter specifies the profile's hirable status to match on.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue hirable_filter = 9;</code>
     * @return bool|null
     */
    public function getHirableFilterValue()
    {
        return $this->readWrapperValue("hirable_filter");
    }

    /**
     * The hirable filter specifies the profile's hirable status to match on.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue hirable_filter = 9;</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setHirableFilter($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->hirable_filter = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * The hirable filter specifies the profile's hirable status to match on.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue hirable_filter = 9;</code>
     * @param bool|null $var
     * @return $this
     */
    public function setHirableFilterValue($var)
    {
        $this->writeWrapperValue("hirable_filter", $var);
        return $this;}

    /**
     * The application date filters specify application date ranges to match on.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.ApplicationDateFilter application_date_filters = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getApplicationDateFilters()
    {
        return $this->application_date_filters;
    }

    /**
     * The application date filters specify application date ranges to match on.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.ApplicationDateFilter application_date_filters = 10;</code>
     * @param \Google\Cloud\Talent\V4beta1\ApplicationDateFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setApplicationDateFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\ApplicationDateFilter::class);
        $this->application_date_filters = $arr;

        return $this;
    }

    /**
     * The application outcome notes filters specify the notes for the outcome of
     * the job application.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.ApplicationOutcomeNotesFilter application_outcome_notes_filters = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getApplicationOutcomeNotesFilters()
    {
        return $this->application_outcome_notes_filters;
    }

    /**
     * The application outcome notes filters specify the notes for the outcome of
     * the job application.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.ApplicationOutcomeNotesFilter application_outcome_notes_filters = 11;</code>
     * @param \Google\Cloud\Talent\V4beta1\ApplicationOutcomeNotesFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setApplicationOutcomeNotesFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\ApplicationOutcomeNotesFilter::class);
        $this->application_outcome_notes_filters = $arr;

        return $this;
    }

    /**
     * The application job filters specify the job applied for in the application.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.ApplicationJobFilter application_job_filters = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getApplicationJobFilters()
    {
        return $this->application_job_filters;
    }

    /**
     * The application job filters specify the job applied for in the application.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.ApplicationJobFilter application_job_filters = 13;</code>
     * @param \Google\Cloud\Talent\V4beta1\ApplicationJobFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setApplicationJobFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\ApplicationJobFilter::class);
        $this->application_job_filters = $arr;

        return $this;
    }

    /**
     * This filter specifies a structured syntax to match against the
     * [Profile.custom_attributes][google.cloud.talent.v4beta1.Profile.custom_attributes] that are marked as `filterable`.
     * The syntax for this expression is a subset of Google SQL syntax.
     * String custom attributes: supported operators are =, != where the left of
     * the operator is a custom field key and the right of the operator is a
     * string (surrounded by quotes) value.
     * Numeric custom attributes: Supported operators are '>', '<' or '='
     * operators where the left of the operator is a custom field key and the
     * right of the operator is a numeric value.
     * Supported functions are LOWER(<field_name>) to
     * perform case insensitive match and EMPTY(<field_name>) to filter on the
     * existence of a key.
     * Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
     * nesting (for example "((A AND B AND C) OR NOT D) AND E"), and there can be
     * a maximum of 50 comparisons/functions in the expression. The expression
     * must be < 2000 characters in length.
     * Sample Query:
     * (key1 = "TEST" OR LOWER(key1)="test" OR NOT EMPTY(key1))
     *
     * Generated from protobuf field <code>string custom_attribute_filter = 15;</code>
     * @return string
     */
    public function getCustomAttributeFilter()
    {
        return $this->custom_attribute_filter;
    }

    /**
     * This filter specifies a structured syntax to match against the
     * [Profile.custom_attributes][google.cloud.talent.v4beta1.Profile.custom_attributes] that are marked as `filterable`.
     * The syntax for this expression is a subset of Google SQL syntax.
     * String custom attributes: supported operators are =, != where the left of
     * the operator is a custom field key and the right of the operator is a
     * string (surrounded by quotes) value.
     * Numeric custom attributes: Supported operators are '>', '<' or '='
     * operators where the left of the operator is a custom field key and the
     * right of the operator is a numeric value.
     * Supported functions are LOWER(<field_name>) to
     * perform case insensitive match and EMPTY(<field_name>) to filter on the
     * existence of a key.
     * Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
     * nesting (for example "((A AND B AND C) OR NOT D) AND E"), and there can be
     * a maximum of 50 comparisons/functions in the expression. The expression
     * must be < 2000 characters in length.
     * Sample Query:
     * (key1 = "TEST" OR LOWER(key1)="test" OR NOT EMPTY(key1))
     *
     * Generated from protobuf field <code>string custom_attribute_filter = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomAttributeFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_attribute_filter = $var;

        return $this;
    }

    /**
     * Deprecated. Use availability_filters instead.
     * The candidate availability filter which filters based on availability
     * signals.
     * Signal 1: Number of days since most recent job application.  See
     * [Availability.JobApplicationAvailabilitySignal][google.cloud.talent.v4beta1.Availability.JobApplicationAvailabilitySignal] for the details of this
     * signal.
     * Signal 2: Number of days since last profile update. See
     * [Availability.ProfileUpdateAvailabilitySignal][google.cloud.talent.v4beta1.Availability.ProfileUpdateAvailabilitySignal]
     * for the details of this signal.
     * The candidate availability filter helps a recruiter understand if a
     * specific candidate is likely to be actively seeking new job opportunities
     * based on an aggregated set of signals.  Specifically, the intent is NOT to
     * indicate the candidate's potential qualification / interest / close ability
     * for a specific job.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.CandidateAvailabilityFilter candidate_availability_filter = 16 [deprecated = true];</code>
     * @return \Google\Cloud\Talent\V4beta1\CandidateAvailabilityFilter|null
     * @deprecated
     */
    public function getCandidateAvailabilityFilter()
    {
        @trigger_error('candidate_availability_filter is deprecated.', E_USER_DEPRECATED);
        return $this->candidate_availability_filter;
    }

    public function hasCandidateAvailabilityFilter()
    {
        @trigger_error('candidate_availability_filter is deprecated.', E_USER_DEPRECATED);
        return isset($this->candidate_availability_filter);
    }

    public function clearCandidateAvailabilityFilter()
    {
        @trigger_error('candidate_availability_filter is deprecated.', E_USER_DEPRECATED);
        unset($this->candidate_availability_filter);
    }

    /**
     * Deprecated. Use availability_filters instead.
     * The candidate availability filter which filters based on availability
     * signals.
     * Signal 1: Number of days since most recent job application.  See
     * [Availability.JobApplicationAvailabilitySignal][google.cloud.talent.v4beta1.Availability.JobApplicationAvailabilitySignal] for the details of this
     * signal.
     * Signal 2: Number of days since last profile update. See
     * [Availability.ProfileUpdateAvailabilitySignal][google.cloud.talent.v4beta1.Availability.ProfileUpdateAvailabilitySignal]
     * for the details of this signal.
     * The candidate availability filter helps a recruiter understand if a
     * specific candidate is likely to be actively seeking new job opportunities
     * based on an aggregated set of signals.  Specifically, the intent is NOT to
     * indicate the candidate's potential qualification / interest / close ability
     * for a specific job.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.CandidateAvailabilityFilter candidate_availability_filter = 16 [deprecated = true];</code>
     * @param \Google\Cloud\Talent\V4beta1\CandidateAvailabilityFilter $var
     * @return $this
     * @deprecated
     */
    public function setCandidateAvailabilityFilter($var)
    {
        @trigger_error('candidate_availability_filter is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4beta1\CandidateAvailabilityFilter::class);
        $this->candidate_availability_filter = $var;

        return $this;
    }

    /**
     * The availability filter which filters based on
     * [Profile.availability_signals][google.cloud.talent.v4beta1.Profile.availability_signals].
     * The availability filter helps a recruiter understand if a
     * specific candidate is likely to be actively seeking new job opportunities
     * based on an aggregated set of signals.  Specifically, the intent is NOT to
     * indicate the candidate's potential qualification / interest / close ability
     * for a specific job.
     * There can be at most one [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter] per
     * [signal_type][google.cloud.talent.v4beta1.AvailabilityFilter.signal_type]. If there are multiple
     * [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter] for a [signal_type][google.cloud.talent.v4beta1.AvailabilityFilter.signal_type],
     * an error is thrown.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.AvailabilityFilter availability_filters = 18;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAvailabilityFilters()
    {
        return $this->availability_filters;
    }

    /**
     * The availability filter which filters based on
     * [Profile.availability_signals][google.cloud.talent.v4beta1.Profile.availability_signals].
     * The availability filter helps a recruiter understand if a
     * specific candidate is likely to be actively seeking new job opportunities
     * based on an aggregated set of signals.  Specifically, the intent is NOT to
     * indicate the candidate's potential qualification / interest / close ability
     * for a specific job.
     * There can be at most one [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter] per
     * [signal_type][google.cloud.talent.v4beta1.AvailabilityFilter.signal_type]. If there are multiple
     * [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter] for a [signal_type][google.cloud.talent.v4beta1.AvailabilityFilter.signal_type],
     * an error is thrown.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.AvailabilityFilter availability_filters = 18;</code>
     * @param \Google\Cloud\Talent\V4beta1\AvailabilityFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAvailabilityFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\AvailabilityFilter::class);
        $this->availability_filters = $arr;

        return $this;
    }

    /**
     * Person name filter specifies person name of profiles to match on.
     * If multiple person name filters are specified, profiles that match any
     * person name filters are retrieved.
     * For example, search for profiles of candidates with name "John Smith".
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonNameFilter person_name_filters = 17;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPersonNameFilters()
    {
        return $this->person_name_filters;
    }

    /**
     * Person name filter specifies person name of profiles to match on.
     * If multiple person name filters are specified, profiles that match any
     * person name filters are retrieved.
     * For example, search for profiles of candidates with name "John Smith".
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonNameFilter person_name_filters = 17;</code>
     * @param \Google\Cloud\Talent\V4beta1\PersonNameFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPersonNameFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\PersonNameFilter::class);
        $this->person_name_filters = $arr;

        return $this;
    }

}

