<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/eventarc/v1/eventarc.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Eventarc\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;

use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Eventarc\V1\CreateTriggerRequest;
use Google\Cloud\Eventarc\V1\DeleteTriggerRequest;
use Google\Cloud\Eventarc\V1\GetTriggerRequest;
use Google\Cloud\Eventarc\V1\ListTriggersRequest;
use Google\Cloud\Eventarc\V1\ListTriggersResponse;
use Google\Cloud\Eventarc\V1\Trigger;
use Google\Cloud\Eventarc\V1\UpdateTriggerRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Eventarc allows users to subscribe to various events that are provided by
 * Google Cloud services and forward them to supported destinations.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $eventarcClient = new EventarcClient();
 * try {
 *     $formattedParent = $eventarcClient->locationName('[PROJECT]', '[LOCATION]');
 *     $trigger = new Trigger();
 *     $triggerId = 'trigger_id';
 *     $validateOnly = false;
 *     $operationResponse = $eventarcClient->createTrigger($formattedParent, $trigger, $triggerId, $validateOnly);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $eventarcClient->createTrigger($formattedParent, $trigger, $triggerId, $validateOnly);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'createTrigger');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $eventarcClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class EventarcGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.eventarc.v1.Eventarc';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'eventarc.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $locationNameTemplate;

    private static $serviceAccountNameTemplate;

    private static $triggerNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/eventarc_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/eventarc_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/eventarc_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/eventarc_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getServiceAccountNameTemplate()
    {
        if (self::$serviceAccountNameTemplate == null) {
            self::$serviceAccountNameTemplate = new PathTemplate(
                'projects/{project}/serviceAccounts/{service_account}'
            );
        }

        return self::$serviceAccountNameTemplate;
    }

    private static function getTriggerNameTemplate()
    {
        if (self::$triggerNameTemplate == null) {
            self::$triggerNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/triggers/{trigger}'
            );
        }

        return self::$triggerNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'location' => self::getLocationNameTemplate(),
                'serviceAccount' => self::getServiceAccountNameTemplate(),
                'trigger' => self::getTriggerNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_account resource.
     *
     * @param string $project
     * @param string $serviceAccount
     *
     * @return string The formatted service_account resource.
     */
    public static function serviceAccountName($project, $serviceAccount)
    {
        return self::getServiceAccountNameTemplate()->render([
            'project' => $project,
            'service_account' => $serviceAccount,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a trigger
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $trigger
     *
     * @return string The formatted trigger resource.
     */
    public static function triggerName($project, $location, $trigger)
    {
        return self::getTriggerNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'trigger' => $trigger,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - location: projects/{project}/locations/{location}
     * - serviceAccount: projects/{project}/serviceAccounts/{service_account}
     * - trigger: projects/{project}/locations/{location}/triggers/{trigger}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'eventarc.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Create a new trigger in a particular project and location.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedParent = $eventarcClient->locationName('[PROJECT]', '[LOCATION]');
     *     $trigger = new Trigger();
     *     $triggerId = 'trigger_id';
     *     $validateOnly = false;
     *     $operationResponse = $eventarcClient->createTrigger($formattedParent, $trigger, $triggerId, $validateOnly);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $eventarcClient->createTrigger($formattedParent, $trigger, $triggerId, $validateOnly);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'createTrigger');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The parent collection in which to add this trigger.
     * @param Trigger $trigger      Required. The trigger to create.
     * @param string  $triggerId    Required. The user-provided ID to be assigned to the trigger.
     * @param bool    $validateOnly Required. If set, validate the request and preview the review, but do not actually
     *                              post it.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createTrigger(
        $parent,
        $trigger,
        $triggerId,
        $validateOnly,
        array $optionalArgs = []
    ) {
        $request = new CreateTriggerRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTrigger($trigger);
        $request->setTriggerId($triggerId);
        $request->setValidateOnly($validateOnly);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateTrigger',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Delete a single trigger.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedName = $eventarcClient->triggerName('[PROJECT]', '[LOCATION]', '[TRIGGER]');
     *     $validateOnly = false;
     *     $operationResponse = $eventarcClient->deleteTrigger($formattedName, $validateOnly);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $eventarcClient->deleteTrigger($formattedName, $validateOnly);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'deleteTrigger');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the trigger to be deleted.
     * @param bool   $validateOnly Required. If set, validate the request and preview the review, but do not actually
     *                             post it.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           If provided, the trigger will only be deleted if the etag matches the
     *           current etag on the resource.
     *     @type bool $allowMissing
     *           If set to true, and the trigger is not found, the request will succeed
     *           but no action will be taken on the server.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTrigger(
        $name,
        $validateOnly,
        array $optionalArgs = []
    ) {
        $request = new DeleteTriggerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setValidateOnly($validateOnly);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteTrigger',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Get a single trigger.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedName = $eventarcClient->triggerName('[PROJECT]', '[LOCATION]', '[TRIGGER]');
     *     $response = $eventarcClient->getTrigger($formattedName);
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the trigger to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Eventarc\V1\Trigger
     *
     * @throws ApiException if the remote call fails
     */
    public function getTrigger($name, array $optionalArgs = [])
    {
        $request = new GetTriggerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTrigger',
            Trigger::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * List triggers.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedParent = $eventarcClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $eventarcClient->listTriggers($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $eventarcClient->listTriggers($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent collection to list triggers on.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           The sorting order of the resources returned. Value should be a comma
     *           separated list of fields. The default sorting oder is ascending. To specify
     *           descending order for a field, append a ` desc` suffix; for example:
     *           `name desc, trigger_id`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTriggers($parent, array $optionalArgs = [])
    {
        $request = new ListTriggersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListTriggers',
            $optionalArgs,
            ListTriggersResponse::class,
            $request
        );
    }

    /**
     * Update a single trigger.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $validateOnly = false;
     *     $operationResponse = $eventarcClient->updateTrigger($validateOnly);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $eventarcClient->updateTrigger($validateOnly);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'updateTrigger');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param bool  $validateOnly Required. If set, validate the request and preview the review, but do not actually
     *                            post it.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type Trigger $trigger
     *           The trigger to be updated.
     *     @type FieldMask $updateMask
     *           The fields to be updated; only fields explicitly provided will be updated.
     *           If no field mask is provided, all provided fields in the request will be
     *           updated. To update all fields, provide a field mask of "*".
     *     @type bool $allowMissing
     *           If set to true, and the trigger is not found, a new trigger will be
     *           created. In this situation, `update_mask` is ignored.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTrigger($validateOnly, array $optionalArgs = [])
    {
        $request = new UpdateTriggerRequest();
        $requestParamHeaders = [];
        $request->setValidateOnly($validateOnly);
        if (isset($optionalArgs['trigger'])) {
            $request->setTrigger($optionalArgs['trigger']);
        }

        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateTrigger',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }
}
