<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/storagetransfer/v1/transfer_types.proto

namespace Google\Cloud\StorageTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * In a GcsData resource, an object's name is the Cloud Storage object's
 * name and its "last modification time" refers to the object's `updated`
 * property of Cloud Storage objects, which changes when the content or the
 * metadata of the object is updated.
 *
 * Generated from protobuf message <code>google.storagetransfer.v1.GcsData</code>
 */
class GcsData extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Cloud Storage bucket name. Must meet
     * [Bucket Name Requirements](/storage/docs/naming#requirements).
     *
     * Generated from protobuf field <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $bucket_name = '';
    /**
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * The root path value must meet
     * [Object Name Requirements](/storage/docs/naming#objectnames).
     *
     * Generated from protobuf field <code>string path = 3;</code>
     */
    protected $path = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $bucket_name
     *           Required. Cloud Storage bucket name. Must meet
     *           [Bucket Name Requirements](/storage/docs/naming#requirements).
     *     @type string $path
     *           Root path to transfer objects.
     *           Must be an empty string or full path name that ends with a '/'. This field
     *           is treated as an object prefix. As such, it should generally not begin with
     *           a '/'.
     *           The root path value must meet
     *           [Object Name Requirements](/storage/docs/naming#objectnames).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Storagetransfer\V1\TransferTypes::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Cloud Storage bucket name. Must meet
     * [Bucket Name Requirements](/storage/docs/naming#requirements).
     *
     * Generated from protobuf field <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getBucketName()
    {
        return $this->bucket_name;
    }

    /**
     * Required. Cloud Storage bucket name. Must meet
     * [Bucket Name Requirements](/storage/docs/naming#requirements).
     *
     * Generated from protobuf field <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setBucketName($var)
    {
        GPBUtil::checkString($var, True);
        $this->bucket_name = $var;

        return $this;
    }

    /**
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * The root path value must meet
     * [Object Name Requirements](/storage/docs/naming#objectnames).
     *
     * Generated from protobuf field <code>string path = 3;</code>
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * The root path value must meet
     * [Object Name Requirements](/storage/docs/naming#objectnames).
     *
     * Generated from protobuf field <code>string path = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->path = $var;

        return $this;
    }

}

