<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/video/livestream/v1/resources.proto

namespace Google\Cloud\Video\LiveStream\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Event is a sub-resource of a channel, which can be scheduled by the user to
 * execute operations on a channel resource without having to stop the channel.
 *
 * Generated from protobuf message <code>google.cloud.video.livestream.v1.Event</code>
 */
class Event extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the event, in the form of:
     * `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * User-defined key/value metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * When this field is set to true, the event will be executed at the earliest
     * time that the server can schedule the event and [execution_time][google.cloud.video.livestream.v1.Event.execution_time] will be
     * populated with the time that the server actually schedules the event.
     *
     * Generated from protobuf field <code>bool execute_now = 9;</code>
     */
    private $execute_now = false;
    /**
     * The time when the event should be executed. When [execute_now][google.cloud.video.livestream.v1.Event.execute_now] is set to
     * `true`, this field should not be set in `CreateEvent` request and will be
     * populated with the time that the server schedules the event.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp execution_time = 10;</code>
     */
    private $execution_time = null;
    /**
     * Output only. The state of the event.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $error = null;
    protected $task;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the event, in the form of:
     *           `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation time.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The update time.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           User-defined key/value metadata.
     *     @type \Google\Cloud\Video\LiveStream\V1\Event\AdBreakTask $ad_break
     *           Required. Inserts a new ad opportunity.
     *     @type bool $execute_now
     *           When this field is set to true, the event will be executed at the earliest
     *           time that the server can schedule the event and [execution_time][google.cloud.video.livestream.v1.Event.execution_time] will be
     *           populated with the time that the server actually schedules the event.
     *     @type \Google\Protobuf\Timestamp $execution_time
     *           The time when the event should be executed. When [execute_now][google.cloud.video.livestream.v1.Event.execute_now] is set to
     *           `true`, this field should not be set in `CreateEvent` request and will be
     *           populated with the time that the server schedules the event.
     *     @type int $state
     *           Output only. The state of the event.
     *     @type \Google\Rpc\Status $error
     *           Output only. An error object that describes the reason for the failure.
     *           This property is always present when `state` is `FAILED`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Video\Livestream\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the event, in the form of:
     * `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the event, in the form of:
     * `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * User-defined key/value metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * User-defined key/value metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Required. Inserts a new ad opportunity.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.AdBreakTask ad_break = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Video\LiveStream\V1\Event\AdBreakTask|null
     */
    public function getAdBreak()
    {
        return $this->readOneof(6);
    }

    public function hasAdBreak()
    {
        return $this->hasOneof(6);
    }

    /**
     * Required. Inserts a new ad opportunity.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.AdBreakTask ad_break = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Video\LiveStream\V1\Event\AdBreakTask $var
     * @return $this
     */
    public function setAdBreak($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\LiveStream\V1\Event\AdBreakTask::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * When this field is set to true, the event will be executed at the earliest
     * time that the server can schedule the event and [execution_time][google.cloud.video.livestream.v1.Event.execution_time] will be
     * populated with the time that the server actually schedules the event.
     *
     * Generated from protobuf field <code>bool execute_now = 9;</code>
     * @return bool
     */
    public function getExecuteNow()
    {
        return $this->execute_now;
    }

    /**
     * When this field is set to true, the event will be executed at the earliest
     * time that the server can schedule the event and [execution_time][google.cloud.video.livestream.v1.Event.execution_time] will be
     * populated with the time that the server actually schedules the event.
     *
     * Generated from protobuf field <code>bool execute_now = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setExecuteNow($var)
    {
        GPBUtil::checkBool($var);
        $this->execute_now = $var;

        return $this;
    }

    /**
     * The time when the event should be executed. When [execute_now][google.cloud.video.livestream.v1.Event.execute_now] is set to
     * `true`, this field should not be set in `CreateEvent` request and will be
     * populated with the time that the server schedules the event.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp execution_time = 10;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExecutionTime()
    {
        return $this->execution_time;
    }

    public function hasExecutionTime()
    {
        return isset($this->execution_time);
    }

    public function clearExecutionTime()
    {
        unset($this->execution_time);
    }

    /**
     * The time when the event should be executed. When [execute_now][google.cloud.video.livestream.v1.Event.execute_now] is set to
     * `true`, this field should not be set in `CreateEvent` request and will be
     * populated with the time that the server schedules the event.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp execution_time = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExecutionTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->execution_time = $var;

        return $this;
    }

    /**
     * Output only. The state of the event.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the event.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Video\LiveStream\V1\Event\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\Status|null
     */
    public function getError()
    {
        return $this->error;
    }

    public function hasError()
    {
        return isset($this->error);
    }

    public function clearError()
    {
        unset($this->error);
    }

    /**
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->error = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTask()
    {
        return $this->whichOneof("task");
    }

}

