<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/reservation/v1/reservation.proto

namespace Google\Cloud\BigQuery\Reservation\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A reservation is a mechanism used to guarantee slots to users.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.reservation.v1.Reservation</code>
 */
class Reservation extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Minimum slots available to this reservation. A slot is a unit of
     * computational power in BigQuery, and serves as the unit of parallelism.
     * Queries using this reservation might use more slots during runtime if
     * ignore_idle_slots is set to false.
     * If the new reservation's slot capacity exceed the parent's slot capacity or
     * if total slot capacity of the new reservation and its siblings exceeds the
     * parent's slot capacity, the request will fail with
     * `google.rpc.Code.RESOURCE_EXHAUSTED`.
     *
     * Generated from protobuf field <code>int64 slot_capacity = 2;</code>
     */
    private $slot_capacity = 0;
    /**
     * If false, any query or pipeline job using this reservation will use idle
     * slots from other reservations within the same admin project. If true, a
     * query or pipeline job using this reservation will execute with the slot
     * capacity specified in the slot_capacity field at most.
     *
     * Generated from protobuf field <code>bool ignore_idle_slots = 4;</code>
     */
    private $ignore_idle_slots = false;
    /**
     * Output only. Creation time of the reservation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $creation_time = null;
    /**
     * Output only. Last update time of the reservation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the reservation, e.g.,
     *           `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     *     @type int|string $slot_capacity
     *           Minimum slots available to this reservation. A slot is a unit of
     *           computational power in BigQuery, and serves as the unit of parallelism.
     *           Queries using this reservation might use more slots during runtime if
     *           ignore_idle_slots is set to false.
     *           If the new reservation's slot capacity exceed the parent's slot capacity or
     *           if total slot capacity of the new reservation and its siblings exceeds the
     *           parent's slot capacity, the request will fail with
     *           `google.rpc.Code.RESOURCE_EXHAUSTED`.
     *     @type bool $ignore_idle_slots
     *           If false, any query or pipeline job using this reservation will use idle
     *           slots from other reservations within the same admin project. If true, a
     *           query or pipeline job using this reservation will execute with the slot
     *           capacity specified in the slot_capacity field at most.
     *     @type \Google\Protobuf\Timestamp $creation_time
     *           Output only. Creation time of the reservation.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Last update time of the reservation.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Reservation\V1\Reservation::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Minimum slots available to this reservation. A slot is a unit of
     * computational power in BigQuery, and serves as the unit of parallelism.
     * Queries using this reservation might use more slots during runtime if
     * ignore_idle_slots is set to false.
     * If the new reservation's slot capacity exceed the parent's slot capacity or
     * if total slot capacity of the new reservation and its siblings exceeds the
     * parent's slot capacity, the request will fail with
     * `google.rpc.Code.RESOURCE_EXHAUSTED`.
     *
     * Generated from protobuf field <code>int64 slot_capacity = 2;</code>
     * @return int|string
     */
    public function getSlotCapacity()
    {
        return $this->slot_capacity;
    }

    /**
     * Minimum slots available to this reservation. A slot is a unit of
     * computational power in BigQuery, and serves as the unit of parallelism.
     * Queries using this reservation might use more slots during runtime if
     * ignore_idle_slots is set to false.
     * If the new reservation's slot capacity exceed the parent's slot capacity or
     * if total slot capacity of the new reservation and its siblings exceeds the
     * parent's slot capacity, the request will fail with
     * `google.rpc.Code.RESOURCE_EXHAUSTED`.
     *
     * Generated from protobuf field <code>int64 slot_capacity = 2;</code>
     * @param int|string $var
     * @return $this
     */
    public function setSlotCapacity($var)
    {
        GPBUtil::checkInt64($var);
        $this->slot_capacity = $var;

        return $this;
    }

    /**
     * If false, any query or pipeline job using this reservation will use idle
     * slots from other reservations within the same admin project. If true, a
     * query or pipeline job using this reservation will execute with the slot
     * capacity specified in the slot_capacity field at most.
     *
     * Generated from protobuf field <code>bool ignore_idle_slots = 4;</code>
     * @return bool
     */
    public function getIgnoreIdleSlots()
    {
        return $this->ignore_idle_slots;
    }

    /**
     * If false, any query or pipeline job using this reservation will use idle
     * slots from other reservations within the same admin project. If true, a
     * query or pipeline job using this reservation will execute with the slot
     * capacity specified in the slot_capacity field at most.
     *
     * Generated from protobuf field <code>bool ignore_idle_slots = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setIgnoreIdleSlots($var)
    {
        GPBUtil::checkBool($var);
        $this->ignore_idle_slots = $var;

        return $this;
    }

    /**
     * Output only. Creation time of the reservation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreationTime()
    {
        return $this->creation_time;
    }

    public function hasCreationTime()
    {
        return isset($this->creation_time);
    }

    public function clearCreationTime()
    {
        unset($this->creation_time);
    }

    /**
     * Output only. Creation time of the reservation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreationTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->creation_time = $var;

        return $this;
    }

    /**
     * Output only. Last update time of the reservation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Last update time of the reservation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

}

