<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/video/stitcher/v1/sessions.proto

namespace Google\Cloud\Video\Stitcher\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Metadata for a VOD session. The session expires 4 hours after its creation.
 *
 * Generated from protobuf message <code>google.cloud.video.stitcher.v1.VodSession</code>
 */
class VodSession extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The name of the VOD session, in the form of
     * `projects/{project_number}/locations/{location}/vodSessions/{id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Output only. Metadata of what was stitched into the content.
     *
     * Generated from protobuf field <code>.google.cloud.video.stitcher.v1.Interstitials interstitials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $interstitials = null;
    /**
     * Output only. The playback URI of the stitched content.
     *
     * Generated from protobuf field <code>string play_uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $play_uri = '';
    /**
     * URI of the media to stitch. For most use cases, you should create a
     * [VodConfig][google.cloud.video.stitcher.v1.VodConfig] with this information
     * rather than setting this field directly.
     *
     * Generated from protobuf field <code>string source_uri = 5;</code>
     */
    protected $source_uri = '';
    /**
     * Ad tag URI. For most use cases, you should create a
     * [VodConfig][google.cloud.video.stitcher.v1.VodConfig] with this information
     * rather than setting this field directly.
     *
     * Generated from protobuf field <code>string ad_tag_uri = 6;</code>
     */
    protected $ad_tag_uri = '';
    /**
     * Key value pairs for ad tag macro replacement, only available for VOD
     * sessions that do not implement Google Ad manager ad insertion. If the
     * specified ad tag URI has macros, this field provides the mapping to the
     * value that will replace the macro in the ad tag URI.
     * Macros are designated by square brackets, for example:
     *   Ad tag URI: `"https://doubleclick.google.com/ad/1?geo_id=[geoId]"`
     *   Ad tag macro map: `{"geoId": "123"}`
     *   Fully qualified ad tag:
     *   `"https://doubleclick.google.com/ad/1?geo_id=123"`
     *
     * Generated from protobuf field <code>map<string, string> ad_tag_macro_map = 7;</code>
     */
    private $ad_tag_macro_map;
    /**
     * Additional options that affect the output of the manifest.
     *
     * Generated from protobuf field <code>.google.cloud.video.stitcher.v1.ManifestOptions manifest_options = 9;</code>
     */
    protected $manifest_options = null;
    /**
     * Output only. The generated ID of the VodSession's source media.
     *
     * Generated from protobuf field <code>string asset_id = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $asset_id = '';
    /**
     * Required. Determines how the ad should be tracked.
     *
     * Generated from protobuf field <code>.google.cloud.video.stitcher.v1.AdTracking ad_tracking = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $ad_tracking = 0;
    /**
     * This field should be set with appropriate values if GAM is being used for
     * ads.
     *
     * Generated from protobuf field <code>.google.cloud.video.stitcher.v1.VodSession.GamSettings gam_settings = 13;</code>
     */
    protected $gam_settings = null;
    /**
     * The resource name of the VOD config for this session, in the form of
     * `projects/{project}/locations/{location}/vodConfigs/{id}`.
     *
     * Generated from protobuf field <code>string vod_config = 14 [(.google.api.resource_reference) = {</code>
     */
    protected $vod_config = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The name of the VOD session, in the form of
     *           `projects/{project_number}/locations/{location}/vodSessions/{id}`.
     *     @type \Google\Cloud\Video\Stitcher\V1\Interstitials $interstitials
     *           Output only. Metadata of what was stitched into the content.
     *     @type string $play_uri
     *           Output only. The playback URI of the stitched content.
     *     @type string $source_uri
     *           URI of the media to stitch. For most use cases, you should create a
     *           [VodConfig][google.cloud.video.stitcher.v1.VodConfig] with this information
     *           rather than setting this field directly.
     *     @type string $ad_tag_uri
     *           Ad tag URI. For most use cases, you should create a
     *           [VodConfig][google.cloud.video.stitcher.v1.VodConfig] with this information
     *           rather than setting this field directly.
     *     @type array|\Google\Protobuf\Internal\MapField $ad_tag_macro_map
     *           Key value pairs for ad tag macro replacement, only available for VOD
     *           sessions that do not implement Google Ad manager ad insertion. If the
     *           specified ad tag URI has macros, this field provides the mapping to the
     *           value that will replace the macro in the ad tag URI.
     *           Macros are designated by square brackets, for example:
     *             Ad tag URI: `"https://doubleclick.google.com/ad/1?geo_id=[geoId]"`
     *             Ad tag macro map: `{"geoId": "123"}`
     *             Fully qualified ad tag:
     *             `"https://doubleclick.google.com/ad/1?geo_id=123"`
     *     @type \Google\Cloud\Video\Stitcher\V1\ManifestOptions $manifest_options
     *           Additional options that affect the output of the manifest.
     *     @type string $asset_id
     *           Output only. The generated ID of the VodSession's source media.
     *     @type int $ad_tracking
     *           Required. Determines how the ad should be tracked.
     *     @type \Google\Cloud\Video\Stitcher\V1\VodSession\GamSettings $gam_settings
     *           This field should be set with appropriate values if GAM is being used for
     *           ads.
     *     @type string $vod_config
     *           The resource name of the VOD config for this session, in the form of
     *           `projects/{project}/locations/{location}/vodConfigs/{id}`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Video\Stitcher\V1\Sessions::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The name of the VOD session, in the form of
     * `projects/{project_number}/locations/{location}/vodSessions/{id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The name of the VOD session, in the form of
     * `projects/{project_number}/locations/{location}/vodSessions/{id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Metadata of what was stitched into the content.
     *
     * Generated from protobuf field <code>.google.cloud.video.stitcher.v1.Interstitials interstitials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Video\Stitcher\V1\Interstitials|null
     */
    public function getInterstitials()
    {
        return $this->interstitials;
    }

    public function hasInterstitials()
    {
        return isset($this->interstitials);
    }

    public function clearInterstitials()
    {
        unset($this->interstitials);
    }

    /**
     * Output only. Metadata of what was stitched into the content.
     *
     * Generated from protobuf field <code>.google.cloud.video.stitcher.v1.Interstitials interstitials = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Video\Stitcher\V1\Interstitials $var
     * @return $this
     */
    public function setInterstitials($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\Stitcher\V1\Interstitials::class);
        $this->interstitials = $var;

        return $this;
    }

    /**
     * Output only. The playback URI of the stitched content.
     *
     * Generated from protobuf field <code>string play_uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPlayUri()
    {
        return $this->play_uri;
    }

    /**
     * Output only. The playback URI of the stitched content.
     *
     * Generated from protobuf field <code>string play_uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPlayUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->play_uri = $var;

        return $this;
    }

    /**
     * URI of the media to stitch. For most use cases, you should create a
     * [VodConfig][google.cloud.video.stitcher.v1.VodConfig] with this information
     * rather than setting this field directly.
     *
     * Generated from protobuf field <code>string source_uri = 5;</code>
     * @return string
     */
    public function getSourceUri()
    {
        return $this->source_uri;
    }

    /**
     * URI of the media to stitch. For most use cases, you should create a
     * [VodConfig][google.cloud.video.stitcher.v1.VodConfig] with this information
     * rather than setting this field directly.
     *
     * Generated from protobuf field <code>string source_uri = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_uri = $var;

        return $this;
    }

    /**
     * Ad tag URI. For most use cases, you should create a
     * [VodConfig][google.cloud.video.stitcher.v1.VodConfig] with this information
     * rather than setting this field directly.
     *
     * Generated from protobuf field <code>string ad_tag_uri = 6;</code>
     * @return string
     */
    public function getAdTagUri()
    {
        return $this->ad_tag_uri;
    }

    /**
     * Ad tag URI. For most use cases, you should create a
     * [VodConfig][google.cloud.video.stitcher.v1.VodConfig] with this information
     * rather than setting this field directly.
     *
     * Generated from protobuf field <code>string ad_tag_uri = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setAdTagUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->ad_tag_uri = $var;

        return $this;
    }

    /**
     * Key value pairs for ad tag macro replacement, only available for VOD
     * sessions that do not implement Google Ad manager ad insertion. If the
     * specified ad tag URI has macros, this field provides the mapping to the
     * value that will replace the macro in the ad tag URI.
     * Macros are designated by square brackets, for example:
     *   Ad tag URI: `"https://doubleclick.google.com/ad/1?geo_id=[geoId]"`
     *   Ad tag macro map: `{"geoId": "123"}`
     *   Fully qualified ad tag:
     *   `"https://doubleclick.google.com/ad/1?geo_id=123"`
     *
     * Generated from protobuf field <code>map<string, string> ad_tag_macro_map = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAdTagMacroMap()
    {
        return $this->ad_tag_macro_map;
    }

    /**
     * Key value pairs for ad tag macro replacement, only available for VOD
     * sessions that do not implement Google Ad manager ad insertion. If the
     * specified ad tag URI has macros, this field provides the mapping to the
     * value that will replace the macro in the ad tag URI.
     * Macros are designated by square brackets, for example:
     *   Ad tag URI: `"https://doubleclick.google.com/ad/1?geo_id=[geoId]"`
     *   Ad tag macro map: `{"geoId": "123"}`
     *   Fully qualified ad tag:
     *   `"https://doubleclick.google.com/ad/1?geo_id=123"`
     *
     * Generated from protobuf field <code>map<string, string> ad_tag_macro_map = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAdTagMacroMap($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->ad_tag_macro_map = $arr;

        return $this;
    }

    /**
     * Additional options that affect the output of the manifest.
     *
     * Generated from protobuf field <code>.google.cloud.video.stitcher.v1.ManifestOptions manifest_options = 9;</code>
     * @return \Google\Cloud\Video\Stitcher\V1\ManifestOptions|null
     */
    public function getManifestOptions()
    {
        return $this->manifest_options;
    }

    public function hasManifestOptions()
    {
        return isset($this->manifest_options);
    }

    public function clearManifestOptions()
    {
        unset($this->manifest_options);
    }

    /**
     * Additional options that affect the output of the manifest.
     *
     * Generated from protobuf field <code>.google.cloud.video.stitcher.v1.ManifestOptions manifest_options = 9;</code>
     * @param \Google\Cloud\Video\Stitcher\V1\ManifestOptions $var
     * @return $this
     */
    public function setManifestOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\Stitcher\V1\ManifestOptions::class);
        $this->manifest_options = $var;

        return $this;
    }

    /**
     * Output only. The generated ID of the VodSession's source media.
     *
     * Generated from protobuf field <code>string asset_id = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getAssetId()
    {
        return $this->asset_id;
    }

    /**
     * Output only. The generated ID of the VodSession's source media.
     *
     * Generated from protobuf field <code>string asset_id = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setAssetId($var)
    {
        GPBUtil::checkString($var, True);
        $this->asset_id = $var;

        return $this;
    }

    /**
     * Required. Determines how the ad should be tracked.
     *
     * Generated from protobuf field <code>.google.cloud.video.stitcher.v1.AdTracking ad_tracking = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getAdTracking()
    {
        return $this->ad_tracking;
    }

    /**
     * Required. Determines how the ad should be tracked.
     *
     * Generated from protobuf field <code>.google.cloud.video.stitcher.v1.AdTracking ad_tracking = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setAdTracking($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Video\Stitcher\V1\AdTracking::class);
        $this->ad_tracking = $var;

        return $this;
    }

    /**
     * This field should be set with appropriate values if GAM is being used for
     * ads.
     *
     * Generated from protobuf field <code>.google.cloud.video.stitcher.v1.VodSession.GamSettings gam_settings = 13;</code>
     * @return \Google\Cloud\Video\Stitcher\V1\VodSession\GamSettings|null
     */
    public function getGamSettings()
    {
        return $this->gam_settings;
    }

    public function hasGamSettings()
    {
        return isset($this->gam_settings);
    }

    public function clearGamSettings()
    {
        unset($this->gam_settings);
    }

    /**
     * This field should be set with appropriate values if GAM is being used for
     * ads.
     *
     * Generated from protobuf field <code>.google.cloud.video.stitcher.v1.VodSession.GamSettings gam_settings = 13;</code>
     * @param \Google\Cloud\Video\Stitcher\V1\VodSession\GamSettings $var
     * @return $this
     */
    public function setGamSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\Stitcher\V1\VodSession\GamSettings::class);
        $this->gam_settings = $var;

        return $this;
    }

    /**
     * The resource name of the VOD config for this session, in the form of
     * `projects/{project}/locations/{location}/vodConfigs/{id}`.
     *
     * Generated from protobuf field <code>string vod_config = 14 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getVodConfig()
    {
        return $this->vod_config;
    }

    /**
     * The resource name of the VOD config for this session, in the form of
     * `projects/{project}/locations/{location}/vodConfigs/{id}`.
     *
     * Generated from protobuf field <code>string vod_config = 14 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setVodConfig($var)
    {
        GPBUtil::checkString($var, True);
        $this->vod_config = $var;

        return $this;
    }

}

