<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/support/v2/actor.proto

namespace Google\Cloud\Support\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An Actor represents an entity that performed an action. For example, an actor
 * could be a user who posted a comment on a support case, a user who
 * uploaded an attachment, or a service account that created a support case.
 *
 * Generated from protobuf message <code>google.cloud.support.v2.Actor</code>
 */
class Actor extends \Google\Protobuf\Internal\Message
{
    /**
     * The name to display for the actor. If not provided, it is inferred from
     * credentials supplied during case creation. When an email is provided, a
     * display name must also be provided. This will be obfuscated if the user
     * is a Google Support agent.
     *
     * Generated from protobuf field <code>string display_name = 1;</code>
     */
    protected $display_name = '';
    /**
     * The email address of the actor. If not provided, it is inferred from the
     * credentials supplied during case creation. When a name is provided, an
     * email must also be provided. If the user is a Google Support agent, this is
     * obfuscated.
     * This field is deprecated. Use `username` instead.
     *
     * Generated from protobuf field <code>string email = 2 [deprecated = true];</code>
     * @deprecated
     */
    protected $email = '';
    /**
     * Output only. Whether the actor is a Google support actor.
     *
     * Generated from protobuf field <code>bool google_support = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $google_support = false;
    /**
     * Output only. The username of the actor. It may look like an email or other
     * format provided by the identity provider. If not provided, it is inferred
     * from the credentials supplied. When a name is provided, a username must
     * also be provided. If the user is a Google Support agent, this will not be
     * set.
     *
     * Generated from protobuf field <code>string username = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $username = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $display_name
     *           The name to display for the actor. If not provided, it is inferred from
     *           credentials supplied during case creation. When an email is provided, a
     *           display name must also be provided. This will be obfuscated if the user
     *           is a Google Support agent.
     *     @type string $email
     *           The email address of the actor. If not provided, it is inferred from the
     *           credentials supplied during case creation. When a name is provided, an
     *           email must also be provided. If the user is a Google Support agent, this is
     *           obfuscated.
     *           This field is deprecated. Use `username` instead.
     *     @type bool $google_support
     *           Output only. Whether the actor is a Google support actor.
     *     @type string $username
     *           Output only. The username of the actor. It may look like an email or other
     *           format provided by the identity provider. If not provided, it is inferred
     *           from the credentials supplied. When a name is provided, a username must
     *           also be provided. If the user is a Google Support agent, this will not be
     *           set.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Support\V2\Actor::initOnce();
        parent::__construct($data);
    }

    /**
     * The name to display for the actor. If not provided, it is inferred from
     * credentials supplied during case creation. When an email is provided, a
     * display name must also be provided. This will be obfuscated if the user
     * is a Google Support agent.
     *
     * Generated from protobuf field <code>string display_name = 1;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * The name to display for the actor. If not provided, it is inferred from
     * credentials supplied during case creation. When an email is provided, a
     * display name must also be provided. This will be obfuscated if the user
     * is a Google Support agent.
     *
     * Generated from protobuf field <code>string display_name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The email address of the actor. If not provided, it is inferred from the
     * credentials supplied during case creation. When a name is provided, an
     * email must also be provided. If the user is a Google Support agent, this is
     * obfuscated.
     * This field is deprecated. Use `username` instead.
     *
     * Generated from protobuf field <code>string email = 2 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getEmail()
    {
        if ($this->email !== '') {
            @trigger_error('email is deprecated.', E_USER_DEPRECATED);
        }
        return $this->email;
    }

    /**
     * The email address of the actor. If not provided, it is inferred from the
     * credentials supplied during case creation. When a name is provided, an
     * email must also be provided. If the user is a Google Support agent, this is
     * obfuscated.
     * This field is deprecated. Use `username` instead.
     *
     * Generated from protobuf field <code>string email = 2 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setEmail($var)
    {
        @trigger_error('email is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->email = $var;

        return $this;
    }

    /**
     * Output only. Whether the actor is a Google support actor.
     *
     * Generated from protobuf field <code>bool google_support = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getGoogleSupport()
    {
        return $this->google_support;
    }

    /**
     * Output only. Whether the actor is a Google support actor.
     *
     * Generated from protobuf field <code>bool google_support = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setGoogleSupport($var)
    {
        GPBUtil::checkBool($var);
        $this->google_support = $var;

        return $this;
    }

    /**
     * Output only. The username of the actor. It may look like an email or other
     * format provided by the identity provider. If not provided, it is inferred
     * from the credentials supplied. When a name is provided, a username must
     * also be provided. If the user is a Google Support agent, this will not be
     * set.
     *
     * Generated from protobuf field <code>string username = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * Output only. The username of the actor. It may look like an email or other
     * format provided by the identity provider. If not provided, it is inferred
     * from the credentials supplied. When a name is provided, a username must
     * also be provided. If the user is a Google Support agent, this will not be
     * set.
     *
     * Generated from protobuf field <code>string username = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUsername($var)
    {
        GPBUtil::checkString($var, True);
        $this->username = $var;

        return $this;
    }

}

