<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/change_stream.proto

namespace Google\Cloud\Spanner\V1\ChangeStreamRecord;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A partition event record describes key range changes for a change stream
 * partition. The changes to a row defined by its primary key can be captured
 * in one change stream partition for a specific time range, and then be
 * captured in a different change stream partition for a different time range.
 * This movement of key ranges across change stream partitions is a reflection
 * of activities, such as Spanner's dynamic splitting and load balancing, etc.
 * Processing this event is needed if users want to guarantee processing of
 * the changes for any key in timestamp order. If time ordered processing of
 * changes for a primary key is not needed, this event can be ignored.
 * To guarantee time ordered processing for each primary key, if the event
 * describes move-ins, the reader of this partition needs to wait until the
 * readers of the source partitions have processed all records with timestamps
 * <= this PartitionEventRecord.commit_timestamp, before advancing beyond this
 * PartitionEventRecord. If the event describes move-outs, the reader can
 * notify the readers of the destination partitions that they can continue
 * processing.
 *
 * Generated from protobuf message <code>google.spanner.v1.ChangeStreamRecord.PartitionEventRecord</code>
 */
class PartitionEventRecord extends \Google\Protobuf\Internal\Message
{
    /**
     * Indicates the commit timestamp at which the key range change occurred.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    private $commit_timestamp = null;
    /**
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * Generated from protobuf field <code>string record_sequence = 2;</code>
     */
    private $record_sequence = '';
    /**
     * Unique partition identifier describing the partition this event
     * occurred on.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEventRecord.
     *
     * Generated from protobuf field <code>string partition_token = 3;</code>
     */
    private $partition_token = '';
    /**
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     * The PartitionEventRecord returned in P1 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     * The PartitionEventRecord returned in P2 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * The PartitionEventRecord returned in P3 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;</code>
     */
    private $move_in_events;
    /**
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     * The PartitionEventRecord returned in P1 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     * The PartitionEventRecord returned in P2 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * The PartitionEventRecord returned in P3 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;</code>
     */
    private $move_out_events;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Protobuf\Timestamp $commit_timestamp
     *           Indicates the commit timestamp at which the key range change occurred.
     *           DataChangeRecord.commit_timestamps,
     *           PartitionStartRecord.start_timestamps,
     *           PartitionEventRecord.commit_timestamps, and
     *           PartitionEndRecord.end_timestamps can have the same value in the same
     *           partition.
     *     @type string $record_sequence
     *           Record sequence numbers are unique and monotonically increasing (but not
     *           necessarily contiguous) for a specific timestamp across record
     *           types in the same partition. To guarantee ordered processing, the reader
     *           should process records (of potentially different types) in
     *           record_sequence order for a specific timestamp in the same partition.
     *     @type string $partition_token
     *           Unique partition identifier describing the partition this event
     *           occurred on.
     *           [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
     *           is equal to the partition token of the change stream partition currently
     *           queried to return this PartitionEventRecord.
     *     @type array<\Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEventRecord\MoveInEvent>|\Google\Protobuf\Internal\RepeatedField $move_in_events
     *           Set when one or more key ranges are moved into the change stream
     *           partition identified by
     *           [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *           Example: Two key ranges are moved into partition (P1) from partition (P2)
     *           and partition (P3) in a single transaction at timestamp T.
     *           The PartitionEventRecord returned in P1 will reflect the move as:
     *           PartitionEventRecord {
     *             commit_timestamp: T
     *             partition_token: "P1"
     *             move_in_events {
     *               source_partition_token: "P2"
     *             }
     *             move_in_events {
     *               source_partition_token: "P3"
     *             }
     *           }
     *           The PartitionEventRecord returned in P2 will reflect the move as:
     *           PartitionEventRecord {
     *             commit_timestamp: T
     *             partition_token: "P2"
     *             move_out_events {
     *               destination_partition_token: "P1"
     *             }
     *           }
     *           The PartitionEventRecord returned in P3 will reflect the move as:
     *           PartitionEventRecord {
     *             commit_timestamp: T
     *             partition_token: "P3"
     *             move_out_events {
     *               destination_partition_token: "P1"
     *             }
     *           }
     *     @type array<\Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEventRecord\MoveOutEvent>|\Google\Protobuf\Internal\RepeatedField $move_out_events
     *           Set when one or more key ranges are moved out of the change stream
     *           partition identified by
     *           [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *           Example: Two key ranges are moved out of partition (P1) to partition (P2)
     *           and partition (P3) in a single transaction at timestamp T.
     *           The PartitionEventRecord returned in P1 will reflect the move as:
     *           PartitionEventRecord {
     *             commit_timestamp: T
     *             partition_token: "P1"
     *             move_out_events {
     *               destination_partition_token: "P2"
     *             }
     *             move_out_events {
     *               destination_partition_token: "P3"
     *             }
     *           }
     *           The PartitionEventRecord returned in P2 will reflect the move as:
     *           PartitionEventRecord {
     *             commit_timestamp: T
     *             partition_token: "P2"
     *             move_in_events {
     *               source_partition_token: "P1"
     *             }
     *           }
     *           The PartitionEventRecord returned in P3 will reflect the move as:
     *           PartitionEventRecord {
     *             commit_timestamp: T
     *             partition_token: "P3"
     *             move_in_events {
     *               source_partition_token: "P1"
     *             }
     *           }
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\ChangeStream::initOnce();
        parent::__construct($data);
    }

    /**
     * Indicates the commit timestamp at which the key range change occurred.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCommitTimestamp()
    {
        return $this->commit_timestamp;
    }

    public function hasCommitTimestamp()
    {
        return isset($this->commit_timestamp);
    }

    public function clearCommitTimestamp()
    {
        unset($this->commit_timestamp);
    }

    /**
     * Indicates the commit timestamp at which the key range change occurred.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCommitTimestamp($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->commit_timestamp = $var;

        return $this;
    }

    /**
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * Generated from protobuf field <code>string record_sequence = 2;</code>
     * @return string
     */
    public function getRecordSequence()
    {
        return $this->record_sequence;
    }

    /**
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * Generated from protobuf field <code>string record_sequence = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setRecordSequence($var)
    {
        GPBUtil::checkString($var, True);
        $this->record_sequence = $var;

        return $this;
    }

    /**
     * Unique partition identifier describing the partition this event
     * occurred on.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEventRecord.
     *
     * Generated from protobuf field <code>string partition_token = 3;</code>
     * @return string
     */
    public function getPartitionToken()
    {
        return $this->partition_token;
    }

    /**
     * Unique partition identifier describing the partition this event
     * occurred on.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEventRecord.
     *
     * Generated from protobuf field <code>string partition_token = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPartitionToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->partition_token = $var;

        return $this;
    }

    /**
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     * The PartitionEventRecord returned in P1 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     * The PartitionEventRecord returned in P2 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * The PartitionEventRecord returned in P3 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMoveInEvents()
    {
        return $this->move_in_events;
    }

    /**
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     * The PartitionEventRecord returned in P1 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     * The PartitionEventRecord returned in P2 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * The PartitionEventRecord returned in P3 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;</code>
     * @param array<\Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEventRecord\MoveInEvent>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMoveInEvents($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEventRecord\MoveInEvent::class);
        $this->move_in_events = $arr;

        return $this;
    }

    /**
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     * The PartitionEventRecord returned in P1 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     * The PartitionEventRecord returned in P2 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * The PartitionEventRecord returned in P3 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMoveOutEvents()
    {
        return $this->move_out_events;
    }

    /**
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     * The PartitionEventRecord returned in P1 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     * The PartitionEventRecord returned in P2 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * The PartitionEventRecord returned in P3 will reflect the move as:
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;</code>
     * @param array<\Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEventRecord\MoveOutEvent>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMoveOutEvents($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEventRecord\MoveOutEvent::class);
        $this->move_out_events = $arr;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PartitionEventRecord::class, \Google\Cloud\Spanner\V1\ChangeStreamRecord_PartitionEventRecord::class);

