<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/change_stream.proto

namespace Google\Cloud\Spanner\V1\ChangeStreamRecord;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A data change record contains a set of changes to a table with the same
 * modification type (insert, update, or delete) committed at the same commit
 * timestamp in one change stream partition for the same transaction. Multiple
 * data change records can be returned for the same transaction across
 * multiple change stream partitions.
 *
 * Generated from protobuf message <code>google.spanner.v1.ChangeStreamRecord.DataChangeRecord</code>
 */
class DataChangeRecord extends \Google\Protobuf\Internal\Message
{
    /**
     * Indicates the timestamp in which the change was committed.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    private $commit_timestamp = null;
    /**
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * The record sequence number ordering across partitions is only meaningful
     * in the context of a specific transaction. Record sequence numbers are
     * unique across partitions for a specific transaction. Sort the
     * DataChangeRecords for the same
     * [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
     * by
     * [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
     * to reconstruct the ordering of the changes within the transaction.
     *
     * Generated from protobuf field <code>string record_sequence = 2;</code>
     */
    private $record_sequence = '';
    /**
     * Provides a globally unique string that represents the transaction in
     * which the change was committed. Multiple transactions can have the same
     * commit timestamp, but each transaction has a unique
     * server_transaction_id.
     *
     * Generated from protobuf field <code>string server_transaction_id = 3;</code>
     */
    private $server_transaction_id = '';
    /**
     * Indicates whether this is the last record for a transaction in the
     *  current partition. Clients can use this field to determine when all
     *  records for a transaction in the current partition have been received.
     *
     * Generated from protobuf field <code>bool is_last_record_in_transaction_in_partition = 4;</code>
     */
    private $is_last_record_in_transaction_in_partition = false;
    /**
     * Name of the table affected by the change.
     *
     * Generated from protobuf field <code>string table = 5;</code>
     */
    private $table = '';
    /**
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;</code>
     */
    private $column_metadata;
    /**
     * Describes the changes that were made.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     */
    private $mods;
    /**
     * Describes the type of change.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType mod_type = 8;</code>
     */
    private $mod_type = 0;
    /**
     * Describes the value capture type that was specified in the change stream
     * configuration when this change was captured.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value_capture_type = 9;</code>
     */
    private $value_capture_type = 0;
    /**
     * Indicates the number of data change records that are part of this
     * transaction across all change stream partitions. This value can be used
     * to assemble all the records associated with a particular transaction.
     *
     * Generated from protobuf field <code>int32 number_of_records_in_transaction = 10;</code>
     */
    private $number_of_records_in_transaction = 0;
    /**
     * Indicates the number of partitions that return data change records for
     * this transaction. This value can be helpful in assembling all records
     * associated with a particular transaction.
     *
     * Generated from protobuf field <code>int32 number_of_partitions_in_transaction = 11;</code>
     */
    private $number_of_partitions_in_transaction = 0;
    /**
     * Indicates the transaction tag associated with this transaction.
     *
     * Generated from protobuf field <code>string transaction_tag = 12;</code>
     */
    private $transaction_tag = '';
    /**
     * Indicates whether the transaction is a system transaction. System
     * transactions include those issued by time-to-live (TTL), column backfill,
     * etc.
     *
     * Generated from protobuf field <code>bool is_system_transaction = 13;</code>
     */
    private $is_system_transaction = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Protobuf\Timestamp $commit_timestamp
     *           Indicates the timestamp in which the change was committed.
     *           DataChangeRecord.commit_timestamps,
     *           PartitionStartRecord.start_timestamps,
     *           PartitionEventRecord.commit_timestamps, and
     *           PartitionEndRecord.end_timestamps can have the same value in the same
     *           partition.
     *     @type string $record_sequence
     *           Record sequence numbers are unique and monotonically increasing (but not
     *           necessarily contiguous) for a specific timestamp across record
     *           types in the same partition. To guarantee ordered processing, the reader
     *           should process records (of potentially different types) in
     *           record_sequence order for a specific timestamp in the same partition.
     *           The record sequence number ordering across partitions is only meaningful
     *           in the context of a specific transaction. Record sequence numbers are
     *           unique across partitions for a specific transaction. Sort the
     *           DataChangeRecords for the same
     *           [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
     *           by
     *           [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
     *           to reconstruct the ordering of the changes within the transaction.
     *     @type string $server_transaction_id
     *           Provides a globally unique string that represents the transaction in
     *           which the change was committed. Multiple transactions can have the same
     *           commit timestamp, but each transaction has a unique
     *           server_transaction_id.
     *     @type bool $is_last_record_in_transaction_in_partition
     *           Indicates whether this is the last record for a transaction in the
     *            current partition. Clients can use this field to determine when all
     *            records for a transaction in the current partition have been received.
     *     @type string $table
     *           Name of the table affected by the change.
     *     @type array<\Google\Cloud\Spanner\V1\ChangeStreamRecord\DataChangeRecord\ColumnMetadata>|\Google\Protobuf\Internal\RepeatedField $column_metadata
     *           Provides metadata describing the columns associated with the
     *           [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     *           below.
     *     @type array<\Google\Cloud\Spanner\V1\ChangeStreamRecord\DataChangeRecord\Mod>|\Google\Protobuf\Internal\RepeatedField $mods
     *           Describes the changes that were made.
     *     @type int $mod_type
     *           Describes the type of change.
     *     @type int $value_capture_type
     *           Describes the value capture type that was specified in the change stream
     *           configuration when this change was captured.
     *     @type int $number_of_records_in_transaction
     *           Indicates the number of data change records that are part of this
     *           transaction across all change stream partitions. This value can be used
     *           to assemble all the records associated with a particular transaction.
     *     @type int $number_of_partitions_in_transaction
     *           Indicates the number of partitions that return data change records for
     *           this transaction. This value can be helpful in assembling all records
     *           associated with a particular transaction.
     *     @type string $transaction_tag
     *           Indicates the transaction tag associated with this transaction.
     *     @type bool $is_system_transaction
     *           Indicates whether the transaction is a system transaction. System
     *           transactions include those issued by time-to-live (TTL), column backfill,
     *           etc.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\ChangeStream::initOnce();
        parent::__construct($data);
    }

    /**
     * Indicates the timestamp in which the change was committed.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCommitTimestamp()
    {
        return $this->commit_timestamp;
    }

    public function hasCommitTimestamp()
    {
        return isset($this->commit_timestamp);
    }

    public function clearCommitTimestamp()
    {
        unset($this->commit_timestamp);
    }

    /**
     * Indicates the timestamp in which the change was committed.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCommitTimestamp($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->commit_timestamp = $var;

        return $this;
    }

    /**
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * The record sequence number ordering across partitions is only meaningful
     * in the context of a specific transaction. Record sequence numbers are
     * unique across partitions for a specific transaction. Sort the
     * DataChangeRecords for the same
     * [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
     * by
     * [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
     * to reconstruct the ordering of the changes within the transaction.
     *
     * Generated from protobuf field <code>string record_sequence = 2;</code>
     * @return string
     */
    public function getRecordSequence()
    {
        return $this->record_sequence;
    }

    /**
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * The record sequence number ordering across partitions is only meaningful
     * in the context of a specific transaction. Record sequence numbers are
     * unique across partitions for a specific transaction. Sort the
     * DataChangeRecords for the same
     * [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
     * by
     * [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
     * to reconstruct the ordering of the changes within the transaction.
     *
     * Generated from protobuf field <code>string record_sequence = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setRecordSequence($var)
    {
        GPBUtil::checkString($var, True);
        $this->record_sequence = $var;

        return $this;
    }

    /**
     * Provides a globally unique string that represents the transaction in
     * which the change was committed. Multiple transactions can have the same
     * commit timestamp, but each transaction has a unique
     * server_transaction_id.
     *
     * Generated from protobuf field <code>string server_transaction_id = 3;</code>
     * @return string
     */
    public function getServerTransactionId()
    {
        return $this->server_transaction_id;
    }

    /**
     * Provides a globally unique string that represents the transaction in
     * which the change was committed. Multiple transactions can have the same
     * commit timestamp, but each transaction has a unique
     * server_transaction_id.
     *
     * Generated from protobuf field <code>string server_transaction_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setServerTransactionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->server_transaction_id = $var;

        return $this;
    }

    /**
     * Indicates whether this is the last record for a transaction in the
     *  current partition. Clients can use this field to determine when all
     *  records for a transaction in the current partition have been received.
     *
     * Generated from protobuf field <code>bool is_last_record_in_transaction_in_partition = 4;</code>
     * @return bool
     */
    public function getIsLastRecordInTransactionInPartition()
    {
        return $this->is_last_record_in_transaction_in_partition;
    }

    /**
     * Indicates whether this is the last record for a transaction in the
     *  current partition. Clients can use this field to determine when all
     *  records for a transaction in the current partition have been received.
     *
     * Generated from protobuf field <code>bool is_last_record_in_transaction_in_partition = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsLastRecordInTransactionInPartition($var)
    {
        GPBUtil::checkBool($var);
        $this->is_last_record_in_transaction_in_partition = $var;

        return $this;
    }

    /**
     * Name of the table affected by the change.
     *
     * Generated from protobuf field <code>string table = 5;</code>
     * @return string
     */
    public function getTable()
    {
        return $this->table;
    }

    /**
     * Name of the table affected by the change.
     *
     * Generated from protobuf field <code>string table = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setTable($var)
    {
        GPBUtil::checkString($var, True);
        $this->table = $var;

        return $this;
    }

    /**
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getColumnMetadata()
    {
        return $this->column_metadata;
    }

    /**
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;</code>
     * @param array<\Google\Cloud\Spanner\V1\ChangeStreamRecord\DataChangeRecord\ColumnMetadata>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setColumnMetadata($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Spanner\V1\ChangeStreamRecord\DataChangeRecord\ColumnMetadata::class);
        $this->column_metadata = $arr;

        return $this;
    }

    /**
     * Describes the changes that were made.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMods()
    {
        return $this->mods;
    }

    /**
     * Describes the changes that were made.
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     * @param array<\Google\Cloud\Spanner\V1\ChangeStreamRecord\DataChangeRecord\Mod>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMods($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Spanner\V1\ChangeStreamRecord\DataChangeRecord\Mod::class);
        $this->mods = $arr;

        return $this;
    }

    /**
     * Describes the type of change.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType mod_type = 8;</code>
     * @return int
     */
    public function getModType()
    {
        return $this->mod_type;
    }

    /**
     * Describes the type of change.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType mod_type = 8;</code>
     * @param int $var
     * @return $this
     */
    public function setModType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Spanner\V1\ChangeStreamRecord\DataChangeRecord\ModType::class);
        $this->mod_type = $var;

        return $this;
    }

    /**
     * Describes the value capture type that was specified in the change stream
     * configuration when this change was captured.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value_capture_type = 9;</code>
     * @return int
     */
    public function getValueCaptureType()
    {
        return $this->value_capture_type;
    }

    /**
     * Describes the value capture type that was specified in the change stream
     * configuration when this change was captured.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value_capture_type = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setValueCaptureType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Spanner\V1\ChangeStreamRecord\DataChangeRecord\ValueCaptureType::class);
        $this->value_capture_type = $var;

        return $this;
    }

    /**
     * Indicates the number of data change records that are part of this
     * transaction across all change stream partitions. This value can be used
     * to assemble all the records associated with a particular transaction.
     *
     * Generated from protobuf field <code>int32 number_of_records_in_transaction = 10;</code>
     * @return int
     */
    public function getNumberOfRecordsInTransaction()
    {
        return $this->number_of_records_in_transaction;
    }

    /**
     * Indicates the number of data change records that are part of this
     * transaction across all change stream partitions. This value can be used
     * to assemble all the records associated with a particular transaction.
     *
     * Generated from protobuf field <code>int32 number_of_records_in_transaction = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setNumberOfRecordsInTransaction($var)
    {
        GPBUtil::checkInt32($var);
        $this->number_of_records_in_transaction = $var;

        return $this;
    }

    /**
     * Indicates the number of partitions that return data change records for
     * this transaction. This value can be helpful in assembling all records
     * associated with a particular transaction.
     *
     * Generated from protobuf field <code>int32 number_of_partitions_in_transaction = 11;</code>
     * @return int
     */
    public function getNumberOfPartitionsInTransaction()
    {
        return $this->number_of_partitions_in_transaction;
    }

    /**
     * Indicates the number of partitions that return data change records for
     * this transaction. This value can be helpful in assembling all records
     * associated with a particular transaction.
     *
     * Generated from protobuf field <code>int32 number_of_partitions_in_transaction = 11;</code>
     * @param int $var
     * @return $this
     */
    public function setNumberOfPartitionsInTransaction($var)
    {
        GPBUtil::checkInt32($var);
        $this->number_of_partitions_in_transaction = $var;

        return $this;
    }

    /**
     * Indicates the transaction tag associated with this transaction.
     *
     * Generated from protobuf field <code>string transaction_tag = 12;</code>
     * @return string
     */
    public function getTransactionTag()
    {
        return $this->transaction_tag;
    }

    /**
     * Indicates the transaction tag associated with this transaction.
     *
     * Generated from protobuf field <code>string transaction_tag = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setTransactionTag($var)
    {
        GPBUtil::checkString($var, True);
        $this->transaction_tag = $var;

        return $this;
    }

    /**
     * Indicates whether the transaction is a system transaction. System
     * transactions include those issued by time-to-live (TTL), column backfill,
     * etc.
     *
     * Generated from protobuf field <code>bool is_system_transaction = 13;</code>
     * @return bool
     */
    public function getIsSystemTransaction()
    {
        return $this->is_system_transaction;
    }

    /**
     * Indicates whether the transaction is a system transaction. System
     * transactions include those issued by time-to-live (TTL), column backfill,
     * etc.
     *
     * Generated from protobuf field <code>bool is_system_transaction = 13;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsSystemTransaction($var)
    {
        GPBUtil::checkBool($var);
        $this->is_system_transaction = $var;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DataChangeRecord::class, \Google\Cloud\Spanner\V1\ChangeStreamRecord_DataChangeRecord::class);

