<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/admin/database/v1/spanner_database_admin.proto

namespace Google\Cloud\Spanner\Admin\Database\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Enqueues the given DDL statements to be applied, in order but not
 * necessarily all at once, to the database schema at some point (or
 * points) in the future. The server checks that the statements
 * are executable (syntactically valid, name tables that exist, etc.)
 * before enqueueing them, but they may still fail upon
 * later execution (e.g., if a statement from another batch of
 * statements is applied first and it conflicts in some way, or if
 * there is some data-related problem like a `NULL` value in a column to
 * which `NOT NULL` would be added). If a statement fails, all
 * subsequent statements in the batch are automatically cancelled.
 * Each batch of statements is assigned a name which can be used with
 * the [Operations][google.longrunning.Operations] API to monitor
 * progress. See the
 * [operation_id][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.operation_id]
 * field for more details.
 *
 * Generated from protobuf message <code>google.spanner.admin.database.v1.UpdateDatabaseDdlRequest</code>
 */
class UpdateDatabaseDdlRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The database to update.
     *
     * Generated from protobuf field <code>string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $database = '';
    /**
     * Required. DDL statements to be applied to the database.
     *
     * Generated from protobuf field <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $statements;
    /**
     * If empty, the new update request is assigned an
     * automatically-generated operation ID. Otherwise, `operation_id`
     * is used to construct the name of the resulting
     * [Operation][google.longrunning.Operation].
     * Specifying an explicit operation ID simplifies determining
     * whether the statements were executed in the event that the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * call is replayed, or the return value is otherwise lost: the
     * [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database]
     * and `operation_id` fields can be combined to form the
     * [name][google.longrunning.Operation.name] of the resulting
     * [longrunning.Operation][google.longrunning.Operation]:
     * `<database>/operations/<operation_id>`.
     * `operation_id` should be unique within the database, and must be
     * a valid identifier: `[a-z][a-z0-9_]*`. Note that
     * automatically-generated operation IDs always begin with an
     * underscore. If the named operation already exists,
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * returns `ALREADY_EXISTS`.
     *
     * Generated from protobuf field <code>string operation_id = 3;</code>
     */
    private $operation_id = '';
    /**
     * Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements.
     * Contains a protobuf-serialized
     * [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
     * To generate it, [install](https://grpc.io/docs/protoc-installation/) and
     * run `protoc` with --include_imports and --descriptor_set_out. For example,
     * to generate for moon/shot/app.proto, run
     * ```
     * $protoc  --proto_path=/app_path --proto_path=/lib_path \
     *          --include_imports \
     *          --descriptor_set_out=descriptors.data \
     *          moon/shot/app.proto
     * ```
     * For more details, see protobuffer [self
     * description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
     *
     * Generated from protobuf field <code>bytes proto_descriptors = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $proto_descriptors = '';
    /**
     * Optional. This field is exposed to be used by the Spanner Migration Tool.
     * For more details, see
     * [SMT](https://github.com/GoogleCloudPlatform/spanner-migration-tool).
     *
     * Generated from protobuf field <code>bool throughput_mode = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $throughput_mode = false;

    /**
     * @param string   $database   Required. The database to update. Please see
     *                             {@see DatabaseAdminClient::databaseName()} for help formatting this field.
     * @param string[] $statements Required. DDL statements to be applied to the database.
     *
     * @return \Google\Cloud\Spanner\Admin\Database\V1\UpdateDatabaseDdlRequest
     *
     * @experimental
     */
    public static function build(string $database, array $statements): self
    {
        return (new self())
            ->setDatabase($database)
            ->setStatements($statements);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $database
     *           Required. The database to update.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $statements
     *           Required. DDL statements to be applied to the database.
     *     @type string $operation_id
     *           If empty, the new update request is assigned an
     *           automatically-generated operation ID. Otherwise, `operation_id`
     *           is used to construct the name of the resulting
     *           [Operation][google.longrunning.Operation].
     *           Specifying an explicit operation ID simplifies determining
     *           whether the statements were executed in the event that the
     *           [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     *           call is replayed, or the return value is otherwise lost: the
     *           [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database]
     *           and `operation_id` fields can be combined to form the
     *           [name][google.longrunning.Operation.name] of the resulting
     *           [longrunning.Operation][google.longrunning.Operation]:
     *           `<database>/operations/<operation_id>`.
     *           `operation_id` should be unique within the database, and must be
     *           a valid identifier: `[a-z][a-z0-9_]*`. Note that
     *           automatically-generated operation IDs always begin with an
     *           underscore. If the named operation already exists,
     *           [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     *           returns `ALREADY_EXISTS`.
     *     @type string $proto_descriptors
     *           Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements.
     *           Contains a protobuf-serialized
     *           [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
     *           To generate it, [install](https://grpc.io/docs/protoc-installation/) and
     *           run `protoc` with --include_imports and --descriptor_set_out. For example,
     *           to generate for moon/shot/app.proto, run
     *           ```
     *           $protoc  --proto_path=/app_path --proto_path=/lib_path \
     *                    --include_imports \
     *                    --descriptor_set_out=descriptors.data \
     *                    moon/shot/app.proto
     *           ```
     *           For more details, see protobuffer [self
     *           description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
     *     @type bool $throughput_mode
     *           Optional. This field is exposed to be used by the Spanner Migration Tool.
     *           For more details, see
     *           [SMT](https://github.com/GoogleCloudPlatform/spanner-migration-tool).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\Admin\Database\V1\SpannerDatabaseAdmin::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The database to update.
     *
     * Generated from protobuf field <code>string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getDatabase()
    {
        return $this->database;
    }

    /**
     * Required. The database to update.
     *
     * Generated from protobuf field <code>string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkString($var, True);
        $this->database = $var;

        return $this;
    }

    /**
     * Required. DDL statements to be applied to the database.
     *
     * Generated from protobuf field <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStatements()
    {
        return $this->statements;
    }

    /**
     * Required. DDL statements to be applied to the database.
     *
     * Generated from protobuf field <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStatements($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->statements = $arr;

        return $this;
    }

    /**
     * If empty, the new update request is assigned an
     * automatically-generated operation ID. Otherwise, `operation_id`
     * is used to construct the name of the resulting
     * [Operation][google.longrunning.Operation].
     * Specifying an explicit operation ID simplifies determining
     * whether the statements were executed in the event that the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * call is replayed, or the return value is otherwise lost: the
     * [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database]
     * and `operation_id` fields can be combined to form the
     * [name][google.longrunning.Operation.name] of the resulting
     * [longrunning.Operation][google.longrunning.Operation]:
     * `<database>/operations/<operation_id>`.
     * `operation_id` should be unique within the database, and must be
     * a valid identifier: `[a-z][a-z0-9_]*`. Note that
     * automatically-generated operation IDs always begin with an
     * underscore. If the named operation already exists,
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * returns `ALREADY_EXISTS`.
     *
     * Generated from protobuf field <code>string operation_id = 3;</code>
     * @return string
     */
    public function getOperationId()
    {
        return $this->operation_id;
    }

    /**
     * If empty, the new update request is assigned an
     * automatically-generated operation ID. Otherwise, `operation_id`
     * is used to construct the name of the resulting
     * [Operation][google.longrunning.Operation].
     * Specifying an explicit operation ID simplifies determining
     * whether the statements were executed in the event that the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * call is replayed, or the return value is otherwise lost: the
     * [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database]
     * and `operation_id` fields can be combined to form the
     * [name][google.longrunning.Operation.name] of the resulting
     * [longrunning.Operation][google.longrunning.Operation]:
     * `<database>/operations/<operation_id>`.
     * `operation_id` should be unique within the database, and must be
     * a valid identifier: `[a-z][a-z0-9_]*`. Note that
     * automatically-generated operation IDs always begin with an
     * underscore. If the named operation already exists,
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * returns `ALREADY_EXISTS`.
     *
     * Generated from protobuf field <code>string operation_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setOperationId($var)
    {
        GPBUtil::checkString($var, True);
        $this->operation_id = $var;

        return $this;
    }

    /**
     * Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements.
     * Contains a protobuf-serialized
     * [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
     * To generate it, [install](https://grpc.io/docs/protoc-installation/) and
     * run `protoc` with --include_imports and --descriptor_set_out. For example,
     * to generate for moon/shot/app.proto, run
     * ```
     * $protoc  --proto_path=/app_path --proto_path=/lib_path \
     *          --include_imports \
     *          --descriptor_set_out=descriptors.data \
     *          moon/shot/app.proto
     * ```
     * For more details, see protobuffer [self
     * description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
     *
     * Generated from protobuf field <code>bytes proto_descriptors = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getProtoDescriptors()
    {
        return $this->proto_descriptors;
    }

    /**
     * Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements.
     * Contains a protobuf-serialized
     * [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
     * To generate it, [install](https://grpc.io/docs/protoc-installation/) and
     * run `protoc` with --include_imports and --descriptor_set_out. For example,
     * to generate for moon/shot/app.proto, run
     * ```
     * $protoc  --proto_path=/app_path --proto_path=/lib_path \
     *          --include_imports \
     *          --descriptor_set_out=descriptors.data \
     *          moon/shot/app.proto
     * ```
     * For more details, see protobuffer [self
     * description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
     *
     * Generated from protobuf field <code>bytes proto_descriptors = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setProtoDescriptors($var)
    {
        GPBUtil::checkString($var, False);
        $this->proto_descriptors = $var;

        return $this;
    }

    /**
     * Optional. This field is exposed to be used by the Spanner Migration Tool.
     * For more details, see
     * [SMT](https://github.com/GoogleCloudPlatform/spanner-migration-tool).
     *
     * Generated from protobuf field <code>bool throughput_mode = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getThroughputMode()
    {
        return $this->throughput_mode;
    }

    /**
     * Optional. This field is exposed to be used by the Spanner Migration Tool.
     * For more details, see
     * [SMT](https://github.com/GoogleCloudPlatform/spanner-migration-tool).
     *
     * Generated from protobuf field <code>bool throughput_mode = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setThroughputMode($var)
    {
        GPBUtil::checkBool($var);
        $this->throughput_mode = $var;

        return $this;
    }

}

