<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/admin/database/v1/spanner_database_admin.proto

namespace Google\Cloud\Spanner\Admin\Database\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Metadata type for the long-running operation returned by
 * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase].
 *
 * Generated from protobuf message <code>google.spanner.admin.database.v1.RestoreDatabaseMetadata</code>
 */
class RestoreDatabaseMetadata extends \Google\Protobuf\Internal\Message
{
    /**
     * Name of the database being created and restored to.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.resource_reference) = {</code>
     */
    private $name = '';
    /**
     * The type of the restore source.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.RestoreSourceType source_type = 2;</code>
     */
    private $source_type = 0;
    /**
     * The progress of the
     * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     * operation.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
     */
    private $progress = null;
    /**
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
     * `Code.CANCELLED`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp cancel_time = 5;</code>
     */
    private $cancel_time = null;
    /**
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored database, and remove the dependency on the restore source.
     * The name is of the form
     * `projects/<project>/instances/<instance>/databases/<database>/operations/<operation>`
     * where the <database> is the name of database being created and restored to.
     * The metadata type of the  long-running operation is
     * [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata].
     * This long-running operation will be automatically created by the system
     * after the RestoreDatabase long-running operation completes successfully.
     * This operation will not be created if the restore was not successful.
     *
     * Generated from protobuf field <code>string optimize_database_operation_name = 6;</code>
     */
    private $optimize_database_operation_name = '';
    protected $source_info;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Name of the database being created and restored to.
     *     @type int $source_type
     *           The type of the restore source.
     *     @type \Google\Cloud\Spanner\Admin\Database\V1\BackupInfo $backup_info
     *           Information about the backup used to restore the database.
     *     @type \Google\Cloud\Spanner\Admin\Database\V1\OperationProgress $progress
     *           The progress of the
     *           [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     *           operation.
     *     @type \Google\Protobuf\Timestamp $cancel_time
     *           The time at which cancellation of this operation was received.
     *           [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     *           starts asynchronous cancellation on a long-running operation. The server
     *           makes a best effort to cancel the operation, but success is not guaranteed.
     *           Clients can use
     *           [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     *           other methods to check whether the cancellation succeeded or whether the
     *           operation completed despite cancellation. On successful cancellation,
     *           the operation is not deleted; instead, it becomes an operation with
     *           an [Operation.error][google.longrunning.Operation.error] value with a
     *           [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
     *           `Code.CANCELLED`.
     *     @type string $optimize_database_operation_name
     *           If exists, the name of the long-running operation that will be used to
     *           track the post-restore optimization process to optimize the performance of
     *           the restored database, and remove the dependency on the restore source.
     *           The name is of the form
     *           `projects/<project>/instances/<instance>/databases/<database>/operations/<operation>`
     *           where the <database> is the name of database being created and restored to.
     *           The metadata type of the  long-running operation is
     *           [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata].
     *           This long-running operation will be automatically created by the system
     *           after the RestoreDatabase long-running operation completes successfully.
     *           This operation will not be created if the restore was not successful.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\Admin\Database\V1\SpannerDatabaseAdmin::initOnce();
        parent::__construct($data);
    }

    /**
     * Name of the database being created and restored to.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the database being created and restored to.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The type of the restore source.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.RestoreSourceType source_type = 2;</code>
     * @return int
     */
    public function getSourceType()
    {
        return $this->source_type;
    }

    /**
     * The type of the restore source.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.RestoreSourceType source_type = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setSourceType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Spanner\Admin\Database\V1\RestoreSourceType::class);
        $this->source_type = $var;

        return $this;
    }

    /**
     * Information about the backup used to restore the database.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
     * @return \Google\Cloud\Spanner\Admin\Database\V1\BackupInfo|null
     */
    public function getBackupInfo()
    {
        return $this->readOneof(3);
    }

    public function hasBackupInfo()
    {
        return $this->hasOneof(3);
    }

    /**
     * Information about the backup used to restore the database.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
     * @param \Google\Cloud\Spanner\Admin\Database\V1\BackupInfo $var
     * @return $this
     */
    public function setBackupInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\Admin\Database\V1\BackupInfo::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * The progress of the
     * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     * operation.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
     * @return \Google\Cloud\Spanner\Admin\Database\V1\OperationProgress|null
     */
    public function getProgress()
    {
        return $this->progress;
    }

    public function hasProgress()
    {
        return isset($this->progress);
    }

    public function clearProgress()
    {
        unset($this->progress);
    }

    /**
     * The progress of the
     * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     * operation.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
     * @param \Google\Cloud\Spanner\Admin\Database\V1\OperationProgress $var
     * @return $this
     */
    public function setProgress($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\Admin\Database\V1\OperationProgress::class);
        $this->progress = $var;

        return $this;
    }

    /**
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
     * `Code.CANCELLED`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp cancel_time = 5;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCancelTime()
    {
        return $this->cancel_time;
    }

    public function hasCancelTime()
    {
        return isset($this->cancel_time);
    }

    public function clearCancelTime()
    {
        unset($this->cancel_time);
    }

    /**
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
     * `Code.CANCELLED`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp cancel_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCancelTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->cancel_time = $var;

        return $this;
    }

    /**
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored database, and remove the dependency on the restore source.
     * The name is of the form
     * `projects/<project>/instances/<instance>/databases/<database>/operations/<operation>`
     * where the <database> is the name of database being created and restored to.
     * The metadata type of the  long-running operation is
     * [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata].
     * This long-running operation will be automatically created by the system
     * after the RestoreDatabase long-running operation completes successfully.
     * This operation will not be created if the restore was not successful.
     *
     * Generated from protobuf field <code>string optimize_database_operation_name = 6;</code>
     * @return string
     */
    public function getOptimizeDatabaseOperationName()
    {
        return $this->optimize_database_operation_name;
    }

    /**
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored database, and remove the dependency on the restore source.
     * The name is of the form
     * `projects/<project>/instances/<instance>/databases/<database>/operations/<operation>`
     * where the <database> is the name of database being created and restored to.
     * The metadata type of the  long-running operation is
     * [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata].
     * This long-running operation will be automatically created by the system
     * after the RestoreDatabase long-running operation completes successfully.
     * This operation will not be created if the restore was not successful.
     *
     * Generated from protobuf field <code>string optimize_database_operation_name = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setOptimizeDatabaseOperationName($var)
    {
        GPBUtil::checkString($var, True);
        $this->optimize_database_operation_name = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSourceInfo()
    {
        return $this->whichOneof("source_info");
    }

}

