<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/products/v1/products_common.proto

namespace Google\Shopping\Merchant\Products\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Product attributes.
 *
 * Generated from protobuf message <code>google.shopping.merchant.products.v1.ProductAttributes</code>
 */
class ProductAttributes extends \Google\Protobuf\Internal\Message
{
    /**
     * Set this value to false when the item does not have unique product
     * identifiers appropriate to its category, such as GTIN, MPN, and brand.
     * Defaults to true, if not provided.
     *
     * Generated from protobuf field <code>optional bool identifier_exists = 4;</code>
     */
    protected $identifier_exists = null;
    /**
     * Whether the item is a business-defined sub-API. A [sub-API]
     * (https://support.google.com/merchants/answer/6324449) is a custom
     * grouping of different products sold by a business for a single price.
     *
     * Generated from protobuf field <code>optional bool is_bundle = 5;</code>
     */
    protected $is_bundle = null;
    /**
     * Title of the item.
     *
     * Generated from protobuf field <code>optional string title = 6;</code>
     */
    protected $title = null;
    /**
     * Description of the item.
     *
     * Generated from protobuf field <code>optional string description = 7;</code>
     */
    protected $description = null;
    /**
     * URL directly linking to your item's page on your online store.
     *
     * Generated from protobuf field <code>optional string link = 8;</code>
     */
    protected $link = null;
    /**
     * URL for the mobile-optimized version of your item's landing page.
     *
     * Generated from protobuf field <code>optional string mobile_link = 9;</code>
     */
    protected $mobile_link = null;
    /**
     * URL for the canonical version of your item's landing page.
     *
     * Generated from protobuf field <code>optional string canonical_link = 10;</code>
     */
    protected $canonical_link = null;
    /**
     * URL of an image of the item.
     *
     * Generated from protobuf field <code>optional string image_link = 11;</code>
     */
    protected $image_link = null;
    /**
     * Additional URLs of images of the item.
     *
     * Generated from protobuf field <code>repeated string additional_image_links = 12;</code>
     */
    private $additional_image_links;
    /**
     * Date on which the item should expire, as specified upon insertion, in
     * [ISO
     * 8601](http://en.wikipedia.org/wiki/ISO_8601) format. The actual
     * expiration date is exposed in `productstatuses` as
     * [googleExpirationDate](https://support.google.com/merchants/answer/6324499)
     * and might be earlier if `expirationDate` is too far in the future.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expiration_date = 16;</code>
     */
    protected $expiration_date = null;
    /**
     * The date time when an offer becomes visible in search results across
     * Google’s YouTube surfaces, in [ISO
     * 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
     * See [Disclosure date](https://support.google.com/merchants/answer/13034208)
     * for more information.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp disclosure_date = 79;</code>
     */
    protected $disclosure_date = null;
    /**
     * Set to true if the item is targeted towards adults.
     *
     * Generated from protobuf field <code>optional bool adult = 17;</code>
     */
    protected $adult = null;
    /**
     * Target [age group](https://support.google.com/merchants/answer/6324463) of
     * the item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.AgeGroup age_group = 18;</code>
     */
    protected $age_group = null;
    /**
     * [Availability](https://support.google.com/merchants/answer/6324448) status
     * of the item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.Availability availability = 19;</code>
     */
    protected $availability = null;
    /**
     * The day a pre-ordered product becomes available for delivery, in [ISO
     * 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp availability_date = 20;</code>
     */
    protected $availability_date = null;
    /**
     * [Brand](https://support.google.com/merchants/answer/6324351) of the item.
     * For example, "Google".
     *
     * Generated from protobuf field <code>optional string brand = 21;</code>
     */
    protected $brand = null;
    /**
     * [Color](https://support.google.com/merchants/answer/6324487) of the item.
     * For example, "red".
     *
     * Generated from protobuf field <code>optional string color = 22;</code>
     */
    protected $color = null;
    /**
     * [Condition](https://support.google.com/merchants/answer/6324469) or state
     * of the item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.Condition condition = 23;</code>
     */
    protected $condition = null;
    /**
     * Target [gender](https://support.google.com/merchants/answer/6324479) of the
     * item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.Gender gender = 24;</code>
     */
    protected $gender = null;
    /**
     * Google's category of the item (see [Google product
     * taxonomy](https://support.google.com/merchants/answer/1705911)). When
     * querying products, this field will contain the user provided value. There
     * is currently no way to get back the auto assigned google product
     * categories through the API.
     *
     * Generated from protobuf field <code>optional string google_product_category = 25;</code>
     */
    protected $google_product_category = null;
    /**
     * Global Trade Item Numbers
     * ([GTIN](https://support.google.com/merchants/answer/188494#gtin)) of the
     * item.
     * You can provide up to 10 GTINs.
     *
     * Generated from protobuf field <code>repeated string gtins = 140;</code>
     */
    private $gtins;
    /**
     * Shared identifier for all variants of the same product.
     *
     * Generated from protobuf field <code>optional string item_group_id = 27;</code>
     */
    protected $item_group_id = null;
    /**
     * The [material](https://support.google.com/merchants/answer/6324410) of
     * which the item is made. For example, "Leather" or "Cotton".
     *
     * Generated from protobuf field <code>optional string material = 28;</code>
     */
    protected $material = null;
    /**
     * Manufacturer Part Number
     * ([MPN](https://support.google.com/merchants/answer/188494#mpn)) of the
     * item.
     *
     * Generated from protobuf field <code>optional string mpn = 29;</code>
     */
    protected $mpn = null;
    /**
     * The item's [pattern](https://support.google.com/merchants/answer/6324483).
     * For example, polka dots.
     *
     * Generated from protobuf field <code>optional string pattern = 30;</code>
     */
    protected $pattern = null;
    /**
     * Price of the item.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price price = 31;</code>
     */
    protected $price = null;
    /**
     * Maximum retail price (MRP) of the item. Applicable to India only.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price maximum_retail_price = 139;</code>
     */
    protected $maximum_retail_price = null;
    /**
     * Number and amount of installments to pay for an item.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductInstallment installment = 32;</code>
     */
    protected $installment = null;
    /**
     * Number of periods (months or years) and amount of payment per period
     * for an item with an associated subscription contract.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.SubscriptionCost subscription_cost = 33;</code>
     */
    protected $subscription_cost = null;
    /**
     * Loyalty points that users receive after purchasing the item. Japan only.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.LoyaltyPoints loyalty_points = 34;</code>
     */
    protected $loyalty_points = null;
    /**
     * A list of loyalty program information that is used to surface loyalty
     * benefits (for example, better pricing, points, etc) to the user of this
     * item.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.LoyaltyProgram loyalty_programs = 136;</code>
     */
    private $loyalty_programs;
    /**
     * Categories of the item (formatted as in [product data
     * specification](https://support.google.com/merchants/answer/7052112#product_category)).
     *
     * Generated from protobuf field <code>repeated string product_types = 35;</code>
     */
    private $product_types;
    /**
     * Advertised sale price of the item.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price sale_price = 36;</code>
     */
    protected $sale_price = null;
    /**
     * Date range during which the item is on sale, see [product data
     * specification](https://support.google.com/merchants/answer/7052112#price_and_availability).
     *
     * Generated from protobuf field <code>.google.type.Interval sale_price_effective_date = 37;</code>
     */
    protected $sale_price_effective_date = null;
    /**
     * The quantity of the product that is available for selling on Google.
     * Supported only for online products.
     *
     * Generated from protobuf field <code>optional int64 sell_on_google_quantity = 38;</code>
     */
    protected $sell_on_google_quantity = null;
    /**
     * The height of the product in the units provided. The value must be
     * between
     * 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductDimension product_height = 119;</code>
     */
    protected $product_height = null;
    /**
     * The length of the product in the units provided. The value must be
     * between 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductDimension product_length = 120;</code>
     */
    protected $product_length = null;
    /**
     * The width of the product in the units provided. The value must be between
     * 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductDimension product_width = 121;</code>
     */
    protected $product_width = null;
    /**
     * The weight of the product in the units provided. The value must be
     * between 0 (exclusive) and 2000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductWeight product_weight = 122;</code>
     */
    protected $product_weight = null;
    /**
     * Shipping rules.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.Shipping shipping = 39;</code>
     */
    private $shipping;
    /**
     * Conditions to be met for a product to have free shipping.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.FreeShippingThreshold free_shipping_threshold = 135;</code>
     */
    private $free_shipping_threshold;
    /**
     * Weight of the item for shipping.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ShippingWeight shipping_weight = 40;</code>
     */
    protected $shipping_weight = null;
    /**
     * Length of the item for shipping.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ShippingDimension shipping_length = 41;</code>
     */
    protected $shipping_length = null;
    /**
     * Width of the item for shipping.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ShippingDimension shipping_width = 42;</code>
     */
    protected $shipping_width = null;
    /**
     * Height of the item for shipping.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ShippingDimension shipping_height = 43;</code>
     */
    protected $shipping_height = null;
    /**
     * Maximal product handling time (in business days).
     *
     * Generated from protobuf field <code>optional int64 max_handling_time = 44;</code>
     */
    protected $max_handling_time = null;
    /**
     * Minimal product handling time (in business days).
     *
     * Generated from protobuf field <code>optional int64 min_handling_time = 45;</code>
     */
    protected $min_handling_time = null;
    /**
     * The shipping label of the product, used to group product in account-level
     * shipping rules.
     *
     * Generated from protobuf field <code>optional string shipping_label = 46;</code>
     */
    protected $shipping_label = null;
    /**
     * The transit time label of the product, used to group product in
     * account-level transit time tables.
     *
     * Generated from protobuf field <code>optional string transit_time_label = 47;</code>
     */
    protected $transit_time_label = null;
    /**
     * Size of the item. Only one value is allowed. For variants with different
     * sizes, insert a separate product for each size with the same
     * `itemGroupId` value, see
     * [Size](https://support.google.com/merchants/answer/6324492).
     *
     * Generated from protobuf field <code>optional string size = 48;</code>
     */
    protected $size = null;
    /**
     * System in which the size is specified. Recommended for apparel items.
     * For more information, see
     * [Size system](https://support.google.com/merchants/answer/6324502).
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.SizeSystem size_system = 49;</code>
     */
    protected $size_system = null;
    /**
     * The cut of the item. It can be used to represent combined size types for
     * apparel items. Maximum two of size types can be provided, see
     * [Size type](https://support.google.com/merchants/answer/6324497).
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.SizeType size_types = 50;</code>
     */
    private $size_types;
    /**
     * The [energy efficiency
     * class](https://support.google.com/merchants/answer/7562785) as defined in
     * EU directive 2010/30/EU.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.EnergyEfficiencyClass energy_efficiency_class = 53;</code>
     */
    protected $energy_efficiency_class = null;
    /**
     * The [energy efficiency
     * class](https://support.google.com/merchants/answer/7562785) as defined in
     * EU directive 2010/30/EU.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.EnergyEfficiencyClass min_energy_efficiency_class = 54;</code>
     */
    protected $min_energy_efficiency_class = null;
    /**
     * The [energy efficiency
     * class](https://support.google.com/merchants/answer/7562785) as defined in
     * EU directive 2010/30/EU.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.EnergyEfficiencyClass max_energy_efficiency_class = 55;</code>
     */
    protected $max_energy_efficiency_class = null;
    /**
     * The measure and dimension of an item.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.UnitPricingMeasure unit_pricing_measure = 56;</code>
     */
    protected $unit_pricing_measure = null;
    /**
     * The preference of the denominator of the unit price.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.UnitPricingBaseMeasure unit_pricing_base_measure = 57;</code>
     */
    protected $unit_pricing_base_measure = null;
    /**
     * The number of identical products in a business-defined multipack.
     *
     * Generated from protobuf field <code>optional int64 multipack = 58;</code>
     */
    protected $multipack = null;
    /**
     * Used to group items in an arbitrary way. Only for CPA%, discouraged
     * otherwise. For more information, see
     * [Display ads
     * attribute](https://support.google.com/merchants/answer/6069387).
     *
     * Generated from protobuf field <code>optional string ads_grouping = 59;</code>
     */
    protected $ads_grouping = null;
    /**
     * Similar to ads_grouping, but only works on CPC.
     *
     * Generated from protobuf field <code>repeated string ads_labels = 60;</code>
     */
    private $ads_labels;
    /**
     * Allows advertisers to override the item URL when the product is shown
     * within the context of Product ads.
     *
     * Generated from protobuf field <code>optional string ads_redirect = 61;</code>
     */
    protected $ads_redirect = null;
    /**
     * Cost of goods sold. Used for gross profit reporting.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price cost_of_goods_sold = 62;</code>
     */
    protected $cost_of_goods_sold = null;
    /**
     * Technical specification or additional product details.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.ProductDetail product_details = 63;</code>
     */
    private $product_details;
    /**
     * Bullet points describing the most relevant [product
     * highlights](https://support.google.com/merchants/answer/9216100).
     *
     * Generated from protobuf field <code>repeated string product_highlights = 64;</code>
     */
    private $product_highlights;
    /**
     * An identifier for an item for dynamic remarketing campaigns.
     *
     * Generated from protobuf field <code>optional string display_ads_id = 65;</code>
     */
    protected $display_ads_id = null;
    /**
     * Advertiser-specified recommendations. For more information, see
     * [Display ads attribute
     * specification](https://support.google.com/merchants/answer/6069387).
     *
     * Generated from protobuf field <code>repeated string display_ads_similar_ids = 66;</code>
     */
    private $display_ads_similar_ids;
    /**
     * Title of an item for dynamic remarketing campaigns.
     *
     * Generated from protobuf field <code>optional string display_ads_title = 67;</code>
     */
    protected $display_ads_title = null;
    /**
     * URL directly to your item's landing page for dynamic remarketing
     * campaigns.
     *
     * Generated from protobuf field <code>optional string display_ads_link = 68;</code>
     */
    protected $display_ads_link = null;
    /**
     * Offer margin for dynamic remarketing campaigns. For more information, see
     * [Display ads
     * attribute](https://support.google.com/merchants/answer/6069387).
     *
     * Generated from protobuf field <code>optional double display_ads_value = 69;</code>
     */
    protected $display_ads_value = null;
    /**
     * The unique ID of a promotion.
     *
     * Generated from protobuf field <code>repeated string promotion_ids = 70;</code>
     */
    private $promotion_ids;
    /**
     * The [pickup](https://support.google.com/merchants/answer/14634021) option
     * for the item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.PickupMethod pickup_method = 80;</code>
     */
    protected $pickup_method = null;
    /**
     * Item store pickup timeline. For more information, see
     * [Pickup SLA](https://support.google.com/merchants/answer/14635400).
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.PickupSla pickup_sla = 81;</code>
     */
    protected $pickup_sla = null;
    /**
     * [Link template](https://support.google.com/merchants/answer/13871172) for
     * business hosted local storefront.
     *
     * Generated from protobuf field <code>optional string link_template = 82;</code>
     */
    protected $link_template = null;
    /**
     * [Link template](https://support.google.com/merchants/answer/13870216) for
     * business hosted local storefront optimized for mobile
     * devices.
     *
     * Generated from protobuf field <code>optional string mobile_link_template = 83;</code>
     */
    protected $mobile_link_template = null;
    /**
     * [Custom label 0](https://support.google.com/merchants/answer/6324473) for
     * custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_0 = 71;</code>
     */
    protected $custom_label_0 = null;
    /**
     * [Custom label 1](https://support.google.com/merchants/answer/6324473)
     * for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_1 = 72;</code>
     */
    protected $custom_label_1 = null;
    /**
     * [Custom label 2](https://support.google.com/merchants/answer/6324473)
     * for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_2 = 73;</code>
     */
    protected $custom_label_2 = null;
    /**
     * [Custom label 3](https://support.google.com/merchants/answer/6324473)
     * for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_3 = 74;</code>
     */
    protected $custom_label_3 = null;
    /**
     * [Custom label 4](https://support.google.com/merchants/answer/6324473) for
     * custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_4 = 75;</code>
     */
    protected $custom_label_4 = null;
    /**
     * The list of destinations to include for this target (corresponds to
     * checked check boxes in Merchant Center). Default destinations are always
     * included unless provided in `excludedDestinations`.
     * For more information, see
     * [Included
     * destination](https://support.google.com/merchants/answer/7501026).
     * Note: We recommend setting destinations on datasources level for most use
     * cases. Use this field within products to only setup exceptions.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.Destination.DestinationEnum included_destinations = 76;</code>
     */
    private $included_destinations;
    /**
     * The list of destinations to exclude for this target (corresponds to
     * unchecked check boxes in Merchant Center).
     * For more information, see
     * [Excluded
     * destination](https://support.google.com/merchants/answer/6324486).
     * Note: We recommend setting destinations on datasources level for most use
     * cases. Use this field within products to only setup exceptions.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.Destination.DestinationEnum excluded_destinations = 77;</code>
     */
    private $excluded_destinations;
    /**
     * List of country codes [(ISO 3166-1
     * alpha-2)](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) to exclude the
     * offer from Shopping Ads destination. Countries from this list are removed
     * from countries configured in data source settings.
     *
     * Generated from protobuf field <code>repeated string shopping_ads_excluded_countries = 78;</code>
     */
    private $shopping_ads_excluded_countries;
    /**
     * Required for multi-seller accounts. Use this attribute if you're a
     * marketplace uploading products for various sellers to your multi-seller
     * account.
     *
     * Generated from protobuf field <code>optional string external_seller_id = 1;</code>
     */
    protected $external_seller_id = null;
    /**
     * Publication of this item will be temporarily
     * [paused](https://support.google.com/merchants/answer/11909930).
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.Pause pause = 13;</code>
     */
    protected $pause = null;
    /**
     * Additional URLs of lifestyle images of the item, used to explicitly
     * identify images that showcase your item in a real-world context. See the
     * [Help Center article](https://support.google.com/merchants/answer/9103186)
     * for more information.
     *
     * Generated from protobuf field <code>repeated string lifestyle_image_links = 14;</code>
     */
    private $lifestyle_image_links;
    /**
     * Extra fields to export to the Cloud Retail program.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.CloudExportAdditionalProperties cloud_export_additional_properties = 84;</code>
     */
    private $cloud_export_additional_properties;
    /**
     * URL of the 3D image of the item. See the
     * [Help Center article](https://support.google.com/merchants/answer/13674896)
     * for more information.
     *
     * Generated from protobuf field <code>optional string virtual_model_link = 130;</code>
     */
    protected $virtual_model_link = null;
    /**
     * Product Certifications, for example for energy efficiency labeling of
     * products recorded in the [EU EPREL](https://eprel.ec.europa.eu/screen/home)
     * database. See the [Help
     * Center](https://support.google.com/merchants/answer/13528839)
     * article for more information.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.ProductCertification certifications = 123;</code>
     */
    private $certifications;
    /**
     * Structured title, for algorithmically (AI)-generated titles.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.StructuredTitle structured_title = 132;</code>
     */
    protected $structured_title = null;
    /**
     * Structured description, for algorithmically (AI)-generated descriptions.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.StructuredDescription structured_description = 133;</code>
     */
    protected $structured_description = null;
    /**
     * A safeguard in the [automated discounts]
     * (https://support.google.com/merchants/answer/10295759) and
     * "Dynamic Promotions"
     * (https://support.google.com/merchants/answer/13949249) projects,
     * ensuring that discounts on business offers do not fall below this value,
     * thereby preserving the offer's value and profitability.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price auto_pricing_min_price = 124;</code>
     */
    protected $auto_pricing_min_price = null;
    /**
     * The list of sustainability incentive programs.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.ProductSustainabilityIncentive sustainability_incentives = 138;</code>
     */
    private $sustainability_incentives;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $identifier_exists
     *           Set this value to false when the item does not have unique product
     *           identifiers appropriate to its category, such as GTIN, MPN, and brand.
     *           Defaults to true, if not provided.
     *     @type bool $is_bundle
     *           Whether the item is a business-defined sub-API. A [sub-API]
     *           (https://support.google.com/merchants/answer/6324449) is a custom
     *           grouping of different products sold by a business for a single price.
     *     @type string $title
     *           Title of the item.
     *     @type string $description
     *           Description of the item.
     *     @type string $link
     *           URL directly linking to your item's page on your online store.
     *     @type string $mobile_link
     *           URL for the mobile-optimized version of your item's landing page.
     *     @type string $canonical_link
     *           URL for the canonical version of your item's landing page.
     *     @type string $image_link
     *           URL of an image of the item.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $additional_image_links
     *           Additional URLs of images of the item.
     *     @type \Google\Protobuf\Timestamp $expiration_date
     *           Date on which the item should expire, as specified upon insertion, in
     *           [ISO
     *           8601](http://en.wikipedia.org/wiki/ISO_8601) format. The actual
     *           expiration date is exposed in `productstatuses` as
     *           [googleExpirationDate](https://support.google.com/merchants/answer/6324499)
     *           and might be earlier if `expirationDate` is too far in the future.
     *     @type \Google\Protobuf\Timestamp $disclosure_date
     *           The date time when an offer becomes visible in search results across
     *           Google’s YouTube surfaces, in [ISO
     *           8601](http://en.wikipedia.org/wiki/ISO_8601) format.
     *           See [Disclosure date](https://support.google.com/merchants/answer/13034208)
     *           for more information.
     *     @type bool $adult
     *           Set to true if the item is targeted towards adults.
     *     @type int $age_group
     *           Target [age group](https://support.google.com/merchants/answer/6324463) of
     *           the item.
     *     @type int $availability
     *           [Availability](https://support.google.com/merchants/answer/6324448) status
     *           of the item.
     *     @type \Google\Protobuf\Timestamp $availability_date
     *           The day a pre-ordered product becomes available for delivery, in [ISO
     *           8601](http://en.wikipedia.org/wiki/ISO_8601) format.
     *     @type string $brand
     *           [Brand](https://support.google.com/merchants/answer/6324351) of the item.
     *           For example, "Google".
     *     @type string $color
     *           [Color](https://support.google.com/merchants/answer/6324487) of the item.
     *           For example, "red".
     *     @type int $condition
     *           [Condition](https://support.google.com/merchants/answer/6324469) or state
     *           of the item.
     *     @type int $gender
     *           Target [gender](https://support.google.com/merchants/answer/6324479) of the
     *           item.
     *     @type string $google_product_category
     *           Google's category of the item (see [Google product
     *           taxonomy](https://support.google.com/merchants/answer/1705911)). When
     *           querying products, this field will contain the user provided value. There
     *           is currently no way to get back the auto assigned google product
     *           categories through the API.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $gtins
     *           Global Trade Item Numbers
     *           ([GTIN](https://support.google.com/merchants/answer/188494#gtin)) of the
     *           item.
     *           You can provide up to 10 GTINs.
     *     @type string $item_group_id
     *           Shared identifier for all variants of the same product.
     *     @type string $material
     *           The [material](https://support.google.com/merchants/answer/6324410) of
     *           which the item is made. For example, "Leather" or "Cotton".
     *     @type string $mpn
     *           Manufacturer Part Number
     *           ([MPN](https://support.google.com/merchants/answer/188494#mpn)) of the
     *           item.
     *     @type string $pattern
     *           The item's [pattern](https://support.google.com/merchants/answer/6324483).
     *           For example, polka dots.
     *     @type \Google\Shopping\Type\Price $price
     *           Price of the item.
     *     @type \Google\Shopping\Type\Price $maximum_retail_price
     *           Maximum retail price (MRP) of the item. Applicable to India only.
     *     @type \Google\Shopping\Merchant\Products\V1\ProductInstallment $installment
     *           Number and amount of installments to pay for an item.
     *     @type \Google\Shopping\Merchant\Products\V1\SubscriptionCost $subscription_cost
     *           Number of periods (months or years) and amount of payment per period
     *           for an item with an associated subscription contract.
     *     @type \Google\Shopping\Merchant\Products\V1\LoyaltyPoints $loyalty_points
     *           Loyalty points that users receive after purchasing the item. Japan only.
     *     @type array<\Google\Shopping\Merchant\Products\V1\LoyaltyProgram>|\Google\Protobuf\Internal\RepeatedField $loyalty_programs
     *           A list of loyalty program information that is used to surface loyalty
     *           benefits (for example, better pricing, points, etc) to the user of this
     *           item.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $product_types
     *           Categories of the item (formatted as in [product data
     *           specification](https://support.google.com/merchants/answer/7052112#product_category)).
     *     @type \Google\Shopping\Type\Price $sale_price
     *           Advertised sale price of the item.
     *     @type \Google\Type\Interval $sale_price_effective_date
     *           Date range during which the item is on sale, see [product data
     *           specification](https://support.google.com/merchants/answer/7052112#price_and_availability).
     *     @type int|string $sell_on_google_quantity
     *           The quantity of the product that is available for selling on Google.
     *           Supported only for online products.
     *     @type \Google\Shopping\Merchant\Products\V1\ProductDimension $product_height
     *           The height of the product in the units provided. The value must be
     *           between
     *           0 (exclusive) and 3000 (inclusive).
     *     @type \Google\Shopping\Merchant\Products\V1\ProductDimension $product_length
     *           The length of the product in the units provided. The value must be
     *           between 0 (exclusive) and 3000 (inclusive).
     *     @type \Google\Shopping\Merchant\Products\V1\ProductDimension $product_width
     *           The width of the product in the units provided. The value must be between
     *           0 (exclusive) and 3000 (inclusive).
     *     @type \Google\Shopping\Merchant\Products\V1\ProductWeight $product_weight
     *           The weight of the product in the units provided. The value must be
     *           between 0 (exclusive) and 2000 (inclusive).
     *     @type array<\Google\Shopping\Merchant\Products\V1\Shipping>|\Google\Protobuf\Internal\RepeatedField $shipping
     *           Shipping rules.
     *     @type array<\Google\Shopping\Merchant\Products\V1\FreeShippingThreshold>|\Google\Protobuf\Internal\RepeatedField $free_shipping_threshold
     *           Conditions to be met for a product to have free shipping.
     *     @type \Google\Shopping\Merchant\Products\V1\ShippingWeight $shipping_weight
     *           Weight of the item for shipping.
     *     @type \Google\Shopping\Merchant\Products\V1\ShippingDimension $shipping_length
     *           Length of the item for shipping.
     *     @type \Google\Shopping\Merchant\Products\V1\ShippingDimension $shipping_width
     *           Width of the item for shipping.
     *     @type \Google\Shopping\Merchant\Products\V1\ShippingDimension $shipping_height
     *           Height of the item for shipping.
     *     @type int|string $max_handling_time
     *           Maximal product handling time (in business days).
     *     @type int|string $min_handling_time
     *           Minimal product handling time (in business days).
     *     @type string $shipping_label
     *           The shipping label of the product, used to group product in account-level
     *           shipping rules.
     *     @type string $transit_time_label
     *           The transit time label of the product, used to group product in
     *           account-level transit time tables.
     *     @type string $size
     *           Size of the item. Only one value is allowed. For variants with different
     *           sizes, insert a separate product for each size with the same
     *           `itemGroupId` value, see
     *           [Size](https://support.google.com/merchants/answer/6324492).
     *     @type int $size_system
     *           System in which the size is specified. Recommended for apparel items.
     *           For more information, see
     *           [Size system](https://support.google.com/merchants/answer/6324502).
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $size_types
     *           The cut of the item. It can be used to represent combined size types for
     *           apparel items. Maximum two of size types can be provided, see
     *           [Size type](https://support.google.com/merchants/answer/6324497).
     *     @type int $energy_efficiency_class
     *           The [energy efficiency
     *           class](https://support.google.com/merchants/answer/7562785) as defined in
     *           EU directive 2010/30/EU.
     *     @type int $min_energy_efficiency_class
     *           The [energy efficiency
     *           class](https://support.google.com/merchants/answer/7562785) as defined in
     *           EU directive 2010/30/EU.
     *     @type int $max_energy_efficiency_class
     *           The [energy efficiency
     *           class](https://support.google.com/merchants/answer/7562785) as defined in
     *           EU directive 2010/30/EU.
     *     @type \Google\Shopping\Merchant\Products\V1\UnitPricingMeasure $unit_pricing_measure
     *           The measure and dimension of an item.
     *     @type \Google\Shopping\Merchant\Products\V1\UnitPricingBaseMeasure $unit_pricing_base_measure
     *           The preference of the denominator of the unit price.
     *     @type int|string $multipack
     *           The number of identical products in a business-defined multipack.
     *     @type string $ads_grouping
     *           Used to group items in an arbitrary way. Only for CPA%, discouraged
     *           otherwise. For more information, see
     *           [Display ads
     *           attribute](https://support.google.com/merchants/answer/6069387).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $ads_labels
     *           Similar to ads_grouping, but only works on CPC.
     *     @type string $ads_redirect
     *           Allows advertisers to override the item URL when the product is shown
     *           within the context of Product ads.
     *     @type \Google\Shopping\Type\Price $cost_of_goods_sold
     *           Cost of goods sold. Used for gross profit reporting.
     *     @type array<\Google\Shopping\Merchant\Products\V1\ProductDetail>|\Google\Protobuf\Internal\RepeatedField $product_details
     *           Technical specification or additional product details.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $product_highlights
     *           Bullet points describing the most relevant [product
     *           highlights](https://support.google.com/merchants/answer/9216100).
     *     @type string $display_ads_id
     *           An identifier for an item for dynamic remarketing campaigns.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $display_ads_similar_ids
     *           Advertiser-specified recommendations. For more information, see
     *           [Display ads attribute
     *           specification](https://support.google.com/merchants/answer/6069387).
     *     @type string $display_ads_title
     *           Title of an item for dynamic remarketing campaigns.
     *     @type string $display_ads_link
     *           URL directly to your item's landing page for dynamic remarketing
     *           campaigns.
     *     @type float $display_ads_value
     *           Offer margin for dynamic remarketing campaigns. For more information, see
     *           [Display ads
     *           attribute](https://support.google.com/merchants/answer/6069387).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $promotion_ids
     *           The unique ID of a promotion.
     *     @type int $pickup_method
     *           The [pickup](https://support.google.com/merchants/answer/14634021) option
     *           for the item.
     *     @type int $pickup_sla
     *           Item store pickup timeline. For more information, see
     *           [Pickup SLA](https://support.google.com/merchants/answer/14635400).
     *     @type string $link_template
     *           [Link template](https://support.google.com/merchants/answer/13871172) for
     *           business hosted local storefront.
     *     @type string $mobile_link_template
     *           [Link template](https://support.google.com/merchants/answer/13870216) for
     *           business hosted local storefront optimized for mobile
     *           devices.
     *     @type string $custom_label_0
     *           [Custom label 0](https://support.google.com/merchants/answer/6324473) for
     *           custom grouping of items in a Shopping campaign.
     *     @type string $custom_label_1
     *           [Custom label 1](https://support.google.com/merchants/answer/6324473)
     *           for custom grouping of items in a Shopping campaign.
     *     @type string $custom_label_2
     *           [Custom label 2](https://support.google.com/merchants/answer/6324473)
     *           for custom grouping of items in a Shopping campaign.
     *     @type string $custom_label_3
     *           [Custom label 3](https://support.google.com/merchants/answer/6324473)
     *           for custom grouping of items in a Shopping campaign.
     *     @type string $custom_label_4
     *           [Custom label 4](https://support.google.com/merchants/answer/6324473) for
     *           custom grouping of items in a Shopping campaign.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $included_destinations
     *           The list of destinations to include for this target (corresponds to
     *           checked check boxes in Merchant Center). Default destinations are always
     *           included unless provided in `excludedDestinations`.
     *           For more information, see
     *           [Included
     *           destination](https://support.google.com/merchants/answer/7501026).
     *           Note: We recommend setting destinations on datasources level for most use
     *           cases. Use this field within products to only setup exceptions.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $excluded_destinations
     *           The list of destinations to exclude for this target (corresponds to
     *           unchecked check boxes in Merchant Center).
     *           For more information, see
     *           [Excluded
     *           destination](https://support.google.com/merchants/answer/6324486).
     *           Note: We recommend setting destinations on datasources level for most use
     *           cases. Use this field within products to only setup exceptions.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $shopping_ads_excluded_countries
     *           List of country codes [(ISO 3166-1
     *           alpha-2)](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) to exclude the
     *           offer from Shopping Ads destination. Countries from this list are removed
     *           from countries configured in data source settings.
     *     @type string $external_seller_id
     *           Required for multi-seller accounts. Use this attribute if you're a
     *           marketplace uploading products for various sellers to your multi-seller
     *           account.
     *     @type int $pause
     *           Publication of this item will be temporarily
     *           [paused](https://support.google.com/merchants/answer/11909930).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $lifestyle_image_links
     *           Additional URLs of lifestyle images of the item, used to explicitly
     *           identify images that showcase your item in a real-world context. See the
     *           [Help Center article](https://support.google.com/merchants/answer/9103186)
     *           for more information.
     *     @type array<\Google\Shopping\Merchant\Products\V1\CloudExportAdditionalProperties>|\Google\Protobuf\Internal\RepeatedField $cloud_export_additional_properties
     *           Extra fields to export to the Cloud Retail program.
     *     @type string $virtual_model_link
     *           URL of the 3D image of the item. See the
     *           [Help Center article](https://support.google.com/merchants/answer/13674896)
     *           for more information.
     *     @type array<\Google\Shopping\Merchant\Products\V1\ProductCertification>|\Google\Protobuf\Internal\RepeatedField $certifications
     *           Product Certifications, for example for energy efficiency labeling of
     *           products recorded in the [EU EPREL](https://eprel.ec.europa.eu/screen/home)
     *           database. See the [Help
     *           Center](https://support.google.com/merchants/answer/13528839)
     *           article for more information.
     *     @type \Google\Shopping\Merchant\Products\V1\StructuredTitle $structured_title
     *           Structured title, for algorithmically (AI)-generated titles.
     *     @type \Google\Shopping\Merchant\Products\V1\StructuredDescription $structured_description
     *           Structured description, for algorithmically (AI)-generated descriptions.
     *     @type \Google\Shopping\Type\Price $auto_pricing_min_price
     *           A safeguard in the [automated discounts]
     *           (https://support.google.com/merchants/answer/10295759) and
     *           "Dynamic Promotions"
     *           (https://support.google.com/merchants/answer/13949249) projects,
     *           ensuring that discounts on business offers do not fall below this value,
     *           thereby preserving the offer's value and profitability.
     *     @type array<\Google\Shopping\Merchant\Products\V1\ProductSustainabilityIncentive>|\Google\Protobuf\Internal\RepeatedField $sustainability_incentives
     *           The list of sustainability incentive programs.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Products\V1\ProductsCommon::initOnce();
        parent::__construct($data);
    }

    /**
     * Set this value to false when the item does not have unique product
     * identifiers appropriate to its category, such as GTIN, MPN, and brand.
     * Defaults to true, if not provided.
     *
     * Generated from protobuf field <code>optional bool identifier_exists = 4;</code>
     * @return bool
     */
    public function getIdentifierExists()
    {
        return isset($this->identifier_exists) ? $this->identifier_exists : false;
    }

    public function hasIdentifierExists()
    {
        return isset($this->identifier_exists);
    }

    public function clearIdentifierExists()
    {
        unset($this->identifier_exists);
    }

    /**
     * Set this value to false when the item does not have unique product
     * identifiers appropriate to its category, such as GTIN, MPN, and brand.
     * Defaults to true, if not provided.
     *
     * Generated from protobuf field <code>optional bool identifier_exists = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setIdentifierExists($var)
    {
        GPBUtil::checkBool($var);
        $this->identifier_exists = $var;

        return $this;
    }

    /**
     * Whether the item is a business-defined sub-API. A [sub-API]
     * (https://support.google.com/merchants/answer/6324449) is a custom
     * grouping of different products sold by a business for a single price.
     *
     * Generated from protobuf field <code>optional bool is_bundle = 5;</code>
     * @return bool
     */
    public function getIsBundle()
    {
        return isset($this->is_bundle) ? $this->is_bundle : false;
    }

    public function hasIsBundle()
    {
        return isset($this->is_bundle);
    }

    public function clearIsBundle()
    {
        unset($this->is_bundle);
    }

    /**
     * Whether the item is a business-defined sub-API. A [sub-API]
     * (https://support.google.com/merchants/answer/6324449) is a custom
     * grouping of different products sold by a business for a single price.
     *
     * Generated from protobuf field <code>optional bool is_bundle = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsBundle($var)
    {
        GPBUtil::checkBool($var);
        $this->is_bundle = $var;

        return $this;
    }

    /**
     * Title of the item.
     *
     * Generated from protobuf field <code>optional string title = 6;</code>
     * @return string
     */
    public function getTitle()
    {
        return isset($this->title) ? $this->title : '';
    }

    public function hasTitle()
    {
        return isset($this->title);
    }

    public function clearTitle()
    {
        unset($this->title);
    }

    /**
     * Title of the item.
     *
     * Generated from protobuf field <code>optional string title = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->title = $var;

        return $this;
    }

    /**
     * Description of the item.
     *
     * Generated from protobuf field <code>optional string description = 7;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * Description of the item.
     *
     * Generated from protobuf field <code>optional string description = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * URL directly linking to your item's page on your online store.
     *
     * Generated from protobuf field <code>optional string link = 8;</code>
     * @return string
     */
    public function getLink()
    {
        return isset($this->link) ? $this->link : '';
    }

    public function hasLink()
    {
        return isset($this->link);
    }

    public function clearLink()
    {
        unset($this->link);
    }

    /**
     * URL directly linking to your item's page on your online store.
     *
     * Generated from protobuf field <code>optional string link = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->link = $var;

        return $this;
    }

    /**
     * URL for the mobile-optimized version of your item's landing page.
     *
     * Generated from protobuf field <code>optional string mobile_link = 9;</code>
     * @return string
     */
    public function getMobileLink()
    {
        return isset($this->mobile_link) ? $this->mobile_link : '';
    }

    public function hasMobileLink()
    {
        return isset($this->mobile_link);
    }

    public function clearMobileLink()
    {
        unset($this->mobile_link);
    }

    /**
     * URL for the mobile-optimized version of your item's landing page.
     *
     * Generated from protobuf field <code>optional string mobile_link = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setMobileLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->mobile_link = $var;

        return $this;
    }

    /**
     * URL for the canonical version of your item's landing page.
     *
     * Generated from protobuf field <code>optional string canonical_link = 10;</code>
     * @return string
     */
    public function getCanonicalLink()
    {
        return isset($this->canonical_link) ? $this->canonical_link : '';
    }

    public function hasCanonicalLink()
    {
        return isset($this->canonical_link);
    }

    public function clearCanonicalLink()
    {
        unset($this->canonical_link);
    }

    /**
     * URL for the canonical version of your item's landing page.
     *
     * Generated from protobuf field <code>optional string canonical_link = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setCanonicalLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->canonical_link = $var;

        return $this;
    }

    /**
     * URL of an image of the item.
     *
     * Generated from protobuf field <code>optional string image_link = 11;</code>
     * @return string
     */
    public function getImageLink()
    {
        return isset($this->image_link) ? $this->image_link : '';
    }

    public function hasImageLink()
    {
        return isset($this->image_link);
    }

    public function clearImageLink()
    {
        unset($this->image_link);
    }

    /**
     * URL of an image of the item.
     *
     * Generated from protobuf field <code>optional string image_link = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setImageLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->image_link = $var;

        return $this;
    }

    /**
     * Additional URLs of images of the item.
     *
     * Generated from protobuf field <code>repeated string additional_image_links = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdditionalImageLinks()
    {
        return $this->additional_image_links;
    }

    /**
     * Additional URLs of images of the item.
     *
     * Generated from protobuf field <code>repeated string additional_image_links = 12;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdditionalImageLinks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->additional_image_links = $arr;

        return $this;
    }

    /**
     * Date on which the item should expire, as specified upon insertion, in
     * [ISO
     * 8601](http://en.wikipedia.org/wiki/ISO_8601) format. The actual
     * expiration date is exposed in `productstatuses` as
     * [googleExpirationDate](https://support.google.com/merchants/answer/6324499)
     * and might be earlier if `expirationDate` is too far in the future.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expiration_date = 16;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpirationDate()
    {
        return $this->expiration_date;
    }

    public function hasExpirationDate()
    {
        return isset($this->expiration_date);
    }

    public function clearExpirationDate()
    {
        unset($this->expiration_date);
    }

    /**
     * Date on which the item should expire, as specified upon insertion, in
     * [ISO
     * 8601](http://en.wikipedia.org/wiki/ISO_8601) format. The actual
     * expiration date is exposed in `productstatuses` as
     * [googleExpirationDate](https://support.google.com/merchants/answer/6324499)
     * and might be earlier if `expirationDate` is too far in the future.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expiration_date = 16;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpirationDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expiration_date = $var;

        return $this;
    }

    /**
     * The date time when an offer becomes visible in search results across
     * Google’s YouTube surfaces, in [ISO
     * 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
     * See [Disclosure date](https://support.google.com/merchants/answer/13034208)
     * for more information.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp disclosure_date = 79;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDisclosureDate()
    {
        return $this->disclosure_date;
    }

    public function hasDisclosureDate()
    {
        return isset($this->disclosure_date);
    }

    public function clearDisclosureDate()
    {
        unset($this->disclosure_date);
    }

    /**
     * The date time when an offer becomes visible in search results across
     * Google’s YouTube surfaces, in [ISO
     * 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
     * See [Disclosure date](https://support.google.com/merchants/answer/13034208)
     * for more information.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp disclosure_date = 79;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDisclosureDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->disclosure_date = $var;

        return $this;
    }

    /**
     * Set to true if the item is targeted towards adults.
     *
     * Generated from protobuf field <code>optional bool adult = 17;</code>
     * @return bool
     */
    public function getAdult()
    {
        return isset($this->adult) ? $this->adult : false;
    }

    public function hasAdult()
    {
        return isset($this->adult);
    }

    public function clearAdult()
    {
        unset($this->adult);
    }

    /**
     * Set to true if the item is targeted towards adults.
     *
     * Generated from protobuf field <code>optional bool adult = 17;</code>
     * @param bool $var
     * @return $this
     */
    public function setAdult($var)
    {
        GPBUtil::checkBool($var);
        $this->adult = $var;

        return $this;
    }

    /**
     * Target [age group](https://support.google.com/merchants/answer/6324463) of
     * the item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.AgeGroup age_group = 18;</code>
     * @return int
     */
    public function getAgeGroup()
    {
        return isset($this->age_group) ? $this->age_group : 0;
    }

    public function hasAgeGroup()
    {
        return isset($this->age_group);
    }

    public function clearAgeGroup()
    {
        unset($this->age_group);
    }

    /**
     * Target [age group](https://support.google.com/merchants/answer/6324463) of
     * the item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.AgeGroup age_group = 18;</code>
     * @param int $var
     * @return $this
     */
    public function setAgeGroup($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\AgeGroup::class);
        $this->age_group = $var;

        return $this;
    }

    /**
     * [Availability](https://support.google.com/merchants/answer/6324448) status
     * of the item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.Availability availability = 19;</code>
     * @return int
     */
    public function getAvailability()
    {
        return isset($this->availability) ? $this->availability : 0;
    }

    public function hasAvailability()
    {
        return isset($this->availability);
    }

    public function clearAvailability()
    {
        unset($this->availability);
    }

    /**
     * [Availability](https://support.google.com/merchants/answer/6324448) status
     * of the item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.Availability availability = 19;</code>
     * @param int $var
     * @return $this
     */
    public function setAvailability($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\Availability::class);
        $this->availability = $var;

        return $this;
    }

    /**
     * The day a pre-ordered product becomes available for delivery, in [ISO
     * 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp availability_date = 20;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getAvailabilityDate()
    {
        return $this->availability_date;
    }

    public function hasAvailabilityDate()
    {
        return isset($this->availability_date);
    }

    public function clearAvailabilityDate()
    {
        unset($this->availability_date);
    }

    /**
     * The day a pre-ordered product becomes available for delivery, in [ISO
     * 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp availability_date = 20;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setAvailabilityDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->availability_date = $var;

        return $this;
    }

    /**
     * [Brand](https://support.google.com/merchants/answer/6324351) of the item.
     * For example, "Google".
     *
     * Generated from protobuf field <code>optional string brand = 21;</code>
     * @return string
     */
    public function getBrand()
    {
        return isset($this->brand) ? $this->brand : '';
    }

    public function hasBrand()
    {
        return isset($this->brand);
    }

    public function clearBrand()
    {
        unset($this->brand);
    }

    /**
     * [Brand](https://support.google.com/merchants/answer/6324351) of the item.
     * For example, "Google".
     *
     * Generated from protobuf field <code>optional string brand = 21;</code>
     * @param string $var
     * @return $this
     */
    public function setBrand($var)
    {
        GPBUtil::checkString($var, True);
        $this->brand = $var;

        return $this;
    }

    /**
     * [Color](https://support.google.com/merchants/answer/6324487) of the item.
     * For example, "red".
     *
     * Generated from protobuf field <code>optional string color = 22;</code>
     * @return string
     */
    public function getColor()
    {
        return isset($this->color) ? $this->color : '';
    }

    public function hasColor()
    {
        return isset($this->color);
    }

    public function clearColor()
    {
        unset($this->color);
    }

    /**
     * [Color](https://support.google.com/merchants/answer/6324487) of the item.
     * For example, "red".
     *
     * Generated from protobuf field <code>optional string color = 22;</code>
     * @param string $var
     * @return $this
     */
    public function setColor($var)
    {
        GPBUtil::checkString($var, True);
        $this->color = $var;

        return $this;
    }

    /**
     * [Condition](https://support.google.com/merchants/answer/6324469) or state
     * of the item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.Condition condition = 23;</code>
     * @return int
     */
    public function getCondition()
    {
        return isset($this->condition) ? $this->condition : 0;
    }

    public function hasCondition()
    {
        return isset($this->condition);
    }

    public function clearCondition()
    {
        unset($this->condition);
    }

    /**
     * [Condition](https://support.google.com/merchants/answer/6324469) or state
     * of the item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.Condition condition = 23;</code>
     * @param int $var
     * @return $this
     */
    public function setCondition($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\Condition::class);
        $this->condition = $var;

        return $this;
    }

    /**
     * Target [gender](https://support.google.com/merchants/answer/6324479) of the
     * item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.Gender gender = 24;</code>
     * @return int
     */
    public function getGender()
    {
        return isset($this->gender) ? $this->gender : 0;
    }

    public function hasGender()
    {
        return isset($this->gender);
    }

    public function clearGender()
    {
        unset($this->gender);
    }

    /**
     * Target [gender](https://support.google.com/merchants/answer/6324479) of the
     * item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.Gender gender = 24;</code>
     * @param int $var
     * @return $this
     */
    public function setGender($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\Gender::class);
        $this->gender = $var;

        return $this;
    }

    /**
     * Google's category of the item (see [Google product
     * taxonomy](https://support.google.com/merchants/answer/1705911)). When
     * querying products, this field will contain the user provided value. There
     * is currently no way to get back the auto assigned google product
     * categories through the API.
     *
     * Generated from protobuf field <code>optional string google_product_category = 25;</code>
     * @return string
     */
    public function getGoogleProductCategory()
    {
        return isset($this->google_product_category) ? $this->google_product_category : '';
    }

    public function hasGoogleProductCategory()
    {
        return isset($this->google_product_category);
    }

    public function clearGoogleProductCategory()
    {
        unset($this->google_product_category);
    }

    /**
     * Google's category of the item (see [Google product
     * taxonomy](https://support.google.com/merchants/answer/1705911)). When
     * querying products, this field will contain the user provided value. There
     * is currently no way to get back the auto assigned google product
     * categories through the API.
     *
     * Generated from protobuf field <code>optional string google_product_category = 25;</code>
     * @param string $var
     * @return $this
     */
    public function setGoogleProductCategory($var)
    {
        GPBUtil::checkString($var, True);
        $this->google_product_category = $var;

        return $this;
    }

    /**
     * Global Trade Item Numbers
     * ([GTIN](https://support.google.com/merchants/answer/188494#gtin)) of the
     * item.
     * You can provide up to 10 GTINs.
     *
     * Generated from protobuf field <code>repeated string gtins = 140;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGtins()
    {
        return $this->gtins;
    }

    /**
     * Global Trade Item Numbers
     * ([GTIN](https://support.google.com/merchants/answer/188494#gtin)) of the
     * item.
     * You can provide up to 10 GTINs.
     *
     * Generated from protobuf field <code>repeated string gtins = 140;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGtins($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->gtins = $arr;

        return $this;
    }

    /**
     * Shared identifier for all variants of the same product.
     *
     * Generated from protobuf field <code>optional string item_group_id = 27;</code>
     * @return string
     */
    public function getItemGroupId()
    {
        return isset($this->item_group_id) ? $this->item_group_id : '';
    }

    public function hasItemGroupId()
    {
        return isset($this->item_group_id);
    }

    public function clearItemGroupId()
    {
        unset($this->item_group_id);
    }

    /**
     * Shared identifier for all variants of the same product.
     *
     * Generated from protobuf field <code>optional string item_group_id = 27;</code>
     * @param string $var
     * @return $this
     */
    public function setItemGroupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->item_group_id = $var;

        return $this;
    }

    /**
     * The [material](https://support.google.com/merchants/answer/6324410) of
     * which the item is made. For example, "Leather" or "Cotton".
     *
     * Generated from protobuf field <code>optional string material = 28;</code>
     * @return string
     */
    public function getMaterial()
    {
        return isset($this->material) ? $this->material : '';
    }

    public function hasMaterial()
    {
        return isset($this->material);
    }

    public function clearMaterial()
    {
        unset($this->material);
    }

    /**
     * The [material](https://support.google.com/merchants/answer/6324410) of
     * which the item is made. For example, "Leather" or "Cotton".
     *
     * Generated from protobuf field <code>optional string material = 28;</code>
     * @param string $var
     * @return $this
     */
    public function setMaterial($var)
    {
        GPBUtil::checkString($var, True);
        $this->material = $var;

        return $this;
    }

    /**
     * Manufacturer Part Number
     * ([MPN](https://support.google.com/merchants/answer/188494#mpn)) of the
     * item.
     *
     * Generated from protobuf field <code>optional string mpn = 29;</code>
     * @return string
     */
    public function getMpn()
    {
        return isset($this->mpn) ? $this->mpn : '';
    }

    public function hasMpn()
    {
        return isset($this->mpn);
    }

    public function clearMpn()
    {
        unset($this->mpn);
    }

    /**
     * Manufacturer Part Number
     * ([MPN](https://support.google.com/merchants/answer/188494#mpn)) of the
     * item.
     *
     * Generated from protobuf field <code>optional string mpn = 29;</code>
     * @param string $var
     * @return $this
     */
    public function setMpn($var)
    {
        GPBUtil::checkString($var, True);
        $this->mpn = $var;

        return $this;
    }

    /**
     * The item's [pattern](https://support.google.com/merchants/answer/6324483).
     * For example, polka dots.
     *
     * Generated from protobuf field <code>optional string pattern = 30;</code>
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : '';
    }

    public function hasPattern()
    {
        return isset($this->pattern);
    }

    public function clearPattern()
    {
        unset($this->pattern);
    }

    /**
     * The item's [pattern](https://support.google.com/merchants/answer/6324483).
     * For example, polka dots.
     *
     * Generated from protobuf field <code>optional string pattern = 30;</code>
     * @param string $var
     * @return $this
     */
    public function setPattern($var)
    {
        GPBUtil::checkString($var, True);
        $this->pattern = $var;

        return $this;
    }

    /**
     * Price of the item.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price price = 31;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getPrice()
    {
        return $this->price;
    }

    public function hasPrice()
    {
        return isset($this->price);
    }

    public function clearPrice()
    {
        unset($this->price);
    }

    /**
     * Price of the item.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price price = 31;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setPrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->price = $var;

        return $this;
    }

    /**
     * Maximum retail price (MRP) of the item. Applicable to India only.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price maximum_retail_price = 139;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getMaximumRetailPrice()
    {
        return $this->maximum_retail_price;
    }

    public function hasMaximumRetailPrice()
    {
        return isset($this->maximum_retail_price);
    }

    public function clearMaximumRetailPrice()
    {
        unset($this->maximum_retail_price);
    }

    /**
     * Maximum retail price (MRP) of the item. Applicable to India only.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price maximum_retail_price = 139;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setMaximumRetailPrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->maximum_retail_price = $var;

        return $this;
    }

    /**
     * Number and amount of installments to pay for an item.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductInstallment installment = 32;</code>
     * @return \Google\Shopping\Merchant\Products\V1\ProductInstallment|null
     */
    public function getInstallment()
    {
        return $this->installment;
    }

    public function hasInstallment()
    {
        return isset($this->installment);
    }

    public function clearInstallment()
    {
        unset($this->installment);
    }

    /**
     * Number and amount of installments to pay for an item.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductInstallment installment = 32;</code>
     * @param \Google\Shopping\Merchant\Products\V1\ProductInstallment $var
     * @return $this
     */
    public function setInstallment($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\ProductInstallment::class);
        $this->installment = $var;

        return $this;
    }

    /**
     * Number of periods (months or years) and amount of payment per period
     * for an item with an associated subscription contract.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.SubscriptionCost subscription_cost = 33;</code>
     * @return \Google\Shopping\Merchant\Products\V1\SubscriptionCost|null
     */
    public function getSubscriptionCost()
    {
        return $this->subscription_cost;
    }

    public function hasSubscriptionCost()
    {
        return isset($this->subscription_cost);
    }

    public function clearSubscriptionCost()
    {
        unset($this->subscription_cost);
    }

    /**
     * Number of periods (months or years) and amount of payment per period
     * for an item with an associated subscription contract.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.SubscriptionCost subscription_cost = 33;</code>
     * @param \Google\Shopping\Merchant\Products\V1\SubscriptionCost $var
     * @return $this
     */
    public function setSubscriptionCost($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\SubscriptionCost::class);
        $this->subscription_cost = $var;

        return $this;
    }

    /**
     * Loyalty points that users receive after purchasing the item. Japan only.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.LoyaltyPoints loyalty_points = 34;</code>
     * @return \Google\Shopping\Merchant\Products\V1\LoyaltyPoints|null
     */
    public function getLoyaltyPoints()
    {
        return $this->loyalty_points;
    }

    public function hasLoyaltyPoints()
    {
        return isset($this->loyalty_points);
    }

    public function clearLoyaltyPoints()
    {
        unset($this->loyalty_points);
    }

    /**
     * Loyalty points that users receive after purchasing the item. Japan only.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.LoyaltyPoints loyalty_points = 34;</code>
     * @param \Google\Shopping\Merchant\Products\V1\LoyaltyPoints $var
     * @return $this
     */
    public function setLoyaltyPoints($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\LoyaltyPoints::class);
        $this->loyalty_points = $var;

        return $this;
    }

    /**
     * A list of loyalty program information that is used to surface loyalty
     * benefits (for example, better pricing, points, etc) to the user of this
     * item.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.LoyaltyProgram loyalty_programs = 136;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLoyaltyPrograms()
    {
        return $this->loyalty_programs;
    }

    /**
     * A list of loyalty program information that is used to surface loyalty
     * benefits (for example, better pricing, points, etc) to the user of this
     * item.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.LoyaltyProgram loyalty_programs = 136;</code>
     * @param array<\Google\Shopping\Merchant\Products\V1\LoyaltyProgram>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLoyaltyPrograms($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\Products\V1\LoyaltyProgram::class);
        $this->loyalty_programs = $arr;

        return $this;
    }

    /**
     * Categories of the item (formatted as in [product data
     * specification](https://support.google.com/merchants/answer/7052112#product_category)).
     *
     * Generated from protobuf field <code>repeated string product_types = 35;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProductTypes()
    {
        return $this->product_types;
    }

    /**
     * Categories of the item (formatted as in [product data
     * specification](https://support.google.com/merchants/answer/7052112#product_category)).
     *
     * Generated from protobuf field <code>repeated string product_types = 35;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProductTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->product_types = $arr;

        return $this;
    }

    /**
     * Advertised sale price of the item.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price sale_price = 36;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getSalePrice()
    {
        return $this->sale_price;
    }

    public function hasSalePrice()
    {
        return isset($this->sale_price);
    }

    public function clearSalePrice()
    {
        unset($this->sale_price);
    }

    /**
     * Advertised sale price of the item.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price sale_price = 36;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setSalePrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->sale_price = $var;

        return $this;
    }

    /**
     * Date range during which the item is on sale, see [product data
     * specification](https://support.google.com/merchants/answer/7052112#price_and_availability).
     *
     * Generated from protobuf field <code>.google.type.Interval sale_price_effective_date = 37;</code>
     * @return \Google\Type\Interval|null
     */
    public function getSalePriceEffectiveDate()
    {
        return $this->sale_price_effective_date;
    }

    public function hasSalePriceEffectiveDate()
    {
        return isset($this->sale_price_effective_date);
    }

    public function clearSalePriceEffectiveDate()
    {
        unset($this->sale_price_effective_date);
    }

    /**
     * Date range during which the item is on sale, see [product data
     * specification](https://support.google.com/merchants/answer/7052112#price_and_availability).
     *
     * Generated from protobuf field <code>.google.type.Interval sale_price_effective_date = 37;</code>
     * @param \Google\Type\Interval $var
     * @return $this
     */
    public function setSalePriceEffectiveDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Interval::class);
        $this->sale_price_effective_date = $var;

        return $this;
    }

    /**
     * The quantity of the product that is available for selling on Google.
     * Supported only for online products.
     *
     * Generated from protobuf field <code>optional int64 sell_on_google_quantity = 38;</code>
     * @return int|string
     */
    public function getSellOnGoogleQuantity()
    {
        return isset($this->sell_on_google_quantity) ? $this->sell_on_google_quantity : 0;
    }

    public function hasSellOnGoogleQuantity()
    {
        return isset($this->sell_on_google_quantity);
    }

    public function clearSellOnGoogleQuantity()
    {
        unset($this->sell_on_google_quantity);
    }

    /**
     * The quantity of the product that is available for selling on Google.
     * Supported only for online products.
     *
     * Generated from protobuf field <code>optional int64 sell_on_google_quantity = 38;</code>
     * @param int|string $var
     * @return $this
     */
    public function setSellOnGoogleQuantity($var)
    {
        GPBUtil::checkInt64($var);
        $this->sell_on_google_quantity = $var;

        return $this;
    }

    /**
     * The height of the product in the units provided. The value must be
     * between
     * 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductDimension product_height = 119;</code>
     * @return \Google\Shopping\Merchant\Products\V1\ProductDimension|null
     */
    public function getProductHeight()
    {
        return $this->product_height;
    }

    public function hasProductHeight()
    {
        return isset($this->product_height);
    }

    public function clearProductHeight()
    {
        unset($this->product_height);
    }

    /**
     * The height of the product in the units provided. The value must be
     * between
     * 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductDimension product_height = 119;</code>
     * @param \Google\Shopping\Merchant\Products\V1\ProductDimension $var
     * @return $this
     */
    public function setProductHeight($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\ProductDimension::class);
        $this->product_height = $var;

        return $this;
    }

    /**
     * The length of the product in the units provided. The value must be
     * between 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductDimension product_length = 120;</code>
     * @return \Google\Shopping\Merchant\Products\V1\ProductDimension|null
     */
    public function getProductLength()
    {
        return $this->product_length;
    }

    public function hasProductLength()
    {
        return isset($this->product_length);
    }

    public function clearProductLength()
    {
        unset($this->product_length);
    }

    /**
     * The length of the product in the units provided. The value must be
     * between 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductDimension product_length = 120;</code>
     * @param \Google\Shopping\Merchant\Products\V1\ProductDimension $var
     * @return $this
     */
    public function setProductLength($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\ProductDimension::class);
        $this->product_length = $var;

        return $this;
    }

    /**
     * The width of the product in the units provided. The value must be between
     * 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductDimension product_width = 121;</code>
     * @return \Google\Shopping\Merchant\Products\V1\ProductDimension|null
     */
    public function getProductWidth()
    {
        return $this->product_width;
    }

    public function hasProductWidth()
    {
        return isset($this->product_width);
    }

    public function clearProductWidth()
    {
        unset($this->product_width);
    }

    /**
     * The width of the product in the units provided. The value must be between
     * 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductDimension product_width = 121;</code>
     * @param \Google\Shopping\Merchant\Products\V1\ProductDimension $var
     * @return $this
     */
    public function setProductWidth($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\ProductDimension::class);
        $this->product_width = $var;

        return $this;
    }

    /**
     * The weight of the product in the units provided. The value must be
     * between 0 (exclusive) and 2000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductWeight product_weight = 122;</code>
     * @return \Google\Shopping\Merchant\Products\V1\ProductWeight|null
     */
    public function getProductWeight()
    {
        return $this->product_weight;
    }

    public function hasProductWeight()
    {
        return isset($this->product_weight);
    }

    public function clearProductWeight()
    {
        unset($this->product_weight);
    }

    /**
     * The weight of the product in the units provided. The value must be
     * between 0 (exclusive) and 2000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ProductWeight product_weight = 122;</code>
     * @param \Google\Shopping\Merchant\Products\V1\ProductWeight $var
     * @return $this
     */
    public function setProductWeight($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\ProductWeight::class);
        $this->product_weight = $var;

        return $this;
    }

    /**
     * Shipping rules.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.Shipping shipping = 39;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getShipping()
    {
        return $this->shipping;
    }

    /**
     * Shipping rules.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.Shipping shipping = 39;</code>
     * @param array<\Google\Shopping\Merchant\Products\V1\Shipping>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setShipping($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\Products\V1\Shipping::class);
        $this->shipping = $arr;

        return $this;
    }

    /**
     * Conditions to be met for a product to have free shipping.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.FreeShippingThreshold free_shipping_threshold = 135;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFreeShippingThreshold()
    {
        return $this->free_shipping_threshold;
    }

    /**
     * Conditions to be met for a product to have free shipping.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.FreeShippingThreshold free_shipping_threshold = 135;</code>
     * @param array<\Google\Shopping\Merchant\Products\V1\FreeShippingThreshold>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFreeShippingThreshold($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\Products\V1\FreeShippingThreshold::class);
        $this->free_shipping_threshold = $arr;

        return $this;
    }

    /**
     * Weight of the item for shipping.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ShippingWeight shipping_weight = 40;</code>
     * @return \Google\Shopping\Merchant\Products\V1\ShippingWeight|null
     */
    public function getShippingWeight()
    {
        return $this->shipping_weight;
    }

    public function hasShippingWeight()
    {
        return isset($this->shipping_weight);
    }

    public function clearShippingWeight()
    {
        unset($this->shipping_weight);
    }

    /**
     * Weight of the item for shipping.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ShippingWeight shipping_weight = 40;</code>
     * @param \Google\Shopping\Merchant\Products\V1\ShippingWeight $var
     * @return $this
     */
    public function setShippingWeight($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\ShippingWeight::class);
        $this->shipping_weight = $var;

        return $this;
    }

    /**
     * Length of the item for shipping.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ShippingDimension shipping_length = 41;</code>
     * @return \Google\Shopping\Merchant\Products\V1\ShippingDimension|null
     */
    public function getShippingLength()
    {
        return $this->shipping_length;
    }

    public function hasShippingLength()
    {
        return isset($this->shipping_length);
    }

    public function clearShippingLength()
    {
        unset($this->shipping_length);
    }

    /**
     * Length of the item for shipping.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ShippingDimension shipping_length = 41;</code>
     * @param \Google\Shopping\Merchant\Products\V1\ShippingDimension $var
     * @return $this
     */
    public function setShippingLength($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\ShippingDimension::class);
        $this->shipping_length = $var;

        return $this;
    }

    /**
     * Width of the item for shipping.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ShippingDimension shipping_width = 42;</code>
     * @return \Google\Shopping\Merchant\Products\V1\ShippingDimension|null
     */
    public function getShippingWidth()
    {
        return $this->shipping_width;
    }

    public function hasShippingWidth()
    {
        return isset($this->shipping_width);
    }

    public function clearShippingWidth()
    {
        unset($this->shipping_width);
    }

    /**
     * Width of the item for shipping.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ShippingDimension shipping_width = 42;</code>
     * @param \Google\Shopping\Merchant\Products\V1\ShippingDimension $var
     * @return $this
     */
    public function setShippingWidth($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\ShippingDimension::class);
        $this->shipping_width = $var;

        return $this;
    }

    /**
     * Height of the item for shipping.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ShippingDimension shipping_height = 43;</code>
     * @return \Google\Shopping\Merchant\Products\V1\ShippingDimension|null
     */
    public function getShippingHeight()
    {
        return $this->shipping_height;
    }

    public function hasShippingHeight()
    {
        return isset($this->shipping_height);
    }

    public function clearShippingHeight()
    {
        unset($this->shipping_height);
    }

    /**
     * Height of the item for shipping.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.ShippingDimension shipping_height = 43;</code>
     * @param \Google\Shopping\Merchant\Products\V1\ShippingDimension $var
     * @return $this
     */
    public function setShippingHeight($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\ShippingDimension::class);
        $this->shipping_height = $var;

        return $this;
    }

    /**
     * Maximal product handling time (in business days).
     *
     * Generated from protobuf field <code>optional int64 max_handling_time = 44;</code>
     * @return int|string
     */
    public function getMaxHandlingTime()
    {
        return isset($this->max_handling_time) ? $this->max_handling_time : 0;
    }

    public function hasMaxHandlingTime()
    {
        return isset($this->max_handling_time);
    }

    public function clearMaxHandlingTime()
    {
        unset($this->max_handling_time);
    }

    /**
     * Maximal product handling time (in business days).
     *
     * Generated from protobuf field <code>optional int64 max_handling_time = 44;</code>
     * @param int|string $var
     * @return $this
     */
    public function setMaxHandlingTime($var)
    {
        GPBUtil::checkInt64($var);
        $this->max_handling_time = $var;

        return $this;
    }

    /**
     * Minimal product handling time (in business days).
     *
     * Generated from protobuf field <code>optional int64 min_handling_time = 45;</code>
     * @return int|string
     */
    public function getMinHandlingTime()
    {
        return isset($this->min_handling_time) ? $this->min_handling_time : 0;
    }

    public function hasMinHandlingTime()
    {
        return isset($this->min_handling_time);
    }

    public function clearMinHandlingTime()
    {
        unset($this->min_handling_time);
    }

    /**
     * Minimal product handling time (in business days).
     *
     * Generated from protobuf field <code>optional int64 min_handling_time = 45;</code>
     * @param int|string $var
     * @return $this
     */
    public function setMinHandlingTime($var)
    {
        GPBUtil::checkInt64($var);
        $this->min_handling_time = $var;

        return $this;
    }

    /**
     * The shipping label of the product, used to group product in account-level
     * shipping rules.
     *
     * Generated from protobuf field <code>optional string shipping_label = 46;</code>
     * @return string
     */
    public function getShippingLabel()
    {
        return isset($this->shipping_label) ? $this->shipping_label : '';
    }

    public function hasShippingLabel()
    {
        return isset($this->shipping_label);
    }

    public function clearShippingLabel()
    {
        unset($this->shipping_label);
    }

    /**
     * The shipping label of the product, used to group product in account-level
     * shipping rules.
     *
     * Generated from protobuf field <code>optional string shipping_label = 46;</code>
     * @param string $var
     * @return $this
     */
    public function setShippingLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->shipping_label = $var;

        return $this;
    }

    /**
     * The transit time label of the product, used to group product in
     * account-level transit time tables.
     *
     * Generated from protobuf field <code>optional string transit_time_label = 47;</code>
     * @return string
     */
    public function getTransitTimeLabel()
    {
        return isset($this->transit_time_label) ? $this->transit_time_label : '';
    }

    public function hasTransitTimeLabel()
    {
        return isset($this->transit_time_label);
    }

    public function clearTransitTimeLabel()
    {
        unset($this->transit_time_label);
    }

    /**
     * The transit time label of the product, used to group product in
     * account-level transit time tables.
     *
     * Generated from protobuf field <code>optional string transit_time_label = 47;</code>
     * @param string $var
     * @return $this
     */
    public function setTransitTimeLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->transit_time_label = $var;

        return $this;
    }

    /**
     * Size of the item. Only one value is allowed. For variants with different
     * sizes, insert a separate product for each size with the same
     * `itemGroupId` value, see
     * [Size](https://support.google.com/merchants/answer/6324492).
     *
     * Generated from protobuf field <code>optional string size = 48;</code>
     * @return string
     */
    public function getSize()
    {
        return isset($this->size) ? $this->size : '';
    }

    public function hasSize()
    {
        return isset($this->size);
    }

    public function clearSize()
    {
        unset($this->size);
    }

    /**
     * Size of the item. Only one value is allowed. For variants with different
     * sizes, insert a separate product for each size with the same
     * `itemGroupId` value, see
     * [Size](https://support.google.com/merchants/answer/6324492).
     *
     * Generated from protobuf field <code>optional string size = 48;</code>
     * @param string $var
     * @return $this
     */
    public function setSize($var)
    {
        GPBUtil::checkString($var, True);
        $this->size = $var;

        return $this;
    }

    /**
     * System in which the size is specified. Recommended for apparel items.
     * For more information, see
     * [Size system](https://support.google.com/merchants/answer/6324502).
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.SizeSystem size_system = 49;</code>
     * @return int
     */
    public function getSizeSystem()
    {
        return isset($this->size_system) ? $this->size_system : 0;
    }

    public function hasSizeSystem()
    {
        return isset($this->size_system);
    }

    public function clearSizeSystem()
    {
        unset($this->size_system);
    }

    /**
     * System in which the size is specified. Recommended for apparel items.
     * For more information, see
     * [Size system](https://support.google.com/merchants/answer/6324502).
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.SizeSystem size_system = 49;</code>
     * @param int $var
     * @return $this
     */
    public function setSizeSystem($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\SizeSystem::class);
        $this->size_system = $var;

        return $this;
    }

    /**
     * The cut of the item. It can be used to represent combined size types for
     * apparel items. Maximum two of size types can be provided, see
     * [Size type](https://support.google.com/merchants/answer/6324497).
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.SizeType size_types = 50;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSizeTypes()
    {
        return $this->size_types;
    }

    /**
     * The cut of the item. It can be used to represent combined size types for
     * apparel items. Maximum two of size types can be provided, see
     * [Size type](https://support.google.com/merchants/answer/6324497).
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.SizeType size_types = 50;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSizeTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Shopping\Merchant\Products\V1\SizeType::class);
        $this->size_types = $arr;

        return $this;
    }

    /**
     * The [energy efficiency
     * class](https://support.google.com/merchants/answer/7562785) as defined in
     * EU directive 2010/30/EU.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.EnergyEfficiencyClass energy_efficiency_class = 53;</code>
     * @return int
     */
    public function getEnergyEfficiencyClass()
    {
        return isset($this->energy_efficiency_class) ? $this->energy_efficiency_class : 0;
    }

    public function hasEnergyEfficiencyClass()
    {
        return isset($this->energy_efficiency_class);
    }

    public function clearEnergyEfficiencyClass()
    {
        unset($this->energy_efficiency_class);
    }

    /**
     * The [energy efficiency
     * class](https://support.google.com/merchants/answer/7562785) as defined in
     * EU directive 2010/30/EU.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.EnergyEfficiencyClass energy_efficiency_class = 53;</code>
     * @param int $var
     * @return $this
     */
    public function setEnergyEfficiencyClass($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\EnergyEfficiencyClass::class);
        $this->energy_efficiency_class = $var;

        return $this;
    }

    /**
     * The [energy efficiency
     * class](https://support.google.com/merchants/answer/7562785) as defined in
     * EU directive 2010/30/EU.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.EnergyEfficiencyClass min_energy_efficiency_class = 54;</code>
     * @return int
     */
    public function getMinEnergyEfficiencyClass()
    {
        return isset($this->min_energy_efficiency_class) ? $this->min_energy_efficiency_class : 0;
    }

    public function hasMinEnergyEfficiencyClass()
    {
        return isset($this->min_energy_efficiency_class);
    }

    public function clearMinEnergyEfficiencyClass()
    {
        unset($this->min_energy_efficiency_class);
    }

    /**
     * The [energy efficiency
     * class](https://support.google.com/merchants/answer/7562785) as defined in
     * EU directive 2010/30/EU.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.EnergyEfficiencyClass min_energy_efficiency_class = 54;</code>
     * @param int $var
     * @return $this
     */
    public function setMinEnergyEfficiencyClass($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\EnergyEfficiencyClass::class);
        $this->min_energy_efficiency_class = $var;

        return $this;
    }

    /**
     * The [energy efficiency
     * class](https://support.google.com/merchants/answer/7562785) as defined in
     * EU directive 2010/30/EU.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.EnergyEfficiencyClass max_energy_efficiency_class = 55;</code>
     * @return int
     */
    public function getMaxEnergyEfficiencyClass()
    {
        return isset($this->max_energy_efficiency_class) ? $this->max_energy_efficiency_class : 0;
    }

    public function hasMaxEnergyEfficiencyClass()
    {
        return isset($this->max_energy_efficiency_class);
    }

    public function clearMaxEnergyEfficiencyClass()
    {
        unset($this->max_energy_efficiency_class);
    }

    /**
     * The [energy efficiency
     * class](https://support.google.com/merchants/answer/7562785) as defined in
     * EU directive 2010/30/EU.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.EnergyEfficiencyClass max_energy_efficiency_class = 55;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxEnergyEfficiencyClass($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\EnergyEfficiencyClass::class);
        $this->max_energy_efficiency_class = $var;

        return $this;
    }

    /**
     * The measure and dimension of an item.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.UnitPricingMeasure unit_pricing_measure = 56;</code>
     * @return \Google\Shopping\Merchant\Products\V1\UnitPricingMeasure|null
     */
    public function getUnitPricingMeasure()
    {
        return $this->unit_pricing_measure;
    }

    public function hasUnitPricingMeasure()
    {
        return isset($this->unit_pricing_measure);
    }

    public function clearUnitPricingMeasure()
    {
        unset($this->unit_pricing_measure);
    }

    /**
     * The measure and dimension of an item.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.UnitPricingMeasure unit_pricing_measure = 56;</code>
     * @param \Google\Shopping\Merchant\Products\V1\UnitPricingMeasure $var
     * @return $this
     */
    public function setUnitPricingMeasure($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\UnitPricingMeasure::class);
        $this->unit_pricing_measure = $var;

        return $this;
    }

    /**
     * The preference of the denominator of the unit price.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.UnitPricingBaseMeasure unit_pricing_base_measure = 57;</code>
     * @return \Google\Shopping\Merchant\Products\V1\UnitPricingBaseMeasure|null
     */
    public function getUnitPricingBaseMeasure()
    {
        return $this->unit_pricing_base_measure;
    }

    public function hasUnitPricingBaseMeasure()
    {
        return isset($this->unit_pricing_base_measure);
    }

    public function clearUnitPricingBaseMeasure()
    {
        unset($this->unit_pricing_base_measure);
    }

    /**
     * The preference of the denominator of the unit price.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1.UnitPricingBaseMeasure unit_pricing_base_measure = 57;</code>
     * @param \Google\Shopping\Merchant\Products\V1\UnitPricingBaseMeasure $var
     * @return $this
     */
    public function setUnitPricingBaseMeasure($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\UnitPricingBaseMeasure::class);
        $this->unit_pricing_base_measure = $var;

        return $this;
    }

    /**
     * The number of identical products in a business-defined multipack.
     *
     * Generated from protobuf field <code>optional int64 multipack = 58;</code>
     * @return int|string
     */
    public function getMultipack()
    {
        return isset($this->multipack) ? $this->multipack : 0;
    }

    public function hasMultipack()
    {
        return isset($this->multipack);
    }

    public function clearMultipack()
    {
        unset($this->multipack);
    }

    /**
     * The number of identical products in a business-defined multipack.
     *
     * Generated from protobuf field <code>optional int64 multipack = 58;</code>
     * @param int|string $var
     * @return $this
     */
    public function setMultipack($var)
    {
        GPBUtil::checkInt64($var);
        $this->multipack = $var;

        return $this;
    }

    /**
     * Used to group items in an arbitrary way. Only for CPA%, discouraged
     * otherwise. For more information, see
     * [Display ads
     * attribute](https://support.google.com/merchants/answer/6069387).
     *
     * Generated from protobuf field <code>optional string ads_grouping = 59;</code>
     * @return string
     */
    public function getAdsGrouping()
    {
        return isset($this->ads_grouping) ? $this->ads_grouping : '';
    }

    public function hasAdsGrouping()
    {
        return isset($this->ads_grouping);
    }

    public function clearAdsGrouping()
    {
        unset($this->ads_grouping);
    }

    /**
     * Used to group items in an arbitrary way. Only for CPA%, discouraged
     * otherwise. For more information, see
     * [Display ads
     * attribute](https://support.google.com/merchants/answer/6069387).
     *
     * Generated from protobuf field <code>optional string ads_grouping = 59;</code>
     * @param string $var
     * @return $this
     */
    public function setAdsGrouping($var)
    {
        GPBUtil::checkString($var, True);
        $this->ads_grouping = $var;

        return $this;
    }

    /**
     * Similar to ads_grouping, but only works on CPC.
     *
     * Generated from protobuf field <code>repeated string ads_labels = 60;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdsLabels()
    {
        return $this->ads_labels;
    }

    /**
     * Similar to ads_grouping, but only works on CPC.
     *
     * Generated from protobuf field <code>repeated string ads_labels = 60;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdsLabels($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->ads_labels = $arr;

        return $this;
    }

    /**
     * Allows advertisers to override the item URL when the product is shown
     * within the context of Product ads.
     *
     * Generated from protobuf field <code>optional string ads_redirect = 61;</code>
     * @return string
     */
    public function getAdsRedirect()
    {
        return isset($this->ads_redirect) ? $this->ads_redirect : '';
    }

    public function hasAdsRedirect()
    {
        return isset($this->ads_redirect);
    }

    public function clearAdsRedirect()
    {
        unset($this->ads_redirect);
    }

    /**
     * Allows advertisers to override the item URL when the product is shown
     * within the context of Product ads.
     *
     * Generated from protobuf field <code>optional string ads_redirect = 61;</code>
     * @param string $var
     * @return $this
     */
    public function setAdsRedirect($var)
    {
        GPBUtil::checkString($var, True);
        $this->ads_redirect = $var;

        return $this;
    }

    /**
     * Cost of goods sold. Used for gross profit reporting.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price cost_of_goods_sold = 62;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getCostOfGoodsSold()
    {
        return $this->cost_of_goods_sold;
    }

    public function hasCostOfGoodsSold()
    {
        return isset($this->cost_of_goods_sold);
    }

    public function clearCostOfGoodsSold()
    {
        unset($this->cost_of_goods_sold);
    }

    /**
     * Cost of goods sold. Used for gross profit reporting.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price cost_of_goods_sold = 62;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setCostOfGoodsSold($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->cost_of_goods_sold = $var;

        return $this;
    }

    /**
     * Technical specification or additional product details.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.ProductDetail product_details = 63;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProductDetails()
    {
        return $this->product_details;
    }

    /**
     * Technical specification or additional product details.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.ProductDetail product_details = 63;</code>
     * @param array<\Google\Shopping\Merchant\Products\V1\ProductDetail>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProductDetails($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\Products\V1\ProductDetail::class);
        $this->product_details = $arr;

        return $this;
    }

    /**
     * Bullet points describing the most relevant [product
     * highlights](https://support.google.com/merchants/answer/9216100).
     *
     * Generated from protobuf field <code>repeated string product_highlights = 64;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProductHighlights()
    {
        return $this->product_highlights;
    }

    /**
     * Bullet points describing the most relevant [product
     * highlights](https://support.google.com/merchants/answer/9216100).
     *
     * Generated from protobuf field <code>repeated string product_highlights = 64;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProductHighlights($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->product_highlights = $arr;

        return $this;
    }

    /**
     * An identifier for an item for dynamic remarketing campaigns.
     *
     * Generated from protobuf field <code>optional string display_ads_id = 65;</code>
     * @return string
     */
    public function getDisplayAdsId()
    {
        return isset($this->display_ads_id) ? $this->display_ads_id : '';
    }

    public function hasDisplayAdsId()
    {
        return isset($this->display_ads_id);
    }

    public function clearDisplayAdsId()
    {
        unset($this->display_ads_id);
    }

    /**
     * An identifier for an item for dynamic remarketing campaigns.
     *
     * Generated from protobuf field <code>optional string display_ads_id = 65;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayAdsId($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_ads_id = $var;

        return $this;
    }

    /**
     * Advertiser-specified recommendations. For more information, see
     * [Display ads attribute
     * specification](https://support.google.com/merchants/answer/6069387).
     *
     * Generated from protobuf field <code>repeated string display_ads_similar_ids = 66;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDisplayAdsSimilarIds()
    {
        return $this->display_ads_similar_ids;
    }

    /**
     * Advertiser-specified recommendations. For more information, see
     * [Display ads attribute
     * specification](https://support.google.com/merchants/answer/6069387).
     *
     * Generated from protobuf field <code>repeated string display_ads_similar_ids = 66;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDisplayAdsSimilarIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->display_ads_similar_ids = $arr;

        return $this;
    }

    /**
     * Title of an item for dynamic remarketing campaigns.
     *
     * Generated from protobuf field <code>optional string display_ads_title = 67;</code>
     * @return string
     */
    public function getDisplayAdsTitle()
    {
        return isset($this->display_ads_title) ? $this->display_ads_title : '';
    }

    public function hasDisplayAdsTitle()
    {
        return isset($this->display_ads_title);
    }

    public function clearDisplayAdsTitle()
    {
        unset($this->display_ads_title);
    }

    /**
     * Title of an item for dynamic remarketing campaigns.
     *
     * Generated from protobuf field <code>optional string display_ads_title = 67;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayAdsTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_ads_title = $var;

        return $this;
    }

    /**
     * URL directly to your item's landing page for dynamic remarketing
     * campaigns.
     *
     * Generated from protobuf field <code>optional string display_ads_link = 68;</code>
     * @return string
     */
    public function getDisplayAdsLink()
    {
        return isset($this->display_ads_link) ? $this->display_ads_link : '';
    }

    public function hasDisplayAdsLink()
    {
        return isset($this->display_ads_link);
    }

    public function clearDisplayAdsLink()
    {
        unset($this->display_ads_link);
    }

    /**
     * URL directly to your item's landing page for dynamic remarketing
     * campaigns.
     *
     * Generated from protobuf field <code>optional string display_ads_link = 68;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayAdsLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_ads_link = $var;

        return $this;
    }

    /**
     * Offer margin for dynamic remarketing campaigns. For more information, see
     * [Display ads
     * attribute](https://support.google.com/merchants/answer/6069387).
     *
     * Generated from protobuf field <code>optional double display_ads_value = 69;</code>
     * @return float
     */
    public function getDisplayAdsValue()
    {
        return isset($this->display_ads_value) ? $this->display_ads_value : 0.0;
    }

    public function hasDisplayAdsValue()
    {
        return isset($this->display_ads_value);
    }

    public function clearDisplayAdsValue()
    {
        unset($this->display_ads_value);
    }

    /**
     * Offer margin for dynamic remarketing campaigns. For more information, see
     * [Display ads
     * attribute](https://support.google.com/merchants/answer/6069387).
     *
     * Generated from protobuf field <code>optional double display_ads_value = 69;</code>
     * @param float $var
     * @return $this
     */
    public function setDisplayAdsValue($var)
    {
        GPBUtil::checkDouble($var);
        $this->display_ads_value = $var;

        return $this;
    }

    /**
     * The unique ID of a promotion.
     *
     * Generated from protobuf field <code>repeated string promotion_ids = 70;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPromotionIds()
    {
        return $this->promotion_ids;
    }

    /**
     * The unique ID of a promotion.
     *
     * Generated from protobuf field <code>repeated string promotion_ids = 70;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPromotionIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->promotion_ids = $arr;

        return $this;
    }

    /**
     * The [pickup](https://support.google.com/merchants/answer/14634021) option
     * for the item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.PickupMethod pickup_method = 80;</code>
     * @return int
     */
    public function getPickupMethod()
    {
        return isset($this->pickup_method) ? $this->pickup_method : 0;
    }

    public function hasPickupMethod()
    {
        return isset($this->pickup_method);
    }

    public function clearPickupMethod()
    {
        unset($this->pickup_method);
    }

    /**
     * The [pickup](https://support.google.com/merchants/answer/14634021) option
     * for the item.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.PickupMethod pickup_method = 80;</code>
     * @param int $var
     * @return $this
     */
    public function setPickupMethod($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\PickupMethod::class);
        $this->pickup_method = $var;

        return $this;
    }

    /**
     * Item store pickup timeline. For more information, see
     * [Pickup SLA](https://support.google.com/merchants/answer/14635400).
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.PickupSla pickup_sla = 81;</code>
     * @return int
     */
    public function getPickupSla()
    {
        return isset($this->pickup_sla) ? $this->pickup_sla : 0;
    }

    public function hasPickupSla()
    {
        return isset($this->pickup_sla);
    }

    public function clearPickupSla()
    {
        unset($this->pickup_sla);
    }

    /**
     * Item store pickup timeline. For more information, see
     * [Pickup SLA](https://support.google.com/merchants/answer/14635400).
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.PickupSla pickup_sla = 81;</code>
     * @param int $var
     * @return $this
     */
    public function setPickupSla($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\PickupSla::class);
        $this->pickup_sla = $var;

        return $this;
    }

    /**
     * [Link template](https://support.google.com/merchants/answer/13871172) for
     * business hosted local storefront.
     *
     * Generated from protobuf field <code>optional string link_template = 82;</code>
     * @return string
     */
    public function getLinkTemplate()
    {
        return isset($this->link_template) ? $this->link_template : '';
    }

    public function hasLinkTemplate()
    {
        return isset($this->link_template);
    }

    public function clearLinkTemplate()
    {
        unset($this->link_template);
    }

    /**
     * [Link template](https://support.google.com/merchants/answer/13871172) for
     * business hosted local storefront.
     *
     * Generated from protobuf field <code>optional string link_template = 82;</code>
     * @param string $var
     * @return $this
     */
    public function setLinkTemplate($var)
    {
        GPBUtil::checkString($var, True);
        $this->link_template = $var;

        return $this;
    }

    /**
     * [Link template](https://support.google.com/merchants/answer/13870216) for
     * business hosted local storefront optimized for mobile
     * devices.
     *
     * Generated from protobuf field <code>optional string mobile_link_template = 83;</code>
     * @return string
     */
    public function getMobileLinkTemplate()
    {
        return isset($this->mobile_link_template) ? $this->mobile_link_template : '';
    }

    public function hasMobileLinkTemplate()
    {
        return isset($this->mobile_link_template);
    }

    public function clearMobileLinkTemplate()
    {
        unset($this->mobile_link_template);
    }

    /**
     * [Link template](https://support.google.com/merchants/answer/13870216) for
     * business hosted local storefront optimized for mobile
     * devices.
     *
     * Generated from protobuf field <code>optional string mobile_link_template = 83;</code>
     * @param string $var
     * @return $this
     */
    public function setMobileLinkTemplate($var)
    {
        GPBUtil::checkString($var, True);
        $this->mobile_link_template = $var;

        return $this;
    }

    /**
     * [Custom label 0](https://support.google.com/merchants/answer/6324473) for
     * custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_0 = 71;</code>
     * @return string
     */
    public function getCustomLabel0()
    {
        return isset($this->custom_label_0) ? $this->custom_label_0 : '';
    }

    public function hasCustomLabel0()
    {
        return isset($this->custom_label_0);
    }

    public function clearCustomLabel0()
    {
        unset($this->custom_label_0);
    }

    /**
     * [Custom label 0](https://support.google.com/merchants/answer/6324473) for
     * custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_0 = 71;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomLabel0($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_label_0 = $var;

        return $this;
    }

    /**
     * [Custom label 1](https://support.google.com/merchants/answer/6324473)
     * for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_1 = 72;</code>
     * @return string
     */
    public function getCustomLabel1()
    {
        return isset($this->custom_label_1) ? $this->custom_label_1 : '';
    }

    public function hasCustomLabel1()
    {
        return isset($this->custom_label_1);
    }

    public function clearCustomLabel1()
    {
        unset($this->custom_label_1);
    }

    /**
     * [Custom label 1](https://support.google.com/merchants/answer/6324473)
     * for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_1 = 72;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomLabel1($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_label_1 = $var;

        return $this;
    }

    /**
     * [Custom label 2](https://support.google.com/merchants/answer/6324473)
     * for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_2 = 73;</code>
     * @return string
     */
    public function getCustomLabel2()
    {
        return isset($this->custom_label_2) ? $this->custom_label_2 : '';
    }

    public function hasCustomLabel2()
    {
        return isset($this->custom_label_2);
    }

    public function clearCustomLabel2()
    {
        unset($this->custom_label_2);
    }

    /**
     * [Custom label 2](https://support.google.com/merchants/answer/6324473)
     * for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_2 = 73;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomLabel2($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_label_2 = $var;

        return $this;
    }

    /**
     * [Custom label 3](https://support.google.com/merchants/answer/6324473)
     * for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_3 = 74;</code>
     * @return string
     */
    public function getCustomLabel3()
    {
        return isset($this->custom_label_3) ? $this->custom_label_3 : '';
    }

    public function hasCustomLabel3()
    {
        return isset($this->custom_label_3);
    }

    public function clearCustomLabel3()
    {
        unset($this->custom_label_3);
    }

    /**
     * [Custom label 3](https://support.google.com/merchants/answer/6324473)
     * for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_3 = 74;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomLabel3($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_label_3 = $var;

        return $this;
    }

    /**
     * [Custom label 4](https://support.google.com/merchants/answer/6324473) for
     * custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_4 = 75;</code>
     * @return string
     */
    public function getCustomLabel4()
    {
        return isset($this->custom_label_4) ? $this->custom_label_4 : '';
    }

    public function hasCustomLabel4()
    {
        return isset($this->custom_label_4);
    }

    public function clearCustomLabel4()
    {
        unset($this->custom_label_4);
    }

    /**
     * [Custom label 4](https://support.google.com/merchants/answer/6324473) for
     * custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_4 = 75;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomLabel4($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_label_4 = $var;

        return $this;
    }

    /**
     * The list of destinations to include for this target (corresponds to
     * checked check boxes in Merchant Center). Default destinations are always
     * included unless provided in `excludedDestinations`.
     * For more information, see
     * [Included
     * destination](https://support.google.com/merchants/answer/7501026).
     * Note: We recommend setting destinations on datasources level for most use
     * cases. Use this field within products to only setup exceptions.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.Destination.DestinationEnum included_destinations = 76;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIncludedDestinations()
    {
        return $this->included_destinations;
    }

    /**
     * The list of destinations to include for this target (corresponds to
     * checked check boxes in Merchant Center). Default destinations are always
     * included unless provided in `excludedDestinations`.
     * For more information, see
     * [Included
     * destination](https://support.google.com/merchants/answer/7501026).
     * Note: We recommend setting destinations on datasources level for most use
     * cases. Use this field within products to only setup exceptions.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.Destination.DestinationEnum included_destinations = 76;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIncludedDestinations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Shopping\Type\Destination\DestinationEnum::class);
        $this->included_destinations = $arr;

        return $this;
    }

    /**
     * The list of destinations to exclude for this target (corresponds to
     * unchecked check boxes in Merchant Center).
     * For more information, see
     * [Excluded
     * destination](https://support.google.com/merchants/answer/6324486).
     * Note: We recommend setting destinations on datasources level for most use
     * cases. Use this field within products to only setup exceptions.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.Destination.DestinationEnum excluded_destinations = 77;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExcludedDestinations()
    {
        return $this->excluded_destinations;
    }

    /**
     * The list of destinations to exclude for this target (corresponds to
     * unchecked check boxes in Merchant Center).
     * For more information, see
     * [Excluded
     * destination](https://support.google.com/merchants/answer/6324486).
     * Note: We recommend setting destinations on datasources level for most use
     * cases. Use this field within products to only setup exceptions.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.Destination.DestinationEnum excluded_destinations = 77;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExcludedDestinations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Shopping\Type\Destination\DestinationEnum::class);
        $this->excluded_destinations = $arr;

        return $this;
    }

    /**
     * List of country codes [(ISO 3166-1
     * alpha-2)](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) to exclude the
     * offer from Shopping Ads destination. Countries from this list are removed
     * from countries configured in data source settings.
     *
     * Generated from protobuf field <code>repeated string shopping_ads_excluded_countries = 78;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getShoppingAdsExcludedCountries()
    {
        return $this->shopping_ads_excluded_countries;
    }

    /**
     * List of country codes [(ISO 3166-1
     * alpha-2)](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) to exclude the
     * offer from Shopping Ads destination. Countries from this list are removed
     * from countries configured in data source settings.
     *
     * Generated from protobuf field <code>repeated string shopping_ads_excluded_countries = 78;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setShoppingAdsExcludedCountries($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->shopping_ads_excluded_countries = $arr;

        return $this;
    }

    /**
     * Required for multi-seller accounts. Use this attribute if you're a
     * marketplace uploading products for various sellers to your multi-seller
     * account.
     *
     * Generated from protobuf field <code>optional string external_seller_id = 1;</code>
     * @return string
     */
    public function getExternalSellerId()
    {
        return isset($this->external_seller_id) ? $this->external_seller_id : '';
    }

    public function hasExternalSellerId()
    {
        return isset($this->external_seller_id);
    }

    public function clearExternalSellerId()
    {
        unset($this->external_seller_id);
    }

    /**
     * Required for multi-seller accounts. Use this attribute if you're a
     * marketplace uploading products for various sellers to your multi-seller
     * account.
     *
     * Generated from protobuf field <code>optional string external_seller_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setExternalSellerId($var)
    {
        GPBUtil::checkString($var, True);
        $this->external_seller_id = $var;

        return $this;
    }

    /**
     * Publication of this item will be temporarily
     * [paused](https://support.google.com/merchants/answer/11909930).
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.Pause pause = 13;</code>
     * @return int
     */
    public function getPause()
    {
        return isset($this->pause) ? $this->pause : 0;
    }

    public function hasPause()
    {
        return isset($this->pause);
    }

    public function clearPause()
    {
        unset($this->pause);
    }

    /**
     * Publication of this item will be temporarily
     * [paused](https://support.google.com/merchants/answer/11909930).
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.Pause pause = 13;</code>
     * @param int $var
     * @return $this
     */
    public function setPause($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Products\V1\Pause::class);
        $this->pause = $var;

        return $this;
    }

    /**
     * Additional URLs of lifestyle images of the item, used to explicitly
     * identify images that showcase your item in a real-world context. See the
     * [Help Center article](https://support.google.com/merchants/answer/9103186)
     * for more information.
     *
     * Generated from protobuf field <code>repeated string lifestyle_image_links = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLifestyleImageLinks()
    {
        return $this->lifestyle_image_links;
    }

    /**
     * Additional URLs of lifestyle images of the item, used to explicitly
     * identify images that showcase your item in a real-world context. See the
     * [Help Center article](https://support.google.com/merchants/answer/9103186)
     * for more information.
     *
     * Generated from protobuf field <code>repeated string lifestyle_image_links = 14;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLifestyleImageLinks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->lifestyle_image_links = $arr;

        return $this;
    }

    /**
     * Extra fields to export to the Cloud Retail program.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.CloudExportAdditionalProperties cloud_export_additional_properties = 84;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCloudExportAdditionalProperties()
    {
        return $this->cloud_export_additional_properties;
    }

    /**
     * Extra fields to export to the Cloud Retail program.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.CloudExportAdditionalProperties cloud_export_additional_properties = 84;</code>
     * @param array<\Google\Shopping\Merchant\Products\V1\CloudExportAdditionalProperties>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCloudExportAdditionalProperties($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\Products\V1\CloudExportAdditionalProperties::class);
        $this->cloud_export_additional_properties = $arr;

        return $this;
    }

    /**
     * URL of the 3D image of the item. See the
     * [Help Center article](https://support.google.com/merchants/answer/13674896)
     * for more information.
     *
     * Generated from protobuf field <code>optional string virtual_model_link = 130;</code>
     * @return string
     */
    public function getVirtualModelLink()
    {
        return isset($this->virtual_model_link) ? $this->virtual_model_link : '';
    }

    public function hasVirtualModelLink()
    {
        return isset($this->virtual_model_link);
    }

    public function clearVirtualModelLink()
    {
        unset($this->virtual_model_link);
    }

    /**
     * URL of the 3D image of the item. See the
     * [Help Center article](https://support.google.com/merchants/answer/13674896)
     * for more information.
     *
     * Generated from protobuf field <code>optional string virtual_model_link = 130;</code>
     * @param string $var
     * @return $this
     */
    public function setVirtualModelLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->virtual_model_link = $var;

        return $this;
    }

    /**
     * Product Certifications, for example for energy efficiency labeling of
     * products recorded in the [EU EPREL](https://eprel.ec.europa.eu/screen/home)
     * database. See the [Help
     * Center](https://support.google.com/merchants/answer/13528839)
     * article for more information.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.ProductCertification certifications = 123;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCertifications()
    {
        return $this->certifications;
    }

    /**
     * Product Certifications, for example for energy efficiency labeling of
     * products recorded in the [EU EPREL](https://eprel.ec.europa.eu/screen/home)
     * database. See the [Help
     * Center](https://support.google.com/merchants/answer/13528839)
     * article for more information.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.ProductCertification certifications = 123;</code>
     * @param array<\Google\Shopping\Merchant\Products\V1\ProductCertification>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCertifications($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\Products\V1\ProductCertification::class);
        $this->certifications = $arr;

        return $this;
    }

    /**
     * Structured title, for algorithmically (AI)-generated titles.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.StructuredTitle structured_title = 132;</code>
     * @return \Google\Shopping\Merchant\Products\V1\StructuredTitle|null
     */
    public function getStructuredTitle()
    {
        return $this->structured_title;
    }

    public function hasStructuredTitle()
    {
        return isset($this->structured_title);
    }

    public function clearStructuredTitle()
    {
        unset($this->structured_title);
    }

    /**
     * Structured title, for algorithmically (AI)-generated titles.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.StructuredTitle structured_title = 132;</code>
     * @param \Google\Shopping\Merchant\Products\V1\StructuredTitle $var
     * @return $this
     */
    public function setStructuredTitle($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\StructuredTitle::class);
        $this->structured_title = $var;

        return $this;
    }

    /**
     * Structured description, for algorithmically (AI)-generated descriptions.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.StructuredDescription structured_description = 133;</code>
     * @return \Google\Shopping\Merchant\Products\V1\StructuredDescription|null
     */
    public function getStructuredDescription()
    {
        return $this->structured_description;
    }

    public function hasStructuredDescription()
    {
        return isset($this->structured_description);
    }

    public function clearStructuredDescription()
    {
        unset($this->structured_description);
    }

    /**
     * Structured description, for algorithmically (AI)-generated descriptions.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.products.v1.StructuredDescription structured_description = 133;</code>
     * @param \Google\Shopping\Merchant\Products\V1\StructuredDescription $var
     * @return $this
     */
    public function setStructuredDescription($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1\StructuredDescription::class);
        $this->structured_description = $var;

        return $this;
    }

    /**
     * A safeguard in the [automated discounts]
     * (https://support.google.com/merchants/answer/10295759) and
     * "Dynamic Promotions"
     * (https://support.google.com/merchants/answer/13949249) projects,
     * ensuring that discounts on business offers do not fall below this value,
     * thereby preserving the offer's value and profitability.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price auto_pricing_min_price = 124;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getAutoPricingMinPrice()
    {
        return $this->auto_pricing_min_price;
    }

    public function hasAutoPricingMinPrice()
    {
        return isset($this->auto_pricing_min_price);
    }

    public function clearAutoPricingMinPrice()
    {
        unset($this->auto_pricing_min_price);
    }

    /**
     * A safeguard in the [automated discounts]
     * (https://support.google.com/merchants/answer/10295759) and
     * "Dynamic Promotions"
     * (https://support.google.com/merchants/answer/13949249) projects,
     * ensuring that discounts on business offers do not fall below this value,
     * thereby preserving the offer's value and profitability.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price auto_pricing_min_price = 124;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setAutoPricingMinPrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->auto_pricing_min_price = $var;

        return $this;
    }

    /**
     * The list of sustainability incentive programs.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.ProductSustainabilityIncentive sustainability_incentives = 138;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSustainabilityIncentives()
    {
        return $this->sustainability_incentives;
    }

    /**
     * The list of sustainability incentive programs.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.products.v1.ProductSustainabilityIncentive sustainability_incentives = 138;</code>
     * @param array<\Google\Shopping\Merchant\Products\V1\ProductSustainabilityIncentive>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSustainabilityIncentives($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\Products\V1\ProductSustainabilityIncentive::class);
        $this->sustainability_incentives = $arr;

        return $this;
    }

}

