<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/accounts/v1beta/autofeedsettings.proto

namespace Google\Shopping\Merchant\Accounts\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Collection of information related to the
 * [autofeed](https://support.google.com/merchants/answer/7538732) settings.
 *
 * Generated from protobuf message <code>google.shopping.merchant.accounts.v1beta.AutofeedSettings</code>
 */
class AutofeedSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the autofeed settings.
     * Format: `accounts/{account}/autofeedSettings`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. Enables or disables product crawling through the autofeed for the
     * given account. Autofeed accounts must meet [certain
     * conditions](https://support.google.com/merchants/answer/7538732#Configure_automated_feeds_Standard_Experience),
     * which can be checked through the `eligible` field.
     * The account must **not** be a marketplace.
     * When the autofeed is enabled for the first time, the products usually
     * appear instantly. When re-enabling, it might take up to 24 hours for
     * products to appear.
     *
     * Generated from protobuf field <code>bool enable_products = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $enable_products = false;
    /**
     * Output only. Determines whether merchant is eligible for being enrolled
     * into an autofeed.
     *
     * Generated from protobuf field <code>bool eligible = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $eligible = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the autofeed settings.
     *           Format: `accounts/{account}/autofeedSettings`.
     *     @type bool $enable_products
     *           Required. Enables or disables product crawling through the autofeed for the
     *           given account. Autofeed accounts must meet [certain
     *           conditions](https://support.google.com/merchants/answer/7538732#Configure_automated_feeds_Standard_Experience),
     *           which can be checked through the `eligible` field.
     *           The account must **not** be a marketplace.
     *           When the autofeed is enabled for the first time, the products usually
     *           appear instantly. When re-enabling, it might take up to 24 hours for
     *           products to appear.
     *     @type bool $eligible
     *           Output only. Determines whether merchant is eligible for being enrolled
     *           into an autofeed.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Accounts\V1Beta\Autofeedsettings::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the autofeed settings.
     * Format: `accounts/{account}/autofeedSettings`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the autofeed settings.
     * Format: `accounts/{account}/autofeedSettings`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Enables or disables product crawling through the autofeed for the
     * given account. Autofeed accounts must meet [certain
     * conditions](https://support.google.com/merchants/answer/7538732#Configure_automated_feeds_Standard_Experience),
     * which can be checked through the `eligible` field.
     * The account must **not** be a marketplace.
     * When the autofeed is enabled for the first time, the products usually
     * appear instantly. When re-enabling, it might take up to 24 hours for
     * products to appear.
     *
     * Generated from protobuf field <code>bool enable_products = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return bool
     */
    public function getEnableProducts()
    {
        return $this->enable_products;
    }

    /**
     * Required. Enables or disables product crawling through the autofeed for the
     * given account. Autofeed accounts must meet [certain
     * conditions](https://support.google.com/merchants/answer/7538732#Configure_automated_feeds_Standard_Experience),
     * which can be checked through the `eligible` field.
     * The account must **not** be a marketplace.
     * When the autofeed is enabled for the first time, the products usually
     * appear instantly. When re-enabling, it might take up to 24 hours for
     * products to appear.
     *
     * Generated from protobuf field <code>bool enable_products = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableProducts($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_products = $var;

        return $this;
    }

    /**
     * Output only. Determines whether merchant is eligible for being enrolled
     * into an autofeed.
     *
     * Generated from protobuf field <code>bool eligible = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getEligible()
    {
        return $this->eligible;
    }

    /**
     * Output only. Determines whether merchant is eligible for being enrolled
     * into an autofeed.
     *
     * Generated from protobuf field <code>bool eligible = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setEligible($var)
    {
        GPBUtil::checkBool($var);
        $this->eligible = $var;

        return $this;
    }

}

