<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/accounts/v1/termsofserviceagreementstate.proto

namespace Google\Shopping\Merchant\Accounts\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * This resource represents the agreement state for a given account and terms of
 * service kind.
 * The state is as follows:
 * * If the business has accepted a terms of service,
 * [`accepted`][google.shopping.merchant.accounts.v1.Accepted]
 * will be populated, otherwise it will be empty
 * * If the business must sign a terms of service,
 * [`required`][google.shopping.merchant.accounts.v1.Required]
 * will be populated, otherwise it will be empty.
 * Note that both `required` and `accepted` can be present. In this case the
 * `accepted` terms of services will have an expiration date set in the
 * [`valid_until`][google.shopping.merchant.accounts.v1.Accepted.valid_until]
 * field. The `required` terms of services need to be accepted before
 * `valid_until` in order for the account to continue having a valid agreement.
 * When accepting new terms of services we expect third-party providers to
 * display the text associated with the given terms of service agreement (the
 * url to the file containing the text is added in the Required message below as
 * [`tos_file_uri`][google.shopping.merchant.accounts.v1.Required.tos_file_uri]).
 * The actual acceptance of the terms of service is done by calling accept on
 * the
 * [`TermsOfService`][google.shopping.merchant.accounts.v1.Accepted.terms_of_service]
 * resource.
 * `valid_until` field.
 *
 * Generated from protobuf message <code>google.shopping.merchant.accounts.v1.TermsOfServiceAgreementState</code>
 */
class TermsOfServiceAgreementState extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the terms of service version.
     * Format: `accounts/{account}/termsOfServiceAgreementState/{identifier}`
     * The identifier format is:
     * `{[TermsOfServiceKind][google.shopping.merchant.accounts.v1.TermsOfServiceKind]}-{country}`
     * For example, an identifier could be: `MERCHANT_CENTER-EU` or
     * `MERCHANT_CENTER-US`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. Region code as defined by https://cldr.unicode.org/. This is the
     * country the current state applies to.
     *
     * Generated from protobuf field <code>string region_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $region_code = '';
    /**
     * Required. Terms of Service kind associated with the particular version.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.TermsOfServiceKind terms_of_service_kind = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $terms_of_service_kind = 0;
    /**
     * Optional. The accepted terms of service of this kind and for the associated
     * region_code
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.accounts.v1.Accepted accepted = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $accepted = null;
    /**
     * Optional. The required terms of service
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.accounts.v1.Required required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $required = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the terms of service version.
     *           Format: `accounts/{account}/termsOfServiceAgreementState/{identifier}`
     *           The identifier format is:
     *           `{[TermsOfServiceKind][google.shopping.merchant.accounts.v1.TermsOfServiceKind]}-{country}`
     *           For example, an identifier could be: `MERCHANT_CENTER-EU` or
     *           `MERCHANT_CENTER-US`.
     *     @type string $region_code
     *           Required. Region code as defined by https://cldr.unicode.org/. This is the
     *           country the current state applies to.
     *     @type int $terms_of_service_kind
     *           Required. Terms of Service kind associated with the particular version.
     *     @type \Google\Shopping\Merchant\Accounts\V1\Accepted $accepted
     *           Optional. The accepted terms of service of this kind and for the associated
     *           region_code
     *     @type \Google\Shopping\Merchant\Accounts\V1\Required $required
     *           Optional. The required terms of service
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Accounts\V1\Termsofserviceagreementstate::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the terms of service version.
     * Format: `accounts/{account}/termsOfServiceAgreementState/{identifier}`
     * The identifier format is:
     * `{[TermsOfServiceKind][google.shopping.merchant.accounts.v1.TermsOfServiceKind]}-{country}`
     * For example, an identifier could be: `MERCHANT_CENTER-EU` or
     * `MERCHANT_CENTER-US`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the terms of service version.
     * Format: `accounts/{account}/termsOfServiceAgreementState/{identifier}`
     * The identifier format is:
     * `{[TermsOfServiceKind][google.shopping.merchant.accounts.v1.TermsOfServiceKind]}-{country}`
     * For example, an identifier could be: `MERCHANT_CENTER-EU` or
     * `MERCHANT_CENTER-US`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Region code as defined by https://cldr.unicode.org/. This is the
     * country the current state applies to.
     *
     * Generated from protobuf field <code>string region_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getRegionCode()
    {
        return $this->region_code;
    }

    /**
     * Required. Region code as defined by https://cldr.unicode.org/. This is the
     * country the current state applies to.
     *
     * Generated from protobuf field <code>string region_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setRegionCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->region_code = $var;

        return $this;
    }

    /**
     * Required. Terms of Service kind associated with the particular version.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.TermsOfServiceKind terms_of_service_kind = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getTermsOfServiceKind()
    {
        return $this->terms_of_service_kind;
    }

    /**
     * Required. Terms of Service kind associated with the particular version.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.TermsOfServiceKind terms_of_service_kind = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setTermsOfServiceKind($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Accounts\V1\TermsOfServiceKind::class);
        $this->terms_of_service_kind = $var;

        return $this;
    }

    /**
     * Optional. The accepted terms of service of this kind and for the associated
     * region_code
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.accounts.v1.Accepted accepted = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Merchant\Accounts\V1\Accepted|null
     */
    public function getAccepted()
    {
        return $this->accepted;
    }

    public function hasAccepted()
    {
        return isset($this->accepted);
    }

    public function clearAccepted()
    {
        unset($this->accepted);
    }

    /**
     * Optional. The accepted terms of service of this kind and for the associated
     * region_code
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.accounts.v1.Accepted accepted = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Merchant\Accounts\V1\Accepted $var
     * @return $this
     */
    public function setAccepted($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1\Accepted::class);
        $this->accepted = $var;

        return $this;
    }

    /**
     * Optional. The required terms of service
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.accounts.v1.Required required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Merchant\Accounts\V1\Required|null
     */
    public function getRequired()
    {
        return $this->required;
    }

    public function hasRequired()
    {
        return isset($this->required);
    }

    public function clearRequired()
    {
        unset($this->required);
    }

    /**
     * Optional. The required terms of service
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.accounts.v1.Required required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Merchant\Accounts\V1\Required $var
     * @return $this
     */
    public function setRequired($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1\Required::class);
        $this->required = $var;

        return $this;
    }

}

