<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/security/privateca/v1/resources.proto

namespace Google\Cloud\Security\PrivateCA\V1\X509Parameters;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes the X.509 name constraints extension, per
 * https://tools.ietf.org/html/rfc5280#section-4.2.1.10
 *
 * Generated from protobuf message <code>google.cloud.security.privateca.v1.X509Parameters.NameConstraints</code>
 */
class NameConstraints extends \Google\Protobuf\Internal\Message
{
    /**
     * Indicates whether or not the name constraints are marked critical.
     *
     * Generated from protobuf field <code>bool critical = 1;</code>
     */
    protected $critical = false;
    /**
     * Contains permitted DNS names. Any DNS name that can be
     * constructed by simply adding zero or more labels to
     * the left-hand side of the name satisfies the name constraint.
     * For example, `example.com`, `www.example.com`, `www.sub.example.com`
     * would satisfy `example.com` while `example1.com` does not.
     *
     * Generated from protobuf field <code>repeated string permitted_dns_names = 2;</code>
     */
    private $permitted_dns_names;
    /**
     * Contains excluded DNS names. Any DNS name that can be
     * constructed by simply adding zero or more labels to
     * the left-hand side of the name satisfies the name constraint.
     * For example, `example.com`, `www.example.com`, `www.sub.example.com`
     * would satisfy `example.com` while `example1.com` does not.
     *
     * Generated from protobuf field <code>repeated string excluded_dns_names = 3;</code>
     */
    private $excluded_dns_names;
    /**
     * Contains the permitted IP ranges. For IPv4 addresses, the ranges
     * are expressed using CIDR notation as specified in RFC 4632.
     * For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
     * addresses.
     *
     * Generated from protobuf field <code>repeated string permitted_ip_ranges = 4;</code>
     */
    private $permitted_ip_ranges;
    /**
     * Contains the excluded IP ranges. For IPv4 addresses, the ranges
     * are expressed using CIDR notation as specified in RFC 4632.
     * For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
     * addresses.
     *
     * Generated from protobuf field <code>repeated string excluded_ip_ranges = 5;</code>
     */
    private $excluded_ip_ranges;
    /**
     * Contains the permitted email addresses. The value can be a particular
     * email address, a hostname to indicate all email addresses on that host or
     * a domain with a leading period (e.g. `.example.com`) to indicate
     * all email addresses in that domain.
     *
     * Generated from protobuf field <code>repeated string permitted_email_addresses = 6;</code>
     */
    private $permitted_email_addresses;
    /**
     * Contains the excluded email addresses. The value can be a particular
     * email address, a hostname to indicate all email addresses on that host or
     * a domain with a leading period (e.g. `.example.com`) to indicate
     * all email addresses in that domain.
     *
     * Generated from protobuf field <code>repeated string excluded_email_addresses = 7;</code>
     */
    private $excluded_email_addresses;
    /**
     * Contains the permitted URIs that apply to the host part of the name.
     * The value can be a hostname or a domain with a
     * leading period (like `.example.com`)
     *
     * Generated from protobuf field <code>repeated string permitted_uris = 8;</code>
     */
    private $permitted_uris;
    /**
     * Contains the excluded URIs that apply to the host part of the name.
     * The value can be a hostname or a domain with a
     * leading period (like `.example.com`)
     *
     * Generated from protobuf field <code>repeated string excluded_uris = 9;</code>
     */
    private $excluded_uris;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $critical
     *           Indicates whether or not the name constraints are marked critical.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $permitted_dns_names
     *           Contains permitted DNS names. Any DNS name that can be
     *           constructed by simply adding zero or more labels to
     *           the left-hand side of the name satisfies the name constraint.
     *           For example, `example.com`, `www.example.com`, `www.sub.example.com`
     *           would satisfy `example.com` while `example1.com` does not.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $excluded_dns_names
     *           Contains excluded DNS names. Any DNS name that can be
     *           constructed by simply adding zero or more labels to
     *           the left-hand side of the name satisfies the name constraint.
     *           For example, `example.com`, `www.example.com`, `www.sub.example.com`
     *           would satisfy `example.com` while `example1.com` does not.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $permitted_ip_ranges
     *           Contains the permitted IP ranges. For IPv4 addresses, the ranges
     *           are expressed using CIDR notation as specified in RFC 4632.
     *           For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
     *           addresses.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $excluded_ip_ranges
     *           Contains the excluded IP ranges. For IPv4 addresses, the ranges
     *           are expressed using CIDR notation as specified in RFC 4632.
     *           For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
     *           addresses.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $permitted_email_addresses
     *           Contains the permitted email addresses. The value can be a particular
     *           email address, a hostname to indicate all email addresses on that host or
     *           a domain with a leading period (e.g. `.example.com`) to indicate
     *           all email addresses in that domain.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $excluded_email_addresses
     *           Contains the excluded email addresses. The value can be a particular
     *           email address, a hostname to indicate all email addresses on that host or
     *           a domain with a leading period (e.g. `.example.com`) to indicate
     *           all email addresses in that domain.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $permitted_uris
     *           Contains the permitted URIs that apply to the host part of the name.
     *           The value can be a hostname or a domain with a
     *           leading period (like `.example.com`)
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $excluded_uris
     *           Contains the excluded URIs that apply to the host part of the name.
     *           The value can be a hostname or a domain with a
     *           leading period (like `.example.com`)
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Security\Privateca\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Indicates whether or not the name constraints are marked critical.
     *
     * Generated from protobuf field <code>bool critical = 1;</code>
     * @return bool
     */
    public function getCritical()
    {
        return $this->critical;
    }

    /**
     * Indicates whether or not the name constraints are marked critical.
     *
     * Generated from protobuf field <code>bool critical = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setCritical($var)
    {
        GPBUtil::checkBool($var);
        $this->critical = $var;

        return $this;
    }

    /**
     * Contains permitted DNS names. Any DNS name that can be
     * constructed by simply adding zero or more labels to
     * the left-hand side of the name satisfies the name constraint.
     * For example, `example.com`, `www.example.com`, `www.sub.example.com`
     * would satisfy `example.com` while `example1.com` does not.
     *
     * Generated from protobuf field <code>repeated string permitted_dns_names = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPermittedDnsNames()
    {
        return $this->permitted_dns_names;
    }

    /**
     * Contains permitted DNS names. Any DNS name that can be
     * constructed by simply adding zero or more labels to
     * the left-hand side of the name satisfies the name constraint.
     * For example, `example.com`, `www.example.com`, `www.sub.example.com`
     * would satisfy `example.com` while `example1.com` does not.
     *
     * Generated from protobuf field <code>repeated string permitted_dns_names = 2;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPermittedDnsNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->permitted_dns_names = $arr;

        return $this;
    }

    /**
     * Contains excluded DNS names. Any DNS name that can be
     * constructed by simply adding zero or more labels to
     * the left-hand side of the name satisfies the name constraint.
     * For example, `example.com`, `www.example.com`, `www.sub.example.com`
     * would satisfy `example.com` while `example1.com` does not.
     *
     * Generated from protobuf field <code>repeated string excluded_dns_names = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExcludedDnsNames()
    {
        return $this->excluded_dns_names;
    }

    /**
     * Contains excluded DNS names. Any DNS name that can be
     * constructed by simply adding zero or more labels to
     * the left-hand side of the name satisfies the name constraint.
     * For example, `example.com`, `www.example.com`, `www.sub.example.com`
     * would satisfy `example.com` while `example1.com` does not.
     *
     * Generated from protobuf field <code>repeated string excluded_dns_names = 3;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExcludedDnsNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->excluded_dns_names = $arr;

        return $this;
    }

    /**
     * Contains the permitted IP ranges. For IPv4 addresses, the ranges
     * are expressed using CIDR notation as specified in RFC 4632.
     * For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
     * addresses.
     *
     * Generated from protobuf field <code>repeated string permitted_ip_ranges = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPermittedIpRanges()
    {
        return $this->permitted_ip_ranges;
    }

    /**
     * Contains the permitted IP ranges. For IPv4 addresses, the ranges
     * are expressed using CIDR notation as specified in RFC 4632.
     * For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
     * addresses.
     *
     * Generated from protobuf field <code>repeated string permitted_ip_ranges = 4;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPermittedIpRanges($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->permitted_ip_ranges = $arr;

        return $this;
    }

    /**
     * Contains the excluded IP ranges. For IPv4 addresses, the ranges
     * are expressed using CIDR notation as specified in RFC 4632.
     * For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
     * addresses.
     *
     * Generated from protobuf field <code>repeated string excluded_ip_ranges = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExcludedIpRanges()
    {
        return $this->excluded_ip_ranges;
    }

    /**
     * Contains the excluded IP ranges. For IPv4 addresses, the ranges
     * are expressed using CIDR notation as specified in RFC 4632.
     * For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
     * addresses.
     *
     * Generated from protobuf field <code>repeated string excluded_ip_ranges = 5;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExcludedIpRanges($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->excluded_ip_ranges = $arr;

        return $this;
    }

    /**
     * Contains the permitted email addresses. The value can be a particular
     * email address, a hostname to indicate all email addresses on that host or
     * a domain with a leading period (e.g. `.example.com`) to indicate
     * all email addresses in that domain.
     *
     * Generated from protobuf field <code>repeated string permitted_email_addresses = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPermittedEmailAddresses()
    {
        return $this->permitted_email_addresses;
    }

    /**
     * Contains the permitted email addresses. The value can be a particular
     * email address, a hostname to indicate all email addresses on that host or
     * a domain with a leading period (e.g. `.example.com`) to indicate
     * all email addresses in that domain.
     *
     * Generated from protobuf field <code>repeated string permitted_email_addresses = 6;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPermittedEmailAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->permitted_email_addresses = $arr;

        return $this;
    }

    /**
     * Contains the excluded email addresses. The value can be a particular
     * email address, a hostname to indicate all email addresses on that host or
     * a domain with a leading period (e.g. `.example.com`) to indicate
     * all email addresses in that domain.
     *
     * Generated from protobuf field <code>repeated string excluded_email_addresses = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExcludedEmailAddresses()
    {
        return $this->excluded_email_addresses;
    }

    /**
     * Contains the excluded email addresses. The value can be a particular
     * email address, a hostname to indicate all email addresses on that host or
     * a domain with a leading period (e.g. `.example.com`) to indicate
     * all email addresses in that domain.
     *
     * Generated from protobuf field <code>repeated string excluded_email_addresses = 7;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExcludedEmailAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->excluded_email_addresses = $arr;

        return $this;
    }

    /**
     * Contains the permitted URIs that apply to the host part of the name.
     * The value can be a hostname or a domain with a
     * leading period (like `.example.com`)
     *
     * Generated from protobuf field <code>repeated string permitted_uris = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPermittedUris()
    {
        return $this->permitted_uris;
    }

    /**
     * Contains the permitted URIs that apply to the host part of the name.
     * The value can be a hostname or a domain with a
     * leading period (like `.example.com`)
     *
     * Generated from protobuf field <code>repeated string permitted_uris = 8;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPermittedUris($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->permitted_uris = $arr;

        return $this;
    }

    /**
     * Contains the excluded URIs that apply to the host part of the name.
     * The value can be a hostname or a domain with a
     * leading period (like `.example.com`)
     *
     * Generated from protobuf field <code>repeated string excluded_uris = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExcludedUris()
    {
        return $this->excluded_uris;
    }

    /**
     * Contains the excluded URIs that apply to the host part of the name.
     * The value can be a hostname or a domain with a
     * leading period (like `.example.com`)
     *
     * Generated from protobuf field <code>repeated string excluded_uris = 9;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExcludedUris($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->excluded_uris = $arr;

        return $this;
    }

}


