<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/run/v2/vendor_settings.proto

namespace Google\Cloud\Run\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes the Build step of the function that builds a container from the
 * given source.
 *
 * Generated from protobuf message <code>google.cloud.run.v2.BuildConfig</code>
 */
class BuildConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $name = '';
    /**
     * The Cloud Storage bucket URI where the function source code is located.
     *
     * Generated from protobuf field <code>string source_location = 2;</code>
     */
    protected $source_location = '';
    /**
     * Optional. The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     *
     * Generated from protobuf field <code>string function_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $function_target = '';
    /**
     * Optional. Artifact Registry URI to store the built image.
     *
     * Generated from protobuf field <code>string image_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $image_uri = '';
    /**
     * Optional. The base image used to build the function.
     *
     * Generated from protobuf field <code>string base_image = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $base_image = '';
    /**
     * Optional. Sets whether the function will receive automatic base image
     * updates.
     *
     * Generated from protobuf field <code>bool enable_automatic_updates = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $enable_automatic_updates = false;
    /**
     * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     * build the Cloud Run function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     *
     * Generated from protobuf field <code>string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $worker_pool = '';
    /**
     * Optional. User-provided build-time environment variables for the function
     *
     * Generated from protobuf field <code>map<string, string> environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $environment_variables;
    /**
     * Optional. Service account to be used for building the container. The format
     * of this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     *
     * Generated from protobuf field <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $service_account = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The Cloud Build name of the latest successful deployment of
     *           the function.
     *     @type string $source_location
     *           The Cloud Storage bucket URI where the function source code is located.
     *     @type string $function_target
     *           Optional. The name of the function (as defined in source code) that will be
     *           executed. Defaults to the resource name suffix, if not specified. For
     *           backward compatibility, if function with given name is not found, then the
     *           system will try to use function named "function".
     *     @type string $image_uri
     *           Optional. Artifact Registry URI to store the built image.
     *     @type string $base_image
     *           Optional. The base image used to build the function.
     *     @type bool $enable_automatic_updates
     *           Optional. Sets whether the function will receive automatic base image
     *           updates.
     *     @type string $worker_pool
     *           Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     *           build the Cloud Run function. The format of this field is
     *           `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     *           `{project}` and `{region}` are the project id and region respectively where
     *           the worker pool is defined and `{workerPool}` is the short name of the
     *           worker pool.
     *     @type array|\Google\Protobuf\Internal\MapField $environment_variables
     *           Optional. User-provided build-time environment variables for the function
     *     @type string $service_account
     *           Optional. Service account to be used for building the container. The format
     *           of this field is
     *           `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Run\V2\VendorSettings::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The Cloud Storage bucket URI where the function source code is located.
     *
     * Generated from protobuf field <code>string source_location = 2;</code>
     * @return string
     */
    public function getSourceLocation()
    {
        return $this->source_location;
    }

    /**
     * The Cloud Storage bucket URI where the function source code is located.
     *
     * Generated from protobuf field <code>string source_location = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_location = $var;

        return $this;
    }

    /**
     * Optional. The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     *
     * Generated from protobuf field <code>string function_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFunctionTarget()
    {
        return $this->function_target;
    }

    /**
     * Optional. The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     *
     * Generated from protobuf field <code>string function_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFunctionTarget($var)
    {
        GPBUtil::checkString($var, True);
        $this->function_target = $var;

        return $this;
    }

    /**
     * Optional. Artifact Registry URI to store the built image.
     *
     * Generated from protobuf field <code>string image_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getImageUri()
    {
        return $this->image_uri;
    }

    /**
     * Optional. Artifact Registry URI to store the built image.
     *
     * Generated from protobuf field <code>string image_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setImageUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->image_uri = $var;

        return $this;
    }

    /**
     * Optional. The base image used to build the function.
     *
     * Generated from protobuf field <code>string base_image = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getBaseImage()
    {
        return $this->base_image;
    }

    /**
     * Optional. The base image used to build the function.
     *
     * Generated from protobuf field <code>string base_image = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setBaseImage($var)
    {
        GPBUtil::checkString($var, True);
        $this->base_image = $var;

        return $this;
    }

    /**
     * Optional. Sets whether the function will receive automatic base image
     * updates.
     *
     * Generated from protobuf field <code>bool enable_automatic_updates = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableAutomaticUpdates()
    {
        return $this->enable_automatic_updates;
    }

    /**
     * Optional. Sets whether the function will receive automatic base image
     * updates.
     *
     * Generated from protobuf field <code>bool enable_automatic_updates = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableAutomaticUpdates($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_automatic_updates = $var;

        return $this;
    }

    /**
     * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     * build the Cloud Run function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     *
     * Generated from protobuf field <code>string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getWorkerPool()
    {
        return $this->worker_pool;
    }

    /**
     * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     * build the Cloud Run function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     *
     * Generated from protobuf field <code>string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setWorkerPool($var)
    {
        GPBUtil::checkString($var, True);
        $this->worker_pool = $var;

        return $this;
    }

    /**
     * Optional. User-provided build-time environment variables for the function
     *
     * Generated from protobuf field <code>map<string, string> environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getEnvironmentVariables()
    {
        return $this->environment_variables;
    }

    /**
     * Optional. User-provided build-time environment variables for the function
     *
     * Generated from protobuf field <code>map<string, string> environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setEnvironmentVariables($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->environment_variables = $arr;

        return $this;
    }

    /**
     * Optional. Service account to be used for building the container. The format
     * of this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     *
     * Generated from protobuf field <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * Optional. Service account to be used for building the container. The format
     * of this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     *
     * Generated from protobuf field <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

}

