<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/serving_config.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configures metadata that is used to generate serving time results (e.g.
 * search results or recommendation predictions).
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.ServingConfig</code>
 */
class ServingConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $name = '';
    /**
     * Required. The human readable serving config display name. Used in Retail
     * UI.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * The id of the model in the same [Catalog][google.cloud.retail.v2.Catalog]
     * to use at serving time. Currently only RecommendationModels are supported:
     * https://cloud.google.com/retail/recommendations-ai/docs/create-models
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     * Required when
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string model_id = 3;</code>
     */
    protected $model_id = '';
    /**
     * How much price ranking we want in serving results.
     * Price reranking causes product items with a similar
     * recommendation probability to be ordered by price, with the
     * highest-priced items first. This setting could result in a decrease in
     * click-through and conversion rates.
     *  Allowed values are:
     * * `no-price-reranking`
     * * `low-price-reranking`
     * * `medium-price-reranking`
     * * `high-price-reranking`
     * If not specified, we choose default based on model type. Default value:
     * `no-price-reranking`.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string price_reranking_level = 4;</code>
     */
    protected $price_reranking_level = '';
    /**
     * Facet specifications for faceted search. If empty, no facets are returned.
     * The ids refer to the ids of [Control][google.cloud.retail.v2.Control]
     * resources with only the Facet control set. These controls are assumed to be
     * in the same [Catalog][google.cloud.retail.v2.Catalog] as the
     * [ServingConfig][google.cloud.retail.v2.ServingConfig].
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string facet_control_ids = 5;</code>
     */
    private $facet_control_ids;
    /**
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;</code>
     */
    protected $dynamic_facet_spec = null;
    /**
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifications, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 100.
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string boost_control_ids = 7;</code>
     */
    private $boost_control_ids;
    /**
     * Condition filter specifications. If a product matches multiple conditions
     * in the specifications, filters from these specifications are all
     * applied and combined via the AND operator. Maximum number of
     * specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string filter_control_ids = 9;</code>
     */
    private $filter_control_ids;
    /**
     * Condition redirect specifications. Only the first triggered redirect action
     * is applied, even if multiple apply. Maximum number of specifications is
     * 1000.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string redirect_control_ids = 10;</code>
     */
    private $redirect_control_ids;
    /**
     * Condition synonyms specifications. If multiple syonyms conditions match,
     * all matching synonyms control in the list will execute. Order of controls
     * in the list will not matter. Maximum number of specifications is
     * 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string twoway_synonyms_control_ids = 18;</code>
     */
    private $twoway_synonyms_control_ids;
    /**
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list will
     * execute. Order of controls in the list will not matter. Maximum number of
     * specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string oneway_synonyms_control_ids = 12;</code>
     */
    private $oneway_synonyms_control_ids;
    /**
     * Condition do not associate specifications. If multiple do not associate
     * conditions match, all matching do not associate controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string do_not_associate_control_ids = 13;</code>
     */
    private $do_not_associate_control_ids;
    /**
     * Condition replacement specifications.
     * - Applied according to the order in the list.
     * - A previously replaced term can not be re-replaced.
     * - Maximum number of specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string replacement_control_ids = 14;</code>
     */
    private $replacement_control_ids;
    /**
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string ignore_control_ids = 15;</code>
     */
    private $ignore_control_ids;
    /**
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string diversity_level = 8;</code>
     */
    protected $diversity_level = '';
    /**
     * What kind of diversity to use - data driven or rule based. If unset, the
     * server behavior defaults to
     * [RULE_BASED_DIVERSITY][google.cloud.retail.v2.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.ServingConfig.DiversityType diversity_type = 20;</code>
     */
    protected $diversity_type = 0;
    /**
     * Whether to add additional category filters on the `similar-items` model.
     * If not specified, we enable it by default.
     *  Allowed values are:
     * * `no-category-match`: No additional filtering of original results from
     *   the model and the customer's filters.
     * * `relaxed-category-match`: Only keep results with categories that match
     *   at least one item categories in the PredictRequests's context item.
     *   * If customer also sends filters in the PredictRequest, then the results
     *   will satisfy both conditions (user given and category match).
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string enable_category_filter_level = 16;</code>
     */
    protected $enable_category_filter_level = '';
    /**
     * When the flag is enabled, the products in the denylist will not be filtered
     * out in the recommendation filtering results.
     *
     * Generated from protobuf field <code>bool ignore_recs_denylist = 24;</code>
     */
    protected $ignore_recs_denylist = false;
    /**
     * The specification for personalization spec.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.PersonalizationSpec personalization_spec = 21;</code>
     */
    protected $personalization_spec = null;
    /**
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $solution_types;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Immutable. Fully qualified name
     *           `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
     *     @type string $display_name
     *           Required. The human readable serving config display name. Used in Retail
     *           UI.
     *           This field must be a UTF-8 encoded string with a length limit of 128
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type string $model_id
     *           The id of the model in the same [Catalog][google.cloud.retail.v2.Catalog]
     *           to use at serving time. Currently only RecommendationModels are supported:
     *           https://cloud.google.com/retail/recommendations-ai/docs/create-models
     *           Can be changed but only to a compatible model (e.g.
     *           others-you-may-like CTR to others-you-may-like CVR).
     *           Required when
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *     @type string $price_reranking_level
     *           How much price ranking we want in serving results.
     *           Price reranking causes product items with a similar
     *           recommendation probability to be ordered by price, with the
     *           highest-priced items first. This setting could result in a decrease in
     *           click-through and conversion rates.
     *            Allowed values are:
     *           * `no-price-reranking`
     *           * `low-price-reranking`
     *           * `medium-price-reranking`
     *           * `high-price-reranking`
     *           If not specified, we choose default based on model type. Default value:
     *           `no-price-reranking`.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $facet_control_ids
     *           Facet specifications for faceted search. If empty, no facets are returned.
     *           The ids refer to the ids of [Control][google.cloud.retail.v2.Control]
     *           resources with only the Facet control set. These controls are assumed to be
     *           in the same [Catalog][google.cloud.retail.v2.Catalog] as the
     *           [ServingConfig][google.cloud.retail.v2.ServingConfig].
     *           A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     *           is returned.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type \Google\Cloud\Retail\V2\SearchRequest\DynamicFacetSpec $dynamic_facet_spec
     *           The specification for dynamically generated facets. Notice that only
     *           textual facets can be dynamically generated.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $boost_control_ids
     *           Condition boost specifications. If a product matches multiple conditions
     *           in the specifications, boost scores from these specifications are all
     *           applied and combined in a non-linear way. Maximum number of
     *           specifications is 100.
     *           Notice that if both
     *           [ServingConfig.boost_control_ids][google.cloud.retail.v2.ServingConfig.boost_control_ids]
     *           and
     *           [SearchRequest.boost_spec][google.cloud.retail.v2.SearchRequest.boost_spec]
     *           are set, the boost conditions from both places are evaluated. If a search
     *           request matches multiple boost conditions, the final boost score is equal
     *           to the sum of the boost scores from all matched boost conditions.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $filter_control_ids
     *           Condition filter specifications. If a product matches multiple conditions
     *           in the specifications, filters from these specifications are all
     *           applied and combined via the AND operator. Maximum number of
     *           specifications is 100.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $redirect_control_ids
     *           Condition redirect specifications. Only the first triggered redirect action
     *           is applied, even if multiple apply. Maximum number of specifications is
     *           1000.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $twoway_synonyms_control_ids
     *           Condition synonyms specifications. If multiple syonyms conditions match,
     *           all matching synonyms control in the list will execute. Order of controls
     *           in the list will not matter. Maximum number of specifications is
     *           100.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $oneway_synonyms_control_ids
     *           Condition oneway synonyms specifications. If multiple oneway synonyms
     *           conditions match, all matching oneway synonyms controls in the list will
     *           execute. Order of controls in the list will not matter. Maximum number of
     *           specifications is 100.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $do_not_associate_control_ids
     *           Condition do not associate specifications. If multiple do not associate
     *           conditions match, all matching do not associate controls in the list will
     *           execute.
     *           - Order does not matter.
     *           - Maximum number of specifications is 100.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $replacement_control_ids
     *           Condition replacement specifications.
     *           - Applied according to the order in the list.
     *           - A previously replaced term can not be re-replaced.
     *           - Maximum number of specifications is 100.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $ignore_control_ids
     *           Condition ignore specifications. If multiple ignore
     *           conditions match, all matching ignore controls in the list will
     *           execute.
     *           - Order does not matter.
     *           - Maximum number of specifications is 100.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *     @type string $diversity_level
     *           How much diversity to use in recommendation model results e.g.
     *           `medium-diversity` or `high-diversity`. Currently supported values:
     *           * `no-diversity`
     *           * `low-diversity`
     *           * `medium-diversity`
     *           * `high-diversity`
     *           * `auto-diversity`
     *           If not specified, we choose default based on recommendation model
     *           type. Default value: `no-diversity`.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *     @type int $diversity_type
     *           What kind of diversity to use - data driven or rule based. If unset, the
     *           server behavior defaults to
     *           [RULE_BASED_DIVERSITY][google.cloud.retail.v2.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
     *     @type string $enable_category_filter_level
     *           Whether to add additional category filters on the `similar-items` model.
     *           If not specified, we enable it by default.
     *            Allowed values are:
     *           * `no-category-match`: No additional filtering of original results from
     *             the model and the customer's filters.
     *           * `relaxed-category-match`: Only keep results with categories that match
     *             at least one item categories in the PredictRequests's context item.
     *             * If customer also sends filters in the PredictRequest, then the results
     *             will satisfy both conditions (user given and category match).
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *     @type bool $ignore_recs_denylist
     *           When the flag is enabled, the products in the denylist will not be filtered
     *           out in the recommendation filtering results.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\PersonalizationSpec $personalization_spec
     *           The specification for personalization spec.
     *           Can only be set if
     *           [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     *           [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *           Notice that if both
     *           [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec]
     *           and
     *           [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     *           are set.
     *           [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     *           will override
     *           [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec].
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $solution_types
     *           Required. Immutable. Specifies the solution types that a serving config can
     *           be associated with. Currently we support setting only one type of solution.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\ServingConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The human readable serving config display name. Used in Retail
     * UI.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The human readable serving config display name. Used in Retail
     * UI.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The id of the model in the same [Catalog][google.cloud.retail.v2.Catalog]
     * to use at serving time. Currently only RecommendationModels are supported:
     * https://cloud.google.com/retail/recommendations-ai/docs/create-models
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     * Required when
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string model_id = 3;</code>
     * @return string
     */
    public function getModelId()
    {
        return $this->model_id;
    }

    /**
     * The id of the model in the same [Catalog][google.cloud.retail.v2.Catalog]
     * to use at serving time. Currently only RecommendationModels are supported:
     * https://cloud.google.com/retail/recommendations-ai/docs/create-models
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     * Required when
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string model_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setModelId($var)
    {
        GPBUtil::checkString($var, True);
        $this->model_id = $var;

        return $this;
    }

    /**
     * How much price ranking we want in serving results.
     * Price reranking causes product items with a similar
     * recommendation probability to be ordered by price, with the
     * highest-priced items first. This setting could result in a decrease in
     * click-through and conversion rates.
     *  Allowed values are:
     * * `no-price-reranking`
     * * `low-price-reranking`
     * * `medium-price-reranking`
     * * `high-price-reranking`
     * If not specified, we choose default based on model type. Default value:
     * `no-price-reranking`.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string price_reranking_level = 4;</code>
     * @return string
     */
    public function getPriceRerankingLevel()
    {
        return $this->price_reranking_level;
    }

    /**
     * How much price ranking we want in serving results.
     * Price reranking causes product items with a similar
     * recommendation probability to be ordered by price, with the
     * highest-priced items first. This setting could result in a decrease in
     * click-through and conversion rates.
     *  Allowed values are:
     * * `no-price-reranking`
     * * `low-price-reranking`
     * * `medium-price-reranking`
     * * `high-price-reranking`
     * If not specified, we choose default based on model type. Default value:
     * `no-price-reranking`.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string price_reranking_level = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setPriceRerankingLevel($var)
    {
        GPBUtil::checkString($var, True);
        $this->price_reranking_level = $var;

        return $this;
    }

    /**
     * Facet specifications for faceted search. If empty, no facets are returned.
     * The ids refer to the ids of [Control][google.cloud.retail.v2.Control]
     * resources with only the Facet control set. These controls are assumed to be
     * in the same [Catalog][google.cloud.retail.v2.Catalog] as the
     * [ServingConfig][google.cloud.retail.v2.ServingConfig].
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string facet_control_ids = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFacetControlIds()
    {
        return $this->facet_control_ids;
    }

    /**
     * Facet specifications for faceted search. If empty, no facets are returned.
     * The ids refer to the ids of [Control][google.cloud.retail.v2.Control]
     * resources with only the Facet control set. These controls are assumed to be
     * in the same [Catalog][google.cloud.retail.v2.Catalog] as the
     * [ServingConfig][google.cloud.retail.v2.ServingConfig].
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string facet_control_ids = 5;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFacetControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->facet_control_ids = $arr;

        return $this;
    }

    /**
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\DynamicFacetSpec|null
     */
    public function getDynamicFacetSpec()
    {
        return $this->dynamic_facet_spec;
    }

    public function hasDynamicFacetSpec()
    {
        return isset($this->dynamic_facet_spec);
    }

    public function clearDynamicFacetSpec()
    {
        unset($this->dynamic_facet_spec);
    }

    /**
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\DynamicFacetSpec $var
     * @return $this
     */
    public function setDynamicFacetSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\DynamicFacetSpec::class);
        $this->dynamic_facet_spec = $var;

        return $this;
    }

    /**
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifications, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 100.
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string boost_control_ids = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBoostControlIds()
    {
        return $this->boost_control_ids;
    }

    /**
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifications, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 100.
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string boost_control_ids = 7;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBoostControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->boost_control_ids = $arr;

        return $this;
    }

    /**
     * Condition filter specifications. If a product matches multiple conditions
     * in the specifications, filters from these specifications are all
     * applied and combined via the AND operator. Maximum number of
     * specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string filter_control_ids = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFilterControlIds()
    {
        return $this->filter_control_ids;
    }

    /**
     * Condition filter specifications. If a product matches multiple conditions
     * in the specifications, filters from these specifications are all
     * applied and combined via the AND operator. Maximum number of
     * specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string filter_control_ids = 9;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFilterControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->filter_control_ids = $arr;

        return $this;
    }

    /**
     * Condition redirect specifications. Only the first triggered redirect action
     * is applied, even if multiple apply. Maximum number of specifications is
     * 1000.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string redirect_control_ids = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRedirectControlIds()
    {
        return $this->redirect_control_ids;
    }

    /**
     * Condition redirect specifications. Only the first triggered redirect action
     * is applied, even if multiple apply. Maximum number of specifications is
     * 1000.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string redirect_control_ids = 10;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRedirectControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->redirect_control_ids = $arr;

        return $this;
    }

    /**
     * Condition synonyms specifications. If multiple syonyms conditions match,
     * all matching synonyms control in the list will execute. Order of controls
     * in the list will not matter. Maximum number of specifications is
     * 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string twoway_synonyms_control_ids = 18;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTwowaySynonymsControlIds()
    {
        return $this->twoway_synonyms_control_ids;
    }

    /**
     * Condition synonyms specifications. If multiple syonyms conditions match,
     * all matching synonyms control in the list will execute. Order of controls
     * in the list will not matter. Maximum number of specifications is
     * 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string twoway_synonyms_control_ids = 18;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTwowaySynonymsControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->twoway_synonyms_control_ids = $arr;

        return $this;
    }

    /**
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list will
     * execute. Order of controls in the list will not matter. Maximum number of
     * specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string oneway_synonyms_control_ids = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOnewaySynonymsControlIds()
    {
        return $this->oneway_synonyms_control_ids;
    }

    /**
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list will
     * execute. Order of controls in the list will not matter. Maximum number of
     * specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string oneway_synonyms_control_ids = 12;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOnewaySynonymsControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->oneway_synonyms_control_ids = $arr;

        return $this;
    }

    /**
     * Condition do not associate specifications. If multiple do not associate
     * conditions match, all matching do not associate controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string do_not_associate_control_ids = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDoNotAssociateControlIds()
    {
        return $this->do_not_associate_control_ids;
    }

    /**
     * Condition do not associate specifications. If multiple do not associate
     * conditions match, all matching do not associate controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string do_not_associate_control_ids = 13;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDoNotAssociateControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->do_not_associate_control_ids = $arr;

        return $this;
    }

    /**
     * Condition replacement specifications.
     * - Applied according to the order in the list.
     * - A previously replaced term can not be re-replaced.
     * - Maximum number of specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string replacement_control_ids = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReplacementControlIds()
    {
        return $this->replacement_control_ids;
    }

    /**
     * Condition replacement specifications.
     * - Applied according to the order in the list.
     * - A previously replaced term can not be re-replaced.
     * - Maximum number of specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string replacement_control_ids = 14;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReplacementControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->replacement_control_ids = $arr;

        return $this;
    }

    /**
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string ignore_control_ids = 15;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIgnoreControlIds()
    {
        return $this->ignore_control_ids;
    }

    /**
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Generated from protobuf field <code>repeated string ignore_control_ids = 15;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIgnoreControlIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->ignore_control_ids = $arr;

        return $this;
    }

    /**
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string diversity_level = 8;</code>
     * @return string
     */
    public function getDiversityLevel()
    {
        return $this->diversity_level;
    }

    /**
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string diversity_level = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setDiversityLevel($var)
    {
        GPBUtil::checkString($var, True);
        $this->diversity_level = $var;

        return $this;
    }

    /**
     * What kind of diversity to use - data driven or rule based. If unset, the
     * server behavior defaults to
     * [RULE_BASED_DIVERSITY][google.cloud.retail.v2.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.ServingConfig.DiversityType diversity_type = 20;</code>
     * @return int
     */
    public function getDiversityType()
    {
        return $this->diversity_type;
    }

    /**
     * What kind of diversity to use - data driven or rule based. If unset, the
     * server behavior defaults to
     * [RULE_BASED_DIVERSITY][google.cloud.retail.v2.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.ServingConfig.DiversityType diversity_type = 20;</code>
     * @param int $var
     * @return $this
     */
    public function setDiversityType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Retail\V2\ServingConfig\DiversityType::class);
        $this->diversity_type = $var;

        return $this;
    }

    /**
     * Whether to add additional category filters on the `similar-items` model.
     * If not specified, we enable it by default.
     *  Allowed values are:
     * * `no-category-match`: No additional filtering of original results from
     *   the model and the customer's filters.
     * * `relaxed-category-match`: Only keep results with categories that match
     *   at least one item categories in the PredictRequests's context item.
     *   * If customer also sends filters in the PredictRequest, then the results
     *   will satisfy both conditions (user given and category match).
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string enable_category_filter_level = 16;</code>
     * @return string
     */
    public function getEnableCategoryFilterLevel()
    {
        return $this->enable_category_filter_level;
    }

    /**
     * Whether to add additional category filters on the `similar-items` model.
     * If not specified, we enable it by default.
     *  Allowed values are:
     * * `no-category-match`: No additional filtering of original results from
     *   the model and the customer's filters.
     * * `relaxed-category-match`: Only keep results with categories that match
     *   at least one item categories in the PredictRequests's context item.
     *   * If customer also sends filters in the PredictRequest, then the results
     *   will satisfy both conditions (user given and category match).
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     *
     * Generated from protobuf field <code>string enable_category_filter_level = 16;</code>
     * @param string $var
     * @return $this
     */
    public function setEnableCategoryFilterLevel($var)
    {
        GPBUtil::checkString($var, True);
        $this->enable_category_filter_level = $var;

        return $this;
    }

    /**
     * When the flag is enabled, the products in the denylist will not be filtered
     * out in the recommendation filtering results.
     *
     * Generated from protobuf field <code>bool ignore_recs_denylist = 24;</code>
     * @return bool
     */
    public function getIgnoreRecsDenylist()
    {
        return $this->ignore_recs_denylist;
    }

    /**
     * When the flag is enabled, the products in the denylist will not be filtered
     * out in the recommendation filtering results.
     *
     * Generated from protobuf field <code>bool ignore_recs_denylist = 24;</code>
     * @param bool $var
     * @return $this
     */
    public function setIgnoreRecsDenylist($var)
    {
        GPBUtil::checkBool($var);
        $this->ignore_recs_denylist = $var;

        return $this;
    }

    /**
     * The specification for personalization spec.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.PersonalizationSpec personalization_spec = 21;</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\PersonalizationSpec|null
     */
    public function getPersonalizationSpec()
    {
        return $this->personalization_spec;
    }

    public function hasPersonalizationSpec()
    {
        return isset($this->personalization_spec);
    }

    public function clearPersonalizationSpec()
    {
        unset($this->personalization_spec);
    }

    /**
     * The specification for personalization spec.
     * Can only be set if
     * [solution_types][google.cloud.retail.v2.ServingConfig.solution_types] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2.SolutionType.SOLUTION_TYPE_SEARCH].
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2.ServingConfig.personalization_spec].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.PersonalizationSpec personalization_spec = 21;</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\PersonalizationSpec $var
     * @return $this
     */
    public function setPersonalizationSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\PersonalizationSpec::class);
        $this->personalization_spec = $var;

        return $this;
    }

    /**
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSolutionTypes()
    {
        return $this->solution_types;
    }

    /**
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSolutionTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Retail\V2\SolutionType::class);
        $this->solution_types = $arr;

        return $this;
    }

}

