<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/redis/cluster/v1/cloud_redis_cluster.proto

namespace Google\Cloud\Redis\Cluster\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A cluster instance.
 *
 * Generated from protobuf message <code>google.cloud.redis.cluster.v1.Cluster</code>
 */
class Cluster extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Identifier. Unique name of the resource in this scope including
     * project and location using the form:
     *     `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The timestamp associated with the cluster creation request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The current state of this cluster.
     * Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. System assigned, unique identifier for the cluster.
     *
     * Generated from protobuf field <code>string uid = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';
    /**
     * Optional. The number of replica nodes per shard.
     *
     * Generated from protobuf field <code>optional int32 replica_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $replica_count = null;
    /**
     * Optional. The authorization mode of the Redis cluster.
     * If not provided, auth feature is disabled for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.AuthorizationMode authorization_mode = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $authorization_mode = 0;
    /**
     * Optional. The in-transit encryption for the Redis cluster.
     * If not provided, encryption  is disabled for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.TransitEncryptionMode transit_encryption_mode = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $transit_encryption_mode = 0;
    /**
     * Output only. Redis memory size in GB for the entire cluster rounded up to
     * the next integer.
     *
     * Generated from protobuf field <code>optional int32 size_gb = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $size_gb = null;
    /**
     * Optional. Number of shards for the Redis cluster.
     *
     * Generated from protobuf field <code>optional int32 shard_count = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $shard_count = null;
    /**
     * Optional. Each PscConfig configures the consumer network where IPs will
     * be designated to the cluster for client access through Private Service
     * Connect Automation. Currently, only one PscConfig is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.PscConfig psc_configs = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $psc_configs;
    /**
     * Output only. Endpoints created on each given network, for Redis clients to
     * connect to the cluster. Currently only one discovery endpoint is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.DiscoveryEndpoint discovery_endpoints = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $discovery_endpoints;
    /**
     * Output only. The list of PSC connections that are auto-created through
     * service connectivity automation.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.PscConnection psc_connections = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $psc_connections;
    /**
     * Output only. Additional information about the current state of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster.StateInfo state_info = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state_info = null;
    /**
     * Optional. The type of a redis node in the cluster. NodeType determines the
     * underlying machine-type of a redis node.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.NodeType node_type = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $node_type = 0;
    /**
     * Optional. Persistence config (RDB, AOF) for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.ClusterPersistenceConfig persistence_config = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $persistence_config = null;
    /**
     * Optional. Key/Value pairs of customer overrides for mutable Redis Configs
     *
     * Generated from protobuf field <code>map<string, string> redis_configs = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $redis_configs;
    /**
     * Output only. Precise value of redis memory size in GB for the entire
     * cluster.
     *
     * Generated from protobuf field <code>optional double precise_size_gb = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $precise_size_gb = null;
    /**
     * Optional. This config will be used to determine how the customer wants us
     * to distribute cluster resources within the region.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.ZoneDistributionConfig zone_distribution_config = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $zone_distribution_config = null;
    /**
     * Optional. Cross cluster replication config.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.CrossClusterReplicationConfig cross_cluster_replication_config = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cross_cluster_replication_config = null;
    /**
     * Optional. The delete operation will fail when the value is set to true.
     *
     * Generated from protobuf field <code>optional bool deletion_protection_enabled = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $deletion_protection_enabled = null;
    /**
     * Optional. ClusterMaintenancePolicy determines when to allow or deny
     * updates.
     *
     * Generated from protobuf field <code>optional .google.cloud.redis.cluster.v1.ClusterMaintenancePolicy maintenance_policy = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $maintenance_policy = null;
    /**
     * Output only. ClusterMaintenanceSchedule Output only Published maintenance
     * schedule.
     *
     * Generated from protobuf field <code>optional .google.cloud.redis.cluster.v1.ClusterMaintenanceSchedule maintenance_schedule = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $maintenance_schedule = null;
    /**
     * Output only. Service attachment details to configure Psc connections
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.PscServiceAttachment psc_service_attachments = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $psc_service_attachments;
    /**
     * Optional. A list of cluster enpoints.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.ClusterEndpoint cluster_endpoints = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $cluster_endpoints;
    /**
     * Optional. Output only. The backup collection full resource name. Example:
     * projects/{project}/locations/{location}/backupCollections/{collection}
     *
     * Generated from protobuf field <code>optional string backup_collection = 39 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $backup_collection = null;
    /**
     * Optional. The KMS key used to encrypt the at-rest data of the cluster.
     *
     * Generated from protobuf field <code>optional string kms_key = 40 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $kms_key = null;
    /**
     * Optional. The automated backup config for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.AutomatedBackupConfig automated_backup_config = 42 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $automated_backup_config = null;
    /**
     * Output only. Encryption information of the data at rest of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.EncryptionInfo encryption_info = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $encryption_info = null;
    protected $import_sources;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Redis\Cluster\V1\Cluster\GcsBackupSource $gcs_source
     *           Optional. Backups stored in Cloud Storage buckets.
     *           The Cloud Storage buckets need to be the same region as the clusters.
     *           Read permission is required to import from the provided Cloud Storage
     *           objects.
     *     @type \Google\Cloud\Redis\Cluster\V1\Cluster\ManagedBackupSource $managed_backup_source
     *           Optional. Backups generated and managed by memorystore service.
     *     @type string $name
     *           Required. Identifier. Unique name of the resource in this scope including
     *           project and location using the form:
     *               `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp associated with the cluster creation request.
     *     @type int $state
     *           Output only. The current state of this cluster.
     *           Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
     *     @type string $uid
     *           Output only. System assigned, unique identifier for the cluster.
     *     @type int $replica_count
     *           Optional. The number of replica nodes per shard.
     *     @type int $authorization_mode
     *           Optional. The authorization mode of the Redis cluster.
     *           If not provided, auth feature is disabled for the cluster.
     *     @type int $transit_encryption_mode
     *           Optional. The in-transit encryption for the Redis cluster.
     *           If not provided, encryption  is disabled for the cluster.
     *     @type int $size_gb
     *           Output only. Redis memory size in GB for the entire cluster rounded up to
     *           the next integer.
     *     @type int $shard_count
     *           Optional. Number of shards for the Redis cluster.
     *     @type array<\Google\Cloud\Redis\Cluster\V1\PscConfig>|\Google\Protobuf\Internal\RepeatedField $psc_configs
     *           Optional. Each PscConfig configures the consumer network where IPs will
     *           be designated to the cluster for client access through Private Service
     *           Connect Automation. Currently, only one PscConfig is supported.
     *     @type array<\Google\Cloud\Redis\Cluster\V1\DiscoveryEndpoint>|\Google\Protobuf\Internal\RepeatedField $discovery_endpoints
     *           Output only. Endpoints created on each given network, for Redis clients to
     *           connect to the cluster. Currently only one discovery endpoint is supported.
     *     @type array<\Google\Cloud\Redis\Cluster\V1\PscConnection>|\Google\Protobuf\Internal\RepeatedField $psc_connections
     *           Output only. The list of PSC connections that are auto-created through
     *           service connectivity automation.
     *     @type \Google\Cloud\Redis\Cluster\V1\Cluster\StateInfo $state_info
     *           Output only. Additional information about the current state of the cluster.
     *     @type int $node_type
     *           Optional. The type of a redis node in the cluster. NodeType determines the
     *           underlying machine-type of a redis node.
     *     @type \Google\Cloud\Redis\Cluster\V1\ClusterPersistenceConfig $persistence_config
     *           Optional. Persistence config (RDB, AOF) for the cluster.
     *     @type array|\Google\Protobuf\Internal\MapField $redis_configs
     *           Optional. Key/Value pairs of customer overrides for mutable Redis Configs
     *     @type float $precise_size_gb
     *           Output only. Precise value of redis memory size in GB for the entire
     *           cluster.
     *     @type \Google\Cloud\Redis\Cluster\V1\ZoneDistributionConfig $zone_distribution_config
     *           Optional. This config will be used to determine how the customer wants us
     *           to distribute cluster resources within the region.
     *     @type \Google\Cloud\Redis\Cluster\V1\CrossClusterReplicationConfig $cross_cluster_replication_config
     *           Optional. Cross cluster replication config.
     *     @type bool $deletion_protection_enabled
     *           Optional. The delete operation will fail when the value is set to true.
     *     @type \Google\Cloud\Redis\Cluster\V1\ClusterMaintenancePolicy $maintenance_policy
     *           Optional. ClusterMaintenancePolicy determines when to allow or deny
     *           updates.
     *     @type \Google\Cloud\Redis\Cluster\V1\ClusterMaintenanceSchedule $maintenance_schedule
     *           Output only. ClusterMaintenanceSchedule Output only Published maintenance
     *           schedule.
     *     @type array<\Google\Cloud\Redis\Cluster\V1\PscServiceAttachment>|\Google\Protobuf\Internal\RepeatedField $psc_service_attachments
     *           Output only. Service attachment details to configure Psc connections
     *     @type array<\Google\Cloud\Redis\Cluster\V1\ClusterEndpoint>|\Google\Protobuf\Internal\RepeatedField $cluster_endpoints
     *           Optional. A list of cluster enpoints.
     *     @type string $backup_collection
     *           Optional. Output only. The backup collection full resource name. Example:
     *           projects/{project}/locations/{location}/backupCollections/{collection}
     *     @type string $kms_key
     *           Optional. The KMS key used to encrypt the at-rest data of the cluster.
     *     @type \Google\Cloud\Redis\Cluster\V1\AutomatedBackupConfig $automated_backup_config
     *           Optional. The automated backup config for the cluster.
     *     @type \Google\Cloud\Redis\Cluster\V1\EncryptionInfo $encryption_info
     *           Output only. Encryption information of the data at rest of the cluster.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Redis\Cluster\V1\CloudRedisCluster::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Backups stored in Cloud Storage buckets.
     * The Cloud Storage buckets need to be the same region as the clusters.
     * Read permission is required to import from the provided Cloud Storage
     * objects.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster.GcsBackupSource gcs_source = 34 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Redis\Cluster\V1\Cluster\GcsBackupSource|null
     */
    public function getGcsSource()
    {
        return $this->readOneof(34);
    }

    public function hasGcsSource()
    {
        return $this->hasOneof(34);
    }

    /**
     * Optional. Backups stored in Cloud Storage buckets.
     * The Cloud Storage buckets need to be the same region as the clusters.
     * Read permission is required to import from the provided Cloud Storage
     * objects.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster.GcsBackupSource gcs_source = 34 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Redis\Cluster\V1\Cluster\GcsBackupSource $var
     * @return $this
     */
    public function setGcsSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Redis\Cluster\V1\Cluster\GcsBackupSource::class);
        $this->writeOneof(34, $var);

        return $this;
    }

    /**
     * Optional. Backups generated and managed by memorystore service.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster.ManagedBackupSource managed_backup_source = 35 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Redis\Cluster\V1\Cluster\ManagedBackupSource|null
     */
    public function getManagedBackupSource()
    {
        return $this->readOneof(35);
    }

    public function hasManagedBackupSource()
    {
        return $this->hasOneof(35);
    }

    /**
     * Optional. Backups generated and managed by memorystore service.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster.ManagedBackupSource managed_backup_source = 35 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Redis\Cluster\V1\Cluster\ManagedBackupSource $var
     * @return $this
     */
    public function setManagedBackupSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Redis\Cluster\V1\Cluster\ManagedBackupSource::class);
        $this->writeOneof(35, $var);

        return $this;
    }

    /**
     * Required. Identifier. Unique name of the resource in this scope including
     * project and location using the form:
     *     `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. Identifier. Unique name of the resource in this scope including
     * project and location using the form:
     *     `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The timestamp associated with the cluster creation request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp associated with the cluster creation request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The current state of this cluster.
     * Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current state of this cluster.
     * Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Redis\Cluster\V1\Cluster\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. System assigned, unique identifier for the cluster.
     *
     * Generated from protobuf field <code>string uid = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. System assigned, unique identifier for the cluster.
     *
     * Generated from protobuf field <code>string uid = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Optional. The number of replica nodes per shard.
     *
     * Generated from protobuf field <code>optional int32 replica_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getReplicaCount()
    {
        return isset($this->replica_count) ? $this->replica_count : 0;
    }

    public function hasReplicaCount()
    {
        return isset($this->replica_count);
    }

    public function clearReplicaCount()
    {
        unset($this->replica_count);
    }

    /**
     * Optional. The number of replica nodes per shard.
     *
     * Generated from protobuf field <code>optional int32 replica_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setReplicaCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->replica_count = $var;

        return $this;
    }

    /**
     * Optional. The authorization mode of the Redis cluster.
     * If not provided, auth feature is disabled for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.AuthorizationMode authorization_mode = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getAuthorizationMode()
    {
        return $this->authorization_mode;
    }

    /**
     * Optional. The authorization mode of the Redis cluster.
     * If not provided, auth feature is disabled for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.AuthorizationMode authorization_mode = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setAuthorizationMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Redis\Cluster\V1\AuthorizationMode::class);
        $this->authorization_mode = $var;

        return $this;
    }

    /**
     * Optional. The in-transit encryption for the Redis cluster.
     * If not provided, encryption  is disabled for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.TransitEncryptionMode transit_encryption_mode = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getTransitEncryptionMode()
    {
        return $this->transit_encryption_mode;
    }

    /**
     * Optional. The in-transit encryption for the Redis cluster.
     * If not provided, encryption  is disabled for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.TransitEncryptionMode transit_encryption_mode = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setTransitEncryptionMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Redis\Cluster\V1\TransitEncryptionMode::class);
        $this->transit_encryption_mode = $var;

        return $this;
    }

    /**
     * Output only. Redis memory size in GB for the entire cluster rounded up to
     * the next integer.
     *
     * Generated from protobuf field <code>optional int32 size_gb = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getSizeGb()
    {
        return isset($this->size_gb) ? $this->size_gb : 0;
    }

    public function hasSizeGb()
    {
        return isset($this->size_gb);
    }

    public function clearSizeGb()
    {
        unset($this->size_gb);
    }

    /**
     * Output only. Redis memory size in GB for the entire cluster rounded up to
     * the next integer.
     *
     * Generated from protobuf field <code>optional int32 size_gb = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setSizeGb($var)
    {
        GPBUtil::checkInt32($var);
        $this->size_gb = $var;

        return $this;
    }

    /**
     * Optional. Number of shards for the Redis cluster.
     *
     * Generated from protobuf field <code>optional int32 shard_count = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getShardCount()
    {
        return isset($this->shard_count) ? $this->shard_count : 0;
    }

    public function hasShardCount()
    {
        return isset($this->shard_count);
    }

    public function clearShardCount()
    {
        unset($this->shard_count);
    }

    /**
     * Optional. Number of shards for the Redis cluster.
     *
     * Generated from protobuf field <code>optional int32 shard_count = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setShardCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->shard_count = $var;

        return $this;
    }

    /**
     * Optional. Each PscConfig configures the consumer network where IPs will
     * be designated to the cluster for client access through Private Service
     * Connect Automation. Currently, only one PscConfig is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.PscConfig psc_configs = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPscConfigs()
    {
        return $this->psc_configs;
    }

    /**
     * Optional. Each PscConfig configures the consumer network where IPs will
     * be designated to the cluster for client access through Private Service
     * Connect Automation. Currently, only one PscConfig is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.PscConfig psc_configs = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Redis\Cluster\V1\PscConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPscConfigs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Redis\Cluster\V1\PscConfig::class);
        $this->psc_configs = $arr;

        return $this;
    }

    /**
     * Output only. Endpoints created on each given network, for Redis clients to
     * connect to the cluster. Currently only one discovery endpoint is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.DiscoveryEndpoint discovery_endpoints = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDiscoveryEndpoints()
    {
        return $this->discovery_endpoints;
    }

    /**
     * Output only. Endpoints created on each given network, for Redis clients to
     * connect to the cluster. Currently only one discovery endpoint is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.DiscoveryEndpoint discovery_endpoints = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Redis\Cluster\V1\DiscoveryEndpoint>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDiscoveryEndpoints($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Redis\Cluster\V1\DiscoveryEndpoint::class);
        $this->discovery_endpoints = $arr;

        return $this;
    }

    /**
     * Output only. The list of PSC connections that are auto-created through
     * service connectivity automation.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.PscConnection psc_connections = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPscConnections()
    {
        return $this->psc_connections;
    }

    /**
     * Output only. The list of PSC connections that are auto-created through
     * service connectivity automation.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.PscConnection psc_connections = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Redis\Cluster\V1\PscConnection>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPscConnections($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Redis\Cluster\V1\PscConnection::class);
        $this->psc_connections = $arr;

        return $this;
    }

    /**
     * Output only. Additional information about the current state of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster.StateInfo state_info = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Redis\Cluster\V1\Cluster\StateInfo|null
     */
    public function getStateInfo()
    {
        return $this->state_info;
    }

    public function hasStateInfo()
    {
        return isset($this->state_info);
    }

    public function clearStateInfo()
    {
        unset($this->state_info);
    }

    /**
     * Output only. Additional information about the current state of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster.StateInfo state_info = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Redis\Cluster\V1\Cluster\StateInfo $var
     * @return $this
     */
    public function setStateInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Redis\Cluster\V1\Cluster\StateInfo::class);
        $this->state_info = $var;

        return $this;
    }

    /**
     * Optional. The type of a redis node in the cluster. NodeType determines the
     * underlying machine-type of a redis node.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.NodeType node_type = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getNodeType()
    {
        return $this->node_type;
    }

    /**
     * Optional. The type of a redis node in the cluster. NodeType determines the
     * underlying machine-type of a redis node.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.NodeType node_type = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setNodeType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Redis\Cluster\V1\NodeType::class);
        $this->node_type = $var;

        return $this;
    }

    /**
     * Optional. Persistence config (RDB, AOF) for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.ClusterPersistenceConfig persistence_config = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Redis\Cluster\V1\ClusterPersistenceConfig|null
     */
    public function getPersistenceConfig()
    {
        return $this->persistence_config;
    }

    public function hasPersistenceConfig()
    {
        return isset($this->persistence_config);
    }

    public function clearPersistenceConfig()
    {
        unset($this->persistence_config);
    }

    /**
     * Optional. Persistence config (RDB, AOF) for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.ClusterPersistenceConfig persistence_config = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Redis\Cluster\V1\ClusterPersistenceConfig $var
     * @return $this
     */
    public function setPersistenceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Redis\Cluster\V1\ClusterPersistenceConfig::class);
        $this->persistence_config = $var;

        return $this;
    }

    /**
     * Optional. Key/Value pairs of customer overrides for mutable Redis Configs
     *
     * Generated from protobuf field <code>map<string, string> redis_configs = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getRedisConfigs()
    {
        return $this->redis_configs;
    }

    /**
     * Optional. Key/Value pairs of customer overrides for mutable Redis Configs
     *
     * Generated from protobuf field <code>map<string, string> redis_configs = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setRedisConfigs($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->redis_configs = $arr;

        return $this;
    }

    /**
     * Output only. Precise value of redis memory size in GB for the entire
     * cluster.
     *
     * Generated from protobuf field <code>optional double precise_size_gb = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return float
     */
    public function getPreciseSizeGb()
    {
        return isset($this->precise_size_gb) ? $this->precise_size_gb : 0.0;
    }

    public function hasPreciseSizeGb()
    {
        return isset($this->precise_size_gb);
    }

    public function clearPreciseSizeGb()
    {
        unset($this->precise_size_gb);
    }

    /**
     * Output only. Precise value of redis memory size in GB for the entire
     * cluster.
     *
     * Generated from protobuf field <code>optional double precise_size_gb = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param float $var
     * @return $this
     */
    public function setPreciseSizeGb($var)
    {
        GPBUtil::checkDouble($var);
        $this->precise_size_gb = $var;

        return $this;
    }

    /**
     * Optional. This config will be used to determine how the customer wants us
     * to distribute cluster resources within the region.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.ZoneDistributionConfig zone_distribution_config = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Redis\Cluster\V1\ZoneDistributionConfig|null
     */
    public function getZoneDistributionConfig()
    {
        return $this->zone_distribution_config;
    }

    public function hasZoneDistributionConfig()
    {
        return isset($this->zone_distribution_config);
    }

    public function clearZoneDistributionConfig()
    {
        unset($this->zone_distribution_config);
    }

    /**
     * Optional. This config will be used to determine how the customer wants us
     * to distribute cluster resources within the region.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.ZoneDistributionConfig zone_distribution_config = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Redis\Cluster\V1\ZoneDistributionConfig $var
     * @return $this
     */
    public function setZoneDistributionConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Redis\Cluster\V1\ZoneDistributionConfig::class);
        $this->zone_distribution_config = $var;

        return $this;
    }

    /**
     * Optional. Cross cluster replication config.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.CrossClusterReplicationConfig cross_cluster_replication_config = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Redis\Cluster\V1\CrossClusterReplicationConfig|null
     */
    public function getCrossClusterReplicationConfig()
    {
        return $this->cross_cluster_replication_config;
    }

    public function hasCrossClusterReplicationConfig()
    {
        return isset($this->cross_cluster_replication_config);
    }

    public function clearCrossClusterReplicationConfig()
    {
        unset($this->cross_cluster_replication_config);
    }

    /**
     * Optional. Cross cluster replication config.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.CrossClusterReplicationConfig cross_cluster_replication_config = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Redis\Cluster\V1\CrossClusterReplicationConfig $var
     * @return $this
     */
    public function setCrossClusterReplicationConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Redis\Cluster\V1\CrossClusterReplicationConfig::class);
        $this->cross_cluster_replication_config = $var;

        return $this;
    }

    /**
     * Optional. The delete operation will fail when the value is set to true.
     *
     * Generated from protobuf field <code>optional bool deletion_protection_enabled = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getDeletionProtectionEnabled()
    {
        return isset($this->deletion_protection_enabled) ? $this->deletion_protection_enabled : false;
    }

    public function hasDeletionProtectionEnabled()
    {
        return isset($this->deletion_protection_enabled);
    }

    public function clearDeletionProtectionEnabled()
    {
        unset($this->deletion_protection_enabled);
    }

    /**
     * Optional. The delete operation will fail when the value is set to true.
     *
     * Generated from protobuf field <code>optional bool deletion_protection_enabled = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setDeletionProtectionEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->deletion_protection_enabled = $var;

        return $this;
    }

    /**
     * Optional. ClusterMaintenancePolicy determines when to allow or deny
     * updates.
     *
     * Generated from protobuf field <code>optional .google.cloud.redis.cluster.v1.ClusterMaintenancePolicy maintenance_policy = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Redis\Cluster\V1\ClusterMaintenancePolicy|null
     */
    public function getMaintenancePolicy()
    {
        return $this->maintenance_policy;
    }

    public function hasMaintenancePolicy()
    {
        return isset($this->maintenance_policy);
    }

    public function clearMaintenancePolicy()
    {
        unset($this->maintenance_policy);
    }

    /**
     * Optional. ClusterMaintenancePolicy determines when to allow or deny
     * updates.
     *
     * Generated from protobuf field <code>optional .google.cloud.redis.cluster.v1.ClusterMaintenancePolicy maintenance_policy = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Redis\Cluster\V1\ClusterMaintenancePolicy $var
     * @return $this
     */
    public function setMaintenancePolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Redis\Cluster\V1\ClusterMaintenancePolicy::class);
        $this->maintenance_policy = $var;

        return $this;
    }

    /**
     * Output only. ClusterMaintenanceSchedule Output only Published maintenance
     * schedule.
     *
     * Generated from protobuf field <code>optional .google.cloud.redis.cluster.v1.ClusterMaintenanceSchedule maintenance_schedule = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Redis\Cluster\V1\ClusterMaintenanceSchedule|null
     */
    public function getMaintenanceSchedule()
    {
        return $this->maintenance_schedule;
    }

    public function hasMaintenanceSchedule()
    {
        return isset($this->maintenance_schedule);
    }

    public function clearMaintenanceSchedule()
    {
        unset($this->maintenance_schedule);
    }

    /**
     * Output only. ClusterMaintenanceSchedule Output only Published maintenance
     * schedule.
     *
     * Generated from protobuf field <code>optional .google.cloud.redis.cluster.v1.ClusterMaintenanceSchedule maintenance_schedule = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Redis\Cluster\V1\ClusterMaintenanceSchedule $var
     * @return $this
     */
    public function setMaintenanceSchedule($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Redis\Cluster\V1\ClusterMaintenanceSchedule::class);
        $this->maintenance_schedule = $var;

        return $this;
    }

    /**
     * Output only. Service attachment details to configure Psc connections
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.PscServiceAttachment psc_service_attachments = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPscServiceAttachments()
    {
        return $this->psc_service_attachments;
    }

    /**
     * Output only. Service attachment details to configure Psc connections
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.PscServiceAttachment psc_service_attachments = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Redis\Cluster\V1\PscServiceAttachment>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPscServiceAttachments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Redis\Cluster\V1\PscServiceAttachment::class);
        $this->psc_service_attachments = $arr;

        return $this;
    }

    /**
     * Optional. A list of cluster enpoints.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.ClusterEndpoint cluster_endpoints = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getClusterEndpoints()
    {
        return $this->cluster_endpoints;
    }

    /**
     * Optional. A list of cluster enpoints.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.cluster.v1.ClusterEndpoint cluster_endpoints = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Redis\Cluster\V1\ClusterEndpoint>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setClusterEndpoints($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Redis\Cluster\V1\ClusterEndpoint::class);
        $this->cluster_endpoints = $arr;

        return $this;
    }

    /**
     * Optional. Output only. The backup collection full resource name. Example:
     * projects/{project}/locations/{location}/backupCollections/{collection}
     *
     * Generated from protobuf field <code>optional string backup_collection = 39 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getBackupCollection()
    {
        return isset($this->backup_collection) ? $this->backup_collection : '';
    }

    public function hasBackupCollection()
    {
        return isset($this->backup_collection);
    }

    public function clearBackupCollection()
    {
        unset($this->backup_collection);
    }

    /**
     * Optional. Output only. The backup collection full resource name. Example:
     * projects/{project}/locations/{location}/backupCollections/{collection}
     *
     * Generated from protobuf field <code>optional string backup_collection = 39 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setBackupCollection($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_collection = $var;

        return $this;
    }

    /**
     * Optional. The KMS key used to encrypt the at-rest data of the cluster.
     *
     * Generated from protobuf field <code>optional string kms_key = 40 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getKmsKey()
    {
        return isset($this->kms_key) ? $this->kms_key : '';
    }

    public function hasKmsKey()
    {
        return isset($this->kms_key);
    }

    public function clearKmsKey()
    {
        unset($this->kms_key);
    }

    /**
     * Optional. The KMS key used to encrypt the at-rest data of the cluster.
     *
     * Generated from protobuf field <code>optional string kms_key = 40 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key = $var;

        return $this;
    }

    /**
     * Optional. The automated backup config for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.AutomatedBackupConfig automated_backup_config = 42 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Redis\Cluster\V1\AutomatedBackupConfig|null
     */
    public function getAutomatedBackupConfig()
    {
        return $this->automated_backup_config;
    }

    public function hasAutomatedBackupConfig()
    {
        return isset($this->automated_backup_config);
    }

    public function clearAutomatedBackupConfig()
    {
        unset($this->automated_backup_config);
    }

    /**
     * Optional. The automated backup config for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.AutomatedBackupConfig automated_backup_config = 42 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Redis\Cluster\V1\AutomatedBackupConfig $var
     * @return $this
     */
    public function setAutomatedBackupConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Redis\Cluster\V1\AutomatedBackupConfig::class);
        $this->automated_backup_config = $var;

        return $this;
    }

    /**
     * Output only. Encryption information of the data at rest of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.EncryptionInfo encryption_info = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Redis\Cluster\V1\EncryptionInfo|null
     */
    public function getEncryptionInfo()
    {
        return $this->encryption_info;
    }

    public function hasEncryptionInfo()
    {
        return isset($this->encryption_info);
    }

    public function clearEncryptionInfo()
    {
        unset($this->encryption_info);
    }

    /**
     * Output only. Encryption information of the data at rest of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.EncryptionInfo encryption_info = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Redis\Cluster\V1\EncryptionInfo $var
     * @return $this
     */
    public function setEncryptionInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Redis\Cluster\V1\EncryptionInfo::class);
        $this->encryption_info = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getImportSources()
    {
        return $this->whichOneof("import_sources");
    }

}

