<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/osconfig/v1/os_policy_assignment_reports.proto

namespace Google\Cloud\OsConfig\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * List the OS policy assignment reports for VM instances.
 *
 * Generated from protobuf message <code>google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest</code>
 */
class ListOSPolicyAssignmentReportsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent resource name.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
     * For `{project}`, either `project-number` or `project-id` can be provided.
     * For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
     * provided. If '-' is provided, the response will include
     * OSPolicyAssignmentReports for all instances in the project/location.
     * For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
     * is provided, the response will include OSPolicyAssignmentReports for all
     * OSPolicyAssignments in the project/location.
     * Either {instance} or {assignment} must be `-`.
     * For example:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
     *  returns all reports for the instance
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
     *  returns all the reports for the given assignment across all instances.
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
     *  returns all the reports for all assignments across all instances.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * The maximum number of results to return.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     */
    protected $page_size = 0;
    /**
     * If provided, this field specifies the criteria that must be met by the
     * `OSPolicyAssignmentReport` API resource that is included in the response.
     *
     * Generated from protobuf field <code>string filter = 3;</code>
     */
    protected $filter = '';
    /**
     * A pagination token returned from a previous call to the
     * `ListOSPolicyAssignmentReports` method that indicates where this listing
     * should continue from.
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     */
    protected $page_token = '';

    /**
     * @param string $parent Required. The parent resource name.
     *
     *                       Format:
     *                       `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
     *
     *                       For `{project}`, either `project-number` or `project-id` can be provided.
     *                       For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
     *                       provided. If '-' is provided, the response will include
     *                       OSPolicyAssignmentReports for all instances in the project/location.
     *                       For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
     *                       is provided, the response will include OSPolicyAssignmentReports for all
     *                       OSPolicyAssignments in the project/location.
     *                       Either {instance} or {assignment} must be `-`.
     *
     *                       For example:
     *                       `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
     *                       returns all reports for the instance
     *                       `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
     *                       returns all the reports for the given assignment across all instances.
     *                       `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
     *                       returns all the reports for all assignments across all instances. Please see
     *                       {@see OsConfigZonalServiceClient::instanceOSPolicyAssignmentName()} for help formatting this field.
     *
     * @return \Google\Cloud\OsConfig\V1\ListOSPolicyAssignmentReportsRequest
     *
     * @experimental
     */
    public static function build(string $parent): self
    {
        return (new self())
            ->setParent($parent);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent resource name.
     *           Format:
     *           `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
     *           For `{project}`, either `project-number` or `project-id` can be provided.
     *           For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
     *           provided. If '-' is provided, the response will include
     *           OSPolicyAssignmentReports for all instances in the project/location.
     *           For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
     *           is provided, the response will include OSPolicyAssignmentReports for all
     *           OSPolicyAssignments in the project/location.
     *           Either {instance} or {assignment} must be `-`.
     *           For example:
     *           `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
     *            returns all reports for the instance
     *           `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
     *            returns all the reports for the given assignment across all instances.
     *           `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
     *            returns all the reports for all assignments across all instances.
     *     @type int $page_size
     *           The maximum number of results to return.
     *     @type string $filter
     *           If provided, this field specifies the criteria that must be met by the
     *           `OSPolicyAssignmentReport` API resource that is included in the response.
     *     @type string $page_token
     *           A pagination token returned from a previous call to the
     *           `ListOSPolicyAssignmentReports` method that indicates where this listing
     *           should continue from.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Osconfig\V1\OsPolicyAssignmentReports::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent resource name.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
     * For `{project}`, either `project-number` or `project-id` can be provided.
     * For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
     * provided. If '-' is provided, the response will include
     * OSPolicyAssignmentReports for all instances in the project/location.
     * For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
     * is provided, the response will include OSPolicyAssignmentReports for all
     * OSPolicyAssignments in the project/location.
     * Either {instance} or {assignment} must be `-`.
     * For example:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
     *  returns all reports for the instance
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
     *  returns all the reports for the given assignment across all instances.
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
     *  returns all the reports for all assignments across all instances.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource name.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
     * For `{project}`, either `project-number` or `project-id` can be provided.
     * For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
     * provided. If '-' is provided, the response will include
     * OSPolicyAssignmentReports for all instances in the project/location.
     * For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
     * is provided, the response will include OSPolicyAssignmentReports for all
     * OSPolicyAssignments in the project/location.
     * Either {instance} or {assignment} must be `-`.
     * For example:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
     *  returns all reports for the instance
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
     *  returns all the reports for the given assignment across all instances.
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
     *  returns all the reports for all assignments across all instances.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * The maximum number of results to return.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * The maximum number of results to return.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * If provided, this field specifies the criteria that must be met by the
     * `OSPolicyAssignmentReport` API resource that is included in the response.
     *
     * Generated from protobuf field <code>string filter = 3;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * If provided, this field specifies the criteria that must be met by the
     * `OSPolicyAssignmentReport` API resource that is included in the response.
     *
     * Generated from protobuf field <code>string filter = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * A pagination token returned from a previous call to the
     * `ListOSPolicyAssignmentReports` method that indicates where this listing
     * should continue from.
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * A pagination token returned from a previous call to the
     * `ListOSPolicyAssignmentReports` method that indicates where this listing
     * should continue from.
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

}

