<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/oracledatabase/v1/autonomous_db_backup.proto

namespace Google\Cloud\OracleDatabase\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Properties of the Autonomous Database Backup resource.
 *
 * Generated from protobuf message <code>google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties</code>
 */
class AutonomousDatabaseBackupProperties extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. OCID of the Autonomous Database backup.
     * https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
     *
     * Generated from protobuf field <code>string ocid = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $ocid = '';
    /**
     * Optional. Retention period in days for the backup.
     *
     * Generated from protobuf field <code>int32 retention_period_days = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $retention_period_days = 0;
    /**
     * Output only. The OCID of the compartment.
     *
     * Generated from protobuf field <code>string compartment_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $compartment_id = '';
    /**
     * Output only. The quantity of data in the database, in terabytes.
     *
     * Generated from protobuf field <code>float database_size_tb = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $database_size_tb = 0.0;
    /**
     * Output only. A valid Oracle Database version for Autonomous Database.
     *
     * Generated from protobuf field <code>string db_version = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $db_version = '';
    /**
     * Output only. Indicates if the backup is long term backup.
     *
     * Generated from protobuf field <code>bool is_long_term_backup = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $is_long_term_backup = false;
    /**
     * Output only. Indicates if the backup is automatic or user initiated.
     *
     * Generated from protobuf field <code>bool is_automatic_backup = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $is_automatic_backup = false;
    /**
     * Output only. Indicates if the backup can be used to restore the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>bool is_restorable = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $is_restorable = false;
    /**
     * Optional. The OCID of the key store of Oracle Vault.
     *
     * Generated from protobuf field <code>string key_store_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $key_store_id = '';
    /**
     * Optional. The wallet name for Oracle Key Vault.
     *
     * Generated from protobuf field <code>string key_store_wallet = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $key_store_wallet = '';
    /**
     * Optional. The OCID of the key container that is used as the master
     * encryption key in database transparent data encryption (TDE) operations.
     *
     * Generated from protobuf field <code>string kms_key_id = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $kms_key_id = '';
    /**
     * Optional. The OCID of the key container version that is used in database
     * transparent data encryption (TDE) operations KMS Key can have multiple key
     * versions. If none is specified, the current key version (latest) of the Key
     * Id is used for the operation. Autonomous Database Serverless does not use
     * key versions, hence is not applicable for Autonomous Database Serverless
     * instances.
     *
     * Generated from protobuf field <code>string kms_key_version_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $kms_key_version_id = '';
    /**
     * Output only. Additional information about the current lifecycle state.
     *
     * Generated from protobuf field <code>string lifecycle_details = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $lifecycle_details = '';
    /**
     * Output only. The lifecycle state of the backup.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.State lifecycle_state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $lifecycle_state = 0;
    /**
     * Output only. The backup size in terabytes.
     *
     * Generated from protobuf field <code>float size_tb = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $size_tb = 0.0;
    /**
     * Output only. Timestamp until when the backup will be available.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp available_till_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $available_till_time = null;
    /**
     * Output only. The date and time the backup completed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $end_time = null;
    /**
     * Output only. The date and time the backup started.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $start_time = null;
    /**
     * Output only. The type of the backup.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.Type type = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $type = 0;
    /**
     * Optional. The OCID of the vault.
     *
     * Generated from protobuf field <code>string vault_id = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $vault_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $ocid
     *           Output only. OCID of the Autonomous Database backup.
     *           https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
     *     @type int $retention_period_days
     *           Optional. Retention period in days for the backup.
     *     @type string $compartment_id
     *           Output only. The OCID of the compartment.
     *     @type float $database_size_tb
     *           Output only. The quantity of data in the database, in terabytes.
     *     @type string $db_version
     *           Output only. A valid Oracle Database version for Autonomous Database.
     *     @type bool $is_long_term_backup
     *           Output only. Indicates if the backup is long term backup.
     *     @type bool $is_automatic_backup
     *           Output only. Indicates if the backup is automatic or user initiated.
     *     @type bool $is_restorable
     *           Output only. Indicates if the backup can be used to restore the Autonomous
     *           Database.
     *     @type string $key_store_id
     *           Optional. The OCID of the key store of Oracle Vault.
     *     @type string $key_store_wallet
     *           Optional. The wallet name for Oracle Key Vault.
     *     @type string $kms_key_id
     *           Optional. The OCID of the key container that is used as the master
     *           encryption key in database transparent data encryption (TDE) operations.
     *     @type string $kms_key_version_id
     *           Optional. The OCID of the key container version that is used in database
     *           transparent data encryption (TDE) operations KMS Key can have multiple key
     *           versions. If none is specified, the current key version (latest) of the Key
     *           Id is used for the operation. Autonomous Database Serverless does not use
     *           key versions, hence is not applicable for Autonomous Database Serverless
     *           instances.
     *     @type string $lifecycle_details
     *           Output only. Additional information about the current lifecycle state.
     *     @type int $lifecycle_state
     *           Output only. The lifecycle state of the backup.
     *     @type float $size_tb
     *           Output only. The backup size in terabytes.
     *     @type \Google\Protobuf\Timestamp $available_till_time
     *           Output only. Timestamp until when the backup will be available.
     *     @type \Google\Protobuf\Timestamp $end_time
     *           Output only. The date and time the backup completed.
     *     @type \Google\Protobuf\Timestamp $start_time
     *           Output only. The date and time the backup started.
     *     @type int $type
     *           Output only. The type of the backup.
     *     @type string $vault_id
     *           Optional. The OCID of the vault.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Oracledatabase\V1\AutonomousDbBackup::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. OCID of the Autonomous Database backup.
     * https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
     *
     * Generated from protobuf field <code>string ocid = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getOcid()
    {
        return $this->ocid;
    }

    /**
     * Output only. OCID of the Autonomous Database backup.
     * https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
     *
     * Generated from protobuf field <code>string ocid = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setOcid($var)
    {
        GPBUtil::checkString($var, True);
        $this->ocid = $var;

        return $this;
    }

    /**
     * Optional. Retention period in days for the backup.
     *
     * Generated from protobuf field <code>int32 retention_period_days = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getRetentionPeriodDays()
    {
        return $this->retention_period_days;
    }

    /**
     * Optional. Retention period in days for the backup.
     *
     * Generated from protobuf field <code>int32 retention_period_days = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setRetentionPeriodDays($var)
    {
        GPBUtil::checkInt32($var);
        $this->retention_period_days = $var;

        return $this;
    }

    /**
     * Output only. The OCID of the compartment.
     *
     * Generated from protobuf field <code>string compartment_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCompartmentId()
    {
        return $this->compartment_id;
    }

    /**
     * Output only. The OCID of the compartment.
     *
     * Generated from protobuf field <code>string compartment_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCompartmentId($var)
    {
        GPBUtil::checkString($var, True);
        $this->compartment_id = $var;

        return $this;
    }

    /**
     * Output only. The quantity of data in the database, in terabytes.
     *
     * Generated from protobuf field <code>float database_size_tb = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return float
     */
    public function getDatabaseSizeTb()
    {
        return $this->database_size_tb;
    }

    /**
     * Output only. The quantity of data in the database, in terabytes.
     *
     * Generated from protobuf field <code>float database_size_tb = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param float $var
     * @return $this
     */
    public function setDatabaseSizeTb($var)
    {
        GPBUtil::checkFloat($var);
        $this->database_size_tb = $var;

        return $this;
    }

    /**
     * Output only. A valid Oracle Database version for Autonomous Database.
     *
     * Generated from protobuf field <code>string db_version = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDbVersion()
    {
        return $this->db_version;
    }

    /**
     * Output only. A valid Oracle Database version for Autonomous Database.
     *
     * Generated from protobuf field <code>string db_version = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDbVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->db_version = $var;

        return $this;
    }

    /**
     * Output only. Indicates if the backup is long term backup.
     *
     * Generated from protobuf field <code>bool is_long_term_backup = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getIsLongTermBackup()
    {
        return $this->is_long_term_backup;
    }

    /**
     * Output only. Indicates if the backup is long term backup.
     *
     * Generated from protobuf field <code>bool is_long_term_backup = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setIsLongTermBackup($var)
    {
        GPBUtil::checkBool($var);
        $this->is_long_term_backup = $var;

        return $this;
    }

    /**
     * Output only. Indicates if the backup is automatic or user initiated.
     *
     * Generated from protobuf field <code>bool is_automatic_backup = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getIsAutomaticBackup()
    {
        return $this->is_automatic_backup;
    }

    /**
     * Output only. Indicates if the backup is automatic or user initiated.
     *
     * Generated from protobuf field <code>bool is_automatic_backup = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setIsAutomaticBackup($var)
    {
        GPBUtil::checkBool($var);
        $this->is_automatic_backup = $var;

        return $this;
    }

    /**
     * Output only. Indicates if the backup can be used to restore the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>bool is_restorable = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getIsRestorable()
    {
        return $this->is_restorable;
    }

    /**
     * Output only. Indicates if the backup can be used to restore the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>bool is_restorable = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setIsRestorable($var)
    {
        GPBUtil::checkBool($var);
        $this->is_restorable = $var;

        return $this;
    }

    /**
     * Optional. The OCID of the key store of Oracle Vault.
     *
     * Generated from protobuf field <code>string key_store_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getKeyStoreId()
    {
        return $this->key_store_id;
    }

    /**
     * Optional. The OCID of the key store of Oracle Vault.
     *
     * Generated from protobuf field <code>string key_store_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setKeyStoreId($var)
    {
        GPBUtil::checkString($var, True);
        $this->key_store_id = $var;

        return $this;
    }

    /**
     * Optional. The wallet name for Oracle Key Vault.
     *
     * Generated from protobuf field <code>string key_store_wallet = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getKeyStoreWallet()
    {
        return $this->key_store_wallet;
    }

    /**
     * Optional. The wallet name for Oracle Key Vault.
     *
     * Generated from protobuf field <code>string key_store_wallet = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setKeyStoreWallet($var)
    {
        GPBUtil::checkString($var, True);
        $this->key_store_wallet = $var;

        return $this;
    }

    /**
     * Optional. The OCID of the key container that is used as the master
     * encryption key in database transparent data encryption (TDE) operations.
     *
     * Generated from protobuf field <code>string kms_key_id = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getKmsKeyId()
    {
        return $this->kms_key_id;
    }

    /**
     * Optional. The OCID of the key container that is used as the master
     * encryption key in database transparent data encryption (TDE) operations.
     *
     * Generated from protobuf field <code>string kms_key_id = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyId($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_id = $var;

        return $this;
    }

    /**
     * Optional. The OCID of the key container version that is used in database
     * transparent data encryption (TDE) operations KMS Key can have multiple key
     * versions. If none is specified, the current key version (latest) of the Key
     * Id is used for the operation. Autonomous Database Serverless does not use
     * key versions, hence is not applicable for Autonomous Database Serverless
     * instances.
     *
     * Generated from protobuf field <code>string kms_key_version_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getKmsKeyVersionId()
    {
        return $this->kms_key_version_id;
    }

    /**
     * Optional. The OCID of the key container version that is used in database
     * transparent data encryption (TDE) operations KMS Key can have multiple key
     * versions. If none is specified, the current key version (latest) of the Key
     * Id is used for the operation. Autonomous Database Serverless does not use
     * key versions, hence is not applicable for Autonomous Database Serverless
     * instances.
     *
     * Generated from protobuf field <code>string kms_key_version_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyVersionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_version_id = $var;

        return $this;
    }

    /**
     * Output only. Additional information about the current lifecycle state.
     *
     * Generated from protobuf field <code>string lifecycle_details = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLifecycleDetails()
    {
        return $this->lifecycle_details;
    }

    /**
     * Output only. Additional information about the current lifecycle state.
     *
     * Generated from protobuf field <code>string lifecycle_details = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLifecycleDetails($var)
    {
        GPBUtil::checkString($var, True);
        $this->lifecycle_details = $var;

        return $this;
    }

    /**
     * Output only. The lifecycle state of the backup.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.State lifecycle_state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getLifecycleState()
    {
        return $this->lifecycle_state;
    }

    /**
     * Output only. The lifecycle state of the backup.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.State lifecycle_state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setLifecycleState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseBackupProperties\State::class);
        $this->lifecycle_state = $var;

        return $this;
    }

    /**
     * Output only. The backup size in terabytes.
     *
     * Generated from protobuf field <code>float size_tb = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return float
     */
    public function getSizeTb()
    {
        return $this->size_tb;
    }

    /**
     * Output only. The backup size in terabytes.
     *
     * Generated from protobuf field <code>float size_tb = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param float $var
     * @return $this
     */
    public function setSizeTb($var)
    {
        GPBUtil::checkFloat($var);
        $this->size_tb = $var;

        return $this;
    }

    /**
     * Output only. Timestamp until when the backup will be available.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp available_till_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getAvailableTillTime()
    {
        return $this->available_till_time;
    }

    public function hasAvailableTillTime()
    {
        return isset($this->available_till_time);
    }

    public function clearAvailableTillTime()
    {
        unset($this->available_till_time);
    }

    /**
     * Output only. Timestamp until when the backup will be available.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp available_till_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setAvailableTillTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->available_till_time = $var;

        return $this;
    }

    /**
     * Output only. The date and time the backup completed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    public function hasEndTime()
    {
        return isset($this->end_time);
    }

    public function clearEndTime()
    {
        unset($this->end_time);
    }

    /**
     * Output only. The date and time the backup completed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_time = $var;

        return $this;
    }

    /**
     * Output only. The date and time the backup started.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    public function hasStartTime()
    {
        return isset($this->start_time);
    }

    public function clearStartTime()
    {
        unset($this->start_time);
    }

    /**
     * Output only. The date and time the backup started.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * Output only. The type of the backup.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.Type type = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Output only. The type of the backup.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.Type type = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseBackupProperties\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Optional. The OCID of the vault.
     *
     * Generated from protobuf field <code>string vault_id = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getVaultId()
    {
        return $this->vault_id;
    }

    /**
     * Optional. The OCID of the vault.
     *
     * Generated from protobuf field <code>string vault_id = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setVaultId($var)
    {
        GPBUtil::checkString($var, True);
        $this->vault_id = $var;

        return $this;
    }

}

