<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/maps/routeoptimization/v1/route_optimization_service.proto

namespace Google\Maps\RouteOptimization\V1\Vehicle;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A limit defining a maximum duration of the route of a vehicle. It can be
 * either hard or soft.
 * When a soft limit field is defined, both the soft max threshold and its
 * associated cost must be defined together.
 *
 * Generated from protobuf message <code>google.maps.routeoptimization.v1.Vehicle.DurationLimit</code>
 */
class DurationLimit extends \Google\Protobuf\Internal\Message
{
    /**
     * A hard limit constraining the duration to be at most max_duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_duration = 1;</code>
     */
    protected $max_duration = null;
    /**
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost. This cost adds up to other costs defined in
     * the model, with the same unit.
     * If defined, `soft_max_duration` must be nonnegative. If max_duration is
     * also defined, `soft_max_duration` must be less than max_duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration soft_max_duration = 2;</code>
     */
    protected $soft_max_duration = null;
    /**
     * Cost per hour incurred if the `soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_hour_after_soft_max * (duration - soft_max_duration)
     * ```
     * The cost must be nonnegative.
     *
     * Generated from protobuf field <code>optional double cost_per_hour_after_soft_max = 3;</code>
     */
    protected $cost_per_hour_after_soft_max = null;
    /**
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost, quadratic in the duration. This cost adds
     * up to other costs defined in the model, with the same unit.
     * If defined, `quadratic_soft_max_duration` must be nonnegative. If
     * `max_duration` is also defined, `quadratic_soft_max_duration` must be
     * less than `max_duration`, and the difference must be no larger than one
     * day:
     *    `max_duration - quadratic_soft_max_duration <= 86400 seconds`
     *
     * Generated from protobuf field <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
     */
    protected $quadratic_soft_max_duration = null;
    /**
     * Cost per square hour incurred if the
     * `quadratic_soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_square_hour_after_quadratic_soft_max *
     *   (duration - quadratic_soft_max_duration)^2
     * ```
     * The cost must be nonnegative.
     *
     * Generated from protobuf field <code>optional double cost_per_square_hour_after_quadratic_soft_max = 5;</code>
     */
    protected $cost_per_square_hour_after_quadratic_soft_max = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Protobuf\Duration $max_duration
     *           A hard limit constraining the duration to be at most max_duration.
     *     @type \Google\Protobuf\Duration $soft_max_duration
     *           A soft limit not enforcing a maximum duration limit, but when violated
     *           makes the route incur a cost. This cost adds up to other costs defined in
     *           the model, with the same unit.
     *           If defined, `soft_max_duration` must be nonnegative. If max_duration is
     *           also defined, `soft_max_duration` must be less than max_duration.
     *     @type float $cost_per_hour_after_soft_max
     *           Cost per hour incurred if the `soft_max_duration` threshold is violated.
     *           The additional cost is 0 if the duration is under the threshold,
     *           otherwise the cost depends on the duration as follows:
     *           ```
     *             cost_per_hour_after_soft_max * (duration - soft_max_duration)
     *           ```
     *           The cost must be nonnegative.
     *     @type \Google\Protobuf\Duration $quadratic_soft_max_duration
     *           A soft limit not enforcing a maximum duration limit, but when violated
     *           makes the route incur a cost, quadratic in the duration. This cost adds
     *           up to other costs defined in the model, with the same unit.
     *           If defined, `quadratic_soft_max_duration` must be nonnegative. If
     *           `max_duration` is also defined, `quadratic_soft_max_duration` must be
     *           less than `max_duration`, and the difference must be no larger than one
     *           day:
     *              `max_duration - quadratic_soft_max_duration <= 86400 seconds`
     *     @type float $cost_per_square_hour_after_quadratic_soft_max
     *           Cost per square hour incurred if the
     *           `quadratic_soft_max_duration` threshold is violated.
     *           The additional cost is 0 if the duration is under the threshold,
     *           otherwise the cost depends on the duration as follows:
     *           ```
     *             cost_per_square_hour_after_quadratic_soft_max *
     *             (duration - quadratic_soft_max_duration)^2
     *           ```
     *           The cost must be nonnegative.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Maps\Routeoptimization\V1\RouteOptimizationService::initOnce();
        parent::__construct($data);
    }

    /**
     * A hard limit constraining the duration to be at most max_duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_duration = 1;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getMaxDuration()
    {
        return $this->max_duration;
    }

    public function hasMaxDuration()
    {
        return isset($this->max_duration);
    }

    public function clearMaxDuration()
    {
        unset($this->max_duration);
    }

    /**
     * A hard limit constraining the duration to be at most max_duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_duration = 1;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setMaxDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->max_duration = $var;

        return $this;
    }

    /**
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost. This cost adds up to other costs defined in
     * the model, with the same unit.
     * If defined, `soft_max_duration` must be nonnegative. If max_duration is
     * also defined, `soft_max_duration` must be less than max_duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration soft_max_duration = 2;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getSoftMaxDuration()
    {
        return $this->soft_max_duration;
    }

    public function hasSoftMaxDuration()
    {
        return isset($this->soft_max_duration);
    }

    public function clearSoftMaxDuration()
    {
        unset($this->soft_max_duration);
    }

    /**
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost. This cost adds up to other costs defined in
     * the model, with the same unit.
     * If defined, `soft_max_duration` must be nonnegative. If max_duration is
     * also defined, `soft_max_duration` must be less than max_duration.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration soft_max_duration = 2;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setSoftMaxDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->soft_max_duration = $var;

        return $this;
    }

    /**
     * Cost per hour incurred if the `soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_hour_after_soft_max * (duration - soft_max_duration)
     * ```
     * The cost must be nonnegative.
     *
     * Generated from protobuf field <code>optional double cost_per_hour_after_soft_max = 3;</code>
     * @return float
     */
    public function getCostPerHourAfterSoftMax()
    {
        return isset($this->cost_per_hour_after_soft_max) ? $this->cost_per_hour_after_soft_max : 0.0;
    }

    public function hasCostPerHourAfterSoftMax()
    {
        return isset($this->cost_per_hour_after_soft_max);
    }

    public function clearCostPerHourAfterSoftMax()
    {
        unset($this->cost_per_hour_after_soft_max);
    }

    /**
     * Cost per hour incurred if the `soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_hour_after_soft_max * (duration - soft_max_duration)
     * ```
     * The cost must be nonnegative.
     *
     * Generated from protobuf field <code>optional double cost_per_hour_after_soft_max = 3;</code>
     * @param float $var
     * @return $this
     */
    public function setCostPerHourAfterSoftMax($var)
    {
        GPBUtil::checkDouble($var);
        $this->cost_per_hour_after_soft_max = $var;

        return $this;
    }

    /**
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost, quadratic in the duration. This cost adds
     * up to other costs defined in the model, with the same unit.
     * If defined, `quadratic_soft_max_duration` must be nonnegative. If
     * `max_duration` is also defined, `quadratic_soft_max_duration` must be
     * less than `max_duration`, and the difference must be no larger than one
     * day:
     *    `max_duration - quadratic_soft_max_duration <= 86400 seconds`
     *
     * Generated from protobuf field <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getQuadraticSoftMaxDuration()
    {
        return $this->quadratic_soft_max_duration;
    }

    public function hasQuadraticSoftMaxDuration()
    {
        return isset($this->quadratic_soft_max_duration);
    }

    public function clearQuadraticSoftMaxDuration()
    {
        unset($this->quadratic_soft_max_duration);
    }

    /**
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost, quadratic in the duration. This cost adds
     * up to other costs defined in the model, with the same unit.
     * If defined, `quadratic_soft_max_duration` must be nonnegative. If
     * `max_duration` is also defined, `quadratic_soft_max_duration` must be
     * less than `max_duration`, and the difference must be no larger than one
     * day:
     *    `max_duration - quadratic_soft_max_duration <= 86400 seconds`
     *
     * Generated from protobuf field <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setQuadraticSoftMaxDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->quadratic_soft_max_duration = $var;

        return $this;
    }

    /**
     * Cost per square hour incurred if the
     * `quadratic_soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_square_hour_after_quadratic_soft_max *
     *   (duration - quadratic_soft_max_duration)^2
     * ```
     * The cost must be nonnegative.
     *
     * Generated from protobuf field <code>optional double cost_per_square_hour_after_quadratic_soft_max = 5;</code>
     * @return float
     */
    public function getCostPerSquareHourAfterQuadraticSoftMax()
    {
        return isset($this->cost_per_square_hour_after_quadratic_soft_max) ? $this->cost_per_square_hour_after_quadratic_soft_max : 0.0;
    }

    public function hasCostPerSquareHourAfterQuadraticSoftMax()
    {
        return isset($this->cost_per_square_hour_after_quadratic_soft_max);
    }

    public function clearCostPerSquareHourAfterQuadraticSoftMax()
    {
        unset($this->cost_per_square_hour_after_quadratic_soft_max);
    }

    /**
     * Cost per square hour incurred if the
     * `quadratic_soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_square_hour_after_quadratic_soft_max *
     *   (duration - quadratic_soft_max_duration)^2
     * ```
     * The cost must be nonnegative.
     *
     * Generated from protobuf field <code>optional double cost_per_square_hour_after_quadratic_soft_max = 5;</code>
     * @param float $var
     * @return $this
     */
    public function setCostPerSquareHourAfterQuadraticSoftMax($var)
    {
        GPBUtil::checkDouble($var);
        $this->cost_per_square_hour_after_quadratic_soft_max = $var;

        return $this;
    }

}


