<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/iap/v1/service.proto

namespace Google\Cloud\Iap\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Allows customers to configure tenant IDs for a Cloud Identity Platform (GCIP)
 * instance for each application.
 *
 * Generated from protobuf message <code>google.cloud.iap.v1.GcipSettings</code>
 */
class GcipSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. GCIP tenant IDs that are linked to the IAP resource. `tenant_ids`
     * could be a string beginning with a number character to indicate
     * authenticating with GCIP tenant flow, or in the format of
     * `_<ProjectNumber>` to indicate authenticating with GCIP agent flow. If
     * agent flow is used, `tenant_ids` should only contain one single element,
     * while for tenant flow, `tenant_ids` can contain multiple elements.
     *
     * Generated from protobuf field <code>repeated string tenant_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $tenant_ids;
    /**
     * Login page URI associated with the GCIP tenants.
     * Typically, all resources within the same project share the same login page,
     * though it could be overridden at the sub resource level.
     *
     * Generated from protobuf field <code>.google.protobuf.StringValue login_page_uri = 2;</code>
     */
    protected $login_page_uri = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $tenant_ids
     *           Optional. GCIP tenant IDs that are linked to the IAP resource. `tenant_ids`
     *           could be a string beginning with a number character to indicate
     *           authenticating with GCIP tenant flow, or in the format of
     *           `_<ProjectNumber>` to indicate authenticating with GCIP agent flow. If
     *           agent flow is used, `tenant_ids` should only contain one single element,
     *           while for tenant flow, `tenant_ids` can contain multiple elements.
     *     @type \Google\Protobuf\StringValue $login_page_uri
     *           Login page URI associated with the GCIP tenants.
     *           Typically, all resources within the same project share the same login page,
     *           though it could be overridden at the sub resource level.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Iap\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. GCIP tenant IDs that are linked to the IAP resource. `tenant_ids`
     * could be a string beginning with a number character to indicate
     * authenticating with GCIP tenant flow, or in the format of
     * `_<ProjectNumber>` to indicate authenticating with GCIP agent flow. If
     * agent flow is used, `tenant_ids` should only contain one single element,
     * while for tenant flow, `tenant_ids` can contain multiple elements.
     *
     * Generated from protobuf field <code>repeated string tenant_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTenantIds()
    {
        return $this->tenant_ids;
    }

    /**
     * Optional. GCIP tenant IDs that are linked to the IAP resource. `tenant_ids`
     * could be a string beginning with a number character to indicate
     * authenticating with GCIP tenant flow, or in the format of
     * `_<ProjectNumber>` to indicate authenticating with GCIP agent flow. If
     * agent flow is used, `tenant_ids` should only contain one single element,
     * while for tenant flow, `tenant_ids` can contain multiple elements.
     *
     * Generated from protobuf field <code>repeated string tenant_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTenantIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->tenant_ids = $arr;

        return $this;
    }

    /**
     * Login page URI associated with the GCIP tenants.
     * Typically, all resources within the same project share the same login page,
     * though it could be overridden at the sub resource level.
     *
     * Generated from protobuf field <code>.google.protobuf.StringValue login_page_uri = 2;</code>
     * @return \Google\Protobuf\StringValue|null
     */
    public function getLoginPageUri()
    {
        return $this->login_page_uri;
    }

    public function hasLoginPageUri()
    {
        return isset($this->login_page_uri);
    }

    public function clearLoginPageUri()
    {
        unset($this->login_page_uri);
    }

    /**
     * Returns the unboxed value from <code>getLoginPageUri()</code>

     * Login page URI associated with the GCIP tenants.
     * Typically, all resources within the same project share the same login page,
     * though it could be overridden at the sub resource level.
     *
     * Generated from protobuf field <code>.google.protobuf.StringValue login_page_uri = 2;</code>
     * @return string|null
     */
    public function getLoginPageUriUnwrapped()
    {
        return $this->readWrapperValue("login_page_uri");
    }

    /**
     * Login page URI associated with the GCIP tenants.
     * Typically, all resources within the same project share the same login page,
     * though it could be overridden at the sub resource level.
     *
     * Generated from protobuf field <code>.google.protobuf.StringValue login_page_uri = 2;</code>
     * @param \Google\Protobuf\StringValue $var
     * @return $this
     */
    public function setLoginPageUri($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\StringValue::class);
        $this->login_page_uri = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\StringValue object.

     * Login page URI associated with the GCIP tenants.
     * Typically, all resources within the same project share the same login page,
     * though it could be overridden at the sub resource level.
     *
     * Generated from protobuf field <code>.google.protobuf.StringValue login_page_uri = 2;</code>
     * @param string|null $var
     * @return $this
     */
    public function setLoginPageUriUnwrapped($var)
    {
        $this->writeWrapperValue("login_page_uri", $var);
        return $this;}

}

