<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/iam/v3/policy_bindings_service.proto

namespace Google\Cloud\Iam\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for SearchTargetPolicyBindings method.
 *
 * Generated from protobuf message <code>google.iam.v3.SearchTargetPolicyBindingsRequest</code>
 */
class SearchTargetPolicyBindingsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The target resource, which is bound to the policy in the binding.
     * Format:
     * * `//iam.googleapis.com/locations/global/workforcePools/POOL_ID`
     * * `//iam.googleapis.com/projects/PROJECT_NUMBER/locations/global/workloadIdentityPools/POOL_ID`
     * * `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
     * * `//cloudresourcemanager.googleapis.com/projects/{project_number}`
     * * `//cloudresourcemanager.googleapis.com/folders/{folder_id}`
     * * `//cloudresourcemanager.googleapis.com/organizations/{organization_id}`
     *
     * Generated from protobuf field <code>string target = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $target = '';
    /**
     * Optional. The maximum number of policy bindings to return. The service may
     * return fewer than this value.
     * If unspecified, at most 50 policy bindings will be returned.
     * The maximum value is 1000; values above 1000 will be coerced to 1000.
     *
     * Generated from protobuf field <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_size = 0;
    /**
     * Optional. A page token, received from a previous
     * `SearchTargetPolicyBindingsRequest` call. Provide this to retrieve the
     * subsequent page.
     * When paginating, all other parameters provided to
     * `SearchTargetPolicyBindingsRequest` must match the call that provided the
     * page token.
     *
     * Generated from protobuf field <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_token = '';
    /**
     * Required. The parent resource where this search will be performed. This
     * should be the nearest Resource Manager resource (project, folder, or
     * organization) to the target.
     * Format:
     * * `projects/{project_id}/locations/{location}`
     * * `projects/{project_number}/locations/{location}`
     * * `folders/{folder_id}/locations/{location}`
     * * `organizations/{organization_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';

    /**
     * @param string $parent Required. The parent resource where this search will be performed. This
     *                       should be the nearest Resource Manager resource (project, folder, or
     *                       organization) to the target.
     *
     *                       Format:
     *
     *                       * `projects/{project_id}/locations/{location}`
     *                       * `projects/{project_number}/locations/{location}`
     *                       * `folders/{folder_id}/locations/{location}`
     *                       * `organizations/{organization_id}/locations/{location}`
     *                       Please see {@see PolicyBindingsClient::organizationLocationName()} for help formatting this field.
     * @param string $target Required. The target resource, which is bound to the policy in the binding.
     *
     *                       Format:
     *
     *                       * `//iam.googleapis.com/locations/global/workforcePools/POOL_ID`
     *                       * `//iam.googleapis.com/projects/PROJECT_NUMBER/locations/global/workloadIdentityPools/POOL_ID`
     *                       * `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
     *                       * `//cloudresourcemanager.googleapis.com/projects/{project_number}`
     *                       * `//cloudresourcemanager.googleapis.com/folders/{folder_id}`
     *                       * `//cloudresourcemanager.googleapis.com/organizations/{organization_id}`
     *
     * @return \Google\Cloud\Iam\V3\SearchTargetPolicyBindingsRequest
     *
     * @experimental
     */
    public static function build(string $parent, string $target): self
    {
        return (new self())
            ->setParent($parent)
            ->setTarget($target);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $target
     *           Required. The target resource, which is bound to the policy in the binding.
     *           Format:
     *           * `//iam.googleapis.com/locations/global/workforcePools/POOL_ID`
     *           * `//iam.googleapis.com/projects/PROJECT_NUMBER/locations/global/workloadIdentityPools/POOL_ID`
     *           * `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
     *           * `//cloudresourcemanager.googleapis.com/projects/{project_number}`
     *           * `//cloudresourcemanager.googleapis.com/folders/{folder_id}`
     *           * `//cloudresourcemanager.googleapis.com/organizations/{organization_id}`
     *     @type int $page_size
     *           Optional. The maximum number of policy bindings to return. The service may
     *           return fewer than this value.
     *           If unspecified, at most 50 policy bindings will be returned.
     *           The maximum value is 1000; values above 1000 will be coerced to 1000.
     *     @type string $page_token
     *           Optional. A page token, received from a previous
     *           `SearchTargetPolicyBindingsRequest` call. Provide this to retrieve the
     *           subsequent page.
     *           When paginating, all other parameters provided to
     *           `SearchTargetPolicyBindingsRequest` must match the call that provided the
     *           page token.
     *     @type string $parent
     *           Required. The parent resource where this search will be performed. This
     *           should be the nearest Resource Manager resource (project, folder, or
     *           organization) to the target.
     *           Format:
     *           * `projects/{project_id}/locations/{location}`
     *           * `projects/{project_number}/locations/{location}`
     *           * `folders/{folder_id}/locations/{location}`
     *           * `organizations/{organization_id}/locations/{location}`
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Iam\V3\PolicyBindingsService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The target resource, which is bound to the policy in the binding.
     * Format:
     * * `//iam.googleapis.com/locations/global/workforcePools/POOL_ID`
     * * `//iam.googleapis.com/projects/PROJECT_NUMBER/locations/global/workloadIdentityPools/POOL_ID`
     * * `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
     * * `//cloudresourcemanager.googleapis.com/projects/{project_number}`
     * * `//cloudresourcemanager.googleapis.com/folders/{folder_id}`
     * * `//cloudresourcemanager.googleapis.com/organizations/{organization_id}`
     *
     * Generated from protobuf field <code>string target = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTarget()
    {
        return $this->target;
    }

    /**
     * Required. The target resource, which is bound to the policy in the binding.
     * Format:
     * * `//iam.googleapis.com/locations/global/workforcePools/POOL_ID`
     * * `//iam.googleapis.com/projects/PROJECT_NUMBER/locations/global/workloadIdentityPools/POOL_ID`
     * * `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
     * * `//cloudresourcemanager.googleapis.com/projects/{project_number}`
     * * `//cloudresourcemanager.googleapis.com/folders/{folder_id}`
     * * `//cloudresourcemanager.googleapis.com/organizations/{organization_id}`
     *
     * Generated from protobuf field <code>string target = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTarget($var)
    {
        GPBUtil::checkString($var, True);
        $this->target = $var;

        return $this;
    }

    /**
     * Optional. The maximum number of policy bindings to return. The service may
     * return fewer than this value.
     * If unspecified, at most 50 policy bindings will be returned.
     * The maximum value is 1000; values above 1000 will be coerced to 1000.
     *
     * Generated from protobuf field <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Optional. The maximum number of policy bindings to return. The service may
     * return fewer than this value.
     * If unspecified, at most 50 policy bindings will be returned.
     * The maximum value is 1000; values above 1000 will be coerced to 1000.
     *
     * Generated from protobuf field <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * Optional. A page token, received from a previous
     * `SearchTargetPolicyBindingsRequest` call. Provide this to retrieve the
     * subsequent page.
     * When paginating, all other parameters provided to
     * `SearchTargetPolicyBindingsRequest` must match the call that provided the
     * page token.
     *
     * Generated from protobuf field <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * Optional. A page token, received from a previous
     * `SearchTargetPolicyBindingsRequest` call. Provide this to retrieve the
     * subsequent page.
     * When paginating, all other parameters provided to
     * `SearchTargetPolicyBindingsRequest` must match the call that provided the
     * page token.
     *
     * Generated from protobuf field <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * Required. The parent resource where this search will be performed. This
     * should be the nearest Resource Manager resource (project, folder, or
     * organization) to the target.
     * Format:
     * * `projects/{project_id}/locations/{location}`
     * * `projects/{project_number}/locations/{location}`
     * * `folders/{folder_id}/locations/{location}`
     * * `organizations/{organization_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource where this search will be performed. This
     * should be the nearest Resource Manager resource (project, folder, or
     * organization) to the target.
     * Format:
     * * `projects/{project_id}/locations/{location}`
     * * `projects/{project_number}/locations/{location}`
     * * `folders/{folder_id}/locations/{location}`
     * * `organizations/{organization_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

}

